"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetOrganizationRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetOrganizationRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetOrganizationNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetOrganizationNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetOrganizationNotFoundLinksTypedDict(TypedDict):
    documentation: GetOrganizationNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetOrganizationNotFoundLinks(BaseModel):
    documentation: GetOrganizationNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetOrganizationHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetOrganizationNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetOrganizationHalJSONError(ClientError):
    r"""An error response object."""

    data: GetOrganizationHalJSONErrorData

    def __init__(
        self,
        data: GetOrganizationHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetOrganizationLocale(str, Enum):
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class GetOrganizationAddressTypedDict(TypedDict):
    r"""The address of the organization."""

    street_and_number: NotRequired[str]
    r"""A street and street number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    city: NotRequired[str]
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class GetOrganizationAddress(BaseModel):
    r"""The address of the organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    city: Optional[str] = None

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class GetOrganizationVatRegulation(str, Enum):
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United
    Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.
    """

    DUTCH = "dutch"
    BRITISH = "british"
    SHIFTED = "shifted"


class GetOrganizationSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOrganizationSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOrganizationDashboardTypedDict(TypedDict):
    r"""Direct link to the organization's Mollie dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOrganizationDashboard(BaseModel):
    r"""Direct link to the organization's Mollie dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOrganizationDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOrganizationDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOrganizationLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetOrganizationSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetOrganizationDashboardTypedDict]
    r"""Direct link to the organization's Mollie dashboard."""
    documentation: NotRequired[GetOrganizationDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetOrganizationLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetOrganizationSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetOrganizationDashboard] = None
    r"""Direct link to the organization's Mollie dashboard."""

    documentation: Optional[GetOrganizationDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetOrganizationResponseTypedDict(TypedDict):
    r"""The organization object."""

    resource: NotRequired[str]
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this
    resource type.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""
    name: NotRequired[str]
    r"""The name of the organization."""
    email: NotRequired[str]
    r"""The email address associated with the organization."""
    locale: NotRequired[GetOrganizationLocale]
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""
    address: NotRequired[GetOrganizationAddressTypedDict]
    r"""The address of the organization."""
    registration_number: NotRequired[str]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are
    verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """
    vat_regulation: NotRequired[Nullable[GetOrganizationVatRegulation]]
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United
    Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.
    """
    links: NotRequired[GetOrganizationLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetOrganizationResponse(BaseModel):
    r"""The organization object."""

    resource: Optional[str] = "organization"
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this
    resource type.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""

    name: Optional[str] = None
    r"""The name of the organization."""

    email: Optional[str] = None
    r"""The email address associated with the organization."""

    locale: Optional[GetOrganizationLocale] = None
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""

    address: Optional[GetOrganizationAddress] = None
    r"""The address of the organization."""

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are
    verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """

    vat_regulation: Annotated[
        OptionalNullable[GetOrganizationVatRegulation],
        pydantic.Field(alias="vatRegulation"),
    ] = UNSET
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United
    Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.
    """

    links: Annotated[Optional[GetOrganizationLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "name",
            "email",
            "locale",
            "address",
            "registrationNumber",
            "vatNumber",
            "vatRegulation",
            "_links",
        ]
        nullable_fields = ["vatNumber", "vatRegulation"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
