#!/usr/bin/env python3
# coding: utf-8
# Copyright 2019 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""__init__"""
from __future__ import absolute_import as _abs

from .add import TensorAdd
from .addn import AddN
from .apply_momentum import ApplyMomentum
from .bias_add_grad import BiasAddGrad
from .cast import Cast
from .conv import Conv2D
from .conv_backprop_input import Conv2DBackpropInput
from .conv_backprop_filter import Conv2DBackpropFilter
from .five2four import Five2Four
from .four2five import Four2Five
from .fused_batch_norm import FusedBatchNorm
from .fused_batchnorm_infer import FusedBatchNormInfer
from .fused_batch_norm_grad import FusedBatchNormGrad
from .matmul import MatMul
from .batchmatmul import BatchMatMul
from .mean import SimpleMean
from .mean_grad import SimpleMeanGrad
from .mul import Mul
from .relu import ReLU
from .relu_grad import ReluGrad
from .sparse_softmax_cross_entropy_with_logits import SparseSoftmaxCrossEntropyWithLogits
from .reshape import Reshape
from .assign_add import AssignAdd
from .less import Less
from .equal_count import EqualCount
from .gather_v2 import GatherV2
from .max_pool_with_argmax import MaxPoolWithArgmax
from .max_pool_grad_with_arg_max import MaxPoolGradWithArgmax

from .softmax import Softmax
from .argmax import Argmax
from .conv_bn1 import ConvBN1
from .bias_add import BiasAdd
from .clear_zero import ClearZero

from .fused_bn1 import FusedBN1
from .fused_bn2 import FusedBN2
from .fused_bn3 import FusedBN3
from .fused_bn_grad1 import BNGrad1
from .fused_bn_grad2 import BNGrad2
from .fused_bn_grad3 import BNGrad3

from .div import Div
from .equal import Equal
from .exp import Exp
from .log import Log
from .max import Max
from .neg import Neg
from .one_hot import OneHot
from .realdiv import RealDiv
from .reciprocal import Reciprocal
from .reduce_mean import ReduceMean
from .strided_slice import StridedSlice
from .sub import Sub
from .sum import Sum
from .tile import Tile
from .zeros_like import ZerosLike
from .floordiv import FloorDiv
