# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

"""ReluGradV2 op"""
from mindspore.ops.op_info_register import op_info_register, TBERegOp, DataType

relu_grad_v2_op_info = TBERegOp("ReluGradV2") \
    .fusion_type("ELEMWISE") \
    .async_flag(False) \
    .binfile_name("relu_grad_v2.so") \
    .compute_cost(10) \
    .kernel_name("relu_grad_v2") \
    .partial_flag(True) \
    .input(0, "gradients", False, "required", "all") \
    .input(1, "mask", False, "required", "all") \
    .output(0, "backprops", True, "required", "all") \
    .dtype_format(DataType.F16_5HD, DataType.U8_Default, DataType.F16_5HD) \
    .dtype_format(DataType.F32_5HD, DataType.U8_Default, DataType.F32_5HD) \
    .dtype_format(DataType.I32_5HD, DataType.U8_Default, DataType.I32_5HD) \
    .dtype_format(DataType.I8_5HD, DataType.U8_Default, DataType.I8_5HD) \
    .dtype_format(DataType.U8_5HD, DataType.U8_Default, DataType.U8_5HD) \
    .get_op_info()


@op_info_register(relu_grad_v2_op_info)
def _relu_grad_v2_tbe():
    """ReluGradV2 TBE register"""
    return
