# Generated by Django 3.0 on 2021-05-06 20:30

import django.db.models.deletion
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):

    dependencies = [
        ('tesla_ce', '0012_auto_20210415_1829'),
    ]

    operations = [
        migrations.CreateModel(
            name='WebhookClient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name that identifies the client.', max_length=250, unique=True)),
                ('client_header', models.CharField(help_text='Name of the request header used to identify the client.', max_length=250, unique=True)),
                ('id_header', models.CharField(default=None, help_text='Name of the request header used to get the message id.', max_length=250, null=True)),
                ('description', models.TextField(blank=True, help_text='Client description.', null=True)),
                ('implementation', models.CharField(blank=True, help_text='Webhook implementation class.', max_length=255)),
                ('enabled', models.BooleanField(blank=None, default=False, help_text='Whether this client is enabled or not', null=None)),
                ('credentials', models.TextField(help_text='Client authentication credentials.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='WebhookMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Created'), (1, 'Processing'), (2, 'Processed'), (3, 'Error'), (4, 'Timeout')], default=0, help_text='Status for this request')),
                ('message_id', models.CharField(help_text='Message Id.', max_length=250)),
                ('error', models.TextField(blank=True, help_text='Error message.', null=True)),
                ('body', models.TextField(help_text='Webhook message body.')),
                ('start_process_at', models.DateTimeField(default=None, help_text='When the webhook started to be processed', null=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('client', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.WebhookClient')),
            ],
            options={
                'unique_together': {('client', 'message_id')},
            },
        ),
    ]
