import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkPacketCaptureConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#maximum_bytes_per_packet NetworkPacketCapture#maximum_bytes_per_packet}.
     *
     * @stability stable
     */
    readonly maximumBytesPerPacket?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#maximum_bytes_per_session NetworkPacketCapture#maximum_bytes_per_session}.
     *
     * @stability stable
     */
    readonly maximumBytesPerSession?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#maximum_capture_duration NetworkPacketCapture#maximum_capture_duration}.
     *
     * @stability stable
     */
    readonly maximumCaptureDuration?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#name NetworkPacketCapture#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#network_watcher_name NetworkPacketCapture#network_watcher_name}.
     *
     * @stability stable
     */
    readonly networkWatcherName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#resource_group_name NetworkPacketCapture#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#target_resource_id NetworkPacketCapture#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#filter NetworkPacketCapture#filter}
     *
     * @stability stable
     */
    readonly filter?: NetworkPacketCaptureFilter[];
    /**
     * storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#storage_location NetworkPacketCapture#storage_location}
     *
     * @stability stable
     */
    readonly storageLocation: NetworkPacketCaptureStorageLocation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#timeouts NetworkPacketCapture#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkPacketCaptureTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkPacketCaptureFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#local_ip_address NetworkPacketCapture#local_ip_address}.
     *
     * @stability stable
     */
    readonly localIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#local_port NetworkPacketCapture#local_port}.
     *
     * @stability stable
     */
    readonly localPort?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#protocol NetworkPacketCapture#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#remote_ip_address NetworkPacketCapture#remote_ip_address}.
     *
     * @stability stable
     */
    readonly remoteIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#remote_port NetworkPacketCapture#remote_port}.
     *
     * @stability stable
     */
    readonly remotePort?: string;
}
export declare function networkPacketCaptureFilterToTerraform(struct?: NetworkPacketCaptureFilter): any;
/**
 * @stability stable
 */
export interface NetworkPacketCaptureStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#file_path NetworkPacketCapture#file_path}.
     *
     * @stability stable
     */
    readonly filePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#storage_account_id NetworkPacketCapture#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
}
export declare function networkPacketCaptureStorageLocationToTerraform(struct?: NetworkPacketCaptureStorageLocationOutputReference | NetworkPacketCaptureStorageLocation): any;
/**
 * @stability stable
 */
export declare class NetworkPacketCaptureStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkPacketCaptureStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkPacketCaptureStorageLocation | undefined);
    private _filePath?;
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    set filePath(value: string);
    /**
     * @stability stable
     */
    resetFilePath(): void;
    /**
     * @stability stable
     */
    get filePathInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkPacketCaptureTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#create NetworkPacketCapture#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#delete NetworkPacketCapture#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#read NetworkPacketCapture#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html#update NetworkPacketCapture#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkPacketCaptureTimeoutsToTerraform(struct?: NetworkPacketCaptureTimeoutsOutputReference | NetworkPacketCaptureTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkPacketCaptureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkPacketCaptureTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkPacketCaptureTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html azurerm_network_packet_capture}.
 *
 * @stability stable
 */
export declare class NetworkPacketCapture extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_packet_capture.html azurerm_network_packet_capture} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkPacketCaptureConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _maximumBytesPerPacket?;
    /**
     * @stability stable
     */
    get maximumBytesPerPacket(): number;
    /**
     * @stability stable
     */
    set maximumBytesPerPacket(value: number);
    /**
     * @stability stable
     */
    resetMaximumBytesPerPacket(): void;
    /**
     * @stability stable
     */
    get maximumBytesPerPacketInput(): number | undefined;
    private _maximumBytesPerSession?;
    /**
     * @stability stable
     */
    get maximumBytesPerSession(): number;
    /**
     * @stability stable
     */
    set maximumBytesPerSession(value: number);
    /**
     * @stability stable
     */
    resetMaximumBytesPerSession(): void;
    /**
     * @stability stable
     */
    get maximumBytesPerSessionInput(): number | undefined;
    private _maximumCaptureDuration?;
    /**
     * @stability stable
     */
    get maximumCaptureDuration(): number;
    /**
     * @stability stable
     */
    set maximumCaptureDuration(value: number);
    /**
     * @stability stable
     */
    resetMaximumCaptureDuration(): void;
    /**
     * @stability stable
     */
    get maximumCaptureDurationInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkWatcherName?;
    /**
     * @stability stable
     */
    get networkWatcherName(): string;
    /**
     * @stability stable
     */
    set networkWatcherName(value: string);
    /**
     * @stability stable
     */
    get networkWatcherNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): NetworkPacketCaptureFilter[];
    /**
     * @stability stable
     */
    set filter(value: NetworkPacketCaptureFilter[]);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): NetworkPacketCaptureFilter[] | undefined;
    private _storageLocation;
    /**
     * @stability stable
     */
    get storageLocation(): NetworkPacketCaptureStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putStorageLocation(value: NetworkPacketCaptureStorageLocation): void;
    /**
     * @stability stable
     */
    get storageLocationInput(): NetworkPacketCaptureStorageLocation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkPacketCaptureTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkPacketCaptureTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkPacketCaptureTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
