BEGIN;

---
--- Originally from Elisabeth Fritze (SBO part), Modified by Gwendolyn O. Gusak (Media part)
---

DROP TABLE IF EXISTS bigg_to_sbo;
DROP TABLE IF EXISTS ec_to_sbo;
DROP TABLE IF EXISTS media;
DROP TABLE IF EXISTS media_compositions;

--
-- Name: bigg_to_sbo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE bigg_to_sbo (
	bigg_reactionid text NOT NULL,
	sbo_term character(11),
	PRIMARY KEY (BiGG_reactionID)
);


--
-- Name: ec_to_sbo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE ec_to_sbo (
	ecnum text NOT NULL,
	sbo_term character(11),
	PRIMARY KEY (ECnum)
);


--
-- Name: media; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE media (
	id INTEGER PRIMARY KEY,
	medium TEXT NOT NULL,
	medium_description TEXT
);


--
-- Name: media_compositions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE media_compositions (
	substance_id INTEGER PRIMARY KEY,
	BiGG TEXT,
	substance TEXT,
	medium_id INTEGER,
	FOREIGN KEY(medium_id) REFERENCES media(id)
);


--
-- Data for Name: bigg_to_sbo; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO bigg_to_sbo VALUES
	('R_ATPM', 'SBO:0000630'),
	('R_23CAMPtex', 'SBO:0000658'),
	('R_23CCMPtex', 'SBO:0000658'),
	('R_23CGMPtex', 'SBO:0000658'),
	('R_23CUMPtex', 'SBO:0000658'),
	('R_23PDE2pp', 'SBO:0000376'),
	('R_23PDE4pp', 'SBO:0000376'),
	('R_23PDE7pp', 'SBO:0000376'),
	('R_23PDE9pp', 'SBO:0000376'),
	('R_2AGPA160tipp', 'SBO:0000658'),
	('R_2AGPE120tipp', 'SBO:0000658'),
	('R_2AGPE140tipp', 'SBO:0000658'),
	('R_2AGPE160tipp', 'SBO:0000658'),
	('R_2AGPE161tipp', 'SBO:0000658'),
	('R_2AGPE180tipp', 'SBO:0000658'),
	('R_2AGPE181tipp', 'SBO:0000658'),
	('R_2AGPG160tipp', 'SBO:0000658'),
	('R_2DGLCNRx', 'SBO:0000200'),
	('R_2DGLCNRy', 'SBO:0000200'),
	('R_2DHGLCNkt_tpp', 'SBO:0000659'),
	('R_2DHGLCNtex', 'SBO:0000658'),
	('R_2PGLYCt6', 'SBO:0000659'),
	('R_3HAD161', 'SBO:0000178'),
	('R_3HAD181', 'SBO:0000178'),
	('R_3HAD40', 'SBO:0000178'),
	('R_3NTD2pp', 'SBO:0000376'),
	('R_3NTD4pp', 'SBO:0000376'),
	('R_3NTD7pp', 'SBO:0000376'),
	('R_3NTD9pp', 'SBO:0000376'),
	('R_3OAR100', 'SBO:0000200'),
	('R_3OAR120', 'SBO:0000200'),
	('R_3OAR161', 'SBO:0000200'),
	('R_3OAR181', 'SBO:0000200'),
	('R_3OAR40', 'SBO:0000200'),
	('R_3OAR60', 'SBO:0000200'),
	('R_3OAR80', 'SBO:0000200'),
	('R_3OAS100', 'SBO:0000402'),
	('R_3OAS120', 'SBO:0000402'),
	('R_3OAS161', 'SBO:0000402'),
	('R_3OAS181', 'SBO:0000402'),
	('R_3OAS60', 'SBO:0000402'),
	('R_3OAS80', 'SBO:0000402'),
	('R_3PEPTabcpp', 'SBO:0000657'),
	('R_4HOXPACMOF', 'SBO:0000200'),
	('R_4HOXPACt2pp', 'SBO:0000659'),
	('R_4OD', 'SBO:0000399'),
	('R_4OT', 'SBO:0000377'),
	('R_4PEPTabcpp', 'SBO:0000657'),
	('R_ABTA', 'SBO:0000403'),
	('R_ABTt_1', 'SBO:0000658'),
	('R_ACACT1r', 'SBO:0000215'),
	('R_ACACT3r', 'SBO:0000215'),
	('R_ACACT5r', 'SBO:0000215'),
	('R_ACALD', 'SBO:0000200'),
	('R_ACALDt', 'SBO:0000658'),
	('R_ACGApts', 'SBO:0000657'),
	('R_ACGK', 'SBO:0000216'),
	('R_ACGS', 'SBO:0000215'),
	('R_ACHBS', 'SBO:0000402'),
	('R_ACKr', 'SBO:0000216'),
	('R_ACLDC', 'SBO:0000399'),
	('R_ACLS', 'SBO:0000402'),
	('R_ACM6PH', 'SBO:0000178'),
	('R_ACMUMptspp', 'SBO:0000657'),
	('R_ACMUMtex', 'SBO:0000658'),
	('R_ACOAD1', 'SBO:0000200'),
	('R_ACOAD1f', 'SBO:0000200'),
	('R_ACOAD2', 'SBO:0000200'),
	('R_ACOAD2f', 'SBO:0000200'),
	('R_ACOAD5f', 'SBO:0000200'),
	('R_ACONT', 'SBO:0000178'),
	('R_ACOTA', 'SBO:0000403'),
	('R_ACTD', 'SBO:0000200'),
	('R_ACTD2', 'SBO:0000200'),
	('R_ACTDa', 'SBO:0000200'),
	('R_ACTNabc', 'SBO:0000657'),
	('R_ACTNabc1', 'SBO:0000657'),
	('R_ACYP_2', 'SBO:0000376'),
	('R_ADADir', 'SBO:0000216'),
	('R_ADCL', 'SBO:0000178'),
	('R_ADCS', 'SBO:0000403'),
	('R_ADK1', 'SBO:0000216'),
	('R_ADKd', 'SBO:0000216'),
	('R_ADNK1', 'SBO:0000216'),
	('R_ADNtex', 'SBO:0000658'),
	('R_ADPT', 'SBO:0000217'),
	('R_ADSK', 'SBO:0000216'),
	('R_ADSL1r', 'SBO:0000178'),
	('R_ADSL2r', 'SBO:0000178'),
	('R_AGDC', 'SBO:0000376'),
	('R_AGMT', 'SBO:0000376'),
	('R_AGPAT120', 'SBO:0000402'),
	('R_AGPAT160', 'SBO:0000402'),
	('R_AGPAT161', 'SBO:0000402'),
	('R_AGPAT180', 'SBO:0000402'),
	('R_AGPAT181', 'SBO:0000402'),
	('R_AGPR', 'SBO:0000200'),
	('R_AHCYSNS', 'SBO:0000376'),
	('R_AHSERL2', 'SBO:0000402'),
	('R_AICART', 'SBO:0000402'),
	('R_AIRC3', 'SBO:0000377'),
	('R_AKGDa', 'SBO:0000200'),
	('R_AKGDb', 'SBO:0000402'),
	('R_AKGDH', 'SBO:0000399'),
	('R_AKGMAL', 'SBO:0000660'),
	('R_AKP1', 'SBO:0000376'),
	('R_ALAabc', 'SBO:0000657'),
	('R_ALAALAabcpp', 'SBO:0000657'),
	('R_ALAD_L', 'SBO:0000200'),
	('R_ALAGLUE', 'SBO:0000377'),
	('R_ALAR', 'SBO:0000377'),
	('R_ALAt2pp', 'SBO:0000659'),
	('R_ALAt2r', 'SBO:0000659'),
	('R_ALATA_D', 'SBO:0000403'),
	('R_ALAtex', 'SBO:0000658'),
	('R_ALCD1', 'SBO:0000200'),
	('R_ALCD19y', 'SBO:0000200'),
	('R_ALCD2x', 'SBO:0000200'),
	('R_ALCD2y', 'SBO:0000200'),
	('R_ALDD2x', 'SBO:0000200'),
	('R_ALLTNt2r', 'SBO:0000659'),
	('R_ALR2', 'SBO:0000200'),
	('R_ALR3', 'SBO:0000200'),
	('R_AMANAPEr', 'SBO:0000377'),
	('R_AMANK', 'SBO:0000216'),
	('R_AMMQLT8', 'SBO:0000214'),
	('R_AMPMS2', 'SBO:0000200'),
	('R_ANHGMtex', 'SBO:0000658'),
	('R_ANPRT', 'SBO:0000217'),
	('R_ANS', 'SBO:0000178'),
	('R_APRAUR', 'SBO:0000200'),
	('R_APSR', 'SBO:0000200'),
	('R_ARABDI', 'SBO:0000377'),
	('R_ARABRr', 'SBO:0000200'),
	('R_ARBabc', 'SBO:0000657'),
	('R_ARBt2r', 'SBO:0000659'),
	('R_ARBt3ipp', 'SBO:0000660'),
	('R_ARBtex', 'SBO:0000658'),
	('R_ARGabc', 'SBO:0000657'),
	('R_ARGabcpp', 'SBO:0000657'),
	('R_ARGDC', 'SBO:0000399'),
	('R_ARGDr', 'SBO:0000401'),
	('R_ARGORNt7', 'SBO:0000660'),
	('R_ARGSL', 'SBO:0000178'),
	('R_ARGt2r', 'SBO:0000659'),
	('R_ARGtex', 'SBO:0000658'),
	('R_ASAD', 'SBO:0000200'),
	('R_ASNN', 'SBO:0000401'),
	('R_ASP1DC', 'SBO:0000399'),
	('R_ASPCT', 'SBO:0000402'),
	('R_ASPK', 'SBO:0000216'),
	('R_ASPt2_3', 'SBO:0000659'),
	('R_ASPTA', 'SBO:0000403'),
	('R_ATPHs', 'SBO:0000401'),
	('R_ATPPRT', 'SBO:0000217'),
	('R_BALAt2pp', 'SBO:0000659'),
	('R_BALAtex', 'SBO:0000658'),
	('R_BETALDHx', 'SBO:0000200'),
	('R_BETALDHy', 'SBO:0000200'),
	('R_BTDD_RR', 'SBO:0000200'),
	('R_BTS3r', 'SBO:0000402'),
	('R_C100SN', 'SBO:0000399'),
	('R_CADVt', 'SBO:0000660'),
	('R_CAT23DOX', 'SBO:0000200'),
	('R_CAt4', 'SBO:0000660'),
	('R_CATECHOLtex', 'SBO:0000658'),
	('R_CATECHOLtpp', 'SBO:0000658'),
	('R_CBMKr', 'SBO:0000216'),
	('R_CD2abc1', 'SBO:0000657'),
	('R_CD2t3pp', 'SBO:0000660'),
	('R_CD2t4', 'SBO:0000660'),
	('R_CD2t4pp', 'SBO:0000660'),
	('R_CD2tex', 'SBO:0000658'),
	('R_CD2tpp', 'SBO:0000658'),
	('R_CDPMEK', 'SBO:0000216'),
	('R_CELBpts', 'SBO:0000657'),
	('R_CGLYabcpp', 'SBO:0000657'),
	('R_CHLabc', 'SBO:0000657'),
	('R_CHLabcpp', 'SBO:0000657'),
	('R_CHLt2', 'SBO:0000659'),
	('R_CHLtex', 'SBO:0000658'),
	('R_CHOLD', 'SBO:0000200'),
	('R_CHORM', 'SBO:0000377'),
	('R_CHORS', 'SBO:0000178'),
	('R_CLt3r_2', 'SBO:0000660'),
	('R_CMCMSAD', 'SBO:0000200'),
	('R_CO2t', 'SBO:0000658'),
	('R_COabc', 'SBO:0000657'),
	('R_COBALT2t3pp', 'SBO:0000660'),
	('R_COBALT2tpp', 'SBO:0000658'),
	('R_COBALTt4pp', 'SBO:0000660'),
	('R_CPMPS', 'SBO:0000178'),
	('R_CPPPGO', 'SBO:0000200'),
	('R_CRNabc', 'SBO:0000657'),
	('R_CRNt2rpp', 'SBO:0000659'),
	('R_CRNt7pp', 'SBO:0000660'),
	('R_CRNtex', 'SBO:0000658'),
	('R_CRO4abcpp', 'SBO:0000657'),
	('R_CRO4t3pp', 'SBO:0000660'),
	('R_CU1Opp', 'SBO:0000200'),
	('R_CU2tpp', 'SBO:0000658'),
	('R_Cut1', 'SBO:0000657'),
	('R_CUtex', 'SBO:0000658'),
	('R_CYSabc2pp', 'SBO:0000657'),
	('R_CYSabcpp', 'SBO:0000657'),
	('R_CYSTL', 'SBO:0000178'),
	('R_CYTD', 'SBO:0000401'),
	('R_CYTDK2', 'SBO:0000216'),
	('R_CYTDt4', 'SBO:0000659'),
	('R_CYTDtex', 'SBO:0000658'),
	('R_CYTK1', 'SBO:0000216'),
	('R_CYTK2', 'SBO:0000216'),
	('R_CYTOM', 'SBO:0000214'),
	('R_DACTt3', 'SBO:0000660'),
	('R_DADK', 'SBO:0000216'),
	('R_DADNK', 'SBO:0000216'),
	('R_DALAOX', 'SBO:0000401'),
	('R_DALAt2pp', 'SBO:0000659'),
	('R_DALAt2r', 'SBO:0000659'),
	('R_DAPDC', 'SBO:0000399'),
	('R_DAPE', 'SBO:0000377'),
	('R_DARBabcpp', 'SBO:0000657'),
	('R_DARBt3ipp', 'SBO:0000660'),
	('R_DASYN120', 'SBO:0000402'),
	('R_DASYN160', 'SBO:0000402'),
	('R_DASYN161', 'SBO:0000402'),
	('R_DASYN180', 'SBO:0000402'),
	('R_DASYN181', 'SBO:0000402'),
	('R_DATPHs', 'SBO:0000401'),
	('R_DB4PS', 'SBO:0000178'),
	('R_DCMPDA', 'SBO:0000401'),
	('R_DDPA', 'SBO:0000402'),
	('R_DGK1', 'SBO:0000216'),
	('R_DGNSK', 'SBO:0000216'),
	('R_DHAD1', 'SBO:0000178'),
	('R_DHAD2', 'SBO:0000178'),
	('R_DHAK', 'SBO:0000216'),
	('R_DHAPT', 'SBO:0000216'),
	('R_DHBSr', 'SBO:0000402'),
	('R_DHDPRy', 'SBO:0000200'),
	('R_DHFR', 'SBO:0000200'),
	('R_DHNAOT', 'SBO:0000399'),
	('R_DHNPA2r', 'SBO:0000178'),
	('R_DHORTS', 'SBO:0000376'),
	('R_DHPDO', 'SBO:0000200'),
	('R_DHPPDA', 'SBO:0000401'),
	('R_DHPS2', 'SBO:0000402'),
	('R_DHQS', 'SBO:0000178'),
	('R_DHQTi', 'SBO:0000178'),
	('R_DINSK', 'SBO:0000216'),
	('R_DIPEPabc15', 'SBO:0000657'),
	('R_DMATT', 'SBO:0000402'),
	('R_DMPPS', 'SBO:0000200'),
	('R_DNMPPA', 'SBO:0000376'),
	('R_DNTPPA', 'SBO:0000376'),
	('R_DPCOAK', 'SBO:0000216'),
	('R_DPMVD', 'SBO:0000399'),
	('R_DPPS', 'SBO:0000402'),
	('R_DPR', 'SBO:0000200'),
	('R_DRBK', 'SBO:0000216'),
	('R_DRIBabc', 'SBO:0000657'),
	('R_DRPA', 'SBO:0000178'),
	('R_DSERDHr', 'SBO:0000200'),
	('R_DSERt2', 'SBO:0000659'),
	('R_DSERt2pp', 'SBO:0000659'),
	('R_DSERtex', 'SBO:0000658'),
	('R_DTMPK', 'SBO:0000216'),
	('R_DURIK1', 'SBO:0000216'),
	('R_DURIPP', 'SBO:0000216'),
	('R_DXPRIi', 'SBO:0000200'),
	('R_DXPS', 'SBO:0000402'),
	('R_EAR100x', 'SBO:0000402'),
	('R_EAR120x', 'SBO:0000402'),
	('R_EAR140y', 'SBO:0000402'),
	('R_EAR160x', 'SBO:0000200'),
	('R_EAR161x', 'SBO:0000200'),
	('R_EAR180y', 'SBO:0000200'),
	('R_EAR181x', 'SBO:0000200'),
	('R_EAR40x', 'SBO:0000402'),
	('R_EAR60x', 'SBO:0000402'),
	('R_EAR80x', 'SBO:0000402'),
	('R_ENO', 'SBO:0000178'),
	('R_ETHAAL', 'SBO:0000178'),
	('R_ETHAt', 'SBO:0000658'),
	('R_ETHSabc', 'SBO:0000657'),
	('R_F6Pt6_2pp', 'SBO:0000660'),
	('R_F6Ptex', 'SBO:0000658'),
	('R_FA80ACPHi', 'SBO:0000376'),
	('R_FACOAE100', 'SBO:0000376'),
	('R_FACOAE140', 'SBO:0000376'),
	('R_FACOAL120t2pp', 'SBO:0000657'),
	('R_FACOAL161t2pp', 'SBO:0000657'),
	('R_FALDH2', 'SBO:0000200'),
	('R_FALGTHLs', 'SBO:0000178'),
	('R_FAO10', 'SBO:0000200'),
	('R_FAO11', 'SBO:0000200'),
	('R_FAO3', 'SBO:0000200'),
	('R_FAS80_L', 'SBO:0000402'),
	('R_FASC120ACP', 'SBO:0000399'),
	('R_FASC140ACP', 'SBO:0000399'),
	('R_FASC141ACP', 'SBO:0000399'),
	('R_FASC160ACP', 'SBO:0000399'),
	('R_FASC161ACP', 'SBO:0000399'),
	('R_FASC180ACP', 'SBO:0000399'),
	('R_FASC181ACP', 'SBO:0000399'),
	('R_FBA', 'SBO:0000178'),
	('R_FBP', 'SBO:0000376'),
	('R_FCLT', 'SBO:0000178'),
	('R_FDH', 'SBO:0000200'),
	('R_FE2abc', 'SBO:0000657'),
	('R_FE2abcpp', 'SBO:0000657'),
	('R_FE2t4pp', 'SBO:0000660'),
	('R_FE2tpp', 'SBO:0000658'),
	('R_FE3abc', 'SBO:0000657'),
	('R_FE3abcpp', 'SBO:0000657'),
	('R_FEDCabc', 'SBO:0000657'),
	('R_FEENTERtex', 'SBO:0000654'),
	('R_FEENTERtpp', 'SBO:0000660'),
	('R_FERIRDe', 'SBO:0000660'),
	('R_FEROpp', 'SBO:0000200'),
	('R_FEROXEFEabcpp', 'SBO:0000657'),
	('R_FEROXEFEtex', 'SBO:0000658'),
	('R_FEROXEtex', 'SBO:0000658'),
	('R_FEROXEtpp', 'SBO:0000658'),
	('R_FFSD', 'SBO:0000376'),
	('R_FLDO', 'SBO:0000200'),
	('R_FLVR', 'SBO:0000200'),
	('R_FLVRx', 'SBO:0000200'),
	('R_FMNAT', 'SBO:0000402'),
	('R_FMNRx', 'SBO:0000200'),
	('R_FMNRy', 'SBO:0000200'),
	('R_FORt2', 'SBO:0000659'),
	('R_FORt3', 'SBO:0000660'),
	('R_FRD3', 'SBO:0000200'),
	('R_FRDO', 'SBO:0000200'),
	('R_FRUK', 'SBO:0000216'),
	('R_FRUpts', 'SBO:0000657'),
	('R_FRUptspp', 'SBO:0000657'),
	('R_FRUtex', 'SBO:0000658'),
	('R_FUM', 'SBO:0000178'),
	('R_FUMt2_3', 'SBO:0000659'),
	('R_FUMt2_3pp', 'SBO:0000659'),
	('R_G1SAT', 'SBO:0000377'),
	('R_G3PAT120', 'SBO:0000402'),
	('R_G3PAT160', 'SBO:0000402'),
	('R_G3PAT161', 'SBO:0000402'),
	('R_G3PAT180', 'SBO:0000402'),
	('R_G3PAT181', 'SBO:0000402'),
	('R_G3PD2', 'SBO:0000200'),
	('R_G3PD7', 'SBO:0000200'),
	('R_G3PT', 'SBO:0000376'),
	('R_G6PDA', 'SBO:0000401'),
	('R_G6PDH2r', 'SBO:0000200'),
	('R_G6Pt6_2', 'SBO:0000660'),
	('R_G6Pt6_2pp', 'SBO:0000660'),
	('R_G6Ptex', 'SBO:0000658'),
	('R_GALCTt2r', 'SBO:0000659'),
	('R_GALCTt2rpp', 'SBO:0000659'),
	('R_GALCTtex', 'SBO:0000658'),
	('R_GALTpts', 'SBO:0000657'),
	('R_GALURt2r', 'SBO:0000659'),
	('R_GAM6Pt6_2pp', 'SBO:0000660'),
	('R_GAMAN6Ptex', 'SBO:0000658'),
	('R_GAMpts', 'SBO:0000657'),
	('R_GAPD', 'SBO:0000200'),
	('R_GARFT', 'SBO:0000402'),
	('R_GBBTNabc', 'SBO:0000657'),
	('R_GBBTNtex', 'SBO:0000658'),
	('R_GCALDD', 'SBO:0000200'),
	('R_GCCa', 'SBO:0000200'),
	('R_GCCb', 'SBO:0000402'),
	('R_GCCc', 'SBO:0000200'),
	('R_GDPTPDP', 'SBO:0000376'),
	('R_GF6PTA', 'SBO:0000403'),
	('R_GHMT2r', 'SBO:0000402'),
	('R_GK1', 'SBO:0000216'),
	('R_GLCabcpp', 'SBO:0000657'),
	('R_GLCNt2r', 'SBO:0000659'),
	('R_GLCP', 'SBO:0000216'),
	('R_GLCpts', 'SBO:0000657'),
	('R_GLCRt2r', 'SBO:0000659'),
	('R_GLCRt2rpp', 'SBO:0000659'),
	('R_GLCRtex', 'SBO:0000658'),
	('R_GLCS1', 'SBO:0000217'),
	('R_GLCtex', 'SBO:0000658'),
	('R_GLCURt2r', 'SBO:0000659'),
	('R_GLGC', 'SBO:0000402'),
	('R_GLNabc', 'SBO:0000657'),
	('R_GLTPD', 'SBO:0000200'),
	('R_GLUabc', 'SBO:0000657'),
	('R_GLUabcpp', 'SBO:0000657'),
	('R_GLUABUTt7', 'SBO:0000660'),
	('R_GLUDxi', 'SBO:0000401'),
	('R_GLUPRT', 'SBO:0000217'),
	('R_GLUR', 'SBO:0000377'),
	('R_GLUSx', 'SBO:0000200'),
	('R_GLUt2r', 'SBO:0000659'),
	('R_GLUt4', 'SBO:0000659'),
	('R_GLUTRR', 'SBO:0000200'),
	('R_GLYabc', 'SBO:0000657'),
	('R_GLYabcpp', 'SBO:0000657'),
	('R_GLYALDt', 'SBO:0000658'),
	('R_GLYBabc', 'SBO:0000657'),
	('R_GLYBt2r', 'SBO:0000659'),
	('R_GLYC3Pabc', 'SBO:0000657'),
	('R_GLYC3Pt6', 'SBO:0000660'),
	('R_GLYCDx', 'SBO:0000200'),
	('R_GLYCK', 'SBO:0000216'),
	('R_GLYCLTDx', 'SBO:0000200'),
	('R_GLYCLTDy', 'SBO:0000200'),
	('R_GLYCLTt2r', 'SBO:0000659'),
	('R_GLYCt', 'SBO:0000658'),
	('R_GLYK', 'SBO:0000216'),
	('R_GLYO1', 'SBO:0000401'),
	('R_GLYt2pp', 'SBO:0000659'),
	('R_GLYt2r', 'SBO:0000659'),
	('R_GLYtex', 'SBO:0000658'),
	('R_GMPR', 'SBO:0000200'),
	('R_GND', 'SBO:0000399'),
	('R_GNK', 'SBO:0000216'),
	('R_GPDDA4', 'SBO:0000376'),
	('R_GRTT', 'SBO:0000402'),
	('R_GSNtex', 'SBO:0000658'),
	('R_GTHOr', 'SBO:0000200'),
	('R_GTHPi', 'SBO:0000200'),
	('R_GTHRDabc2pp', 'SBO:0000657'),
	('R_GTHRDabcpp', 'SBO:0000657'),
	('R_GTHRDtex', 'SBO:0000658'),
	('R_GTPCI', 'SBO:0000376'),
	('R_GTPDPK', 'SBO:0000402'),
	('R_GTPHs', 'SBO:0000401'),
	('R_GUAPRT', 'SBO:0000217'),
	('R_GUAt2r', 'SBO:0000659'),
	('R_H2Ot', 'SBO:0000658'),
	('R_H2Otex', 'SBO:0000658'),
	('R_H2Otpp', 'SBO:0000658'),
	('R_H2St', 'SBO:0000658'),
	('R_HACD1', 'SBO:0000200'),
	('R_HACD2', 'SBO:0000200'),
	('R_HACD3', 'SBO:0000200'),
	('R_HACD4', 'SBO:0000200'),
	('R_HACD5', 'SBO:0000200'),
	('R_HACD6', 'SBO:0000200'),
	('R_HACD7', 'SBO:0000200'),
	('R_HACD8', 'SBO:0000200'),
	('R_HCO3E', 'SBO:0000178'),
	('R_HDCAt2pp', 'SBO:0000659'),
	('R_HEMEOS', 'SBO:0000402'),
	('R_HETZK', 'SBO:0000216'),
	('R_HEX1', 'SBO:0000216'),
	('R_HEX4', 'SBO:0000216'),
	('R_HEX7', 'SBO:0000216'),
	('R_HISabc', 'SBO:0000657'),
	('R_HISabcpp', 'SBO:0000657'),
	('R_HISt2rpp', 'SBO:0000659'),
	('R_HISTD', 'SBO:0000200'),
	('R_HISTP', 'SBO:0000376'),
	('R_HMBS', 'SBO:0000401'),
	('R_HMGCOARi', 'SBO:0000200'),
	('R_HMPK2', 'SBO:0000216'),
	('R_HMSD', 'SBO:0000200'),
	('R_HPAtex', 'SBO:0000658'),
	('R_HPPK2', 'SBO:0000402'),
	('R_HPYRRx', 'SBO:0000200'),
	('R_HPYRRy', 'SBO:0000200'),
	('R_HSDy', 'SBO:0000200'),
	('R_HSERTA', 'SBO:0000215'),
	('R_HSK', 'SBO:0000216'),
	('R_HSST', 'SBO:0000402'),
	('R_HSTPT', 'SBO:0000403'),
	('R_HXANt2r', 'SBO:0000659'),
	('R_HXPRT', 'SBO:0000217'),
	('R_HYPOE', 'SBO:0000376'),
	('R_I2FE2SS2', 'SBO:0000200'),
	('R_I4FE4SR', 'SBO:0000200'),
	('R_ICDHyr', 'SBO:0000200'),
	('R_ICHORS', 'SBO:0000377'),
	('R_IDOND', 'SBO:0000200'),
	('R_IDOND2', 'SBO:0000200'),
	('R_IGPDH', 'SBO:0000178'),
	('R_IGPS', 'SBO:0000399'),
	('R_ILEabc', 'SBO:0000657'),
	('R_ILEabcpp', 'SBO:0000657'),
	('R_ILEt2r', 'SBO:0000659'),
	('R_ILEt2rpp', 'SBO:0000659'),
	('R_ILETA', 'SBO:0000403'),
	('R_IMPD', 'SBO:0000200'),
	('R_INSTt2', 'SBO:0000659'),
	('R_IPDDI', 'SBO:0000377'),
	('R_IPDPS', 'SBO:0000200'),
	('R_IPMD', 'SBO:0000200'),
	('R_IPPMIa', 'SBO:0000178'),
	('R_IPPMIb', 'SBO:0000178'),
	('R_IPPS', 'SBO:0000402'),
	('R_KARA1i', 'SBO:0000200'),
	('R_KARA2', 'SBO:0000200'),
	('R_KAS13', 'SBO:0000402'),
	('R_KAS14', 'SBO:0000399'),
	('R_KAS15', 'SBO:0000402'),
	('R_KAS16', 'SBO:0000399'),
	('R_KAS17', 'SBO:0000399'),
	('R_KAS2', 'SBO:0000402'),
	('R_KAS7', 'SBO:0000399'),
	('R_KAS8', 'SBO:0000399'),
	('R_KAS_HP', 'SBO:0000399'),
	('R_KAS_HP2', 'SBO:0000399'),
	('R_Kt2r', 'SBO:0000659'),
	('R_Kt3pp', 'SBO:0000660'),
	('R_LACpts', 'SBO:0000657'),
	('R_LacR', 'SBO:0000377'),
	('R_LALGP', 'SBO:0000376'),
	('R_LCADi', 'SBO:0000200'),
	('R_LCARS', 'SBO:0000200'),
	('R_LCTSabc', 'SBO:0000657'),
	('R_LCTSt3ipp', 'SBO:0000660'),
	('R_LCTStex', 'SBO:0000658'),
	('R_LDH_D', 'SBO:0000200'),
	('R_LDH_L', 'SBO:0000200'),
	('R_LEUabc', 'SBO:0000657'),
	('R_LEUabcpp', 'SBO:0000657'),
	('R_LEUt2r', 'SBO:0000659'),
	('R_LEUt2rpp', 'SBO:0000659'),
	('R_LIPOS', 'SBO:0000200'),
	('R_L_LACt2r', 'SBO:0000659'),
	('R_LPLIPAL2A160', 'SBO:0000376'),
	('R_LPLIPAL2E160', 'SBO:0000376'),
	('R_LPLIPAL2E180', 'SBO:0000376'),
	('R_LSERDHr', 'SBO:0000200'),
	('R_LYSabc', 'SBO:0000657'),
	('R_LYSabcpp', 'SBO:0000657'),
	('R_LYSDC', 'SBO:0000399'),
	('R_LYSt2r', 'SBO:0000659'),
	('R_LYSt3pp', 'SBO:0000660'),
	('R_LYSt3r', 'SBO:0000660'),
	('R_M1PD', 'SBO:0000200'),
	('R_MACPD', 'SBO:0000399'),
	('R_MAL6PG', 'SBO:0000376'),
	('R_MALT', 'SBO:0000376'),
	('R_MALt2_3', 'SBO:0000659'),
	('R_MALt2_3pp', 'SBO:0000659'),
	('R_MALTabc', 'SBO:0000657'),
	('R_MALTHXabcpp', 'SBO:0000657'),
	('R_MALTHXtexi', 'SBO:0000658'),
	('R_MALtpp', 'SBO:0000659'),
	('R_MALTpts', 'SBO:0000657'),
	('R_MAN6PI', 'SBO:0000377'),
	('R_MAN6Pt6_2', 'SBO:0000660'),
	('R_MAN6Pt6_2pp', 'SBO:0000660'),
	('R_MAN6Ptex', 'SBO:0000658'),
	('R_MANpts', 'SBO:0000657'),
	('R_MCSNAH', 'SBO:0000401'),
	('R_MDDCP1ex', 'SBO:0000376'),
	('R_MDDCP2ex', 'SBO:0000376'),
	('R_MDDCP3ex', 'SBO:0000376'),
	('R_MDDCP4ex', 'SBO:0000376'),
	('R_MDDCP5ex', 'SBO:0000376'),
	('R_MDDCP5pp', 'SBO:0000376'),
	('R_MDH', 'SBO:0000200'),
	('R_ME1', 'SBO:0000399'),
	('R_MECDPDH2', 'SBO:0000200'),
	('R_MECDPS', 'SBO:0000178'),
	('R_MELIBt2', 'SBO:0000659'),
	('R_MELIBt2pp', 'SBO:0000659'),
	('R_MELIBt3ipp', 'SBO:0000660'),
	('R_MELIBtex', 'SBO:0000658'),
	('R_MEPCT', 'SBO:0000402'),
	('R_METabc', 'SBO:0000657'),
	('R_METAT', 'SBO:0000402'),
	('R_METS', 'SBO:0000214'),
	('R_METSabc', 'SBO:0000657'),
	('R_METSRabc', 'SBO:0000657'),
	('R_MEVK1', 'SBO:0000216'),
	('R_MEVK2', 'SBO:0000216'),
	('R_MEVK3', 'SBO:0000216'),
	('R_MEVK4', 'SBO:0000216'),
	('R_MG2abc', 'SBO:0000657'),
	('R_MGSA', 'SBO:0000178'),
	('R_MGt5', 'SBO:0000658'),
	('R_MI1PP', 'SBO:0000376'),
	('R_MI1PS', 'SBO:0000377'),
	('R_MLTG1', 'SBO:0000376'),
	('R_MLTP1', 'SBO:0000217'),
	('R_MLTP2', 'SBO:0000217'),
	('R_MN2t3pp', 'SBO:0000660'),
	('R_MN2tpp', 'SBO:0000658'),
	('R_MNabc', 'SBO:0000657'),
	('R_MNLpts', 'SBO:0000657'),
	('R_MNt2', 'SBO:0000659'),
	('R_MOADSUx', 'SBO:0000200'),
	('R_MOBDabc', 'SBO:0000657'),
	('R_MOHMT', 'SBO:0000402'),
	('R_MPTAT', 'SBO:0000402'),
	('R_MPTG', 'SBO:0000655'),
	('R_MSO3abc', 'SBO:0000657'),
	('R_MTHFC', 'SBO:0000376'),
	('R_MTHFD', 'SBO:0000200'),
	('R_MTHFR5', 'SBO:0000200'),
	('R_NAabcO', 'SBO:0000657'),
	('R_NADFADOR', 'SBO:0000200'),
	('R_NADH10', 'SBO:0000200'),
	('R_NADH5', 'SBO:0000200'),
	('R_NADH6', 'SBO:0000200'),
	('R_NADH7', 'SBO:0000200'),
	('R_NADH8', 'SBO:0000200'),
	('R_NADH9', 'SBO:0000200'),
	('R_NADK', 'SBO:0000216'),
	('R_NADPHQR2', 'SBO:0000200'),
	('R_NAPRT', 'SBO:0000217'),
	('R_NAt3_1', 'SBO:0000660'),
	('R_NAt3_15', 'SBO:0000660'),
	('R_NAt3_2', 'SBO:0000660'),
	('R_NAt3pp', 'SBO:0000660'),
	('R_NCAMUP', 'SBO:0000658'),
	('R_NDPK1', 'SBO:0000216'),
	('R_NDPK2', 'SBO:0000216'),
	('R_NDPK3', 'SBO:0000216'),
	('R_NDPK4', 'SBO:0000216'),
	('R_NDPK5', 'SBO:0000216'),
	('R_NDPK6', 'SBO:0000216'),
	('R_NDPK7', 'SBO:0000216'),
	('R_NDPK8', 'SBO:0000216'),
	('R_NDPK9', 'SBO:0000216'),
	('R_NH4t', 'SBO:0000658'),
	('R_NH4tex', 'SBO:0000658'),
	('R_NH4tpp', 'SBO:0000658'),
	('R_NI2t3pp', 'SBO:0000660'),
	('R_NI2t4pp', 'SBO:0000660'),
	('R_NI2tex', 'SBO:0000658'),
	('R_NI2uabcpp', 'SBO:0000657'),
	('R_NIabc', 'SBO:0000657'),
	('R_NNAM', 'SBO:0000376'),
	('R_NO2t2r', 'SBO:0000659'),
	('R_NO3t7', 'SBO:0000660'),
	('R_NODOy', 'SBO:0000200'),
	('R_NOt', 'SBO:0000658'),
	('R_NPHS', 'SBO:0000178'),
	('R_NTD10', 'SBO:0000376'),
	('R_NTD2', 'SBO:0000376'),
	('R_NTD7', 'SBO:0000376'),
	('R_NTD9', 'SBO:0000376'),
	('R_NTRIRx', 'SBO:0000200'),
	('R_NTRIRy', 'SBO:0000200'),
	('R_O2t', 'SBO:0000658'),
	('R_O2tpp', 'SBO:0000658'),
	('R_OCBT', 'SBO:0000402'),
	('R_OCDCAt2pp', 'SBO:0000659'),
	('R_OCDCEAt2pp', 'SBO:0000659'),
	('R_OCTDPS', 'SBO:0000402'),
	('R_OIVD1r', 'SBO:0000399'),
	('R_OIVD2', 'SBO:0000200'),
	('R_OIVD3', 'SBO:0000399'),
	('R_OMCDC', 'SBO:0000200'),
	('R_OMPDC', 'SBO:0000399'),
	('R_OOR3r', 'SBO:0000200'),
	('R_OP4ENH', 'SBO:0000178'),
	('R_OPTCCL', 'SBO:0000399'),
	('R_ORNabc', 'SBO:0000657'),
	('R_ORNabcpp', 'SBO:0000657'),
	('R_ORNCD', 'SBO:0000178'),
	('R_ORNDC', 'SBO:0000399'),
	('R_ORNTA', 'SBO:0000403'),
	('R_ORNTAC', 'SBO:0000215'),
	('R_ORNTAC_1', 'SBO:0000215'),
	('R_ORNtex', 'SBO:0000658'),
	('R_ORPT', 'SBO:0000217'),
	('R_OXGDC2', 'SBO:0000399'),
	('R_P5CD', 'SBO:0000200'),
	('R_P5CR', 'SBO:0000200'),
	('R_PA160abcpp', 'SBO:0000657'),
	('R_PAPPT3', 'SBO:0000402'),
	('R_PAPSR', 'SBO:0000200'),
	('R_PDH', 'SBO:0000399'),
	('R_PDHcr', 'SBO:0000200'),
	('R_PDXPP', 'SBO:0000376'),
	('R_PE120abcpp', 'SBO:0000657'),
	('R_PE140abcpp', 'SBO:0000657'),
	('R_PE160abcpp', 'SBO:0000657'),
	('R_PE161abcpp', 'SBO:0000657'),
	('R_PE180abcpp', 'SBO:0000657'),
	('R_PE181abcpp', 'SBO:0000657'),
	('R_PFK', 'SBO:0000216'),
	('R_PFK_2', 'SBO:0000216'),
	('R_PFL', 'SBO:0000215'),
	('R_PG160abcpp', 'SBO:0000657'),
	('R_PGAMT', 'SBO:0000377'),
	('R_PGCD', 'SBO:0000200'),
	('R_PGI', 'SBO:0000377'),
	('R_PGK', 'SBO:0000216'),
	('R_PGL', 'SBO:0000376'),
	('R_PGLYCP', 'SBO:0000376'),
	('R_PGPP160', 'SBO:0000376'),
	('R_PGSA160', 'SBO:0000402'),
	('R_PIabc', 'SBO:0000657'),
	('R_PIt2r', 'SBO:0000659'),
	('R_PIt7ipp', 'SBO:0000659'),
	('R_PItex', 'SBO:0000658'),
	('R_PLIPA1A160pp', 'SBO:0000376'),
	('R_PLIPA1E160pp', 'SBO:0000376'),
	('R_PLIPA1E180pp', 'SBO:0000376'),
	('R_PMANM', 'SBO:0000377'),
	('R_PMEVK', 'SBO:0000216'),
	('R_PMPK', 'SBO:0000216'),
	('R_PNTK', 'SBO:0000216'),
	('R_POX', 'SBO:0000399'),
	('R_POX2', 'SBO:0000399'),
	('R_PPA', 'SBO:0000376'),
	('R_PPA2', 'SBO:0000376'),
	('R_PPBNGS', 'SBO:0000178'),
	('R_PPCDC', 'SBO:0000399'),
	('R_PPCK', 'SBO:0000399'),
	('R_PPDK', 'SBO:0000402'),
	('R_PPM2', 'SBO:0000377'),
	('R_PPND', 'SBO:0000200'),
	('R_PPNDH', 'SBO:0000399'),
	('R_PPPGO', 'SBO:0000200'),
	('R_PRAIi', 'SBO:0000377'),
	('R_PRAMPC', 'SBO:0000376'),
	('R_PRATPP', 'SBO:0000376'),
	('R_PRMICI', 'SBO:0000377'),
	('R_PROabc', 'SBO:0000657'),
	('R_PROabcpp', 'SBO:0000657'),
	('R_PROD2', 'SBO:0000200'),
	('R_PROGLYabcpp', 'SBO:0000657'),
	('R_PROGLYtex', 'SBO:0000658'),
	('R_PROt2rpp', 'SBO:0000659'),
	('R_PROt4', 'SBO:0000659'),
	('R_PRPPS', 'SBO:0000402'),
	('R_PSCVT', 'SBO:0000402'),
	('R_PSD120', 'SBO:0000399'),
	('R_PSD160', 'SBO:0000399'),
	('R_PSD161', 'SBO:0000399'),
	('R_PSD180', 'SBO:0000399'),
	('R_PSD181', 'SBO:0000399'),
	('R_PSER_Lt6', 'SBO:0000659'),
	('R_PSERT', 'SBO:0000403'),
	('R_PSSA120', 'SBO:0000402'),
	('R_PSSA160', 'SBO:0000402'),
	('R_PSSA161', 'SBO:0000402'),
	('R_PSSA180', 'SBO:0000402'),
	('R_PSSA181', 'SBO:0000402'),
	('R_PTAr', 'SBO:0000215'),
	('R_PTPATi', 'SBO:0000402'),
	('R_PTRCabc', 'SBO:0000657'),
	('R_PTRCabcpp', 'SBO:0000657'),
	('R_PTRCORNt7', 'SBO:0000660'),
	('R_PTRCORNt7pp', 'SBO:0000660'),
	('R_PUNP1', 'SBO:0000217'),
	('R_PUNP2', 'SBO:0000217'),
	('R_PUNP3', 'SBO:0000216'),
	('R_PUNP5', 'SBO:0000216'),
	('R_PUNP6', 'SBO:0000216'),
	('R_PYDAMK', 'SBO:0000216'),
	('R_PYDXK', 'SBO:0000216'),
	('R_PYDXNK', 'SBO:0000216'),
	('R_PYDXPP', 'SBO:0000376'),
	('R_PYK', 'SBO:0000216'),
	('R_PYNP1', 'SBO:0000217'),
	('R_PYNP2r', 'SBO:0000216'),
	('R_QRr', 'SBO:0000200'),
	('R_RAFFINt2', 'SBO:0000659'),
	('R_RAFH', 'SBO:0000376'),
	('R_RBFK', 'SBO:0000216'),
	('R_RBFSb', 'SBO:0000402'),
	('R_RBK', 'SBO:0000216'),
	('R_RBK_L1', 'SBO:0000216'),
	('R_RBP4E', 'SBO:0000377'),
	('R_RDXR', 'SBO:0000200'),
	('R_RHCCE', 'SBO:0000178'),
	('R_RIBabc', 'SBO:0000657'),
	('R_RIBabc1', 'SBO:0000657'),
	('R_RIBFLVt2', 'SBO:0000659'),
	('R_RNDR1', 'SBO:0000200'),
	('R_RNDR2', 'SBO:0000200'),
	('R_RNDR3', 'SBO:0000200'),
	('R_RNDR4', 'SBO:0000200'),
	('R_RNMK', 'SBO:0000216'),
	('R_RNTR1', 'SBO:0000200'),
	('R_RNTR2', 'SBO:0000200'),
	('R_RNTR3', 'SBO:0000200'),
	('R_RNTR4', 'SBO:0000200'),
	('R_RPE', 'SBO:0000377'),
	('R_RPI', 'SBO:0000377'),
	('R_S2FE2SS2', 'SBO:0000200'),
	('R_S4FE4SR', 'SBO:0000200'),
	('R_SADT', 'SBO:0000402'),
	('R_SADT2', 'SBO:0000402'),
	('R_SALCHS2FEabcpp', 'SBO:0000657'),
	('R_SALCHS2FEtonex', 'SBO:0000654'),
	('R_SALCHS4abcpp', 'SBO:0000657'),
	('R_SALCHS4tex', 'SBO:0000654'),
	('R_SALCHSXtex', 'SBO:0000658'),
	('R_SALCHSXtpp', 'SBO:0000658'),
	('R_SDPDS', 'SBO:0000376'),
	('R_SDPTA', 'SBO:0000403'),
	('R_SERabc', 'SBO:0000657'),
	('R_SERAT', 'SBO:0000215'),
	('R_SERt2r', 'SBO:0000659'),
	('R_SFGTHi', 'SBO:0000376'),
	('R_SHCHD2', 'SBO:0000200'),
	('R_SHCHD2_1', 'SBO:0000200'),
	('R_SHCHF', 'SBO:0000178'),
	('R_SHCHF_2', 'SBO:0000178'),
	('R_SHK3Dr', 'SBO:0000200'),
	('R_SHKK', 'SBO:0000216'),
	('R_SHSL1', 'SBO:0000402'),
	('R_SHSL4r', 'SBO:0000401'),
	('R_SO3abcpp', 'SBO:0000657'),
	('R_SO3tex', 'SBO:0000658'),
	('R_SO4t2', 'SBO:0000659'),
	('R_SPMDabc', 'SBO:0000657'),
	('R_SPMDabcpp', 'SBO:0000657'),
	('R_SPMDt3', 'SBO:0000660'),
	('R_SPMDtex', 'SBO:0000658'),
	('R_SPP', 'SBO:0000376'),
	('R_SPTc', 'SBO:0000403'),
	('R_SPT_syn', 'SBO:0000403'),
	('R_SSALy', 'SBO:0000200'),
	('R_St', 'SBO:0000658'),
	('R_SUCCt2_3', 'SBO:0000659'),
	('R_SUCCt2_3pp', 'SBO:0000659'),
	('R_SUCCt3pp', 'SBO:0000660'),
	('R_SUCD1', 'SBO:0000200'),
	('R_SUCD4', 'SBO:0000200'),
	('R_SUCFUMt', 'SBO:0000660'),
	('R_SUCFUMtpp', 'SBO:0000660'),
	('R_SUCpts', 'SBO:0000657'),
	('R_SULabc', 'SBO:0000657'),
	('R_SULR', 'SBO:0000200'),
	('R_SULR_1', 'SBO:0000200'),
	('R_TALA', 'SBO:0000402'),
	('R_TARTRDtpp', 'SBO:0000658'),
	('R_TARTt2_3pp', 'SBO:0000659'),
	('R_TAURabc', 'SBO:0000657'),
	('R_TETDHpp2', 'SBO:0000660'),
	('R_TETtex', 'SBO:0000658'),
	('R_TGBPA', 'SBO:0000178'),
	('R_THDPS', 'SBO:0000402'),
	('R_THIORDXi', 'SBO:0000200'),
	('R_THMabc', 'SBO:0000657'),
	('R_THMDt4', 'SBO:0000659'),
	('R_THMt2', 'SBO:0000659'),
	('R_THRabc', 'SBO:0000657'),
	('R_THRD_L', 'SBO:0000178'),
	('R_THRS', 'SBO:0000178'),
	('R_THZPSN3', 'SBO:0000399'),
	('R_TKT1', 'SBO:0000402'),
	('R_TKT2', 'SBO:0000402'),
	('R_TMDK1', 'SBO:0000216'),
	('R_TMDPP', 'SBO:0000216'),
	('R_TMDS', 'SBO:0000214'),
	('R_TMN', 'SBO:0000376'),
	('R_TMPK', 'SBO:0000216'),
	('R_TMPPP', 'SBO:0000402'),
	('R_TPI', 'SBO:0000377'),
	('R_TRDR', 'SBO:0000200'),
	('R_TREpts', 'SBO:0000657'),
	('R_TRPS1', 'SBO:0000178'),
	('R_TRPTA', 'SBO:0000403'),
	('R_TSULabc', 'SBO:0000657'),
	('R_TSULabcpp', 'SBO:0000657'),
	('R_TTDCAt2pp', 'SBO:0000659'),
	('R_TYRL', 'SBO:0000178'),
	('R_UAGCVT', 'SBO:0000402'),
	('R_UAGDP', 'SBO:0000402'),
	('R_UAGPT3', 'SBO:0000217'),
	('R_UAPGR', 'SBO:0000200'),
	('R_UDPG4E', 'SBO:0000377'),
	('R_UMPK', 'SBO:0000216'),
	('R_UPP3MT', 'SBO:0000214'),
	('R_UPP3MT_2', 'SBO:0000214'),
	('R_UPP3S', 'SBO:0000178'),
	('R_UPPDC1', 'SBO:0000399'),
	('R_UPPRT', 'SBO:0000217'),
	('R_URAt2', 'SBO:0000659'),
	('R_URATEt_1', 'SBO:0000659'),
	('R_UREA', 'SBO:0000376'),
	('R_UREAt', 'SBO:0000658'),
	('R_URIC', 'SBO:0000233'),
	('R_URIDK2r', 'SBO:0000216'),
	('R_URIH', 'SBO:0000376'),
	('R_URIK1', 'SBO:0000216'),
	('R_URIK2', 'SBO:0000216'),
	('R_URIK3', 'SBO:0000216'),
	('R_URIt4', 'SBO:0000659'),
	('R_URItex', 'SBO:0000658'),
	('R_VALabc', 'SBO:0000657'),
	('R_VALabcpp', 'SBO:0000657'),
	('R_VALt2r', 'SBO:0000659'),
	('R_VALt2rpp', 'SBO:0000659'),
	('R_XANt', 'SBO:0000658'),
	('R_XANt2', 'SBO:0000659'),
	('R_XPPT', 'SBO:0000217'),
	('R_XTSNH', 'SBO:0000376'),
	('R_XYLabc', 'SBO:0000657'),
	('R_XYLI1', 'SBO:0000377'),
	('R_XYLK', 'SBO:0000216'),
	('R_XYLt2', 'SBO:0000659'),
	('R_ZN2t3pp', 'SBO:0000660'),
	('R_ZN2t4', 'SBO:0000660'),
	('R_ZN2t4pp', 'SBO:0000660'),
	('R_ZN2tpp', 'SBO:0000658'),
	('R_ZNabc', 'SBO:0000657'),
	('R_ZNabcpp', 'SBO:0000657'),
	('R_EX_glc__D_e', 'SBO:0000627'),
	('R_EX_h2o_e', 'SBO:0000627'),
	('R_EX_23camp_e', 'SBO:0000627'),
	('R_EX_23ccmp_e', 'SBO:0000627'),
	('R_EX_23cgmp_e', 'SBO:0000627'),
	('R_EX_23cump_e', 'SBO:0000627'),
	('R_EX_2dhglcn_e', 'SBO:0000627'),
	('R_EX_h_e', 'SBO:0000627'),
	('R_EX_2pglyc_e', 'SBO:0000627'),
	('R_EX_leu__L_e', 'SBO:0000627'),
	('R_EX_ala__L_e', 'SBO:0000627'),
	('R_EX_cl_e', 'SBO:0000627'),
	('R_EX_arab__L_e', 'SBO:0000627'),
	('R_EX_abt__L_e', 'SBO:0000627'),
	('R_EX_4abut_e', 'SBO:0000627'),
	('R_EX_acald_e', 'SBO:0000627'),
	('R_EX_acgam_e', 'SBO:0000627'),
	('R_EX_chol_e', 'SBO:0000627'),
	('R_EX_acmum_e', 'SBO:0000627'),
	('R_EX_pi_e', 'SBO:0000627'),
	('R_EX_ribflv_e', 'SBO:0000627'),
	('R_EX_actn__R_e', 'SBO:0000627'),
	('R_EX_adn_e', 'SBO:0000627'),
	('R_EX_nh4_e', 'SBO:0000627'),
	('R_EX_akg_e', 'SBO:0000627'),
	('R_EX_mal__L_e', 'SBO:0000627'),
	('R_EX_alaala_e', 'SBO:0000627'),
	('R_EX_ala__D_e', 'SBO:0000627'),
	('R_EX_gln__L_e', 'SBO:0000627'),
	('R_EX_gly_e', 'SBO:0000627'),
	('R_EX_ser__L_e', 'SBO:0000627'),
	('R_EX_thr__L_e', 'SBO:0000627'),
	('R_EX_arg__L_e', 'SBO:0000627'),
	('R_EX_alltn_e', 'SBO:0000627'),
	('R_EX_cgly_e', 'SBO:0000627'),
	('R_EX_malt_e', 'SBO:0000627'),
	('R_EX_anhgm_e', 'SBO:0000627'),
	('R_EX_fe3_e', 'SBO:0000627'),
	('R_EX_lys__L_e', 'SBO:0000627'),
	('R_EX_orn_e', 'SBO:0000627'),
	('R_EX_asp__L_e', 'SBO:0000627'),
	('R_EX_k_e', 'SBO:0000627'),
	('R_EX_pro__L_e', 'SBO:0000627'),
	('R_EX_ala_B_e', 'SBO:0000627'),
	('R_EX_cellb_e', 'SBO:0000627'),
	('R_EX_ca2_e', 'SBO:0000627'),
	('R_EX_15dap_e', 'SBO:0000627'),
	('R_EX_catechol_e', 'SBO:0000627'),
	('R_EX_cit_e', 'SBO:0000627'),
	('R_EX_mg2_e', 'SBO:0000627'),
	('R_EX_mn2_e', 'SBO:0000627'),
	('R_EX_cobalt2_e', 'SBO:0000627'),
	('R_EX_zn2_e', 'SBO:0000627'),
	('R_EX_succ_e', 'SBO:0000627'),
	('R_EX_for_e', 'SBO:0000627'),
	('R_EX_co2_e', 'SBO:0000627'),
	('R_EX_crn_e', 'SBO:0000627'),
	('R_EX_cu2_e', 'SBO:0000627'),
	('R_EX_cu_e', 'SBO:0000627'),
	('R_EX_o2_e', 'SBO:0000627'),
	('R_EX_glu__L_e', 'SBO:0000627'),
	('R_EX_cytd_e', 'SBO:0000627'),
	('R_EX_diact_e', 'SBO:0000627'),
	('R_EX_drib_e', 'SBO:0000627'),
	('R_EX_ser__D_e', 'SBO:0000627'),
	('R_EX_galur_e', 'SBO:0000627'),
	('R_EX_etha_e', 'SBO:0000627'),
	('R_EX_eths_e', 'SBO:0000627'),
	('R_EX_f6p_e', 'SBO:0000627'),
	('R_EX_fe2_e', 'SBO:0000627'),
	('R_EX_enter_e', 'SBO:0000627'),
	('R_EX_feroxEfe_e', 'SBO:0000627'),
	('R_EX_feroxE_e', 'SBO:0000627'),
	('R_EX_fru_e', 'SBO:0000627'),
	('R_EX_fum_e', 'SBO:0000627'),
	('R_EX_g6p_e', 'SBO:0000627'),
	('R_EX_galct__D_e', 'SBO:0000627'),
	('R_EX_galt_e', 'SBO:0000627'),
	('R_EX_gam6p_e', 'SBO:0000627'),
	('R_EX_gam_e', 'SBO:0000627'),
	('R_EX_gthrd_e', 'SBO:0000627'),
	('R_EX_glcn_e', 'SBO:0000627'),
	('R_EX_glcr_e', 'SBO:0000627'),
	('R_EX_glcur_e', 'SBO:0000627'),
	('R_EX_glyc3p_e', 'SBO:0000627'),
	('R_EX_glyald_e', 'SBO:0000627'),
	('R_EX_glyb_e', 'SBO:0000627'),
	('R_EX_glyclt_e', 'SBO:0000627'),
	('R_EX_glyc_e', 'SBO:0000627'),
	('R_EX_gsn_e', 'SBO:0000627'),
	('R_EX_gua_e', 'SBO:0000627'),
	('R_EX_h2s_e', 'SBO:0000627'),
	('R_EX_his__L_e', 'SBO:0000627'),
	('R_EX_4hphac_e', 'SBO:0000627'),
	('R_EX_hxan_e', 'SBO:0000627'),
	('R_EX_taur_e', 'SBO:0000627'),
	('R_EX_ile__L_e', 'SBO:0000627'),
	('R_EX_inost_e', 'SBO:0000627'),
	('R_EX_lcts_e', 'SBO:0000627'),
	('R_EX_lac__L_e', 'SBO:0000627'),
	('R_EX_malthx_e', 'SBO:0000627'),
	('R_EX_man6p_e', 'SBO:0000627'),
	('R_EX_man_e', 'SBO:0000627'),
	('R_EX_murein5p5p_e', 'SBO:0000627'),
	('R_EX_murein5px4p_e', 'SBO:0000627'),
	('R_EX_murein5px3p_e', 'SBO:0000627'),
	('R_EX_murein5p5p5p_e', 'SBO:0000627'),
	('R_EX_murein5px4px4p_e', 'SBO:0000627'),
	('R_EX_murein4px4p_e', 'SBO:0000627'),
	('R_EX_murein4px4px4p_e', 'SBO:0000627'),
	('R_EX_murein5p4p_e', 'SBO:0000627'),
	('R_EX_murein4p4p_e', 'SBO:0000627'),
	('R_EX_murein4p3p_e', 'SBO:0000627'),
	('R_EX_murein5p3p_e', 'SBO:0000627'),
	('R_EX_melib_e', 'SBO:0000627'),
	('R_EX_met__L_e', 'SBO:0000627'),
	('R_EX_metox_e', 'SBO:0000627'),
	('R_EX_metox__R_e', 'SBO:0000627'),
	('R_EX_mnl_e', 'SBO:0000627'),
	('R_EX_mobd_e', 'SBO:0000627'),
	('R_EX_uaagmda_e', 'SBO:0000627'),
	('R_EX_udcpdp_e', 'SBO:0000627'),
	('R_EX_mso3_e', 'SBO:0000627'),
	('R_EX_ncam_e', 'SBO:0000627'),
	('R_EX_no2_e', 'SBO:0000627'),
	('R_EX_no3_e', 'SBO:0000627'),
	('R_EX_no_e', 'SBO:0000627'),
	('R_EX_uri_e', 'SBO:0000627'),
	('R_EX_progly_e', 'SBO:0000627'),
	('R_EX_pser__L_e', 'SBO:0000627'),
	('R_EX_ptrc_e', 'SBO:0000627'),
	('R_EX_so4_e', 'SBO:0000627'),
	('R_EX_urate_e', 'SBO:0000627'),
	('R_EX_val__L_e', 'SBO:0000627'),
	('R_EX_raffin_e', 'SBO:0000627'),
	('R_EX_spmd_e', 'SBO:0000627'),
	('R_EX_urea_e', 'SBO:0000627'),
	('R_EX_rib__D_e', 'SBO:0000627'),
	('R_EX_salchs2fe_e', 'SBO:0000627'),
	('R_EX_salchs4_e', 'SBO:0000627'),
	('R_EX_salchsx_e', 'SBO:0000627'),
	('R_EX_so3_e', 'SBO:0000627'),
	('R_EX_s_e', 'SBO:0000627'),
	('R_EX_sucr_e', 'SBO:0000627'),
	('R_EX_tet_e', 'SBO:0000627'),
	('R_EX_thm_e', 'SBO:0000627'),
	('R_EX_thymd_e', 'SBO:0000627'),
	('R_EX_tre_e', 'SBO:0000627'),
	('R_EX_tsul_e', 'SBO:0000627'),
	('R_EX_ura_e', 'SBO:0000627'),
	('R_EX_xan_e', 'SBO:0000627'),
	('R_EX_xyl__D_e', 'SBO:0000627'),
	('R_SK_4crsol_c', 'SBO:0000632'),
	('R_SK_5drib_c', 'SBO:0000632'),
	('R_SK_aacald_c', 'SBO:0000632'),
	('R_SK_bmocogdp_c', 'SBO:0000632'),
	('R_SK_hemeO_c', 'SBO:0000632'),
	('R_SK_hmfurn_c', 'SBO:0000632'),
	('R_SK_lipopb_c', 'SBO:0000632'),
	('R_SK_sheme_c', 'SBO:0000632'),
	('R_25HVITD2t', 'SBO:0000658'),
	('R_25HVITD2tin', 'SBO:0000658'),
	('R_25HVITD2tin_m', 'SBO:0000658'),
	('R_25HVITD2tm', 'SBO:0000658'),
	('R_25HVITD3t', 'SBO:0000658'),
	('R_25HVITD3tin', 'SBO:0000658'),
	('R_25HVITD3tin_m', 'SBO:0000658'),
	('R_25HVITD3tm', 'SBO:0000658'),
	('R_25VITD2Hm', 'SBO:0000200'),
	('R_25VITD3Hm', 'SBO:0000200'),
	('R_2AMACHYD', 'SBO:0000178'),
	('R_2AMACSULT', 'SBO:0000200'),
	('R_2AMADPTm', 'SBO:0000660'),
	('R_2DR1PP', 'SBO:0000216'),
	('R_2HBO', 'SBO:0000200'),
	('R_2HBt2', 'SBO:0000659'),
	('R_2HCO3_NAt', 'SBO:0000659'),
	('R_2MCITt', 'SBO:0000658'),
	('R_2OXOADOXm', 'SBO:0000399'),
	('R_2OXOADPTm', 'SBO:0000660'),
	('R_CYTK14', 'SBO:0000216'),
	('R_34DHOXPEGOX', 'SBO:0000200'),
	('R_34DHOXPEGt', 'SBO:0000658'),
	('R_34DHPHAMT', 'SBO:0000214'),
	('R_34DHPHEt', 'SBO:0000658'),
	('R_34DHALDD', 'SBO:0000200'),
	('R_CYTK14n', 'SBO:0000216'),
	('R_CYTK1m', 'SBO:0000216'),
	('R_CYTK1n', 'SBO:0000216'),
	('R_34DHPLACOX_NADP', 'SBO:0000200'),
	('R_34DHXMANDACOX', 'SBO:0000200'),
	('R_34DHXMANDACOX_NADP', 'SBO:0000200'),
	('R_CYTK2n', 'SBO:0000216'),
	('R_34HPLFM', 'SBO:0000200'),
	('R_41R1H2MAE12BOOX', 'SBO:0000200'),
	('R_CYTK3', 'SBO:0000216'),
	('R_CYTK3n', 'SBO:0000216'),
	('R_CYTK4', 'SBO:0000216'),
	('R_41R2A1H12BOOX', 'SBO:0000200'),
	('R_42A12BOOX', 'SBO:0000401'),
	('R_CYTK4n', 'SBO:0000216'),
	('R_34HPPOR', 'SBO:0000200'),
	('R_35CGMPtn', 'SBO:0000658'),
	('R_CYTK2_1', 'SBO:0000216'),
	('R_3AIBTm', 'SBO:0000403'),
	('R_CYTK5n', 'SBO:0000216'),
	('R_3AIBt', 'SBO:0000658'),
	('R_CPK1', 'SBO:0000216'),
	('R_4ABUTtm', 'SBO:0000658'),
	('R_3AIBtm', 'SBO:0000658'),
	('R_4HBZCOAFm', 'SBO:0000200'),
	('R_4HBZFm', 'SBO:0000376'),
	('R_CYTK6n', 'SBO:0000216'),
	('R_CYTK7', 'SBO:0000216'),
	('R_CYTK7n', 'SBO:0000216'),
	('R_CYTK8', 'SBO:0000216'),
	('R_4HDEBRISOQUINEte', 'SBO:0000658'),
	('R_5ADTSTSTERONESte', 'SBO:0000658'),
	('R_CYTK8n', 'SBO:0000216'),
	('R_CYTK9', 'SBO:0000216'),
	('R_CYTK9n', 'SBO:0000216'),
	('R_D3AIBTm', 'SBO:0000403'),
	('R_5ADTSTSTERONEte', 'SBO:0000658'),
	('R_5ADTSTSTERONEtr', 'SBO:0000658'),
	('R_4HGLSDm', 'SBO:0000200'),
	('R_4HOXPACDOX_NADP', 'SBO:0000200'),
	('R_4MOPt2im', 'SBO:0000659'),
	('R_DADA', 'SBO:0000401'),
	('R_DADAe', 'SBO:0000401'),
	('R_3DPHBH1', 'SBO:0000200'),
	('R_DADNt4', 'SBO:0000658'),
	('R_4MTOLBUTAMIDEte', 'SBO:0000658'),
	('R_4NPHSFte', 'SBO:0000658'),
	('R_3DPHBH2', 'SBO:0000200'),
	('R_3DSPHR', 'SBO:0000200'),
	('R_3HAO', 'SBO:0000200'),
	('R_DAGK_hs', 'SBO:0000216'),
	('R_DAGKn_hs', 'SBO:0000216'),
	('R_4NPHte', 'SBO:0000658'),
	('R_3HBCDm', 'SBO:0000178'),
	('R_4PYRDX', 'SBO:0000657'),
	('R_5ADTSTSTERONEGLCte', 'SBO:0000657'),
	('R_DAG_HSter', 'SBO:0000658'),
	('R_DALAOXx', 'SBO:0000401'),
	('R_3HBCOAHLm', 'SBO:0000376'),
	('R_5ADTSTSTERONEGLCtr', 'SBO:0000658'),
	('R_5AOPtm', 'SBO:0000658'),
	('R_5DHFtl', 'SBO:0000658'),
	('R_3HCO3_NAt', 'SBO:0000659'),
	('R_5FTHFt2', 'SBO:0000660'),
	('R_5HLTDL', 'SBO:0000399'),
	('R_5HOMEPRAZOLEte', 'SBO:0000658'),
	('R_5HOXINDACTO2OX', 'SBO:0000200'),
	('R_5HOXINDACTOX', 'SBO:0000200'),
	('R_5HOXINDACTOXm', 'SBO:0000200'),
	('R_DALAt2rL', 'SBO:0000659'),
	('R_DALAxt', 'SBO:0000658'),
	('R_DARGOp', 'SBO:0000200'),
	('R_DASCBH', 'SBO:0000376'),
	('R_DASCBR', 'SBO:0000200'),
	('R_DASPO1p', 'SBO:0000401'),
	('R_5HOXINOXDA', 'SBO:0000401'),
	('R_5HTRPDOX', 'SBO:0000200'),
	('R_DATPtn', 'SBO:0000658'),
	('R_5HTRPVESSEC', 'SBO:0000657'),
	('R_3HKYNAKGAT', 'SBO:0000403'),
	('R_3HLYTCL', 'SBO:0000399'),
	('R_3HPCOAHYD', 'SBO:0000376'),
	('R_5MTHFt', 'SBO:0000658'),
	('R_5MTHFt2', 'SBO:0000660'),
	('R_3HPPD', 'SBO:0000200'),
	('R_3HXKYNDCL', 'SBO:0000399'),
	('R_5HXKYNDCL', 'SBO:0000399'),
	('R_5HXKYNOXDA', 'SBO:0000200'),
	('R_5THFtl', 'SBO:0000658'),
	('R_3HXKYNOXDA', 'SBO:0000200'),
	('R_5THFtm', 'SBO:0000658'),
	('R_3M4HDXPAC', 'SBO:0000200'),
	('R_6DHFtl', 'SBO:0000658'),
	('R_6DHFtm', 'SBO:0000658'),
	('R_6HTSTSTERONEte', 'SBO:0000658'),
	('R_6HTSTSTERONEtr', 'SBO:0000658'),
	('R_6THFtl', 'SBO:0000658'),
	('R_ABUTD', 'SBO:0000200'),
	('R_ABUTt2r', 'SBO:0000659'),
	('R_6THFtm', 'SBO:0000658'),
	('R_3MLDAt', 'SBO:0000658'),
	('R_7DHCHSTEROLtr', 'SBO:0000658'),
	('R_3MOBt2im', 'SBO:0000659'),
	('R_7DHFtl', 'SBO:0000658'),
	('R_7DHFtm', 'SBO:0000658'),
	('R_7THFtl', 'SBO:0000658'),
	('R_10FTHF7GLUtm', 'SBO:0000658'),
	('R_10FTHFtl', 'SBO:0000658'),
	('R_7THFtm', 'SBO:0000658'),
	('R_3MOPt2im', 'SBO:0000659'),
	('R_10FTHFtm', 'SBO:0000658'),
	('R_11DOCRTSLtm', 'SBO:0000658'),
	('R_3MOX4HOXPGALDOX', 'SBO:0000200'),
	('R_11DOCRTSLtr', 'SBO:0000658'),
	('R_10FTHF5GLUtl', 'SBO:0000658'),
	('R_3MOX4HOXPGALDOX_NADP', 'SBO:0000200'),
	('R_10FTHF5GLUtm', 'SBO:0000658'),
	('R_10FTHF6GLUtl', 'SBO:0000658'),
	('R_3MOXTYROX', 'SBO:0000200'),
	('R_10FTHF6GLUtm', 'SBO:0000658'),
	('R_10FTHF7GLUtl', 'SBO:0000658'),
	('R_11DOCRTSTRNtm', 'SBO:0000658'),
	('R_11DOCRTSTRNtr', 'SBO:0000658'),
	('R_13DAMPPOX', 'SBO:0000401'),
	('R_AACTOOR', 'SBO:0000401'),
	('R_AACTtm', 'SBO:0000658'),
	('R_1MNCAMti', 'SBO:0000657'),
	('R_3NTD7l', 'SBO:0000376'),
	('R_1PPDCRp', 'SBO:0000200'),
	('R_AASAD3', 'SBO:0000200'),
	('R_3SALAASPm', 'SBO:0000660'),
	('R_AASAD3m', 'SBO:0000200'),
	('R_1a_24_25VITD2Hm', 'SBO:0000200'),
	('R_1a_24_25VITD3Hm', 'SBO:0000200'),
	('R_3SALACBOXL', 'SBO:0000399'),
	('R_1a_25VITD2Hm', 'SBO:0000200'),
	('R_1a_25VITD3Hm', 'SBO:0000200'),
	('R_24NPHte', 'SBO:0000658'),
	('R_AATA', 'SBO:0000403'),
	('R_24_25DHVITD2t', 'SBO:0000658'),
	('R_24_25DHVITD2tm', 'SBO:0000658'),
	('R_24_25DHVITD3t', 'SBO:0000658'),
	('R_24_25DHVITD3tm', 'SBO:0000658'),
	('R_24_25VITD2Hm', 'SBO:0000200'),
	('R_3SALATAi', 'SBO:0000403'),
	('R_24_25VITD3Hm', 'SBO:0000233'),
	('R_ABTArm', 'SBO:0000403'),
	('R_ABTD', 'SBO:0000200'),
	('R_ABTt', 'SBO:0000658'),
	('R_ABUTt2rL', 'SBO:0000659'),
	('R_ABUTt4_2_r', 'SBO:0000659'),
	('R_ACACT1r_copy1', 'SBO:0000215'),
	('R_3SALATAim', 'SBO:0000403'),
	('R_ACACT1r_copy2', 'SBO:0000215'),
	('R_ACACT1m', 'SBO:0000215'),
	('R_ACACT1x', 'SBO:0000215'),
	('R_ACACT5p', 'SBO:0000215'),
	('R_ACOAD8m', 'SBO:0000200'),
	('R_ACOAD9m', 'SBO:0000200'),
	('R_ACOAH', 'SBO:0000376'),
	('R_ACACt2', 'SBO:0000659'),
	('R_ACACt2m', 'SBO:0000659'),
	('R_ACACtx', 'SBO:0000658'),
	('R_ACALDtm', 'SBO:0000658'),
	('R_ACONTm', 'SBO:0000178'),
	('R_ACOX22x', 'SBO:0000200'),
	('R_ACALDtx', 'SBO:0000658'),
	('R_ACOX2x', 'SBO:0000200'),
	('R_ACRNtm', 'SBO:0000658'),
	('R_ACCOAgt', 'SBO:0000658'),
	('R_ACCOAtn', 'SBO:0000658'),
	('R_ACCOAtr', 'SBO:0000658'),
	('R_ACSOMT', 'SBO:0000214'),
	('R_ACSRTNMT', 'SBO:0000214'),
	('R_ACETONEt2', 'SBO:0000659'),
	('R_ACETONEt2m', 'SBO:0000659'),
	('R_ACGAGBSIDEtg', 'SBO:0000658'),
	('R_ACGAGBSIDEtl', 'SBO:0000658'),
	('R_ACGALFUCGALACGALFUC12GAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_ACTLMO', 'SBO:0000200'),
	('R_ACTNMO', 'SBO:0000200'),
	('R_ACYP', 'SBO:0000376'),
	('R_ACt2m', 'SBO:0000659'),
	('R_ACGALFUCGALACGALFUC12GAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_ACGALFUCGALACGALFUCGALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_ACGALFUCGALACGALFUCGALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_ACGALK', 'SBO:0000216'),
	('R_ACt2r', 'SBO:0000659'),
	('R_ACtg', 'SBO:0000658'),
	('R_ADA', 'SBO:0000401'),
	('R_ACGALK2', 'SBO:0000216'),
	('R_ACGALtlg', 'SBO:0000658'),
	('R_ADAe', 'SBO:0000401'),
	('R_ADCim', 'SBO:0000399'),
	('R_ACGALtly', 'SBO:0000658'),
	('R_ACGAM2E', 'SBO:0000377'),
	('R_ACGAM6PS', 'SBO:0000215'),
	('R_ADEt', 'SBO:0000658'),
	('R_ADEtl', 'SBO:0000658'),
	('R_ADHAPtx', 'SBO:0000658'),
	('R_ACGAMK', 'SBO:0000216'),
	('R_ACGAMPM', 'SBO:0000377'),
	('R_ACGAMtly', 'SBO:0000658'),
	('R_ACGBGBSIDEtg', 'SBO:0000658'),
	('R_ADK1m', 'SBO:0000216'),
	('R_ADK3', 'SBO:0000216'),
	('R_ADK3m', 'SBO:0000216'),
	('R_ACGBGBSIDEtl', 'SBO:0000658'),
	('R_ACGPID', 'SBO:0000376'),
	('R_ADMDC', 'SBO:0000399'),
	('R_ADNCYC', 'SBO:0000178'),
	('R_ACGSm', 'SBO:0000215'),
	('R_ACHVESSEC', 'SBO:0000657'),
	('R_ACHtn', 'SBO:0000658'),
	('R_ADNK1m', 'SBO:0000216'),
	('R_ADNt', 'SBO:0000658'),
	('R_ADNt4', 'SBO:0000659'),
	('R_ADNt5', 'SBO:0000659'),
	('R_ADNtl', 'SBO:0000658'),
	('R_ADNtm', 'SBO:0000658'),
	('R_ACN13ACNGALGBSIDEte', 'SBO:0000658'),
	('R_ACN13ACNGALGBSIDEtg', 'SBO:0000658'),
	('R_ACN23ACNGALGBSIDEte', 'SBO:0000658'),
	('R_ADPMAN', 'SBO:0000376'),
	('R_ADPRDP', 'SBO:0000376'),
	('R_ADPRDPm', 'SBO:0000376'),
	('R_ADPRIBt', 'SBO:0000658'),
	('R_ADPtx', 'SBO:0000658'),
	('R_ACN23ACNGALGBSIDEtg', 'SBO:0000658'),
	('R_ACNACNGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_ACNACNGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_ADRNCOAtx', 'SBO:0000658'),
	('R_ACNACNGALGBSIDEte', 'SBO:0000658'),
	('R_ACNACNGALGBSIDEtg', 'SBO:0000658'),
	('R_ACNAM9PL', 'SBO:0000402'),
	('R_ADRNCRNt', 'SBO:0000658'),
	('R_ACNAMPH', 'SBO:0000376'),
	('R_ACNAMlt', 'SBO:0000659'),
	('R_ADRNLPVESSEC', 'SBO:0000657'),
	('R_ADRNt', 'SBO:0000658'),
	('R_ADSELK', 'SBO:0000216'),
	('R_ACNAMtn', 'SBO:0000658'),
	('R_ACNGALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_ACNGALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_ACNML', 'SBO:0000178'),
	('R_ACOAD10m', 'SBO:0000200'),
	('R_ACOAD1fm', 'SBO:0000200'),
	('R_AFLATOXINte', 'SBO:0000658'),
	('R_AGLPED', 'SBO:0000200'),
	('R_AGLPR', 'SBO:0000200'),
	('R_AHCYStn', 'SBO:0000658'),
	('R_AGMTm', 'SBO:0000376'),
	('R_AHCYStr', 'SBO:0000658'),
	('R_AIRCr', 'SBO:0000399'),
	('R_AGPRim', 'SBO:0000200'),
	('R_AKGDm', 'SBO:0000399'),
	('R_AGPex', 'SBO:0000658'),
	('R_ALDD2xm', 'SBO:0000200'),
	('R_ALDD2y', 'SBO:0000200'),
	('R_AKGMALtm', 'SBO:0000660'),
	('R_AKGt4_3', 'SBO:0000659'),
	('R_AKGtp', 'SBO:0000658'),
	('R_AKR1C1', 'SBO:0000200'),
	('R_ALDSTRNte', 'SBO:0000658'),
	('R_ALDSTRNtm', 'SBO:0000658'),
	('R_AGTim', 'SBO:0000403'),
	('R_AKR1C41', 'SBO:0000200'),
	('R_AKR1C42', 'SBO:0000200'),
	('R_AKR1D', 'SBO:0000200'),
	('R_AGTix', 'SBO:0000403'),
	('R_AKR1D2', 'SBO:0000200'),
	('R_ALAASNNaEx', 'SBO:0000660'),
	('R_ALOX12R', 'SBO:0000200'),
	('R_ALOX15', 'SBO:0000200'),
	('R_ALOX5', 'SBO:0000200'),
	('R_ALACYSNaEx', 'SBO:0000660'),
	('R_AHANDROSTANGLCte', 'SBO:0000657'),
	('R_ALADGLNexR', 'SBO:0000660'),
	('R_ALADGLYexR', 'SBO:0000660'),
	('R_ALAGLNNaEx', 'SBO:0000660'),
	('R_ALOX52', 'SBO:0000200'),
	('R_ALR', 'SBO:0000200'),
	('R_ALAGLNexR', 'SBO:0000660'),
	('R_AHANDROSTANGLCtr', 'SBO:0000658'),
	('R_ALAGLYexR', 'SBO:0000660'),
	('R_AHCi', 'SBO:0000376'),
	('R_ALASERNaEx', 'SBO:0000660'),
	('R_ALASm', 'SBO:0000402'),
	('R_ALATA_L', 'SBO:0000403'),
	('R_ALATHRNaEx', 'SBO:0000660'),
	('R_ALAt2rL', 'SBO:0000659'),
	('R_AM6SAD', 'SBO:0000200'),
	('R_AMCOXO', 'SBO:0000200'),
	('R_AMETr', 'SBO:0000658'),
	('R_ALAt4', 'SBO:0000659'),
	('R_ALAtN1', 'SBO:0000660'),
	('R_ARGNm', 'SBO:0000376'),
	('R_ALCD21_D', 'SBO:0000200'),
	('R_AMETt2m', 'SBO:0000660'),
	('R_AMETtn', 'SBO:0000658'),
	('R_AMPDA', 'SBO:0000401'),
	('R_AMPtp', 'SBO:0000658'),
	('R_AMPtr', 'SBO:0000658'),
	('R_ALCD22_D', 'SBO:0000200'),
	('R_ALCD22_L', 'SBO:0000200'),
	('R_ANDRSTRNGLCte', 'SBO:0000657'),
	('R_ANDRSTRNte', 'SBO:0000658'),
	('R_ANDRSTRNtr', 'SBO:0000658'),
	('R_ANTIPYRENEte', 'SBO:0000658'),
	('R_AOBUTDsm', 'SBO:0000200'),
	('R_ALDD19xr', 'SBO:0000200'),
	('R_ALDD19x_P', 'SBO:0000200'),
	('R_APNNOXte', 'SBO:0000658'),
	('R_ALDD20x', 'SBO:0000200'),
	('R_ALDD20xm', 'SBO:0000200'),
	('R_APPNNte', 'SBO:0000658'),
	('R_ALDD21', 'SBO:0000200'),
	('R_APRGSTRNte', 'SBO:0000658'),
	('R_APRTO2', 'SBO:0000200'),
	('R_AQCOBALt', 'SBO:0000658'),
	('R_ARABR', 'SBO:0000200'),
	('R_ARAB_Lt', 'SBO:0000658'),
	('R_ATPH1e', 'SBO:0000376'),
	('R_ARACHCOAtx', 'SBO:0000658'),
	('R_ARGt4', 'SBO:0000659'),
	('R_ATPS4m', 'SBO:0000376'),
	('R_ATPasel', 'SBO:0000376'),
	('R_ATPtm', 'SBO:0000660'),
	('R_ATPtn', 'SBO:0000657'),
	('R_ATPtx', 'SBO:0000657'),
	('R_AVITE1t', 'SBO:0000658'),
	('R_AVITE2t', 'SBO:0000658'),
	('R_BAAT1x', 'SBO:0000402'),
	('R_BAAT2x', 'SBO:0000402'),
	('R_BAAT3x', 'SBO:0000402'),
	('R_BAAT4x', 'SBO:0000402'),
	('R_BAAT5x', 'SBO:0000402'),
	('R_BALAVECSEC', 'SBO:0000657'),
	('R_BALAtmr', 'SBO:0000658'),
	('R_BAMPPALDOX', 'SBO:0000200'),
	('R_BAMPPALDOXm', 'SBO:0000200'),
	('R_BBHOX', 'SBO:0000200'),
	('R_BDG2HCGHD', 'SBO:0000376'),
	('R_BDHm', 'SBO:0000200'),
	('R_BETALDHxm', 'SBO:0000200'),
	('R_BHBt', 'SBO:0000659'),
	('R_BHBtm', 'SBO:0000659'),
	('R_BHMT', 'SBO:0000214'),
	('R_BILDGLCURt', 'SBO:0000660'),
	('R_BILDGLCURte', 'SBO:0000657'),
	('R_BILDGLCURtr', 'SBO:0000658'),
	('R_BILGLCURt', 'SBO:0000660'),
	('R_BILGLCURte', 'SBO:0000657'),
	('R_BILGLCURtr', 'SBO:0000658'),
	('R_BILIRED', 'SBO:0000200'),
	('R_CAt7r', 'SBO:0000660'),
	('R_CBL2OR', 'SBO:0000200'),
	('R_CBL2tm', 'SBO:0000658'),
	('R_CBLATm', 'SBO:0000402'),
	('R_CBPPer', 'SBO:0000399'),
	('R_CBPter', 'SBO:0000659'),
	('R_CBR1', 'SBO:0000200'),
	('R_CBR2', 'SBO:0000200'),
	('R_CCA_D3t', 'SBO:0000658'),
	('R_CCA_D3tm', 'SBO:0000658'),
	('R_CDPDAGtm', 'SBO:0000658'),
	('R_CEPTE', 'SBO:0000402'),
	('R_CERK', 'SBO:0000216'),
	('R_CERT1gt', 'SBO:0000658'),
	('R_CERT1rt', 'SBO:0000658'),
	('R_CERT2gt', 'SBO:0000658'),
	('R_CERT2rt', 'SBO:0000658'),
	('R_CGLYt3_2', 'SBO:0000659'),
	('R_CGMPt', 'SBO:0000657'),
	('R_CH25H', 'SBO:0000200'),
	('R_CHAT', 'SBO:0000215'),
	('R_CHATn', 'SBO:0000215'),
	('R_CHLP', 'SBO:0000376'),
	('R_CHLPCTD', 'SBO:0000402'),
	('R_CHLtm', 'SBO:0000658'),
	('R_CHOLATEt', 'SBO:0000660'),
	('R_CHOLATEt2', 'SBO:0000659'),
	('R_CHOLATEt3', 'SBO:0000657'),
	('R_CHOLD2m', 'SBO:0000200'),
	('R_CHOLK', 'SBO:0000216'),
	('R_CHOLPtg', 'SBO:0000658'),
	('R_CHOLPtl', 'SBO:0000658'),
	('R_CHOLt4', 'SBO:0000659'),
	('R_CHOLtg', 'SBO:0000658'),
	('R_CHOLtn', 'SBO:0000658'),
	('R_CHOLtr', 'SBO:0000658'),
	('R_CHOLtu', 'SBO:0000658'),
	('R_CHSTEROLSULT', 'SBO:0000220'),
	('R_CHSTEROLt', 'SBO:0000657'),
	('R_CHSTEROLt1', 'SBO:0000658'),
	('R_CHSTEROLt2', 'SBO:0000658'),
	('R_CHSTEROLt3', 'SBO:0000658'),
	('R_CHSTEROLtg', 'SBO:0000657'),
	('R_CITL', 'SBO:0000178'),
	('R_CITMCOAHm', 'SBO:0000178'),
	('R_CITMCOALm', 'SBO:0000178'),
	('R_CITRtm', 'SBO:0000658'),
	('R_CITt4_2', 'SBO:0000659'),
	('R_CITt4_4', 'SBO:0000659'),
	('R_CITtam', 'SBO:0000660'),
	('R_CITtbm', 'SBO:0000660'),
	('R_CK', 'SBO:0000216'),
	('R_CKc', 'SBO:0000216'),
	('R_CLFORtex', 'SBO:0000660'),
	('R_CSNATer', 'SBO:0000215'),
	('R_CSNATm', 'SBO:0000215'),
	('R_CSNATp', 'SBO:0000215'),
	('R_CSNATr', 'SBO:0000215'),
	('R_CSND', 'SBO:0000401'),
	('R_CSNt', 'SBO:0000658'),
	('R_CSPG_At', 'SBO:0000658'),
	('R_CSPG_Atly', 'SBO:0000658'),
	('R_CSPG_Bt', 'SBO:0000658'),
	('R_CSPG_Btly', 'SBO:0000658'),
	('R_CSPG_Ct', 'SBO:0000658'),
	('R_CSPG_Ctly', 'SBO:0000658'),
	('R_CSPG_Dt', 'SBO:0000658'),
	('R_CSPG_Dtly', 'SBO:0000658'),
	('R_CSPG_Et', 'SBO:0000658'),
	('R_CSPG_Etly', 'SBO:0000658'),
	('R_CTPtn', 'SBO:0000658'),
	('R_CYANSTm', 'SBO:0000402'),
	('R_CYANt', 'SBO:0000658'),
	('R_CYANtm', 'SBO:0000658'),
	('R_CYSALANaEx', 'SBO:0000660'),
	('R_CYSAMO', 'SBO:0000200'),
	('R_CYSASNNaEx', 'SBO:0000660'),
	('R_CYSGLNNaEx', 'SBO:0000660'),
	('R_CYSGLTH', 'SBO:0000200'),
	('R_CYSGLUexR', 'SBO:0000660'),
	('R_CYSGLYex_copy1', 'SBO:0000660'),
	('R_CYSGLYex_copy2', 'SBO:0000660'),
	('R_CYSLYSL', 'SBO:0000401'),
	('R_CYSO', 'SBO:0000200'),
	('R_CYSSERNaEx', 'SBO:0000660'),
	('R_CYSTGL', 'SBO:0000178'),
	('R_CYSTGLUex', 'SBO:0000660'),
	('R_CYSTHRNaEx', 'SBO:0000660'),
	('R_CYSTS', 'SBO:0000178'),
	('R_CYSTSERex', 'SBO:0000660'),
	('R_CYSt4', 'SBO:0000659'),
	('R_CYStec', 'SBO:0000658'),
	('R_CYTDK2m', 'SBO:0000216'),
	('R_CYTDn', 'SBO:0000401'),
	('R_CYTDt', 'SBO:0000658'),
	('R_CYTDt5', 'SBO:0000659'),
	('R_CYTDtl', 'SBO:0000658'),
	('R_CYTDtm', 'SBO:0000658'),
	('R_CYTDtn', 'SBO:0000658'),
	('R_CYTK10', 'SBO:0000216'),
	('R_CYTK10n', 'SBO:0000216'),
	('R_CYTK11', 'SBO:0000216'),
	('R_CYTK11n', 'SBO:0000216'),
	('R_CYTK12', 'SBO:0000216'),
	('R_CYTK12n', 'SBO:0000216'),
	('R_CYTK13', 'SBO:0000216'),
	('R_CYTK13n', 'SBO:0000216'),
	('R_DIGALSIDEtg', 'SBO:0000658'),
	('R_DIGALSIDEtl', 'SBO:0000658'),
	('R_DINt', 'SBO:0000658'),
	('R_DITPtn', 'SBO:0000658'),
	('R_DLNLCGCRNt', 'SBO:0000658'),
	('R_DLNLCGt', 'SBO:0000658'),
	('R_DMANTIPYRINEte', 'SBO:0000658'),
	('R_DMATTx', 'SBO:0000402'),
	('R_DMGDHm', 'SBO:0000200'),
	('R_DMGtm', 'SBO:0000658'),
	('R_DMHPTCRNt', 'SBO:0000658'),
	('R_DMHPTCRNte', 'SBO:0000658'),
	('R_DM_13_cis_oretn_n', 'SBO:0000628'),
	('R_DM_13_cis_retn_n', 'SBO:0000628'),
	('R_DM_Asn_X_Ser_Thr_l', 'SBO:0000628'),
	('R_DM_Ser_Thr_l', 'SBO:0000628'),
	('R_DM_Ser_Gly_Ala_X_Gly_l', 'SBO:0000628'),
	('R_DM_avite1_c', 'SBO:0000628'),
	('R_DM_avite2_c', 'SBO:0000628'),
	('R_DM_bvite_c', 'SBO:0000628'),
	('R_DM_datp_m', 'SBO:0000628'),
	('R_DM_datp_n', 'SBO:0000628'),
	('R_DM_dctp_m', 'SBO:0000628'),
	('R_DM_dctp_n', 'SBO:0000628'),
	('R_DM_dgtp_m', 'SBO:0000628'),
	('R_DM_dgtp_n', 'SBO:0000628'),
	('R_DM_dsT_antigen_g', 'SBO:0000628'),
	('R_DM_dttp_m', 'SBO:0000628'),
	('R_DM_dttp_n', 'SBO:0000628'),
	('R_DM_ethamp_r', 'SBO:0000628'),
	('R_DM_gpi_sig_r', 'SBO:0000628'),
	('R_DM_hretn_n', 'SBO:0000628'),
	('R_DM_kdn_c', 'SBO:0000628'),
	('R_DM_melanin_c', 'SBO:0000628'),
	('R_DM_oretn_n', 'SBO:0000628'),
	('R_DM_sTn_antigen_g', 'SBO:0000628'),
	('R_DM_sprm_c', 'SBO:0000628'),
	('R_DM_yvite_c', 'SBO:0000628'),
	('R_DNADtn', 'SBO:0000658'),
	('R_DNAMTn', 'SBO:0000214'),
	('R_DNDPt10m', 'SBO:0000660'),
	('R_DNDPt11m', 'SBO:0000660'),
	('R_DNDPt12m', 'SBO:0000660'),
	('R_DNDPt13m', 'SBO:0000660'),
	('R_DNDPt14m', 'SBO:0000660'),
	('R_DNDPt15m', 'SBO:0000660'),
	('R_DNDPt16m', 'SBO:0000660'),
	('R_DNDPt17m', 'SBO:0000660'),
	('R_DNDPt18m', 'SBO:0000660'),
	('R_DNDPt19m', 'SBO:0000660'),
	('R_DNDPt1m', 'SBO:0000660'),
	('R_DNDPt20m', 'SBO:0000660'),
	('R_DNDPt21m', 'SBO:0000660'),
	('R_DNDPt22m', 'SBO:0000660'),
	('R_DNDPt23m', 'SBO:0000660'),
	('R_DNDPt24m', 'SBO:0000660'),
	('R_DNDPt25m', 'SBO:0000660'),
	('R_DNDPt26m', 'SBO:0000660'),
	('R_DNDPt27m', 'SBO:0000660'),
	('R_DNDPt28m', 'SBO:0000660'),
	('R_DNDPt29m', 'SBO:0000660'),
	('R_DNDPt2m', 'SBO:0000660'),
	('R_ARACHCRNt', 'SBO:0000658'),
	('R_ARACHDCOAtx', 'SBO:0000658'),
	('R_ARACHDt2', 'SBO:0000658'),
	('R_ARACHDtr', 'SBO:0000658'),
	('R_ARACHt', 'SBO:0000658'),
	('R_ARGDCm', 'SBO:0000399'),
	('R_ARGLYSex', 'SBO:0000660'),
	('R_ARGN', 'SBO:0000376'),
	('R_DCK1m', 'SBO:0000216'),
	('R_BILIRUBt2', 'SBO:0000660'),
	('R_BILIRUBtr', 'SBO:0000658'),
	('R_BIOCYTtn', 'SBO:0000658'),
	('R_BPNT2', 'SBO:0000376'),
	('R_BTND1', 'SBO:0000376'),
	('R_BTND1n', 'SBO:0000376'),
	('R_BTNDe', 'SBO:0000376'),
	('R_BTNDm', 'SBO:0000376'),
	('R_BTNt2i', 'SBO:0000659'),
	('R_BTNt2m', 'SBO:0000659'),
	('R_BTNt3i', 'SBO:0000657'),
	('R_BTNt4i', 'SBO:0000660'),
	('R_BTNtn', 'SBO:0000658'),
	('R_BUP2', 'SBO:0000401'),
	('R_BUTt2m', 'SBO:0000659'),
	('R_BUTt2r', 'SBO:0000659'),
	('R_BVITEt', 'SBO:0000658'),
	('R_BZt', 'SBO:0000658'),
	('R_BZtr', 'SBO:0000658'),
	('R_C14STRr', 'SBO:0000200'),
	('R_C160CPT1', 'SBO:0000218'),
	('R_C160CPT2', 'SBO:0000218'),
	('R_C160CRNt', 'SBO:0000658'),
	('R_C161CRN2t', 'SBO:0000658'),
	('R_C161CRNt', 'SBO:0000658'),
	('R_C180CRNt', 'SBO:0000658'),
	('R_C181CRNt', 'SBO:0000658'),
	('R_C204CRNt', 'SBO:0000658'),
	('R_C226COAtx', 'SBO:0000658'),
	('R_C226CRNt', 'SBO:0000658'),
	('R_C2M26DCOAHLm', 'SBO:0000178'),
	('R_C2M26DCOAHLx', 'SBO:0000178'),
	('R_C3STDH1Pr', 'SBO:0000399'),
	('R_C3STDH1r', 'SBO:0000377'),
	('R_C3STKR2r', 'SBO:0000200'),
	('R_C4STMO1r', 'SBO:0000200'),
	('R_C4STMO2Pr', 'SBO:0000399'),
	('R_C4STMO2r', 'SBO:0000399'),
	('R_CAATPS', 'SBO:0000657'),
	('R_CAMPt', 'SBO:0000657'),
	('R_CAROtr', 'SBO:0000658'),
	('R_CARVEOLte', 'SBO:0000658'),
	('R_CAT2p', 'SBO:0000200'),
	('R_CLFORtex2', 'SBO:0000660'),
	('R_CLHCO3tex2', 'SBO:0000660'),
	('R_CLHCOtex', 'SBO:0000660'),
	('R_CLI2tex', 'SBO:0000660'),
	('R_CLOHtex2', 'SBO:0000660'),
	('R_CLOXAtex2', 'SBO:0000660'),
	('R_CLPNDCOAtx', 'SBO:0000658'),
	('R_CLPNDCRNt', 'SBO:0000658'),
	('R_CLPNDt', 'SBO:0000658'),
	('R_CMPACNAtg', 'SBO:0000660'),
	('R_CMPACNAtn', 'SBO:0000658'),
	('R_ACNMCT', 'SBO:0000402'),
	('R_CMPSASn', 'SBO:0000402'),
	('R_CO2ter', 'SBO:0000658'),
	('R_CO2tg', 'SBO:0000658'),
	('R_CO2tm', 'SBO:0000658'),
	('R_CO2tn', 'SBO:0000658'),
	('R_CO2tp', 'SBO:0000658'),
	('R_COAtl', 'SBO:0000658'),
	('R_COAtim', 'SBO:0000658'),
	('R_COAtn', 'SBO:0000658'),
	('R_COAtp', 'SBO:0000658'),
	('R_COAtr', 'SBO:0000658'),
	('R_COKECBESr', 'SBO:0000376'),
	('R_COQ7m', 'SBO:0000200'),
	('R_CORE2GTg', 'SBO:0000217'),
	('R_CORE3GTg', 'SBO:0000217'),
	('R_CORE4GTg', 'SBO:0000217'),
	('R_COUMARINte', 'SBO:0000658'),
	('R_COt', 'SBO:0000658'),
	('R_CPCTDTX', 'SBO:0000402'),
	('R_CREATt4_2_r', 'SBO:0000659'),
	('R_CREATtmdiffir', 'SBO:0000658'),
	('R_CRMPte', 'SBO:0000658'),
	('R_CRNCAR3tp', 'SBO:0000660'),
	('R_CRNCARtp', 'SBO:0000660'),
	('R_CRNt_copy1', 'SBO:0000658'),
	('R_CRNtHa', 'SBO:0000660'),
	('R_CRNtim', 'SBO:0000658'),
	('R_CRNt_copy2', 'SBO:0000658'),
	('R_CRNtuNa', 'SBO:0000659'),
	('R_CRNtx', 'SBO:0000658'),
	('R_CRTSLtm', 'SBO:0000658'),
	('R_CRTSLtr', 'SBO:0000658'),
	('R_CRTSTRNtm', 'SBO:0000658'),
	('R_CRTSTRNtr', 'SBO:0000658'),
	('R_CRVNCtr', 'SBO:0000658'),
	('R_DCK1n', 'SBO:0000216'),
	('R_DCK2n', 'SBO:0000216'),
	('R_DCSPTN1COAtx', 'SBO:0000658'),
	('R_DCSPTN1CRNt', 'SBO:0000658'),
	('R_DCSPTN1t', 'SBO:0000658'),
	('R_DCT', 'SBO:0000377'),
	('R_DCTPtn', 'SBO:0000658'),
	('R_DCYTD', 'SBO:0000401'),
	('R_DCYTDn', 'SBO:0000401'),
	('R_DCYTt', 'SBO:0000658'),
	('R_DEBRISOQUINEt', 'SBO:0000658'),
	('R_DECDPtm', 'SBO:0000658'),
	('R_DEDOLR_L', 'SBO:0000200'),
	('R_DEDOLR_U', 'SBO:0000200'),
	('R_DESAT16_2', 'SBO:0000200'),
	('R_DESAT18_10', 'SBO:0000200'),
	('R_DESAT18_3', 'SBO:0000200'),
	('R_DESAT18_4', 'SBO:0000200'),
	('R_DESAT18_5', 'SBO:0000200'),
	('R_DESAT18_6', 'SBO:0000200'),
	('R_DESAT18_7', 'SBO:0000200'),
	('R_DESAT18_8', 'SBO:0000200'),
	('R_DESAT18_9', 'SBO:0000200'),
	('R_DESAT20_1', 'SBO:0000200'),
	('R_DESAT20_2', 'SBO:0000200'),
	('R_DESAT22_1p', 'SBO:0000200'),
	('R_DESAT22_2p', 'SBO:0000200'),
	('R_DESAT24_1', 'SBO:0000200'),
	('R_DGCHOLte', 'SBO:0000658'),
	('R_DGCHOLtx', 'SBO:0000658'),
	('R_DGK2m', 'SBO:0000216'),
	('R_DGNSKm', 'SBO:0000216'),
	('R_DGSNt', 'SBO:0000658'),
	('R_DGSNtm', 'SBO:0000658'),
	('R_DGTPtn', 'SBO:0000658'),
	('R_DGULND', 'SBO:0000399'),
	('R_DHAAt1r', 'SBO:0000658'),
	('R_DHCHOLESTANATEtm', 'SBO:0000658'),
	('R_DHCR241r', 'SBO:0000200'),
	('R_DHCR242r', 'SBO:0000200'),
	('R_DHCR243r', 'SBO:0000200'),
	('R_DHCR71r', 'SBO:0000200'),
	('R_DHCR72r', 'SBO:0000200'),
	('R_DHCRD1', 'SBO:0000200'),
	('R_DHCRD2', 'SBO:0000200'),
	('R_DHEASt', 'SBO:0000660'),
	('R_DHEAStr', 'SBO:0000658'),
	('R_DHFtl', 'SBO:0000658'),
	('R_DHFtm', 'SBO:0000658'),
	('R_DHORD9', 'SBO:0000660'),
	('R_DHPM1', 'SBO:0000376'),
	('R_DHPM2', 'SBO:0000376'),
	('R_DHPR', 'SBO:0000200'),
	('R_DIDPtn', 'SBO:0000658'),
	('R_DIGALSGALSIDEte', 'SBO:0000658'),
	('R_DIGALSGALSIDEtg', 'SBO:0000658'),
	('R_DNDPt30m', 'SBO:0000660'),
	('R_DNDPt31m', 'SBO:0000660'),
	('R_DNDPt32m', 'SBO:0000660'),
	('R_DNDPt33m', 'SBO:0000660'),
	('R_DNDPt34m', 'SBO:0000660'),
	('R_DNDPt35m', 'SBO:0000660'),
	('R_DNDPt36m', 'SBO:0000660'),
	('R_DNDPt37m', 'SBO:0000660'),
	('R_DNDPt38m', 'SBO:0000660'),
	('R_DNDPt39m', 'SBO:0000660'),
	('R_DNDPt3m', 'SBO:0000660'),
	('R_DNDPt40m', 'SBO:0000660'),
	('R_DNDPt41m', 'SBO:0000660'),
	('R_DNDPt42m', 'SBO:0000660'),
	('R_DNDPt43m', 'SBO:0000660'),
	('R_DNDPt44m', 'SBO:0000660'),
	('R_DNDPt45m', 'SBO:0000660'),
	('R_DNDPt46m', 'SBO:0000660'),
	('R_DNDPt47m', 'SBO:0000660'),
	('R_DNDPt48m', 'SBO:0000660'),
	('R_DNDPt49m', 'SBO:0000660'),
	('R_DNDPt4m', 'SBO:0000660'),
	('R_DNDPt50m', 'SBO:0000660'),
	('R_DNDPt51m', 'SBO:0000660'),
	('R_DNDPt52m', 'SBO:0000660'),
	('R_DNDPt53m', 'SBO:0000660'),
	('R_DNDPt54m', 'SBO:0000660'),
	('R_DNDPt55m', 'SBO:0000660'),
	('R_DNDPt56m', 'SBO:0000660'),
	('R_DNDPt57m', 'SBO:0000660'),
	('R_DNDPt58m', 'SBO:0000660'),
	('R_DNDPt59m', 'SBO:0000660'),
	('R_DNDPt5m', 'SBO:0000660'),
	('R_DNDPt60m', 'SBO:0000660'),
	('R_DNDPt61m', 'SBO:0000660'),
	('R_DNDPt62m', 'SBO:0000660'),
	('R_DNDPt63m', 'SBO:0000660'),
	('R_DNDPt6m', 'SBO:0000660'),
	('R_DNDPt7m', 'SBO:0000660'),
	('R_DNDPt8m', 'SBO:0000660'),
	('R_DNDPt9m', 'SBO:0000660'),
	('R_DOGULND1', 'SBO:0000399'),
	('R_DOGULND2', 'SBO:0000399'),
	('R_DOLGLCP_Lter', 'SBO:0000658'),
	('R_DOLGLCP_Uter', 'SBO:0000658'),
	('R_DOLICHOL_Lter', 'SBO:0000658'),
	('R_DOLICHOL_Uter', 'SBO:0000658'),
	('R_DOLK_L', 'SBO:0000216'),
	('R_DOLK_U', 'SBO:0000216'),
	('R_DOLMANP_Lter', 'SBO:0000658'),
	('R_DOLMANP_Uter', 'SBO:0000658'),
	('R_EHGLATm', 'SBO:0000403'),
	('R_EICOSTETCRNt', 'SBO:0000658'),
	('R_EICOSTETt', 'SBO:0000658'),
	('R_ELAIDCRNt', 'SBO:0000658'),
	('R_ELAIDt', 'SBO:0000658'),
	('R_EPCTX', 'SBO:0000402'),
	('R_ESTRADIOLGLCt', 'SBO:0000660'),
	('R_ESTRADIOLGLCt2', 'SBO:0000657'),
	('R_ESTRADIOLGLCtr', 'SBO:0000658'),
	('R_ESTRADIOLtr', 'SBO:0000658'),
	('R_ESTRIOLGLCte', 'SBO:0000657'),
	('R_ESTRIOLGLCtr', 'SBO:0000658'),
	('R_ESTRIOLtr', 'SBO:0000658'),
	('R_ESTRONEGLCt', 'SBO:0000657'),
	('R_ESTRONEGLCtr', 'SBO:0000658'),
	('R_ESTRONESt', 'SBO:0000660'),
	('R_ESTRONESt2', 'SBO:0000659'),
	('R_ESTRONEtr', 'SBO:0000658'),
	('R_ESTSULT', 'SBO:0000220'),
	('R_ETF', 'SBO:0000200'),
	('R_ETHAK', 'SBO:0000216'),
	('R_ETHP', 'SBO:0000376'),
	('R_ETOHMO', 'SBO:0000200'),
	('R_ETOHt', 'SBO:0000658'),
	('R_ETOHtx', 'SBO:0000658'),
	('R_EX_10fthf5glu_e', 'SBO:0000627'),
	('R_EX_10fthf6glu_e', 'SBO:0000627'),
	('R_EX_10fthf7glu_e', 'SBO:0000627'),
	('R_EX_10fthf_e', 'SBO:0000627'),
	('R_EX_11_cis_retfa_e', 'SBO:0000627'),
	('R_EX_13_cis_retnglc_e', 'SBO:0000627'),
	('R_EX_1glyc_hs_e', 'SBO:0000627'),
	('R_EX_1mncam_e', 'SBO:0000627'),
	('R_EX_2425dhvitd2_e', 'SBO:0000627'),
	('R_EX_2425dhvitd3_e', 'SBO:0000627'),
	('R_EX_24nph_e', 'SBO:0000627'),
	('R_EX_25hvitd2_e', 'SBO:0000627'),
	('R_EX_25hvitd3_e', 'SBO:0000627'),
	('R_EX_2hb_e', 'SBO:0000627'),
	('R_EX_2mcit_e', 'SBO:0000627'),
	('R_EX_34dhoxpeg_e', 'SBO:0000627'),
	('R_EX_34dhphe_e', 'SBO:0000627'),
	('R_EX_35cgmp_e', 'SBO:0000627'),
	('R_EX_3aib__D_e', 'SBO:0000627'),
	('R_EX_3aib_e', 'SBO:0000627'),
	('R_EX_3mlda_e', 'SBO:0000627'),
	('R_EX_4hdebrisoquine_e', 'SBO:0000627'),
	('R_EX_4mtolbutamide_e', 'SBO:0000627'),
	('R_EX_4nph_e', 'SBO:0000627'),
	('R_DOLP_Lter', 'SBO:0000658'),
	('R_DOLP_Uter', 'SBO:0000658'),
	('R_DOPABMO', 'SBO:0000200'),
	('R_DOPAMT', 'SBO:0000214'),
	('R_DOPASFt', 'SBO:0000658'),
	('R_DOPASULT', 'SBO:0000220'),
	('R_DOPAVESSEC', 'SBO:0000657'),
	('R_DOPAt4_2_r', 'SBO:0000659'),
	('R_DOPAtu', 'SBO:0000658'),
	('R_DORNOp', 'SBO:0000200'),
	('R_DPCOAPP', 'SBO:0000376'),
	('R_DPCOAtl', 'SBO:0000658'),
	('R_DPGM', 'SBO:0000377'),
	('R_DPHMBDCm', 'SBO:0000399'),
	('R_DPMVDx', 'SBO:0000399'),
	('R_DPROOp', 'SBO:0000200'),
	('R_DRIBt', 'SBO:0000658'),
	('R_DTDPtn', 'SBO:0000658'),
	('R_DTTPtn', 'SBO:0000658'),
	('R_DUDPtn', 'SBO:0000658'),
	('R_DUMPtn', 'SBO:0000658'),
	('R_DURAD', 'SBO:0000200'),
	('R_DURAD2', 'SBO:0000200'),
	('R_DURIK1m', 'SBO:0000216'),
	('R_DURIt', 'SBO:0000658'),
	('R_DURItn', 'SBO:0000658'),
	('R_D_3AIBt', 'SBO:0000658'),
	('R_D_LACt2', 'SBO:0000659'),
	('R_D_LACtm', 'SBO:0000659'),
	('R_EAFLATOXINte', 'SBO:0000658'),
	('R_EBASTINEOHte', 'SBO:0000658'),
	('R_EBASTINEOHtr', 'SBO:0000658'),
	('R_EBASTINEte', 'SBO:0000658'),
	('R_EBASTINEtr', 'SBO:0000658'),
	('R_EBP1r', 'SBO:0000377'),
	('R_EBP2r', 'SBO:0000377'),
	('R_ECGISOr', 'SBO:0000377'),
	('R_ECOAH12m', 'SBO:0000178'),
	('R_ECOAH9m', 'SBO:0000178'),
	('R_EGMESTr', 'SBO:0000376'),
	('R_EHGLAT', 'SBO:0000403'),
	('R_EX_4nphsf_e', 'SBO:0000627'),
	('R_EX_4pyrdx_e', 'SBO:0000627'),
	('R_EX_5adtststerone_e', 'SBO:0000627'),
	('R_EX_5adtststeroneglc_e', 'SBO:0000627'),
	('R_EX_5adtststerones_e', 'SBO:0000627'),
	('R_EX_5dhf_e', 'SBO:0000627'),
	('R_EX_5fthf_e', 'SBO:0000627'),
	('R_EX_5homeprazole_e', 'SBO:0000627'),
	('R_EX_5htrp_e', 'SBO:0000627'),
	('R_EX_5mthf_e', 'SBO:0000627'),
	('R_EX_5thf_e', 'SBO:0000627'),
	('R_EX_6dhf_e', 'SBO:0000627'),
	('R_EX_6htststerone_e', 'SBO:0000627'),
	('R_EX_6thf_e', 'SBO:0000627'),
	('R_EX_7dhf_e', 'SBO:0000627'),
	('R_EX_7thf_e', 'SBO:0000627'),
	('R_EX_9_cis_retfa_e', 'SBO:0000627'),
	('R_EX_clpnd_e', 'SBO:0000627'),
	('R_EX_cysi__L_e', 'SBO:0000627'),
	('R_EX_Rtotal2_e', 'SBO:0000627'),
	('R_EX_Rtotal3_e', 'SBO:0000627'),
	('R_EX_Rtotal_e', 'SBO:0000627'),
	('R_EX_Tyr_ggn_e', 'SBO:0000627'),
	('R_EX_abt_e', 'SBO:0000627'),
	('R_EX_ac_e', 'SBO:0000627'),
	('R_EX_acac_e', 'SBO:0000627'),
	('R_EX_acetone_e', 'SBO:0000627'),
	('R_EX_acgalfucgalacgalfuc12gal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_acgalfucgalacgalfucgalacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_ach_e', 'SBO:0000627'),
	('R_EX_acn13acngalgbside_hs_e', 'SBO:0000627'),
	('R_EX_acn23acngalgbside_hs_e', 'SBO:0000627'),
	('R_EX_acnacngal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_acnacngalgbside_hs_e', 'SBO:0000627'),
	('R_EX_acngalacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_ade_e', 'SBO:0000627'),
	('R_EX_adp_e', 'SBO:0000627'),
	('R_EX_adprbp_e', 'SBO:0000627'),
	('R_EX_adprib_e', 'SBO:0000627'),
	('R_EX_adrn_e', 'SBO:0000627'),
	('R_EX_adrnl_e', 'SBO:0000627'),
	('R_EX_aflatoxin_e', 'SBO:0000627'),
	('R_EX_ahandrostanglc_e', 'SBO:0000627'),
	('R_EX_ak2lgchol_hs_e', 'SBO:0000627'),
	('R_EX_aldstrn_e', 'SBO:0000627'),
	('R_EX_amp_e', 'SBO:0000627'),
	('R_EX_andrstrn_e', 'SBO:0000627'),
	('R_EX_andrstrnglc_e', 'SBO:0000627'),
	('R_EX_antipyrene_e', 'SBO:0000627'),
	('R_EX_apnnox_e', 'SBO:0000627'),
	('R_EX_appnn_e', 'SBO:0000627'),
	('R_EX_aprgstrn_e', 'SBO:0000627'),
	('R_EX_aqcobal_e', 'SBO:0000627'),
	('R_EX_arach_e', 'SBO:0000627'),
	('R_EX_arachd_e', 'SBO:0000627'),
	('R_EX_ascb__L_e', 'SBO:0000627'),
	('R_EX_asn__L_e', 'SBO:0000627'),
	('R_EX_asp__D_e', 'SBO:0000627'),
	('R_EX_camp_e', 'SBO:0000627'),
	('R_EX_caro_e', 'SBO:0000627'),
	('R_EX_carveol_e', 'SBO:0000627'),
	('R_EX_cca_d3_e', 'SBO:0000627'),
	('R_EX_cholate_e', 'SBO:0000627'),
	('R_EX_chsterol_e', 'SBO:0000627'),
	('R_EX_chtn_e', 'SBO:0000627'),
	('R_EX_cmp_e', 'SBO:0000627'),
	('R_EX_co_e', 'SBO:0000627'),
	('R_EX_coumarin_e', 'SBO:0000627'),
	('R_EX_creat_e', 'SBO:0000627'),
	('R_EX_crmp_hs_e', 'SBO:0000627'),
	('R_EX_crvnc_e', 'SBO:0000627'),
	('R_EX_csn_e', 'SBO:0000627'),
	('R_EX_cspg_a_e', 'SBO:0000627'),
	('R_EX_cspg_b_e', 'SBO:0000627'),
	('R_EX_cspg_c_e', 'SBO:0000627'),
	('R_EX_cspg_d_e', 'SBO:0000627'),
	('R_EX_cspg_e_e', 'SBO:0000627'),
	('R_EX_cyan_e', 'SBO:0000627'),
	('R_EX_cys__L_e', 'SBO:0000627'),
	('R_EX_dad_2_e', 'SBO:0000627'),
	('R_EX_dad_5_e', 'SBO:0000627'),
	('R_EX_dag_hs_e', 'SBO:0000627'),
	('R_EX_dcsptn1_e', 'SBO:0000627'),
	('R_EX_dcyt_e', 'SBO:0000627'),
	('R_EX_debrisoquine_e', 'SBO:0000627'),
	('R_EX_dgchol_e', 'SBO:0000627'),
	('R_EX_dgsn_e', 'SBO:0000627'),
	('R_EX_dhdascb_e', 'SBO:0000627'),
	('R_EX_dheas_e', 'SBO:0000627'),
	('R_EX_dhf_e', 'SBO:0000627'),
	('R_EX_digalsgalside_hs_e', 'SBO:0000627'),
	('R_EX_din_e', 'SBO:0000627'),
	('R_EX_dlnlcg_e', 'SBO:0000627'),
	('R_EX_dmantipyrine_e', 'SBO:0000627'),
	('R_EX_dmhptcrn_e', 'SBO:0000627'),
	('R_EX_dopa_e', 'SBO:0000627'),
	('R_EX_dopasf_e', 'SBO:0000627'),
	('R_EX_atp_e', 'SBO:0000627'),
	('R_EX_avite1_e', 'SBO:0000627'),
	('R_EX_avite2_e', 'SBO:0000627'),
	('R_EX_bhb_e', 'SBO:0000627'),
	('R_EX_bildglcur_e', 'SBO:0000627'),
	('R_EX_bilglcur_e', 'SBO:0000627'),
	('R_EX_bilirub_e', 'SBO:0000627'),
	('R_EX_biocyt_e', 'SBO:0000627'),
	('R_EX_btn_e', 'SBO:0000627'),
	('R_EX_but_e', 'SBO:0000627'),
	('R_EX_bvite_e', 'SBO:0000627'),
	('R_EX_bz_e', 'SBO:0000627'),
	('R_EX_galgalfucfucgalacglcgalacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_galgalgalthcrm_hs_e', 'SBO:0000627'),
	('R_EX_gbside_hs_e', 'SBO:0000627'),
	('R_EX_gchola_e', 'SBO:0000627'),
	('R_EX_duri_e', 'SBO:0000627'),
	('R_EX_eaflatoxin_e', 'SBO:0000627'),
	('R_EX_ebastine_e', 'SBO:0000627'),
	('R_EX_ebastineoh_e', 'SBO:0000627'),
	('R_EX_eicostet_e', 'SBO:0000627'),
	('R_EX_elaid_e', 'SBO:0000627'),
	('R_EX_estradiolglc_e', 'SBO:0000627'),
	('R_EX_estriolglc_e', 'SBO:0000627'),
	('R_EX_estroneglc_e', 'SBO:0000627'),
	('R_EX_estrones_e', 'SBO:0000627'),
	('R_EX_gd1b2_hs_e', 'SBO:0000627'),
	('R_EX_gd1c_hs_e', 'SBO:0000627'),
	('R_EX_etoh_e', 'SBO:0000627'),
	('R_ARGt5r', 'SBO:0000658'),
	('R_EX_gdchola_e', 'SBO:0000627'),
	('R_EX_gdp_e', 'SBO:0000627'),
	('R_ARGtm', 'SBO:0000660'),
	('R_EX_fol_e', 'SBO:0000627'),
	('R_EX_fuc13galacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_gluala_e', 'SBO:0000627'),
	('R_EX_fuc14galacglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fuc__L_e', 'SBO:0000627'),
	('R_EX_fucacgalfucgalacglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fucacngal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fucacngalacglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_glyc__S_e', 'SBO:0000627'),
	('R_EX_glygn2_e', 'SBO:0000627'),
	('R_EX_fucfuc12gal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fucfuc132galacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fucfucfucgalacglc13galacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_glygn4_e', 'SBO:0000627'),
	('R_EX_glygn5_e', 'SBO:0000627'),
	('R_EX_gmp_e', 'SBO:0000627'),
	('R_EX_fucfucfucgalacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fucfucgalacglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fucgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_fucgalfucgalacglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_gp1c_hs_e', 'SBO:0000627'),
	('R_EX_gp1calpha_hs_e', 'SBO:0000627'),
	('R_EX_gq1b_hs_e', 'SBO:0000627'),
	('R_EX_gq1balpha_hs_e', 'SBO:0000627'),
	('R_EX_gt1a_hs_e', 'SBO:0000627'),
	('R_EX_gthox_e', 'SBO:0000627'),
	('R_EX_fucgalgbside_hs_e', 'SBO:0000627'),
	('R_EX_gal_e', 'SBO:0000627'),
	('R_EX_galacglcgalgbside_hs_e', 'SBO:0000627'),
	('R_EX_galfuc12gal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_galfucgalacglcgal14acglcgalgluside_hs_e', 'SBO:0000627'),
	('R_EX_gtp_e', 'SBO:0000627'),
	('R_EX_h2o2_e', 'SBO:0000627'),
	('R_EX_mthgxl_e', 'SBO:0000627'),
	('R_EX_n2m2nmasn_e', 'SBO:0000627'),
	('R_EX_na1_e', 'SBO:0000627'),
	('R_EX_ha_e', 'SBO:0000627'),
	('R_EX_ha_pre1_e', 'SBO:0000627'),
	('R_EX_nac_e', 'SBO:0000627'),
	('R_EX_nad_e', 'SBO:0000627'),
	('R_EX_hco3_e', 'SBO:0000627'),
	('R_EX_hcoumarin_e', 'SBO:0000627'),
	('R_EX_hdca_e', 'SBO:0000627'),
	('R_EX_nadp_e', 'SBO:0000627'),
	('R_EX_hdcea_e', 'SBO:0000627'),
	('R_EX_nifedipine_e', 'SBO:0000627'),
	('R_EX_npthl_e', 'SBO:0000627'),
	('R_EX_nrpphr_e', 'SBO:0000627'),
	('R_EX_nrpphrsf_e', 'SBO:0000627'),
	('R_EX_nrvnc_e', 'SBO:0000627'),
	('R_EX_hestratriol_e', 'SBO:0000627'),
	('R_EX_hexc_e', 'SBO:0000627'),
	('R_EX_hista_e', 'SBO:0000627'),
	('R_EX_hom__L_e', 'SBO:0000627'),
	('R_EX_hpdca_e', 'SBO:0000627'),
	('R_EX_hspg_e', 'SBO:0000627'),
	('R_EX_htaxol_e', 'SBO:0000627'),
	('R_EX_o2s_e', 'SBO:0000627'),
	('R_EX_oagd3_hs_e', 'SBO:0000627'),
	('R_EX_oagt3_hs_e', 'SBO:0000627'),
	('R_EX_i_e', 'SBO:0000627'),
	('R_EX_idp_e', 'SBO:0000627'),
	('R_EX_ocdca_e', 'SBO:0000627'),
	('R_EX_ocdcea_e', 'SBO:0000627'),
	('R_EX_octa_e', 'SBO:0000627'),
	('R_EX_oh1_e', 'SBO:0000627'),
	('R_EX_imp_e', 'SBO:0000627'),
	('R_EX_omeprazole_e', 'SBO:0000627'),
	('R_EX_onpthl_e', 'SBO:0000627'),
	('R_EX_ins_e', 'SBO:0000627'),
	('R_EX_ksi_e', 'SBO:0000627'),
	('R_EX_ksi_deg1_e', 'SBO:0000627'),
	('R_EX_ksii_core2_e', 'SBO:0000627'),
	('R_EX_ksii_core4_e', 'SBO:0000627'),
	('R_EX_oxa_e', 'SBO:0000627'),
	('R_EX_paf_hs_e', 'SBO:0000627'),
	('R_EX_pchol_hs_e', 'SBO:0000627'),
	('R_EX_pe_hs_e', 'SBO:0000627'),
	('R_EX_peplys_e', 'SBO:0000627'),
	('R_EX_perillyl_e', 'SBO:0000627'),
	('R_EX_pglyc_hs_e', 'SBO:0000627'),
	('R_EX_lac__D_e', 'SBO:0000627'),
	('R_EX_phe__L_e', 'SBO:0000627'),
	('R_EX_leuktrC4_e', 'SBO:0000627'),
	('R_EX_lgnc_e', 'SBO:0000627'),
	('R_EX_pheacgln_e', 'SBO:0000627'),
	('R_EX_pheme_e', 'SBO:0000627'),
	('R_EX_phllqne_e', 'SBO:0000627'),
	('R_EX_phyt_e', 'SBO:0000627'),
	('R_EX_limnen_e', 'SBO:0000627'),
	('R_EX_pnto__R_e', 'SBO:0000627'),
	('R_EX_lipoate_e', 'SBO:0000627'),
	('R_EX_lneldc_e', 'SBO:0000627'),
	('R_EX_ppa_e', 'SBO:0000627'),
	('R_EX_pro__D_e', 'SBO:0000627'),
	('R_EX_lnlc_e', 'SBO:0000627'),
	('R_EX_lnlnca_e', 'SBO:0000627'),
	('R_EX_lnlncg_e', 'SBO:0000627'),
	('R_EX_prostgd2_e', 'SBO:0000627'),
	('R_EX_prostge1_e', 'SBO:0000627'),
	('R_EX_prostge2_e', 'SBO:0000627'),
	('R_EX_prostgf2_e', 'SBO:0000627'),
	('R_EX_lpchol_hs_e', 'SBO:0000627'),
	('R_EX_mag_hs_e', 'SBO:0000627'),
	('R_EX_ps_hs_e', 'SBO:0000627'),
	('R_EX_malttr_e', 'SBO:0000627'),
	('R_EX_ptdca_e', 'SBO:0000627'),
	('R_EX_meoh_e', 'SBO:0000627'),
	('R_EX_pydam_e', 'SBO:0000627'),
	('R_EX_pydx_e', 'SBO:0000627'),
	('R_EX_pydxn_e', 'SBO:0000627'),
	('R_EX_mepi_e', 'SBO:0000627'),
	('R_EX_mercplaccys_e', 'SBO:0000627'),
	('R_EX_pyr_e', 'SBO:0000627'),
	('R_EX_rbt_e', 'SBO:0000627'),
	('R_EX_retfa_e', 'SBO:0000627'),
	('R_EX_tag__D_e', 'SBO:0000627'),
	('R_EX_retinol_9_cis_e', 'SBO:0000627'),
	('R_EX_retinol_e', 'SBO:0000627'),
	('R_EX_retinol_cis_11_e', 'SBO:0000627'),
	('R_EX_taxol_e', 'SBO:0000627'),
	('R_EX_retn_e', 'SBO:0000627'),
	('R_EX_retnglc_e', 'SBO:0000627'),
	('R_EX_retpalm_e', 'SBO:0000627'),
	('R_EX_tchola_e', 'SBO:0000627'),
	('R_EX_tcynt_e', 'SBO:0000627'),
	('R_EX_tdchola_e', 'SBO:0000627'),
	('R_EX_tethex3_e', 'SBO:0000627'),
	('R_EX_tetpent3_e', 'SBO:0000627'),
	('R_EX_tetpent6_e', 'SBO:0000627'),
	('R_EX_s2l2fn2m2masn_e', 'SBO:0000627'),
	('R_EX_s2l2n2m2masn_e', 'SBO:0000627'),
	('R_EX_tettet6_e', 'SBO:0000627'),
	('R_EX_thf_e', 'SBO:0000627'),
	('R_EX_sarcs_e', 'SBO:0000627'),
	('R_EX_sel_e', 'SBO:0000627'),
	('R_EX_thmmp_e', 'SBO:0000627'),
	('R_EX_thmtp_e', 'SBO:0000627'),
	('R_EX_thym_e', 'SBO:0000627'),
	('R_EX_sl__L_e', 'SBO:0000627'),
	('R_EX_spc_hs_e', 'SBO:0000627'),
	('R_EX_sph1p_e', 'SBO:0000627'),
	('R_EX_thyox__L_e', 'SBO:0000627'),
	('R_EX_sphs1p_e', 'SBO:0000627'),
	('R_EX_srtn_e', 'SBO:0000627'),
	('R_EX_strch1_e', 'SBO:0000627'),
	('R_EX_tmndnc_e', 'SBO:0000627'),
	('R_EX_tolbutamide_e', 'SBO:0000627'),
	('R_EX_strch2_e', 'SBO:0000627'),
	('R_EX_strdnc_e', 'SBO:0000627'),
	('R_EX_tag_hs_e', 'SBO:0000627'),
	('R_EX_triodthy_e', 'SBO:0000627'),
	('R_EX_triodthysuf_e', 'SBO:0000627'),
	('R_EX_trp__L_e', 'SBO:0000627'),
	('R_EX_tststeroneglc_e', 'SBO:0000627'),
	('R_EX_tststerones_e', 'SBO:0000627'),
	('R_EX_ttdca_e', 'SBO:0000627'),
	('R_EX_txa2_e', 'SBO:0000627'),
	('R_EX_tymsf_e', 'SBO:0000627'),
	('R_EX_tyr__L_e', 'SBO:0000627'),
	('R_EX_udp_e', 'SBO:0000627'),
	('R_EX_ump_e', 'SBO:0000627'),
	('R_FADH2tru', 'SBO:0000658'),
	('R_FADH2tx', 'SBO:0000658'),
	('R_FADtru', 'SBO:0000658'),
	('R_FADtx', 'SBO:0000658'),
	('R_FAEL183', 'SBO:0000399'),
	('R_FAEL184', 'SBO:0000399'),
	('R_FAEL204', 'SBO:0000399'),
	('R_FAEL205', 'SBO:0000399'),
	('R_FAH1', 'SBO:0000200'),
	('R_FAH2', 'SBO:0000200'),
	('R_FAH3', 'SBO:0000200'),
	('R_FALDH', 'SBO:0000200'),
	('R_FALDtly', 'SBO:0000658'),
	('R_FALDtm', 'SBO:0000658'),
	('R_FAOXC11', 'SBO:0000200'),
	('R_FAOXC140', 'SBO:0000200'),
	('R_FAOXC150m', 'SBO:0000200'),
	('R_FAOXC160', 'SBO:0000200'),
	('R_FAOXC16080m', 'SBO:0000200'),
	('R_FAOXC16080x', 'SBO:0000200'),
	('R_FAOXC161802m', 'SBO:0000200'),
	('R_FAOXC16180m', 'SBO:0000200'),
	('R_FAOXC170m', 'SBO:0000200'),
	('R_FAOXC180', 'SBO:0000200'),
	('R_FAOXC180x', 'SBO:0000200'),
	('R_FAOXC1811601m', 'SBO:0000200'),
	('R_FAOXC1811602m', 'SBO:0000200'),
	('R_FAOXC1811603m', 'SBO:0000200'),
	('R_EX_utp_e', 'SBO:0000627'),
	('R_FAOXC182806m', 'SBO:0000200'),
	('R_FAOXC18280m', 'SBO:0000200'),
	('R_EX_vacc_e', 'SBO:0000627'),
	('R_FAOXC183803m', 'SBO:0000200'),
	('R_FAOXC183806m', 'SBO:0000200'),
	('R_FAOXC183806x', 'SBO:0000200'),
	('R_EX_vitd2_e', 'SBO:0000627'),
	('R_EX_vitd3_e', 'SBO:0000627'),
	('R_EX_whddca_e', 'SBO:0000627'),
	('R_EX_whhdca_e', 'SBO:0000627'),
	('R_ASCBt', 'SBO:0000658'),
	('R_EX_whtststerone_e', 'SBO:0000627'),
	('R_EX_whttdca_e', 'SBO:0000627'),
	('R_EX_xolest2_hs_e', 'SBO:0000627'),
	('R_FAOXC18480m', 'SBO:0000200'),
	('R_FAOXC18480x', 'SBO:0000200'),
	('R_FAOXC200180m', 'SBO:0000200'),
	('R_FAOXC200180x', 'SBO:0000200'),
	('R_FAOXC2031836m', 'SBO:0000200'),
	('R_EX_xolest_hs_e', 'SBO:0000627'),
	('R_EX_xoltri24_e', 'SBO:0000627'),
	('R_EX_xoltri25_e', 'SBO:0000627'),
	('R_FAOXC204', 'SBO:0000200'),
	('R_ASCBt4', 'SBO:0000659'),
	('R_FAOXC204184m', 'SBO:0000200'),
	('R_FAOXC2051843m', 'SBO:0000200'),
	('R_FAOXC2051843x', 'SBO:0000200'),
	('R_EX_xoltri27_e', 'SBO:0000627'),
	('R_EX_xylt_e', 'SBO:0000627'),
	('R_ASNALANaEx', 'SBO:0000660'),
	('R_EX_yvite_e', 'SBO:0000627'),
	('R_FAOXC2242046m', 'SBO:0000200'),
	('R_FAOXC2242046x', 'SBO:0000200'),
	('R_FAOXC2251836m', 'SBO:0000200'),
	('R_FAOXC2251836x', 'SBO:0000200'),
	('R_FAOXC2252053m', 'SBO:0000200'),
	('R_FAOXC2252053x', 'SBO:0000200'),
	('R_F1PGT', 'SBO:0000402'),
	('R_FAOXC226', 'SBO:0000200'),
	('R_ASNCYSNaEx', 'SBO:0000660'),
	('R_FAOXC226205m', 'SBO:0000200'),
	('R_FAOXC226205x', 'SBO:0000200'),
	('R_FAOXC240200x', 'SBO:0000200'),
	('R_FA120ACPHi', 'SBO:0000376'),
	('R_FA140ACPHi', 'SBO:0000376'),
	('R_FA141ACPHi', 'SBO:0000376'),
	('R_FAOXC241181x', 'SBO:0000200'),
	('R_ASNGLNNaEx', 'SBO:0000660'),
	('R_FAOXC2442246x', 'SBO:0000200'),
	('R_FAOXC2452253x', 'SBO:0000200'),
	('R_FA160ACPHi', 'SBO:0000376'),
	('R_FA161ACPHi', 'SBO:0000376'),
	('R_FAOXC2452256x', 'SBO:0000200'),
	('R_FA180ACPH', 'SBO:0000376'),
	('R_FA181ACPH', 'SBO:0000376'),
	('R_FAOXC246226x', 'SBO:0000200'),
	('R_FAOXC260240x', 'SBO:0000200'),
	('R_FAOXC80', 'SBO:0000200'),
	('R_FAS100COA', 'SBO:0000402'),
	('R_FAS120COA', 'SBO:0000402'),
	('R_FAS140COA', 'SBO:0000402'),
	('R_ASNNm', 'SBO:0000401'),
	('R_FAS160COA', 'SBO:0000402'),
	('R_FAS180COA', 'SBO:0000402'),
	('R_FAS80COA_L', 'SBO:0000402'),
	('R_FATP1t', 'SBO:0000659'),
	('R_FATP2t', 'SBO:0000659'),
	('R_ASNSERNaEx', 'SBO:0000660'),
	('R_ASNTHRNaEx', 'SBO:0000660'),
	('R_L_LACt4r', 'SBO:0000659'),
	('R_FATP3t', 'SBO:0000659'),
	('R_ASNt4', 'SBO:0000659'),
	('R_FATP4t', 'SBO:0000659'),
	('R_FATP5t', 'SBO:0000659'),
	('R_FATP6t', 'SBO:0000659'),
	('R_FATP7t', 'SBO:0000659'),
	('R_FATP8t', 'SBO:0000659'),
	('R_FATP9t', 'SBO:0000659'),
	('R_FUCFUC12GAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_ASNtN1', 'SBO:0000660'),
	('R_FUCFUC12GAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCFUC132GALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCFUC132GALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FBA2', 'SBO:0000178'),
	('R_ASNtm', 'SBO:0000658'),
	('R_FBA4', 'SBO:0000178'),
	('R_FUCFUCFUCGALACGLC13GALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCFUCFUCGALACGLC13GALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCFUCFUCGALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCFUCFUCGALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FBP26', 'SBO:0000376'),
	('R_FUCFUCGALACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FCLTm', 'SBO:0000178'),
	('R_FUCFUCGALACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCGALFUCGALACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCGALFUCGALACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCGALGBSIDEte', 'SBO:0000658'),
	('R_FCOAH', 'SBO:0000376'),
	('R_FE2t', 'SBO:0000658'),
	('R_FE2tm', 'SBO:0000659'),
	('R_FK', 'SBO:0000216'),
	('R_FKYNH', 'SBO:0000376'),
	('R_FUCGALGBSIDEtg', 'SBO:0000658'),
	('R_FUCtly', 'SBO:0000658'),
	('R_ASPDt6', 'SBO:0000660'),
	('R_ASPDxt', 'SBO:0000658'),
	('R_ASPGLUm', 'SBO:0000660'),
	('R_FUMAC', 'SBO:0000376'),
	('R_FOLR2', 'SBO:0000200'),
	('R_ASPNATm', 'SBO:0000215'),
	('R_FOLt2', 'SBO:0000660'),
	('R_FORMCOAtx', 'SBO:0000658'),
	('R_FUMSO3tm', 'SBO:0000660'),
	('R_FUMSO4tm', 'SBO:0000660'),
	('R_FUMTSULtm', 'SBO:0000660'),
	('R_FORtm', 'SBO:0000658'),
	('R_FUMm', 'SBO:0000178'),
	('R_FORtr', 'SBO:0000658'),
	('R_FUMtm', 'SBO:0000660'),
	('R_FORtrn', 'SBO:0000658'),
	('R_ASPTAm', 'SBO:0000403'),
	('R_FUT12g', 'SBO:0000217'),
	('R_ASPt6', 'SBO:0000660'),
	('R_ATP1ter', 'SBO:0000657'),
	('R_ATP2ter', 'SBO:0000657'),
	('R_FRDPtc', 'SBO:0000658'),
	('R_FRDPtr', 'SBO:0000658'),
	('R_FRTT', 'SBO:0000402'),
	('R_FRUt1r', 'SBO:0000658'),
	('R_FRUt4', 'SBO:0000659'),
	('R_FT', 'SBO:0000402'),
	('R_FTCD', 'SBO:0000178'),
	('R_FTHFDH', 'SBO:0000200'),
	('R_FUC13GALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUC13GALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUC14GALACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUC14GALACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCACGALFUCGALACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCACGALFUCGALACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCACNGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCACNGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_FUCACNGALACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_FUCACNGALACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_GALFUC12GAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_GALFUC12GAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_GALFUCGALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_GBSIDEte', 'SBO:0000658'),
	('R_GBSIDEtl', 'SBO:0000658'),
	('R_GALFUCGALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_GALGALFUCFUCGALACGLCGALACGLCGAL14ACGLCGALGLUSIDEte', 'SBO:0000658'),
	('R_GALGALFUCFUCGALACGLCGALACGLCGAL14ACGLCGALGLUSIDEtg', 'SBO:0000658'),
	('R_GALGALGALTHCRMte', 'SBO:0000658'),
	('R_GCALDDm', 'SBO:0000200'),
	('R_GALGALGALTHCRMtg', 'SBO:0000658'),
	('R_GALGLUSIDEtg', 'SBO:0000658'),
	('R_GCC2am', 'SBO:0000200'),
	('R_GCC2bim', 'SBO:0000402'),
	('R_GCC2cm', 'SBO:0000200'),
	('R_GALGLUSIDEtl', 'SBO:0000658'),
	('R_GCCam', 'SBO:0000200'),
	('R_GCCbim', 'SBO:0000402'),
	('R_GCCcm', 'SBO:0000200'),
	('R_GCHOLAt', 'SBO:0000660'),
	('R_GCHOLAt2', 'SBO:0000659'),
	('R_GALKr', 'SBO:0000216'),
	('R_GCHOLAt3', 'SBO:0000657'),
	('R_GCHOLAte', 'SBO:0000658'),
	('R_GALOR', 'SBO:0000200'),
	('R_GALSIDEtg', 'SBO:0000658'),
	('R_GALSIDEtl', 'SBO:0000658'),
	('R_GCHOLAtx', 'SBO:0000658'),
	('R_GD1B2te', 'SBO:0000658'),
	('R_GD1B2tg', 'SBO:0000658'),
	('R_GALT2g', 'SBO:0000217'),
	('R_GD1Cte', 'SBO:0000658'),
	('R_GD1Ctg', 'SBO:0000658'),
	('R_GALt1r', 'SBO:0000658'),
	('R_GDCHOLAte', 'SBO:0000658'),
	('R_GDCHOLAtx', 'SBO:0000658'),
	('R_GDPFUCtg', 'SBO:0000660'),
	('R_GDPtg', 'SBO:0000658'),
	('R_GALt2_2', 'SBO:0000659'),
	('R_GALt4', 'SBO:0000659'),
	('R_GALt4_2', 'SBO:0000659'),
	('R_GALtly', 'SBO:0000658'),
	('R_GFUCS', 'SBO:0000200'),
	('R_GAMt1r', 'SBO:0000658'),
	('R_GHMT3m', 'SBO:0000178'),
	('R_G1M6MASNB1terg', 'SBO:0000658'),
	('R_GK1m', 'SBO:0000216'),
	('R_GLACO', 'SBO:0000200'),
	('R_GLACOm', 'SBO:0000200'),
	('R_GLACter', 'SBO:0000658'),
	('R_G1M7MASNBterg', 'SBO:0000658'),
	('R_G1M7MASNCterg', 'SBO:0000658'),
	('R_GGLUCT', 'SBO:0000655'),
	('R_GGT5r', 'SBO:0000376'),
	('R_GGT6', 'SBO:0000402'),
	('R_GLCAT2g', 'SBO:0000217'),
	('R_GLCAT3g', 'SBO:0000217'),
	('R_GLCAT4g', 'SBO:0000217'),
	('R_GHMT2rm', 'SBO:0000402'),
	('R_G1M8MASNterg', 'SBO:0000658'),
	('R_GHMT3', 'SBO:0000178'),
	('R_GLCAT5g', 'SBO:0000217'),
	('R_GLCAT6g', 'SBO:0000217'),
	('R_GLCAT7g', 'SBO:0000217'),
	('R_G1PTT', 'SBO:0000402'),
	('R_GLCAT8g', 'SBO:0000217'),
	('R_GLCAT9g', 'SBO:0000217'),
	('R_GLCt4_2', 'SBO:0000659'),
	('R_G2M8MASNterg', 'SBO:0000658'),
	('R_GLCter', 'SBO:0000658'),
	('R_GLCATg', 'SBO:0000217'),
	('R_GLCMter', 'SBO:0000658'),
	('R_GLCtg', 'SBO:0000658'),
	('R_G3M8MASNterg', 'SBO:0000658'),
	('R_GLCtly', 'SBO:0000658'),
	('R_GLNALANaEx', 'SBO:0000660'),
	('R_GLNASNNaEx', 'SBO:0000660'),
	('R_G3PD1ir', 'SBO:0000200'),
	('R_GLNCYSNaEx', 'SBO:0000660'),
	('R_G3PD2m', 'SBO:0000660'),
	('R_GLNSERNaEx', 'SBO:0000660'),
	('R_GLNTHRNaEx', 'SBO:0000660'),
	('R_GLNt4', 'SBO:0000659'),
	('R_GLNtN1', 'SBO:0000660'),
	('R_GLNtm', 'SBO:0000658'),
	('R_GLPASE1', 'SBO:0000216'),
	('R_GLCURter', 'SBO:0000658'),
	('R_GLCURtly', 'SBO:0000659'),
	('R_GLCt1', 'SBO:0000658'),
	('R_GLCt2_2', 'SBO:0000659'),
	('R_GLPASE2', 'SBO:0000216'),
	('R_GLRASE', 'SBO:0000200'),
	('R_GLCt2', 'SBO:0000659'),
	('R_GLCt4', 'SBO:0000659'),
	('R_GLU5Km', 'SBO:0000216'),
	('R_GLUDC', 'SBO:0000399'),
	('R_GLYt7_211_r', 'SBO:0000659'),
	('R_GLYt7_311_r', 'SBO:0000659'),
	('R_G5SDym', 'SBO:0000200'),
	('R_GLYtm', 'SBO:0000658'),
	('R_GLYtp', 'SBO:0000658'),
	('R_G6PDH1er_copy1', 'SBO:0000200'),
	('R_GMAND', 'SBO:0000178'),
	('R_G6PDH1er_copy2', 'SBO:0000200'),
	('R_GMPtn', 'SBO:0000658'),
	('R_GNDer', 'SBO:0000399'),
	('R_G6PDH2er', 'SBO:0000200'),
	('R_GP1CALPHAte', 'SBO:0000658'),
	('R_GP1CALPHAtg', 'SBO:0000658'),
	('R_GP1Cte', 'SBO:0000658'),
	('R_GP1Ctg', 'SBO:0000658'),
	('R_GDHm', 'SBO:0000200'),
	('R_GLUDym', 'SBO:0000200'),
	('R_GLUNm', 'SBO:0000401'),
	('R_GLUTCOADHm', 'SBO:0000399'),
	('R_GLUVESSEC', 'SBO:0000657'),
	('R_GLUt2m', 'SBO:0000659'),
	('R_G6Pter', 'SBO:0000658'),
	('R_GQ1BALPHAte', 'SBO:0000658'),
	('R_GLUt6', 'SBO:0000660'),
	('R_GLUt7l', 'SBO:0000658'),
	('R_GLUtr', 'SBO:0000658'),
	('R_GQ1BALPHAtg', 'SBO:0000658'),
	('R_GABAVESSEC', 'SBO:0000657'),
	('R_GQ1Bte', 'SBO:0000658'),
	('R_GQ1Btg', 'SBO:0000658'),
	('R_GLXO1', 'SBO:0000200'),
	('R_GLXO2p', 'SBO:0000200'),
	('R_GLXtm', 'SBO:0000658'),
	('R_GLXtp', 'SBO:0000658'),
	('R_GRTTx', 'SBO:0000402'),
	('R_GSNKm', 'SBO:0000216'),
	('R_GSNt', 'SBO:0000658'),
	('R_GSNt4', 'SBO:0000659'),
	('R_GSNt5', 'SBO:0000659'),
	('R_GLYAMDTRc', 'SBO:0000402'),
	('R_GLYBt4_2_r', 'SBO:0000659'),
	('R_GSNtl', 'SBO:0000658'),
	('R_GLYBtm', 'SBO:0000658'),
	('R_GACMTRc', 'SBO:0000214'),
	('R_GLYC3Ptm', 'SBO:0000658'),
	('R_GLYCK2', 'SBO:0000216'),
	('R_GSNtm', 'SBO:0000658'),
	('R_GT1Ate', 'SBO:0000658'),
	('R_GT1Atg', 'SBO:0000658'),
	('R_GTHDH', 'SBO:0000200'),
	('R_GLYCLTDym', 'SBO:0000200'),
	('R_GACPAILter', 'SBO:0000658'),
	('R_GTHOm', 'SBO:0000200'),
	('R_GLYCLTtp', 'SBO:0000658'),
	('R_GLYCTO1p', 'SBO:0000200'),
	('R_GLYC_St', 'SBO:0000658'),
	('R_GTHPe', 'SBO:0000200'),
	('R_GTHPm', 'SBO:0000200'),
	('R_GTHRDt', 'SBO:0000657'),
	('R_GTHRDtr', 'SBO:0000658'),
	('R_GTMLTe', 'SBO:0000659'),
	('R_GLYCtm', 'SBO:0000658'),
	('R_GLYKm', 'SBO:0000216'),
	('R_GLYOX', 'SBO:0000376'),
	('R_GLYOXm', 'SBO:0000376'),
	('R_GTPCIn', 'SBO:0000376'),
	('R_GTPtn', 'SBO:0000658'),
	('R_GLYOp', 'SBO:0000401'),
	('R_GAL3ST12', 'SBO:0000220'),
	('R_GLYVESSEC', 'SBO:0000657'),
	('R_GLYt2rL', 'SBO:0000659'),
	('R_GUAD', 'SBO:0000401'),
	('R_GLYt4', 'SBO:0000659'),
	('R_GALACGLCGALGBSIDEte', 'SBO:0000658'),
	('R_GUAt', 'SBO:0000658'),
	('R_GULLACter', 'SBO:0000658'),
	('R_GULN3D', 'SBO:0000200'),
	('R_GULNDer', 'SBO:0000200'),
	('R_GALACGLCGALGBSIDEtg', 'SBO:0000658'),
	('R_GULNter', 'SBO:0000658'),
	('R_H2O2syn', 'SBO:0000200'),
	('R_H2O2t', 'SBO:0000658'),
	('R_H2O2tly', 'SBO:0000658'),
	('R_H2O2tm', 'SBO:0000658'),
	('R_H2O2tn', 'SBO:0000658'),
	('R_H2O2tp', 'SBO:0000658'),
	('R_H2Oter', 'SBO:0000658'),
	('R_H2Otg', 'SBO:0000658'),
	('R_HEX10', 'SBO:0000216'),
	('R_H2Otly', 'SBO:0000658'),
	('R_H2Otm', 'SBO:0000658'),
	('R_H2Otn', 'SBO:0000658'),
	('R_H2Otp', 'SBO:0000658'),
	('R_HEXCCOAtx', 'SBO:0000658'),
	('R_HEXCCRNt', 'SBO:0000658'),
	('R_HEXCt', 'SBO:0000658'),
	('R_HGNTOR', 'SBO:0000200'),
	('R_HIBDm', 'SBO:0000200'),
	('R_HISDr', 'SBO:0000178'),
	('R_HISDC', 'SBO:0000399'),
	('R_HISTASE', 'SBO:0000401'),
	('R_HISTAVESSEC', 'SBO:0000657'),
	('R_HISTAtu', 'SBO:0000658'),
	('R_HISt4', 'SBO:0000659'),
	('R_HIStN1', 'SBO:0000660'),
	('R_HIStiDF', 'SBO:0000658'),
	('R_HKYNH', 'SBO:0000376'),
	('R_HKt', 'SBO:0000657'),
	('R_HACD1m', 'SBO:0000200'),
	('R_HACD1x', 'SBO:0000200'),
	('R_HACD9m', 'SBO:0000200'),
	('R_HMGCOARr', 'SBO:0000200'),
	('R_HMGCOARx', 'SBO:0000200'),
	('R_HAS1', 'SBO:0000660'),
	('R_HMGCOAS', 'SBO:0000402'),
	('R_HAS2', 'SBO:0000660'),
	('R_HAtly', 'SBO:0000658'),
	('R_HBZOPT10m', 'SBO:0000402'),
	('R_HCO3Em', 'SBO:0000178'),
	('R_HMGCOASm', 'SBO:0000402'),
	('R_HMGCOAtm', 'SBO:0000658'),
	('R_HMGCOAtx', 'SBO:0000658'),
	('R_HMGLm', 'SBO:0000178'),
	('R_HMGLx', 'SBO:0000178'),
	('R_HCO3_CLt', 'SBO:0000660'),
	('R_HCO3_NAt', 'SBO:0000659'),
	('R_HCOUMARINte', 'SBO:0000658'),
	('R_HDCAter', 'SBO:0000658'),
	('R_HOMt4', 'SBO:0000659'),
	('R_HOXG', 'SBO:0000200'),
	('R_HDCAt', 'SBO:0000658'),
	('R_HPACtr', 'SBO:0000658'),
	('R_MEOHtly', 'SBO:0000658'),
	('R_HPDCACRNt', 'SBO:0000658'),
	('R_HPDCAt', 'SBO:0000658'),
	('R_HPROxm', 'SBO:0000200'),
	('R_HPYRDC', 'SBO:0000399'),
	('R_HDCEAt', 'SBO:0000658'),
	('R_HDD2COAtx', 'SBO:0000658'),
	('R_HESTRATRIOLte', 'SBO:0000658'),
	('R_HESTRATRIOLtr', 'SBO:0000658'),
	('R_HSD17B3r', 'SBO:0000200'),
	('R_HSD17B42x', 'SBO:0000200'),
	('R_HPYRDCm', 'SBO:0000399'),
	('R_HPYRR2x', 'SBO:0000200'),
	('R_IPDDIx', 'SBO:0000377'),
	('R_HPYRtp', 'SBO:0000658'),
	('R_HRETNtn', 'SBO:0000658'),
	('R_HSD17B4x', 'SBO:0000200'),
	('R_HSD17B7r', 'SBO:0000200'),
	('R_HSD17B8r', 'SBO:0000200'),
	('R_HSD17B9r', 'SBO:0000200'),
	('R_HSD3A1r', 'SBO:0000200'),
	('R_HSD3A2r', 'SBO:0000200'),
	('R_HSD3B11', 'SBO:0000377'),
	('R_HSD3B11r', 'SBO:0000377'),
	('R_HSD3B12r', 'SBO:0000377'),
	('R_HSAT1ly', 'SBO:0000660'),
	('R_HSAT2ly', 'SBO:0000660'),
	('R_HSAT3ly', 'SBO:0000660'),
	('R_HSAT4ly', 'SBO:0000660'),
	('R_HSD3B13', 'SBO:0000377'),
	('R_HSD3B13r', 'SBO:0000377'),
	('R_HSD3B2r', 'SBO:0000200'),
	('R_HSD3B3r', 'SBO:0000200'),
	('R_HSD3B7', 'SBO:0000200'),
	('R_HSD11B1r', 'SBO:0000200'),
	('R_HSD11B2r', 'SBO:0000200'),
	('R_HSD17B1', 'SBO:0000200'),
	('R_HSD17B2r', 'SBO:0000200'),
	('R_HSD3B7P', 'SBO:0000200'),
	('R_HSPGt', 'SBO:0000658'),
	('R_HSPGtly', 'SBO:0000658'),
	('R_HTAXOLte', 'SBO:0000658'),
	('R_LGNCCRNt', 'SBO:0000658'),
	('R_HXANtl', 'SBO:0000658'),
	('R_LGNCt', 'SBO:0000658'),
	('R_ITPtn', 'SBO:0000658'),
	('R_LGTHL', 'SBO:0000178'),
	('R_HXANtx', 'SBO:0000658'),
	('R_LIMNENte', 'SBO:0000658'),
	('R_LIPOti', 'SBO:0000657'),
	('R_It', 'SBO:0000658'),
	('R_HYXNt', 'SBO:0000658'),
	('R_Htm', 'SBO:0000658'),
	('R_Htr', 'SBO:0000658'),
	('R_LNELDCCRNt', 'SBO:0000658'),
	('R_LNELDCt', 'SBO:0000658'),
	('R_Htx', 'SBO:0000658'),
	('R_ICDHxm', 'SBO:0000399'),
	('R_LNLCCRNt', 'SBO:0000658'),
	('R_KCC2t', 'SBO:0000659'),
	('R_LNLCt', 'SBO:0000658'),
	('R_ICDHyp', 'SBO:0000200'),
	('R_ICDHym', 'SBO:0000200'),
	('R_IDHPOXOX2b', 'SBO:0000200'),
	('R_IDHPOXOX3', 'SBO:0000200'),
	('R_IDHPOXOX4', 'SBO:0000200'),
	('R_IDHPOXOXb', 'SBO:0000200'),
	('R_LNLNCACRNt', 'SBO:0000658'),
	('R_LNLNCAt', 'SBO:0000658'),
	('R_LNLNCGCRNt', 'SBO:0000658'),
	('R_LNLNCGt', 'SBO:0000658'),
	('R_KCCt', 'SBO:0000659'),
	('R_IDOURtly', 'SBO:0000659'),
	('R_LNS14DM', 'SBO:0000200'),
	('R_LNS14DMr', 'SBO:0000200'),
	('R_LNSTLSr', 'SBO:0000377'),
	('R_IDPtn', 'SBO:0000658'),
	('R_LPCOXp', 'SBO:0000200'),
	('R_ILETAm', 'SBO:0000403'),
	('R_ILEt4', 'SBO:0000659'),
	('R_ILEtmi', 'SBO:0000658'),
	('R_ILEtec', 'SBO:0000658'),
	('R_KHK', 'SBO:0000216'),
	('R_KHK2', 'SBO:0000216'),
	('R_KHK3', 'SBO:0000216'),
	('R_IMACTD', 'SBO:0000200'),
	('R_IMACTD_m', 'SBO:0000200'),
	('R_INOSTO', 'SBO:0000200'),
	('R_INSKm', 'SBO:0000216'),
	('R_LSTO1r', 'SBO:0000200'),
	('R_KSII_CORE2t', 'SBO:0000658'),
	('R_LSTO2r', 'SBO:0000200'),
	('R_LTA4H', 'SBO:0000376'),
	('R_INSTt4', 'SBO:0000659'),
	('R_INSTt4_2', 'SBO:0000659'),
	('R_INSt', 'SBO:0000658'),
	('R_LTC4Sr', 'SBO:0000178'),
	('R_LTD4DP', 'SBO:0000376'),
	('R_INSt4', 'SBO:0000659'),
	('R_LTDCL', 'SBO:0000399'),
	('R_INSt5', 'SBO:0000659'),
	('R_KSII_CORE2tly', 'SBO:0000658'),
	('R_LYSMTF3n', 'SBO:0000214'),
	('R_INStl', 'SBO:0000658'),
	('R_INStm', 'SBO:0000658'),
	('R_L_LACtcm', 'SBO:0000658'),
	('R_LYSOXp', 'SBO:0000200'),
	('R_LYSt4', 'SBO:0000659'),
	('R_LYSt5r', 'SBO:0000658'),
	('R_LYStip', 'SBO:0000658'),
	('R_KSII_CORE4t', 'SBO:0000658'),
	('R_LYStm', 'SBO:0000660'),
	('R_LYStn', 'SBO:0000658'),
	('R_L_LACDcm', 'SBO:0000660'),
	('R_L_LACtm', 'SBO:0000659'),
	('R_KSII_CORE4tly', 'SBO:0000658'),
	('R_KSIt', 'SBO:0000658'),
	('R_KSItly', 'SBO:0000658'),
	('R_MEOHtr', 'SBO:0000658'),
	('R_KYN', 'SBO:0000376'),
	('R_MEPIVESSte', 'SBO:0000657'),
	('R_MERCPLACCYSt', 'SBO:0000658'),
	('R_M4MPDOL_Lter', 'SBO:0000658'),
	('R_M4MPDOL_Uter', 'SBO:0000658'),
	('R_M7MASNBterg', 'SBO:0000658'),
	('R_METLEUex', 'SBO:0000660'),
	('R_M8MASNterg', 'SBO:0000658'),
	('R_KYN3OX', 'SBO:0000200'),
	('R_MACACI', 'SBO:0000377'),
	('R_METt4', 'SBO:0000659'),
	('R_METtec', 'SBO:0000658'),
	('R_MEVK1x', 'SBO:0000216'),
	('R_MACOXO', 'SBO:0000200'),
	('R_KYNAKGAT', 'SBO:0000403'),
	('R_MALSO3tm', 'SBO:0000660'),
	('R_MALSO4tm', 'SBO:0000660'),
	('R_MALTSULtm', 'SBO:0000660'),
	('R_MALTe', 'SBO:0000376'),
	('R_MGCHrm', 'SBO:0000178'),
	('R_MALTly', 'SBO:0000376'),
	('R_MALTt1r', 'SBO:0000658'),
	('R_Kt3g', 'SBO:0000660'),
	('R_MALtm', 'SBO:0000660'),
	('R_MAN1PT2', 'SBO:0000402'),
	('R_MHISOR', 'SBO:0000401'),
	('R_MI13456PK', 'SBO:0000216'),
	('R_MI13456Ptn', 'SBO:0000658'),
	('R_MI1345PKn', 'SBO:0000216'),
	('R_MI1346PKn', 'SBO:0000216'),
	('R_MI1346Ptn', 'SBO:0000658'),
	('R_MI134P4P', 'SBO:0000376'),
	('R_MANt1r', 'SBO:0000658'),
	('R_MANt4', 'SBO:0000659'),
	('R_MANter', 'SBO:0000658'),
	('R_MI134PK', 'SBO:0000216'),
	('R_MANtg', 'SBO:0000658'),
	('R_MI134PP', 'SBO:0000376'),
	('R_MI13PP', 'SBO:0000376'),
	('R_MI1456PKn', 'SBO:0000216'),
	('R_MI145P6Kn', 'SBO:0000216'),
	('R_MANtly', 'SBO:0000658'),
	('R_MAOLNOR', 'SBO:0000200'),
	('R_MAOX', 'SBO:0000401'),
	('R_MI145PK', 'SBO:0000216'),
	('R_MI145PKn', 'SBO:0000216'),
	('R_LALDD', 'SBO:0000200'),
	('R_MI14PP', 'SBO:0000376'),
	('R_MI14Ptn', 'SBO:0000658'),
	('R_MI1P_Dtn', 'SBO:0000658'),
	('R_MCD', 'SBO:0000399'),
	('R_MCDm', 'SBO:0000399'),
	('R_MCDp', 'SBO:0000399'),
	('R_MCITS', 'SBO:0000402'),
	('R_MCLACCYSR', 'SBO:0000200'),
	('R_MCLORi', 'SBO:0000200'),
	('R_MI3456PK', 'SBO:0000216'),
	('R_MI34PP', 'SBO:0000376'),
	('R_MI3PP', 'SBO:0000376'),
	('R_LALDO', 'SBO:0000200'),
	('R_MI4PP', 'SBO:0000376'),
	('R_MICITDr', 'SBO:0000178'),
	('R_MCPST', 'SBO:0000402'),
	('R_MINOHPtn', 'SBO:0000658'),
	('R_MDHm', 'SBO:0000200'),
	('R_LALDO2', 'SBO:0000200'),
	('R_MLTG1e', 'SBO:0000376'),
	('R_MLTG1ly', 'SBO:0000376'),
	('R_MDRPD', 'SBO:0000178'),
	('R_LALDO2x', 'SBO:0000200'),
	('R_ME1m', 'SBO:0000399'),
	('R_ME2', 'SBO:0000200'),
	('R_ME2m', 'SBO:0000200'),
	('R_MELATN23DOX', 'SBO:0000200'),
	('R_MELATNOX', 'SBO:0000200'),
	('R_MEOHt2', 'SBO:0000658'),
	('R_LAPCOAl', 'SBO:0000216'),
	('R_LCADi_D', 'SBO:0000200'),
	('R_LCADi_Dm', 'SBO:0000200'),
	('R_LCADm', 'SBO:0000200'),
	('R_MMCD', 'SBO:0000399'),
	('R_MMCDm', 'SBO:0000399'),
	('R_MMCDp', 'SBO:0000399'),
	('R_MMEm', 'SBO:0000377'),
	('R_MMMm', 'SBO:0000377'),
	('R_MMSAD1m', 'SBO:0000200'),
	('R_MMSAD3m', 'SBO:0000399'),
	('R_MMTSADm', 'SBO:0000200'),
	('R_LCTStg', 'SBO:0000658'),
	('R_MTAP', 'SBO:0000217'),
	('R_LCTStl', 'SBO:0000658'),
	('R_MTHFD2i', 'SBO:0000200'),
	('R_MTHFD2m', 'SBO:0000200'),
	('R_MTHFDm', 'SBO:0000200'),
	('R_LCYSTAT', 'SBO:0000403'),
	('R_MTHFR3', 'SBO:0000200'),
	('R_MTHGXLt', 'SBO:0000658'),
	('R_MTRI', 'SBO:0000377'),
	('R_N2M2NMASNt', 'SBO:0000658'),
	('R_N2M2NMASNtly', 'SBO:0000658'),
	('R_N3Tg', 'SBO:0000217'),
	('R_LCYSTATm', 'SBO:0000403'),
	('R_NABTNO', 'SBO:0000200'),
	('R_LCYSTCBOXL', 'SBO:0000399'),
	('R_NABTNOm', 'SBO:0000200'),
	('R_NACt', 'SBO:0000658'),
	('R_NADH2_u10m', 'SBO:0000200'),
	('R_NADHtpu', 'SBO:0000658'),
	('R_NADHtru', 'SBO:0000658'),
	('R_NADPHtru', 'SBO:0000658'),
	('R_NADPHtxu', 'SBO:0000658'),
	('R_NADPN', 'SBO:0000376'),
	('R_NACASPtm', 'SBO:0000658'),
	('R_NADPNe', 'SBO:0000376'),
	('R_NADPtru', 'SBO:0000658'),
	('R_NADPtxu', 'SBO:0000658'),
	('R_NADtn', 'SBO:0000658'),
	('R_NADtpu', 'SBO:0000658'),
	('R_NADtru', 'SBO:0000658'),
	('R_NAHCO3_HCLt', 'SBO:0000660'),
	('R_NAIt', 'SBO:0000659'),
	('R_LDH_Lm', 'SBO:0000200'),
	('R_NAt', 'SBO:0000658'),
	('R_NAt3_1g', 'SBO:0000660'),
	('R_NAt5', 'SBO:0000660'),
	('R_LEUKTRA4tr', 'SBO:0000658'),
	('R_NAtx', 'SBO:0000658'),
	('R_NDPK9m', 'SBO:0000216'),
	('R_NDPK9n', 'SBO:0000216'),
	('R_NH4t3r', 'SBO:0000660'),
	('R_NH4tn', 'SBO:0000658'),
	('R_NH4tp', 'SBO:0000658'),
	('R_NCCt', 'SBO:0000659'),
	('R_NCKt', 'SBO:0000660'),
	('R_NCNt', 'SBO:0000660'),
	('R_LEUKTRB4tr', 'SBO:0000658'),
	('R_LEUKTRC4t', 'SBO:0000660'),
	('R_NDP8', 'SBO:0000376'),
	('R_LEUKTRD4tr', 'SBO:0000658'),
	('R_NICRNS', 'SBO:0000216'),
	('R_NICRNTtn', 'SBO:0000658'),
	('R_NIFEDIPINEte', 'SBO:0000658'),
	('R_NKCC2t', 'SBO:0000659'),
	('R_NDPK10', 'SBO:0000216'),
	('R_NDPK10m', 'SBO:0000216'),
	('R_NKCCt', 'SBO:0000659'),
	('R_NDPK10n', 'SBO:0000216'),
	('R_NDPK1m', 'SBO:0000216'),
	('R_NDPK1n', 'SBO:0000216'),
	('R_NDPK2m', 'SBO:0000216'),
	('R_NMNS', 'SBO:0000217'),
	('R_NMNtn', 'SBO:0000658'),
	('R_NDPK2n', 'SBO:0000216'),
	('R_LEUt4', 'SBO:0000659'),
	('R_NDPK3m', 'SBO:0000216'),
	('R_NDPK3n', 'SBO:0000216'),
	('R_NDPK4m', 'SBO:0000216'),
	('R_NDPK4n', 'SBO:0000216'),
	('R_NDPK5m', 'SBO:0000216'),
	('R_NNDPR', 'SBO:0000217'),
	('R_NDPK5n', 'SBO:0000216'),
	('R_LEUt5m', 'SBO:0000658'),
	('R_NDPK6m', 'SBO:0000216'),
	('R_NNMT', 'SBO:0000214'),
	('R_NORANMT', 'SBO:0000214'),
	('R_NOS1', 'SBO:0000200'),
	('R_NOS2', 'SBO:0000200'),
	('R_NDPK6n', 'SBO:0000216'),
	('R_NDPK7m', 'SBO:0000216'),
	('R_NDPK7n', 'SBO:0000216'),
	('R_NDPK8m', 'SBO:0000216'),
	('R_NP1', 'SBO:0000217'),
	('R_NPTHLte', 'SBO:0000658'),
	('R_NRPPHRSFt', 'SBO:0000658'),
	('R_NDPK8n', 'SBO:0000216'),
	('R_LEUtec', 'SBO:0000658'),
	('R_NRPPHRVESSEC', 'SBO:0000657'),
	('R_NRPPHRt4_2_r', 'SBO:0000659'),
	('R_LFORKYNHYD', 'SBO:0000376'),
	('R_NRPPHRtu', 'SBO:0000658'),
	('R_NRVNCCOAtx', 'SBO:0000658'),
	('R_TTDCAtr', 'SBO:0000658'),
	('R_LGNCCOAtx', 'SBO:0000658'),
	('R_NRVNCCRNt', 'SBO:0000658'),
	('R_NRVNCt', 'SBO:0000658'),
	('R_NTD9e', 'SBO:0000376'),
	('R_NTD9l', 'SBO:0000376'),
	('R_NTMELYStner', 'SBO:0000658'),
	('R_NS26Tg', 'SBO:0000217'),
	('R_NaKt', 'SBO:0000657'),
	('R_NTD2e', 'SBO:0000376'),
	('R_O2St', 'SBO:0000658'),
	('R_NTD2l', 'SBO:0000376'),
	('R_O2Stm', 'SBO:0000658'),
	('R_NTD2m', 'SBO:0000376'),
	('R_P45019A2r', 'SBO:0000200'),
	('R_O2Stn', 'SBO:0000658'),
	('R_O2Stx', 'SBO:0000658'),
	('R_O2ter', 'SBO:0000658'),
	('R_O2tm', 'SBO:0000658'),
	('R_O2tn', 'SBO:0000658'),
	('R_O2tp', 'SBO:0000658'),
	('R_OAGD3te', 'SBO:0000658'),
	('R_OAGD3tg', 'SBO:0000658'),
	('R_OAGT3te', 'SBO:0000658'),
	('R_OAGT3tg', 'SBO:0000658'),
	('R_NTD7e', 'SBO:0000376'),
	('R_NTD7l', 'SBO:0000376'),
	('R_P4501B1r', 'SBO:0000200'),
	('R_OBDHc', 'SBO:0000399'),
	('R_P45021A1r', 'SBO:0000200'),
	('R_OCBTm', 'SBO:0000402'),
	('R_OCCOAtm', 'SBO:0000658'),
	('R_PCRNtc', 'SBO:0000658'),
	('R_OCCOAtx', 'SBO:0000658'),
	('R_P45021A2r', 'SBO:0000200'),
	('R_OCDCAt', 'SBO:0000658'),
	('R_OCDCEAt', 'SBO:0000658'),
	('R_OCOAT1m', 'SBO:0000402'),
	('R_P45027A11m', 'SBO:0000200'),
	('R_OCTAt', 'SBO:0000658'),
	('R_PCt', 'SBO:0000657'),
	('R_P45027A12m', 'SBO:0000200'),
	('R_ODECOAtx', 'SBO:0000658'),
	('R_OIVD1m', 'SBO:0000399'),
	('R_OIVD2m', 'SBO:0000200'),
	('R_OIVD3m', 'SBO:0000399'),
	('R_OMEPRAZOLEte', 'SBO:0000658'),
	('R_P45027A13m', 'SBO:0000200'),
	('R_ONPTHLte', 'SBO:0000658'),
	('R_OPAH', 'SBO:0000376'),
	('R_PDHm', 'SBO:0000399'),
	('R_PDX5POi', 'SBO:0000200'),
	('R_ORETNtn', 'SBO:0000658'),
	('R_ORETNtn2', 'SBO:0000658'),
	('R_P45027A14m', 'SBO:0000200'),
	('R_PEAMNO', 'SBO:0000401'),
	('R_ORNTArm', 'SBO:0000403'),
	('R_P45027A15m', 'SBO:0000200'),
	('R_ORNt3m', 'SBO:0000660'),
	('R_ORNt4m', 'SBO:0000660'),
	('R_ORNt', 'SBO:0000658'),
	('R_PEFLIP', 'SBO:0000657'),
	('R_PEFLIPm', 'SBO:0000657'),
	('R_PEPCK_re', 'SBO:0000399'),
	('R_OXAHCOtex', 'SBO:0000660'),
	('R_PEPCKm', 'SBO:0000399'),
	('R_PEPLYStn', 'SBO:0000658'),
	('R_OXAtp', 'SBO:0000658'),
	('R_P45027A16m', 'SBO:0000200'),
	('R_P45011A1m', 'SBO:0000200'),
	('R_P45011B11m', 'SBO:0000200'),
	('R_PERILLYLte', 'SBO:0000658'),
	('R_PEROXx', 'SBO:0000200'),
	('R_PETHCT', 'SBO:0000402'),
	('R_P45011B12m', 'SBO:0000200'),
	('R_P45011B21m', 'SBO:0000200'),
	('R_P45027A1m', 'SBO:0000200'),
	('R_P45017A1r', 'SBO:0000200'),
	('R_P45017A2r', 'SBO:0000200'),
	('R_P45017A3r', 'SBO:0000200'),
	('R_PE_HSter', 'SBO:0000658'),
	('R_PE_HStg', 'SBO:0000658'),
	('R_PE_HStm', 'SBO:0000658'),
	('R_P45017A4r', 'SBO:0000200'),
	('R_P4502A6', 'SBO:0000200'),
	('R_P45019A1r', 'SBO:0000200'),
	('R_PFK26', 'SBO:0000216'),
	('R_P4502C18', 'SBO:0000200'),
	('R_PGDI', 'SBO:0000377'),
	('R_PGDIr', 'SBO:0000377'),
	('R_PGESr', 'SBO:0000377'),
	('R_PCRNtm', 'SBO:0000658'),
	('R_PHEACGLNt', 'SBO:0000658'),
	('R_P4502C19', 'SBO:0000200'),
	('R_PGISr', 'SBO:0000377'),
	('R_PHEMEt', 'SBO:0000658'),
	('R_PHEMEtm', 'SBO:0000658'),
	('R_P4502C8', 'SBO:0000200'),
	('R_PGLer', 'SBO:0000376'),
	('R_P4502C9', 'SBO:0000200'),
	('R_PHEt4', 'SBO:0000659'),
	('R_PHEtec', 'SBO:0000658'),
	('R_P4502C92', 'SBO:0000200'),
	('R_PGS', 'SBO:0000200'),
	('R_PHYCBOXL', 'SBO:0000399'),
	('R_PHYHx', 'SBO:0000200'),
	('R_PGSr', 'SBO:0000200'),
	('R_PHYQt', 'SBO:0000657'),
	('R_P4502C93', 'SBO:0000200'),
	('R_PHYTt', 'SBO:0000658'),
	('R_PHACCOAGLNAC', 'SBO:0000215'),
	('R_PHCDm', 'SBO:0000200'),
	('R_P4502C94', 'SBO:0000200'),
	('R_PI34P5K', 'SBO:0000216'),
	('R_PI34P5Kn', 'SBO:0000216'),
	('R_UMPK6', 'SBO:0000216'),
	('R_P4502D6', 'SBO:0000200'),
	('R_PI3P4K', 'SBO:0000216'),
	('R_PI3P4Kn', 'SBO:0000216'),
	('R_P4502E1', 'SBO:0000200'),
	('R_PI3P5K', 'SBO:0000216'),
	('R_PI5P3K', 'SBO:0000216'),
	('R_PI5P3Ker', 'SBO:0000216'),
	('R_PI5P4K', 'SBO:0000216'),
	('R_PI5P4Kn', 'SBO:0000216'),
	('R_PIK3', 'SBO:0000216'),
	('R_PIK3er', 'SBO:0000216'),
	('R_PIK3n', 'SBO:0000216'),
	('R_PIK4', 'SBO:0000216'),
	('R_PIK4n', 'SBO:0000216'),
	('R_PIK5', 'SBO:0000216'),
	('R_PIK5n', 'SBO:0000216'),
	('R_PI45P3K', 'SBO:0000216'),
	('R_PI45P3Kn', 'SBO:0000216'),
	('R_PI4P3K', 'SBO:0000216'),
	('R_PI4P3Ker', 'SBO:0000216'),
	('R_PI4P3Kn', 'SBO:0000216'),
	('R_PI4P5K', 'SBO:0000216'),
	('R_PI4P5Kn', 'SBO:0000216'),
	('R_PROD2m', 'SBO:0000200'),
	('R_PIt2m', 'SBO:0000659'),
	('R_PIt7_copy1', 'SBO:0000659'),
	('R_PIt7_copy2', 'SBO:0000659'),
	('R_P4502F1', 'SBO:0000200'),
	('R_PIt8', 'SBO:0000659'),
	('R_PIt9', 'SBO:0000659'),
	('R_PMEVKx', 'SBO:0000216'),
	('R_PIter', 'SBO:0000658'),
	('R_PItg', 'SBO:0000658'),
	('R_PItn', 'SBO:0000658'),
	('R_PItx', 'SBO:0000658'),
	('R_PMI12346PH', 'SBO:0000376'),
	('R_PMI12346PHn', 'SBO:0000376'),
	('R_P45039A1r', 'SBO:0000233'),
	('R_PMTCOAtx', 'SBO:0000658'),
	('R_PNP', 'SBO:0000216'),
	('R_PRODt2r', 'SBO:0000659'),
	('R_PNTEH', 'SBO:0000376'),
	('R_P4503A4', 'SBO:0000200'),
	('R_PRODt2rL', 'SBO:0000659'),
	('R_PROSTGD2t', 'SBO:0000660'),
	('R_PNTKm', 'SBO:0000216'),
	('R_P4503A43r', 'SBO:0000200'),
	('R_PNTOt5', 'SBO:0000657'),
	('R_PROSTGE1t', 'SBO:0000660'),
	('R_PROSTGE1t3', 'SBO:0000657'),
	('R_PROSTGE2t', 'SBO:0000660'),
	('R_PROSTGE2t2', 'SBO:0000658'),
	('R_PROSTGE2t3', 'SBO:0000657'),
	('R_PROSTGF2t', 'SBO:0000658'),
	('R_PPA2m', 'SBO:0000376'),
	('R_PPAer', 'SBO:0000376'),
	('R_PROt2r', 'SBO:0000659'),
	('R_PROt2rL', 'SBO:0000659'),
	('R_PPAm', 'SBO:0000376'),
	('R_P4503A5', 'SBO:0000200'),
	('R_PPAn', 'SBO:0000376'),
	('R_PPAtr', 'SBO:0000658'),
	('R_PROt4_2_r', 'SBO:0000659'),
	('R_PROtm', 'SBO:0000658'),
	('R_PPAtm', 'SBO:0000658'),
	('R_P4503A7r', 'SBO:0000200'),
	('R_P45046A1r', 'SBO:0000233'),
	('R_PPCOAOm', 'SBO:0000200'),
	('R_P4504B1r', 'SBO:0000200'),
	('R_PSDm_hs', 'SBO:0000399'),
	('R_LCARR', 'SBO:0000200'),
	('R_PPDOy', 'SBO:0000200'),
	('R_PSFLIP', 'SBO:0000657'),
	('R_PSFLIPm', 'SBO:0000657'),
	('R_PSP_L', 'SBO:0000376'),
	('R_PPItr', 'SBO:0000658'),
	('R_PPItx', 'SBO:0000658'),
	('R_PPMI12346Ptn', 'SBO:0000658'),
	('R_PPMI1346Ptn', 'SBO:0000658'),
	('R_P4504F121r', 'SBO:0000200'),
	('R_PPOR', 'SBO:0000200'),
	('R_PPPG9tm', 'SBO:0000658'),
	('R_PS_HSter', 'SBO:0000658'),
	('R_PS_HStg', 'SBO:0000658'),
	('R_PTDCACRNt', 'SBO:0000658'),
	('R_PPPGOm', 'SBO:0000200'),
	('R_P4504F122r', 'SBO:0000200'),
	('R_PPPItn', 'SBO:0000658'),
	('R_PTDCAt', 'SBO:0000658'),
	('R_P4504F123r', 'SBO:0000200'),
	('R_PTE5x', 'SBO:0000376'),
	('R_PTHPS', 'SBO:0000178'),
	('R_PTHPSn', 'SBO:0000178'),
	('R_PRGNLONESULT', 'SBO:0000220'),
	('R_PRGNLONEtm', 'SBO:0000658'),
	('R_PRGNLONEtr', 'SBO:0000658'),
	('R_PRISTANALtx', 'SBO:0000658'),
	('R_PTRCAT1', 'SBO:0000215'),
	('R_PTRCOX1', 'SBO:0000401'),
	('R_PRISTCOAtx', 'SBO:0000658'),
	('R_P4504F81r', 'SBO:0000200'),
	('R_PRISTtx', 'SBO:0000658'),
	('R_PRO1x', 'SBO:0000200'),
	('R_PRO1xm', 'SBO:0000200'),
	('R_PROAKGOX1r', 'SBO:0000399'),
	('R_P4507A1r', 'SBO:0000200'),
	('R_P4507B11r', 'SBO:0000233'),
	('R_PUNP4', 'SBO:0000216'),
	('R_UMPK6n', 'SBO:0000216'),
	('R_PUNP7', 'SBO:0000216'),
	('R_P4507B12r', 'SBO:0000200'),
	('R_P4508B11r', 'SBO:0000233'),
	('R_PYAM5PO', 'SBO:0000200'),
	('R_PYAM5Ptm', 'SBO:0000658'),
	('R_PYRt2m', 'SBO:0000659'),
	('R_PYRt2p', 'SBO:0000659'),
	('R_P4508B13r', 'SBO:0000200'),
	('R_PYDAMtr', 'SBO:0000658'),
	('R_PYDX5Ptm', 'SBO:0000658'),
	('R_PYDXDH', 'SBO:0000200'),
	('R_PYRt2', 'SBO:0000659'),
	('R_RADH', 'SBO:0000200'),
	('R_RADH2', 'SBO:0000200'),
	('R_RADH3', 'SBO:0000200'),
	('R_RADH4', 'SBO:0000200'),
	('R_PYDXNtr', 'SBO:0000658'),
	('R_P450LTB4r', 'SBO:0000200'),
	('R_PYDXtr', 'SBO:0000658'),
	('R_RAHY', 'SBO:0000200'),
	('R_RAI1', 'SBO:0000377'),
	('R_P450SCC1m', 'SBO:0000200'),
	('R_PYLALDOX', 'SBO:0000200'),
	('R_PYLALDOXm', 'SBO:0000200'),
	('R_P5CDm', 'SBO:0000200'),
	('R_RAtn', 'SBO:0000658'),
	('R_RAtn3', 'SBO:0000658'),
	('R_P5CRm', 'SBO:0000200'),
	('R_P5CRx', 'SBO:0000200'),
	('R_RTOTALCRNt', 'SBO:0000658'),
	('R_Rtotaltl', 'SBO:0000658'),
	('R_RBK_Dr', 'SBO:0000216'),
	('R_RBTt', 'SBO:0000658'),
	('R_RDH1', 'SBO:0000200'),
	('R_Rtotaltp', 'SBO:0000658'),
	('R_P5CRxm', 'SBO:0000200'),
	('R_RDH1a', 'SBO:0000200'),
	('R_RDH2', 'SBO:0000200'),
	('R_RDH2a', 'SBO:0000200'),
	('R_RDH3', 'SBO:0000200'),
	('R_RDH3a', 'SBO:0000200'),
	('R_RDH4', 'SBO:0000200'),
	('R_S2L2FN2M2MASNt', 'SBO:0000658'),
	('R_S2L2FN2M2MASNtly', 'SBO:0000658'),
	('R_S2L2N2M2MASNtly', 'SBO:0000658'),
	('R_RETFAt', 'SBO:0000658'),
	('R_RETFAt1', 'SBO:0000658'),
	('R_RETFAt2', 'SBO:0000658'),
	('R_RETI1', 'SBO:0000377'),
	('R_RETNGLCt', 'SBO:0000658'),
	('R_RETNGLCt2', 'SBO:0000658'),
	('R_RETNGLCt2r', 'SBO:0000658'),
	('R_RETNGLCtr', 'SBO:0000658'),
	('R_RETNt', 'SBO:0000658'),
	('R_RETNtr', 'SBO:0000658'),
	('R_PAIL45P_HStn', 'SBO:0000658'),
	('R_RETNtr2', 'SBO:0000658'),
	('R_RETt', 'SBO:0000658'),
	('R_RIBFLVt3', 'SBO:0000657'),
	('R_RIBt', 'SBO:0000658'),
	('R_RIBt2', 'SBO:0000659'),
	('R_PAIL4P_HStn', 'SBO:0000658'),
	('R_PAIL_HStn', 'SBO:0000658'),
	('R_PAN4PP', 'SBO:0000376'),
	('R_RTOTAL2CRNt', 'SBO:0000658'),
	('R_PAPStg', 'SBO:0000658'),
	('R_RTOTAL3CRNt', 'SBO:0000658'),
	('R_PAPtg', 'SBO:0000658'),
	('R_SBTD_D2', 'SBO:0000200'),
	('R_PA_HSter', 'SBO:0000658'),
	('R_SBTR', 'SBO:0000200'),
	('R_PA_HStg', 'SBO:0000658'),
	('R_SCP21x', 'SBO:0000658'),
	('R_SCP22x', 'SBO:0000658'),
	('R_SCPx', 'SBO:0000402'),
	('R_SEAHCYSHYD', 'SBO:0000376'),
	('R_SEAHCYStn', 'SBO:0000658'),
	('R_SEASMETtn', 'SBO:0000658'),
	('R_PA_HStn', 'SBO:0000658'),
	('R_SELADT', 'SBO:0000402'),
	('R_SELCYSTGL', 'SBO:0000178'),
	('R_SELCYSTS', 'SBO:0000178'),
	('R_PCFLOPm', 'SBO:0000657'),
	('R_SELMETAT', 'SBO:0000402'),
	('R_SELNPS', 'SBO:0000402'),
	('R_SELt4_3', 'SBO:0000659'),
	('R_SERALANaEx', 'SBO:0000660'),
	('R_SERASNNaEx', 'SBO:0000660'),
	('R_SERCYSNaEx', 'SBO:0000660'),
	('R_SERDGLNexR', 'SBO:0000660'),
	('R_SERDGLYexR', 'SBO:0000660'),
	('R_SERGLNNaEx', 'SBO:0000660'),
	('R_SERGLNexR', 'SBO:0000660'),
	('R_SERGLYexR', 'SBO:0000660'),
	('R_SERHL', 'SBO:0000178'),
	('R_SERLYSNaex', 'SBO:0000660'),
	('R_SERPT', 'SBO:0000218'),
	('R_SERTHRNaEx', 'SBO:0000660'),
	('R_SACCD3m', 'SBO:0000200'),
	('R_SACCD4m', 'SBO:0000200'),
	('R_SERt4', 'SBO:0000659'),
	('R_SERtN1', 'SBO:0000660'),
	('R_SERtp', 'SBO:0000658'),
	('R_SGALSIDEtg', 'SBO:0000658'),
	('R_SGALSIDEtl', 'SBO:0000658'),
	('R_SGPL11r', 'SBO:0000178'),
	('R_SALMCOM', 'SBO:0000214'),
	('R_SALMCOM2', 'SBO:0000214'),
	('R_SAMHISTA', 'SBO:0000214'),
	('R_SARCOXp', 'SBO:0000200'),
	('R_SARCStex', 'SBO:0000658'),
	('R_SARCStm', 'SBO:0000658'),
	('R_SARCStp', 'SBO:0000658'),
	('R_PCHOL_HSter', 'SBO:0000658'),
	('R_SARDHm', 'SBO:0000200'),
	('R_SBPP3er', 'SBO:0000376'),
	('R_SLCBK1', 'SBO:0000216'),
	('R_SLDt', 'SBO:0000658'),
	('R_SLDx', 'SBO:0000200'),
	('R_SLDxm', 'SBO:0000200'),
	('R_SO4CLtex2', 'SBO:0000660'),
	('R_SO4HCOtex', 'SBO:0000660'),
	('R_SPC_HSt', 'SBO:0000658'),
	('R_SPH1Pte', 'SBO:0000658'),
	('R_SO4OXAtex2', 'SBO:0000660'),
	('R_SO4t4_2', 'SBO:0000659'),
	('R_PCHOL_HStg', 'SBO:0000658'),
	('R_SO4t4_3', 'SBO:0000659'),
	('R_SPH1Pter', 'SBO:0000658'),
	('R_SPHGNtr', 'SBO:0000658'),
	('R_SPHINGStl', 'SBO:0000658'),
	('R_PCLAD', 'SBO:0000399'),
	('R_PCLYSOX', 'SBO:0000200'),
	('R_SPHINGStr', 'SBO:0000658'),
	('R_PCREATtmdiffir', 'SBO:0000658'),
	('R_SPHK21c', 'SBO:0000216'),
	('R_STS2r', 'SBO:0000376'),
	('R_STS3', 'SBO:0000376'),
	('R_SPHMYLNtg', 'SBO:0000658'),
	('R_THMTPt', 'SBO:0000660'),
	('R_SPHMYLNtl', 'SBO:0000658'),
	('R_SPHS1Pte', 'SBO:0000658'),
	('R_SPHS1Ptr', 'SBO:0000658'),
	('R_SPMS', 'SBO:0000402'),
	('R_SPODM', 'SBO:0000200'),
	('R_SPODMe', 'SBO:0000200'),
	('R_STS3r', 'SBO:0000376'),
	('R_STS4', 'SBO:0000376'),
	('R_STS4r', 'SBO:0000376'),
	('R_SUCCtm', 'SBO:0000660'),
	('R_SUCCt4_2', 'SBO:0000659'),
	('R_SUCCt4_3', 'SBO:0000659'),
	('R_SUCCtp', 'SBO:0000658'),
	('R_SPODMm', 'SBO:0000200'),
	('R_SPODMn', 'SBO:0000200'),
	('R_SPODMx', 'SBO:0000200'),
	('R_SUCD1m', 'SBO:0000200'),
	('R_SPR', 'SBO:0000200'),
	('R_THMt2m', 'SBO:0000659'),
	('R_SPRn', 'SBO:0000200'),
	('R_SULFOX', 'SBO:0000660'),
	('R_T2M26DCOAHLm', 'SBO:0000178'),
	('R_SPTix', 'SBO:0000403'),
	('R_T2M26DCOAHLx', 'SBO:0000178'),
	('R_THMt3', 'SBO:0000660'),
	('R_T4HCINNMFM', 'SBO:0000178'),
	('R_SQLEr', 'SBO:0000200'),
	('R_SQLSr', 'SBO:0000402'),
	('R_THP2Ctp', 'SBO:0000658'),
	('R_TAGAT_Dt', 'SBO:0000658'),
	('R_TAURt4_2_r', 'SBO:0000659'),
	('R_TAURtcx', 'SBO:0000659'),
	('R_SR5AR2r', 'SBO:0000200'),
	('R_SR5ARr', 'SBO:0000200'),
	('R_SRTN23OX', 'SBO:0000200'),
	('R_SRTNACT', 'SBO:0000215'),
	('R_SRTNMTX', 'SBO:0000214'),
	('R_SRTNt6_2_r', 'SBO:0000660'),
	('R_SRTNtu', 'SBO:0000658'),
	('R_TAXOLte', 'SBO:0000658'),
	('R_TCHOLAt', 'SBO:0000660'),
	('R_TCHOLAt2', 'SBO:0000659'),
	('R_SSALxm', 'SBO:0000200'),
	('R_THRALANaEx', 'SBO:0000660'),
	('R_TCHOLAt3', 'SBO:0000657'),
	('R_TCHOLAte', 'SBO:0000658'),
	('R_TCHOLAtx', 'SBO:0000658'),
	('R_TCYNTt', 'SBO:0000658'),
	('R_ST3GAL61g', 'SBO:0000217'),
	('R_TCYNTtm', 'SBO:0000658'),
	('R_TDCHOLAte', 'SBO:0000658'),
	('R_THRASNNaEx', 'SBO:0000660'),
	('R_TDCHOLAtx', 'SBO:0000658'),
	('R_TDPDRE', 'SBO:0000377'),
	('R_TDPDRR', 'SBO:0000200'),
	('R_TDPGDH', 'SBO:0000178'),
	('R_TETHEX3COAtx', 'SBO:0000658'),
	('R_TETHEX3t', 'SBO:0000658'),
	('R_TETPENT3COAtx', 'SBO:0000658'),
	('R_THRCYSNaEx', 'SBO:0000660'),
	('R_TETPENT3CRNt', 'SBO:0000658'),
	('R_TETPENT3t', 'SBO:0000658'),
	('R_TETPENT6COAtx', 'SBO:0000658'),
	('R_TETPENT6CRNt', 'SBO:0000658'),
	('R_TETPENT6t', 'SBO:0000658'),
	('R_TETTET6COAtx', 'SBO:0000658'),
	('R_STCOAtx', 'SBO:0000658'),
	('R_STRDNCCRNt', 'SBO:0000658'),
	('R_STRDNCt', 'SBO:0000658'),
	('R_STS1', 'SBO:0000376'),
	('R_TETTET6CRNt', 'SBO:0000658'),
	('R_TETTET6t', 'SBO:0000658'),
	('R_THCHOLSTOICtm', 'SBO:0000658'),
	('R_STS1r', 'SBO:0000376'),
	('R_STS2', 'SBO:0000376'),
	('R_THD1m', 'SBO:0000200'),
	('R_THRGLNNaEx', 'SBO:0000660'),
	('R_THFt2', 'SBO:0000660'),
	('R_THFtl', 'SBO:0000658'),
	('R_THFtm', 'SBO:0000658'),
	('R_THRGLNexR', 'SBO:0000660'),
	('R_TTDCRNt', 'SBO:0000658'),
	('R_TXA2te', 'SBO:0000658'),
	('R_TXA2tr', 'SBO:0000658'),
	('R_TXASr', 'SBO:0000377'),
	('R_THMDt5', 'SBO:0000659'),
	('R_THMMPt4', 'SBO:0000660'),
	('R_THMMPtm', 'SBO:0000660'),
	('R_THMP', 'SBO:0000376'),
	('R_THMPPtm', 'SBO:0000660'),
	('R_THMTP', 'SBO:0000376'),
	('R_TYMSFt', 'SBO:0000658'),
	('R_TYRCBOX', 'SBO:0000399'),
	('R_TYRDOPO', 'SBO:0000200'),
	('R_TYRDOPO3', 'SBO:0000200'),
	('R_UMPK7', 'SBO:0000216'),
	('R_UMPK7n', 'SBO:0000216'),
	('R_TYROXDAc', 'SBO:0000401'),
	('R_THRGLYexR', 'SBO:0000660'),
	('R_UMPKm', 'SBO:0000216'),
	('R_UMPKn', 'SBO:0000216'),
	('R_TYRt', 'SBO:0000658'),
	('R_THRSERNaEx', 'SBO:0000660'),
	('R_TYRt4', 'SBO:0000659'),
	('R_THRt4', 'SBO:0000659'),
	('R_THYMDt1', 'SBO:0000658'),
	('R_THYMDtl', 'SBO:0000658'),
	('R_UPPN', 'SBO:0000376'),
	('R_THYMDtm', 'SBO:0000658'),
	('R_URATEt', 'SBO:0000658'),
	('R_URATEtx', 'SBO:0000658'),
	('R_URAt', 'SBO:0000658'),
	('R_URCN', 'SBO:0000178'),
	('R_UAGALDP', 'SBO:0000402'),
	('R_UDPACGALtl', 'SBO:0000658'),
	('R_UREAt5', 'SBO:0000659'),
	('R_THYMt', 'SBO:0000658'),
	('R_UREAtm', 'SBO:0000658'),
	('R_URIDK2m', 'SBO:0000216'),
	('R_UDPGALtg', 'SBO:0000660'),
	('R_UDPGD', 'SBO:0000200'),
	('R_UDPGLCAter', 'SBO:0000660'),
	('R_UDPGLCAtg', 'SBO:0000660'),
	('R_URIt', 'SBO:0000658'),
	('R_UDPGLCter', 'SBO:0000660'),
	('R_URIt5', 'SBO:0000659'),
	('R_THYOXt', 'SBO:0000660'),
	('R_UROLACer', 'SBO:0000376'),
	('R_UTPtn', 'SBO:0000658'),
	('R_UDPGLCtg', 'SBO:0000660'),
	('R_UDPGLDCg', 'SBO:0000399'),
	('R_Uritl', 'SBO:0000658'),
	('R_THYOXt2', 'SBO:0000658'),
	('R_Uritm', 'SBO:0000658'),
	('R_Uritn', 'SBO:0000658'),
	('R_UDPGNP', 'SBO:0000217'),
	('R_UDPXYLter', 'SBO:0000660'),
	('R_UDPXYLtg', 'SBO:0000660'),
	('R_UDPtl', 'SBO:0000658'),
	('R_VACCCRNt', 'SBO:0000658'),
	('R_VACCt', 'SBO:0000658'),
	('R_UGALGTg', 'SBO:0000217'),
	('R_THYPX', 'SBO:0000200'),
	('R_UGALNACter', 'SBO:0000660'),
	('R_UGALNACtg', 'SBO:0000660'),
	('R_VALt4', 'SBO:0000659'),
	('R_VALt5m', 'SBO:0000658'),
	('R_VALtec', 'SBO:0000658'),
	('R_UGLCNACtg', 'SBO:0000660'),
	('R_UGLT', 'SBO:0000402'),
	('R_UGT1A10r', 'SBO:0000217'),
	('R_UGT1A1r', 'SBO:0000217'),
	('R_VITD2Hm', 'SBO:0000200'),
	('R_VITD2t', 'SBO:0000658'),
	('R_VITD2tm', 'SBO:0000658'),
	('R_UGT1A2r', 'SBO:0000217'),
	('R_UGT1A3r', 'SBO:0000217'),
	('R_UGT1A4r', 'SBO:0000217'),
	('R_UGT1A5r', 'SBO:0000217'),
	('R_UGT1A5r2', 'SBO:0000217'),
	('R_UGT1A6r', 'SBO:0000217'),
	('R_UGT1A7r', 'SBO:0000217'),
	('R_VITD3Hm', 'SBO:0000233'),
	('R_VITD3t', 'SBO:0000658'),
	('R_VITD3t2', 'SBO:0000658'),
	('R_VITD3tm', 'SBO:0000658'),
	('R_VITD3tm3', 'SBO:0000658'),
	('R_UGT1A8r', 'SBO:0000217'),
	('R_UGT1A9r', 'SBO:0000217'),
	('R_TMABADH', 'SBO:0000200'),
	('R_UMPK2', 'SBO:0000216'),
	('R_UMPK2n', 'SBO:0000216'),
	('R_UMPK3', 'SBO:0000216'),
	('R_WHDDCAte', 'SBO:0000658'),
	('R_WHHDCAte', 'SBO:0000658'),
	('R_WHTSTSTERONEte', 'SBO:0000658'),
	('R_WHTTDCAte', 'SBO:0000658'),
	('R_UMPK3n', 'SBO:0000216'),
	('R_UMPK4', 'SBO:0000216'),
	('R_XANDp', 'SBO:0000200'),
	('R_UMPK4n', 'SBO:0000216'),
	('R_XANtx', 'SBO:0000658'),
	('R_XAO2x', 'SBO:0000200'),
	('R_XAOx', 'SBO:0000200'),
	('R_XOL27OHtm', 'SBO:0000658'),
	('R_UMPK5', 'SBO:0000216'),
	('R_UMPK5n', 'SBO:0000216'),
	('R_XOL7AH2tm', 'SBO:0000658'),
	('R_XOL7AH2tr', 'SBO:0000658'),
	('R_XOL7AONEtr', 'SBO:0000658'),
	('R_XOLDIOLONEt', 'SBO:0000658'),
	('R_XOLDIOLONEtm', 'SBO:0000658'),
	('R_XOLEST2te', 'SBO:0000658'),
	('R_XYLTD_D', 'SBO:0000200'),
	('R_XOLESTte', 'SBO:0000658'),
	('R_TMDK1m', 'SBO:0000216'),
	('R_XOLTRI24tc', 'SBO:0000658'),
	('R_XOLTRI24te', 'SBO:0000658'),
	('R_XOLTRI25tc', 'SBO:0000658'),
	('R_XOLTRI25te', 'SBO:0000658'),
	('R_XYLTt', 'SBO:0000658'),
	('R_XYLUR', 'SBO:0000200'),
	('R_XYLt', 'SBO:0000658'),
	('R_XYLtly', 'SBO:0000658'),
	('R_XOLTRI27tc', 'SBO:0000658'),
	('R_XOLTRI27te', 'SBO:0000658'),
	('R_YVITEt', 'SBO:0000658'),
	('R_XOLTRIOLtm', 'SBO:0000658'),
	('R_TMDPK', 'SBO:0000402'),
	('R_XOLTRIOLtr', 'SBO:0000658'),
	('R_XSERtg', 'SBO:0000658'),
	('R_TMDPPK', 'SBO:0000216'),
	('R_TMLYSOX', 'SBO:0000200'),
	('R_TMLYSter', 'SBO:0000658'),
	('R_TMNDNCCOAtx', 'SBO:0000658'),
	('R_TMNDNCCRNt', 'SBO:0000658'),
	('R_TMNDNCt', 'SBO:0000658'),
	('R_TOLBUTAMIDEte', 'SBO:0000658'),
	('R_TRDR2', 'SBO:0000200'),
	('R_TRDR3', 'SBO:0000200'),
	('R_TRDRm', 'SBO:0000200'),
	('R_TREH', 'SBO:0000376'),
	('R_TREHe', 'SBO:0000376'),
	('R_TRIODTHYSUFt', 'SBO:0000658'),
	('R_TRIODTHYSULT', 'SBO:0000220'),
	('R_TRIODTHYt', 'SBO:0000660'),
	('R_TRIODTHYt2', 'SBO:0000658'),
	('R_TRIOK', 'SBO:0000216'),
	('R_TRPt', 'SBO:0000658'),
	('R_TRPt4', 'SBO:0000659'),
	('R_TRYPTAOX', 'SBO:0000401'),
	('R_TSTSTERONEGLCte', 'SBO:0000657'),
	('R_TSTSTERONEGLCtr', 'SBO:0000658'),
	('R_TSTSTERONESte', 'SBO:0000658'),
	('R_TSTSTERONEtr', 'SBO:0000658'),
	('R_TSULt4_3', 'SBO:0000659'),
	('R_4MPTNLte', 'SBO:0000658'),
	('R_5FTHFt2_1', 'SBO:0000660'),
	('R_ACALDtr', 'SBO:0000658'),
	('R_ACHVESSEC_1', 'SBO:0000657'),
	('R_ANDRSTRNGLCtr', 'SBO:0000658'),
	('R_BALAVECSEC_1', 'SBO:0000657'),
	('R_BTNt3i_1', 'SBO:0000657'),
	('R_CAATPS_1', 'SBO:0000657'),
	('R_CK_cho', 'SBO:0000216'),
	('R_CRNt', 'SBO:0000658'),
	('R_CRTSLt', 'SBO:0000658'),
	('R_CYSGLYex', 'SBO:0000660'),
	('R_DESAT18_12', 'SBO:0000200'),
	('R_DHEAtr', 'SBO:0000658'),
	('R_DM_core5_g', 'SBO:0000628'),
	('R_DM_dem2emgacpail_prot_hs_r', 'SBO:0000628'),
	('R_DM_dgpi_prot_hs_r', 'SBO:0000628'),
	('R_DM_n5m2masn_g', 'SBO:0000628'),
	('R_DMNONCRNt', 'SBO:0000658'),
	('R_DOPAVESSEC_1', 'SBO:0000657'),
	('R_ESTRADIOLt', 'SBO:0000658'),
	('R_EX_4mptnl_e', 'SBO:0000627'),
	('R_EX_crtstrn_e', 'SBO:0000627'),
	('R_EX_leuktrB4_e', 'SBO:0000627'),
	('R_EX_leuktrD4_e', 'SBO:0000627'),
	('R_EX_leuktrE4_e', 'SBO:0000627'),
	('R_F1Atg', 'SBO:0000658'),
	('R_FAOXC260240x_1', 'SBO:0000200'),
	('R_G6PDH1er', 'SBO:0000200'),
	('R_GABAVESSEC_1', 'SBO:0000657'),
	('R_GLYVESSEC_1', 'SBO:0000657'),
	('R_GMPtg', 'SBO:0000658'),
	('R_HISTAVESSEC_1', 'SBO:0000657'),
	('R_HPYRR2x_1', 'SBO:0000200'),
	('R_HSD17B42x_1', 'SBO:0000200'),
	('R_IPDPtx', 'SBO:0000658'),
	('R_LEUKTRB4t', 'SBO:0000658'),
	('R_LEUKTRD4t', 'SBO:0000658'),
	('R_LEUKTRE4t', 'SBO:0000658'),
	('R_LEUKTRF4t', 'SBO:0000658'),
	('R_TTCCOAtx', 'SBO:0000658'),
	('R_LIPOti_1', 'SBO:0000657'),
	('R_NOS2_2', 'SBO:0000200'),
	('R_PGLYCt', 'SBO:0000658'),
	('R_PRGSTRNt', 'SBO:0000658'),
	('R_PROSTGI2t', 'SBO:0000660'),
	('R_Ser_Thrtg', 'SBO:0000658'),
	('R_SO4tl', 'SBO:0000658'),
	('R_THMMPt4_1', 'SBO:0000660'),
	('R_THMMPtm_cho', 'SBO:0000660'),
	('R_THMTPt_1', 'SBO:0000660'),
	('R_TSTSTERONEt', 'SBO:0000658'),
	('R_UGT1A10r_1', 'SBO:0000217'),
	('R_UMPtr', 'SBO:0000658'),
	('R_EX_4abutn_e', 'SBO:0000627'),
	('R_EX_acmana_e', 'SBO:0000627'),
	('R_EX_ahdt_e', 'SBO:0000627'),
	('R_EX_dgmp_e', 'SBO:0000627'),
	('R_EX_dgtp_e', 'SBO:0000627'),
	('R_EX_dha_e', 'SBO:0000627'),
	('R_EX_dhap_e', 'SBO:0000627'),
	('R_EX_dttp_e', 'SBO:0000627'),
	('R_EX_isomal_e', 'SBO:0000627'),
	('R_EX_HC00250_e', 'SBO:0000627'),
	('R_EX_HC01361_e', 'SBO:0000627'),
	('R_EX_HC01440_e', 'SBO:0000627'),
	('R_EX_HC01446_e', 'SBO:0000627'),
	('R_EX_HC01577_e', 'SBO:0000627'),
	('R_EX_HC02160_e', 'SBO:0000627'),
	('R_EX_orot_e', 'SBO:0000627'),
	('R_EX_udpg_e', 'SBO:0000627'),
	('R_r0009', 'SBO:0000376'),
	('R_r0013', 'SBO:0000376'),
	('R_r0016', 'SBO:0000200'),
	('R_GDR', 'SBO:0000200'),
	('R_r0023', 'SBO:0000200'),
	('R_r0027', 'SBO:0000200'),
	('R_ACOAHim', 'SBO:0000376'),
	('R_r0074', 'SBO:0000200'),
	('R_r0083', 'SBO:0000200'),
	('R_r0086', 'SBO:0000401'),
	('R_r0142', 'SBO:0000200'),
	('R_r0156', 'SBO:0000403'),
	('R_PYK2', 'SBO:0000216'),
	('R_r0202', 'SBO:0000200'),
	('R_MAN1PT', 'SBO:0000402'),
	('R_DHFR2i', 'SBO:0000200'),
	('R_r0246', 'SBO:0000200'),
	('R_r0249', 'SBO:0000377'),
	('R_ACOAR7m', 'SBO:0000200'),
	('R_r0330', 'SBO:0000200'),
	('R_r0354', 'SBO:0000216'),
	('R_r0361', 'SBO:0000216'),
	('R_r0381', 'SBO:0000200'),
	('R_r0383', 'SBO:0000200'),
	('R_HXAND', 'SBO:0000200'),
	('R_r0402', 'SBO:0000200'),
	('R_r0425', 'SBO:0000200'),
	('R_r0434', 'SBO:0000218'),
	('R_r0437', 'SBO:0000218'),
	('R_r0451', 'SBO:0000200'),
	('R_r0463', 'SBO:0000402'),
	('R_r0480', 'SBO:0000214'),
	('R_HMGCOAR', 'SBO:0000200'),
	('R_r0514', 'SBO:0000200'),
	('R_THFATm', 'SBO:0000402'),
	('R_SPHPL', 'SBO:0000178'),
	('R_r0546', 'SBO:0000200'),
	('R_r0557', 'SBO:0000402'),
	('R_r0558', 'SBO:0000200'),
	('R_r0568', 'SBO:0000402'),
	('R_r0571', 'SBO:0000376'),
	('R_HPROx', 'SBO:0000200'),
	('R_HPROb', 'SBO:0000200'),
	('R_r0627', 'SBO:0000376'),
	('R_r0629', 'SBO:0000402'),
	('R_r0630', 'SBO:0000402'),
	('R_r0633', 'SBO:0000200'),
	('R_r0642', 'SBO:0000200'),
	('R_r0648', 'SBO:0000402'),
	('R_r0656', 'SBO:0000402'),
	('R_r0670', 'SBO:0000200'),
	('R_r0672', 'SBO:0000200'),
	('R_r0688', 'SBO:0000200'),
	('R_HACD6m', 'SBO:0000200'),
	('R_HACD5p', 'SBO:0000200'),
	('R_ACACT5m', 'SBO:0000215'),
	('R_r0730', 'SBO:0000200'),
	('R_r0737', 'SBO:0000376'),
	('R_r0743', 'SBO:0000200'),
	('R_r0750', 'SBO:0000200'),
	('R_r0755', 'SBO:0000200'),
	('R_r0756', 'SBO:0000200'),
	('R_r0782', 'SBO:0000200'),
	('R_r0784', 'SBO:0000200'),
	('R_r0788', 'SBO:0000214'),
	('R_r0789', 'SBO:0000214'),
	('R_r0801', 'SBO:0000660'),
	('R_r0812', 'SBO:0000657'),
	('R_r0819', 'SBO:0000660'),
	('R_r0822', 'SBO:0000660'),
	('R_r0829', 'SBO:0000660'),
	('R_r0830', 'SBO:0000660'),
	('R_r0836', 'SBO:0000660'),
	('R_r0839', 'SBO:0000658'),
	('R_r0840', 'SBO:0000658'),
	('R_r0841', 'SBO:0000658'),
	('R_r0842', 'SBO:0000658'),
	('R_r0845', 'SBO:0000660'),
	('R_r0859', 'SBO:0000657'),
	('R_r0870', 'SBO:0000658'),
	('R_r0885', 'SBO:0000660'),
	('R_r0892', 'SBO:0000658'),
	('R_r0899', 'SBO:0000658'),
	('R_r0907', 'SBO:0000658'),
	('R_r0908', 'SBO:0000658'),
	('R_r0909', 'SBO:0000658'),
	('R_MALICITtm', 'SBO:0000660'),
	('R_r0915', 'SBO:0000660'),
	('R_r0921', 'SBO:0000658'),
	('R_r0924', 'SBO:0000660'),
	('R_r0926', 'SBO:0000658'),
	('R_r0932', 'SBO:0000658'),
	('R_r0936', 'SBO:0000658'),
	('R_r0937', 'SBO:0000658'),
	('R_r0940', 'SBO:0000658'),
	('R_r0942', 'SBO:0000658'),
	('R_SPMDtex2', 'SBO:0000658'),
	('R_r0954', 'SBO:0000658'),
	('R_r0960', 'SBO:0000659'),
	('R_r0962', 'SBO:0000658'),
	('R_r0975', 'SBO:0000658'),
	('R_r0983', 'SBO:0000658'),
	('R_r0984', 'SBO:0000658'),
	('R_r0986', 'SBO:0000658'),
	('R_r0987', 'SBO:0000658'),
	('R_r0989', 'SBO:0000658'),
	('R_r0994', 'SBO:0000658'),
	('R_r0997', 'SBO:0000660'),
	('R_CARN1619Zt_m', 'SBO:0000660'),
	('R_r1002', 'SBO:0000660'),
	('R_r1005', 'SBO:0000660'),
	('R_r1007', 'SBO:0000660'),
	('R_r1008', 'SBO:0000660'),
	('R_r1013', 'SBO:0000658'),
	('R_r1014', 'SBO:0000660'),
	('R_r1017', 'SBO:0000660'),
	('R_r1028', 'SBO:0000657'),
	('R_r1029', 'SBO:0000660'),
	('R_r1043', 'SBO:0000659'),
	('R_r1044', 'SBO:0000659'),
	('R_r1045', 'SBO:0000659'),
	('R_r1051', 'SBO:0000658'),
	('R_CITt2r', 'SBO:0000659'),
	('R_CITt4_1', 'SBO:0000659'),
	('R_r1117', 'SBO:0000658'),
	('R_r1134', 'SBO:0000200'),
	('R_r1143', 'SBO:0000659'),
	('R_r1148', 'SBO:0000660'),
	('R_r1150', 'SBO:0000658'),
	('R_r1155', 'SBO:0000659'),
	('R_r1162', 'SBO:0000657'),
	('R_r1163', 'SBO:0000659'),
	('R_PPCOAtm', 'SBO:0000658'),
	('R_r1292', 'SBO:0000658'),
	('R_r1298', 'SBO:0000658'),
	('R_r1304', 'SBO:0000658'),
	('R_r1364', 'SBO:0000658'),
	('R_r1365', 'SBO:0000658'),
	('R_r1375', 'SBO:0000658'),
	('R_r1378', 'SBO:0000200'),
	('R_r1384', 'SBO:0000401'),
	('R_r1400', 'SBO:0000660'),
	('R_HCO3Ee', 'SBO:0000178'),
	('R_r1421', 'SBO:0000658'),
	('R_PIt', 'SBO:0000658'),
	('R_r1428', 'SBO:0000658'),
	('R_ALAtmi', 'SBO:0000658'),
	('R_r1435', 'SBO:0000658'),
	('R_r1437', 'SBO:0000658'),
	('R_PHEt2m', 'SBO:0000659'),
	('R_r1456', 'SBO:0000660'),
	('R_r1467', 'SBO:0000658'),
	('R_r1468', 'SBO:0000658'),
	('R_GTHRDt2', 'SBO:0000658'),
	('R_r1495', 'SBO:0000659'),
	('R_r1497', 'SBO:0000659'),
	('R_r1498', 'SBO:0000659'),
	('R_r1499', 'SBO:0000659'),
	('R_r1502', 'SBO:0000659'),
	('R_r1503', 'SBO:0000659'),
	('R_r1515', 'SBO:0000657'),
	('R_r1518', 'SBO:0000657'),
	('R_r1519', 'SBO:0000657'),
	('R_r1520', 'SBO:0000657'),
	('R_r1525', 'SBO:0000657'),
	('R_r1530', 'SBO:0000657'),
	('R_r1531_1', 'SBO:0000657'),
	('R_r1533_1', 'SBO:0000657'),
	('R_r1536', 'SBO:0000657'),
	('R_r1540', 'SBO:0000659'),
	('R_r1547', 'SBO:0000660'),
	('R_r1548', 'SBO:0000660'),
	('R_r1549', 'SBO:0000660'),
	('R_r1552', 'SBO:0000660'),
	('R_r1553', 'SBO:0000660'),
	('R_r1554', 'SBO:0000660'),
	('R_r1556', 'SBO:0000660'),
	('R_r1557', 'SBO:0000660'),
	('R_r1560', 'SBO:0000660'),
	('R_r1561', 'SBO:0000660'),
	('R_r1562', 'SBO:0000660'),
	('R_r1564', 'SBO:0000660'),
	('R_r1565', 'SBO:0000660'),
	('R_r1567', 'SBO:0000660'),
	('R_r1568', 'SBO:0000660'),
	('R_r1571', 'SBO:0000660'),
	('R_r1578', 'SBO:0000660'),
	('R_r1579', 'SBO:0000660'),
	('R_r1581', 'SBO:0000660'),
	('R_r1584', 'SBO:0000660'),
	('R_r1585', 'SBO:0000660'),
	('R_r1586', 'SBO:0000660'),
	('R_r1587', 'SBO:0000660'),
	('R_r1588', 'SBO:0000660'),
	('R_r1589', 'SBO:0000660'),
	('R_r1590', 'SBO:0000660'),
	('R_r1591', 'SBO:0000660'),
	('R_r1593', 'SBO:0000660'),
	('R_r1594', 'SBO:0000660'),
	('R_r1595', 'SBO:0000660'),
	('R_r1597', 'SBO:0000660'),
	('R_r1603', 'SBO:0000660'),
	('R_r1604', 'SBO:0000660'),
	('R_r1610', 'SBO:0000660'),
	('R_r1611', 'SBO:0000660'),
	('R_r1612', 'SBO:0000660'),
	('R_r1613', 'SBO:0000660'),
	('R_r1615', 'SBO:0000660'),
	('R_r1616', 'SBO:0000660'),
	('R_r1617', 'SBO:0000660'),
	('R_TYRPHELAT2tc', 'SBO:0000660'),
	('R_CYSPHELAT2tc', 'SBO:0000660'),
	('R_r1621', 'SBO:0000660'),
	('R_ASNPHELAT2tc', 'SBO:0000660'),
	('R_VALPHELAT2tc', 'SBO:0000660'),
	('R_THRPHELAT2tc', 'SBO:0000660'),
	('R_ILEPHELAT2tc', 'SBO:0000660'),
	('R_r1629', 'SBO:0000660'),
	('R_r1630', 'SBO:0000660'),
	('R_r1631', 'SBO:0000660'),
	('R_r1632', 'SBO:0000660'),
	('R_r1634', 'SBO:0000660'),
	('R_r1637', 'SBO:0000660'),
	('R_r1641', 'SBO:0000660'),
	('R_r1645', 'SBO:0000660'),
	('R_ILELAT1tc', 'SBO:0000660'),
	('R_r1648', 'SBO:0000660'),
	('R_r1649', 'SBO:0000660'),
	('R_r1652', 'SBO:0000660'),
	('R_r1657', 'SBO:0000660'),
	('R_r1659', 'SBO:0000660'),
	('R_r1661', 'SBO:0000660'),
	('R_r1666', 'SBO:0000660'),
	('R_r1671', 'SBO:0000660'),
	('R_r1673', 'SBO:0000660'),
	('R_r1674', 'SBO:0000660'),
	('R_r1676', 'SBO:0000660'),
	('R_r1678', 'SBO:0000660'),
	('R_r1680', 'SBO:0000660'),
	('R_r1685', 'SBO:0000660'),
	('R_r1686', 'SBO:0000660'),
	('R_r1692', 'SBO:0000660'),
	('R_r1693', 'SBO:0000660'),
	('R_r1696', 'SBO:0000660'),
	('R_r1700', 'SBO:0000660'),
	('R_r1701', 'SBO:0000660'),
	('R_r1705', 'SBO:0000660'),
	('R_r1706', 'SBO:0000660'),
	('R_r1707', 'SBO:0000660'),
	('R_r1710', 'SBO:0000660'),
	('R_r1717', 'SBO:0000660'),
	('R_r1722', 'SBO:0000660'),
	('R_r1723', 'SBO:0000660'),
	('R_r1726', 'SBO:0000660'),
	('R_r1731', 'SBO:0000660'),
	('R_r1732', 'SBO:0000660'),
	('R_r1736', 'SBO:0000660'),
	('R_r1744', 'SBO:0000660'),
	('R_r1745', 'SBO:0000660'),
	('R_r1746', 'SBO:0000660'),
	('R_r1747', 'SBO:0000660'),
	('R_r1748', 'SBO:0000660'),
	('R_r1750', 'SBO:0000660'),
	('R_r1752', 'SBO:0000660'),
	('R_r1753', 'SBO:0000660'),
	('R_r1754', 'SBO:0000660'),
	('R_r1755', 'SBO:0000660'),
	('R_r1758', 'SBO:0000660'),
	('R_r1762', 'SBO:0000660'),
	('R_r1763', 'SBO:0000660'),
	('R_r1764', 'SBO:0000660'),
	('R_r1766', 'SBO:0000660'),
	('R_r1768', 'SBO:0000660'),
	('R_r1771', 'SBO:0000660'),
	('R_r1774', 'SBO:0000660'),
	('R_r1778', 'SBO:0000660'),
	('R_r1779', 'SBO:0000660'),
	('R_r1781', 'SBO:0000660'),
	('R_r1783', 'SBO:0000660'),
	('R_r1784', 'SBO:0000660'),
	('R_r1786', 'SBO:0000660'),
	('R_r1789', 'SBO:0000660'),
	('R_r1790', 'SBO:0000660'),
	('R_r1791', 'SBO:0000660'),
	('R_r1792', 'SBO:0000660'),
	('R_r1796', 'SBO:0000660'),
	('R_r1797', 'SBO:0000660'),
	('R_r1798', 'SBO:0000660'),
	('R_r1799', 'SBO:0000660'),
	('R_r1805', 'SBO:0000660'),
	('R_r1806', 'SBO:0000660'),
	('R_r1809', 'SBO:0000660'),
	('R_r1811', 'SBO:0000660'),
	('R_r1814', 'SBO:0000660'),
	('R_r1817', 'SBO:0000660'),
	('R_r1818', 'SBO:0000660'),
	('R_r1820', 'SBO:0000660'),
	('R_r1821', 'SBO:0000660'),
	('R_r1822', 'SBO:0000660'),
	('R_r1823', 'SBO:0000660'),
	('R_r1824', 'SBO:0000660'),
	('R_r1827', 'SBO:0000660'),
	('R_r1829', 'SBO:0000660'),
	('R_r1830', 'SBO:0000660'),
	('R_r1832', 'SBO:0000660'),
	('R_r1833', 'SBO:0000660'),
	('R_r1836', 'SBO:0000660'),
	('R_r1837', 'SBO:0000660'),
	('R_r1841', 'SBO:0000660'),
	('R_r1842', 'SBO:0000660'),
	('R_r1846', 'SBO:0000660'),
	('R_r1847', 'SBO:0000660'),
	('R_r1848', 'SBO:0000660'),
	('R_r1851', 'SBO:0000660'),
	('R_r1853', 'SBO:0000660'),
	('R_r1854', 'SBO:0000660'),
	('R_r1855', 'SBO:0000660'),
	('R_r1857', 'SBO:0000660'),
	('R_r1858', 'SBO:0000660'),
	('R_r1860', 'SBO:0000660'),
	('R_r1861', 'SBO:0000660'),
	('R_r1864', 'SBO:0000660'),
	('R_r1865', 'SBO:0000660'),
	('R_r1867', 'SBO:0000660'),
	('R_r1874', 'SBO:0000660'),
	('R_r1876', 'SBO:0000660'),
	('R_r1877', 'SBO:0000660'),
	('R_r1880', 'SBO:0000660'),
	('R_r1881', 'SBO:0000660'),
	('R_r1882', 'SBO:0000660'),
	('R_r1885', 'SBO:0000660'),
	('R_r1887', 'SBO:0000660'),
	('R_r1889', 'SBO:0000660'),
	('R_r1890', 'SBO:0000660'),
	('R_r1892', 'SBO:0000660'),
	('R_r1893', 'SBO:0000660'),
	('R_r1898', 'SBO:0000660'),
	('R_r1899', 'SBO:0000660'),
	('R_r1900', 'SBO:0000660'),
	('R_r1901', 'SBO:0000660'),
	('R_r1903', 'SBO:0000660'),
	('R_r1904', 'SBO:0000660'),
	('R_r1905', 'SBO:0000660'),
	('R_r1907', 'SBO:0000660'),
	('R_r1908', 'SBO:0000660'),
	('R_r1910', 'SBO:0000660'),
	('R_r1912', 'SBO:0000660'),
	('R_r1916', 'SBO:0000660'),
	('R_r1918', 'SBO:0000660'),
	('R_r1920', 'SBO:0000660'),
	('R_r1921', 'SBO:0000660'),
	('R_r1925', 'SBO:0000660'),
	('R_r1928', 'SBO:0000660'),
	('R_r1932', 'SBO:0000660'),
	('R_r1935', 'SBO:0000660'),
	('R_r1940', 'SBO:0000660'),
	('R_r1944', 'SBO:0000660'),
	('R_r1945', 'SBO:0000660'),
	('R_r1948', 'SBO:0000660'),
	('R_r1949', 'SBO:0000660'),
	('R_r1951', 'SBO:0000660'),
	('R_r1954', 'SBO:0000660'),
	('R_r1957', 'SBO:0000660'),
	('R_r1961', 'SBO:0000660'),
	('R_r1962', 'SBO:0000660'),
	('R_r1963', 'SBO:0000660'),
	('R_r1964', 'SBO:0000660'),
	('R_r1965', 'SBO:0000660'),
	('R_r1967', 'SBO:0000660'),
	('R_r1970', 'SBO:0000660'),
	('R_r1972', 'SBO:0000660'),
	('R_r1974', 'SBO:0000660'),
	('R_r1976', 'SBO:0000660'),
	('R_r1980', 'SBO:0000660'),
	('R_r1981', 'SBO:0000660'),
	('R_r1983', 'SBO:0000660'),
	('R_r1984', 'SBO:0000660'),
	('R_r1985', 'SBO:0000660'),
	('R_r1986', 'SBO:0000660'),
	('R_r1987', 'SBO:0000660'),
	('R_r1989', 'SBO:0000660'),
	('R_r1997', 'SBO:0000660'),
	('R_r2000', 'SBO:0000660'),
	('R_r2001', 'SBO:0000660'),
	('R_r2003', 'SBO:0000660'),
	('R_r2004', 'SBO:0000660'),
	('R_r2005', 'SBO:0000660'),
	('R_r2007', 'SBO:0000660'),
	('R_r2011', 'SBO:0000660'),
	('R_r2013', 'SBO:0000660'),
	('R_r2014', 'SBO:0000660'),
	('R_r2016', 'SBO:0000660'),
	('R_r2017', 'SBO:0000660'),
	('R_r2018', 'SBO:0000660'),
	('R_r2021', 'SBO:0000660'),
	('R_r2023', 'SBO:0000660'),
	('R_r2026', 'SBO:0000660'),
	('R_r2030', 'SBO:0000660'),
	('R_r2031', 'SBO:0000660'),
	('R_r2032', 'SBO:0000660'),
	('R_r2035', 'SBO:0000660'),
	('R_r2036', 'SBO:0000660'),
	('R_r2038', 'SBO:0000660'),
	('R_r2039', 'SBO:0000660'),
	('R_r2040', 'SBO:0000660'),
	('R_r2041', 'SBO:0000660'),
	('R_r2046', 'SBO:0000660'),
	('R_r2047', 'SBO:0000660'),
	('R_r2048', 'SBO:0000660'),
	('R_r2049', 'SBO:0000660'),
	('R_r2050', 'SBO:0000660'),
	('R_r2051', 'SBO:0000660'),
	('R_r2055', 'SBO:0000660'),
	('R_r2056', 'SBO:0000660'),
	('R_r2058', 'SBO:0000660'),
	('R_r2060', 'SBO:0000660'),
	('R_r2063', 'SBO:0000660'),
	('R_r2065', 'SBO:0000660'),
	('R_r2067', 'SBO:0000660'),
	('R_r2068', 'SBO:0000660'),
	('R_r2071', 'SBO:0000660'),
	('R_r2073_1', 'SBO:0000659'),
	('R_r2080', 'SBO:0000660'),
	('R_r2081', 'SBO:0000660'),
	('R_r2084', 'SBO:0000660'),
	('R_r2085', 'SBO:0000660'),
	('R_r2086', 'SBO:0000660'),
	('R_r2087', 'SBO:0000660'),
	('R_r2088', 'SBO:0000660'),
	('R_r2089', 'SBO:0000660'),
	('R_r2090', 'SBO:0000660'),
	('R_r2092', 'SBO:0000660'),
	('R_r2093', 'SBO:0000660'),
	('R_r2094', 'SBO:0000660'),
	('R_r2096', 'SBO:0000660'),
	('R_r2100', 'SBO:0000660'),
	('R_r2101', 'SBO:0000660'),
	('R_r2104', 'SBO:0000660'),
	('R_r2106', 'SBO:0000660'),
	('R_r2108', 'SBO:0000660'),
	('R_r2111', 'SBO:0000660'),
	('R_r2113', 'SBO:0000660'),
	('R_r2114', 'SBO:0000660'),
	('R_r2115', 'SBO:0000660'),
	('R_r2120', 'SBO:0000660'),
	('R_r2121', 'SBO:0000660'),
	('R_r2122', 'SBO:0000660'),
	('R_r2123', 'SBO:0000660'),
	('R_r2125', 'SBO:0000660'),
	('R_r2126', 'SBO:0000660'),
	('R_r2130', 'SBO:0000660'),
	('R_r2133', 'SBO:0000660'),
	('R_r2139', 'SBO:0000660'),
	('R_r2141', 'SBO:0000660'),
	('R_r2146', 'SBO:0000660'),
	('R_r2149', 'SBO:0000660'),
	('R_r2150', 'SBO:0000660'),
	('R_r2151', 'SBO:0000660'),
	('R_r2153', 'SBO:0000660'),
	('R_r2159', 'SBO:0000660'),
	('R_r2164', 'SBO:0000660'),
	('R_r2165', 'SBO:0000660'),
	('R_r2166', 'SBO:0000660'),
	('R_r2167', 'SBO:0000660'),
	('R_r2172', 'SBO:0000660'),
	('R_r2173', 'SBO:0000660'),
	('R_r2175', 'SBO:0000660'),
	('R_r2176', 'SBO:0000660'),
	('R_r2177', 'SBO:0000660'),
	('R_r2178', 'SBO:0000660'),
	('R_r2179', 'SBO:0000660'),
	('R_r2189', 'SBO:0000660'),
	('R_r2191', 'SBO:0000660'),
	('R_r2192', 'SBO:0000660'),
	('R_r2193', 'SBO:0000660'),
	('R_r2195', 'SBO:0000660'),
	('R_r2196', 'SBO:0000660'),
	('R_r2199', 'SBO:0000660'),
	('R_r2201', 'SBO:0000660'),
	('R_r2202', 'SBO:0000660'),
	('R_r2204', 'SBO:0000660'),
	('R_r2205', 'SBO:0000660'),
	('R_r2206', 'SBO:0000660'),
	('R_r2210', 'SBO:0000660'),
	('R_r2211', 'SBO:0000660'),
	('R_r2212', 'SBO:0000660'),
	('R_r2213', 'SBO:0000660'),
	('R_r2215', 'SBO:0000660'),
	('R_r2217', 'SBO:0000660'),
	('R_r2219', 'SBO:0000660'),
	('R_r2226', 'SBO:0000660'),
	('R_r2227', 'SBO:0000660'),
	('R_r2228', 'SBO:0000660'),
	('R_r2229', 'SBO:0000660'),
	('R_r2230', 'SBO:0000660'),
	('R_r2231', 'SBO:0000660'),
	('R_r2233', 'SBO:0000660'),
	('R_r2236', 'SBO:0000660'),
	('R_r2237', 'SBO:0000660'),
	('R_r2238', 'SBO:0000660'),
	('R_r2239', 'SBO:0000660'),
	('R_r2242', 'SBO:0000660'),
	('R_r2244', 'SBO:0000660'),
	('R_r2245', 'SBO:0000660'),
	('R_r2246', 'SBO:0000660'),
	('R_r2247', 'SBO:0000660'),
	('R_r2248', 'SBO:0000660'),
	('R_r2249', 'SBO:0000660'),
	('R_r2250', 'SBO:0000660'),
	('R_r2255', 'SBO:0000660'),
	('R_r2256', 'SBO:0000660'),
	('R_r2257', 'SBO:0000660'),
	('R_r2258', 'SBO:0000660'),
	('R_r2260', 'SBO:0000660'),
	('R_r2264', 'SBO:0000660'),
	('R_r2265', 'SBO:0000660'),
	('R_r2266', 'SBO:0000660'),
	('R_r2268', 'SBO:0000660'),
	('R_r2273', 'SBO:0000660'),
	('R_r2275', 'SBO:0000660'),
	('R_r2276', 'SBO:0000660'),
	('R_r2277', 'SBO:0000660'),
	('R_r2278', 'SBO:0000660'),
	('R_r2282', 'SBO:0000660'),
	('R_r2283', 'SBO:0000660'),
	('R_r2289', 'SBO:0000660'),
	('R_r2293', 'SBO:0000660'),
	('R_r2294', 'SBO:0000660'),
	('R_r2297', 'SBO:0000660'),
	('R_r2299', 'SBO:0000660'),
	('R_r2300', 'SBO:0000660'),
	('R_r2342', 'SBO:0000658'),
	('R_r2301', 'SBO:0000660'),
	('R_r2307', 'SBO:0000660'),
	('R_r2309', 'SBO:0000660'),
	('R_r2310', 'SBO:0000660'),
	('R_r2313', 'SBO:0000660'),
	('R_r2315', 'SBO:0000660'),
	('R_r2317', 'SBO:0000660'),
	('R_r2321', 'SBO:0000660'),
	('R_r2324', 'SBO:0000660'),
	('R_r2325', 'SBO:0000660'),
	('R_r2331', 'SBO:0000660'),
	('R_r2332', 'SBO:0000660'),
	('R_r2333', 'SBO:0000660'),
	('R_r2334', 'SBO:0000660'),
	('R_r2439', 'SBO:0000660'),
	('R_r2335', 'SBO:0000660'),
	('R_r2341', 'SBO:0000658'),
	('R_RE0512X', 'SBO:0000200'),
	('R_r2344', 'SBO:0000658'),
	('R_r2347', 'SBO:0000658'),
	('R_r2352', 'SBO:0000658'),
	('R_RE0568C', 'SBO:0000200'),
	('R_r2354', 'SBO:0000658'),
	('R_r2472', 'SBO:0000660'),
	('R_G6Pt6er', 'SBO:0000660'),
	('R_RE0569C', 'SBO:0000399'),
	('R_r2484', 'SBO:0000660'),
	('R_r2486', 'SBO:0000660'),
	('R_r2355', 'SBO:0000658'),
	('R_r2357', 'SBO:0000658'),
	('R_r2358', 'SBO:0000658'),
	('R_r2487', 'SBO:0000660'),
	('R_r2359', 'SBO:0000658'),
	('R_r2488', 'SBO:0000660'),
	('R_RE0569E', 'SBO:0000399'),
	('R_r2489', 'SBO:0000660'),
	('R_r2491', 'SBO:0000660'),
	('R_r2360', 'SBO:0000658'),
	('R_r2362', 'SBO:0000658'),
	('R_r2363', 'SBO:0000658'),
	('R_r2366', 'SBO:0000658'),
	('R_r2492', 'SBO:0000660'),
	('R_r2493', 'SBO:0000660'),
	('R_r2496', 'SBO:0000660'),
	('R_r2369', 'SBO:0000658'),
	('R_r2374', 'SBO:0000660'),
	('R_r2375', 'SBO:0000660'),
	('R_r2377', 'SBO:0000660'),
	('R_r2382', 'SBO:0000660'),
	('R_r2502', 'SBO:0000657'),
	('R_r2505', 'SBO:0000657'),
	('R_r2506', 'SBO:0000659'),
	('R_r2509', 'SBO:0000660'),
	('R_r2510', 'SBO:0000660'),
	('R_r2384', 'SBO:0000660'),
	('R_r2385', 'SBO:0000660'),
	('R_r2512', 'SBO:0000660'),
	('R_r2387', 'SBO:0000660'),
	('R_r2514', 'SBO:0000660'),
	('R_r2388', 'SBO:0000660'),
	('R_r2515', 'SBO:0000660'),
	('R_RE0570C', 'SBO:0000200'),
	('R_r2516', 'SBO:0000659'),
	('R_r2517', 'SBO:0000657'),
	('R_r2396', 'SBO:0000660'),
	('R_r2399', 'SBO:0000660'),
	('R_r2400', 'SBO:0000660'),
	('R_r2404', 'SBO:0000660'),
	('R_r2518', 'SBO:0000657'),
	('R_r2519', 'SBO:0000658'),
	('R_r2520', 'SBO:0000660'),
	('R_r2405', 'SBO:0000660'),
	('R_r2407', 'SBO:0000660'),
	('R_GLNt', 'SBO:0000658'),
	('R_r2532', 'SBO:0000658'),
	('R_r2408', 'SBO:0000660'),
	('R_RE0689E', 'SBO:0000401'),
	('R_r2409', 'SBO:0000660'),
	('R_r2411', 'SBO:0000660'),
	('R_r2534', 'SBO:0000658'),
	('R_r2538', 'SBO:0000658'),
	('R_r2412', 'SBO:0000660'),
	('R_r2419', 'SBO:0000660'),
	('R_RE0690E', 'SBO:0000401'),
	('R_RE1518X', 'SBO:0000200'),
	('R_RE1519X', 'SBO:0000200'),
	('R_RE0691C', 'SBO:0000403'),
	('R_RE1526M', 'SBO:0000200'),
	('R_RE1526X', 'SBO:0000200'),
	('R_RE1527M', 'SBO:0000200'),
	('R_RE1527X', 'SBO:0000200'),
	('R_RE2030M', 'SBO:0000215'),
	('R_RE2034C', 'SBO:0000403'),
	('R_RE1587C', 'SBO:0000200'),
	('R_RE1630C', 'SBO:0000214'),
	('R_RE1632C', 'SBO:0000200'),
	('R_RE1804M', 'SBO:0000200'),
	('R_RE1807C', 'SBO:0000200'),
	('R_RE2112R', 'SBO:0000200'),
	('R_RE1810M', 'SBO:0000200'),
	('R_RE1826C', 'SBO:0000200'),
	('R_RE1835C', 'SBO:0000376'),
	('R_RE1845C', 'SBO:0000402'),
	('R_RE2155C', 'SBO:0000200'),
	('R_RE1901R', 'SBO:0000200'),
	('R_RE1134C', 'SBO:0000200'),
	('R_SPMDAT1', 'SBO:0000215'),
	('R_RE2240C', 'SBO:0000233'),
	('R_RE1342C', 'SBO:0000200'),
	('R_RE2386C', 'SBO:0000214'),
	('R_RE2405C', 'SBO:0000217'),
	('R_RE2427M', 'SBO:0000402'),
	('R_RE1516X', 'SBO:0000200'),
	('R_RE2526C', 'SBO:0000200'),
	('R_RE1517M', 'SBO:0000200'),
	('R_RE2625M', 'SBO:0000200'),
	('R_RE2626M', 'SBO:0000200'),
	('R_RE2636C', 'SBO:0000200'),
	('R_RE2814M', 'SBO:0000200'),
	('R_RE3041C', 'SBO:0000200'),
	('R_RE2991X', 'SBO:0000200'),
	('R_RE3050R', 'SBO:0000200'),
	('R_RE3076X', 'SBO:0000200'),
	('R_RE3001M', 'SBO:0000200'),
	('R_RE3005M', 'SBO:0000200'),
	('R_RE3010C', 'SBO:0000200'),
	('R_RE3010X', 'SBO:0000200'),
	('R_RE3011R', 'SBO:0000200'),
	('R_RE3013C', 'SBO:0000200'),
	('R_RE3103C', 'SBO:0000399'),
	('R_RE3014R', 'SBO:0000200'),
	('R_RE3224C', 'SBO:0000399'),
	('R_RE3104C', 'SBO:0000200'),
	('R_RE3232C', 'SBO:0000200'),
	('R_RE3234C', 'SBO:0000200'),
	('R_RE3108C', 'SBO:0000200'),
	('R_RE3236C', 'SBO:0000200'),
	('R_RE3241C', 'SBO:0000399'),
	('R_RE3432C', 'SBO:0000200'),
	('R_RE3434C', 'SBO:0000200'),
	('R_RE3436C', 'SBO:0000200'),
	('R_RE3251C', 'SBO:0000200'),
	('R_RE3251M', 'SBO:0000200'),
	('R_RE3476C', 'SBO:0000200'),
	('R_RE3476M', 'SBO:0000200'),
	('R_RE3110C', 'SBO:0000399'),
	('R_RE3286C', 'SBO:0000200'),
	('R_RE3287C', 'SBO:0000200'),
	('R_RE3288C', 'SBO:0000200'),
	('R_RE3289C', 'SBO:0000200'),
	('R_RE3307C', 'SBO:0000200'),
	('R_RE3346M', 'SBO:0000200'),
	('R_RE3367E', 'SBO:0000401'),
	('R_RE3119C', 'SBO:0000200'),
	('R_EX_CE2250_e', 'SBO:0000627'),
	('R_EX_CE1935_e', 'SBO:0000627'),
	('R_EX_CE1943_e', 'SBO:0000627'),
	('R_RE3597C', 'SBO:0000200'),
	('R_RE3120C', 'SBO:0000399'),
	('R_RE3597M', 'SBO:0000200'),
	('R_RE3597X', 'SBO:0000200'),
	('R_EX_CE1939_e', 'SBO:0000627'),
	('R_EX_CE2915_e', 'SBO:0000627'),
	('R_EX_CE4722_e', 'SBO:0000627'),
	('R_EX_CE4723_e', 'SBO:0000627'),
	('R_EX_prostgh2_e', 'SBO:0000627'),
	('R_EX_citr__L_e', 'SBO:0000627'),
	('R_EX_HC00822_e', 'SBO:0000627'),
	('R_EX_C02528_e', 'SBO:0000627'),
	('R_EX_HC02192_e', 'SBO:0000627'),
	('R_EX_HC02195_e', 'SBO:0000627'),
	('R_EX_HC02191_e', 'SBO:0000627'),
	('R_EX_HC02198_e', 'SBO:0000627'),
	('R_EX_HC02203_e', 'SBO:0000627'),
	('R_EX_HC02204_e', 'SBO:0000627'),
	('R_EX_HC02205_e', 'SBO:0000627'),
	('R_EX_HC02206_e', 'SBO:0000627'),
	('R_EX_HC02207_e', 'SBO:0000627'),
	('R_EX_HC02213_e', 'SBO:0000627'),
	('R_EX_HC02217_e', 'SBO:0000627'),
	('R_EX_arachcoa_e', 'SBO:0000627'),
	('R_EX_coa_e', 'SBO:0000627'),
	('R_EX_CE4724_e', 'SBO:0000627'),
	('R_EX_malthp_e', 'SBO:0000627'),
	('R_EX_CE2838_e', 'SBO:0000627'),
	('R_EX_cynt_e', 'SBO:0000627'),
	('R_EX_3ump_e', 'SBO:0000627'),
	('R_EX_CE5786_e', 'SBO:0000627'),
	('R_EX_CE5797_e', 'SBO:0000627'),
	('R_EX_CE5787_e', 'SBO:0000627'),
	('R_EX_CE5868_e', 'SBO:0000627'),
	('R_EX_CE4881_e', 'SBO:0000627'),
	('R_EX_CE5854_e', 'SBO:0000627'),
	('R_EX_cdpea_e', 'SBO:0000627'),
	('R_EX_CE5853_e', 'SBO:0000627'),
	('R_EX_CE1925_e', 'SBO:0000627'),
	('R_RE3156X', 'SBO:0000200'),
	('R_C141OHe', 'SBO:0000658'),
	('R_RE3165C', 'SBO:0000399'),
	('R_RE3168C', 'SBO:0000200'),
	('R_C162ACBP', 'SBO:0000658'),
	('R_RE3169C', 'SBO:0000200'),
	('R_ACRNtp', 'SBO:0000658'),
	('R_BIOMASS_reaction', 'SBO:0000629'),
	('R_RE3170C', 'SBO:0000399'),
	('R_3HBCOARc', 'SBO:0000658'),
	('R_RE3174C', 'SBO:0000399'),
	('R_C3DCe', 'SBO:0000658'),
	('R_RE3175C', 'SBO:0000200'),
	('R_C4CRNe', 'SBO:0000658'),
	('R_C4DCCACT', 'SBO:0000658'),
	('R_C10DCe', 'SBO:0000658'),
	('R_RE3178M', 'SBO:0000200'),
	('R_C4DCe', 'SBO:0000658'),
	('R_C4tcx', 'SBO:0000658'),
	('R_C4tmc', 'SBO:0000658'),
	('R_C12DCTD', 'SBO:0000658'),
	('R_C12DCe', 'SBO:0000658'),
	('R_C5DCe', 'SBO:0000658'),
	('R_RE3179M', 'SBO:0000200'),
	('R_C6DCCACT', 'SBO:0000658'),
	('R_C81CRNe', 'SBO:0000658'),
	('R_SK_dd2coa_c', 'SBO:0000632'),
	('R_DDCRNe', 'SBO:0000658'),
	('R_SK_decdicoa_c', 'SBO:0000632'),
	('R_DOCOSACTDe', 'SBO:0000658'),
	('R_DOCOSACTDr', 'SBO:0000658'),
	('R_DOCOSCOAtxc', 'SBO:0000657'),
	('R_EX_3hdececrn_e', 'SBO:0000627'),
	('R_EX_3ivcrn_e', 'SBO:0000627'),
	('R_EX_3thexddcoacrn_e', 'SBO:0000627'),
	('R_EX_c101crn_e', 'SBO:0000627'),
	('R_EX_c10crn_e', 'SBO:0000627'),
	('R_EX_c10dc_e', 'SBO:0000627'),
	('R_EX_c12dc_e', 'SBO:0000627'),
	('R_EX_c3dc_e', 'SBO:0000627'),
	('R_DOCO13EFATP', 'SBO:0000657'),
	('R_FAOXC16C16OHm', 'SBO:0000200'),
	('R_EX_c4dc_e', 'SBO:0000627'),
	('R_FAOXC123C102x', 'SBO:0000200'),
	('R_FAOXC16DCC14DCx', 'SBO:0000200'),
	('R_FAOXC16OHC16r', 'SBO:0000200'),
	('R_FAOXC170150m', 'SBO:0000200'),
	('R_FAOXC181C181OHm', 'SBO:0000200'),
	('R_FAOXC182C162m', 'SBO:0000200'),
	('R_FAOXC183C163m', 'SBO:0000200'),
	('R_EX_c5dc_e', 'SBO:0000627'),
	('R_FAOXC120100x', 'SBO:0000200'),
	('R_EX_c6crn_e', 'SBO:0000627'),
	('R_EX_c8crn_e', 'SBO:0000627'),
	('R_EX_decdicrn_e', 'SBO:0000627'),
	('R_FAOXC184C163x', 'SBO:0000200'),
	('R_FAOXC184C164m', 'SBO:0000200'),
	('R_FAOXC185C164m', 'SBO:0000200'),
	('R_FAOXC18C18OHm', 'SBO:0000200'),
	('R_EX_docosac_e', 'SBO:0000627'),
	('R_EX_docosdiac_e', 'SBO:0000627'),
	('R_EX_dca_e', 'SBO:0000627'),
	('R_FAOXC101C8x', 'SBO:0000200'),
	('R_FAOXC12DCC10DCx', 'SBO:0000200'),
	('R_FAOXC102C101m', 'SBO:0000200'),
	('R_FAOXC102C81m', 'SBO:0000200'),
	('R_FAOXC221C201x', 'SBO:0000200'),
	('R_FAOXC225C204m', 'SBO:0000200'),
	('R_FAOXC225C226m', 'SBO:0000200'),
	('R_FAOXC102C81x', 'SBO:0000200'),
	('R_FAOXC226C225m', 'SBO:0000200'),
	('R_FAOXC227C226m', 'SBO:0000200'),
	('R_FAOXC22C22DCHYr', 'SBO:0000200'),
	('R_FAOXC22OHC22r', 'SBO:0000200'),
	('R_FAOXC103C102m', 'SBO:0000200'),
	('R_FAOXC103C102x', 'SBO:0000200'),
	('R_FAOXC10C10OHm', 'SBO:0000200'),
	('R_FAOXC10080m', 'SBO:0000200'),
	('R_FAOXC10080x', 'SBO:0000200'),
	('R_FAOXC121C101m', 'SBO:0000200'),
	('R_FAOXC4020m', 'SBO:0000200'),
	('R_FAOXC6C4x', 'SBO:0000200'),
	('R_FAOXC6DCC4DCx', 'SBO:0000200'),
	('R_EX_dchac_e', 'SBO:0000627'),
	('R_FAOXC81C61m', 'SBO:0000200'),
	('R_FAOXC8C6m', 'SBO:0000200'),
	('R_FAOXC8DCC6DCx', 'SBO:0000200'),
	('R_FAOXC13BRC11BRx', 'SBO:0000200'),
	('R_FAOXC9C7m', 'SBO:0000200'),
	('R_FAOXOHC16C16DCc', 'SBO:0000200'),
	('R_FAOXOHC22C22DCc', 'SBO:0000200'),
	('R_STCOATxc', 'SBO:0000657'),
	('R_FAOXC13C11m', 'SBO:0000200'),
	('R_FAOXC141C141OHm', 'SBO:0000200'),
	('R_TDCRNe', 'SBO:0000658'),
	('R_FAOXC142C122m', 'SBO:0000200'),
	('R_SK_tetdec2coa_c', 'SBO:0000632'),
	('R_SK_tetdece1coa_c', 'SBO:0000632'),
	('R_TETDECE1CRNe', 'SBO:0000658'),
	('R_TIGCRNe', 'SBO:0000658'),
	('R_FAOXC142C122x', 'SBO:0000200'),
	('R_FAOXC143C123m', 'SBO:0000200'),
	('R_FAOXC143C123x', 'SBO:0000200'),
	('R_FAOXC140120m', 'SBO:0000200'),
	('R_FAOXC14C14OHm', 'SBO:0000200'),
	('R_34DHPHELAT1tc', 'SBO:0000660'),
	('R_4OHPROIMINOtc', 'SBO:0000659'),
	('R_FAOXOHMC10DC10c', 'SBO:0000200'),
	('R_FAOXTC162TC142m', 'SBO:0000200'),
	('R_FAOXTC182TC162m', 'SBO:0000200'),
	('R_ALAALAPEPT1tc', 'SBO:0000659'),
	('R_ALAyLATthc', 'SBO:0000660'),
	('R_FAOXC15BRC13BRx', 'SBO:0000200'),
	('R_ARGATB0tc', 'SBO:0000659'),
	('R_FOAXC122C101x', 'SBO:0000200'),
	('R_FAOXC15NADx', 'SBO:0000200'),
	('R_ASNATB0tc', 'SBO:0000659'),
	('R_BALAt2r', 'SBO:0000659'),
	('R_HDCACBP', 'SBO:0000658'),
	('R_FAOXC161C141m', 'SBO:0000200'),
	('R_BTNTe', 'SBO:0000658'),
	('R_FAOXC161C141x', 'SBO:0000200'),
	('R_CARPEPT1tc', 'SBO:0000659'),
	('R_CYSSNAT5tc', 'SBO:0000660'),
	('R_CYSTLEUrBATtc', 'SBO:0000660'),
	('R_HEXDIACtr', 'SBO:0000658'),
	('R_HEXDICOAACBPx', 'SBO:0000658'),
	('R_HIVCACBP', 'SBO:0000658'),
	('R_GALSGLT1le', 'SBO:0000657'),
	('R_HIVCRNe', 'SBO:0000658'),
	('R_FAOXC161C161OHm', 'SBO:0000200'),
	('R_HTDCACBP', 'SBO:0000658'),
	('R_HTDCRNe', 'SBO:0000658'),
	('R_IVCOAACBP', 'SBO:0000658'),
	('R_GLNATB0tc', 'SBO:0000659'),
	('R_GLYPHEPEPT1tc', 'SBO:0000659'),
	('R_IVCRNe', 'SBO:0000658'),
	('R_LGNCCOAtcx_1', 'SBO:0000657'),
	('R_NRVNCCOAtxc', 'SBO:0000657'),
	('R_FAOXC162C162OHm', 'SBO:0000200'),
	('R_OCT11EFATP_1', 'SBO:0000657'),
	('R_HISSNAT5tc', 'SBO:0000660'),
	('R_HISyLATtc', 'SBO:0000660'),
	('R_FAOXC163C142x', 'SBO:0000200'),
	('R_HPETFABP1tc', 'SBO:0000658'),
	('R_LEUATB0tc', 'SBO:0000659'),
	('R_LEUGLYPEPT1tc', 'SBO:0000659'),
	('R_LEULEUPEPT1tc', 'SBO:0000659'),
	('R_OCTDECE1CRNe', 'SBO:0000658'),
	('R_SK_octdececoa_c', 'SBO:0000632'),
	('R_OMHDEACIDTD', 'SBO:0000658'),
	('R_SCP21cx', 'SBO:0000657'),
	('R_LINOFATPtc', 'SBO:0000657'),
	('R_METATB0tc', 'SBO:0000659'),
	('R_NACHORCTL3le', 'SBO:0000659'),
	('R_OLEICFATPtc', 'SBO:0000657'),
	('R_FAOXC163C164Gm', 'SBO:0000200'),
	('R_ORNALArBATtc', 'SBO:0000660'),
	('R_ORNLEUrBATtc', 'SBO:0000660'),
	('R_PHEATB0tc', 'SBO:0000659'),
	('R_EX_gltdechol_e', 'SBO:0000627'),
	('R_EX_glysar_e', 'SBO:0000627'),
	('R_EX_gumtchol_e', 'SBO:0000627'),
	('R_EX_leugly_e', 'SBO:0000627'),
	('R_EX_leuleu_e', 'SBO:0000627'),
	('R_PHEyLATthc', 'SBO:0000660'),
	('R_PROIMINOtc', 'SBO:0000659'),
	('R_EX_pect_e', 'SBO:0000627'),
	('R_EX_pectingchol_e', 'SBO:0000627'),
	('R_EX_pectintchol_e', 'SBO:0000627'),
	('R_EX_psyl_e', 'SBO:0000627'),
	('R_EX_psylchol_e', 'SBO:0000627'),
	('R_EX_psyltchol_e', 'SBO:0000627'),
	('R_EX_slfcys_e', 'SBO:0000627'),
	('R_THMATPe', 'SBO:0000657'),
	('R_TRPATB0tc', 'SBO:0000659'),
	('R_TYRATB0tc', 'SBO:0000659'),
	('R_VALATB0tc', 'SBO:0000659'),
	('R_VITEtl', 'SBO:0000657'),
	('R_3AIB_Dtm', 'SBO:0000658'),
	('R_EX_pan4p_e', 'SBO:0000627'),
	('R_EX_ptth_e', 'SBO:0000627'),
	('R_EX_q10h2_e', 'SBO:0000627'),
	('R_FAOXC164C143m', 'SBO:0000200'),
	('R_4ABUTtcn', 'SBO:0000658'),
	('R_4HPROLTASCT1', 'SBO:0000660'),
	('R_FAOXC164C143x', 'SBO:0000200'),
	('R_AHCYStm', 'SBO:0000658'),
	('R_FAOXC164C163x', 'SBO:0000200'),
	('R_FE2DMT1', 'SBO:0000659'),
	('R_ALA_DTDe', 'SBO:0000658'),
	('R_ASPDTDe', 'SBO:0000658'),
	('R_ASPPROASCT1', 'SBO:0000660'),
	('R_FRDPtcr', 'SBO:0000658'),
	('R_G6PDH2c', 'SBO:0000200'),
	('R_FAOXC164C165m', 'SBO:0000200'),
	('R_GLU5SAtmc', 'SBO:0000658'),
	('R_G3PDm', 'SBO:0000200'),
	('R_GNDc', 'SBO:0000399'),
	('R_CHSTEROLtrc', 'SBO:0000658'),
	('R_CRNtp', 'SBO:0000658'),
	('R_Coqe', 'SBO:0000658'),
	('R_DCTPtm_cho', 'SBO:0000658'),
	('R_DGTPtm_cho', 'SBO:0000658'),
	('R_DM_taur_c', 'SBO:0000628'),
	('R_DM_pmtcoa_r', 'SBO:0000628'),
	('R_DSREDUCr', 'SBO:0000200'),
	('R_INSK', 'SBO:0000216'),
	('R_Kt3r', 'SBO:0000660'),
	('R_LACLt', 'SBO:0000658'),
	('R_DTMPKm', 'SBO:0000216'),
	('R_DTTPtm_cho', 'SBO:0000658'),
	('R_EX_4hpro_LT_e', 'SBO:0000627'),
	('R_EX_bglc_e', 'SBO:0000627'),
	('R_MAL_Ltx', 'SBO:0000658'),
	('R_EX_carn_e', 'SBO:0000627'),
	('R_FAOXC165C164m', 'SBO:0000200'),
	('R_EX_glgchlo_e', 'SBO:0000627'),
	('R_MDHp', 'SBO:0000200'),
	('R_SK_5HPET_c', 'SBO:0000632'),
	('R_EX_crtn_e', 'SBO:0000627'),
	('R_SPRMti', 'SBO:0000658'),
	('R_TAURt', 'SBO:0000658'),
	('R_q10h2tc', 'SBO:0000658'),
	('R_34HPPte', 'SBO:0000658'),
	('R_3MOBte', 'SBO:0000658'),
	('R_EX_cyst__L_e', 'SBO:0000627'),
	('R_EX_dcmp_e', 'SBO:0000627'),
	('R_3MOPt', 'SBO:0000658'),
	('R_4HPRO_LTte', 'SBO:0000658'),
	('R_5MTAte', 'SBO:0000658'),
	('R_5OXPROt', 'SBO:0000659'),
	('R_AICARte', 'SBO:0000658'),
	('R_ANTHte', 'SBO:0000658'),
	('R_NADtm', 'SBO:0000658'),
	('R_NADtx', 'SBO:0000658'),
	('R_OCDCAFATPc', 'SBO:0000657'),
	('R_CBASPte', 'SBO:0000658'),
	('R_DM_4hpro_LT_m', 'SBO:0000628'),
	('R_DM_Lcystin_c', 'SBO:0000628'),
	('R_DM_ncam_c', 'SBO:0000628'),
	('R_EX_34hpp_e', 'SBO:0000627'),
	('R_EX_3mob_e', 'SBO:0000627'),
	('R_EX_3mop_e', 'SBO:0000627'),
	('R_EX_ahcys_e', 'SBO:0000627'),
	('R_PNTEHe', 'SBO:0000376'),
	('R_PPItm', 'SBO:0000658'),
	('R_PRO_Dtde', 'SBO:0000658'),
	('R_PTPATe', 'SBO:0000402'),
	('R_Q10H2e', 'SBO:0000658'),
	('R_RTOTAL2FATPc', 'SBO:0000657'),
	('R_RTOTALFATPc', 'SBO:0000657'),
	('R_EX_aicar_e', 'SBO:0000627'),
	('R_EX_anth_e', 'SBO:0000627'),
	('R_MALt', 'SBO:0000658'),
	('R_SFCYSe', 'SBO:0000658'),
	('R_IDOURte', 'SBO:0000658'),
	('R_EX_icit_e', 'SBO:0000627'),
	('R_EX_idour_e', 'SBO:0000627'),
	('R_5HOXINDOAtr', 'SBO:0000660'),
	('R_TCHOLABCtc', 'SBO:0000657'),
	('R_TYRB0AT3tc', 'SBO:0000659'),
	('R_VALB0AT3tc', 'SBO:0000659'),
	('R_PEPtr', 'SBO:0000657'),
	('R_GUDACtr', 'SBO:0000659'),
	('R_GUDACtr2', 'SBO:0000658'),
	('R_LKYNRtr', 'SBO:0000658'),
	('R_CALAtr', 'SBO:0000658'),
	('R_KYNATEtr2', 'SBO:0000658'),
	('R_3ANTHRNtr', 'SBO:0000658'),
	('R_HKYNRtr', 'SBO:0000660'),
	('R_EX_Lkynr_e', 'SBO:0000627'),
	('R_DMGLYtr', 'SBO:0000658'),
	('R_ETHAMPtr', 'SBO:0000658'),
	('R_EX_quln_e', 'SBO:0000627'),
	('R_EX_xmp_e', 'SBO:0000627'),
	('R_FUMtr', 'SBO:0000658'),
	('R_EX_3pg_e', 'SBO:0000627'),
	('R_G3PCt', 'SBO:0000658'),
	('R_GLCURtr', 'SBO:0000658'),
	('R_Kt1', 'SBO:0000658'),
	('R_EX_3hanthrn_e', 'SBO:0000627'),
	('R_ALAPAT4te', 'SBO:0000658'),
	('R_GLYCLm', 'SBO:0000200'),
	('R_ARGSUCte', 'SBO:0000658'),
	('R_3PGtr', 'SBO:0000658'),
	('R_GLYC3tr', 'SBO:0000658'),
	('R_EX_2pg_e', 'SBO:0000627'),
	('R_ACRNte', 'SBO:0000659'),
	('R_PCRNte', 'SBO:0000659'),
	('R_ARACHDFATPtc', 'SBO:0000657'),
	('R_STCRNte', 'SBO:0000659'),
	('R_EX_acrn_e', 'SBO:0000627'),
	('R_BUTSMCT1', 'SBO:0000659'),
	('R_EX_pcrn_e', 'SBO:0000627'),
	('R_EX_lneldccrn_e', 'SBO:0000627'),
	('R_EX_odecrn_e', 'SBO:0000627'),
	('R_EX_pmtcrn_e', 'SBO:0000627'),
	('R_Clt', 'SBO:0000658'),
	('R_DM_ascb__L_c', 'SBO:0000628'),
	('R_PCREATte', 'SBO:0000658'),
	('R_BGLYte', 'SBO:0000658'),
	('R_BIOMASS_maintenance', 'SBO:0000629'),
	('R_BIOMASS_maintenance_noTrTr', 'SBO:0000629'),
	('R_15KPROSTGF2c', 'SBO:0000200'),
	('R_ADPOHc', 'SBO:0000200'),
	('R_AND19ONEc', 'SBO:0000200'),
	('R_DESAT14_9', 'SBO:0000200'),
	('R_21HPRGNLONE', 'SBO:0000200'),
	('R_CRNATBtc', 'SBO:0000659'),
	('R_DHEASABCCte', 'SBO:0000657'),
	('R_DOPAENT4tc', 'SBO:0000659'),
	('R_ESTRAABCtc', 'SBO:0000657'),
	('R_BILIVERDt', 'SBO:0000659'),
	('R_ESTRSABCtc', 'SBO:0000657'),
	('R_C02356t', 'SBO:0000658'),
	('R_C02712te', 'SBO:0000659'),
	('R_C02712tm', 'SBO:0000658'),
	('R_FOLABCCte', 'SBO:0000657'),
	('R_C03990tr', 'SBO:0000658'),
	('R_FOLOAT2tc', 'SBO:0000660'),
	('R_C03990tx', 'SBO:0000658'),
	('R_C04483t2', 'SBO:0000660'),
	('R_C04717ATP', 'SBO:0000657'),
	('R_EX_3mtp_e', 'SBO:0000627'),
	('R_ELAIDCRNte', 'SBO:0000659'),
	('R_LNLCCRNNAt', 'SBO:0000659'),
	('R_PHLACHt', 'SBO:0000659'),
	('R_C04805td', 'SBO:0000658'),
	('R_C05463t1', 'SBO:0000657'),
	('R_C05463t2', 'SBO:0000660'),
	('R_C05953t', 'SBO:0000660'),
	('R_C06314t', 'SBO:0000659'),
	('R_C06439t', 'SBO:0000660'),
	('R_12HPETATP', 'SBO:0000657'),
	('R_15HPETATP', 'SBO:0000657'),
	('R_C11695td', 'SBO:0000658'),
	('R_21HPRGNLONEt1', 'SBO:0000657'),
	('R_C14768td', 'SBO:0000658'),
	('R_2OXOADPt', 'SBO:0000660'),
	('R_GABABGTtc', 'SBO:0000659'),
	('R_3HPPNOHGLUCte', 'SBO:0000658'),
	('R_GLUB0AT3tc', 'SBO:0000659'),
	('R_3HPPt', 'SBO:0000658'),
	('R_3MHISt1', 'SBO:0000659'),
	('R_3MHISt2', 'SBO:0000660'),
	('R_3MOXTYRt', 'SBO:0000658'),
	('R_3UIBtd', 'SBO:0000658'),
	('R_56DTHMt', 'SBO:0000659'),
	('R_EX_C14769_e', 'SBO:0000627'),
	('R_C14770ATP', 'SBO:0000657'),
	('R_C14826ATP', 'SBO:0000657'),
	('R_CE0328t', 'SBO:0000657'),
	('R_56DURAtd', 'SBO:0000658'),
	('R_7DHCHSTEROLtd', 'SBO:0000658'),
	('R_CE1243ATP', 'SBO:0000657'),
	('R_GLYB0AT3tc', 'SBO:0000659'),
	('R_CE1556td', 'SBO:0000658'),
	('R_CE2028t', 'SBO:0000658'),
	('R_ACGLUtd', 'SBO:0000658'),
	('R_ACGLYte', 'SBO:0000658'),
	('R_ACORNt', 'SBO:0000658'),
	('R_CE4843td', 'SBO:0000658'),
	('R_ACTHRtc', 'SBO:0000658'),
	('R_CE6247t', 'SBO:0000657'),
	('R_H2OGLYAQPt', 'SBO:0000659'),
	('R_CE7083t', 'SBO:0000657'),
	('R_ACTHRte', 'SBO:0000658'),
	('R_AND19ONEt', 'SBO:0000658'),
	('R_CE7172ATP', 'SBO:0000657'),
	('R_ILEB0AT3tc', 'SBO:0000659'),
	('R_LEUB0AT3tc', 'SBO:0000659'),
	('R_DODECANACt', 'SBO:0000657'),
	('R_DODECANACtd', 'SBO:0000658'),
	('R_EX_56dthm_e', 'SBO:0000627'),
	('R_EX_56dura_e', 'SBO:0000627'),
	('R_EX_5HPET_e', 'SBO:0000627'),
	('R_EX_acthr__L_e', 'SBO:0000627'),
	('R_EX_adpoh_e', 'SBO:0000627'),
	('R_EX_amet_e', 'SBO:0000627'),
	('R_ELAIDCRNtd', 'SBO:0000658'),
	('R_EX_15HPET_e', 'SBO:0000627'),
	('R_EX_15kprostgf2_e', 'SBO:0000627'),
	('R_EX_21hprgnlone_e', 'SBO:0000627'),
	('R_EX_3hmp_e', 'SBO:0000627'),
	('R_EX_3mhis_e', 'SBO:0000627'),
	('R_EX_and19one_e', 'SBO:0000627'),
	('R_EX_aracheth_e', 'SBO:0000627'),
	('R_EX_C02356_e', 'SBO:0000627'),
	('R_EX_C02712_e', 'SBO:0000627'),
	('R_EX_C04717_e', 'SBO:0000627'),
	('R_LGNCFATPtc', 'SBO:0000657'),
	('R_EX_C05957_e', 'SBO:0000627'),
	('R_METB0AT3tc', 'SBO:0000659'),
	('R_EX_C06314_e', 'SBO:0000627'),
	('R_EX_pcholet_hs_e', 'SBO:0000627'),
	('R_EX_C14771_e', 'SBO:0000627'),
	('R_NACSMCTte', 'SBO:0000659'),
	('R_EX_CE1273_e', 'SBO:0000627'),
	('R_EX_CE2176_e', 'SBO:0000627'),
	('R_EX_pcholn201_hs_e', 'SBO:0000627'),
	('R_EX_pcholn205_hs_e', 'SBO:0000627'),
	('R_EX_pcholn226_hs_e', 'SBO:0000627'),
	('R_EX_pcholn24_hs_e', 'SBO:0000627'),
	('R_EX_eidi1114ac_e', 'SBO:0000627'),
	('R_PGLYCABCte', 'SBO:0000657'),
	('R_EX_CE6031_e', 'SBO:0000627'),
	('R_EX_CE7082_e', 'SBO:0000627'),
	('R_EX_pcholn261_hs_e', 'SBO:0000627'),
	('R_EX_pcholpalm_hs_e', 'SBO:0000627'),
	('R_EX_pe14_hs_e', 'SBO:0000627'),
	('R_EX_pe15_hs_e', 'SBO:0000627'),
	('R_EX_pe161_hs_e', 'SBO:0000627'),
	('R_EX_pe203_hs_e', 'SBO:0000627'),
	('R_EX_pe226_hs_e', 'SBO:0000627'),
	('R_EX_CE7083_e', 'SBO:0000627'),
	('R_EX_docohxeth_e', 'SBO:0000627'),
	('R_EX_elaidcrn_e', 'SBO:0000627'),
	('R_EX_HC00900_e', 'SBO:0000627'),
	('R_EX_hexdiac_e', 'SBO:0000627'),
	('R_EX_hgentis_e', 'SBO:0000627'),
	('R_EX_leuktrB4wcooh_e', 'SBO:0000627'),
	('R_EX_pe2linl_hs_e', 'SBO:0000627'),
	('R_EX_pear_hs_e', 'SBO:0000627'),
	('R_EX_pendecaeth_e', 'SBO:0000627'),
	('R_EX_lineth_e', 'SBO:0000627'),
	('R_PHEMEABCte', 'SBO:0000657'),
	('R_EX_lnlccrn_e', 'SBO:0000627'),
	('R_EX_Lpipecol_e', 'SBO:0000627'),
	('R_EX_pepalm_hs_e', 'SBO:0000627'),
	('R_EX_peste_hs_e', 'SBO:0000627'),
	('R_EX_pmeth_e', 'SBO:0000627'),
	('R_EX_lthstrl_e', 'SBO:0000627'),
	('R_EX_maglinl_hs_e', 'SBO:0000627'),
	('R_EX_sebacid_e', 'SBO:0000627'),
	('R_EX_sphmyln180241_hs_e', 'SBO:0000627'),
	('R_EX_magste_hs_e', 'SBO:0000627'),
	('R_EX_mev__R_e', 'SBO:0000627'),
	('R_EX_sphmyln18114_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18115_hs_e', 'SBO:0000627'),
	('R_EX_pailpalm_hs_e', 'SBO:0000627'),
	('R_EX_pailste_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18116_hs_e', 'SBO:0000627'),
	('R_EX_pchol2linl_hs_e', 'SBO:0000627'),
	('R_EX_pchol2ole_hs_e', 'SBO:0000627'),
	('R_EX_pchol2palm_hs_e', 'SBO:0000627'),
	('R_EX_pcholar_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln181181_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18120_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18121_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18122_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln181221_hs_e', 'SBO:0000627'),
	('R_EX_subeac_e', 'SBO:0000627'),
	('R_GALTt', 'SBO:0000658'),
	('R_EX_tetdeca511ac_e', 'SBO:0000627'),
	('R_PPASMCT1', 'SBO:0000659'),
	('R_EX_thrnt_e', 'SBO:0000627'),
	('R_GLYC2Pte', 'SBO:0000659'),
	('R_GLYCLTt', 'SBO:0000658'),
	('R_HC00319t2', 'SBO:0000660'),
	('R_HC00900t1', 'SBO:0000660'),
	('R_EX_ttdcrn_e', 'SBO:0000627'),
	('R_EX_txb2_e', 'SBO:0000627'),
	('R_EX_wharachd_e', 'SBO:0000627'),
	('R_HC00900t2', 'SBO:0000660'),
	('R_HC00900t3', 'SBO:0000660'),
	('R_EX_xolest181_hs_e', 'SBO:0000627'),
	('R_PROPAT4te', 'SBO:0000658'),
	('R_EX_xolest182_hs_e', 'SBO:0000627'),
	('R_HC00900t4', 'SBO:0000660'),
	('R_EX_xolest204_hs_e', 'SBO:0000627'),
	('R_FORGLUt', 'SBO:0000658'),
	('R_HEXDIACATP', 'SBO:0000657'),
	('R_PYRSMCT1', 'SBO:0000659'),
	('R_HGENTISt', 'SBO:0000658'),
	('R_HMCRNt', 'SBO:0000658'),
	('R_RETABCtc', 'SBO:0000657'),
	('R_LCYSTt', 'SBO:0000659'),
	('R_LEUKTRB4WCOOHt', 'SBO:0000657'),
	('R_LEUKTRB4WOHt', 'SBO:0000657'),
	('R_EX_achom__L_e', 'SBO:0000627'),
	('R_PHACGLYt', 'SBO:0000658'),
	('R_EX_phacgly_e', 'SBO:0000627'),
	('R_ESTRIOLATP', 'SBO:0000657'),
	('R_r1528', 'SBO:0000657'),
	('R_EX_3moxtyr_e', 'SBO:0000627'),
	('R_EX_glyc2p_e', 'SBO:0000627'),
	('R_LEUKTRB4WOHtr', 'SBO:0000660'),
	('R_LNLCCRNtd', 'SBO:0000658'),
	('R_LPIPECOLt', 'SBO:0000659'),
	('R_SERB0AT3tc', 'SBO:0000659'),
	('R_EX_oaa_e', 'SBO:0000627'),
	('R_EX_phlac_e', 'SBO:0000627'),
	('R_EX_ttdcea_e', 'SBO:0000627'),
	('R_LTHSTRLABCt', 'SBO:0000657'),
	('R_MI1Pt', 'SBO:0000659'),
	('R_NWHARGtd', 'SBO:0000658'),
	('R_TTDCEAt', 'SBO:0000658'),
	('R_SRTNENT4tc', 'SBO:0000659'),
	('R_7KLITCHOLc', 'SBO:0000200'),
	('R_EX_alaargcys_e', 'SBO:0000627'),
	('R_HC02195te', 'SBO:0000657'),
	('R_HC02196te', 'SBO:0000657'),
	('R_PSERtr', 'SBO:0000658'),
	('R_TETDECA511ACt', 'SBO:0000657'),
	('R_TXB2t', 'SBO:0000657'),
	('R_ACILEtm', 'SBO:0000658'),
	('R_ACLEUtm', 'SBO:0000658'),
	('R_EX_acleu__L_e', 'SBO:0000627'),
	('R_HC02220te', 'SBO:0000657'),
	('R_G3PD1irm', 'SBO:0000200'),
	('R_DM_k_c', 'SBO:0000628'),
	('R_PHEACGLYsec', 'SBO:0000658'),
	('R_ACHOMtm', 'SBO:0000658'),
	('R_ACHOMte', 'SBO:0000658'),
	('R_PCRESOLup', 'SBO:0000658'),
	('R_EX_alaarggly_e', 'SBO:0000627'),
	('R_EX_pheacgly_e', 'SBO:0000627'),
	('R_EX_alaglylys_e', 'SBO:0000627'),
	('R_EX_pcresol_e', 'SBO:0000627'),
	('R_EX_pcs_e', 'SBO:0000627'),
	('R_NORMETEt', 'SBO:0000658'),
	('R_EX_hisargser_e', 'SBO:0000627'),
	('R_EX_hiscyscys_e', 'SBO:0000627'),
	('R_EX_alahisala_e', 'SBO:0000627'),
	('R_EX_hisglu_e', 'SBO:0000627'),
	('R_C05300t', 'SBO:0000658'),
	('R_RETINALt', 'SBO:0000658'),
	('R_MALTTTRt', 'SBO:0000658'),
	('R_1MNCAMt', 'SBO:0000658'),
	('R_EX_hisglugln_e', 'SBO:0000627'),
	('R_EX_hislysala_e', 'SBO:0000627'),
	('R_EX_hislysglu_e', 'SBO:0000627'),
	('R_EX_C05300_e', 'SBO:0000627'),
	('R_EX_argalaala_e', 'SBO:0000627'),
	('R_EX_retinal_e', 'SBO:0000627'),
	('R_EX_dhbpt_e', 'SBO:0000627'),
	('R_EX_hislysthr_e', 'SBO:0000627'),
	('R_EX_hislysval_e', 'SBO:0000627'),
	('R_EX_hismetgln_e', 'SBO:0000627'),
	('R_EX_hisphearg_e', 'SBO:0000627'),
	('R_EX_hisprolys_e', 'SBO:0000627'),
	('R_EX_histrphis_e', 'SBO:0000627'),
	('R_EX_ileargile_e', 'SBO:0000627'),
	('R_EX_argalaphe_e', 'SBO:0000627'),
	('R_EX_ileasp_e', 'SBO:0000627'),
	('R_EX_ileprolys_e', 'SBO:0000627'),
	('R_EX_prolyspro_e', 'SBO:0000627'),
	('R_EX_prophe_e', 'SBO:0000627'),
	('R_EX_argalathr_e', 'SBO:0000627'),
	('R_EX_proproarg_e', 'SBO:0000627'),
	('R_EX_propropro_e', 'SBO:0000627'),
	('R_EX_leuasnasp_e', 'SBO:0000627'),
	('R_EX_leuasplys_e', 'SBO:0000627'),
	('R_EX_protrplys_e', 'SBO:0000627'),
	('R_EX_provalgln_e', 'SBO:0000627'),
	('R_EX_leuleutrp_e', 'SBO:0000627'),
	('R_EX_argarg_e', 'SBO:0000627'),
	('R_EX_leuproarg_e', 'SBO:0000627'),
	('R_EX_leusertrp_e', 'SBO:0000627'),
	('R_EX_serlyshis_e', 'SBO:0000627'),
	('R_EX_thrglntyr_e', 'SBO:0000627'),
	('R_EX_thrphearg_e', 'SBO:0000627'),
	('R_EX_thrserarg_e', 'SBO:0000627'),
	('R_EX_leutrp_e', 'SBO:0000627'),
	('R_EX_thrthrarg_e', 'SBO:0000627'),
	('R_EX_leuval_e', 'SBO:0000627'),
	('R_EX_thrtyrmet_e', 'SBO:0000627'),
	('R_EX_lysargleu_e', 'SBO:0000627'),
	('R_EX_argarglys_e', 'SBO:0000627'),
	('R_EX_lyscyshis_e', 'SBO:0000627'),
	('R_EX_lysglnphe_e', 'SBO:0000627'),
	('R_EX_lystrparg_e', 'SBO:0000627'),
	('R_EX_lysvalphe_e', 'SBO:0000627'),
	('R_EX_trpargala_e', 'SBO:0000627'),
	('R_EX_trpglngln_e', 'SBO:0000627'),
	('R_EX_trpglugly_e', 'SBO:0000627'),
	('R_EX_trpglupro_e', 'SBO:0000627'),
	('R_EX_trpglyleu_e', 'SBO:0000627'),
	('R_EX_trpglyphe_e', 'SBO:0000627'),
	('R_EX_trpilelys_e', 'SBO:0000627'),
	('R_EX_trpiletrp_e', 'SBO:0000627'),
	('R_EX_trpleuval_e', 'SBO:0000627'),
	('R_EX_metglntyr_e', 'SBO:0000627'),
	('R_EX_metphearg_e', 'SBO:0000627'),
	('R_EX_pheasnmet_e', 'SBO:0000627'),
	('R_EX_pheasp_e', 'SBO:0000627'),
	('R_EX_pheleuasp_e', 'SBO:0000627'),
	('R_EX_pheleuhis_e', 'SBO:0000627'),
	('R_EX_trplys_e', 'SBO:0000627'),
	('R_EX_trpmetval_e', 'SBO:0000627'),
	('R_EX_trptyrgln_e', 'SBO:0000627'),
	('R_EX_phelyspro_e', 'SBO:0000627'),
	('R_EX_phephethr_e', 'SBO:0000627'),
	('R_EX_pheproarg_e', 'SBO:0000627'),
	('R_EX_trptyrtyr_e', 'SBO:0000627'),
	('R_EX_phesertrp_e', 'SBO:0000627'),
	('R_EX_tyrargser_e', 'SBO:0000627'),
	('R_EX_argcysgly_e', 'SBO:0000627'),
	('R_EX_tyrcysthr_e', 'SBO:0000627'),
	('R_EX_tyrleuarg_e', 'SBO:0000627'),
	('R_EX_tyrphetyr_e', 'SBO:0000627'),
	('R_EX_tyrthr_e', 'SBO:0000627'),
	('R_EX_tyrtrpphe_e', 'SBO:0000627'),
	('R_EX_tyrtyr_e', 'SBO:0000627'),
	('R_EX_tyrvalmet_e', 'SBO:0000627'),
	('R_EX_valarggly_e', 'SBO:0000627'),
	('R_EX_valhisasn_e', 'SBO:0000627'),
	('R_EX_valphearg_e', 'SBO:0000627'),
	('R_EX_valprotrp_e', 'SBO:0000627'),
	('R_EX_valserarg_e', 'SBO:0000627'),
	('R_EX_phetyrgln_e', 'SBO:0000627'),
	('R_EX_phetyrlys_e', 'SBO:0000627'),
	('R_EX_proargcys_e', 'SBO:0000627'),
	('R_EX_proasncys_e', 'SBO:0000627'),
	('R_EX_proglnpro_e', 'SBO:0000627'),
	('R_EX_prohis_e', 'SBO:0000627'),
	('R_EX_prohistyr_e', 'SBO:0000627'),
	('R_ALAGLYLYSt', 'SBO:0000659'),
	('R_ALALYSTHRt', 'SBO:0000659'),
	('R_ARGALAALAt', 'SBO:0000659'),
	('R_ARGALAPHEt', 'SBO:0000659'),
	('R_ARGALATHRt', 'SBO:0000659'),
	('R_ARGARGt', 'SBO:0000659'),
	('R_ARGARGLYSt', 'SBO:0000659'),
	('R_ARGARGMETt', 'SBO:0000659'),
	('R_ARGCYSSERt', 'SBO:0000659'),
	('R_ARGGLUPROt', 'SBO:0000659'),
	('R_ARGHISTHRt', 'SBO:0000659'),
	('R_ARGPROMETt', 'SBO:0000659'),
	('R_ARGPROTHRt', 'SBO:0000659'),
	('R_GLNPROGLUt', 'SBO:0000659'),
	('R_GLNTRPGLUt', 'SBO:0000659'),
	('R_GLNTYRLEUt', 'SBO:0000659'),
	('R_GLUARGLEUt', 'SBO:0000659'),
	('R_GLUASNLEUt', 'SBO:0000659'),
	('R_GLUGLUt', 'SBO:0000659'),
	('R_GLUILELYSt', 'SBO:0000659'),
	('R_GLUMETt', 'SBO:0000659'),
	('R_GLUMETHISt', 'SBO:0000659'),
	('R_ASNASNARGt', 'SBO:0000659'),
	('R_ASPALAARGt', 'SBO:0000659'),
	('R_ASPASNGLUt', 'SBO:0000659'),
	('R_ASPGLUPROt', 'SBO:0000659'),
	('R_ASPGLUTRPt', 'SBO:0000659'),
	('R_ASPHISCYSt', 'SBO:0000659'),
	('R_ASPHISPROt', 'SBO:0000659'),
	('R_ASPLYSGLUt', 'SBO:0000659'),
	('R_ASPLYSHISt', 'SBO:0000659'),
	('R_GLUTHRLYSt', 'SBO:0000659'),
	('R_GLYVALHISt', 'SBO:0000659'),
	('R_HISASPt', 'SBO:0000659'),
	('R_HISGLNALAt', 'SBO:0000659'),
	('R_HISGLYLYSt', 'SBO:0000659'),
	('R_HISLYSALAt', 'SBO:0000659'),
	('R_HISLYSILEt', 'SBO:0000659'),
	('R_ASPMETASPt', 'SBO:0000659'),
	('R_ASPPROLYSt', 'SBO:0000659'),
	('R_ASPVALASNt', 'SBO:0000659'),
	('R_CYSASNMETt', 'SBO:0000659'),
	('R_HISLYSVALt', 'SBO:0000659'),
	('R_EX_argglupro_e', 'SBO:0000627'),
	('R_HISMETt', 'SBO:0000659'),
	('R_CYSASPPHEt', 'SBO:0000659'),
	('R_CYSGLUHISt', 'SBO:0000659'),
	('R_CYSGLUTRPt', 'SBO:0000659'),
	('R_CYSLEUTHRt', 'SBO:0000659'),
	('R_EX_argglygly_e', 'SBO:0000627'),
	('R_CYSSERMETt', 'SBO:0000659'),
	('R_EX_argphearg_e', 'SBO:0000627'),
	('R_ILEASNHISt', 'SBO:0000659'),
	('R_ILEGLYARGt', 'SBO:0000659'),
	('R_ILEPROLYSt', 'SBO:0000659'),
	('R_ILESERARGt', 'SBO:0000659'),
	('R_LEUASNASPt', 'SBO:0000659'),
	('R_LEUASPLYSt', 'SBO:0000659'),
	('R_LEUPROt', 'SBO:0000659'),
	('R_GLNHISLYSt', 'SBO:0000659'),
	('R_EX_argpromet_e', 'SBO:0000627'),
	('R_LEUPROARGt', 'SBO:0000659'),
	('R_LEUTRPt', 'SBO:0000659'),
	('R_EX_argprothr_e', 'SBO:0000627'),
	('R_LEUTRPARGt', 'SBO:0000659'),
	('R_LEUVALt', 'SBO:0000659'),
	('R_EX_argtyrval_e', 'SBO:0000627'),
	('R_LYSARGLEUt', 'SBO:0000659'),
	('R_EX_argvalcys_e', 'SBO:0000627'),
	('R_SERTRPHISt', 'SBO:0000659'),
	('R_LYSGLNPHEt', 'SBO:0000659'),
	('R_EX_argvaltrp_e', 'SBO:0000627'),
	('R_LYSGLUGLUt', 'SBO:0000659'),
	('R_LYSLYSLYSt', 'SBO:0000659'),
	('R_LYSTYRILEt', 'SBO:0000659'),
	('R_THRHISHISt', 'SBO:0000659'),
	('R_EX_asnasnarg_e', 'SBO:0000627'),
	('R_THRILEARGt', 'SBO:0000659'),
	('R_THRPHEARGt', 'SBO:0000659'),
	('R_LYSVALPHEt', 'SBO:0000659'),
	('R_METARGLEUt', 'SBO:0000659'),
	('R_METGLNTYRt', 'SBO:0000659'),
	('R_THRSERARGt', 'SBO:0000659'),
	('R_THRTYRMETt', 'SBO:0000659'),
	('R_TRPARGALAt', 'SBO:0000659'),
	('R_METGLYARGt', 'SBO:0000659'),
	('R_TRPASPASPt', 'SBO:0000659'),
	('R_TRPGLNGLNt', 'SBO:0000659'),
	('R_TRPGLUGLYt', 'SBO:0000659'),
	('R_TRPGLULEUt', 'SBO:0000659'),
	('R_TRPGLUTYRt', 'SBO:0000659'),
	('R_METTRPPHEt', 'SBO:0000659'),
	('R_PHEASNMETt', 'SBO:0000659'),
	('R_PHEASPt', 'SBO:0000659'),
	('R_PHELEUt', 'SBO:0000659'),
	('R_PHELEUASPt', 'SBO:0000659'),
	('R_PHELEUHISt', 'SBO:0000659'),
	('R_TRPGLYPHEt', 'SBO:0000659'),
	('R_TRPGLYVALt', 'SBO:0000659'),
	('R_TRPILETRPt', 'SBO:0000659'),
	('R_PHELYSALAt', 'SBO:0000659'),
	('R_PHELYSPROt', 'SBO:0000659'),
	('R_EX_asncyscys_e', 'SBO:0000627'),
	('R_PHEPHEASNt', 'SBO:0000659'),
	('R_PHEPHETHRt', 'SBO:0000659'),
	('R_TRPLEUVALt', 'SBO:0000659'),
	('R_TRPMETARGt', 'SBO:0000659'),
	('R_TRPPHEt', 'SBO:0000659'),
	('R_TRPPROLEUt', 'SBO:0000659'),
	('R_TRPSERTYRt', 'SBO:0000659'),
	('R_PHETHRLYSt', 'SBO:0000659'),
	('R_PHETYRGLNt', 'SBO:0000659'),
	('R_PROARGASPt', 'SBO:0000659'),
	('R_PROASNCYSt', 'SBO:0000659'),
	('R_TRPTHRILEt', 'SBO:0000659'),
	('R_TRPTHRTYRt', 'SBO:0000659'),
	('R_TRPTYRGLNt', 'SBO:0000659'),
	('R_PROGLNPROt', 'SBO:0000659'),
	('R_PROHISt', 'SBO:0000659'),
	('R_PROHISTYRt', 'SBO:0000659'),
	('R_PROLEUARGt', 'SBO:0000659'),
	('R_PROLYSPROt', 'SBO:0000659'),
	('R_TRPVALASPt', 'SBO:0000659'),
	('R_TYRALAt', 'SBO:0000659'),
	('R_TYRASPARGt', 'SBO:0000659'),
	('R_TYRGLUt', 'SBO:0000659'),
	('R_TYRLEUARGt', 'SBO:0000659'),
	('R_TYRPHETYRt', 'SBO:0000659'),
	('R_PROPROPROt', 'SBO:0000659'),
	('R_PROTRPTHRt', 'SBO:0000659'),
	('R_SERARGTRPt', 'SBO:0000659'),
	('R_TYRVALMETt', 'SBO:0000659'),
	('R_SERLYSHISt', 'SBO:0000659'),
	('R_VALARGGLYt', 'SBO:0000659'),
	('R_EX_asnpheasp_e', 'SBO:0000627'),
	('R_VALHISASNt', 'SBO:0000659'),
	('R_EX_asnphecys_e', 'SBO:0000627'),
	('R_VALLYSTYRt', 'SBO:0000659'),
	('R_EX_asntyrthr_e', 'SBO:0000627'),
	('R_VALPROTRPt', 'SBO:0000659'),
	('R_VALTRPPHEt', 'SBO:0000659'),
	('R_EX_aspglu_e', 'SBO:0000627'),
	('R_VALVALt', 'SBO:0000659'),
	('R_EX_aspglupro_e', 'SBO:0000627'),
	('R_EX_asphiscys_e', 'SBO:0000627'),
	('R_EX_aspvalasn_e', 'SBO:0000627'),
	('R_EX_cyssermet_e', 'SBO:0000627'),
	('R_XOLEST226_HSte', 'SBO:0000658'),
	('R_EX_cystyrasn_e', 'SBO:0000627'),
	('R_PCHOLN281_HSte', 'SBO:0000658'),
	('R_ACRNtr', 'SBO:0000658'),
	('R_EX_glnasngln_e', 'SBO:0000627'),
	('R_ODECRNtr', 'SBO:0000658'),
	('R_PMTCRNtr', 'SBO:0000658'),
	('R_XOLEST183tl', 'SBO:0000658'),
	('R_XOLEST205tl', 'SBO:0000658'),
	('R_PHEACGLYtm', 'SBO:0000658'),
	('R_HXAt1', 'SBO:0000658'),
	('R_HXAt2', 'SBO:0000658'),
	('R_HXAt3', 'SBO:0000658'),
	('R_EX_hxa_e', 'SBO:0000627'),
	('R_PACALDtm', 'SBO:0000658'),
	('R_BZtm', 'SBO:0000658'),
	('R_EX_glnhislys_e', 'SBO:0000627'),
	('R_EX_glnproglu_e', 'SBO:0000627'),
	('R_PA_HStm', 'SBO:0000658'),
	('R_EX_gluargleu_e', 'SBO:0000627'),
	('R_MMALtm', 'SBO:0000658'),
	('R_EX_gluasnleu_e', 'SBO:0000627'),
	('R_CE2512te', 'SBO:0000658'),
	('R_r2514m', 'SBO:0000660'),
	('R_EX_gluthrlys_e', 'SBO:0000627'),
	('R_EX_glutrpala_e', 'SBO:0000627'),
	('R_HOMOVALte', 'SBO:0000660'),
	('R_XOLEST182_HSte', 'SBO:0000658'),
	('R_XOLEST205_HSte', 'SBO:0000658'),
	('R_FAS180', 'SBO:0000402'),
	('R_5AOPt2', 'SBO:0000659'),
	('R_ACNAMt2', 'SBO:0000659'),
	('R_CORE5t', 'SBO:0000658'),
	('R_EX_glyhisasn_e', 'SBO:0000627'),
	('R_CORE8t', 'SBO:0000658'),
	('R_EX_glylyscys_e', 'SBO:0000627'),
	('R_CA2t', 'SBO:0000658'),
	('R_MK7t', 'SBO:0000658'),
	('R_MK9t', 'SBO:0000658'),
	('R_SK_adprbp_c', 'SBO:0000632'),
	('R_EX_glylysphe_e', 'SBO:0000627'),
	('R_SK_bandmt_c', 'SBO:0000632'),
	('R_STN_ANTIGENt', 'SBO:0000658'),
	('R_EX_core4_e', 'SBO:0000627'),
	('R_EX_core5_e', 'SBO:0000627'),
	('R_SK_for_c', 'SBO:0000632'),
	('R_EX_glyvalhis_e', 'SBO:0000627'),
	('R_SK_mi1345p_c', 'SBO:0000632'),
	('R_EX_dsT_antigen_e', 'SBO:0000627'),
	('R_EX_f1a_e', 'SBO:0000627'),
	('R_SK_mi134p_c', 'SBO:0000632'),
	('R_SK_mi145p_c', 'SBO:0000632'),
	('R_EX_galam_e', 'SBO:0000627'),
	('R_DM_pchol_hs_c', 'SBO:0000628'),
	('R_EX_gncore1_e', 'SBO:0000627'),
	('R_EX_mqn7_e', 'SBO:0000627'),
	('R_SK_crvnc_c', 'SBO:0000632'),
	('R_r2444', 'SBO:0000658'),
	('R_LPAMt', 'SBO:0000659'),
	('R_EX_acgal_e', 'SBO:0000627'),
	('R_EX_acnam_e', 'SBO:0000627'),
	('R_EX_pcreat_e', 'SBO:0000627'),
	('R_EX_HC00342_e', 'SBO:0000627'),
	('R_EX_CE2934_e', 'SBO:0000627'),
	('R_DM_mqn10_c', 'SBO:0000628'),
	('R_DM_mqn7_c', 'SBO:0000628'),
	('R_DM_mqn8_c', 'SBO:0000628'),
	('R_HCYSte', 'SBO:0000658'),
	('R_SPRMt2i', 'SBO:0000660'),
	('R_THMMPtrbc', 'SBO:0000658'),
	('R_THMtrbc', 'SBO:0000658'),
	('R_ACNAMtr', 'SBO:0000658'),
	('R_DM_mqn9_c', 'SBO:0000628'),
	('R_GNCORE1t', 'SBO:0000658'),
	('R_GNCORE2t', 'SBO:0000658'),
	('R_3HMPtm', 'SBO:0000658'),
	('R_SK_doco13ecoa_c', 'SBO:0000632'),
	('R_ACGLUtm', 'SBO:0000658'),
	('R_LPAMtm', 'SBO:0000659'),
	('R_r2535m', 'SBO:0000658'),
	('R_CE2934t', 'SBO:0000658'),
	('R_ESTR2r', 'SBO:0000200'),
	('R_SK_fad_c', 'SBO:0000632'),
	('R_PGLYCtm', 'SBO:0000658'),
	('R_SK_25hvitd2_c', 'SBO:0000632'),
	('R_SK_9_cis_retfa_c', 'SBO:0000632'),
	('R_SK_glygn2_c', 'SBO:0000632'),
	('R_SK_HC02193_c', 'SBO:0000632'),
	('R_SK_lnlc_c', 'SBO:0000632'),
	('R_SK_HC02195_c', 'SBO:0000632'),
	('R_SK_HC02197_c', 'SBO:0000632'),
	('R_SK_HC02198_c', 'SBO:0000632'),
	('R_SK_Tyr_ggn_c', 'SBO:0000632'),
	('R_SK_btn_c', 'SBO:0000632'),
	('R_SK_c226coa_c', 'SBO:0000632'),
	('R_SK_lnlccoa_c', 'SBO:0000632'),
	('R_SK_lnlncgcoa_c', 'SBO:0000632'),
	('R_SK_nad_c', 'SBO:0000632'),
	('R_SK_pmtcoa_c', 'SBO:0000632'),
	('R_CYTDt2', 'SBO:0000659'),
	('R_SK_pydx_c', 'SBO:0000632'),
	('R_SK_pydxn_c', 'SBO:0000632'),
	('R_SK_retinol_c', 'SBO:0000632'),
	('R_SK_tag_hs_c', 'SBO:0000632'),
	('R_SK_tchola_c', 'SBO:0000632'),
	('R_SK_tdechola_c', 'SBO:0000632'),
	('R_SK_thf_c', 'SBO:0000632'),
	('R_GLYLEUHYDROc', 'SBO:0000376'),
	('R_GLYLEUPEPT1tc', 'SBO:0000659'),
	('R_GLYPROPRO1c', 'SBO:0000376'),
	('R_EX_glyleu_e', 'SBO:0000627'),
	('R_SK_tmndnc_c', 'SBO:0000632'),
	('R_SK_tmndnccoa_c', 'SBO:0000632'),
	('R_SK_vitd3_c', 'SBO:0000632'),
	('R_DXTRNt', 'SBO:0000658'),
	('R_EX_dxtrn_e', 'SBO:0000627'),
	('R_DHCHOLESTANATEATP', 'SBO:0000657'),
	('R_DHCHOLESTANATEt', 'SBO:0000659'),
	('R_EX_dhcholestanate_e', 'SBO:0000627'),
	('R_r0398', 'SBO:0000200'),
	('R_r0422', 'SBO:0000200'),
	('R_SK_dhcholestanate_c', 'SBO:0000632'),
	('R_THCHOLSTOICATP', 'SBO:0000657'),
	('R_EX_thcholstoic_e', 'SBO:0000627'),
	('R_THMDt2', 'SBO:0000659'),
	('R_EX_ind3ac_e', 'SBO:0000627'),
	('R_SK_thcholstoic_c', 'SBO:0000632'),
	('R_XOL7AONEATP', 'SBO:0000657'),
	('R_EX_mqn8_e', 'SBO:0000627'),
	('R_EX_xol7aone_e', 'SBO:0000627'),
	('R_SK_xol7aone_c', 'SBO:0000632'),
	('R_SK_xoldiolone_c', 'SBO:0000632'),
	('R_7KILTCHOLATP', 'SBO:0000657'),
	('R_SK_dchac_c', 'SBO:0000632'),
	('R_SK_CE1273_c', 'SBO:0000632'),
	('R_OAADC', 'SBO:0000399'),
	('R_ADNt2', 'SBO:0000659'),
	('R_GLYALDDr', 'SBO:0000200'),
	('R_MTHFR2', 'SBO:0000200'),
	('R_MVLACte', 'SBO:0000658'),
	('R_TIGGLYte', 'SBO:0000658'),
	('R_3OHGLUTACOAT3t', 'SBO:0000660'),
	('R_GLUTACOAm', 'SBO:0000200'),
	('R_EX_tym_e', 'SBO:0000627'),
	('R_3HIVActe', 'SBO:0000658'),
	('R_3HADPACtxc', 'SBO:0000658'),
	('R_3HADPACte', 'SBO:0000658'),
	('R_EX_3hadpac_e', 'SBO:0000627'),
	('R_PAFABCt', 'SBO:0000657'),
	('R_PAILR_HSSECt', 'SBO:0000658'),
	('R_PCHLN225_HSABCt', 'SBO:0000657'),
	('R_PCHOL2LINL_HSABCt', 'SBO:0000657'),
	('R_PCHOL2OLE_HSABCt', 'SBO:0000657'),
	('R_PCHOL2STE_HSABCt', 'SBO:0000657'),
	('R_PCHOLDOC_HSABCt', 'SBO:0000657'),
	('R_PCHOLEIC_HSABCt', 'SBO:0000657'),
	('R_PCHOLET_HSABCt', 'SBO:0000657'),
	('R_5OHHEXAc', 'SBO:0000200'),
	('R_5OHHEXAte', 'SBO:0000658'),
	('R_PCHOLLINL_HSABCt', 'SBO:0000657'),
	('R_EX_ethmalac_e', 'SBO:0000627'),
	('R_PCHOLN183_HSABCt', 'SBO:0000657'),
	('R_HEXGLYte', 'SBO:0000658'),
	('R_EX_lanost_e', 'SBO:0000627'),
	('R_EX_hexgly_e', 'SBO:0000627'),
	('R_PCHOLN203_HSABCt', 'SBO:0000657'),
	('R_PCHOLN224_HSABCt', 'SBO:0000657'),
	('R_PCHOLN225_HSABCt', 'SBO:0000657'),
	('R_PCHOLN2254_HSABCt', 'SBO:0000657'),
	('R_PCHOLOLE_HSABCt', 'SBO:0000657'),
	('R_PCHOLPALME_HSABCt', 'SBO:0000657'),
	('R_PE14_HSABCt', 'SBO:0000657'),
	('R_EX_subgly_e', 'SBO:0000627'),
	('R_4OHBUTtmc', 'SBO:0000658'),
	('R_EX_4ohbut_e', 'SBO:0000627'),
	('R_12HPETUPKt', 'SBO:0000658'),
	('R_15HPETUPKt', 'SBO:0000658'),
	('R_AK2LGCHOLABCt', 'SBO:0000657'),
	('R_APRGSTRNABCt', 'SBO:0000657'),
	('R_C14770UPKt', 'SBO:0000658'),
	('R_PE161_HSABCt', 'SBO:0000657'),
	('R_PE17_HSABCt', 'SBO:0000657'),
	('R_PE203_HSABCt', 'SBO:0000657'),
	('R_PE2LINL_HSABCt', 'SBO:0000657'),
	('R_CE2510ABCt', 'SBO:0000657'),
	('R_PEAR_HSABCt', 'SBO:0000657'),
	('R_PHPYRtm', 'SBO:0000659'),
	('R_EX_3mox4hoxm_e', 'SBO:0000627'),
	('R_CE4970tm', 'SBO:0000658'),
	('R_PELINL_HSABCt', 'SBO:0000657'),
	('R_CE2026tm', 'SBO:0000658'),
	('R_PEPALM_HSASBCt', 'SBO:0000657'),
	('R_SPHMYLN181161_hs_ATPt', 'SBO:0000657'),
	('R_EX_CE2026_e', 'SBO:0000627'),
	('R_SPHMYLN18117_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN18120_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN18121_hs_ATPt', 'SBO:0000657'),
	('R_2HYDOGOAT3t', 'SBO:0000660'),
	('R_2HYDOGte', 'SBO:0000658'),
	('R_PESTE_HSABCt', 'SBO:0000657'),
	('R_SPHMYLN_HsSECt', 'SBO:0000658'),
	('R_SPHMYLN180241_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18117_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18118_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18120_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18123_hs_SECt', 'SBO:0000658'),
	('R_GLUTAROAT3t', 'SBO:0000660'),
	('R_GLUTARte', 'SBO:0000658'),
	('R_EX_thexdd_e', 'SBO:0000627'),
	('R_HEXDTRtm', 'SBO:0000660'),
	('R_SPHMYLN1824_hs_SECt', 'SBO:0000658'),
	('R_HEXDTRte', 'SBO:0000657'),
	('R_CE4968tm', 'SBO:0000658'),
	('R_EX_hexdtr_e', 'SBO:0000627'),
	('R_HPDECECOAm', 'SBO:0000200'),
	('R_CE4968te', 'SBO:0000659'),
	('R_EIC21114TRte', 'SBO:0000657'),
	('R_EX_eic21114tr_e', 'SBO:0000627'),
	('R_AK2LGCHOLt', 'SBO:0000658'),
	('R_DIGALSGALSIDEATPte', 'SBO:0000657'),
	('R_EX_CE4968_e', 'SBO:0000627'),
	('R_PCHOLET_HSt1e', 'SBO:0000658'),
	('R_PCHOLHEP_HSt1e', 'SBO:0000658'),
	('R_SUCACETATc', 'SBO:0000200'),
	('R_PCHOLLINL_HSt1e', 'SBO:0000658'),
	('R_PCHOLN15_HSt1e', 'SBO:0000658'),
	('R_PCHOLN183_HSt1e', 'SBO:0000658'),
	('R_PCHOLN1836_HSt1e', 'SBO:0000658'),
	('R_PCHOLN201_HSt1e', 'SBO:0000658'),
	('R_PCHOLN225_HSt1e', 'SBO:0000658'),
	('R_5EIPENCte', 'SBO:0000657'),
	('R_T4HCINNMte', 'SBO:0000660'),
	('R_AGRMte', 'SBO:0000658'),
	('R_EANDRSTRNte', 'SBO:0000657'),
	('R_AHANDROSTANte', 'SBO:0000657'),
	('R_PCHLN225_HSt1e', 'SBO:0000658'),
	('R_PCHOLSTE_HSt1e', 'SBO:0000658'),
	('R_SUCACETOte', 'SBO:0000658'),
	('R_PE12_HSt1e', 'SBO:0000658'),
	('R_PE14_HSt1e', 'SBO:0000658'),
	('R_PE15_HSt1e', 'SBO:0000658'),
	('R_C05301te', 'SBO:0000657'),
	('R_11DOCRTSLte', 'SBO:0000657'),
	('R_CE2211te', 'SBO:0000657'),
	('R_17AHPRGSTRNte', 'SBO:0000657'),
	('R_PE161_HSt1e', 'SBO:0000658'),
	('R_PE226_HSt1e', 'SBO:0000658'),
	('R_C03681te', 'SBO:0000657'),
	('R_PEAR_HSt1e', 'SBO:0000658'),
	('R_CE1352te', 'SBO:0000657'),
	('R_VANILLACc', 'SBO:0000200'),
	('R_PELPALM_HSt1e', 'SBO:0000658'),
	('R_PESTE_HSt1e', 'SBO:0000658'),
	('R_SPHMYLN_HsATPte', 'SBO:0000657'),
	('R_SPHMYLN180241_hs_ATPt', 'SBO:0000657'),
	('R_C05769te', 'SBO:0000657'),
	('R_GLCRt1', 'SBO:0000658'),
	('R_2HYOXPLCte', 'SBO:0000659'),
	('R_MHISTAte', 'SBO:0000658'),
	('R_SPHMYLN18114_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN18115_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN18116_hs_ATPt', 'SBO:0000657'),
	('R_VANILLACte', 'SBO:0000658'),
	('R_2OBUTt', 'SBO:0000659'),
	('R_PPP9ABCte', 'SBO:0000657'),
	('R_MLTHFte', 'SBO:0000659'),
	('R_TYMte2', 'SBO:0000659'),
	('R_CE4890te', 'SBO:0000659'),
	('R_CE7085te', 'SBO:0000657'),
	('R_CE4877te', 'SBO:0000657'),
	('R_C05770te', 'SBO:0000657'),
	('R_SPHS1Pt2e', 'SBO:0000657'),
	('R_DHEAte', 'SBO:0000657'),
	('R_EX_dhea_e', 'SBO:0000627'),
	('R_AHANDROSTANtr', 'SBO:0000657'),
	('R_EX_ahandrostan_e', 'SBO:0000627'),
	('R_ANDRSTANDRtr', 'SBO:0000657'),
	('R_EX_andrstandn_e', 'SBO:0000627'),
	('R_EX_CE2209_e', 'SBO:0000627'),
	('R_EX_estrone_e', 'SBO:0000627'),
	('R_C05298te', 'SBO:0000657'),
	('R_EX_C05299_e', 'SBO:0000627'),
	('R_EX_C05302_e', 'SBO:0000627'),
	('R_EX_11docrtsl_e', 'SBO:0000627'),
	('R_PTRCARGte', 'SBO:0000660'),
	('R_MLTHFte2', 'SBO:0000660'),
	('R_13DAMPPte', 'SBO:0000658'),
	('R_ARGN1ASPMDte', 'SBO:0000660'),
	('R_34DHPHAte', 'SBO:0000658'),
	('R_34DHOXMANDte', 'SBO:0000658'),
	('R_CE6205te', 'SBO:0000658'),
	('R_1A25DHVITD3te', 'SBO:0000658'),
	('R_ISOBUTtm', 'SBO:0000658'),
	('R_ISOBUTte', 'SBO:0000658'),
	('R_NACCYSte', 'SBO:0000658'),
	('R_EX_agm_e', 'SBO:0000627'),
	('R_T4HCINNMtm', 'SBO:0000658'),
	('R_EX_prgnlone_e', 'SBO:0000627'),
	('R_EX_17ahprgnlone_e', 'SBO:0000627'),
	('R_EX_C03681_e', 'SBO:0000627'),
	('R_HC02020tr', 'SBO:0000658'),
	('R_EX_prgnlones_e', 'SBO:0000627'),
	('R_EX_CE1352_e', 'SBO:0000627'),
	('R_XOL24OHte', 'SBO:0000658'),
	('R_EX_xol24oh_e', 'SBO:0000627'),
	('R_XOL25OHte', 'SBO:0000658'),
	('R_EX_xol25oh_e', 'SBO:0000627'),
	('R_DSMSTEROLtr', 'SBO:0000658'),
	('R_DSMSTEROLte', 'SBO:0000658'),
	('R_EX_chsterols_e', 'SBO:0000627'),
	('R_EX_3ityr__L_e', 'SBO:0000627'),
	('R_EX_T4hcinnm_e', 'SBO:0000627'),
	('R_4HBZtm', 'SBO:0000658'),
	('R_SUCSALtm', 'SBO:0000658'),
	('R_SUCSALte', 'SBO:0000658'),
	('R_CE7081tr', 'SBO:0000660'),
	('R_CE7081tm', 'SBO:0000657'),
	('R_EX_35diotyr_e', 'SBO:0000627'),
	('R_EX_13_cis_retn_e', 'SBO:0000627'),
	('R_DM_myelin_hs_c', 'SBO:0000628'),
	('R_12HARACHDtr', 'SBO:0000660'),
	('R_12HARACHDte', 'SBO:0000657'),
	('R_18HARACHDte', 'SBO:0000657'),
	('R_EX_18harachd_e', 'SBO:0000627'),
	('R_SQLte', 'SBO:0000658'),
	('R_HC00460te', 'SBO:0000658'),
	('R_EX_HC00460_e', 'SBO:0000627'),
	('R_ORN_Dte', 'SBO:0000660'),
	('R_5G2OXPTte', 'SBO:0000658'),
	('R_EX_vanillac_e', 'SBO:0000627'),
	('R_EX_CE7090_e', 'SBO:0000627'),
	('R_EX_CE7096_e', 'SBO:0000627'),
	('R_EX_CE4877_e', 'SBO:0000627'),
	('R_EX_CE1447_e', 'SBO:0000627'),
	('R_6HOXMELATNte', 'SBO:0000658'),
	('R_2H3MVc', 'SBO:0000200'),
	('R_EX_trypta_e', 'SBO:0000627'),
	('R_EX_CE2006_e', 'SBO:0000627'),
	('R_GLUCYSte', 'SBO:0000657'),
	('R_EX_C10164_e', 'SBO:0000627'),
	('R_EX_n8aspmd_e', 'SBO:0000627'),
	('R_2H3MVte', 'SBO:0000658'),
	('R_EX_CE6205_e', 'SBO:0000627'),
	('R_EX_C09642_e', 'SBO:0000627'),
	('R_MELATNte', 'SBO:0000658'),
	('R_2HIVc', 'SBO:0000200'),
	('R_EX_C05769_e', 'SBO:0000627'),
	('R_C05767te', 'SBO:0000658'),
	('R_EX_C05770_e', 'SBO:0000627'),
	('R_2HIVte', 'SBO:0000658'),
	('R_PPBNGte', 'SBO:0000658'),
	('R_EX_ppbng_e', 'SBO:0000627'),
	('R_12PPDRte', 'SBO:0000658'),
	('R_EX_12ppd__R_e', 'SBO:0000627'),
	('R_AMETAMte', 'SBO:0000658'),
	('R_UDPG3DOPA', 'SBO:0000217'),
	('R_34DHPEAR', 'SBO:0000200'),
	('R_EX_dopa4sf_e', 'SBO:0000627'),
	('R_DOPA4GLCURt', 'SBO:0000657'),
	('R_DOPA3GLCURt', 'SBO:0000657'),
	('R_XYLUDte', 'SBO:0000658'),
	('R_GLCNte', 'SBO:0000658'),
	('R_EX_CE0737_e', 'SBO:0000627'),
	('R_SPHGNSte', 'SBO:0000658'),
	('R_EX_2hiv_e', 'SBO:0000627'),
	('R_4GLU56DIHDINDt', 'SBO:0000657'),
	('R_EX_4glu56dihdind_e', 'SBO:0000627'),
	('R_EX_hdd2crn_e', 'SBO:0000627'),
	('R_IM4ACte', 'SBO:0000658'),
	('R_EX_im4ac_e', 'SBO:0000627'),
	('R_EX_CE1918_e', 'SBO:0000627'),
	('R_EX_mlthf_e', 'SBO:0000627'),
	('R_5CYSDOPAt', 'SBO:0000658'),
	('R_CE5025t', 'SBO:0000657'),
	('R_EX_CE5025_e', 'SBO:0000627'),
	('R_EX_CE2172_e', 'SBO:0000627'),
	('R_EX_ppp9_e', 'SBO:0000627'),
	('R_AACTte', 'SBO:0000658'),
	('R_EX_aact_e', 'SBO:0000627'),
	('R_CE5629t', 'SBO:0000658'),
	('R_EX_CE5629_e', 'SBO:0000627'),
	('R_EX_CE2705_e', 'SBO:0000627'),
	('R_SPHGNte', 'SBO:0000658'),
	('R_SELMETHt2e', 'SBO:0000658'),
	('R_EX_prist_e', 'SBO:0000627'),
	('R_EX_CE2049_e', 'SBO:0000627'),
	('R_DES21', 'SBO:0000200'),
	('R_EX_gd3_hs_e', 'SBO:0000627'),
	('R_CE2047te', 'SBO:0000657'),
	('R_EX_CE2047_e', 'SBO:0000627'),
	('R_LANOSTt', 'SBO:0000658'),
	('R_FDPte', 'SBO:0000658'),
	('R_EX_gm3_hs_e', 'SBO:0000627'),
	('R_GALGLUSIDEtl2', 'SBO:0000658'),
	('R_EX_2m3hbu_e', 'SBO:0000627'),
	('R_GD3tl', 'SBO:0000658'),
	('R_GLUSIDEtg', 'SBO:0000660'),
	('R_COKEtr', 'SBO:0000658'),
	('R_GM1tg', 'SBO:0000658'),
	('R_GM1tl', 'SBO:0000658'),
	('R_GM2tg', 'SBO:0000658'),
	('R_EX_5a2opntn_e', 'SBO:0000627'),
	('R_5A2OPNTNte', 'SBO:0000658'),
	('R_ARG_Dtx', 'SBO:0000658'),
	('R_ARG_Dte', 'SBO:0000658'),
	('R_EX_arg__D_e', 'SBO:0000627'),
	('R_GD3tlc', 'SBO:0000658'),
	('R_LANOSTtr', 'SBO:0000658'),
	('R_EX_idl_hs_e', 'SBO:0000627'),
	('R_EX_ldl_hs_e', 'SBO:0000627'),
	('R_EX_hdl_hs_e', 'SBO:0000627'),
	('R_EX_HC00005_e', 'SBO:0000627'),
	('R_DM_gd3_hs_g', 'SBO:0000628'),
	('R_2M3OVACtm', 'SBO:0000658'),
	('R_2M3HVACte', 'SBO:0000658'),
	('R_GD3tm', 'SBO:0000658'),
	('R_DM_pail35p_hs_n', 'SBO:0000628'),
	('R_DM_gd3_hs_m', 'SBO:0000628'),
	('R_DM_pcreat_c', 'SBO:0000628'),
	('R_DM_na1_x', 'SBO:0000628'),
	('R_DM_na1_g', 'SBO:0000628'),
	('R_EX_2m3hvac_e', 'SBO:0000627'),
	('R_DM_thm_m', 'SBO:0000628'),
	('R_DM_15HPET_n', 'SBO:0000628'),
	('R_EX_pail_hs_e', 'SBO:0000627'),
	('R_EX_CE1243_e', 'SBO:0000627'),
	('R_EX_galgluside_hs_e', 'SBO:0000627'),
	('R_EX_ga1_hs_e', 'SBO:0000627'),
	('R_SPHMYLNte', 'SBO:0000658'),
	('R_NH4tr', 'SBO:0000658'),
	('R_EX_gt1b_hs_e', 'SBO:0000627'),
	('R_HMR_0020', 'SBO:0000658'),
	('R_BUTt', 'SBO:0000658'),
	('R_HMR_0164', 'SBO:0000658'),
	('R_UDPGALt2n', 'SBO:0000658'),
	('R_UDPGALt2r', 'SBO:0000658'),
	('R_TETPENT3COAtm', 'SBO:0000658'),
	('R_THCRMtl', 'SBO:0000658'),
	('R_3MGLUTACtm', 'SBO:0000658'),
	('R_PCHOL_HStn', 'SBO:0000658'),
	('R_CHOLPtn', 'SBO:0000658'),
	('R_PHCRMter', 'SBO:0000658'),
	('R_HMR_0166', 'SBO:0000658'),
	('R_EX_3mglutac_e', 'SBO:0000627'),
	('R_HMR_0172', 'SBO:0000658'),
	('R_SPHGNtg', 'SBO:0000658'),
	('R_SPHINGStn', 'SBO:0000658'),
	('R_SPHINGStg', 'SBO:0000658'),
	('R_EX_cmpacna_e', 'SBO:0000627'),
	('R_EX_gd2_hs_e', 'SBO:0000627'),
	('R_HMR_0178', 'SBO:0000658'),
	('R_DHCRMtg', 'SBO:0000658'),
	('R_GDA1tn', 'SBO:0000658'),
	('R_PHSPHINGStg', 'SBO:0000658'),
	('R_PHSPHINGStr', 'SBO:0000658'),
	('R_SK_34dhpac_c', 'SBO:0000632'),
	('R_34DHPEt', 'SBO:0000658'),
	('R_DM_ts3_c', 'SBO:0000628'),
	('R_HMR_0183', 'SBO:0000658'),
	('R_FACOAE120', 'SBO:0000376'),
	('R_HMR_0194', 'SBO:0000657'),
	('R_HMR_0203', 'SBO:0000658'),
	('R_DM_sph1p_n', 'SBO:0000628'),
	('R_DM_sphs1p_n', 'SBO:0000628'),
	('R_DM_gda1_hs_n', 'SBO:0000628'),
	('R_GALSIDEtn', 'SBO:0000658'),
	('R_HMR_0208', 'SBO:0000658'),
	('R_CERT1tn', 'SBO:0000658'),
	('R_Rtotalter', 'SBO:0000658'),
	('R_HMR_0215', 'SBO:0000657'),
	('R_DM_phsph1p_c', 'SBO:0000628'),
	('R_3MGLUTRc', 'SBO:0000200'),
	('R_GD1Atn', 'SBO:0000658'),
	('R_ATPtg', 'SBO:0000657'),
	('R_GD1Btl', 'SBO:0000658'),
	('R_DM_gd3_hs_l', 'SBO:0000628'),
	('R_HMR_0232', 'SBO:0000658'),
	('R_HMR_0235', 'SBO:0000657'),
	('R_HMR_0240', 'SBO:0000658'),
	('R_3MGLUTRte', 'SBO:0000658'),
	('R_HMR_0243', 'SBO:0000657'),
	('R_EX_3mglutr_e', 'SBO:0000627'),
	('R_HMR_0244', 'SBO:0000658'),
	('R_HMR_0254', 'SBO:0000658'),
	('R_HMR_0292', 'SBO:0000658'),
	('R_HMR_0303', 'SBO:0000657'),
	('R_PPIOGLYtm', 'SBO:0000658'),
	('R_HMR_0304', 'SBO:0000658'),
	('R_PPIOGLYte', 'SBO:0000658'),
	('R_HMR_0322', 'SBO:0000658'),
	('R_HMR_0325', 'SBO:0000657'),
	('R_HMR_0270', 'SBO:0000658'),
	('R_HMR_0273', 'SBO:0000657'),
	('R_HMR_0277', 'SBO:0000657'),
	('R_HMR_0288', 'SBO:0000658'),
	('R_HMR_0587', 'SBO:0000658'),
	('R_HMR_0391', 'SBO:0000657'),
	('R_HMR_0392', 'SBO:0000658'),
	('R_HMR_0415', 'SBO:0000657'),
	('R_HMR_0329', 'SBO:0000657'),
	('R_HMR_0344', 'SBO:0000658'),
	('R_HMR_0347', 'SBO:0000657'),
	('R_HMR_0367', 'SBO:0000657'),
	('R_HMR_0371', 'SBO:0000657'),
	('R_HMR_0423', 'SBO:0000657'),
	('R_HMR_0427', 'SBO:0000657'),
	('R_HMR_0383', 'SBO:0000657'),
	('R_HMR_0384', 'SBO:0000658'),
	('R_HMR_0469', 'SBO:0000657'),
	('R_HMR_0966', 'SBO:0000658'),
	('R_HMR_0984', 'SBO:0000658'),
	('R_HMR_1095', 'SBO:0000658'),
	('R_HMR_1102', 'SBO:0000200'),
	('R_HMR_1127', 'SBO:0000200'),
	('R_HMR_1242', 'SBO:0000658'),
	('R_HMR_1284', 'SBO:0000658'),
	('R_HMR_1306', 'SBO:0000658'),
	('R_HMR_1311', 'SBO:0000658'),
	('R_HMR_1325', 'SBO:0000200'),
	('R_HMR_1331', 'SBO:0000658'),
	('R_HMR_1392', 'SBO:0000660'),
	('R_HMR_1738', 'SBO:0000200'),
	('R_HMR_1740', 'SBO:0000200'),
	('R_HMR_1744', 'SBO:0000658'),
	('R_SMO', 'SBO:0000200'),
	('R_LNSTLS', 'SBO:0000377'),
	('R_HMR_1479', 'SBO:0000200'),
	('R_C3STDH1', 'SBO:0000377'),
	('R_HMR_1745', 'SBO:0000658'),
	('R_HMR_1746', 'SBO:0000200'),
	('R_HMR_1747', 'SBO:0000200'),
	('R_HMR_1748', 'SBO:0000200'),
	('R_HMR_1502', 'SBO:0000200'),
	('R_HMR_1503', 'SBO:0000200'),
	('R_HMR_1505', 'SBO:0000399'),
	('R_CHLSTI_1', 'SBO:0000377'),
	('R_HMR_1753', 'SBO:0000658'),
	('R_DSMSTOLR', 'SBO:0000200'),
	('R_HMR_1758', 'SBO:0000658'),
	('R_HMR_1759', 'SBO:0000658'),
	('R_HMR_1536', 'SBO:0000200'),
	('R_HMR_1538', 'SBO:0000200'),
	('R_HMR_1539', 'SBO:0000200'),
	('R_HMR_1762', 'SBO:0000200'),
	('R_HMR_1765', 'SBO:0000200'),
	('R_HMR_1767', 'SBO:0000200'),
	('R_HMR_1768', 'SBO:0000200'),
	('R_HMR_1771', 'SBO:0000200'),
	('R_HMR_1781', 'SBO:0000200'),
	('R_HMR_1783', 'SBO:0000200'),
	('R_HMR_1785', 'SBO:0000200'),
	('R_HMR_1543', 'SBO:0000200'),
	('R_HMR_1547', 'SBO:0000200'),
	('R_HMR_1549', 'SBO:0000200'),
	('R_HMR_1786', 'SBO:0000200'),
	('R_HMR_1838', 'SBO:0000200'),
	('R_HMR_1550', 'SBO:0000200'),
	('R_HMR_1897', 'SBO:0000660'),
	('R_HMR_1551', 'SBO:0000399'),
	('R_HMR_1916', 'SBO:0000658'),
	('R_HMR_1927', 'SBO:0000200'),
	('R_HMR_1629', 'SBO:0000658'),
	('R_HMR_1630', 'SBO:0000658'),
	('R_HMR_1631', 'SBO:0000658'),
	('R_HMR_1929', 'SBO:0000200'),
	('R_HMR_1666', 'SBO:0000658'),
	('R_HMR_1940', 'SBO:0000200'),
	('R_HMR_1944', 'SBO:0000200'),
	('R_HMR_1949', 'SBO:0000200'),
	('R_HMR_1958', 'SBO:0000200'),
	('R_HMR_1968', 'SBO:0000200'),
	('R_HMR_1971', 'SBO:0000200'),
	('R_HMR_1996', 'SBO:0000200'),
	('R_HMR_0769', 'SBO:0000658'),
	('R_HMR_2010', 'SBO:0000200'),
	('R_HMR_2016', 'SBO:0000200'),
	('R_HMR_1981', 'SBO:0000200'),
	('R_HMR_1982', 'SBO:0000200'),
	('R_HMR_2018', 'SBO:0000200'),
	('R_HMR_0770', 'SBO:0000658'),
	('R_HMR_2041', 'SBO:0000200'),
	('R_HMR_0771', 'SBO:0000658'),
	('R_HMR_2090', 'SBO:0000658'),
	('R_HMR_2210', 'SBO:0000200'),
	('R_HMR_2211', 'SBO:0000399'),
	('R_HMR_2215', 'SBO:0000399'),
	('R_HMR_2260', 'SBO:0000200'),
	('R_HMR_2268', 'SBO:0000200'),
	('R_HMR_2289', 'SBO:0000200'),
	('R_DESAT18', 'SBO:0000200'),
	('R_HMR_2296', 'SBO:0000200'),
	('R_HMR_2332', 'SBO:0000399'),
	('R_HMR_2270', 'SBO:0000200'),
	('R_HMR_2282', 'SBO:0000200'),
	('R_HMR_2342', 'SBO:0000399'),
	('R_HMR_2284', 'SBO:0000200'),
	('R_HMR_2343', 'SBO:0000200'),
	('R_HMR_2347', 'SBO:0000399'),
	('R_DESAT16', 'SBO:0000200'),
	('R_HMR_2287', 'SBO:0000200'),
	('R_HMR_2348', 'SBO:0000200'),
	('R_HMR_2350', 'SBO:0000200'),
	('R_HMR_2353', 'SBO:0000399'),
	('R_HMR_2533', 'SBO:0000200'),
	('R_HMR_2541', 'SBO:0000200'),
	('R_HMR_2354', 'SBO:0000200'),
	('R_HMR_2359', 'SBO:0000200'),
	('R_HMR_2361', 'SBO:0000399'),
	('R_HMR_2364', 'SBO:0000200'),
	('R_HMR_2569', 'SBO:0000658'),
	('R_HMR_2581', 'SBO:0000200'),
	('R_HMR_2603', 'SBO:0000660'),
	('R_HMR_2609', 'SBO:0000660'),
	('R_HMR_2365', 'SBO:0000200'),
	('R_HMR_2368', 'SBO:0000200'),
	('R_HMR_2374', 'SBO:0000200'),
	('R_HMR_2380', 'SBO:0000200'),
	('R_CARN140t_m', 'SBO:0000660'),
	('R_HMR_2621', 'SBO:0000660'),
	('R_HMR_2391', 'SBO:0000200'),
	('R_HMR_2393', 'SBO:0000200'),
	('R_HMR_2395', 'SBO:0000399'),
	('R_HMR_2457', 'SBO:0000200'),
	('R_HMR_2624', 'SBO:0000660'),
	('R_HMR_2737', 'SBO:0000660'),
	('R_HMR_2634', 'SBO:0000660'),
	('R_HMR_2649', 'SBO:0000660'),
	('R_HMR_2652', 'SBO:0000660'),
	('R_HMR_2673', 'SBO:0000660'),
	('R_HMR_2676', 'SBO:0000660'),
	('R_HMR_2682', 'SBO:0000660'),
	('R_HMR_2700', 'SBO:0000660'),
	('R_HMR_2706', 'SBO:0000660'),
	('R_CARN1829Z12Zt_m', 'SBO:0000660'),
	('R_HMR_2722', 'SBO:0000660'),
	('R_HMR_2731', 'SBO:0000660'),
	('R_HMR_2734', 'SBO:0000660'),
	('R_CARN1836Z9Z12Zt_m', 'SBO:0000660'),
	('R_HMR_2753', 'SBO:0000660'),
	('R_HMR_2757', 'SBO:0000660'),
	('R_HMR_2760', 'SBO:0000660'),
	('R_HMR_2764', 'SBO:0000660'),
	('R_HMR_3021', 'SBO:0000658'),
	('R_HMR_3023', 'SBO:0000658'),
	('R_HMR_3054', 'SBO:0000200'),
	('R_HMR_3055', 'SBO:0000200'),
	('R_HMR_9667', 'SBO:0000658'),
	('R_HMR_3059', 'SBO:0000200'),
	('R_HMR_3115', 'SBO:0000200'),
	('R_HMR_2769', 'SBO:0000660'),
	('R_HMR_3072', 'SBO:0000200'),
	('R_HMR_3128', 'SBO:0000200'),
	('R_ACOADH100_m', 'SBO:0000200'),
	('R_HMR_3170', 'SBO:0000200'),
	('R_HMR_3172', 'SBO:0000200'),
	('R_HMR_3174', 'SBO:0000200'),
	('R_HMR_3176', 'SBO:0000200'),
	('R_HMR_3184', 'SBO:0000200'),
	('R_HMR_3096', 'SBO:0000200'),
	('R_HMR_3190', 'SBO:0000200'),
	('R_HMR_3192', 'SBO:0000200'),
	('R_HMR_3106', 'SBO:0000658'),
	('R_HMR_3111', 'SBO:0000200'),
	('R_HMR_3200', 'SBO:0000200'),
	('R_HMR_3204', 'SBO:0000200'),
	('R_HMR_3218', 'SBO:0000200'),
	('R_HMR_3478', 'SBO:0000658'),
	('R_HMR_3220', 'SBO:0000200'),
	('R_HMR_3234', 'SBO:0000200'),
	('R_HMR_3222', 'SBO:0000200'),
	('R_HMR_3240', 'SBO:0000200'),
	('R_HMR_3244', 'SBO:0000200'),
	('R_HMR_3328', 'SBO:0000200'),
	('R_HMR_3332', 'SBO:0000200'),
	('R_HMR_3408', 'SBO:0000200'),
	('R_HMR_3409', 'SBO:0000200'),
	('R_HMR_3413', 'SBO:0000200'),
	('R_HMR_3336', 'SBO:0000200'),
	('R_HMR_3414', 'SBO:0000200'),
	('R_HMR_3416', 'SBO:0000200'),
	('R_HMR_3421', 'SBO:0000200'),
	('R_HMR_2851', 'SBO:0000660'),
	('R_HMR_3425', 'SBO:0000200'),
	('R_HMR_3426', 'SBO:0000200'),
	('R_HMR_3340', 'SBO:0000200'),
	('R_HMR_3427', 'SBO:0000200'),
	('R_HMR_3428', 'SBO:0000200'),
	('R_HMR_3431', 'SBO:0000200'),
	('R_HMR_3432', 'SBO:0000200'),
	('R_HMR_3433', 'SBO:0000200'),
	('R_HMR_3448', 'SBO:0000200'),
	('R_HMR_3450', 'SBO:0000200'),
	('R_HMR_3398', 'SBO:0000200'),
	('R_HMR_3407', 'SBO:0000200'),
	('R_HMR_3457', 'SBO:0000200'),
	('R_HMR_3597', 'SBO:0000658'),
	('R_HMR_2861', 'SBO:0000660'),
	('R_HMR_2865', 'SBO:0000660'),
	('R_HMR_2884', 'SBO:0000660'),
	('R_ASPT', 'SBO:0000178'),
	('R_HMR_3855', 'SBO:0000200'),
	('R_HMR_3951', 'SBO:0000659'),
	('R_HMR_4079', 'SBO:0000200'),
	('R_HMR_4124', 'SBO:0000399'),
	('R_HMR_4266', 'SBO:0000658'),
	('R_HMR_2888', 'SBO:0000660'),
	('R_XYLR', 'SBO:0000200'),
	('R_HMR_6633', 'SBO:0000200'),
	('R_DCTPD', 'SBO:0000401'),
	('R_TYROX', 'SBO:0000200'),
	('R_HMR_6785', 'SBO:0000200'),
	('R_HMR_4700', 'SBO:0000200'),
	('R_4HALDD', 'SBO:0000200'),
	('R_HMR_6854', 'SBO:0000200'),
	('R_HMR_6907', 'SBO:0000200'),
	('R_HMR_6909', 'SBO:0000200'),
	('R_HMR_4756', 'SBO:0000658'),
	('R_HMR_4790', 'SBO:0000658'),
	('R_HMR_4957', 'SBO:0000658'),
	('R_GLNtm_1', 'SBO:0000659'),
	('R_METOX', 'SBO:0000200'),
	('R_CITt4_3', 'SBO:0000659'),
	('R_HMR_6362', 'SBO:0000659'),
	('R_HMR_6365', 'SBO:0000659'),
	('R_HMR_6385', 'SBO:0000660'),
	('R_HMR_7173', 'SBO:0000658'),
	('R_HMR_7182', 'SBO:0000658'),
	('R_HMR_7199', 'SBO:0000658'),
	('R_HMR_7257', 'SBO:0000658'),
	('R_HMR_7431', 'SBO:0000658'),
	('R_HMR_6408', 'SBO:0000659'),
	('R_HMR_6500', 'SBO:0000660'),
	('R_GLYCTO1', 'SBO:0000200'),
	('R_HMR_7711', 'SBO:0000658'),
	('R_AMPtn', 'SBO:0000658'),
	('R_HMR_7720', 'SBO:0000658'),
	('R_HMR_6629', 'SBO:0000658'),
	('R_HMR_7756', 'SBO:0000401'),
	('R_HMR_7898', 'SBO:0000658'),
	('R_HMR_9670', 'SBO:0000658'),
	('R_HMR_7900', 'SBO:0000658'),
	('R_HMR_7906', 'SBO:0000658'),
	('R_HMR_9671', 'SBO:0000658'),
	('R_HMR_7944', 'SBO:0000658'),
	('R_HMR_9175', 'SBO:0000658'),
	('R_HMR_9176', 'SBO:0000658'),
	('R_HMR_9180', 'SBO:0000658'),
	('R_HMR_9184', 'SBO:0000658'),
	('R_HMR_9187', 'SBO:0000658'),
	('R_HMR_9188', 'SBO:0000658'),
	('R_HMR_8023', 'SBO:0000658'),
	('R_HMR_8374', 'SBO:0000658'),
	('R_HMR_8418', 'SBO:0000660'),
	('R_HMR_9189', 'SBO:0000658'),
	('R_HMR_9581', 'SBO:0000658'),
	('R_DCYTtm', 'SBO:0000658'),
	('R_HMR_8476', 'SBO:0000658'),
	('R_HMR_9582', 'SBO:0000659'),
	('R_HMR_8567', 'SBO:0000658'),
	('R_FA160tp', 'SBO:0000658'),
	('R_SO4t_e', 'SBO:0000659'),
	('R_HMR_9593', 'SBO:0000659'),
	('R_HMR_9604', 'SBO:0000659'),
	('R_HMR_9605', 'SBO:0000660'),
	('R_PNTOt1', 'SBO:0000659'),
	('R_HMR_8588', 'SBO:0000658'),
	('R_HMR_9608', 'SBO:0000659'),
	('R_HMR_9609', 'SBO:0000659'),
	('R_HMR_9610', 'SBO:0000659'),
	('R_HMR_9612', 'SBO:0000659'),
	('R_HMR_9614', 'SBO:0000659'),
	('R_HMR_9617', 'SBO:0000659'),
	('R_HMR_9619', 'SBO:0000659'),
	('R_HMR_9622', 'SBO:0000660'),
	('R_HMR_9623', 'SBO:0000660'),
	('R_3DHLCAt2', 'SBO:0000659'),
	('R_7DHCDCHOLt', 'SBO:0000660'),
	('R_7DHCDCHOLt2', 'SBO:0000659'),
	('R_7DHCHOLabc', 'SBO:0000657'),
	('R_7DHCHOLt', 'SBO:0000660'),
	('R_7DHCHOLt2', 'SBO:0000659'),
	('R_HMR_9624', 'SBO:0000660'),
	('R_HMR_9625', 'SBO:0000658'),
	('R_HMR_9626', 'SBO:0000658'),
	('R_HMR_9628', 'SBO:0000658'),
	('R_CA24GSr', 'SBO:0000217'),
	('R_CA24Gtr', 'SBO:0000658'),
	('R_HMR_9631', 'SBO:0000658'),
	('R_HMR_9635', 'SBO:0000658'),
	('R_HMR_9638', 'SBO:0000658'),
	('R_CA3Sabc', 'SBO:0000657'),
	('R_HMR_9720', 'SBO:0000658'),
	('R_CDCA24Gte', 'SBO:0000657'),
	('R_HMR_9640', 'SBO:0000658'),
	('R_HMR_9642', 'SBO:0000658'),
	('R_HMR_9644', 'SBO:0000658'),
	('R_HMR_9647', 'SBO:0000658'),
	('R_HMR_9648', 'SBO:0000658'),
	('R_HC02220t', 'SBO:0000660'),
	('R_CDCA6AH', 'SBO:0000200'),
	('R_COPROSTabc', 'SBO:0000657'),
	('R_COPROSTt', 'SBO:0000660'),
	('R_COPROSTt2', 'SBO:0000659'),
	('R_DCA24GSr', 'SBO:0000217'),
	('R_HMR_9656', 'SBO:0000658'),
	('R_HMR_9660', 'SBO:0000658'),
	('R_HMR_9661', 'SBO:0000658'),
	('R_HMR_9663', 'SBO:0000658'),
	('R_DCA3GSr', 'SBO:0000217'),
	('R_DCA3Sabc', 'SBO:0000657'),
	('R_DCA3St', 'SBO:0000660'),
	('R_DM_icdchol_c', 'SBO:0000628'),
	('R_DM_lca24g_c', 'SBO:0000628'),
	('R_DM_3dhdchol_c', 'SBO:0000628'),
	('R_DM_7dhcdchol_c', 'SBO:0000628'),
	('R_DM_7dhchol_c', 'SBO:0000628'),
	('R_DM_lca3g_c', 'SBO:0000628'),
	('R_DM_tcdca3s_c', 'SBO:0000628'),
	('R_DM_thyochol_c', 'SBO:0000628'),
	('R_DM_ca24g_c', 'SBO:0000628'),
	('R_ADD', 'SBO:0000401'),
	('R_DM_ca3s_c', 'SBO:0000628'),
	('R_DM_dca24g_c', 'SBO:0000628'),
	('R_DM_dca3s_c', 'SBO:0000628'),
	('R_DM_uchol_c', 'SBO:0000628'),
	('R_DM_gca3s_c', 'SBO:0000628'),
	('R_DM_udca3s_c', 'SBO:0000628'),
	('R_HMR_9803', 'SBO:0000200'),
	('R_EX_12dhchol_e', 'SBO:0000627'),
	('R_EX_3dhchol_e', 'SBO:0000627'),
	('R_DM_gcdca3s_c', 'SBO:0000628'),
	('R_DM_gdca3s_c', 'SBO:0000628'),
	('R_DM_gudca3s_c', 'SBO:0000628'),
	('R_DM_hca24g_c', 'SBO:0000628'),
	('R_EX_3dhlchol_e', 'SBO:0000627'),
	('R_EX_7dhcdchol_e', 'SBO:0000627'),
	('R_EX_ca24g_e', 'SBO:0000627'),
	('R_EX_ca3s_e', 'SBO:0000627'),
	('R_EX_cdca24g_e', 'SBO:0000627'),
	('R_EX_coprost_e', 'SBO:0000627'),
	('R_EX_dca3s_e', 'SBO:0000627'),
	('R_EX_hdca24g_e', 'SBO:0000627'),
	('R_EX_hdca6g_e', 'SBO:0000627'),
	('R_DM_hca6g_c', 'SBO:0000628'),
	('R_DM_hdca24g_c', 'SBO:0000628'),
	('R_EX_icdchol_e', 'SBO:0000627'),
	('R_HDCA24Gte', 'SBO:0000657'),
	('R_HMR_9804', 'SBO:0000200'),
	('R_HDCA24Gtr', 'SBO:0000658'),
	('R_HDCA6GSc', 'SBO:0000217'),
	('R_HDCA6Gtr', 'SBO:0000658'),
	('R_HYOCHOLt', 'SBO:0000660'),
	('R_EX_lca3g_e', 'SBO:0000627'),
	('R_EX_tca3s_e', 'SBO:0000627'),
	('R_EX_tdca3s_e', 'SBO:0000627'),
	('R_EX_thyochol_e', 'SBO:0000627'),
	('R_EX_tudca3s_e', 'SBO:0000627'),
	('R_HYOCHOLt2', 'SBO:0000659'),
	('R_ICDCHOLt2', 'SBO:0000659'),
	('R_HMR_9807', 'SBO:0000401'),
	('R_ISOCHOLt', 'SBO:0000660'),
	('R_GCA3St', 'SBO:0000660'),
	('R_EX_mem2emgacpail_prot_hs_e', 'SBO:0000627'),
	('R_GCDCA3Sabc', 'SBO:0000657'),
	('R_GDCA3St', 'SBO:0000660'),
	('R_HCA24GSr', 'SBO:0000217'),
	('R_HCA24Gtr', 'SBO:0000658'),
	('R_HCA6Gte', 'SBO:0000657'),
	('R_HCA6Gtr', 'SBO:0000658'),
	('R_LCA24Gte', 'SBO:0000657'),
	('R_LCA24Gtr', 'SBO:0000658'),
	('R_LCA3GSr', 'SBO:0000217'),
	('R_TCDCA3Sabc', 'SBO:0000657'),
	('R_TCDCA3St', 'SBO:0000660'),
	('R_TCDCA6AH', 'SBO:0000200'),
	('R_UDCA3Sabc', 'SBO:0000657'),
	('R_TDCA3Sabc', 'SBO:0000657'),
	('R_UDCA3St', 'SBO:0000660'),
	('R_TDCA3St', 'SBO:0000660'),
	('R_UDCHOLt', 'SBO:0000660'),
	('R_C14STR', 'SBO:0000200'),
	('R_THYOCHOLabc', 'SBO:0000657'),
	('R_THYOCHOLt', 'SBO:0000660'),
	('R_HMR_1467', 'SBO:0000200'),
	('R_TUDCA3St', 'SBO:0000660'),
	('R_UCHOLabc', 'SBO:0000657'),
	('R_UCHOLt', 'SBO:0000660'),
	('R_12HTACRtep', 'SBO:0000658'),
	('R_HMR_1500', 'SBO:0000200'),
	('R_1331TACRteb', 'SBO:0000657'),
	('R_13DMTtu', 'SBO:0000657'),
	('R_3HPVSTETteb', 'SBO:0000657'),
	('R_3HPVSTETtev', 'SBO:0000658'),
	('R_3HPVSteb', 'SBO:0000657'),
	('R_3HPVStep', 'SBO:0000658'),
	('R_13DMTtep', 'SBO:0000658'),
	('R_14HMDZALThr', 'SBO:0000200'),
	('R_14HMDZhr', 'SBO:0000200'),
	('R_3ISPVSteb', 'SBO:0000657'),
	('R_4BHGLZhr', 'SBO:0000200'),
	('R_1513TACRtu', 'SBO:0000657'),
	('R_1531TACRtev', 'SBO:0000658'),
	('R_4BHGLZtev', 'SBO:0000658'),
	('R_15DMTtu', 'SBO:0000657'),
	('R_EX_nadh_e', 'SBO:0000627'),
	('R_1HIBUP_Sthv', 'SBO:0000658'),
	('R_1HMDGLUChr', 'SBO:0000217'),
	('R_2HATVACIDOXDhc', 'SBO:0000200'),
	('R_2HATVACIDthc', 'SBO:0000660'),
	('R_2HATVLACGLUChr', 'SBO:0000217'),
	('R_2HATVLACGLUCteb', 'SBO:0000657'),
	('R_2HATVLACOXDhc', 'SBO:0000200'),
	('R_2HATVLACthc', 'SBO:0000660'),
	('R_4HATVLACOXDhc', 'SBO:0000200'),
	('R_56DHPVShc', 'SBO:0000200'),
	('R_56DHPVStev', 'SBO:0000658'),
	('R_56EPPVStev', 'SBO:0000658'),
	('R_5OHFVSGLUhc', 'SBO:0000217'),
	('R_5OHFVShc', 'SBO:0000200'),
	('R_5OHFVSteb', 'SBO:0000657'),
	('R_6AHGLZABCt', 'SBO:0000657'),
	('R_6AHGLZhr', 'SBO:0000200'),
	('R_6BHGLZABCt', 'SBO:0000657'),
	('R_6CSMVACIDteb', 'SBO:0000657'),
	('R_2HIBUPGLUC_Sthv', 'SBO:0000658'),
	('R_31DMTtu', 'SBO:0000657'),
	('R_31DMTtep', 'SBO:0000658'),
	('R_35DHPVShc', 'SBO:0000200'),
	('R_35DHPVStep', 'SBO:0000658'),
	('R_6HLVSTthep', 'SBO:0000658'),
	('R_35DHPVSthc', 'SBO:0000660'),
	('R_3HIBUPGLUC_Sthv', 'SBO:0000658'),
	('R_3HIBUP_Rthv', 'SBO:0000658'),
	('R_3HIBUP_Sthv', 'SBO:0000658'),
	('R_6HMSMVhep', 'SBO:0000200'),
	('R_6MELVSTthep', 'SBO:0000658'),
	('R_3HLVSTACtbc', 'SBO:0000657'),
	('R_6OHFVSGLUtev', 'SBO:0000658'),
	('R_12DHCHOLabc', 'SBO:0000657'),
	('R_6OHFVShc', 'SBO:0000200'),
	('R_7AHGLZtev', 'SBO:0000658'),
	('R_7BHGLZABCt', 'SBO:0000657'),
	('R_ATVLACtdhc', 'SBO:0000658'),
	('R_Am1CSAteb', 'SBO:0000657'),
	('R_CARBIBUP_SGLUthv', 'SBO:0000658'),
	('R_CARIBUP_Rthv', 'SBO:0000658'),
	('R_7BHGLZGLCABCt', 'SBO:0000657'),
	('R_7BHGLZGLChr', 'SBO:0000217'),
	('R_7BHGLZGLCtev', 'SBO:0000658'),
	('R_7HPVSteb', 'SBO:0000657'),
	('R_CRGLZABCt', 'SBO:0000657'),
	('R_7HPVStev', 'SBO:0000658'),
	('R_ALLOP2tu', 'SBO:0000659'),
	('R_CRVS1M24hc', 'SBO:0000200'),
	('R_ACMPtu', 'SBO:0000657'),
	('R_3DHCAS', 'SBO:0000200'),
	('R_ACMPGLUChr', 'SBO:0000217'),
	('R_ACMPGLUTdt', 'SBO:0000658'),
	('R_CRVS23M24hc', 'SBO:0000200'),
	('R_CRVSATPthc', 'SBO:0000657'),
	('R_CRVSM1hc', 'SBO:0000200'),
	('R_ACMPGLUTthc', 'SBO:0000657'),
	('R_ACMPGLUthc', 'SBO:0000657'),
	('R_AM19CShr', 'SBO:0000200'),
	('R_AM19CSteb', 'SBO:0000657'),
	('R_AM1A4NCSteb', 'SBO:0000657'),
	('R_AM1ACCStev', 'SBO:0000658'),
	('R_AM1ACShr', 'SBO:0000200'),
	('R_CRVSM23hc', 'SBO:0000200'),
	('R_CRVSM23tev', 'SBO:0000658'),
	('R_CRVSM24teb', 'SBO:0000657'),
	('R_CSAtd', 'SBO:0000658'),
	('R_CVM1GLUChc', 'SBO:0000217'),
	('R_AM1ACSteb', 'SBO:0000657'),
	('R_AM1ALCShr', 'SBO:0000200'),
	('R_AM1ALCSteb', 'SBO:0000657'),
	('R_AM1ALCStep', 'SBO:0000658'),
	('R_CYSAMPtev', 'SBO:0000657'),
	('R_AM1C4N9CSteb', 'SBO:0000657'),
	('R_3DHCDCAS', 'SBO:0000200'),
	('R_AM1C9CShr', 'SBO:0000200'),
	('R_AM1C9CSteb', 'SBO:0000657'),
	('R_AM1C9CStev', 'SBO:0000658'),
	('R_AM1CCShr', 'SBO:0000200'),
	('R_AM1CCSteb', 'SBO:0000657'),
	('R_DEOXFVShc', 'SBO:0000200'),
	('R_DEOXFVStev', 'SBO:0000658'),
	('R_AM1CGLChr', 'SBO:0000217'),
	('R_3DHCHOLabc', 'SBO:0000657'),
	('R_AM1CSAtep', 'SBO:0000658'),
	('R_AM4N9CStev', 'SBO:0000658'),
	('R_AM4NC9CSteb', 'SBO:0000657'),
	('R_AM4NCSteb', 'SBO:0000657'),
	('R_AM4NCStep', 'SBO:0000658'),
	('R_ATVACIDOATPtu', 'SBO:0000660'),
	('R_ATVACIDtdu', 'SBO:0000658'),
	('R_ATVACIDtu', 'SBO:0000657'),
	('R_ATVLACGLCURhc', 'SBO:0000217'),
	('R_EX_3hlvstacid_e', 'SBO:0000627'),
	('R_EX_3hpvs_e', 'SBO:0000627'),
	('R_DESFVSteb', 'SBO:0000657'),
	('R_DHGLZABCt', 'SBO:0000657'),
	('R_DHGLZhc', 'SBO:0000200'),
	('R_DSPVSteb', 'SBO:0000657'),
	('R_EPOXTACteb', 'SBO:0000657'),
	('R_EPOXTACtev', 'SBO:0000658'),
	('R_EX_13dmt_e', 'SBO:0000627'),
	('R_EX_1513tacr_e', 'SBO:0000627'),
	('R_EX_1hibupglu__S_e', 'SBO:0000627'),
	('R_EX_2hatvacidgluc_e', 'SBO:0000627'),
	('R_EX_2hibupglu__S_e', 'SBO:0000627'),
	('R_EX_31dmt_e', 'SBO:0000627'),
	('R_EX_35dsmv_e', 'SBO:0000627'),
	('R_EX_3hibup__R_e', 'SBO:0000627'),
	('R_EX_3ohacmp_e', 'SBO:0000627'),
	('R_EX_4hatvacid_e', 'SBO:0000627'),
	('R_EX_4hmdgluc_e', 'SBO:0000627'),
	('R_EX_56dhpvs_e', 'SBO:0000627'),
	('R_3DHCHOLt', 'SBO:0000660'),
	('R_EX_5ohfvs_e', 'SBO:0000627'),
	('R_EX_6epvs_e', 'SBO:0000627'),
	('R_EX_lvst_e', 'SBO:0000627'),
	('R_EX_meracmp_e', 'SBO:0000627'),
	('R_EX_nfdac_e', 'SBO:0000627'),
	('R_EX_oxyp_e', 'SBO:0000627'),
	('R_EX_ptvstm3_e', 'SBO:0000627'),
	('R_EX_6hmsmvacid_e', 'SBO:0000627'),
	('R_EX_6ohfvs_e', 'SBO:0000627'),
	('R_EX_7ahglz_e', 'SBO:0000627'),
	('R_EX_7bhglz_e', 'SBO:0000627'),
	('R_EX_7hpvs_e', 'SBO:0000627'),
	('R_EX_acmpglut_e', 'SBO:0000627'),
	('R_EX_am19cs_e', 'SBO:0000627'),
	('R_EX_pvs_e', 'SBO:0000627'),
	('R_EX_pvsgluc_e', 'SBO:0000627'),
	('R_EX_smv_e', 'SBO:0000627'),
	('R_EX_smvacid_e', 'SBO:0000627'),
	('R_3DHCHOLt2', 'SBO:0000659'),
	('R_EX_sulpacmp_e', 'SBO:0000627'),
	('R_EX_tacr_e', 'SBO:0000627'),
	('R_EX_thrfvs_e', 'SBO:0000627'),
	('R_3DHDCAabc', 'SBO:0000657'),
	('R_EX_tmd_e', 'SBO:0000627'),
	('R_EX_tmdm1_e', 'SBO:0000627'),
	('R_EX_tmdm3_e', 'SBO:0000627'),
	('R_EX_am1alcs_e', 'SBO:0000627'),
	('R_EX_am1c4n9cs_e', 'SBO:0000627'),
	('R_EX_am1cglc_e', 'SBO:0000627'),
	('R_EX_am1csa_e', 'SBO:0000627'),
	('R_EX_tripvs_e', 'SBO:0000627'),
	('R_EX_am4ncs_e', 'SBO:0000627'),
	('R_EX_am9csa_e', 'SBO:0000627'),
	('R_FVSGLUChc', 'SBO:0000217'),
	('R_EX_atvacid_e', 'SBO:0000627'),
	('R_FVSTETGLUhc', 'SBO:0000217'),
	('R_EX_caribup__R_e', 'SBO:0000627'),
	('R_FVSTETGLUtev', 'SBO:0000658'),
	('R_FVSTETtev', 'SBO:0000658'),
	('R_FVStep', 'SBO:0000658'),
	('R_GLZABCteb', 'SBO:0000657'),
	('R_EX_crvs_e', 'SBO:0000627'),
	('R_EX_crvsm24_e', 'SBO:0000627'),
	('R_EX_csa_e', 'SBO:0000627'),
	('R_EX_dhglz_e', 'SBO:0000627'),
	('R_EX_dspvs_e', 'SBO:0000627'),
	('R_EX_epoxtac_e', 'SBO:0000627'),
	('R_GTACMPhr', 'SBO:0000217'),
	('R_GTACMPtev', 'SBO:0000657'),
	('R_IBUPGT_HEP', 'SBO:0000217'),
	('R_EX_fvs_e', 'SBO:0000627'),
	('R_3DHDCAt2', 'SBO:0000659'),
	('R_EX_fvstetglu_e', 'SBO:0000627'),
	('R_EX_glc3meacp_e', 'SBO:0000627'),
	('R_EX_glz_e', 'SBO:0000627'),
	('R_EX_gtacmp_e', 'SBO:0000627'),
	('R_EX_ibup__R_e', 'SBO:0000627'),
	('R_IBUP_RCYP2hep', 'SBO:0000200'),
	('R_IBUP_Rtdu', 'SBO:0000658'),
	('R_EX_ibupgluc_e', 'SBO:0000627'),
	('R_EX_isolvstacid_e', 'SBO:0000627'),
	('R_EX_lst4exp_e', 'SBO:0000627'),
	('R_IBUP_SCYP1hep', 'SBO:0000200'),
	('R_EX_lstn_e', 'SBO:0000627'),
	('R_EX_lstnm1_e', 'SBO:0000627'),
	('R_IBUP_SCYP2hep', 'SBO:0000200'),
	('R_3DHLCAabc', 'SBO:0000657'),
	('R_IBUP_Stbc', 'SBO:0000657'),
	('R_ISOLVSTtbc', 'SBO:0000657'),
	('R_LST4EXPTDhc', 'SBO:0000658'),
	('R_LST4EXPthc', 'SBO:0000660'),
	('R_LSTN1GLUCtev', 'SBO:0000658'),
	('R_LSTNtu', 'SBO:0000657'),
	('R_LSTNM1hr', 'SBO:0000200'),
	('R_LSTNM1tev', 'SBO:0000658'),
	('R_PVStep', 'SBO:0000658'),
	('R_RSVATPtu', 'SBO:0000657'),
	('R_LSTNM2hr', 'SBO:0000200'),
	('R_LSTNM2tev', 'SBO:0000658'),
	('R_LSTNM4hr', 'SBO:0000217'),
	('R_LSTNM4tev', 'SBO:0000658'),
	('R_RSVtu', 'SBO:0000660'),
	('R_LSTNM5hr', 'SBO:0000200'),
	('R_S3MEACMPtev', 'SBO:0000657'),
	('R_LSTNM5tev', 'SBO:0000658'),
	('R_LSTNM7thc', 'SBO:0000660'),
	('R_SMVtu', 'SBO:0000657'),
	('R_LSTNRATt', 'SBO:0000660'),
	('R_3DHLCAS', 'SBO:0000200'),
	('R_SMVtv', 'SBO:0000658'),
	('R_SULPACMPtev', 'SBO:0000657'),
	('R_THRFVStev', 'SBO:0000658'),
	('R_TLACFVStev', 'SBO:0000658'),
	('R_TMDM1OATt', 'SBO:0000660'),
	('R_TMDM1hr', 'SBO:0000200'),
	('R_TMDM3OATt', 'SBO:0000660'),
	('R_LVSTACOXD6MEhep', 'SBO:0000200'),
	('R_LVSTOXD3Hhep', 'SBO:0000200'),
	('R_LVSTOXD6Hhep', 'SBO:0000200'),
	('R_MDZtu', 'SBO:0000657'),
	('R_MERACMPthc', 'SBO:0000657'),
	('R_MHGLZhr', 'SBO:0000200'),
	('R_NDERSVhc', 'SBO:0000200'),
	('R_TMDM5OATt', 'SBO:0000660'),
	('R_TMDOATtev', 'SBO:0000660'),
	('R_TMDtd', 'SBO:0000658'),
	('R_TRIPVShc', 'SBO:0000200'),
	('R_TRIPVSteb', 'SBO:0000657'),
	('R_TSACGLUCtev', 'SBO:0000657'),
	('R_NFDNPYtep', 'SBO:0000658'),
	('R_NFDOHtep', 'SBO:0000658'),
	('R_NFDOXDhc', 'SBO:0000200'),
	('R_NFDtd', 'SBO:0000658'),
	('R_13HTACRitr', 'SBO:0000658'),
	('R_6AHGLZitr', 'SBO:0000658'),
	('R_OXYPR1tehv', 'SBO:0000658'),
	('R_PROFVStev', 'SBO:0000658'),
	('R_PTVSTATPtu', 'SBO:0000657'),
	('R_PTVSTM13hr', 'SBO:0000200'),
	('R_PTVSTtep', 'SBO:0000658'),
	('R_PVSGLUCtev', 'SBO:0000658'),
	('R_H2O2ter', 'SBO:0000658'),
	('R_1HIBUP_Sitr', 'SBO:0000658'),
	('R_2HIBUP_Sitr', 'SBO:0000658'),
	('R_2HIBUPGLUC_Sitr', 'SBO:0000658'),
	('R_PAPSitr', 'SBO:0000658'),
	('R_6BHGLZGLCitr', 'SBO:0000658'),
	('R_SMVitr', 'SBO:0000658'),
	('R_6BHGLZitr', 'SBO:0000658'),
	('R_3HIBUPGLUC_Sitr', 'SBO:0000658'),
	('R_3HPVSitr', 'SBO:0000658'),
	('R_3HPVSTETCOAitm', 'SBO:0000658'),
	('R_3HPVSTETCOAitx', 'SBO:0000658'),
	('R_7BHGLZitr', 'SBO:0000658'),
	('R_MHGLZitr', 'SBO:0000658'),
	('R_3ISPVSitr', 'SBO:0000658'),
	('R_3HIBUP_Sitr', 'SBO:0000658'),
	('R_6CSMVitr', 'SBO:0000658'),
	('R_FVSitr', 'SBO:0000658'),
	('R_3MEACMPitr', 'SBO:0000658'),
	('R_3OHACMPitr', 'SBO:0000658'),
	('R_AM9CSAitr', 'SBO:0000658'),
	('R_4HATVACIDitr', 'SBO:0000658'),
	('R_6HLVSTitr', 'SBO:0000658'),
	('R_4OHMDZitr', 'SBO:0000658'),
	('R_2HATVACIDitr', 'SBO:0000658'),
	('R_EX_caproic_e', 'SBO:0000627'),
	('R_56EPPVSitr', 'SBO:0000658'),
	('R_6HLVSTACIDitr', 'SBO:0000658'),
	('R_1A25HVITD2t', 'SBO:0000658'),
	('R_EX_1a25dhvitd2_e', 'SBO:0000627'),
	('R_6HMSMVitr', 'SBO:0000658'),
	('R_EX_M00234_e', 'SBO:0000627'),
	('R_EX_M01807_e', 'SBO:0000627'),
	('R_6MELVACIDitr', 'SBO:0000658'),
	('R_EX_M00503_e', 'SBO:0000627'),
	('R_EX_M02837_e', 'SBO:0000627'),
	('R_EX_M01820_e', 'SBO:0000627'),
	('R_6MELVSTitr', 'SBO:0000658'),
	('R_EX_M00510_e', 'SBO:0000627'),
	('R_EX_M00008_e', 'SBO:0000627'),
	('R_EX_gpi_sig_e', 'SBO:0000627'),
	('R_EX_kdn_e', 'SBO:0000627'),
	('R_EX_m3gacpail_prot_hs_e', 'SBO:0000627'),
	('R_EX_dolichol__L_e', 'SBO:0000627'),
	('R_SK_his__L_c', 'SBO:0000632'),
	('R_SK_lys__L_c', 'SBO:0000632'),
	('R_EX_M00019_e', 'SBO:0000627'),
	('R_EX_M00115_e', 'SBO:0000627'),
	('R_EX_M00117_e', 'SBO:0000627'),
	('R_EX_M00315_e', 'SBO:0000627'),
	('R_EX_M00341_e', 'SBO:0000627'),
	('R_EX_M01197_e', 'SBO:0000627'),
	('R_EX_M01235_e', 'SBO:0000627'),
	('R_SK_thr__L_c', 'SBO:0000632'),
	('R_SK_val__L_c', 'SBO:0000632'),
	('R_SK_ala__L_c', 'SBO:0000632'),
	('R_EX_M01238_e', 'SBO:0000627'),
	('R_SK_arg__L_c', 'SBO:0000632'),
	('R_6OHFVSitr', 'SBO:0000658'),
	('R_SK_asn__L_c', 'SBO:0000632'),
	('R_SK_pro__L_c', 'SBO:0000632'),
	('R_EX_M01582_e', 'SBO:0000627'),
	('R_EX_M02053_e', 'SBO:0000627'),
	('R_EX_M02457_e', 'SBO:0000627'),
	('R_EX_M02745_e', 'SBO:0000627'),
	('R_SK_tyr__L_c', 'SBO:0000632'),
	('R_DM_CE5026_c', 'SBO:0000628'),
	('R_DM_CE1562_c', 'SBO:0000628'),
	('R_7AHGLZitr', 'SBO:0000658'),
	('R_DM_ind56qn_c', 'SBO:0000628'),
	('R_DM_CE5025_c', 'SBO:0000628'),
	('R_DM_CE4888_c', 'SBO:0000628'),
	('R_7BHGLZGLCitr', 'SBO:0000658'),
	('R_DM_4abut_c', 'SBO:0000628'),
	('R_DM_srtn_c', 'SBO:0000628'),
	('R_DM_adrnl_c', 'SBO:0000628'),
	('R_EX_M02560_e', 'SBO:0000627'),
	('R_EX_C01601_e', 'SBO:0000627'),
	('R_EX_M02108_e', 'SBO:0000627'),
	('R_DM_nrpphr_c', 'SBO:0000628'),
	('R_EX_M03134_e', 'SBO:0000627'),
	('R_DM_tym_c', 'SBO:0000628'),
	('R_DM_Lkynr_c', 'SBO:0000628'),
	('R_EX_M01111_e', 'SBO:0000627'),
	('R_EX_h2co3_e', 'SBO:0000627'),
	('R_EX_M01870_e', 'SBO:0000627'),
	('R_EX_ditp_e', 'SBO:0000627'),
	('R_EX_M02446_e', 'SBO:0000627'),
	('R_EX_M02447_e', 'SBO:0000627'),
	('R_EX_itacon_e', 'SBO:0000627'),
	('R_7HPVSitr', 'SBO:0000658'),
	('R_ACMPitr', 'SBO:0000658'),
	('R_AM19CSitr', 'SBO:0000658'),
	('R_AM1ACSitr', 'SBO:0000658'),
	('R_AM1ALCSitr', 'SBO:0000658'),
	('R_AM1CGLCitr', 'SBO:0000658'),
	('R_CARIBUPGLU_Sitr', 'SBO:0000658'),
	('R_CRVSM22itr', 'SBO:0000658'),
	('R_CSAitr', 'SBO:0000658'),
	('R_DEOXFVSitx', 'SBO:0000658'),
	('R_FVSitx', 'SBO:0000658'),
	('R_GLC3MEACPitr', 'SBO:0000658'),
	('R_GLZitr', 'SBO:0000658'),
	('R_GTACMPitr', 'SBO:0000658'),
	('R_IBUP_Ritr', 'SBO:0000658'),
	('R_IBUP_Sitr', 'SBO:0000658'),
	('R_LSTN1GLUCitr', 'SBO:0000658'),
	('R_LSTNM1itr', 'SBO:0000658'),
	('R_LSTNM2itr', 'SBO:0000658'),
	('R_LSTNM5itr', 'SBO:0000658'),
	('R_LSTNM7itr', 'SBO:0000658'),
	('R_MDZitr', 'SBO:0000658'),
	('R_MDZGLCitr', 'SBO:0000658'),
	('R_NDERSVitr', 'SBO:0000658'),
	('R_NFDOHitr', 'SBO:0000658'),
	('R_PTVSTM13itr', 'SBO:0000658'),
	('R_PVSGLUCitr', 'SBO:0000658'),
	('R_TACRitr', 'SBO:0000658'),
	('R_THSACMPitr', 'SBO:0000658'),
	('R_TMACMPitr', 'SBO:0000658'),
	('R_TMDitr', 'SBO:0000658'),
	('R_TMDM3itr', 'SBO:0000658'),
	('R_TSACMGLUCitr', 'SBO:0000658'),
	('R_1OHMDZitr', 'SBO:0000658'),
	('R_COAtg', 'SBO:0000658'),
	('R_3SALACBOXL_cho', 'SBO:0000399'),
	('R_4MPTNLtm', 'SBO:0000658'),
	('R_5HTRPVESSEC_1', 'SBO:0000657'),
	('R_5MTHFt2_1', 'SBO:0000660'),
	('R_ADRNLPVESSEC_1', 'SBO:0000657'),
	('R_CKc_cho', 'SBO:0000216'),
	('R_CLOHtex2_1', 'SBO:0000660'),
	('R_CRTSTRNt', 'SBO:0000658'),
	('R_DAGt', 'SBO:0000658'),
	('R_DASCBR_1', 'SBO:0000200'),
	('R_DESAT18_11', 'SBO:0000200'),
	('R_DM_core7_g', 'SBO:0000628'),
	('R_DM_core8_g', 'SBO:0000628'),
	('R_DM_gncore2_g', 'SBO:0000628'),
	('R_DM_m3gacpail_prot_hs_r', 'SBO:0000628'),
	('R_DM_mem2emgacpail_prot_hs_r', 'SBO:0000628'),
	('R_SK_T_antigen_g', 'SBO:0000632'),
	('R_EX_crtsl_e', 'SBO:0000627'),
	('R_EX_estradiol_e', 'SBO:0000627'),
	('R_EX_leuktrA4_e', 'SBO:0000627'),
	('R_EX_leuktrF4_e', 'SBO:0000627'),
	('R_EX_prgstrn_e', 'SBO:0000627'),
	('R_EX_tststerone_e', 'SBO:0000627'),
	('R_FAH3_1', 'SBO:0000200'),
	('R_FAOXC1811602m_1', 'SBO:0000200'),
	('R_CRNCARtm', 'SBO:0000660'),
	('R_r2434', 'SBO:0000660'),
	('R_CARN160t_m', 'SBO:0000660'),
	('R_CARN1819Zt_m', 'SBO:0000660'),
	('R_r2437', 'SBO:0000660'),
	('R_r2438', 'SBO:0000660'),
	('R_r2447', 'SBO:0000659'),
	('R_r2449', 'SBO:0000659'),
	('R_r2465_1', 'SBO:0000658'),
	('R_r2482', 'SBO:0000660'),
	('R_r2483', 'SBO:0000660'),
	('R_r2485', 'SBO:0000660'),
	('R_r2490', 'SBO:0000660'),
	('R_r2494', 'SBO:0000660'),
	('R_r2495', 'SBO:0000660'),
	('R_r2497', 'SBO:0000657'),
	('R_r2498', 'SBO:0000657'),
	('R_r2499', 'SBO:0000657'),
	('R_r2501', 'SBO:0000657'),
	('R_r2503', 'SBO:0000657'),
	('R_r2507', 'SBO:0000660'),
	('R_r2508', 'SBO:0000660'),
	('R_r2511', 'SBO:0000660'),
	('R_r2513', 'SBO:0000660'),
	('R_r2521', 'SBO:0000660'),
	('R_r2526', 'SBO:0000658'),
	('R_r2535', 'SBO:0000658'),
	('R_r2537', 'SBO:0000658'),
	('R_r2539', 'SBO:0000660'),
	('R_EX_sprm_e', 'SBO:0000627'),
	('R_FACOAE180', 'SBO:0000376'),
	('R_GULND', 'SBO:0000200'),
	('R_RE0512M', 'SBO:0000200'),
	('R_RE1933C', 'SBO:0000376'),
	('R_RE2112C', 'SBO:0000200'),
	('R_RE2147C', 'SBO:0000217'),
	('R_RE2154C', 'SBO:0000200'),
	('R_FAOXC240200x_1', 'SBO:0000200'),
	('R_RE2235C', 'SBO:0000200'),
	('R_RE2235R', 'SBO:0000200'),
	('R_r2343', 'SBO:0000658'),
	('R_r2346', 'SBO:0000658'),
	('R_r2353', 'SBO:0000658'),
	('R_r2356', 'SBO:0000658'),
	('R_r2361', 'SBO:0000658'),
	('R_RE2404C', 'SBO:0000217'),
	('R_RE2407C', 'SBO:0000200'),
	('R_RE2410C', 'SBO:0000200'),
	('R_r2364', 'SBO:0000658'),
	('R_r2365', 'SBO:0000658'),
	('R_r2367', 'SBO:0000658'),
	('R_r2368', 'SBO:0000658'),
	('R_ASCBt5', 'SBO:0000659'),
	('R_r2371', 'SBO:0000660'),
	('R_r2372', 'SBO:0000660'),
	('R_AKGCITtm', 'SBO:0000660'),
	('R_r2376', 'SBO:0000660'),
	('R_RE2625C', 'SBO:0000200'),
	('R_r2378', 'SBO:0000660'),
	('R_r2379', 'SBO:0000660'),
	('R_r2380', 'SBO:0000660'),
	('R_RE2626C', 'SBO:0000200'),
	('R_r2381', 'SBO:0000660'),
	('R_r2386', 'SBO:0000660'),
	('R_RE2636R', 'SBO:0000200'),
	('R_r2389', 'SBO:0000660'),
	('R_r2390', 'SBO:0000660'),
	('R_r2391', 'SBO:0000660'),
	('R_r2392', 'SBO:0000660'),
	('R_r2393', 'SBO:0000657'),
	('R_r2394', 'SBO:0000657'),
	('R_r2395', 'SBO:0000660'),
	('R_r2397', 'SBO:0000660'),
	('R_RE2640C', 'SBO:0000376'),
	('R_RE3185M', 'SBO:0000200'),
	('R_RE3186M', 'SBO:0000200'),
	('R_r2398', 'SBO:0000660'),
	('R_r2401', 'SBO:0000660'),
	('R_r2402', 'SBO:0000660'),
	('R_r2403', 'SBO:0000660'),
	('R_r2406', 'SBO:0000660'),
	('R_r2410', 'SBO:0000660'),
	('R_r2413', 'SBO:0000660'),
	('R_r2416', 'SBO:0000660'),
	('R_RE3198C', 'SBO:0000200'),
	('R_RE3225C', 'SBO:0000399'),
	('R_r2420', 'SBO:0000660'),
	('R_r2425', 'SBO:0000660'),
	('R_RE3226C', 'SBO:0000399'),
	('R_RE3227C', 'SBO:0000200'),
	('R_RE1517X', 'SBO:0000200'),
	('R_RE1518M', 'SBO:0000200'),
	('R_RE3229C', 'SBO:0000200'),
	('R_RE3230C', 'SBO:0000200'),
	('R_RE3242C', 'SBO:0000200'),
	('R_RE1525M', 'SBO:0000200'),
	('R_RE1525X', 'SBO:0000200'),
	('R_RE3244C', 'SBO:0000200'),
	('R_RE3259C', 'SBO:0000376'),
	('R_RE1711C', 'SBO:0000200'),
	('R_RE3346C', 'SBO:0000200'),
	('R_FADRx', 'SBO:0000200'),
	('R_RE1796M', 'SBO:0000200'),
	('R_RE1803C', 'SBO:0000200'),
	('R_RE1804C', 'SBO:0000200'),
	('R_RE1807M', 'SBO:0000200'),
	('R_RE3430C_1', 'SBO:0000200'),
	('R_RE3430M', 'SBO:0000200'),
	('R_EX_CE1940_e', 'SBO:0000627'),
	('R_EX_CE1936_e', 'SBO:0000627'),
	('R_EX_maltpt_e', 'SBO:0000627'),
	('R_EX_CE2916_e', 'SBO:0000627'),
	('R_RE1860E', 'SBO:0000376'),
	('R_EX_CE2917_e', 'SBO:0000627'),
	('R_EX_CE2839_e', 'SBO:0000627'),
	('R_RE1897C', 'SBO:0000402'),
	('R_RE1903R', 'SBO:0000200'),
	('R_EX_CE1950_e', 'SBO:0000627'),
	('R_EX_CE5788_e', 'SBO:0000627'),
	('R_EX_CE5789_e', 'SBO:0000627'),
	('R_EX_CE5798_e', 'SBO:0000627'),
	('R_EX_CE5791_e', 'SBO:0000627'),
	('R_EX_CE5867_e', 'SBO:0000627'),
	('R_EX_CE5869_e', 'SBO:0000627'),
	('R_EX_CE4633_e', 'SBO:0000627'),
	('R_EX_CE1926_e', 'SBO:0000627'),
	('R_EX_udpgal_e', 'SBO:0000627'),
	('R_EX_crm_hs_e', 'SBO:0000627'),
	('R_RE2675C_1', 'SBO:0000200'),
	('R_EX_galside_hs_e', 'SBO:0000627'),
	('R_EX_CE0074_e', 'SBO:0000627'),
	('R_EX_12dgr120_e', 'SBO:0000627'),
	('R_EX_C04849_e', 'SBO:0000627'),
	('R_RE2766C', 'SBO:0000200'),
	('R_RE2799C', 'SBO:0000200'),
	('R_RE2814R', 'SBO:0000200'),
	('R_2MB2COAc', 'SBO:0000658'),
	('R_ADPACTD', 'SBO:0000658'),
	('R_RE2987X', 'SBO:0000200'),
	('R_BCRNe', 'SBO:0000658'),
	('R_SK_c101coa_c', 'SBO:0000632'),
	('R_C101CRNe', 'SBO:0000658'),
	('R_C10CRNe', 'SBO:0000658'),
	('R_C10DCCACT', 'SBO:0000658'),
	('R_RE2993X', 'SBO:0000200'),
	('R_RE2996X', 'SBO:0000200'),
	('R_DOCOSADIACTD', 'SBO:0000658'),
	('R_DOCOSDIACTD', 'SBO:0000658'),
	('R_EX_3bcrn_e', 'SBO:0000627'),
	('R_EX_3ddcrn_e', 'SBO:0000627'),
	('R_EX_3deccrn_e', 'SBO:0000627'),
	('R_EX_3hexdcrn_e', 'SBO:0000627'),
	('R_RE3010M', 'SBO:0000200'),
	('R_RE3011M', 'SBO:0000200'),
	('R_RE3012C', 'SBO:0000200'),
	('R_RE3012M', 'SBO:0000200'),
	('R_RE3012R', 'SBO:0000200'),
	('R_EX_3octdec2crn_e', 'SBO:0000627'),
	('R_EX_3octdeccrn_e', 'SBO:0000627'),
	('R_EX_3octdece1crn_e', 'SBO:0000627'),
	('R_EX_3tdcrn_e', 'SBO:0000627'),
	('R_EX_3tetd7ecoacrn_e', 'SBO:0000627'),
	('R_EX_3ttetddcoacrn_e', 'SBO:0000627'),
	('R_EX_c16dc_e', 'SBO:0000627'),
	('R_EX_c4crn_e', 'SBO:0000627'),
	('R_RE3015R', 'SBO:0000200'),
	('R_RE3432M', 'SBO:0000200'),
	('R_RE3432X', 'SBO:0000200'),
	('R_RE3435C', 'SBO:0000200'),
	('R_RE3470C', 'SBO:0000200'),
	('R_RE3470M', 'SBO:0000200'),
	('R_EX_c51crn_e', 'SBO:0000627'),
	('R_EX_c6dc_e', 'SBO:0000627'),
	('R_EX_c81crn_e', 'SBO:0000627'),
	('R_EX_c8dc_e', 'SBO:0000627'),
	('R_EX_ddece1crn_e', 'SBO:0000627'),
	('R_EX_ddeccrn_e', 'SBO:0000627'),
	('R_EX_doco13ac_e', 'SBO:0000627'),
	('R_EX_ivcrn_e', 'SBO:0000627'),
	('R_RE3556C', 'SBO:0000377'),
	('R_EX_tetdec2crn_e', 'SBO:0000627'),
	('R_EX_tetdece1crn_e', 'SBO:0000627'),
	('R_FAOXC101C102m', 'SBO:0000200'),
	('R_EX_prostgi2_e', 'SBO:0000627'),
	('R_FAOXC101C8m', 'SBO:0000200'),
	('R_FAOXC102C101x', 'SBO:0000200'),
	('R_FAOXC102C103m', 'SBO:0000200'),
	('R_FAOXC10DCC8DCx', 'SBO:0000200'),
	('R_FAOXC11BRC9BRx', 'SBO:0000200'),
	('R_FAOXC11C9m', 'SBO:0000200'),
	('R_FAOXC121C10x', 'SBO:0000200'),
	('R_EX_cdp_e', 'SBO:0000627'),
	('R_EX_dtdp_e', 'SBO:0000627'),
	('R_EX_HC00955_e', 'SBO:0000627'),
	('R_EX_HC00004_e', 'SBO:0000627'),
	('R_EX_C02470_e', 'SBO:0000627'),
	('R_FAOXC122C101m', 'SBO:0000200'),
	('R_EX_HC02193_e', 'SBO:0000627'),
	('R_EX_HC02196_e', 'SBO:0000627'),
	('R_EX_HC02220_e', 'SBO:0000627'),
	('R_STRDNCCOAtxc', 'SBO:0000657'),
	('R_EX_HC02194_e', 'SBO:0000627'),
	('R_EX_HC02197_e', 'SBO:0000627'),
	('R_EX_HC02187_e', 'SBO:0000627'),
	('R_EX_HC02180_e', 'SBO:0000627'),
	('R_SUBEACTD', 'SBO:0000658'),
	('R_SUBERCACT', 'SBO:0000658'),
	('R_SUCCOAPET', 'SBO:0000376'),
	('R_TETDEC2CRNe', 'SBO:0000658'),
	('R_ALAATB0tc', 'SBO:0000659'),
	('R_ASCBSVCTtc', 'SBO:0000657'),
	('R_BALABETAtc', 'SBO:0000659'),
	('R_CYSATB0tc', 'SBO:0000659'),
	('R_EX_HC02202_e', 'SBO:0000627'),
	('R_EX_malcoa_e', 'SBO:0000627'),
	('R_C141ACBP', 'SBO:0000658'),
	('R_C142ACBP', 'SBO:0000658'),
	('R_C142OHe', 'SBO:0000658'),
	('R_C162OHe', 'SBO:0000658'),
	('R_C16DCe', 'SBO:0000658'),
	('R_FA160COAabcp_1', 'SBO:0000657'),
	('R_CYSTALArBATtc', 'SBO:0000660'),
	('R_FOLt', 'SBO:0000659'),
	('R_GLCSGLT1le', 'SBO:0000657'),
	('R_GLNyLATthc', 'SBO:0000660'),
	('R_GLYGLYPEPT1tc', 'SBO:0000658'),
	('R_GLYPROPEPT1tc', 'SBO:0000659'),
	('R_C6CRNe', 'SBO:0000658'),
	('R_GLYSARPEPT1tc', 'SBO:0000659'),
	('R_GLYSNAT5tc', 'SBO:0000660'),
	('R_HISyLATthc', 'SBO:0000660'),
	('R_ILEATB0tc', 'SBO:0000659'),
	('R_LEUyLAThtc', 'SBO:0000660'),
	('R_LYSATB0tc', 'SBO:0000659'),
	('R_METyLATthc', 'SBO:0000660'),
	('R_OCDEAFABP1tc', 'SBO:0000658'),
	('R_EX_gltcho_e', 'SBO:0000627'),
	('R_C6CRNtcx', 'SBO:0000658'),
	('R_C6DCe', 'SBO:0000658'),
	('R_SK_c81coa_c', 'SBO:0000632'),
	('R_C8CRNe', 'SBO:0000658'),
	('R_EX_glygly_e', 'SBO:0000627'),
	('R_EX_gum_e', 'SBO:0000627'),
	('R_EX_gumdchac_e', 'SBO:0000627'),
	('R_EX_gumgchol_e', 'SBO:0000627'),
	('R_EX_pectindchac_e', 'SBO:0000627'),
	('R_C8DCe', 'SBO:0000658'),
	('R_C9BRxtc', 'SBO:0000658'),
	('R_EX_psyltdechol_e', 'SBO:0000627'),
	('R_EX_tdechola_e', 'SBO:0000627'),
	('R_EX_cysam_e', 'SBO:0000627'),
	('R_EX_dpcoa_e', 'SBO:0000627'),
	('R_DCATDc', 'SBO:0000658'),
	('R_DCATDr', 'SBO:0000658'),
	('R_DCSPTN1COAtxc', 'SBO:0000657'),
	('R_DDECCRNe', 'SBO:0000658'),
	('R_DDECE1CRNe', 'SBO:0000658'),
	('R_DECCRNe', 'SBO:0000658'),
	('R_EX_fmn_e', 'SBO:0000627'),
	('R_EX_hyptaur_e', 'SBO:0000627'),
	('R_EX_q10_e', 'SBO:0000627'),
	('R_DECDICRNe', 'SBO:0000658'),
	('R_DOCO13ECOAtxc', 'SBO:0000657'),
	('R_FAOXC160140x', 'SBO:0000200'),
	('R_FAOXC181C161m', 'SBO:0000200'),
	('R_FAOXC181C161x', 'SBO:0000200'),
	('R_FADH2ETC', 'SBO:0000200'),
	('R_FE3t', 'SBO:0000658'),
	('R_GLUPROASCT1', 'SBO:0000660'),
	('R_FAOXC182C182OHm', 'SBO:0000200'),
	('R_FAOXC183C163Gm', 'SBO:0000200'),
	('R_FAOXC184C163m', 'SBO:0000200'),
	('R_LEUGLYHYc', 'SBO:0000376'),
	('R_FAOXC184C164x', 'SBO:0000200'),
	('R_FAOXC201C181x', 'SBO:0000200'),
	('R_FAOXC204C184m', 'SBO:0000200'),
	('R_FAOXC205C184x', 'SBO:0000200'),
	('R_FAOXC205C185m', 'SBO:0000200'),
	('R_PAN4PPe', 'SBO:0000376'),
	('R_PTRCtex2', 'SBO:0000658'),
	('R_FAOXC225C204x', 'SBO:0000200'),
	('R_FAOXC226C205m', 'SBO:0000200'),
	('R_TRPB0AT3tc', 'SBO:0000659'),
	('R_FAOXC226C225x', 'SBO:0000200'),
	('R_FAOXC226C227m', 'SBO:0000200'),
	('R_FAOXC22C20x', 'SBO:0000200'),
	('R_FAOXC241C221x', 'SBO:0000200'),
	('R_FAOXC24C22x', 'SBO:0000200'),
	('R_RIBFLVt3o', 'SBO:0000657'),
	('R_FAOXC5C3x', 'SBO:0000200'),
	('R_FAOXC61C4m', 'SBO:0000200'),
	('R_FAOXC61C4x', 'SBO:0000200'),
	('R_FAOXC6C4m', 'SBO:0000200'),
	('R_FAOXC7C5m', 'SBO:0000200'),
	('R_FAOXC81C61x', 'SBO:0000200'),
	('R_r0963', 'SBO:0000658'),
	('R_LNELDCCRNte', 'SBO:0000659'),
	('R_ODECRNte', 'SBO:0000659'),
	('R_PMTCRNte', 'SBO:0000659'),
	('R_HDCECRNte', 'SBO:0000659'),
	('R_EX_argsuc_e', 'SBO:0000627'),
	('R_EX_stcrn_e', 'SBO:0000627'),
	('R_EX_hdcecrn_e', 'SBO:0000627'),
	('R_HC00342te', 'SBO:0000659'),
	('R_PHLAC', 'SBO:0000200'),
	('R_FAOXC8C6x', 'SBO:0000200'),
	('R_FAOXMC10OHMC10r', 'SBO:0000200'),
	('R_FAOXTC101TC102m', 'SBO:0000200'),
	('R_FAOXTC102C101m', 'SBO:0000200'),
	('R_FAOXTC122TC101m', 'SBO:0000200'),
	('R_C14825c', 'SBO:0000200'),
	('R_FAOXTC142TC122m', 'SBO:0000200'),
	('R_GLUTCOAACBP', 'SBO:0000658'),
	('R_HDDACBP', 'SBO:0000658'),
	('R_HDECAACBP', 'SBO:0000658'),
	('R_HDECEACBP', 'SBO:0000658'),
	('R_HEDCECRNe', 'SBO:0000658'),
	('R_HEXCOAACBP', 'SBO:0000658'),
	('R_HEXDCRNe', 'SBO:0000658'),
	('R_HEXDICOAACBP', 'SBO:0000658'),
	('R_HOCDACBP', 'SBO:0000658'),
	('R_HOCTDACBP', 'SBO:0000658'),
	('R_HOCTDEC2CRNe', 'SBO:0000658'),
	('R_HOCTDECCRNe', 'SBO:0000658'),
	('R_OCD11CRNCACT', 'SBO:0000658'),
	('R_OCTDEC2ACBP', 'SBO:0000658'),
	('R_OCTDECCACT', 'SBO:0000658'),
	('R_OMHDOCOSACTD', 'SBO:0000658'),
	('R_OMHPALTD', 'SBO:0000658'),
	('R_PRISTCOAtcx', 'SBO:0000657'),
	('R_SEBACIDTD', 'SBO:0000658'),
	('R_PALFATPtc', 'SBO:0000657'),
	('R_METDECARc', 'SBO:0000399'),
	('R_3MTPte', 'SBO:0000658'),
	('R_TTDCRNNAt', 'SBO:0000659'),
	('R_PCHOLHSTDe_1', 'SBO:0000658'),
	('R_PEHSFABPe', 'SBO:0000658'),
	('R_PMTCOAFABP1tc_1', 'SBO:0000658'),
	('R_PNTOte', 'SBO:0000658'),
	('R_PROGLYPEPT1tc', 'SBO:0000659'),
	('R_SBT_Dt', 'SBO:0000658'),
	('R_SERATB0tc', 'SBO:0000659'),
	('R_TAUBETAtc', 'SBO:0000659'),
	('R_TAUPAT1c', 'SBO:0000659'),
	('R_THRATB0tc', 'SBO:0000659'),
	('R_VITKtl', 'SBO:0000658'),
	('R_1a25DHVITD3TRn', 'SBO:0000658'),
	('R_25HVITD3c', 'SBO:0000200'),
	('R_15KPROSTGF2t', 'SBO:0000660'),
	('R_21HPRGNLONEt2', 'SBO:0000658'),
	('R_34HPLte', 'SBO:0000659'),
	('R_3HMPtd', 'SBO:0000658'),
	('R_3HPPPNOHc', 'SBO:0000200'),
	('R_3MHISt3', 'SBO:0000660'),
	('R_4AABUTNt', 'SBO:0000658'),
	('R_4TMEABUTNt1', 'SBO:0000659'),
	('R_4TMEABUTNt2', 'SBO:0000659'),
	('R_ADNK3', 'SBO:0000216'),
	('R_ADNK4', 'SBO:0000216'),
	('R_56DTHMtd', 'SBO:0000658'),
	('R_AMETtm', 'SBO:0000658'),
	('R_ARACHFATPc', 'SBO:0000657'),
	('R_ASPte', 'SBO:0000658'),
	('R_BIDGLCURr', 'SBO:0000217'),
	('R_56DURAt', 'SBO:0000659'),
	('R_5AOPt', 'SBO:0000659'),
	('R_5HPETATP', 'SBO:0000657'),
	('R_5HPETtd', 'SBO:0000658'),
	('R_7DHCHSTEROLt', 'SBO:0000657'),
	('R_ABT_Dt', 'SBO:0000658'),
	('R_ABTpp2', 'SBO:0000659'),
	('R_ABTD1', 'SBO:0000200'),
	('R_ACGLYtc', 'SBO:0000658'),
	('R_ACLYSt', 'SBO:0000658'),
	('R_ACLYStm', 'SBO:0000658'),
	('R_ADPACtd', 'SBO:0000658'),
	('R_CYSAMOe', 'SBO:0000200'),
	('R_DATPtm_cho', 'SBO:0000658'),
	('R_DHAPtm', 'SBO:0000658'),
	('R_DM_1a25dhvitd3_n', 'SBO:0000628'),
	('R_DM_4abut_n', 'SBO:0000628'),
	('R_DM_5HPET_r', 'SBO:0000628'),
	('R_DM_pe_hs_r', 'SBO:0000628'),
	('R_DPCOAPPe', 'SBO:0000376'),
	('R_ADPOHt', 'SBO:0000658'),
	('R_ALLTNti', 'SBO:0000658'),
	('R_AMETt', 'SBO:0000658'),
	('R_EX_7dhchsterol_e', 'SBO:0000627'),
	('R_EX_acgly_e', 'SBO:0000627'),
	('R_EX_aclys_e', 'SBO:0000627'),
	('R_EX_acorn_e', 'SBO:0000627'),
	('R_TTDCAFATPc', 'SBO:0000657'),
	('R_q10tm', 'SBO:0000658'),
	('R_4MOPte', 'SBO:0000658'),
	('R_AHCYSte', 'SBO:0000658'),
	('R_DM_anth_c', 'SBO:0000628'),
	('R_DM_fol_c', 'SBO:0000628'),
	('R_DM_pnto__R_c', 'SBO:0000628'),
	('R_EX_4mop_e', 'SBO:0000627'),
	('R_EX_5mta_e', 'SBO:0000627'),
	('R_EX_adpac_e', 'SBO:0000627'),
	('R_EX_biliverd_e', 'SBO:0000627'),
	('R_EX_C04805_e', 'SBO:0000627'),
	('R_EX_C06315_e', 'SBO:0000627'),
	('R_EX_C11695_e', 'SBO:0000627'),
	('R_EX_C14768_e', 'SBO:0000627'),
	('R_EX_C14770_e', 'SBO:0000627'),
	('R_EX_C14825_e', 'SBO:0000627'),
	('R_EX_C14826_e', 'SBO:0000627'),
	('R_EX_CE0955_e', 'SBO:0000627'),
	('R_EX_5oxpro_e', 'SBO:0000627'),
	('R_EX_cbasp_e', 'SBO:0000627'),
	('R_OROTGLUt', 'SBO:0000660'),
	('R_GLYALDtr', 'SBO:0000659'),
	('R_LKYNRtr2', 'SBO:0000660'),
	('R_LKYNRtr3', 'SBO:0000660'),
	('R_BALAPAT1tc2', 'SBO:0000659'),
	('R_BALABETAtc2', 'SBO:0000659'),
	('R_CRTNtr', 'SBO:0000658'),
	('R_EX_CE1556_e', 'SBO:0000627'),
	('R_EX_CE2028_e', 'SBO:0000627'),
	('R_EX_CE2445_e', 'SBO:0000627'),
	('R_EX_CE2537_e', 'SBO:0000627'),
	('R_EX_CE5304_e', 'SBO:0000627'),
	('R_EX_CE6247_e', 'SBO:0000627'),
	('R_EX_CE7172_e', 'SBO:0000627'),
	('R_KYNATEtr', 'SBO:0000660'),
	('R_QULNtr', 'SBO:0000660'),
	('R_2PGtr', 'SBO:0000658'),
	('R_CARNtr', 'SBO:0000658'),
	('R_CHOLPtr', 'SBO:0000658'),
	('R_CYST_Ltr', 'SBO:0000658'),
	('R_DCMPtr', 'SBO:0000658'),
	('R_DHAPtr', 'SBO:0000658'),
	('R_ICITtr', 'SBO:0000658'),
	('R_EX_cortsn_e', 'SBO:0000627'),
	('R_EX_didecaeth_e', 'SBO:0000627'),
	('R_EX_diholineth_e', 'SBO:0000627'),
	('R_EX_docteteth_e', 'SBO:0000627'),
	('R_EX_dodecanac_e', 'SBO:0000627'),
	('R_EX_forglu_e', 'SBO:0000627'),
	('R_EX_hepdeceth_e', 'SBO:0000627'),
	('R_EX_hexdeceeth_e', 'SBO:0000627'),
	('R_EX_hmcarn_e', 'SBO:0000627'),
	('R_EX_hmcr_e', 'SBO:0000627'),
	('R_L2AADPtr', 'SBO:0000658'),
	('R_XMPtr', 'SBO:0000658'),
	('R_XTSNtr', 'SBO:0000658'),
	('R_UDPGLCURtr', 'SBO:0000658'),
	('R_IMPtr', 'SBO:0000658'),
	('R_EX_hxcoa_e', 'SBO:0000627'),
	('R_EX_leuktrB4woh_e', 'SBO:0000627'),
	('R_EX_magarachi_hs_e', 'SBO:0000627'),
	('R_EX_magole_hs_e', 'SBO:0000627'),
	('R_EX_magpalm_hs_e', 'SBO:0000627'),
	('R_NICRNtr', 'SBO:0000658'),
	('R_OROT5Ptr', 'SBO:0000658'),
	('R_EX_mi1p__D_e', 'SBO:0000627'),
	('R_EX_Nacasp_e', 'SBO:0000627'),
	('R_EX_nwharg_e', 'SBO:0000627'),
	('R_EX_oleth_e', 'SBO:0000627'),
	('R_EX_pailar_hs_e', 'SBO:0000627'),
	('R_EX_pchol2ste_hs_e', 'SBO:0000627'),
	('R_GLYC_Rt', 'SBO:0000658'),
	('R_HC00319t1', 'SBO:0000660'),
	('R_HC02149td', 'SBO:0000658'),
	('R_HEXDIACtd', 'SBO:0000658'),
	('R_HMCARNt', 'SBO:0000660'),
	('R_HPPPNt2r', 'SBO:0000659'),
	('R_HXCOAte', 'SBO:0000658'),
	('R_HXCOAtx', 'SBO:0000658'),
	('R_IND3ACt', 'SBO:0000658'),
	('R_LPIPECOLtx', 'SBO:0000659'),
	('R_LTHSTRLt', 'SBO:0000658'),
	('R_MEV_Rt', 'SBO:0000658'),
	('R_NACASPt', 'SBO:0000659'),
	('R_OAAt_1', 'SBO:0000659'),
	('R_pac', 'SBO:0000658'),
	('R_PCOLLG5HLYStd', 'SBO:0000658'),
	('R_EX_4tmeabutn_e', 'SBO:0000627'),
	('R_SACCRP_Lte', 'SBO:0000658'),
	('R_SACCRP_Ltm', 'SBO:0000658'),
	('R_SEBACIDtd', 'SBO:0000658'),
	('R_SUBEACtd', 'SBO:0000658'),
	('R_TETDECA511ACtd', 'SBO:0000658'),
	('R_THRNTt', 'SBO:0000657'),
	('R_TMLYStd', 'SBO:0000658'),
	('R_TTDCEAATP', 'SBO:0000657'),
	('R_C03990ATP', 'SBO:0000657'),
	('R_C03990t', 'SBO:0000659'),
	('R_C04483t1', 'SBO:0000657'),
	('R_C04717td', 'SBO:0000658'),
	('R_C04805ATP', 'SBO:0000657'),
	('R_C05953tm', 'SBO:0000658'),
	('R_C05957t', 'SBO:0000660'),
	('R_C05957td', 'SBO:0000658'),
	('R_C06315t', 'SBO:0000659'),
	('R_URCANt', 'SBO:0000658'),
	('R_WHARACHDt', 'SBO:0000657'),
	('R_WHARACHDtr', 'SBO:0000660'),
	('R_ACILEte', 'SBO:0000658'),
	('R_EX_acile__L_e', 'SBO:0000627'),
	('R_ACLEUte', 'SBO:0000658'),
	('R_EX_hisasp_e', 'SBO:0000627'),
	('R_EX_hisglnala_e', 'SBO:0000627'),
	('R_EX_hisglylys_e', 'SBO:0000627'),
	('R_C14768ATP', 'SBO:0000657'),
	('R_C14769td1', 'SBO:0000658'),
	('R_C14769td2', 'SBO:0000657'),
	('R_C14771ATP', 'SBO:0000657'),
	('R_C14825ATP', 'SBO:0000657'),
	('R_C14825td', 'SBO:0000658'),
	('R_C14826td', 'SBO:0000658'),
	('R_CE0955te', 'SBO:0000660'),
	('R_CE0955tr', 'SBO:0000658'),
	('R_CE1273t1', 'SBO:0000657'),
	('R_CE1273t2', 'SBO:0000660'),
	('R_EX_hishislys_e', 'SBO:0000627'),
	('R_EX_hislysile_e', 'SBO:0000627'),
	('R_EX_hismet_e', 'SBO:0000627'),
	('R_EX_ileasnhis_e', 'SBO:0000627'),
	('R_EX_ileglnglu_e', 'SBO:0000627'),
	('R_EX_ileglyarg_e', 'SBO:0000627'),
	('R_EX_ileserarg_e', 'SBO:0000627'),
	('R_EX_iletrptyr_e', 'SBO:0000627'),
	('R_CE1297t', 'SBO:0000657'),
	('R_CE1297td', 'SBO:0000658'),
	('R_CE2176t', 'SBO:0000660'),
	('R_CE2445t', 'SBO:0000657'),
	('R_CE2510t', 'SBO:0000657'),
	('R_CE2513ATP', 'SBO:0000657'),
	('R_CE2537ATP', 'SBO:0000657'),
	('R_CE4843t', 'SBO:0000657'),
	('R_EX_leualaarg_e', 'SBO:0000627'),
	('R_EX_leupro_e', 'SBO:0000627'),
	('R_EX_leutrparg_e', 'SBO:0000627'),
	('R_EX_leutyrtyr_e', 'SBO:0000627'),
	('R_EX_lysgluglu_e', 'SBO:0000627'),
	('R_EX_lyslyslys_e', 'SBO:0000627'),
	('R_EX_lyspheile_e', 'SBO:0000627'),
	('R_EX_lystyrile_e', 'SBO:0000627'),
	('R_EX_lysvaltrp_e', 'SBO:0000627'),
	('R_EX_metargleu_e', 'SBO:0000627'),
	('R_CE5304t', 'SBO:0000660'),
	('R_CE6031t', 'SBO:0000658'),
	('R_CE7082ATP', 'SBO:0000657'),
	('R_CORTSNt', 'SBO:0000658'),
	('R_CORTSNti', 'SBO:0000658'),
	('R_EX_12HPET_e', 'SBO:0000627'),
	('R_EX_2oxoadp_e', 'SBO:0000627'),
	('R_EX_34hpl_e', 'SBO:0000627'),
	('R_EX_3hpp_e', 'SBO:0000627'),
	('R_EX_3hpppnohgluc_e', 'SBO:0000627'),
	('R_EX_metasntyr_e', 'SBO:0000627'),
	('R_EX_metglyarg_e', 'SBO:0000627'),
	('R_EX_methislys_e', 'SBO:0000627'),
	('R_EX_metmetile_e', 'SBO:0000627'),
	('R_EX_mettrpphe_e', 'SBO:0000627'),
	('R_EX_pheglnphe_e', 'SBO:0000627'),
	('R_EX_pheleu_e', 'SBO:0000627'),
	('R_EX_phelysala_e', 'SBO:0000627'),
	('R_EX_3uib_e', 'SBO:0000627'),
	('R_EX_4aabutn_e', 'SBO:0000627'),
	('R_EX_pcholdoc_hs_e', 'SBO:0000627'),
	('R_EX_pcholeic_hs_e', 'SBO:0000627'),
	('R_EX_pcholhep_hs_e', 'SBO:0000627'),
	('R_EX_phephe_e', 'SBO:0000627'),
	('R_EX_phepheasn_e', 'SBO:0000627'),
	('R_EX_phethrlys_e', 'SBO:0000627'),
	('R_EX_phetrpleu_e', 'SBO:0000627'),
	('R_EX_pchollinl_hs_e', 'SBO:0000627'),
	('R_EX_pcholmyr_hs_e', 'SBO:0000627'),
	('R_EX_pcholn15_hs_e', 'SBO:0000627'),
	('R_EX_pcholn183_hs_e', 'SBO:0000627'),
	('R_EX_pcholn1836_hs_e', 'SBO:0000627'),
	('R_EX_pcholn19_hs_e', 'SBO:0000627'),
	('R_EX_pcholn203_hs_e', 'SBO:0000627'),
	('R_EX_pcholn204_hs_e', 'SBO:0000627'),
	('R_EX_pcholn224_hs_e', 'SBO:0000627'),
	('R_EX_phetyr_e', 'SBO:0000627'),
	('R_EX_proargasp_e', 'SBO:0000627'),
	('R_EX_procys_e', 'SBO:0000627'),
	('R_EX_proglulys_e', 'SBO:0000627'),
	('R_ALAARGGLYt', 'SBO:0000659'),
	('R_ALAASNLEUt', 'SBO:0000659'),
	('R_ALAHISALAt', 'SBO:0000659'),
	('R_ARGCYSGLYt', 'SBO:0000659'),
	('R_ARGGLUGLUt', 'SBO:0000659'),
	('R_ARGGLYGLYt', 'SBO:0000659'),
	('R_ARGLEUPHEt', 'SBO:0000659'),
	('R_ARGLYSASPt', 'SBO:0000659'),
	('R_ARGPHEARGt', 'SBO:0000659'),
	('R_EX_pcholn225_hs_e', 'SBO:0000627'),
	('R_EX_pcholn2254_hs_e', 'SBO:0000627'),
	('R_EX_pcholn28_hs_e', 'SBO:0000627'),
	('R_EX_pcholn281_hs_e', 'SBO:0000627'),
	('R_EX_pcholole_hs_e', 'SBO:0000627'),
	('R_EX_pcholpalme_hs_e', 'SBO:0000627'),
	('R_EX_pcholste_hs_e', 'SBO:0000627'),
	('R_EX_pcollg5hlys_e', 'SBO:0000627'),
	('R_EX_pe12_hs_e', 'SBO:0000627'),
	('R_EX_pe13_hs_e', 'SBO:0000627'),
	('R_ARGSERSERt', 'SBO:0000659'),
	('R_ARGTYRVALt', 'SBO:0000659'),
	('R_ARGVALCYSt', 'SBO:0000659'),
	('R_ARGVALTRPt', 'SBO:0000659'),
	('R_ASNCYSCYSt', 'SBO:0000659'),
	('R_ASNMETPROt', 'SBO:0000659'),
	('R_ASNPHEASPt', 'SBO:0000659'),
	('R_ASNPHECYSt', 'SBO:0000659'),
	('R_ASNTYRGLYt', 'SBO:0000659'),
	('R_ASNTYRPHEt', 'SBO:0000659'),
	('R_ASNTYRTHRt', 'SBO:0000659'),
	('R_ASPGLUt', 'SBO:0000659'),
	('R_CYSCYSt', 'SBO:0000659'),
	('R_CYSGLNMETt', 'SBO:0000659'),
	('R_CYSTYRASNt', 'SBO:0000659'),
	('R_EX_pe17_hs_e', 'SBO:0000627'),
	('R_EX_pe224_hs_e', 'SBO:0000627'),
	('R_EX_pedh203_hs_e', 'SBO:0000627'),
	('R_EX_pelinl_hs_e', 'SBO:0000627'),
	('R_EX_peole_hs_e', 'SBO:0000627'),
	('R_EX_saccrp__L_e', 'SBO:0000627'),
	('R_EX_sphmyln181161_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18117_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18118_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln181201_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln18123_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln1824_hs_e', 'SBO:0000627'),
	('R_EX_sphmyln1825_hs_e', 'SBO:0000627'),
	('R_EX_steeth_e', 'SBO:0000627'),
	('R_EX_tetdecaeth_e', 'SBO:0000627'),
	('R_EX_tmlys_e', 'SBO:0000627'),
	('R_EX_trideceth_e', 'SBO:0000627'),
	('R_EX_urcan_e', 'SBO:0000627'),
	('R_EX_xolest183_hs_e', 'SBO:0000627'),
	('R_EX_xolest205_hs_e', 'SBO:0000627'),
	('R_EX_xolest226_hs_e', 'SBO:0000627'),
	('R_GLNASNGLNt', 'SBO:0000659'),
	('R_GLNHISHISt', 'SBO:0000659'),
	('R_LYSCYSHISt', 'SBO:0000659'),
	('R_LYSPHEILEt', 'SBO:0000659'),
	('R_LYSTRPARGt', 'SBO:0000659'),
	('R_LYSVALTRPt', 'SBO:0000659'),
	('R_METASNTYRt', 'SBO:0000659'),
	('R_METHISLYSt', 'SBO:0000659'),
	('R_METMETILEt', 'SBO:0000659'),
	('R_METPHEARGt', 'SBO:0000659'),
	('R_PHEGLNPHEt', 'SBO:0000659'),
	('R_PHEPHEt', 'SBO:0000659'),
	('R_PHEPROARGt', 'SBO:0000659'),
	('R_PHESERTRPt', 'SBO:0000659'),
	('R_PHETRPLEUt', 'SBO:0000659'),
	('R_PHETYRt', 'SBO:0000659'),
	('R_PHETYRLYSt', 'SBO:0000659'),
	('R_PROARGCYSt', 'SBO:0000659'),
	('R_PROCYSt', 'SBO:0000659'),
	('R_PROGLULYSt', 'SBO:0000659'),
	('R_EX_estriol_e', 'SBO:0000627'),
	('R_EX_3hpppn_e', 'SBO:0000627'),
	('R_EX_5aop_e', 'SBO:0000627'),
	('R_EX_abt__D_e', 'SBO:0000627'),
	('R_EX_acglu_e', 'SBO:0000627'),
	('R_EX_CE2510_e', 'SBO:0000627'),
	('R_EX_ddca_e', 'SBO:0000627'),
	('R_EX_glyc__R_e', 'SBO:0000627'),
	('R_EX_Lcyst_e', 'SBO:0000627'),
	('R_EX_pac_e', 'SBO:0000627'),
	('R_3HPPPNOHGLUCc', 'SBO:0000217'),
	('R_HC02194c', 'SBO:0000200'),
	('R_HC02194te', 'SBO:0000657'),
	('R_XOL27OHtmc', 'SBO:0000658'),
	('R_PROPHEt', 'SBO:0000659'),
	('R_PROPROARGt', 'SBO:0000659'),
	('R_PROTRPLYSt', 'SBO:0000659'),
	('R_PROVALGLNt', 'SBO:0000659'),
	('R_SERARGALAt', 'SBO:0000659'),
	('R_SERCYSARGt', 'SBO:0000659'),
	('R_SERGLYGLUt', 'SBO:0000659'),
	('R_VALLEUPHEt', 'SBO:0000659'),
	('R_VALPHEARGt', 'SBO:0000659'),
	('R_VALSERARGt', 'SBO:0000659'),
	('R_VALTRPVALt', 'SBO:0000659'),
	('R_TRPGLYASPt', 'SBO:0000659'),
	('R_PCSsec', 'SBO:0000658'),
	('R_EX_bgly_e', 'SBO:0000627'),
	('R_MEPIt', 'SBO:0000658'),
	('R_TREt', 'SBO:0000658'),
	('R_LEULEUt', 'SBO:0000658'),
	('R_GLYPROt', 'SBO:0000658'),
	('R_PROGLyt', 'SBO:0000658'),
	('R_DHBPTt', 'SBO:0000658'),
	('R_THBPTt', 'SBO:0000658'),
	('R_EX_normete__L_e', 'SBO:0000627'),
	('R_EX_maltttr_e', 'SBO:0000627'),
	('R_EX_thbpt_e', 'SBO:0000627'),
	('R_DM_itp_n', 'SBO:0000628'),
	('R_EX_proleuarg_e', 'SBO:0000627'),
	('R_EX_protrpthr_e', 'SBO:0000627'),
	('R_EX_serargala_e', 'SBO:0000627'),
	('R_EX_serargtrp_e', 'SBO:0000627'),
	('R_EX_sercysarg_e', 'SBO:0000627'),
	('R_EX_serglyglu_e', 'SBO:0000627'),
	('R_PE224_HSte', 'SBO:0000658'),
	('R_EX_serphelys_e', 'SBO:0000627'),
	('R_EX_sertrphis_e', 'SBO:0000627'),
	('R_EX_thrargtyr_e', 'SBO:0000627'),
	('R_EX_thrasntyr_e', 'SBO:0000627'),
	('R_EX_thrglnglu_e', 'SBO:0000627'),
	('R_EX_thrhishis_e', 'SBO:0000627'),
	('R_EX_thrilearg_e', 'SBO:0000627'),
	('R_EX_thrmetarg_e', 'SBO:0000627'),
	('R_EX_trpalapro_e', 'SBO:0000627'),
	('R_EX_trpaspasp_e', 'SBO:0000627'),
	('R_EX_trpgluleu_e', 'SBO:0000627'),
	('R_EX_trpglutyr_e', 'SBO:0000627'),
	('R_EX_trpglyval_e', 'SBO:0000627'),
	('R_EX_trphismet_e', 'SBO:0000627'),
	('R_EX_trpmetarg_e', 'SBO:0000627'),
	('R_EX_trpphe_e', 'SBO:0000627'),
	('R_EX_trpprogly_e', 'SBO:0000627'),
	('R_EX_trpproleu_e', 'SBO:0000627'),
	('R_EX_trpproval_e', 'SBO:0000627'),
	('R_EX_trpsertyr_e', 'SBO:0000627'),
	('R_EX_trpthrglu_e', 'SBO:0000627'),
	('R_EX_trpthrile_e', 'SBO:0000627'),
	('R_EX_trpthrtyr_e', 'SBO:0000627'),
	('R_EX_trpvalasp_e', 'SBO:0000627'),
	('R_PCHOLN261_HSte', 'SBO:0000658'),
	('R_PCHOLN28_HSte', 'SBO:0000658'),
	('R_HDCECRNtr', 'SBO:0000658'),
	('R_LNELDCCRNtr', 'SBO:0000658'),
	('R_STCRNtr', 'SBO:0000658'),
	('R_EX_sphmyln_hs_e', 'SBO:0000627'),
	('R_XOLEST182tl', 'SBO:0000658'),
	('R_TMNDNCtl', 'SBO:0000658'),
	('R_XOLEST226tl', 'SBO:0000658'),
	('R_CRVNCtl', 'SBO:0000658'),
	('R_BGLYtm', 'SBO:0000658'),
	('R_GNCORE1te', 'SBO:0000658'),
	('R_GNCORE2te', 'SBO:0000658'),
	('R_LHCYSTINt', 'SBO:0000658'),
	('R_EX_Lhcystin_e', 'SBO:0000627'),
	('R_MALOAAtm', 'SBO:0000660'),
	('R_EX_tyrala_e', 'SBO:0000627'),
	('R_EX_tyralaphe_e', 'SBO:0000627'),
	('R_EX_tyrargglu_e', 'SBO:0000627'),
	('R_EX_tyrasparg_e', 'SBO:0000627'),
	('R_EX_tyrcysgly_e', 'SBO:0000627'),
	('R_EX_tyrglu_e', 'SBO:0000627'),
	('R_EX_valleuphe_e', 'SBO:0000627'),
	('R_EX_vallystyr_e', 'SBO:0000627'),
	('R_EX_valtrpphe_e', 'SBO:0000627'),
	('R_EX_valtrpval_e', 'SBO:0000627'),
	('R_EX_valval_e', 'SBO:0000627'),
	('R_EX_trpglyasp_e', 'SBO:0000627'),
	('R_ALAARGCYSt', 'SBO:0000659'),
	('R_GLNLYSLYSt', 'SBO:0000659'),
	('R_GLNLYSTRPt', 'SBO:0000659'),
	('R_GLULEUt', 'SBO:0000659'),
	('R_GLUTHRt', 'SBO:0000659'),
	('R_GLUTRPALAt', 'SBO:0000659'),
	('R_GLYHISASNt', 'SBO:0000659'),
	('R_GLYHISLYSt', 'SBO:0000659'),
	('R_GLYLYSCYSt', 'SBO:0000659'),
	('R_GLYLYSPHEt', 'SBO:0000659'),
	('R_GLYTYRLYSt', 'SBO:0000659'),
	('R_HISARGCYSt', 'SBO:0000659'),
	('R_HISARGSERt', 'SBO:0000659'),
	('R_HISCYSCYSt', 'SBO:0000659'),
	('R_MLTHFtm', 'SBO:0000658'),
	('R_2MOPtm', 'SBO:0000658'),
	('R_PSDm_hsc', 'SBO:0000399'),
	('R_r2514e', 'SBO:0000660'),
	('R_RE2675C2', 'SBO:0000200'),
	('R_3MOXTYRESSte', 'SBO:0000657'),
	('R_ADRNLtu', 'SBO:0000658'),
	('R_ACDO', 'SBO:0000200'),
	('R_DM_pe_hs_c', 'SBO:0000628'),
	('R_SK_akg_c', 'SBO:0000632'),
	('R_SK_mi14p_c', 'SBO:0000632'),
	('R_GTHOXti2', 'SBO:0000657'),
	('R_NORMETEVESSte', 'SBO:0000657'),
	('R_OROATP', 'SBO:0000659'),
	('R_HISGLUt', 'SBO:0000659'),
	('R_HISGLUGLNt', 'SBO:0000659'),
	('R_HISHISLYSt', 'SBO:0000659'),
	('R_HISLYSGLUt', 'SBO:0000659'),
	('R_HISLYSTHRt', 'SBO:0000659'),
	('R_HISMETGLNt', 'SBO:0000659'),
	('R_HISPHEARGt', 'SBO:0000659'),
	('R_HISPROLYSt', 'SBO:0000659'),
	('R_HISTRPHISt', 'SBO:0000659'),
	('R_ILEARGILEt', 'SBO:0000659'),
	('R_ILEASPt', 'SBO:0000659'),
	('R_ILEGLNGLUt', 'SBO:0000659'),
	('R_ILETRPTYRt', 'SBO:0000659'),
	('R_LEUALAARGt', 'SBO:0000659'),
	('R_LEULEUTRPt', 'SBO:0000659'),
	('R_LEUSERTRPt', 'SBO:0000659'),
	('R_SK_band_c', 'SBO:0000632'),
	('R_Ht', 'SBO:0000658'),
	('R_UGT1A10c', 'SBO:0000217'),
	('R_ACGALtr', 'SBO:0000658'),
	('R_LEUTYRTYRt', 'SBO:0000659'),
	('R_SERPHELYSt', 'SBO:0000659'),
	('R_THRARGTYRt', 'SBO:0000659'),
	('R_THRASNTYRt', 'SBO:0000659'),
	('R_THRGLNGLUt', 'SBO:0000659'),
	('R_THRGLNTYRt', 'SBO:0000659'),
	('R_THRMETARGt', 'SBO:0000659'),
	('R_THRTHRARGt', 'SBO:0000659'),
	('R_TRPALAPROt', 'SBO:0000659'),
	('R_TRPGLUPROt', 'SBO:0000659'),
	('R_TRPGLYLEUt', 'SBO:0000659'),
	('R_EX_glyphe_e', 'SBO:0000627'),
	('R_EX_glypro_e', 'SBO:0000627'),
	('R_TRPHISMETt', 'SBO:0000659'),
	('R_TRPILELYSt', 'SBO:0000659'),
	('R_TRPLYSt', 'SBO:0000659'),
	('R_TRPMETVALt', 'SBO:0000659'),
	('R_TRPPROGLYt', 'SBO:0000659'),
	('R_TRPPROVALt', 'SBO:0000659'),
	('R_TRPTHRGLUt', 'SBO:0000659'),
	('R_TRPTYRTYRt', 'SBO:0000659'),
	('R_TYRALAPHEt', 'SBO:0000659'),
	('R_TYRARGGLUt', 'SBO:0000659'),
	('R_TYRARGSERt', 'SBO:0000659'),
	('R_TYRCYSGLYt', 'SBO:0000659'),
	('R_TYRCYSTHRt', 'SBO:0000659'),
	('R_TYRTHRt', 'SBO:0000659'),
	('R_TYRTRPPHEt', 'SBO:0000659'),
	('R_TYRTYRt', 'SBO:0000659'),
	('R_EX_ppi_e', 'SBO:0000627'),
	('R_PIt7', 'SBO:0000659'),
	('R_EX_4hbz_e', 'SBO:0000627'),
	('R_EX_34dhpha_e', 'SBO:0000627'),
	('R_CE2537ABCt', 'SBO:0000657'),
	('R_CE7082UPKt', 'SBO:0000658'),
	('R_CE7172UPKt', 'SBO:0000658'),
	('R_NRVNCABCt', 'SBO:0000657'),
	('R_PAIL_hs_SECt', 'SBO:0000658'),
	('R_PAILPALM_HSSECt', 'SBO:0000658'),
	('R_PCHOLAR_HSABCt', 'SBO:0000657'),
	('R_PCHOLHEP_HSABCt', 'SBO:0000657'),
	('R_PCHOLMYR_HsABCt', 'SBO:0000657'),
	('R_PCHOLN15_HSABCt', 'SBO:0000657'),
	('R_PCHOLN1836_HSABCt', 'SBO:0000657'),
	('R_PCHOLN19_HSABCt', 'SBO:0000657'),
	('R_PCHOLN201_HSABCt', 'SBO:0000657'),
	('R_PCHOLN204_HSABCt', 'SBO:0000657'),
	('R_PCHOLN205_HSABCt', 'SBO:0000657'),
	('R_PCHOLN264_HSABCt', 'SBO:0000657'),
	('R_PCHOLSTE_HSABCt', 'SBO:0000657'),
	('R_PE12_HSABCt', 'SBO:0000657'),
	('R_EX_homoval_e', 'SBO:0000627'),
	('R_GLYCLTtm', 'SBO:0000658'),
	('R_TYMc', 'SBO:0000200'),
	('R_DOPAc', 'SBO:0000200'),
	('R_PCHOL2PALM_HSte', 'SBO:0000658'),
	('R_Pe13_HSABCt', 'SBO:0000657'),
	('R_PE15_HSABCt', 'SBO:0000657'),
	('R_PE226_HSABCt', 'SBO:0000657'),
	('R_PEDH203_HSABCt', 'SBO:0000657'),
	('R_PELPALM_HSABCt', 'SBO:0000657'),
	('R_PEOLE_HSABCt', 'SBO:0000657'),
	('R_SPHMYLN18114_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18115_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18116_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN181161_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN181181_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN181201_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18121_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN18122_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN181221_hs_SECt', 'SBO:0000658'),
	('R_SPHMYLN1825_hs_SECt', 'SBO:0000658'),
	('R_3AIBt1', 'SBO:0000659'),
	('R_APRGSTRNt1e', 'SBO:0000660'),
	('R_PAFt', 'SBO:0000658'),
	('R_PCHOL2LINL_HSt1e', 'SBO:0000658'),
	('R_PCHOL2OLE_HSt1e', 'SBO:0000658'),
	('R_XOLEST183te', 'SBO:0000658'),
	('R_CORE4t', 'SBO:0000658'),
	('R_CORE7t', 'SBO:0000658'),
	('R_DST_ANTIGENt', 'SBO:0000658'),
	('R_GALAMtr', 'SBO:0000658'),
	('R_MK10t', 'SBO:0000658'),
	('R_MK11t', 'SBO:0000658'),
	('R_S2L2N2M2Mt', 'SBO:0000658'),
	('R_EX_core7_e', 'SBO:0000627'),
	('R_EX_core8_e', 'SBO:0000627'),
	('R_EX_gncore2_e', 'SBO:0000627'),
	('R_EX_mqn10_e', 'SBO:0000627'),
	('R_EX_mqn11_e', 'SBO:0000627'),
	('R_EX_mqn9_e', 'SBO:0000627'),
	('R_EX_s2l2n2m2m_e', 'SBO:0000627'),
	('R_EX_sTn_antigen_e', 'SBO:0000627'),
	('R_EX_lpam_e', 'SBO:0000627'),
	('R_EX_pa_hs_e', 'SBO:0000627'),
	('R_DM_mqn11_c', 'SBO:0000628'),
	('R_DM_galam_c', 'SBO:0000628'),
	('R_DM_C02712_c', 'SBO:0000628'),
	('R_F1Ate', 'SBO:0000658'),
	('R_F1Ate2', 'SBO:0000658'),
	('R_34HPLtm', 'SBO:0000659'),
	('R_3HPPtm', 'SBO:0000658'),
	('R_PGP_hs_tm', 'SBO:0000658'),
	('R_C02592tx', 'SBO:0000658'),
	('R_PROSTGE2t2r', 'SBO:0000658'),
	('R_PROSTGE2t2m', 'SBO:0000658'),
	('R_ESTRr', 'SBO:0000200'),
	('R_LTHSTRLtr', 'SBO:0000658'),
	('R_SK_11_cis_retfa_c', 'SBO:0000632'),
	('R_SK_C02528_c', 'SBO:0000632'),
	('R_SK_HC02191_c', 'SBO:0000632'),
	('R_SK_HC02192_c', 'SBO:0000632'),
	('R_SK_HC02194_c', 'SBO:0000632'),
	('R_PCHOL2STE_HSt1e', 'SBO:0000658'),
	('R_PCHOLAR_HSt1e', 'SBO:0000658'),
	('R_PCHOLDOC_HSt1e', 'SBO:0000658'),
	('R_PCHOLEIC_HSt1e', 'SBO:0000658'),
	('R_PCHOLMYR_Hst1e', 'SBO:0000658'),
	('R_PCHOLN19_HSt1e', 'SBO:0000658'),
	('R_PCHOLN203_HSt1e', 'SBO:0000658'),
	('R_PCHOLN204_HSt1e', 'SBO:0000658'),
	('R_PCHOLN205_HSt1e', 'SBO:0000658'),
	('R_PCHOLN224_HSt1e', 'SBO:0000658'),
	('R_PCHOLN2254_HSt1e', 'SBO:0000658'),
	('R_PCHOLN264_HSt1e', 'SBO:0000658'),
	('R_PCHOLOLE_HSt1e', 'SBO:0000658'),
	('R_PEPALM_HSt1e', 'SBO:0000658'),
	('R_PCHOLPALME_HSt1e', 'SBO:0000658'),
	('R_Pe13_HSt1e', 'SBO:0000658'),
	('R_PE17_HSt1e', 'SBO:0000658'),
	('R_PE203_HSt1e', 'SBO:0000658'),
	('R_PE2LINL_HSt1e', 'SBO:0000658'),
	('R_PEDH203_HSt1e', 'SBO:0000658'),
	('R_PELINL_HSt1e', 'SBO:0000658'),
	('R_PEOLE_HSt1e', 'SBO:0000658'),
	('R_TRYPTAte', 'SBO:0000659'),
	('R_SELMETHte', 'SBO:0000659'),
	('R_CE7090te', 'SBO:0000657'),
	('R_CE7096te', 'SBO:0000657'),
	('R_CE1447te', 'SBO:0000657'),
	('R_C05769te3', 'SBO:0000660'),
	('R_C05770te4', 'SBO:0000660'),
	('R_MLTHFte3', 'SBO:0000658'),
	('R_CE2705t', 'SBO:0000658'),
	('R_MMAte', 'SBO:0000660'),
	('R_TYMte', 'SBO:0000658'),
	('R_HDD2CRNte2', 'SBO:0000659'),
	('R_SK_HC02196_c', 'SBO:0000632'),
	('R_SK_HC02220_c', 'SBO:0000632'),
	('R_SK_chol_c', 'SBO:0000632'),
	('R_SK_cholate_c', 'SBO:0000632'),
	('R_SK_coa_c', 'SBO:0000632'),
	('R_FEROc', 'SBO:0000200'),
	('R_MLTHFte1', 'SBO:0000657'),
	('R_CE1918te', 'SBO:0000660'),
	('R_EX_CE4969_e', 'SBO:0000627'),
	('R_NACCYStm', 'SBO:0000658'),
	('R_EX_CE1310_e', 'SBO:0000627'),
	('R_AGMt_m', 'SBO:0000658'),
	('R_4HBZte', 'SBO:0000658'),
	('R_EX_sucsal_e', 'SBO:0000627'),
	('R_EX_CE7081_e', 'SBO:0000627'),
	('R_EGMEtr', 'SBO:0000658'),
	('R_EGMEte', 'SBO:0000658'),
	('R_EX_egme_e', 'SBO:0000627'),
	('R_EX_12harachd_e', 'SBO:0000627'),
	('R_18HARACHDtr', 'SBO:0000660'),
	('R_SQLter', 'SBO:0000658'),
	('R_EX_sql_e', 'SBO:0000627'),
	('R_ORN_Dtx', 'SBO:0000660'),
	('R_EX_orn__D_e', 'SBO:0000627'),
	('R_5G2OXPTtx', 'SBO:0000658'),
	('R_EX_melatn_e', 'SBO:0000627'),
	('R_INSt2', 'SBO:0000659'),
	('R_EX_6hoxmelatn_e', 'SBO:0000627'),
	('R_C10164te', 'SBO:0000658'),
	('R_EX_CE4890_e', 'SBO:0000627'),
	('R_C05769te2', 'SBO:0000658'),
	('R_EX_C05767_e', 'SBO:0000627'),
	('R_C05770te3', 'SBO:0000658'),
	('R_EX_mhista_e', 'SBO:0000627'),
	('R_EX_13dampp_e', 'SBO:0000627'),
	('R_EX_mma_e', 'SBO:0000627'),
	('R_EX_ametam_e', 'SBO:0000627'),
	('R_XYLULte', 'SBO:0000658'),
	('R_EX_xylu__L_e', 'SBO:0000627'),
	('R_EX_xylu__D_e', 'SBO:0000627'),
	('R_CE0737te', 'SBO:0000658'),
	('R_EX_sphings_e', 'SBO:0000627'),
	('R_HDD2CRNte', 'SBO:0000658'),
	('R_EX_sphgn_e', 'SBO:0000627'),
	('R_EX_N1aspmd_e', 'SBO:0000627'),
	('R_URIt2', 'SBO:0000659'),
	('R_r0082', 'SBO:0000200'),
	('R_C13856te', 'SBO:0000658'),
	('R_EX_1a25dhvitd3_e', 'SBO:0000627'),
	('R_PRISTte', 'SBO:0000657'),
	('R_CE2049te', 'SBO:0000657'),
	('R_EX_fdp_e', 'SBO:0000627'),
	('R_EX_coke_e', 'SBO:0000627'),
	('R_COKEte', 'SBO:0000658'),
	('R_5A2OPNTNtx', 'SBO:0000658'),
	('R_EX_HC00006_e', 'SBO:0000627'),
	('R_EX_HC00007_e', 'SBO:0000627'),
	('R_EX_HC00008_e', 'SBO:0000627'),
	('R_EX_HC00009_e', 'SBO:0000627'),
	('R_UDPG4DOPA', 'SBO:0000217'),
	('R_S2L2N2M2Mtl', 'SBO:0000658'),
	('R_DM_k_g', 'SBO:0000628'),
	('R_DM_na1_r', 'SBO:0000628'),
	('R_DM_na1_c', 'SBO:0000628'),
	('R_DM_retn_n', 'SBO:0000628'),
	('R_DM_hhxdcal_c', 'SBO:0000628'),
	('R_DM_15HPET_x', 'SBO:0000628'),
	('R_MK8t', 'SBO:0000658'),
	('R_DM_15HPET_r', 'SBO:0000628'),
	('R_SK_Ser_Gly_Ala_X_Gly_r', 'SBO:0000632'),
	('R_EX_CE5026_e', 'SBO:0000627'),
	('R_EX_5cysgly34dhphe_e', 'SBO:0000627'),
	('R_EX_CE1261_e', 'SBO:0000627'),
	('R_EX_gm1_hs_e', 'SBO:0000627'),
	('R_EX_gm2_hs_e', 'SBO:0000627'),
	('R_EX_gm1b_hs_e', 'SBO:0000627'),
	('R_EX_gd1b_hs_e', 'SBO:0000627'),
	('R_HMR_0019', 'SBO:0000658'),
	('R_FA40COAtm', 'SBO:0000658'),
	('R_HMR_0167', 'SBO:0000658'),
	('R_HMR_0170', 'SBO:0000658'),
	('R_HMR_0176', 'SBO:0000658'),
	('R_HMR_0182', 'SBO:0000658'),
	('R_HMR_0185', 'SBO:0000658'),
	('R_HMR_0191', 'SBO:0000658'),
	('R_EX_mvlac_e', 'SBO:0000627'),
	('R_TIGGLYtm', 'SBO:0000658'),
	('R_HMR_0207', 'SBO:0000657'),
	('R_HMR_0211', 'SBO:0000657'),
	('R_HMR_0239', 'SBO:0000657'),
	('R_HMR_0291', 'SBO:0000657'),
	('R_EX_tiggly_e', 'SBO:0000627'),
	('R_TD2GLTRCOAm', 'SBO:0000200'),
	('R_3OHGLUTACtm', 'SBO:0000658'),
	('R_3OHGLUTACte', 'SBO:0000658'),
	('R_EX_3ohglutac_e', 'SBO:0000627'),
	('R_GLUTCONtm', 'SBO:0000658'),
	('R_GLUTCONte', 'SBO:0000658'),
	('R_EX_glutcon_e', 'SBO:0000627'),
	('R_3HIVActm', 'SBO:0000658'),
	('R_EX_3hivac_e', 'SBO:0000627'),
	('R_3OHSEBACtxc', 'SBO:0000658'),
	('R_3OHSEBACte', 'SBO:0000658'),
	('R_EX_3ohsebac_e', 'SBO:0000627'),
	('R_HMR_0296', 'SBO:0000658'),
	('R_HMR_0299', 'SBO:0000657'),
	('R_HMR_0300', 'SBO:0000658'),
	('R_HMR_0307', 'SBO:0000657'),
	('R_HMR_0308', 'SBO:0000658'),
	('R_HMR_0311', 'SBO:0000657'),
	('R_HMR_0317', 'SBO:0000657'),
	('R_HMR_0321', 'SBO:0000657'),
	('R_HMR_0326', 'SBO:0000658'),
	('R_3OHSUBACtxc', 'SBO:0000658'),
	('R_3OHSUBACte', 'SBO:0000658'),
	('R_EX_3ohsubac_e', 'SBO:0000627'),
	('R_EX_5ohhexa_e', 'SBO:0000627'),
	('R_7OHOCTAc', 'SBO:0000200'),
	('R_7OHOCTAte', 'SBO:0000658'),
	('R_EX_7ohocata_e', 'SBO:0000627'),
	('R_ETHMALACte', 'SBO:0000658'),
	('R_METHSUCCte', 'SBO:0000658'),
	('R_EX_methsucc_e', 'SBO:0000627'),
	('R_SUBGLYte', 'SBO:0000658'),
	('R_4OHBUTm', 'SBO:0000200'),
	('R_4OHBUTtce', 'SBO:0000658'),
	('R_HMR_0343', 'SBO:0000657'),
	('R_FACOAE1839Z12Z15Z', 'SBO:0000376'),
	('R_HMR_0359', 'SBO:0000657'),
	('R_HMR_0363', 'SBO:0000657'),
	('R_HMR_0375', 'SBO:0000657'),
	('R_HMR_0380', 'SBO:0000658'),
	('R_HMR_0387', 'SBO:0000657'),
	('R_HMR_0388', 'SBO:0000658'),
	('R_3AIBSYMPt', 'SBO:0000659'),
	('R_C14771UPKt', 'SBO:0000658'),
	('R_CE1243UPKt', 'SBO:0000658'),
	('R_SPHMYLN18118_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN181181_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN181201_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN18122_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN181221_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN18123_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN1824_hs_ATPt', 'SBO:0000657'),
	('R_SPHMYLN1825_hs_ATPt', 'SBO:0000657'),
	('R_THEXDDtm', 'SBO:0000660'),
	('R_THEXDDte', 'SBO:0000657'),
	('R_HPDECEtm', 'SBO:0000660'),
	('R_HPDECEte', 'SBO:0000657'),
	('R_EX_hpdece_e', 'SBO:0000627'),
	('R_5EIPENCtm', 'SBO:0000660'),
	('R_EX_5eipenc_e', 'SBO:0000627'),
	('R_ANDRSTNDNte', 'SBO:0000657'),
	('R_ANDRSTANDRte', 'SBO:0000657'),
	('R_CE2209te', 'SBO:0000657'),
	('R_C05299te', 'SBO:0000657'),
	('R_C05302te', 'SBO:0000657'),
	('R_HMR_0831', 'SBO:0000658'),
	('R_HMR_0913', 'SBO:0000658'),
	('R_PGESc', 'SBO:0000377'),
	('R_HMR_1737', 'SBO:0000200'),
	('R_HMR_1739', 'SBO:0000200'),
	('R_HMR_1741', 'SBO:0000200'),
	('R_HMR_1742', 'SBO:0000200'),
	('R_HMR_1743', 'SBO:0000200'),
	('R_HMR_1749', 'SBO:0000200'),
	('R_HMR_1750', 'SBO:0000200'),
	('R_CE5072te', 'SBO:0000657'),
	('R_11DOCRTSTRNte', 'SBO:0000657'),
	('R_PRGNLONEte', 'SBO:0000657'),
	('R_17AHPRGNLONEte', 'SBO:0000657'),
	('R_PRGNLONESte', 'SBO:0000657'),
	('R_MMAt2e', 'SBO:0000658'),
	('R_CE2006te', 'SBO:0000657'),
	('R_N8ASPMDte', 'SBO:0000658'),
	('R_CE4890te2', 'SBO:0000658'),
	('R_C09642te', 'SBO:0000658'),
	('R_EX_5g2oxpt_e', 'SBO:0000627'),
	('R_EX_andrstndn_e', 'SBO:0000627'),
	('R_EANDRSTRNtr', 'SBO:0000657'),
	('R_EX_eandrstrn_e', 'SBO:0000627'),
	('R_ESTRONEte', 'SBO:0000657'),
	('R_EX_C05298_e', 'SBO:0000627'),
	('R_EX_C05301_e', 'SBO:0000627'),
	('R_EX_CE5072_e', 'SBO:0000627'),
	('R_EX_11docrtstrn_e', 'SBO:0000627'),
	('R_EX_CE2211_e', 'SBO:0000627'),
	('R_EX_17ahprgstrn_e', 'SBO:0000627'),
	('R_HC02020te', 'SBO:0000658'),
	('R_EX_HC02020_e', 'SBO:0000627'),
	('R_XOL24OHtr', 'SBO:0000658'),
	('R_XOL27OHte', 'SBO:0000658'),
	('R_HMR_1751', 'SBO:0000200'),
	('R_HMR_1752', 'SBO:0000658'),
	('R_HMR_1764', 'SBO:0000658'),
	('R_HMR_1766', 'SBO:0000200'),
	('R_HMR_1769', 'SBO:0000200'),
	('R_HMR_1770', 'SBO:0000200'),
	('R_HMR_1928', 'SBO:0000200'),
	('R_HMR_1941', 'SBO:0000200'),
	('R_HMR_1948', 'SBO:0000200'),
	('R_HMR_1967', 'SBO:0000200'),
	('R_HMR_1970', 'SBO:0000200'),
	('R_HMR_1976', 'SBO:0000200'),
	('R_HMR_1979', 'SBO:0000200'),
	('R_HMR_1988', 'SBO:0000200'),
	('R_HMR_1989', 'SBO:0000200'),
	('R_EX_xol27oh_e', 'SBO:0000627'),
	('R_XOL25OHtr', 'SBO:0000658'),
	('R_EX_dsmsterol_e', 'SBO:0000627'),
	('R_CHSTEROLSte', 'SBO:0000658'),
	('R_3ITYR_Lte', 'SBO:0000660'),
	('R_35DIODTYRte', 'SBO:0000660'),
	('R_13_CIS_RETNte', 'SBO:0000658'),
	('R_CE1617te', 'SBO:0000658'),
	('R_EX_CE1617_e', 'SBO:0000627'),
	('R_EX_34dhoxmand_e', 'SBO:0000627'),
	('R_FNA5MOXAMte', 'SBO:0000658'),
	('R_EX_fna5moxam_e', 'SBO:0000627'),
	('R_CE5643te', 'SBO:0000658'),
	('R_EX_CE5643_e', 'SBO:0000627'),
	('R_EX_CE7085_e', 'SBO:0000627'),
	('R_CE1401te', 'SBO:0000658'),
	('R_EX_CE1401_e', 'SBO:0000627'),
	('R_EX_glucys_e', 'SBO:0000627'),
	('R_DOPA4SFt', 'SBO:0000658'),
	('R_EX_dopa4glcur_e', 'SBO:0000627'),
	('R_EX_dopa3glcur_e', 'SBO:0000627'),
	('R_DOPACHRMDC', 'SBO:0000399'),
	('R_CE5026t', 'SBO:0000657'),
	('R_CE1261t', 'SBO:0000658'),
	('R_HMR_1990', 'SBO:0000200'),
	('R_HMR_1991', 'SBO:0000200'),
	('R_HMR_2288', 'SBO:0000200'),
	('R_HMR_2292', 'SBO:0000200'),
	('R_HMR_2293', 'SBO:0000200'),
	('R_HMR_2295', 'SBO:0000200'),
	('R_HMR_2334', 'SBO:0000200'),
	('R_HMR_2338', 'SBO:0000200'),
	('R_HMR_2345', 'SBO:0000200'),
	('R_HMR_2356', 'SBO:0000200'),
	('R_HMR_2362', 'SBO:0000200'),
	('R_HMR_2403', 'SBO:0000200'),
	('R_HMR_2433', 'SBO:0000399'),
	('R_HMR_2434', 'SBO:0000200'),
	('R_HMR_2436', 'SBO:0000200'),
	('R_HMR_2472', 'SBO:0000200'),
	('R_HMR_2484', 'SBO:0000200'),
	('R_HMR_2495', 'SBO:0000200'),
	('R_HMR_2670', 'SBO:0000660'),
	('R_HMR_2679', 'SBO:0000660'),
	('R_HMR_2685', 'SBO:0000660'),
	('R_HMR_2688', 'SBO:0000660'),
	('R_HMR_2691', 'SBO:0000660'),
	('R_HMR_2695', 'SBO:0000660'),
	('R_NADPQNOXR', 'SBO:0000200'),
	('R_NADQNOXR', 'SBO:0000200'),
	('R_EX_5cysdopa_e', 'SBO:0000627'),
	('R_CE2172t', 'SBO:0000658'),
	('R_CRMte', 'SBO:0000658'),
	('R_EX_gluside_hs_e', 'SBO:0000627'),
	('R_GA1tl', 'SBO:0000658'),
	('R_GALGLUSIDEtg2', 'SBO:0000658'),
	('R_GD3tg', 'SBO:0000658'),
	('R_GLUSIDEte', 'SBO:0000658'),
	('R_GLUSIDEtl', 'SBO:0000660'),
	('R_GM2tl', 'SBO:0000658'),
	('R_SPHMYLNtl2', 'SBO:0000660'),
	('R_RE3477C1', 'SBO:0000200'),
	('R_WHTSTSTERONEtr', 'SBO:0000658'),
	('R_TETTET6COAtm', 'SBO:0000658'),
	('R_TETPENT6COAtm', 'SBO:0000658'),
	('R_DAG_HStg', 'SBO:0000658'),
	('R_HMR_2703', 'SBO:0000660'),
	('R_HMR_2709', 'SBO:0000660'),
	('R_HMR_2712', 'SBO:0000660'),
	('R_HMR_2715', 'SBO:0000660'),
	('R_HMR_2718', 'SBO:0000660'),
	('R_HMR_2727', 'SBO:0000660'),
	('R_HMR_9665', 'SBO:0000658'),
	('R_HMR_3018', 'SBO:0000658'),
	('R_HMR_3053', 'SBO:0000200'),
	('R_HMR_3056', 'SBO:0000200'),
	('R_HMR_3064', 'SBO:0000200'),
	('R_HMR_3068', 'SBO:0000200'),
	('R_HMR_3076', 'SBO:0000200'),
	('R_HMR_3100', 'SBO:0000200'),
	('R_HMR_3107', 'SBO:0000200'),
	('R_HMR_3109', 'SBO:0000200'),
	('R_HMR_3230', 'SBO:0000200'),
	('R_PHCRMtg', 'SBO:0000658'),
	('R_SPHGNtn', 'SBO:0000658'),
	('R_EX_gd1a_hs_e', 'SBO:0000627'),
	('R_DHCRMter', 'SBO:0000658'),
	('R_EX_34dhpe_e', 'SBO:0000627'),
	('R_DM_no2_c', 'SBO:0000628'),
	('R_DM_gm1_hs_n', 'SBO:0000628'),
	('R_DM_6hddopaqn_c', 'SBO:0000628'),
	('R_GALSIDEter', 'SBO:0000658'),
	('R_Rtotaltg', 'SBO:0000658'),
	('R_GD1Atg', 'SBO:0000658'),
	('R_HMR_0247', 'SBO:0000657'),
	('R_HMR_0253', 'SBO:0000657'),
	('R_HMR_0257', 'SBO:0000657'),
	('R_HMR_0261', 'SBO:0000657'),
	('R_HMR_0278', 'SBO:0000658'),
	('R_HMR_0281', 'SBO:0000657'),
	('R_HMR_0287', 'SBO:0000657'),
	('R_HMR_0395', 'SBO:0000657'),
	('R_FACOAE1836Z9Z12Z', 'SBO:0000376'),
	('R_HMR_0419', 'SBO:0000657'),
	('R_HMR_0428', 'SBO:0000658'),
	('R_HMR_0431', 'SBO:0000657'),
	('R_HMR_0432', 'SBO:0000658'),
	('R_HMR_0435', 'SBO:0000657'),
	('R_HMR_0436', 'SBO:0000658'),
	('R_HMR_0439', 'SBO:0000657'),
	('R_HMR_0467', 'SBO:0000658'),
	('R_G3PD', 'SBO:0000200'),
	('R_HMR_0942', 'SBO:0000200'),
	('R_HMR_0946', 'SBO:0000200'),
	('R_HMR_0950', 'SBO:0000200'),
	('R_HMR_0954', 'SBO:0000200'),
	('R_HMR_0962', 'SBO:0000658'),
	('R_HMR_0981', 'SBO:0000200'),
	('R_HMR_1104', 'SBO:0000658'),
	('R_HMR_1126', 'SBO:0000200'),
	('R_HMR_3232', 'SBO:0000200'),
	('R_HMR_3236', 'SBO:0000200'),
	('R_HMR_3242', 'SBO:0000200'),
	('R_HMR_3246', 'SBO:0000200'),
	('R_HMR_3296', 'SBO:0000200'),
	('R_HMR_3322', 'SBO:0000200'),
	('R_HMR_3344', 'SBO:0000200'),
	('R_HMR_3348', 'SBO:0000200'),
	('R_HMR_3352', 'SBO:0000200'),
	('R_HMR_3396', 'SBO:0000200'),
	('R_HMR_3397', 'SBO:0000200'),
	('R_HMR_3406', 'SBO:0000200'),
	('R_HMR_3522', 'SBO:0000200'),
	('R_HMR_9669', 'SBO:0000658'),
	('R_HMR_6632', 'SBO:0000200'),
	('R_HMR_6647', 'SBO:0000200'),
	('R_HMR_1129', 'SBO:0000200'),
	('R_HMR_1135', 'SBO:0000658'),
	('R_HMR_1243', 'SBO:0000658'),
	('R_HMR_1280', 'SBO:0000200'),
	('R_HMR_1283', 'SBO:0000658'),
	('R_HMR_1316', 'SBO:0000658'),
	('R_HMR_1317', 'SBO:0000200'),
	('R_HMR_1329', 'SBO:0000200'),
	('R_HMR_1477', 'SBO:0000200'),
	('R_HMR_1478', 'SBO:0000200'),
	('R_HMR_1490', 'SBO:0000200'),
	('R_HMR_1493', 'SBO:0000200'),
	('R_HMR_1494', 'SBO:0000200'),
	('R_HMR_1495', 'SBO:0000399'),
	('R_HMR_1504', 'SBO:0000200'),
	('R_HMR_1509', 'SBO:0000200'),
	('R_HMR_1516', 'SBO:0000200'),
	('R_HMR_1540', 'SBO:0000200'),
	('R_HMR_1544', 'SBO:0000200'),
	('R_HMR_1545', 'SBO:0000200'),
	('R_HMR_1546', 'SBO:0000399'),
	('R_HMR_1548', 'SBO:0000200'),
	('R_HMR_1552', 'SBO:0000200'),
	('R_HMR_1557', 'SBO:0000200'),
	('R_LTHSTRLOR', 'SBO:0000200'),
	('R_HMR_1565', 'SBO:0000200'),
	('R_HMR_1620', 'SBO:0000658'),
	('R_HMR_1623', 'SBO:0000658'),
	('R_HMR_1651', 'SBO:0000200'),
	('R_HMR_1665', 'SBO:0000658'),
	('R_HMR_1681', 'SBO:0000200'),
	('R_HMR_1685', 'SBO:0000200'),
	('R_HMR_1701', 'SBO:0000658'),
	('R_HMR_1735', 'SBO:0000200'),
	('R_HMR_1992', 'SBO:0000200'),
	('R_HMR_1993', 'SBO:0000200'),
	('R_HMR_2002', 'SBO:0000200'),
	('R_HMR_2007', 'SBO:0000200'),
	('R_HMR_2011', 'SBO:0000200'),
	('R_HMR_2014', 'SBO:0000200'),
	('R_HMR_2087', 'SBO:0000658'),
	('R_HMR_2127', 'SBO:0000658'),
	('R_HMR_2190', 'SBO:0000399'),
	('R_HMR_2217', 'SBO:0000200'),
	('R_HMR_2219', 'SBO:0000200'),
	('R_HMR_2259', 'SBO:0000399'),
	('R_HMR_2262', 'SBO:0000200'),
	('R_HMR_2263', 'SBO:0000399'),
	('R_HMR_2264', 'SBO:0000200'),
	('R_HMR_2266', 'SBO:0000200'),
	('R_HMR_2267', 'SBO:0000399'),
	('R_HMR_2281', 'SBO:0000200'),
	('R_HMR_3520', 'SBO:0000660'),
	('R_HMR_2530', 'SBO:0000399'),
	('R_HMR_2537', 'SBO:0000200'),
	('R_HMR_2540', 'SBO:0000399'),
	('R_HMR_2543', 'SBO:0000200'),
	('R_HMR_2585', 'SBO:0000200'),
	('R_HMR_2644', 'SBO:0000660'),
	('R_HMR_6782', 'SBO:0000200'),
	('R_HMR_6826', 'SBO:0000200'),
	('R_HMR_6834', 'SBO:0000200'),
	('R_ICITt_x', 'SBO:0000658'),
	('R_HMR_6989', 'SBO:0000659'),
	('R_HMR_7184', 'SBO:0000658'),
	('R_HMR_7198', 'SBO:0000658'),
	('R_HMR_7330', 'SBO:0000658'),
	('R_HMR_7432', 'SBO:0000658'),
	('R_HMR_7437', 'SBO:0000658'),
	('R_HMR_7628', 'SBO:0000399'),
	('R_PMI12346PS', 'SBO:0000216'),
	('R_HMR_7715', 'SBO:0000658'),
	('R_HMR_7724', 'SBO:0000658'),
	('R_HMR_7727', 'SBO:0000658'),
	('R_HMR_7757', 'SBO:0000659'),
	('R_HMR_7758', 'SBO:0000659'),
	('R_HMR_7903', 'SBO:0000658'),
	('R_HMR_7947', 'SBO:0000658'),
	('R_HMR_7949', 'SBO:0000658'),
	('R_HMR_8056', 'SBO:0000658'),
	('R_HMR_8084', 'SBO:0000658'),
	('R_HMR_8086', 'SBO:0000658'),
	('R_HMR_8505', 'SBO:0000658'),
	('R_HMR_8510', 'SBO:0000658'),
	('R_ID3ACALDtm', 'SBO:0000658'),
	('R_HMR_8590', 'SBO:0000658'),
	('R_7DHCDCHOLabc', 'SBO:0000657'),
	('R_CA24GSc', 'SBO:0000217'),
	('R_CA24Gte', 'SBO:0000657'),
	('R_CA3St', 'SBO:0000660'),
	('R_CDCA24GSc', 'SBO:0000217'),
	('R_CDCA24GSr', 'SBO:0000217'),
	('R_CDCA24Gtr', 'SBO:0000658'),
	('R_CDCA3GSc', 'SBO:0000217'),
	('R_CDCA3GSr', 'SBO:0000217'),
	('R_CDCA3Gte', 'SBO:0000657'),
	('R_CDCA3Gtr', 'SBO:0000658'),
	('R_DCA24GSc', 'SBO:0000217'),
	('R_DCA24Gte', 'SBO:0000657'),
	('R_DCA24Gtr', 'SBO:0000658'),
	('R_DCA3GSc', 'SBO:0000217'),
	('R_DCA3Gte', 'SBO:0000657'),
	('R_DCA3Gtr', 'SBO:0000658'),
	('R_DM_12dhchol_c', 'SBO:0000628'),
	('R_DM_3dhcdchol_c', 'SBO:0000628'),
	('R_DM_3dhchol_c', 'SBO:0000628'),
	('R_DM_3dhlchol_c', 'SBO:0000628'),
	('R_DM_cdca24g_c', 'SBO:0000628'),
	('R_DM_cdca3g_c', 'SBO:0000628'),
	('R_DM_coprost_c', 'SBO:0000628'),
	('R_DM_dca3g_c', 'SBO:0000628'),
	('R_HDCA24GSc', 'SBO:0000217'),
	('R_HDCA24GSr', 'SBO:0000217'),
	('R_CARN180t_m', 'SBO:0000660'),
	('R_HMR_2661', 'SBO:0000660'),
	('R_HMR_2667', 'SBO:0000660'),
	('R_HMR_3117', 'SBO:0000200'),
	('R_ACOADH160_m', 'SBO:0000200'),
	('R_ACOADH120_m', 'SBO:0000200'),
	('R_HMR_3149', 'SBO:0000200'),
	('R_ACOADH60_m', 'SBO:0000200'),
	('R_HMR_3178', 'SBO:0000200'),
	('R_HMR_3180', 'SBO:0000200'),
	('R_HMR_3182', 'SBO:0000200'),
	('R_HMR_3186', 'SBO:0000200'),
	('R_HMR_3188', 'SBO:0000200'),
	('R_HMR_3194', 'SBO:0000200'),
	('R_HMR_3196', 'SBO:0000200'),
	('R_HMR_3198', 'SBO:0000200'),
	('R_HMR_3202', 'SBO:0000200'),
	('R_HMR_3224', 'SBO:0000200'),
	('R_HMR_3411', 'SBO:0000200'),
	('R_HMR_3422', 'SBO:0000200'),
	('R_HMR_3423', 'SBO:0000200'),
	('R_HMR_3424', 'SBO:0000200'),
	('R_HMR_3429', 'SBO:0000200'),
	('R_HMR_3446', 'SBO:0000200'),
	('R_HMR_3452', 'SBO:0000200'),
	('R_HMR_3454', 'SBO:0000200'),
	('R_HMR_3859', 'SBO:0000660'),
	('R_HMR_3864', 'SBO:0000660'),
	('R_HMR_3867', 'SBO:0000658'),
	('R_HMR_3953', 'SBO:0000658'),
	('R_HMR_3996', 'SBO:0000200'),
	('R_HMR_4422', 'SBO:0000399'),
	('R_HMR_4702', 'SBO:0000399'),
	('R_BILIRED2', 'SBO:0000200'),
	('R_PROAKGOX1', 'SBO:0000399'),
	('R_HMR_4777', 'SBO:0000399'),
	('R_HMR_4831', 'SBO:0000200'),
	('R_HMR_4955', 'SBO:0000658'),
	('R_HDCA6GSr', 'SBO:0000217'),
	('R_HDCA6Gte', 'SBO:0000657'),
	('R_HYOCHOLabc', 'SBO:0000657'),
	('R_HYOCHOLtr', 'SBO:0000658'),
	('R_ICDCHOLabc', 'SBO:0000657'),
	('R_ICDCHOLt', 'SBO:0000660'),
	('R_ISOCHOLabc', 'SBO:0000657'),
	('R_ISOCHOLt2', 'SBO:0000659'),
	('R_LCA24GSc', 'SBO:0000217'),
	('R_LCA24GSr', 'SBO:0000217'),
	('R_LCA3GSc', 'SBO:0000217'),
	('R_LCA3Gte', 'SBO:0000657'),
	('R_LCA3Gtr', 'SBO:0000658'),
	('R_LCA3Sabc', 'SBO:0000657'),
	('R_LCA3St', 'SBO:0000660'),
	('R_M02155tr', 'SBO:0000658'),
	('R_TCA3Sabc', 'SBO:0000657'),
	('R_TCA3St', 'SBO:0000660'),
	('R_THYOCHOLt2', 'SBO:0000659'),
	('R_TUDCA3Sabc', 'SBO:0000657'),
	('R_3HPVShc', 'SBO:0000200'),
	('R_3HPVSthc', 'SBO:0000660'),
	('R_3HSMVACIDteb', 'SBO:0000657'),
	('R_3ISPVStep', 'SBO:0000658'),
	('R_3ISPVSthc', 'SBO:0000660'),
	('R_3OHACMPhr', 'SBO:0000200'),
	('R_3OHACMPtev', 'SBO:0000657'),
	('R_4BHGLZABCt', 'SBO:0000657'),
	('R_4HATVACIDOXDhc', 'SBO:0000200'),
	('R_4HATVACIDteb', 'SBO:0000657'),
	('R_4HATVACIDtep', 'SBO:0000658'),
	('R_4HATVACIDthc', 'SBO:0000660'),
	('R_4HATVLACteb', 'SBO:0000657'),
	('R_4HATVLACtep', 'SBO:0000658'),
	('R_4HATVLACthc', 'SBO:0000660'),
	('R_4HMDGLUCtev', 'SBO:0000658'),
	('R_4HMDZGLUChr', 'SBO:0000217'),
	('R_4OHMDZhr', 'SBO:0000200'),
	('R_4OHMDZtev', 'SBO:0000658'),
	('R_56DHPVSteb', 'SBO:0000657'),
	('R_56EPPVShc', 'SBO:0000200'),
	('R_56EPPVSteb', 'SBO:0000657'),
	('R_5OHFVSGLUtev', 'SBO:0000658'),
	('R_6AHGLZtev', 'SBO:0000658'),
	('R_6BHGLZGLCABCt', 'SBO:0000657'),
	('R_6BHGLZGLChr', 'SBO:0000217'),
	('R_6BHGLZGLCtev', 'SBO:0000658'),
	('R_6BHGLZhr', 'SBO:0000200'),
	('R_6BHGLZtev', 'SBO:0000658'),
	('R_6CSMVhep', 'SBO:0000200'),
	('R_6EPSteb', 'SBO:0000657'),
	('R_6EPVStep', 'SBO:0000658'),
	('R_6EPVSthc', 'SBO:0000660'),
	('R_6HMSMVACIDteb', 'SBO:0000657'),
	('R_6HSMVACIDteb', 'SBO:0000657'),
	('R_6HSMVhep', 'SBO:0000200'),
	('R_6MELVACtbc', 'SBO:0000657'),
	('R_ATVLACtu', 'SBO:0000657'),
	('R_Am19CStev', 'SBO:0000658'),
	('R_CARIBUP_SGLUhep', 'SBO:0000217'),
	('R_CARIBUP_Sthv', 'SBO:0000658'),
	('R_CRGLZtev', 'SBO:0000658'),
	('R_CRVS1tev', 'SBO:0000658'),
	('R_CRVSATPtu', 'SBO:0000657'),
	('R_CRVSM1teb', 'SBO:0000657'),
	('R_CRVSM23teb', 'SBO:0000657'),
	('R_CRVSM24tev', 'SBO:0000658'),
	('R_CRVStu', 'SBO:0000658'),
	('R_CRVSthc', 'SBO:0000660'),
	('R_CSASULPteb', 'SBO:0000657'),
	('R_CSASULPtev', 'SBO:0000658'),
	('R_CSAtu', 'SBO:0000657'),
	('R_CVM23GLUChc', 'SBO:0000217'),
	('R_DESFVShc', 'SBO:0000200'),
	('R_DHGLZtev', 'SBO:0000658'),
	('R_DSPVShc', 'SBO:0000200'),
	('R_DSPVStev', 'SBO:0000658'),
	('R_EX_12htacr_e', 'SBO:0000627'),
	('R_EX_1331tacr_e', 'SBO:0000627'),
	('R_EX_14hmdz_e', 'SBO:0000627'),
	('R_EX_1531tacr_e', 'SBO:0000627'),
	('R_EX_15dmt_e', 'SBO:0000627'),
	('R_EX_1hibup__S_e', 'SBO:0000627'),
	('R_EX_1hmdgluc_e', 'SBO:0000627'),
	('R_EX_1ohmdz_e', 'SBO:0000627'),
	('R_EX_2hatvacid_e', 'SBO:0000627'),
	('R_EX_2hatvlac_e', 'SBO:0000627'),
	('R_EX_2hatvlacgluc_e', 'SBO:0000627'),
	('R_EX_2hibup__R_e', 'SBO:0000627'),
	('R_EX_2hibup__S_e', 'SBO:0000627'),
	('R_EX_35dhpvs_e', 'SBO:0000627'),
	('R_EX_3hibup__S_e', 'SBO:0000627'),
	('R_EX_3hibupglu__S_e', 'SBO:0000627'),
	('R_EX_lstnm4_e', 'SBO:0000627'),
	('R_EX_lstnm5_e', 'SBO:0000627'),
	('R_EX_lstnm7_e', 'SBO:0000627'),
	('R_HMR_4964', 'SBO:0000660'),
	('R_HMR_5249', 'SBO:0000658'),
	('R_FE2utm', 'SBO:0000658'),
	('R_HMR_6359', 'SBO:0000659'),
	('R_HMR_6363', 'SBO:0000659'),
	('R_HMR_6364', 'SBO:0000659'),
	('R_HMR_6397', 'SBO:0000200'),
	('R_FADRx2', 'SBO:0000200'),
	('R_ITKPK', 'SBO:0000216'),
	('R_MI3PS', 'SBO:0000377'),
	('R_HMR_6617', 'SBO:0000658'),
	('R_HMR_6619', 'SBO:0000658'),
	('R_HMR_8761', 'SBO:0000216'),
	('R_HMR_8776', 'SBO:0000658'),
	('R_HMR_9019', 'SBO:0000658'),
	('R_HMR_9174', 'SBO:0000658'),
	('R_HMR_9177', 'SBO:0000658'),
	('R_HMR_9178', 'SBO:0000658'),
	('R_HMR_9179', 'SBO:0000658'),
	('R_HMR_9185', 'SBO:0000658'),
	('R_HMR_9191', 'SBO:0000658'),
	('R_HMR_9583', 'SBO:0000658'),
	('R_HMR_9584', 'SBO:0000659'),
	('R_HMR_9602', 'SBO:0000659'),
	('R_HMR_9603', 'SBO:0000659'),
	('R_HMR_9613', 'SBO:0000659'),
	('R_HMR_9615', 'SBO:0000659'),
	('R_HMR_9620', 'SBO:0000659'),
	('R_HMR_9621', 'SBO:0000659'),
	('R_HMR_9627', 'SBO:0000658'),
	('R_HMR_9629', 'SBO:0000658'),
	('R_HMR_9630', 'SBO:0000658'),
	('R_HMR_9634', 'SBO:0000658'),
	('R_HMR_9639', 'SBO:0000658'),
	('R_HMR_9652', 'SBO:0000658'),
	('R_HMR_9657', 'SBO:0000658'),
	('R_HMR_9658', 'SBO:0000658'),
	('R_HMR_9662', 'SBO:0000658'),
	('R_DM_hdca6g_c', 'SBO:0000628'),
	('R_DM_hyochol_c', 'SBO:0000628'),
	('R_DM_isochol_c', 'SBO:0000628'),
	('R_DM_lca3s_c', 'SBO:0000628'),
	('R_DM_tca3s_c', 'SBO:0000628'),
	('R_DM_tdca3s_c', 'SBO:0000628'),
	('R_DM_tudca3s_c', 'SBO:0000628'),
	('R_EX_3dhcdchol_e', 'SBO:0000627'),
	('R_EX_3dhdchol_e', 'SBO:0000627'),
	('R_EX_7dhchol_e', 'SBO:0000627'),
	('R_EX_cdca3g_e', 'SBO:0000627'),
	('R_EX_dca24g_e', 'SBO:0000627'),
	('R_EX_dca3g_e', 'SBO:0000627'),
	('R_EX_gca3s_e', 'SBO:0000627'),
	('R_EX_gcdca3s_e', 'SBO:0000627'),
	('R_EX_gdca3s_e', 'SBO:0000627'),
	('R_EX_gudca3s_e', 'SBO:0000627'),
	('R_EX_hca24g_e', 'SBO:0000627'),
	('R_EX_hca6g_e', 'SBO:0000627'),
	('R_EX_hyochol_e', 'SBO:0000627'),
	('R_EX_isochol_e', 'SBO:0000627'),
	('R_EX_lca24g_e', 'SBO:0000627'),
	('R_EX_lca3s_e', 'SBO:0000627'),
	('R_EX_tcdca3s_e', 'SBO:0000627'),
	('R_EX_uchol_e', 'SBO:0000627'),
	('R_EX_udca3s_e', 'SBO:0000627'),
	('R_GCA3Sabc', 'SBO:0000657'),
	('R_GCDCA3St', 'SBO:0000660'),
	('R_GDCA3Sabc', 'SBO:0000657'),
	('R_GUDCA3Sabc', 'SBO:0000657'),
	('R_GUDCA3St', 'SBO:0000660'),
	('R_HCA24GSc', 'SBO:0000217'),
	('R_HCA24Gte', 'SBO:0000657'),
	('R_HCA6GSc', 'SBO:0000217'),
	('R_HCA6GSr', 'SBO:0000217'),
	('R_UCHOLt2', 'SBO:0000659'),
	('R_UDCHOLt2', 'SBO:0000659'),
	('R_12HTACRhr', 'SBO:0000200'),
	('R_12HTACRtu', 'SBO:0000657'),
	('R_1331TACRtev', 'SBO:0000658'),
	('R_14MDZtev', 'SBO:0000658'),
	('R_1513TACRtep', 'SBO:0000658'),
	('R_1531TACRteb', 'SBO:0000657'),
	('R_15DMTtep', 'SBO:0000658'),
	('R_1HIBUPGLUC_Sthv', 'SBO:0000658'),
	('R_1HIBUP_SGLUhep', 'SBO:0000217'),
	('R_1HMDZGLUChc', 'SBO:0000658'),
	('R_1OHMDZhr', 'SBO:0000200'),
	('R_1OHMDZtep', 'SBO:0000658'),
	('R_2HATVACIDGLUChr', 'SBO:0000217'),
	('R_2HATVACIDGLUCteb', 'SBO:0000657'),
	('R_2HATVACIDteb', 'SBO:0000657'),
	('R_2HATVACIDtep', 'SBO:0000658'),
	('R_2HATVLACteb', 'SBO:0000657'),
	('R_2HATVLACtep', 'SBO:0000658'),
	('R_2HIBUP_Rthv', 'SBO:0000658'),
	('R_2HIBUP_SGLUhep', 'SBO:0000217'),
	('R_2HIBUP_Sthv', 'SBO:0000658'),
	('R_35DSMVhep', 'SBO:0000200'),
	('R_35DSMVteb', 'SBO:0000657'),
	('R_3HIBUP_SGLUhep', 'SBO:0000217'),
	('R_3HPVSTETCOAhcm', 'SBO:0000200'),
	('R_3HPVSTETCOAhcx', 'SBO:0000200'),
	('R_6MSMVhep', 'SBO:0000200'),
	('R_6OHFVSGLUhc', 'SBO:0000217'),
	('R_6OHFVSteb', 'SBO:0000657'),
	('R_7AHGLZABCt', 'SBO:0000657'),
	('R_7AHGLZhr', 'SBO:0000200'),
	('R_7BHGLZhr', 'SBO:0000200'),
	('R_7BHGLZtev', 'SBO:0000658'),
	('R_7HPVShc', 'SBO:0000200'),
	('R_ACMPGLUTtep', 'SBO:0000657'),
	('R_ACMPGLUtep', 'SBO:0000657'),
	('R_ACMPdt', 'SBO:0000658'),
	('R_ACMPthc', 'SBO:0000657'),
	('R_EX_mdz_e', 'SBO:0000627'),
	('R_EX_mdzglc_e', 'SBO:0000627'),
	('R_EX_mhglz_e', 'SBO:0000627'),
	('R_EX_ndersv_e', 'SBO:0000627'),
	('R_EX_nfd_e', 'SBO:0000627'),
	('R_EX_nfdlac_e', 'SBO:0000627'),
	('R_EX_nfdnpy_e', 'SBO:0000627'),
	('R_EX_nfdoh_e', 'SBO:0000627'),
	('R_EX_oxy1rb_e', 'SBO:0000627'),
	('R_EX_oxy7rb_e', 'SBO:0000627'),
	('R_EX_profvs_e', 'SBO:0000627'),
	('R_EX_ptvst_e', 'SBO:0000627'),
	('R_EX_ptvstlac_e', 'SBO:0000627'),
	('R_EX_rsv_e', 'SBO:0000627'),
	('R_EX_rsvlac_e', 'SBO:0000627'),
	('R_EX_s3meacmp_e', 'SBO:0000627'),
	('R_EX_stacmp_e', 'SBO:0000627'),
	('R_EX_tauribup__S_e', 'SBO:0000627'),
	('R_EX_tlacfvs_e', 'SBO:0000627'),
	('R_EX_tmdm5_e', 'SBO:0000627'),
	('R_EX_tsacmgluc_e', 'SBO:0000627'),
	('R_EX_tsacmsul_e', 'SBO:0000627'),
	('R_FVSteb', 'SBO:0000657'),
	('R_FVStu', 'SBO:0000660'),
	('R_GLC3MEACPhr', 'SBO:0000217'),
	('R_GLC3MEACPtev', 'SBO:0000657'),
	('R_GLZtd', 'SBO:0000658'),
	('R_IBUPGLUCtchep', 'SBO:0000658'),
	('R_IBUPGLUCtpvb', 'SBO:0000657'),
	('R_IBUP_RCYP3hep', 'SBO:0000200'),
	('R_IBUP_Rtdhep', 'SBO:0000660'),
	('R_IBUP_SCYP3hep', 'SBO:0000200'),
	('R_IBUP_Stdhep', 'SBO:0000660'),
	('R_IBUP_Stdu', 'SBO:0000658'),
	('R_RSVGLUChc', 'SBO:0000217'),
	('R_RSVLACteb', 'SBO:0000657'),
	('R_RSVtev', 'SBO:0000658'),
	('R_SMVACIDATPteb', 'SBO:0000657'),
	('R_SMVACIDtev', 'SBO:0000658'),
	('R_SMVGLUChep', 'SBO:0000217'),
	('R_SMVthep', 'SBO:0000660'),
	('R_STACMPtev', 'SBO:0000657'),
	('R_TACRDtsc', 'SBO:0000658'),
	('R_TACRtu', 'SBO:0000657'),
	('R_TAURIBUP_Sthv', 'SBO:0000658'),
	('R_THSACMPhr', 'SBO:0000200'),
	('R_TMDM3hr', 'SBO:0000200'),
	('R_TMDOATPtsc', 'SBO:0000660'),
	('R_TMDOATthc', 'SBO:0000660'),
	('R_TRIPVStev', 'SBO:0000658'),
	('R_TSACMGLUChr', 'SBO:0000217'),
	('R_TSACMSULtev', 'SBO:0000657'),
	('R_12HTACRitr', 'SBO:0000658'),
	('R_14HMDZitr', 'SBO:0000658'),
	('R_1513TACRitr', 'SBO:0000658'),
	('R_1531TACRitr', 'SBO:0000658'),
	('R_1HIBUPGLUitr', 'SBO:0000658'),
	('R_1HMDGLUCitr', 'SBO:0000658'),
	('R_2HATVACIDGLUCitr', 'SBO:0000658'),
	('R_2HATVLACGLUCitr', 'SBO:0000658'),
	('R_2HIBUP_Ritr', 'SBO:0000658'),
	('R_35DHPVSitr', 'SBO:0000658'),
	('R_35DSMVitr', 'SBO:0000658'),
	('R_3HIBUP_Ritr', 'SBO:0000658'),
	('R_3HLVSTitr', 'SBO:0000658'),
	('R_3HPVSCOAitm', 'SBO:0000658'),
	('R_3HPVSCOAitx', 'SBO:0000658'),
	('R_3HSMVitr', 'SBO:0000658'),
	('R_4BHGLZitr', 'SBO:0000658'),
	('R_4HATVLACitr', 'SBO:0000658'),
	('R_4HMDGLUCitr', 'SBO:0000658'),
	('R_56DHPVSitr', 'SBO:0000658'),
	('R_5OHFVSitr', 'SBO:0000658'),
	('R_EX_rbl__D_e', 'SBO:0000627'),
	('R_EX_M01966_e', 'SBO:0000627'),
	('R_EX_M02155_e', 'SBO:0000627'),
	('R_EX_M01989_e', 'SBO:0000627'),
	('R_EX_M01881_e', 'SBO:0000627'),
	('R_EX_M03131_e', 'SBO:0000627'),
	('R_EX_n5m2masn_e', 'SBO:0000627'),
	('R_EX_hretn_e', 'SBO:0000627'),
	('R_SK_ile__L_c', 'SBO:0000632'),
	('R_SK_leu__L_c', 'SBO:0000632'),
	('R_SK_met__L_c', 'SBO:0000632'),
	('R_SK_phe__L_c', 'SBO:0000632'),
	('R_SK_trp__L_c', 'SBO:0000632'),
	('R_SK_asp__L_c', 'SBO:0000632'),
	('R_SK_cys__L_c', 'SBO:0000632'),
	('R_SK_gln__L_c', 'SBO:0000632'),
	('R_SK_glu__L_c', 'SBO:0000632'),
	('R_SK_ser__L_c', 'SBO:0000632'),
	('R_SK_gly_c', 'SBO:0000632'),
	('R_SK_4abut_l', 'SBO:0000632'),
	('R_DM_CE1261_c', 'SBO:0000628'),
	('R_DM_4glu56dihdind_c', 'SBO:0000628'),
	('R_DM_5cysdopa_c', 'SBO:0000628'),
	('R_DM_dopa_c', 'SBO:0000628'),
	('R_DM_ach_c', 'SBO:0000628'),
	('R_DM_hista_c', 'SBO:0000628'),
	('R_DM_kynate_c', 'SBO:0000628'),
	('R_DM_cbl2_m', 'SBO:0000628'),
	('R_DM_1a2425thvitd2_m', 'SBO:0000628'),
	('R_DM_btn_m', 'SBO:0000628'),
	('R_DM_btn_n', 'SBO:0000628'),
	('R_DCMPtm', 'SBO:0000658'),
	('R_DM_protein_c', 'SBO:0000628'),
	('R_Htmi', 'SBO:0000658'),
	('R_NADH2_u10mi', 'SBO:0000200'),
	('R_ALLOP1tu', 'SBO:0000659'),
	('R_ALLOPtepvb', 'SBO:0000658'),
	('R_AM19CSALThr', 'SBO:0000200'),
	('R_AM1ACStep', 'SBO:0000658'),
	('R_AM1CCStev', 'SBO:0000658'),
	('R_AM1CGLCteb', 'SBO:0000657'),
	('R_AM1CSAhr', 'SBO:0000200'),
	('R_AM4N9CShr', 'SBO:0000200'),
	('R_AM9CSAhr', 'SBO:0000200'),
	('R_AM9CSAteb', 'SBO:0000657'),
	('R_AM9CSAtep', 'SBO:0000658'),
	('R_ATVACIDMCTtu', 'SBO:0000659'),
	('R_ATVACYLGLUChc', 'SBO:0000217'),
	('R_ATVETHGLUChc', 'SBO:0000217'),
	('R_ATVLACThc', 'SBO:0000660'),
	('R_EX_3hpvstet_e', 'SBO:0000627'),
	('R_EX_3hsmvacid_e', 'SBO:0000627'),
	('R_EX_3ispvs_e', 'SBO:0000627'),
	('R_EX_4bhglz_e', 'SBO:0000627'),
	('R_EX_4hatvlac_e', 'SBO:0000627'),
	('R_EX_4ohmdz_e', 'SBO:0000627'),
	('R_EX_56eppvs_e', 'SBO:0000627'),
	('R_EX_5ohfvsglu_e', 'SBO:0000627'),
	('R_EX_6ahglz_e', 'SBO:0000627'),
	('R_EX_6bhglz_e', 'SBO:0000627'),
	('R_EX_6bhglzglc_e', 'SBO:0000627'),
	('R_EX_6csmvacid_e', 'SBO:0000627'),
	('R_EX_6hlvst_e', 'SBO:0000627'),
	('R_EX_6hsmvacid_e', 'SBO:0000627'),
	('R_EX_6melvacid_e', 'SBO:0000627'),
	('R_EX_6melvst_e', 'SBO:0000627'),
	('R_EX_6ohfvsglu_e', 'SBO:0000627'),
	('R_EX_7bhglzglc_e', 'SBO:0000627'),
	('R_EX_acmp_e', 'SBO:0000627'),
	('R_EX_acmpglu_e', 'SBO:0000627'),
	('R_EX_allop_e', 'SBO:0000627'),
	('R_EX_am1a4ncs_e', 'SBO:0000627'),
	('R_EX_am1accs_e', 'SBO:0000627'),
	('R_EX_am1acs_e', 'SBO:0000627'),
	('R_EX_am1c9cs_e', 'SBO:0000627'),
	('R_EX_am1ccs_e', 'SBO:0000627'),
	('R_EX_am4n9cs_e', 'SBO:0000627'),
	('R_EX_atvlac_e', 'SBO:0000627'),
	('R_EX_caribup_s_e', 'SBO:0000627'),
	('R_EX_caribupglu__S_e', 'SBO:0000627'),
	('R_EX_crglz_e', 'SBO:0000627'),
	('R_EX_crvsm1_e', 'SBO:0000627'),
	('R_EX_crvsm23_e', 'SBO:0000627'),
	('R_EX_csasulp_e', 'SBO:0000627'),
	('R_EX_cysacmp_e', 'SBO:0000627'),
	('R_EX_deoxfvs_e', 'SBO:0000627'),
	('R_EX_desfvs_e', 'SBO:0000627'),
	('R_EX_fvstet_e', 'SBO:0000627'),
	('R_EX_ibup__S_e', 'SBO:0000627'),
	('R_EX_lstn1gluc_e', 'SBO:0000627'),
	('R_EX_lstnm2_e', 'SBO:0000627'),
	('R_LSTN1GLUChr', 'SBO:0000217'),
	('R_LSTNM7TDhc', 'SBO:0000658'),
	('R_LSTNM7hr', 'SBO:0000217'),
	('R_LSTNtd', 'SBO:0000658'),
	('R_LVSTACIDtu', 'SBO:0000657'),
	('R_LVSTACOXD6Hhep', 'SBO:0000200'),
	('R_LVSTOXD6METhep', 'SBO:0000200'),
	('R_LVSTPGPtu', 'SBO:0000657'),
	('R_LVSTtu', 'SBO:0000658'),
	('R_MDZGLCtev', 'SBO:0000658'),
	('R_MDZtd', 'SBO:0000658'),
	('R_MERACMPtep', 'SBO:0000657'),
	('R_MHGLZABCt', 'SBO:0000657'),
	('R_MHGLZtev', 'SBO:0000658'),
	('R_NDERSVteb', 'SBO:0000657'),
	('R_NFDACOXDhc', 'SBO:0000200'),
	('R_NFDACtep', 'SBO:0000658'),
	('R_NFDLACtep', 'SBO:0000658'),
	('R_OXYPR7tehv', 'SBO:0000658'),
	('R_OXYPthc', 'SBO:0000658'),
	('R_OXYPtepv', 'SBO:0000659'),
	('R_PROFVSCOAhc', 'SBO:0000200'),
	('R_PTVSTGLUChc', 'SBO:0000217'),
	('R_PTVSTLACtev', 'SBO:0000658'),
	('R_PTVSTM3eb', 'SBO:0000657'),
	('R_PTVSTtu', 'SBO:0000660'),
	('R_PVSATPtu', 'SBO:0000657'),
	('R_PVSGLUChc', 'SBO:0000217'),
	('R_PVSGLUCteb', 'SBO:0000657'),
	('R_PVSHtu', 'SBO:0000659'),
	('R_PVSOATPtu', 'SBO:0000660'),
	('R_NFDACitr', 'SBO:0000658'),
	('R_ACMPGLUTitr', 'SBO:0000658'),
	('R_NAPQIhr', 'SBO:0000200'),
	('R_UDPRIBc', 'SBO:0000399'),
	('R_GLYitr', 'SBO:0000658'),
	('R_PAPitr', 'SBO:0000658'),
	('R_13DMTitr', 'SBO:0000658'),
	('R_15DMTitr', 'SBO:0000658'),
	('R_ATVACIDitr', 'SBO:0000658'),
	('R_ATVLACitr', 'SBO:0000658'),
	('R_31DMTitr', 'SBO:0000658'),
	('R_AM1CCSitr', 'SBO:0000658'),
	('R_LST4EXPitr', 'SBO:0000658'),
	('R_RSVitr', 'SBO:0000658'),
	('R_TRIPVSitr', 'SBO:0000658'),
	('R_SMVACIDitr', 'SBO:0000658'),
	('R_PTVSTitr', 'SBO:0000658'),
	('R_AM1CSAitr', 'SBO:0000658'),
	('R_1A25HVITD2tm', 'SBO:0000658'),
	('R_EX_C13856_e', 'SBO:0000627'),
	('R_EX_M02956_e', 'SBO:0000627'),
	('R_EX_M00241_e', 'SBO:0000627'),
	('R_EX_M00003_e', 'SBO:0000627'),
	('R_EX_M00010_e', 'SBO:0000627'),
	('R_EX_M00017_e', 'SBO:0000627'),
	('R_EX_M00021_e', 'SBO:0000627'),
	('R_EX_M00260_e', 'SBO:0000627'),
	('R_EX_M00265_e', 'SBO:0000627'),
	('R_EX_M01207_e', 'SBO:0000627'),
	('R_EX_M02613_e', 'SBO:0000627'),
	('R_EX_M03045_e', 'SBO:0000627'),
	('R_EX_M03051_e', 'SBO:0000627'),
	('R_EX_M03153_e', 'SBO:0000627'),
	('R_EX_M02561_e', 'SBO:0000627'),
	('R_EX_M02909_e', 'SBO:0000627'),
	('R_EX_M03117_e', 'SBO:0000627'),
	('R_EX_M01872_e', 'SBO:0000627'),
	('R_EX_hnifedipine_e', 'SBO:0000627'),
	('R_EX_M02449_e', 'SBO:0000627'),
	('R_EX_M02451_e', 'SBO:0000627'),
	('R_EX_adpman_e', 'SBO:0000627'),
	('R_FCOAH2', 'SBO:0000376'),
	('R_FOLt2_1', 'SBO:0000660'),
	('R_Htg', 'SBO:0000658'),
	('R_LEUKTRA4t', 'SBO:0000658'),
	('R_LPCHOLt', 'SBO:0000658'),
	('R_MAGt', 'SBO:0000658'),
	('R_MEPIVESSte_cho', 'SBO:0000657'),
	('R_NaKt_1', 'SBO:0000657'),
	('R_NRPPHRVESSEC_1', 'SBO:0000657'),
	('R_PEt', 'SBO:0000658'),
	('R_PNTOt5_1', 'SBO:0000657'),
	('R_PROSTGH2t', 'SBO:0000660'),
	('R_PROSTGI2tr', 'SBO:0000658'),
	('R_PSt3', 'SBO:0000658'),
	('R_RTOTAL2t', 'SBO:0000658'),
	('R_RTOTALt', 'SBO:0000658'),
	('R_SK_citr__L_c', 'SBO:0000632'),
	('R_SK_pre_prot_r', 'SBO:0000632'),
	('R_TAGt', 'SBO:0000658'),
	('R_THFt2_1', 'SBO:0000660'),
	('R_THMPPtm_cho', 'SBO:0000660'),
	('R_EX_ctp_e', 'SBO:0000627'),
	('R_EX_dtmp_e', 'SBO:0000627'),
	('R_EX_fad_e', 'SBO:0000627'),
	('R_EX_fald_e', 'SBO:0000627'),
	('R_EX_g1p_e', 'SBO:0000627'),
	('R_EX_HC01104_e', 'SBO:0000627'),
	('R_EX_HC01441_e', 'SBO:0000627'),
	('R_EX_HC01444_e', 'SBO:0000627'),
	('R_EX_HC01609_e', 'SBO:0000627'),
	('R_EX_cpppg1_e', 'SBO:0000627'),
	('R_EX_HC01700_e', 'SBO:0000627'),
	('R_EX_HC02161_e', 'SBO:0000627'),
	('R_EX_itp_e', 'SBO:0000627'),
	('R_EX_prpp_e', 'SBO:0000627'),
	('R_EX_pydx5p_e', 'SBO:0000627'),
	('R_r0002', 'SBO:0000658'),
	('R_GDRm', 'SBO:0000200'),
	('R_DPCOAKm', 'SBO:0000216'),
	('R_r0047', 'SBO:0000376'),
	('R_r0051', 'SBO:0000217'),
	('R_ALATA_Lm', 'SBO:0000403'),
	('R_r0084', 'SBO:0000200'),
	('R_r0085', 'SBO:0000401'),
	('R_PYK3', 'SBO:0000216'),
	('R_r0145', 'SBO:0000200'),
	('R_PYK4', 'SBO:0000216'),
	('R_r0157', 'SBO:0000403'),
	('R_r0809', 'SBO:0000660'),
	('R_r0173', 'SBO:0000200'),
	('R_r0179', 'SBO:0000200'),
	('R_r0186', 'SBO:0000178'),
	('R_r0205', 'SBO:0000660'),
	('R_DHFRim', 'SBO:0000200'),
	('R_DURADx', 'SBO:0000200'),
	('R_r0280', 'SBO:0000216'),
	('R_r0281', 'SBO:0000401'),
	('R_r0331', 'SBO:0000200'),
	('R_r0340', 'SBO:0000216'),
	('R_r0360', 'SBO:0000216'),
	('R_r0363', 'SBO:0000216'),
	('R_r0364', 'SBO:0000216'),
	('R_r0365', 'SBO:0000200'),
	('R_r0385', 'SBO:0000200'),
	('R_r0386', 'SBO:0000200'),
	('R_PYDXO_1', 'SBO:0000401'),
	('R_r0393', 'SBO:0000200'),
	('R_XAO2', 'SBO:0000200'),
	('R_r1003', 'SBO:0000660'),
	('R_AGPOP', 'SBO:0000216'),
	('R_r0423', 'SBO:0000200'),
	('R_r0424', 'SBO:0000200'),
	('R_r0450', 'SBO:0000403'),
	('R_XAND', 'SBO:0000200'),
	('R_XAO', 'SBO:0000200'),
	('R_r0512', 'SBO:0000200'),
	('R_r0525', 'SBO:0000200'),
	('R_NMNDA', 'SBO:0000376'),
	('R_DUTCP', 'SBO:0000216'),
	('R_CYSAMO_cho', 'SBO:0000200'),
	('R_r0541', 'SBO:0000399'),
	('R_r0548', 'SBO:0000200'),
	('R_DHRT_ibcoa', 'SBO:0000402'),
	('R_r0575', 'SBO:0000200'),
	('R_PTPATim', 'SBO:0000402'),
	('R_r0596', 'SBO:0000376'),
	('R_r0604', 'SBO:0000402'),
	('R_HPROym', 'SBO:0000200'),
	('R_ACOAR5m', 'SBO:0000200'),
	('R_r0641', 'SBO:0000376'),
	('R_r0643', 'SBO:0000200'),
	('R_r0649_1', 'SBO:0000399'),
	('R_r0652_1', 'SBO:0000200'),
	('R_r0673', 'SBO:0000200'),
	('R_r0686', 'SBO:0000200'),
	('R_r0707', 'SBO:0000376'),
	('R_r0714_1', 'SBO:0000200'),
	('R_r0715', 'SBO:0000200'),
	('R_HACD6p', 'SBO:0000200'),
	('R_HACD5m', 'SBO:0000200'),
	('R_HACD4m', 'SBO:0000200'),
	('R_HACD4p', 'SBO:0000200'),
	('R_r0733', 'SBO:0000200'),
	('R_ACOAR4m', 'SBO:0000200'),
	('R_r0739', 'SBO:0000200'),
	('R_r0741', 'SBO:0000200'),
	('R_r0747', 'SBO:0000200'),
	('R_r0752', 'SBO:0000200'),
	('R_r0753', 'SBO:0000200'),
	('R_r0754', 'SBO:0000200'),
	('R_r0757', 'SBO:0000200'),
	('R_r0783', 'SBO:0000200'),
	('R_ACOAR2m', 'SBO:0000200'),
	('R_r0796', 'SBO:0000200'),
	('R_r0813', 'SBO:0000660'),
	('R_r0817', 'SBO:0000658'),
	('R_r0818', 'SBO:0000658'),
	('R_SUCFUMtm', 'SBO:0000660'),
	('R_r0826', 'SBO:0000658'),
	('R_r0834', 'SBO:0000660'),
	('R_r0835', 'SBO:0000660'),
	('R_NH4tm', 'SBO:0000658'),
	('R_r0853', 'SBO:0000657'),
	('R_r0860', 'SBO:0000660'),
	('R_r0871', 'SBO:0000658'),
	('R_r0879', 'SBO:0000659'),
	('R_r0881', 'SBO:0000659'),
	('R_r0886', 'SBO:0000658'),
	('R_r0911', 'SBO:0000660'),
	('R_CITtcm', 'SBO:0000660'),
	('R_r0927', 'SBO:0000658'),
	('R_r0931', 'SBO:0000658'),
	('R_r0934', 'SBO:0000658'),
	('R_r0946', 'SBO:0000660'),
	('R_r0950', 'SBO:0000658'),
	('R_r0961', 'SBO:0000659'),
	('R_r0968', 'SBO:0000658'),
	('R_r0970', 'SBO:0000658'),
	('R_r0973', 'SBO:0000658'),
	('R_PNTOt4', 'SBO:0000659'),
	('R_r0990', 'SBO:0000658'),
	('R_r0993', 'SBO:0000657'),
	('R_r0995', 'SBO:0000660'),
	('R_r0998', 'SBO:0000660'),
	('R_r0999', 'SBO:0000660'),
	('R_r1000', 'SBO:0000660'),
	('R_r1006', 'SBO:0000660'),
	('R_r1011', 'SBO:0000658'),
	('R_r1012', 'SBO:0000660'),
	('R_r1015', 'SBO:0000659'),
	('R_r1018', 'SBO:0000658'),
	('R_r1019', 'SBO:0000658'),
	('R_r1020', 'SBO:0000658'),
	('R_r1024', 'SBO:0000660'),
	('R_r1025', 'SBO:0000660'),
	('R_r1026', 'SBO:0000657'),
	('R_r1030', 'SBO:0000658'),
	('R_CHOLESTTDe', 'SBO:0000658'),
	('R_r1052', 'SBO:0000658'),
	('R_r1078', 'SBO:0000658'),
	('R_r1106', 'SBO:0000658'),
	('R_r1109', 'SBO:0000178'),
	('R_r1116', 'SBO:0000657'),
	('R_r1135', 'SBO:0000200'),
	('R_r1146', 'SBO:0000399'),
	('R_AKGICITtm', 'SBO:0000660'),
	('R_OBDHm', 'SBO:0000200'),
	('R_DUTUP', 'SBO:0000216'),
	('R_r1159', 'SBO:0000658'),
	('R_r1299', 'SBO:0000658'),
	('R_r1301', 'SBO:0000658'),
	('R_r1302', 'SBO:0000658'),
	('R_r1303', 'SBO:0000658'),
	('R_r1318', 'SBO:0000658'),
	('R_r1367', 'SBO:0000658'),
	('R_r1368', 'SBO:0000658'),
	('R_r1380', 'SBO:0000200'),
	('R_r1401', 'SBO:0000660'),
	('R_HISt2m', 'SBO:0000659'),
	('R_GLY3Pt', 'SBO:0000658'),
	('R_METtm', 'SBO:0000658'),
	('R_thr_mt', 'SBO:0000658'),
	('R_r1454', 'SBO:0000660'),
	('R_r1457', 'SBO:0000200'),
	('R_r1459', 'SBO:0000658'),
	('R_r1472', 'SBO:0000200'),
	('R_r1477', 'SBO:0000200'),
	('R_r1500', 'SBO:0000659'),
	('R_r1501', 'SBO:0000659'),
	('R_r1512', 'SBO:0000658'),
	('R_r1514', 'SBO:0000657'),
	('R_r1516', 'SBO:0000657'),
	('R_r1517', 'SBO:0000657'),
	('R_r1521', 'SBO:0000657'),
	('R_r1522', 'SBO:0000657'),
	('R_r1523', 'SBO:0000657'),
	('R_r1527', 'SBO:0000657'),
	('R_r1529', 'SBO:0000657'),
	('R_r1532_1', 'SBO:0000657'),
	('R_HCO3_2NAt', 'SBO:0000659'),
	('R_r1544', 'SBO:0000660'),
	('R_r1546', 'SBO:0000660'),
	('R_r1551', 'SBO:0000660'),
	('R_r1559', 'SBO:0000660'),
	('R_r1563', 'SBO:0000660'),
	('R_r1566', 'SBO:0000660'),
	('R_r1569', 'SBO:0000660'),
	('R_r1570', 'SBO:0000660'),
	('R_r1573', 'SBO:0000660'),
	('R_r1574', 'SBO:0000660'),
	('R_r1575', 'SBO:0000660'),
	('R_r1576', 'SBO:0000660'),
	('R_r1580', 'SBO:0000660'),
	('R_r1583', 'SBO:0000660'),
	('R_r1592', 'SBO:0000660'),
	('R_r1596', 'SBO:0000660'),
	('R_r1598', 'SBO:0000660'),
	('R_r1599', 'SBO:0000660'),
	('R_r1600', 'SBO:0000660'),
	('R_r1602', 'SBO:0000660'),
	('R_r1605', 'SBO:0000660'),
	('R_r1606', 'SBO:0000660'),
	('R_r1607', 'SBO:0000660'),
	('R_r1608', 'SBO:0000660'),
	('R_r1609', 'SBO:0000660'),
	('R_r1614', 'SBO:0000660'),
	('R_LEUPHELAT2tc', 'SBO:0000660'),
	('R_r1625', 'SBO:0000660'),
	('R_r1627', 'SBO:0000660'),
	('R_r1628', 'SBO:0000660'),
	('R_r1633', 'SBO:0000660'),
	('R_r1635', 'SBO:0000660'),
	('R_r1636', 'SBO:0000660'),
	('R_r1638', 'SBO:0000660'),
	('R_r1639', 'SBO:0000660'),
	('R_r1640', 'SBO:0000660'),
	('R_r1642', 'SBO:0000660'),
	('R_r1643', 'SBO:0000660'),
	('R_VALLAT1tc', 'SBO:0000660'),
	('R_r1646', 'SBO:0000660'),
	('R_r1650', 'SBO:0000660'),
	('R_r1651', 'SBO:0000660'),
	('R_r1653', 'SBO:0000660'),
	('R_r1654', 'SBO:0000660'),
	('R_r1655', 'SBO:0000660'),
	('R_r1656', 'SBO:0000660'),
	('R_r1658', 'SBO:0000660'),
	('R_r1660', 'SBO:0000660'),
	('R_r1662', 'SBO:0000660'),
	('R_r1664', 'SBO:0000660'),
	('R_r1665', 'SBO:0000660'),
	('R_r1668', 'SBO:0000660'),
	('R_r1669', 'SBO:0000660'),
	('R_r1670', 'SBO:0000660'),
	('R_r1672', 'SBO:0000660'),
	('R_r1675', 'SBO:0000660'),
	('R_r1677', 'SBO:0000660'),
	('R_r1679', 'SBO:0000660'),
	('R_r1681', 'SBO:0000660'),
	('R_r1682', 'SBO:0000660'),
	('R_r1683', 'SBO:0000660'),
	('R_r1684', 'SBO:0000660'),
	('R_r1687', 'SBO:0000660'),
	('R_r1690', 'SBO:0000660'),
	('R_r1691', 'SBO:0000660'),
	('R_r1695', 'SBO:0000660'),
	('R_r1698', 'SBO:0000660'),
	('R_r1702', 'SBO:0000660'),
	('R_r1708', 'SBO:0000660'),
	('R_r1711', 'SBO:0000660'),
	('R_r1713', 'SBO:0000660'),
	('R_r1715', 'SBO:0000660'),
	('R_r1716', 'SBO:0000660'),
	('R_r1720', 'SBO:0000660'),
	('R_r1721', 'SBO:0000660'),
	('R_r1725', 'SBO:0000660'),
	('R_r1728', 'SBO:0000660'),
	('R_r1730', 'SBO:0000660'),
	('R_r1733', 'SBO:0000660'),
	('R_r1734', 'SBO:0000660'),
	('R_r1735', 'SBO:0000660'),
	('R_r1737', 'SBO:0000660'),
	('R_r1738', 'SBO:0000660'),
	('R_r1739', 'SBO:0000660'),
	('R_r1740', 'SBO:0000660'),
	('R_r1741', 'SBO:0000660'),
	('R_r1742', 'SBO:0000660'),
	('R_r1743', 'SBO:0000660'),
	('R_r1749', 'SBO:0000660'),
	('R_r1751', 'SBO:0000660'),
	('R_r1756', 'SBO:0000660'),
	('R_r1757', 'SBO:0000660'),
	('R_r1759', 'SBO:0000660'),
	('R_r1760', 'SBO:0000660'),
	('R_r1761', 'SBO:0000660'),
	('R_r1765', 'SBO:0000660'),
	('R_r1767', 'SBO:0000660'),
	('R_r1769', 'SBO:0000660'),
	('R_r1770', 'SBO:0000660'),
	('R_r1772', 'SBO:0000660'),
	('R_r1773', 'SBO:0000660'),
	('R_r1775', 'SBO:0000660'),
	('R_r1776', 'SBO:0000660'),
	('R_r1777', 'SBO:0000660'),
	('R_r1780', 'SBO:0000660'),
	('R_r1782', 'SBO:0000660'),
	('R_r1785', 'SBO:0000660'),
	('R_r1787', 'SBO:0000660'),
	('R_r1788', 'SBO:0000660'),
	('R_r1800', 'SBO:0000660'),
	('R_r1801', 'SBO:0000660'),
	('R_r1803', 'SBO:0000660'),
	('R_r1807', 'SBO:0000660'),
	('R_r1808', 'SBO:0000660'),
	('R_r1810', 'SBO:0000660'),
	('R_r1812', 'SBO:0000660'),
	('R_r1813', 'SBO:0000660'),
	('R_r1815', 'SBO:0000660'),
	('R_r1816', 'SBO:0000660'),
	('R_r1819', 'SBO:0000660'),
	('R_r1825', 'SBO:0000660'),
	('R_r1826', 'SBO:0000660'),
	('R_r1828', 'SBO:0000660'),
	('R_r1831', 'SBO:0000660'),
	('R_r1834', 'SBO:0000660'),
	('R_r1835', 'SBO:0000660'),
	('R_r1843', 'SBO:0000660'),
	('R_r1844', 'SBO:0000660'),
	('R_r1850', 'SBO:0000660'),
	('R_r1852', 'SBO:0000660'),
	('R_r1856', 'SBO:0000660'),
	('R_r1859', 'SBO:0000660'),
	('R_r1862', 'SBO:0000660'),
	('R_r1863', 'SBO:0000660'),
	('R_r1866', 'SBO:0000660'),
	('R_r1871', 'SBO:0000660'),
	('R_r1872', 'SBO:0000660'),
	('R_r1873', 'SBO:0000660'),
	('R_r1879', 'SBO:0000660'),
	('R_r1883', 'SBO:0000660'),
	('R_r1884', 'SBO:0000660'),
	('R_r1886', 'SBO:0000660'),
	('R_r1888', 'SBO:0000660'),
	('R_r1891', 'SBO:0000660'),
	('R_r1894', 'SBO:0000660'),
	('R_r1895', 'SBO:0000660'),
	('R_r1896', 'SBO:0000660'),
	('R_r1897', 'SBO:0000660'),
	('R_r1902', 'SBO:0000660'),
	('R_r1906', 'SBO:0000660'),
	('R_r1909', 'SBO:0000660'),
	('R_r1911', 'SBO:0000660'),
	('R_r1913', 'SBO:0000660'),
	('R_r1914', 'SBO:0000660'),
	('R_r1915', 'SBO:0000660'),
	('R_r1917', 'SBO:0000660'),
	('R_r1919', 'SBO:0000660'),
	('R_r1922', 'SBO:0000660'),
	('R_r1923', 'SBO:0000660'),
	('R_r1924', 'SBO:0000660'),
	('R_r1926', 'SBO:0000660'),
	('R_r1929', 'SBO:0000660'),
	('R_r1930', 'SBO:0000660'),
	('R_r1931', 'SBO:0000660'),
	('R_r1933', 'SBO:0000660'),
	('R_r1934', 'SBO:0000660'),
	('R_r1936', 'SBO:0000660'),
	('R_r1937', 'SBO:0000660'),
	('R_r1938', 'SBO:0000660'),
	('R_r1939', 'SBO:0000660'),
	('R_r1941', 'SBO:0000660'),
	('R_r1942', 'SBO:0000660'),
	('R_r1943', 'SBO:0000660'),
	('R_r1946', 'SBO:0000660'),
	('R_r1947', 'SBO:0000660'),
	('R_r1950', 'SBO:0000660'),
	('R_r1952', 'SBO:0000660'),
	('R_r1953', 'SBO:0000660'),
	('R_r1955', 'SBO:0000660'),
	('R_r1956', 'SBO:0000660'),
	('R_r1958', 'SBO:0000660'),
	('R_r1959', 'SBO:0000660'),
	('R_r1960', 'SBO:0000660'),
	('R_r1966', 'SBO:0000660'),
	('R_r1968', 'SBO:0000660'),
	('R_r1969', 'SBO:0000660'),
	('R_r1971', 'SBO:0000660'),
	('R_r1973', 'SBO:0000660'),
	('R_r1975', 'SBO:0000660'),
	('R_r1977', 'SBO:0000660'),
	('R_r1978', 'SBO:0000660'),
	('R_r1979', 'SBO:0000660'),
	('R_r1982', 'SBO:0000660'),
	('R_r1988', 'SBO:0000660'),
	('R_r1990', 'SBO:0000660'),
	('R_r1991', 'SBO:0000660'),
	('R_r1992', 'SBO:0000660'),
	('R_r1993', 'SBO:0000660'),
	('R_r1994', 'SBO:0000660'),
	('R_r1995', 'SBO:0000660'),
	('R_r1996', 'SBO:0000660'),
	('R_r1998', 'SBO:0000660'),
	('R_r1999', 'SBO:0000660'),
	('R_r2002', 'SBO:0000660'),
	('R_r2006', 'SBO:0000660'),
	('R_r2008', 'SBO:0000660'),
	('R_r2009', 'SBO:0000660'),
	('R_r2010', 'SBO:0000660'),
	('R_r2012', 'SBO:0000660'),
	('R_r2015', 'SBO:0000660'),
	('R_r2019', 'SBO:0000660'),
	('R_r2020', 'SBO:0000660'),
	('R_r2022', 'SBO:0000660'),
	('R_r2024', 'SBO:0000660'),
	('R_r2027', 'SBO:0000660'),
	('R_r2028', 'SBO:0000660'),
	('R_r2029', 'SBO:0000660'),
	('R_r2034', 'SBO:0000660'),
	('R_r2037', 'SBO:0000660'),
	('R_r2042', 'SBO:0000660'),
	('R_r2043', 'SBO:0000660'),
	('R_r2044', 'SBO:0000660'),
	('R_r2045', 'SBO:0000660'),
	('R_r2052', 'SBO:0000660'),
	('R_r2053', 'SBO:0000660'),
	('R_r2054', 'SBO:0000660'),
	('R_r2057', 'SBO:0000660'),
	('R_r2059', 'SBO:0000660'),
	('R_r2061', 'SBO:0000660'),
	('R_r2062', 'SBO:0000660'),
	('R_r2064', 'SBO:0000660'),
	('R_r2066', 'SBO:0000660'),
	('R_r2069', 'SBO:0000660'),
	('R_r2070', 'SBO:0000660'),
	('R_r2079', 'SBO:0000660'),
	('R_r2082', 'SBO:0000660'),
	('R_r2083', 'SBO:0000660'),
	('R_r2091', 'SBO:0000660'),
	('R_r2095', 'SBO:0000660'),
	('R_r2097', 'SBO:0000660'),
	('R_r2098', 'SBO:0000660'),
	('R_r2099', 'SBO:0000660'),
	('R_r2102', 'SBO:0000660'),
	('R_r2103', 'SBO:0000660'),
	('R_r2105', 'SBO:0000660'),
	('R_r2107', 'SBO:0000660'),
	('R_r2109', 'SBO:0000660'),
	('R_r2110', 'SBO:0000660'),
	('R_r2112', 'SBO:0000660'),
	('R_r2116', 'SBO:0000660'),
	('R_r2117', 'SBO:0000660'),
	('R_r2118', 'SBO:0000660'),
	('R_r2119', 'SBO:0000660'),
	('R_r2124', 'SBO:0000660'),
	('R_r2127', 'SBO:0000660'),
	('R_r2128', 'SBO:0000660'),
	('R_r2129', 'SBO:0000660'),
	('R_r2131', 'SBO:0000660'),
	('R_r2132', 'SBO:0000660'),
	('R_r2136', 'SBO:0000659'),
	('R_r2140', 'SBO:0000660'),
	('R_r2142', 'SBO:0000660'),
	('R_r2143', 'SBO:0000660'),
	('R_r2144', 'SBO:0000660'),
	('R_r2145', 'SBO:0000660'),
	('R_r2147', 'SBO:0000660'),
	('R_r2148', 'SBO:0000660'),
	('R_r2152', 'SBO:0000660'),
	('R_r2154', 'SBO:0000660'),
	('R_r2155', 'SBO:0000660'),
	('R_r2156', 'SBO:0000660'),
	('R_r2157', 'SBO:0000660'),
	('R_r2158', 'SBO:0000660'),
	('R_r2160', 'SBO:0000660'),
	('R_r2161', 'SBO:0000660'),
	('R_r2162', 'SBO:0000660'),
	('R_r2163', 'SBO:0000660'),
	('R_r2168', 'SBO:0000660'),
	('R_r2169', 'SBO:0000660'),
	('R_r2170', 'SBO:0000660'),
	('R_r2171', 'SBO:0000660'),
	('R_r2174', 'SBO:0000660'),
	('R_r2180', 'SBO:0000660'),
	('R_r2181', 'SBO:0000660'),
	('R_r2182', 'SBO:0000660'),
	('R_r2183', 'SBO:0000660'),
	('R_r2184', 'SBO:0000660'),
	('R_r2185', 'SBO:0000660'),
	('R_r2186', 'SBO:0000660'),
	('R_r2187', 'SBO:0000660'),
	('R_r2188', 'SBO:0000660'),
	('R_r2190', 'SBO:0000660'),
	('R_r2194', 'SBO:0000660'),
	('R_r2197', 'SBO:0000660'),
	('R_r2198', 'SBO:0000660'),
	('R_r2200', 'SBO:0000660'),
	('R_r2203', 'SBO:0000660'),
	('R_r2207', 'SBO:0000660'),
	('R_r2208', 'SBO:0000660'),
	('R_r2209', 'SBO:0000660'),
	('R_r2214', 'SBO:0000660'),
	('R_r2216', 'SBO:0000660'),
	('R_r2218', 'SBO:0000660'),
	('R_r2220', 'SBO:0000660'),
	('R_r2221', 'SBO:0000660'),
	('R_r2222', 'SBO:0000660'),
	('R_r2223', 'SBO:0000660'),
	('R_r2224', 'SBO:0000660'),
	('R_r2225', 'SBO:0000660'),
	('R_r2232', 'SBO:0000660'),
	('R_r2234', 'SBO:0000660'),
	('R_r2235', 'SBO:0000660'),
	('R_r2240', 'SBO:0000660'),
	('R_r2241', 'SBO:0000660'),
	('R_r2243', 'SBO:0000660'),
	('R_r2251', 'SBO:0000660'),
	('R_r2252', 'SBO:0000660'),
	('R_r2253', 'SBO:0000660'),
	('R_r2254', 'SBO:0000660'),
	('R_r2259', 'SBO:0000660'),
	('R_r2261', 'SBO:0000660'),
	('R_r2262', 'SBO:0000660'),
	('R_r2263', 'SBO:0000660'),
	('R_r2267', 'SBO:0000660'),
	('R_r2269', 'SBO:0000660'),
	('R_r2270', 'SBO:0000660'),
	('R_r2271', 'SBO:0000660'),
	('R_r2272', 'SBO:0000660'),
	('R_r2274', 'SBO:0000660'),
	('R_r2279', 'SBO:0000660'),
	('R_r2280', 'SBO:0000660'),
	('R_r2281', 'SBO:0000660'),
	('R_r2284', 'SBO:0000660'),
	('R_r2285', 'SBO:0000660'),
	('R_r2286', 'SBO:0000660'),
	('R_r2287', 'SBO:0000660'),
	('R_r2288', 'SBO:0000660'),
	('R_r2290', 'SBO:0000660'),
	('R_r2291', 'SBO:0000660'),
	('R_r2292', 'SBO:0000660'),
	('R_r2295', 'SBO:0000660'),
	('R_r2296', 'SBO:0000660'),
	('R_r2298', 'SBO:0000660'),
	('R_r2302', 'SBO:0000660'),
	('R_r2303', 'SBO:0000660'),
	('R_r2304', 'SBO:0000660'),
	('R_r2305', 'SBO:0000660'),
	('R_r2306', 'SBO:0000660'),
	('R_r2308', 'SBO:0000660'),
	('R_r2311', 'SBO:0000660'),
	('R_r2312', 'SBO:0000660'),
	('R_r2314', 'SBO:0000660'),
	('R_r2316', 'SBO:0000660'),
	('R_r2318', 'SBO:0000660'),
	('R_r2319', 'SBO:0000660'),
	('R_r2320', 'SBO:0000660'),
	('R_r2322', 'SBO:0000660'),
	('R_r2323', 'SBO:0000660'),
	('R_r2326', 'SBO:0000660'),
	('R_r2327', 'SBO:0000660'),
	('R_r2328', 'SBO:0000660'),
	('R_r2329', 'SBO:0000660'),
	('R_r2330', 'SBO:0000660'),
	('R_r2338', 'SBO:0000658'),
	('R_RE0565C', 'SBO:0000402'),
	('R_RE0566C', 'SBO:0000200'),
	('R_RE0571C', 'SBO:0000178'),
	('R_RE0574C', 'SBO:0000200'),
	('R_RE0576C_1', 'SBO:0000200'),
	('R_RE0581C', 'SBO:0000200'),
	('R_ECOAR', 'SBO:0000200'),
	('R_RE0688E', 'SBO:0000401'),
	('R_RE0827E', 'SBO:0000401'),
	('R_RE0828E', 'SBO:0000401'),
	('R_RE0935E', 'SBO:0000376'),
	('R_RE0944E', 'SBO:0000376'),
	('R_RE1096C', 'SBO:0000200'),
	('R_RE1266C_1', 'SBO:0000399'),
	('R_CYP2R1', 'SBO:0000233'),
	('R_RE1516M', 'SBO:0000200'),
	('R_RE3082X', 'SBO:0000200'),
	('R_RE3106C', 'SBO:0000200'),
	('R_RE3112C', 'SBO:0000200'),
	('R_RE3121C', 'SBO:0000200'),
	('R_RE3134C', 'SBO:0000200'),
	('R_CHLSTD78I', 'SBO:0000377'),
	('R_RE3151C', 'SBO:0000399'),
	('R_RE3152C', 'SBO:0000200'),
	('R_RE3154C', 'SBO:0000200'),
	('R_RE3161C', 'SBO:0000399'),
	('R_RE3162C', 'SBO:0000200'),
	('R_RE3164C', 'SBO:0000200'),
	('R_RE3166C', 'SBO:0000200'),
	('R_RE3171C', 'SBO:0000200'),
	('R_RE3173C', 'SBO:0000200'),
	('R_RE3177M', 'SBO:0000200'),
	('R_RE3430X', 'SBO:0000200'),
	('R_FAOXC123C102m', 'SBO:0000200'),
	('R_FAOXC120100m', 'SBO:0000200'),
	('R_FAOXC12C12OHm', 'SBO:0000200'),
	('R_FAOXC12DCTc', 'SBO:0000658'),
	('R_FAOXC141C121m', 'SBO:0000200'),
	('R_FAOXC141C121x', 'SBO:0000200'),
	('R_FAOXC142C142OHm', 'SBO:0000200'),
	('R_FAOXC140120x', 'SBO:0000200'),
	('R_FAOXC14DCC12DCx', 'SBO:0000200'),
	('R_FAOXC15C13m', 'SBO:0000200'),
	('R_FAOXC15NADPx', 'SBO:0000200'),
	('R_FAOXC162C142m', 'SBO:0000200'),
	('R_FAOXC163C143m', 'SBO:0000200'),
	('R_FAOXC163GC142m', 'SBO:0000200'),
	('R_FAOXC164GC163m', 'SBO:0000200'),
	('R_FAOXC165C164x', 'SBO:0000200'),
	('R_FAOXC160140m', 'SBO:0000200'),
	('R_EX_5hoxindoa_e', 'SBO:0000627'),
	('R_EX_cala_e', 'SBO:0000627'),
	('R_EX_cholp_e', 'SBO:0000627'),
	('R_EX_dmgly_e', 'SBO:0000627'),
	('R_EX_ethamp_e', 'SBO:0000627'),
	('R_EX_g3pc_e', 'SBO:0000627'),
	('R_EX_gudac_e', 'SBO:0000627'),
	('R_EX_hcys__L_e', 'SBO:0000627'),
	('R_EX_kynate_e', 'SBO:0000627'),
	('R_EX_L2aadp_e', 'SBO:0000627'),
	('R_EX_pep_e', 'SBO:0000627'),
	('R_EX_xtsn_e', 'SBO:0000627'),
	('R_EX_udpglcur_e', 'SBO:0000627'),
	('R_EX_hLkynr_e', 'SBO:0000627'),
	('R_EX_nicrnt_e', 'SBO:0000627'),
	('R_EX_orot5p_e', 'SBO:0000627'),
	('R_ALAB0AT3tc', 'SBO:0000659'),
	('R_ARGB0AT3tc', 'SBO:0000659'),
	('R_ASNB0AT3tc', 'SBO:0000659'),
	('R_BETBGTtc', 'SBO:0000659'),
	('R_CYSB0AT3tc', 'SBO:0000659'),
	('R_ESTROSABCCte', 'SBO:0000657'),
	('R_FOLOAT1tc', 'SBO:0000660'),
	('R_FOLOATPtc', 'SBO:0000660'),
	('R_GLNB0AT3tc', 'SBO:0000659'),
	('R_GSNt2', 'SBO:0000659'),
	('R_LEUKABCtc', 'SBO:0000657'),
	('R_PHEB0AT3tc', 'SBO:0000659'),
	('R_PSHSABCtc', 'SBO:0000657'),
	('R_EX_alaasnleu_e', 'SBO:0000627'),
	('R_EX_alalysthr_e', 'SBO:0000627'),
	('R_EX_argargmet_e', 'SBO:0000627'),
	('R_EX_argcysser_e', 'SBO:0000627'),
	('R_EX_arggluglu_e', 'SBO:0000627'),
	('R_EX_arghisthr_e', 'SBO:0000627'),
	('R_EX_argleuphe_e', 'SBO:0000627'),
	('R_EX_arglysasp_e', 'SBO:0000627'),
	('R_EX_argserser_e', 'SBO:0000627'),
	('R_EX_asnmetpro_e', 'SBO:0000627'),
	('R_EX_asntyrgly_e', 'SBO:0000627'),
	('R_EX_asntyrphe_e', 'SBO:0000627'),
	('R_EX_aspalaarg_e', 'SBO:0000627'),
	('R_EX_aspasnglu_e', 'SBO:0000627'),
	('R_EX_aspglutrp_e', 'SBO:0000627'),
	('R_EX_asphispro_e', 'SBO:0000627'),
	('R_EX_asplysglu_e', 'SBO:0000627'),
	('R_EX_asplyshis_e', 'SBO:0000627'),
	('R_EX_aspmetasp_e', 'SBO:0000627'),
	('R_EX_aspprolys_e', 'SBO:0000627'),
	('R_EX_cysasnmet_e', 'SBO:0000627'),
	('R_EX_cysaspphe_e', 'SBO:0000627'),
	('R_EX_cyscys_e', 'SBO:0000627'),
	('R_EX_cysglnmet_e', 'SBO:0000627'),
	('R_EX_cysgluhis_e', 'SBO:0000627'),
	('R_EX_cysglutrp_e', 'SBO:0000627'),
	('R_EX_cysleuthr_e', 'SBO:0000627'),
	('R_EX_glnhishis_e', 'SBO:0000627'),
	('R_EX_glnlyslys_e', 'SBO:0000627'),
	('R_EX_glnlystrp_e', 'SBO:0000627'),
	('R_EX_glntrpglu_e', 'SBO:0000627'),
	('R_EX_glntyrleu_e', 'SBO:0000627'),
	('R_EX_gluglu_e', 'SBO:0000627'),
	('R_EX_gluilelys_e', 'SBO:0000627'),
	('R_EX_gluleu_e', 'SBO:0000627'),
	('R_EX_glumet_e', 'SBO:0000627'),
	('R_EX_glumethis_e', 'SBO:0000627'),
	('R_EX_gluthr_e', 'SBO:0000627'),
	('R_EX_glyhislys_e', 'SBO:0000627'),
	('R_EX_glytyrlys_e', 'SBO:0000627'),
	('R_EX_hisargcys_e', 'SBO:0000627'),
	('R_SK_dgchol_c', 'SBO:0000632'),
	('R_SK_fe3_c', 'SBO:0000632'),
	('R_SK_gchola_c', 'SBO:0000632'),
	('R_SK_hdca_c', 'SBO:0000632'),
	('R_SK_lnlncacoa_c', 'SBO:0000632'),
	('R_SK_nadp_c', 'SBO:0000632'),
	('R_SK_odecoa_c', 'SBO:0000632'),
	('R_SK_phyQ_c', 'SBO:0000632'),
	('R_SK_pydam_c', 'SBO:0000632'),
	('R_SK_retfa_c', 'SBO:0000632'),
	('R_SK_stcoa_c', 'SBO:0000632'),
	('R_SK_tdchola_c', 'SBO:0000632'),
	('R_DM_thmpp_c', 'SBO:0000628'),
	('R_DM_thmtp_c', 'SBO:0000628'),
	('R_THCHOLSTOICt', 'SBO:0000659'),
	('R_XOL7AH3ATP', 'SBO:0000657'),
	('R_XOL7AH3t', 'SBO:0000659'),
	('R_EX_xol7ah3_e', 'SBO:0000627'),
	('R_SK_xol7ah3_c', 'SBO:0000632'),
	('R_XOL7AONEt', 'SBO:0000659'),
	('R_XOLDIOLONEATP', 'SBO:0000657'),
	('R_EX_xoldiolone_e', 'SBO:0000627'),
	('R_7KILTCHOLt', 'SBO:0000659'),
	('R_EX_7klitchol_e', 'SBO:0000627'),
	('R_SK_7klitchol_c', 'SBO:0000632'),
	('R_EX_2obut_e', 'SBO:0000627'),
	('R_EX_phpyr_e', 'SBO:0000627'),
	('R_EX_2hyoxplac_e', 'SBO:0000627'),
	('R_PHPYRte', 'SBO:0000659'),
	('R_3MOX4HOXMte', 'SBO:0000658'),
	('R_GLXt', 'SBO:0000658'),
	('R_EX_glx_e', 'SBO:0000627'),
	('R_CE4970te', 'SBO:0000659'),
	('R_EX_CE4970_e', 'SBO:0000627'),
	('R_CE2026te', 'SBO:0000659'),
	('R_ACTYRtc', 'SBO:0000658'),
	('R_ACTYRte', 'SBO:0000658'),
	('R_EX_actyr_e', 'SBO:0000627'),
	('R_SUCACETATALTc', 'SBO:0000200'),
	('R_SUCACETOc', 'SBO:0000399'),
	('R_EX_sucaceto_e', 'SBO:0000627'),
	('R_CE2176tm', 'SBO:0000658'),
	('R_NACVANALAtm', 'SBO:0000658'),
	('R_NACVANALAte', 'SBO:0000658'),
	('R_EX_nacvanala_e', 'SBO:0000627'),
	('R_EX_2h3mv_e', 'SBO:0000627'),
	('R_2M3HBUtm', 'SBO:0000658'),
	('R_2M3HBUte', 'SBO:0000658'),
	('R_2M3HVACc', 'SBO:0000200'),
	('R_3H3MGLTte', 'SBO:0000658'),
	('R_EX_3h3mglt_e', 'SBO:0000627'),
	('R_3MGLUTACte', 'SBO:0000658'),
	('R_EX_ppiogly_e', 'SBO:0000627'),
	('R_SBPP3', 'SBO:0000376'),
	('R_HMR_2740', 'SBO:0000660'),
	('R_HMR_2772', 'SBO:0000660'),
	('R_HMR_2775', 'SBO:0000660'),
	('R_HMR_2817', 'SBO:0000660'),
	('R_HMR_2821', 'SBO:0000660'),
	('R_HMR_2857', 'SBO:0000660'),
	('R_HMR_3113', 'SBO:0000200'),
	('R_HMR_9674', 'SBO:0000658'),
	('R_IND3ACtm', 'SBO:0000658'),
	('R_ACtp', 'SBO:0000658'),
	('R_HMR_9680', 'SBO:0000658'),
	('R_HMR_9716', 'SBO:0000658'),
	('R_HMR_9719', 'SBO:0000200'),
	('R_GLUN', 'SBO:0000401'),
	('R_HMR_0980', 'SBO:0000200'),
	('R_HMR_4772', 'SBO:0000399'),
	('R_EX_sbt__D_e', 'SBO:0000627'),
	('R_12DHCHOLt', 'SBO:0000660'),
	('R_12DHCHOLt2', 'SBO:0000659'),
	('R_3DHCDCHOLabc', 'SBO:0000657'),
	('R_3DHCDCHOLt', 'SBO:0000660'),
	('R_3DHCDCHOLt2', 'SBO:0000659'),
	('R_3DHDCAS', 'SBO:0000200'),
	('R_3DHDCAt', 'SBO:0000660'),
	('R_3DHLCAt', 'SBO:0000660'),
	('R_5OHFVSGLUitr', 'SBO:0000658'),
	('R_6HSMVitr', 'SBO:0000658'),
	('R_6OHFVSGLUitr', 'SBO:0000658'),
	('R_ACMPGLUitr', 'SBO:0000658'),
	('R_AM1ACCSitr', 'SBO:0000658'),
	('R_AM1C9CSitr', 'SBO:0000658'),
	('R_AM4N9CSitr', 'SBO:0000658'),
	('R_AM4NCSitr', 'SBO:0000658'),
	('R_CARIBUP_Sitr', 'SBO:0000658'),
	('R_CRGLZitr', 'SBO:0000658'),
	('R_CRVSitr', 'SBO:0000658'),
	('R_CRVSM24itr', 'SBO:0000658'),
	('R_CRVSM31itr', 'SBO:0000658'),
	('R_DESFVSitr', 'SBO:0000658'),
	('R_DSPVSitr', 'SBO:0000658'),
	('R_EPOXTACitr', 'SBO:0000658'),
	('R_FVSCOAitx', 'SBO:0000658'),
	('R_FVSTETitr', 'SBO:0000658'),
	('R_FVSTETGLUitr', 'SBO:0000658'),
	('R_IBUPGLUCitr', 'SBO:0000658'),
	('R_LSTNitr', 'SBO:0000658'),
	('R_LSTNM4itr', 'SBO:0000658'),
	('R_LVSTitr', 'SBO:0000658'),
	('R_EX_lvstacid_e', 'SBO:0000627'),
	('R_LVSTACIDitr', 'SBO:0000658'),
	('R_NFDNPYitr', 'SBO:0000658'),
	('R_PROFVSCOAitx', 'SBO:0000658'),
	('R_PTVSTLACitr', 'SBO:0000658'),
	('R_PTVSTM13te', 'SBO:0000658'),
	('R_EX_ptvstm13_e', 'SBO:0000627'),
	('R_PTVSTM3itr', 'SBO:0000658'),
	('R_PVSitr', 'SBO:0000658'),
	('R_RSVLACitr', 'SBO:0000658'),
	('R_TLACFVSitr', 'SBO:0000658'),
	('R_TMDM1itr', 'SBO:0000658'),
	('R_TMDM5itr', 'SBO:0000658'),
	('R_MDZGLChr', 'SBO:0000217'),
	('R_TMACMPhr', 'SBO:0000200'),
	('R_CYSACMPitr', 'SBO:0000658'),
	('R_ARTFR12', 'SBO:0000631'),
	('R_ARTFR202', 'SBO:0000631'),
	('R_ARTFR203', 'SBO:0000631'),
	('R_ARTFR204', 'SBO:0000631'),
	('R_ARTFR205', 'SBO:0000631'),
	('R_ARTFR206', 'SBO:0000631'),
	('R_ARTFR208', 'SBO:0000631'),
	('R_ARTFR209', 'SBO:0000631'),
	('R_ARTFR210', 'SBO:0000631'),
	('R_ARTFR211', 'SBO:0000631'),
	('R_ARTFR212', 'SBO:0000631'),
	('R_ARTFR213', 'SBO:0000631'),
	('R_ARTFR32', 'SBO:0000631'),
	('R_ARTFR33', 'SBO:0000631'),
	('R_ARTFR34', 'SBO:0000631'),
	('R_ARTFR41', 'SBO:0000631'),
	('R_ARTFR42', 'SBO:0000631'),
	('R_ARTFR43', 'SBO:0000631'),
	('R_ARTFR44', 'SBO:0000631'),
	('R_ARTFR45', 'SBO:0000631'),
	('R_ARTFR46', 'SBO:0000631'),
	('R_ARTFR53', 'SBO:0000631'),
	('R_ARTFR54', 'SBO:0000631'),
	('R_ARTFR55', 'SBO:0000631'),
	('R_ARTFR56', 'SBO:0000631'),
	('R_ARTFR57', 'SBO:0000631'),
	('R_ARTFR61', 'SBO:0000631');

--
-- Data for Name: ec_to_sbo; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO EC_to_SBO(ECnum, SBO_term) VALUES
-- Transamination
   ('2.6.1', 'SBO:0000403'),
-- Decarboxylation
   ('4.1.1', 'SBO:0000399'),
-- Glycosylation
   ('2.4', 'SBO:0000217'),
-- Methylation
   ('2.1.1', 'SBO:0000214'),
-- Sulfation
   ('2.8.2', 'SBO:0000220'),
-- Myristoylation
   ('2.3.1.155', 'SBO:0000219'),
   ('2.3.1.243', 'SBO:0000219'),
-- Farnesylation
   ('2.5.1.58', 'SBO:0000222'),
-- Geranylgeranylation
   ('2.5.1.116', 'SBO:0000223'),
   ('2.5.1.41', 'SBO:0000223'),
   ('2.5.1.42', 'SBO:0000223'),
   ('2.5.1.59', 'SBO:0000223'),
   ('2.5.1.60', 'SBO:0000223'),
-- Isomerisation
	('5', 'SBO:0000377'),
-- Hydrolysis
	('3', 'SBO:0000376'),
-- Redox
	('1', 'SBO:0000200'),
-- Transferases
	('2', 'SBO:0000402'), 
-- Lyases
	('4', 'SBO:0000178');

-- Add EC numbers for phosphorylation
INSERT INTO EC_to_SBO (ECnum, SBO_term) VALUES
	('2.7.1', 'SBO:0000216'),
	('2.7.2', 'SBO:0000216'),
	('2.7.3', 'SBO:0000216'),
	('2.7.4', 'SBO:0000216'),
	('2.7.10', 'SBO:0000216'),
	('2.7.11', 'SBO:0000216'),
	('2.7.12', 'SBO:0000216'),
	('2.7.13', 'SBO:0000216'),
	('2.7.14', 'SBO:0000216'),
	('2.7.99', 'SBO:0000216');
-- Add EC numbers for palmitoylation
INSERT INTO EC_to_SBO(ECnum, SBO_term) VALUES
	('2.3.1.21', 'SBO:0000218'),
	('2.3.1.50', 'SBO:0000218'),
	('2.3.1.96', 'SBO:0000218'),
	('2.3.1.100', 'SBO:0000218'),
	('2.3.1.251', 'SBO:0000218'),
	('2.3.1.291', 'SBO:0000218');
	
-- Add EC numbers for deamination
INSERT INTO EC_to_SBO(ECnum, SBO_term) VALUES
	('3.5.1.120', 'SBO:0000401'),
	('3.5.3.5', 'SBO:0000401'),
	('3.5.3.6', 'SBO:0000401'),
	('3.5.3.9', 'SBO:0000401'),
	('3.5.3.12', 'SBO:0000401'),
	('3.5.3.13', 'SBO:0000401'),
	('3.5.3.15', 'SBO:0000401'),
	('3.5.3.21', 'SBO:0000401'),
	('3.5.4.1', 'SBO:0000401'),
	('3.5.4.2', 'SBO:0000401'),
	('3.5.4.3', 'SBO:0000401'),
	('3.5.4.4', 'SBO:0000401'),
	('3.5.4.5', 'SBO:0000401'),
	('3.5.4.6', 'SBO:0000401'),
	('3.5.4.7', 'SBO:0000401'),
	('3.5.4.11', 'SBO:0000401'),
	('3.5.4.12', 'SBO:0000401'),
	('3.5.4.13', 'SBO:0000401'),
	('3.5.4.14', 'SBO:0000401'),
	('3.5.4.15', 'SBO:0000401'),
	('3.5.4.17', 'SBO:0000401'),
	('3.5.4.18', 'SBO:0000401'),
	('3.5.4.20', 'SBO:0000401'),
	('3.5.4.21', 'SBO:0000401'),
	('3.5.4.22', 'SBO:0000401'),
	('3.5.4.23', 'SBO:0000401'),
	('3.5.4.24', 'SBO:0000401'),
	('3.5.4.26', 'SBO:0000401'),
	('3.5.4.28', 'SBO:0000401'),
	('3.5.4.30', 'SBO:0000401'),
	('3.5.4.31', 'SBO:0000401'),
	('3.5.4.32', 'SBO:0000401'),
	('3.5.4.33', 'SBO:0000401'),
	('3.5.4.34', 'SBO:0000401'),
	('3.5.4.35', 'SBO:0000401'),
	('3.5.4.36', 'SBO:0000401'),
	('3.5.4.37', 'SBO:0000401'),
	('3.5.4.38', 'SBO:0000401'),
	('3.5.4.40', 'SBO:0000401'),
	('3.5.4.41', 'SBO:0000401'),
	('3.5.4.45', 'SBO:0000401'),
	('3.5.4.46', 'SBO:0000401'),
	('3.5.99.5', 'SBO:0000401'),
	('3.5.99.6', 'SBO:0000401'),
	('3.5.99.7', 'SBO:0000401'),
	('3.5.99.10', 'SBO:0000401'),
	('3.5.99.11', 'SBO:0000401');

-- Add EC numbers for acetylation
INSERT INTO EC_to_SBO(ECnum, SBO_term) VALUES
	('2.3.1.1', 'SBO:0000215'),
	('2.3.1.2', 'SBO:0000215'),
	('2.3.1.3', 'SBO:0000215'),
	('2.3.1.4', 'SBO:0000215'),
	('2.3.1.5', 'SBO:0000215'),
	('2.3.1.6', 'SBO:0000215'),
	('2.3.1.7', 'SBO:0000215'),
	('2.3.1.8', 'SBO:0000215'),
	('2.3.1.9', 'SBO:0000215'),
	('2.3.1.10', 'SBO:0000215'),
	('2.3.1.11', 'SBO:0000215'),
	('2.3.1.12', 'SBO:0000215'),
	('2.3.1.14', 'SBO:0000215'),
	('2.3.1.17', 'SBO:0000215'),
	('2.3.1.18', 'SBO:0000215'),
	('2.3.1.27', 'SBO:0000215'),
	('2.3.1.28', 'SBO:0000215'),
	('2.3.1.29', 'SBO:0000215'),
	('2.3.1.30', 'SBO:0000215'),
	('2.3.1.31', 'SBO:0000215'),
	('2.3.1.32', 'SBO:0000215'),
	('2.3.1.33', 'SBO:0000215'),
	('2.3.1.34', 'SBO:0000215'),
	('2.3.1.35', 'SBO:0000215'),
	('2.3.1.36', 'SBO:0000215'),
	('2.3.1.38', 'SBO:0000215'),
	('2.3.1.44', 'SBO:0000215'),
	('2.3.1.45', 'SBO:0000215'),
	('2.3.1.48', 'SBO:0000215'),
	('2.3.1.49', 'SBO:0000215'),
	('2.3.1.53', 'SBO:0000215'),
	('2.3.1.54', 'SBO:0000215'),
	('2.3.1.56', 'SBO:0000215'),
	('2.3.1.57', 'SBO:0000215'),
	('2.3.1.59', 'SBO:0000215'),
	('2.3.1.60', 'SBO:0000215'),
	('2.3.1.66', 'SBO:0000215'),
	('2.3.1.67', 'SBO:0000215'),
	('2.3.1.69', 'SBO:0000215'),
	('2.3.1.78', 'SBO:0000215'),
	('2.3.1.79', 'SBO:0000215'),
	('2.3.1.80', 'SBO:0000215'),
	('2.3.1.81', 'SBO:0000215'),
	('2.3.1.82', 'SBO:0000215'),
	('2.3.1.84', 'SBO:0000215'),
	('2.3.1.87', 'SBO:0000215'),
	('2.3.1.88', 'SBO:0000215'),
	('2.3.1.89', 'SBO:0000215'),
	('2.3.1.102', 'SBO:0000215'),
	('2.3.1.105', 'SBO:0000215'),
	('2.3.1.107', 'SBO:0000215'),
	('2.3.1.108', 'SBO:0000215'),
	('2.3.1.118', 'SBO:0000215'),
	('2.3.1.128', 'SBO:0000215'),
	('2.3.1.136', 'SBO:0000215'),
	('2.3.1.149', 'SBO:0000215'),
	('2.3.1.150', 'SBO:0000215'),
	('2.3.1.157', 'SBO:0000215'),
	('2.3.1.162', 'SBO:0000215'),
	('2.3.1.163', 'SBO:0000215'),
	('2.3.1.167', 'SBO:0000215'),
	('2.3.1.175', 'SBO:0000215'),
	('2.3.1.178', 'SBO:0000215'),
	('2.3.1.183', 'SBO:0000215'),
	('2.3.1.192', 'SBO:0000215'),
	('2.3.1.193', 'SBO:0000215'),
	('2.3.1.195', 'SBO:0000215'),
	('2.3.1.197', 'SBO:0000215'),
	('2.3.1.201', 'SBO:0000215'),
	('2.3.1.202', 'SBO:0000215'),
	('2.3.1.203', 'SBO:0000215'),
	('2.3.1.205', 'SBO:0000215'),
	('2.3.1.224', 'SBO:0000215'),
	('2.3.1.227', 'SBO:0000215'),
	('2.3.1.254', 'SBO:0000215'),
	('2.3.1.255', 'SBO:0000215'),
	('2.3.1.256', 'SBO:0000215'),
	('2.3.1.257', 'SBO:0000215'),
	('2.3.1.258', 'SBO:0000215'),
	('2.3.1.259', 'SBO:0000215'),
	('2.3.1.264', 'SBO:0000215'),
	('2.3.1.266', 'SBO:0000215'),
	('2.3.1.267', 'SBO:0000215'),
	('2.3.1.268', 'SBO:0000215'),
	('2.3.1.271', 'SBO:0000215'),
	('2.3.1.272', 'SBO:0000215'),
	('2.3.1.276', 'SBO:0000215'),
	('2.3.1.280', 'SBO:0000215'),
	('2.3.1.285', 'SBO:0000215'),
	('2.3.1.286', 'SBO:0000215'),
	('2.3.3.15', 'SBO:0000215');

-- Add EC numbers for hydroxylation
INSERT INTO EC_to_SBO(ECnum, SBO_term) VALUES
	('1.7.3.3', 'SBO:0000233'),
	('1.14.11.20', 'SBO:0000233'),
	('1.14.11.26', 'SBO:0000233'),
	('1.14.11.28', 'SBO:0000233'),
	('1.14.11.35', 'SBO:0000233'),
	('1.14.11.39', 'SBO:0000233'),
	('1.14.11.40', 'SBO:0000233'),
	('1.14.11.41', 'SBO:0000233'),
	('1.14.11.42', 'SBO:0000233'),
	('1.14.11.45', 'SBO:0000233'),
	('1.14.11.47', 'SBO:0000233'),
	('1.14.11.55', 'SBO:0000233'),
	('1.14.11.56', 'SBO:0000233'),
	('1.14.11.57', 'SBO:0000233'),
	('1.14.11.58', 'SBO:0000233'),
	('1.14.11.60', 'SBO:0000233'),
	('1.14.11.61', 'SBO:0000233'),
	('1.14.11.62', 'SBO:0000233'),
	('1.14.13.52', 'SBO:0000233'),
	('1.14.13.53', 'SBO:0000233'),
	('1.14.13.63', 'SBO:0000233'),
	('1.14.13.64', 'SBO:0000233'),
	('1.14.13.73', 'SBO:0000233'),
	('1.14.13.74', 'SBO:0000233'),
	('1.14.13.75', 'SBO:0000233'),
	('1.14.13.76', 'SBO:0000233'),
	('1.14.13.77', 'SBO:0000233'),
	('1.14.13.88', 'SBO:0000233'),
	('1.14.13.89', 'SBO:0000233'),
	('1.14.13.91', 'SBO:0000233'),
	('1.14.13.93', 'SBO:0000233'),
	('1.14.13.94', 'SBO:0000233'),
	('1.14.13.95', 'SBO:0000233'),
	('1.14.13.96', 'SBO:0000233'),
	('1.14.13.97', 'SBO:0000233'),
	('1.14.13.98', 'SBO:0000233'),
	('1.14.13.99', 'SBO:0000233'),
	('1.14.13.100', 'SBO:0000233'),
	('1.14.13.103', 'SBO:0000233'),
	('1.14.13.108', 'SBO:0000233'),
	('1.14.13.109', 'SBO:0000233'),
	('1.14.13.110', 'SBO:0000233'),
	('1.14.13.113', 'SBO:0000233'),
	('1.14.13.116', 'SBO:0000233'),
	('1.14.13.119', 'SBO:0000233'),
	('1.14.13.123', 'SBO:0000233'),
	('1.14.13.126', 'SBO:0000233'),
	('1.14.13.127', 'SBO:0000233'),
	('1.14.13.129', 'SBO:0000233'),
	('1.14.13.135', 'SBO:0000233'),
	('1.14.13.143', 'SBO:0000233'),
	('1.14.13.145', 'SBO:0000233'),
	('1.14.13.146', 'SBO:0000233'),
	('1.14.13.147', 'SBO:0000233'),
	('1.14.13.150', 'SBO:0000233'),
	('1.14.13.152', 'SBO:0000233'),
	('1.14.13.153', 'SBO:0000233'),
	('1.14.13.154', 'SBO:0000233'),
	('1.14.13.159', 'SBO:0000233'),
	('1.14.13.161', 'SBO:0000233'),
	('1.14.13.172', 'SBO:0000233'),
	('1.14.13.174', 'SBO:0000233'),
	('1.14.13.176', 'SBO:0000233'),
	('1.14.13.180', 'SBO:0000233'),
	('1.14.13.181', 'SBO:0000233'),
	('1.14.13.183', 'SBO:0000233'),
	('1.14.13.184', 'SBO:0000233'),
	('1.14.13.188', 'SBO:0000233'),
	('1.14.13.189', 'SBO:0000233'),
	('1.14.13.191', 'SBO:0000233'),
	('1.14.13.194', 'SBO:0000233'),
	('1.14.13.197', 'SBO:0000233'),
	('1.14.13.198', 'SBO:0000233'),
	('1.14.13.199', 'SBO:0000233'),
	('1.14.13.209', 'SBO:0000233'),
	('1.14.13.214', 'SBO:0000233'),
	('1.14.13.219', 'SBO:0000233'),
	('1.14.13.220', 'SBO:0000233'),
	('1.14.13.228', 'SBO:0000233'),
	('1.14.13.240', 'SBO:0000233'),
	('1.14.14.24', 'SBO:0000233'),
	('1.14.14.25', 'SBO:0000233'),
	('1.14.14.26', 'SBO:0000233'),
	('1.14.14.27', 'SBO:0000233'),
	('1.14.14.29', 'SBO:0000233'),
	('1.14.14.48', 'SBO:0000233'),
	('1.14.14.49', 'SBO:0000233'),
	('1.14.14.54', 'SBO:0000233'),
	('1.14.14.57', 'SBO:0000233'),
	('1.14.14.69', 'SBO:0000233'),
	('1.14.14.70', 'SBO:0000233'),
	('1.14.14.71', 'SBO:0000233'),
	('1.14.14.76', 'SBO:0000233'),
	('1.14.14.78', 'SBO:0000233'),
	('1.14.14.79', 'SBO:0000233'),
	('1.14.14.81', 'SBO:0000233'),
	('1.14.14.83', 'SBO:0000233'),
	('1.14.14.85', 'SBO:0000233'),
	('1.14.14.88', 'SBO:0000233'),
	('1.14.14.89', 'SBO:0000233'),
	('1.14.14.90', 'SBO:0000233'),
	('1.14.14.95', 'SBO:0000233'),
	('1.14.14.103', 'SBO:0000233'),
	('1.14.14.104', 'SBO:0000233'),
	('1.14.14.105', 'SBO:0000233'),
	('1.14.14.106', 'SBO:0000233'),
	('1.14.14.112', 'SBO:0000233'),
	('1.14.14.113', 'SBO:0000233'),
	('1.14.14.116', 'SBO:0000233'),
	('1.14.14.118', 'SBO:0000233'),
	('1.14.14.120', 'SBO:0000233'),
	('1.14.14.121', 'SBO:0000233'),
	('1.14.14.124', 'SBO:0000233'),
	('1.14.14.125', 'SBO:0000233'),
	('1.14.14.132', 'SBO:0000233'),
	('1.14.14.134', 'SBO:0000233'),
	('1.14.14.136', 'SBO:0000233'),
	('1.14.14.137', 'SBO:0000233'),
	('1.14.14.138', 'SBO:0000233'),
	('1.14.14.139', 'SBO:0000233'),
	('1.14.14.142', 'SBO:0000233'),
	('1.14.14.144', 'SBO:0000233'),
	('1.14.14.145', 'SBO:0000233'),
	('1.14.14.146', 'SBO:0000233'),
	('1.14.14.149', 'SBO:0000233'),
	('1.14.14.158', 'SBO:0000233'),
	('1.14.14.162', 'SBO:0000233'),
	('1.14.14.163', 'SBO:0000233'),
	('1.14.14.164', 'SBO:0000233'),
	('1.14.14.165', 'SBO:0000233'),
	('1.14.14.166', 'SBO:0000233'),
	('1.14.14.167', 'SBO:0000233'),
	('1.14.14.168', 'SBO:0000233'),
	('1.14.14.171', 'SBO:0000233'),
	('1.14.15.10', 'SBO:0000233'),
	('1.14.15.14', 'SBO:0000233'),
	('1.14.15.16', 'SBO:0000233'),
	('1.14.15.19', 'SBO:0000233'),
	('1.14.15.22', 'SBO:0000233'),
	('1.14.15.24', 'SBO:0000233'),
	('1.14.15.27', 'SBO:0000233'),
	('1.14.15.31', 'SBO:0000233'),
	('1.14.15.35', 'SBO:0000233'),
	('1.14.18.6', 'SBO:0000233'),
	('1.14.18.7', 'SBO:0000233'),
	('1.14.18.8', 'SBO:0000233'),
	('1.14.99.2', 'SBO:0000233'),
	('1.14.99.37', 'SBO:0000233'),
	('1.14.99.38', 'SBO:0000233'),
	('1.14.99.43', 'SBO:0000233'),
	('1.14.99.47', 'SBO:0000233'),
	('1.14.99.49', 'SBO:0000233'),
	('1.14.99.60', 'SBO:0000233'),
	('1.14.99.65', 'SBO:0000233'),
	('1.17.2.2', 'SBO:0000233'),
	('1.17.3.4', 'SBO:0000233'),
	('1.17.98.2', 'SBO:0000233'),
	('1.17.99.2', 'SBO:0000233'),
	('1.17.99.3', 'SBO:0000233');

--
-- Data for Name: media; Type: TABLE DATA; Schema: public; Owner: -
--
INSERT INTO media(medium, medium_description) VALUES
	('LB', 'Lysogeny broth'),
	('M9', 'M9 minimal medium'),
	('SNM3', 'Synthetic Nasal Medium Version 3'),
	('RPMI', 'Roswell Park Memorial Institute 1640 Medium'),
	('CGXII', 'Corynebacterium glutamicum optimized growth medium'),
	('CasA', 'Casamino Acids'),
	('Blood', 'Blood medium'),
	('MP-AU', 'Multi-Purpose Artificial Urine'),
	('dGMM', 'Defined Gut Microbiota Medium');

--
-- Data for Name: media_compositions; Type: TABLE DATA; Schema: public; Owner: -
--
INSERT INTO media_compositions(BiGG, substance, medium_id) VALUES
-- LB medium
	-- LB: Carbohydrates
	('glc__D', 'D-Glucose', (SELECT id from media WHERE medium='LB')),
	-- LB: Amino acids
	('ala__L',	'L-Alanine', (SELECT id from media WHERE medium='LB')),
	('asp__L', 'L-Aspartate', (SELECT id from media WHERE medium='LB')),
	('glu__L', 'L-Glutamate', (SELECT id from media WHERE medium='LB')),
	('his__L', 'L-Histidine', (SELECT id from media WHERE medium='LB')),
	('leu__L', 'L-Leucine', (SELECT id from media WHERE medium='LB')),
	('met__L', 'L-Methionine', (SELECT id from media WHERE medium='LB')),
	('pro__L', 'L-Proline', (SELECT id from media WHERE medium='LB')),
	('thr__L', 'L-Threonine', (SELECT id from media WHERE medium='LB')),
	('tyr__L', 'L-Tyrosine', (SELECT id from media WHERE medium='LB')),
	('arg__L', 'L-Arginine', (SELECT id from media WHERE medium='LB')),
	('cys__L', 'L-Cysteine', (SELECT id from media WHERE medium='LB')),
	('gly', 'Glycine', (SELECT id from media WHERE medium='LB')),
	('ile__L', 'L-Isoleucine', (SELECT id from media WHERE medium='LB')),
	('lys__L', 'L-Lysine', (SELECT id from media WHERE medium='LB')),
	('phe__L', 'L-Phenylalanine', (SELECT id from media WHERE medium='LB')),
	('ser__L', 'L-Serine', (SELECT id from media WHERE medium='LB')),
	('trp__L', 'L-Tryptophan', (SELECT id from media WHERE medium='LB')),
	('val__L', 'L-Valine', (SELECT id from media WHERE medium='LB')),
	-- LB: Vitamins
	('thm', 'Thiamin', (SELECT id from media WHERE medium='LB')),
	('ribflv', 'Riboflavin', (SELECT id from media WHERE medium='LB')),
	('pnto__R', 'R-Pantothenate', (SELECT id from media WHERE medium='LB')),
	('pydx', 'Pyridoxine', (SELECT id from media WHERE medium='LB')),
	('btn', 'Biotin', (SELECT id from media WHERE medium='LB')),
	('fol', 'Folate', (SELECT id from media WHERE medium='LB')),
	('cbl1', 'Vitamin B12', (SELECT id from media WHERE medium='LB')),
	('cbl2', 'Vitamin B12', (SELECT id from media WHERE medium='LB')),
	('b12', 'Vitamin B12', (SELECT id from media WHERE medium='LB')),
	-- LB: Other chemicals
	('na1', 'Sodium; Na+', (SELECT id from media WHERE medium='LB')),
	('cl', 'Chloride; Cl-', (SELECT id from media WHERE medium='LB')),
	('so4', 'Sulfate', (SELECT id from media WHERE medium='LB')),
	('k', 'Potassium; K+', (SELECT id from media WHERE medium='LB')),
	('pi', 'Phosphate', (SELECT id from media WHERE medium='LB')),
	('ca2', 'Calcium; Ca2+', (SELECT id from media WHERE medium='LB')),
	('mg2', 'Magnesium', (SELECT id from media WHERE medium='LB')),
	(NULL, 'Selenium', (SELECT id from media WHERE medium='LB')),
	('zn2', 'Zinc; Zn2+', (SELECT id from media WHERE medium='LB')),
	('aso3', 'Arsenite; should be Arsenic', (SELECT id from media WHERE medium='LB')),
	('cd2', 'Cadmium', (SELECT id from media WHERE medium='LB')),
	('hg2', 'Mercury; Hg2+', (SELECT id from media WHERE medium='LB')),
	(NULL, 'Lead', (SELECT id from media WHERE medium='LB')),
	-- LB: Nucleotides/nucleosides
	('ins', 'Inosine', (SELECT id from media WHERE medium='LB')),
	('hxan', 'Hypoxanthine', (SELECT id from media WHERE medium='LB')),
	('dcyt', 'Deoxycytidine', (SELECT id from media WHERE medium='LB')),
	('thymd', 'Thymidine', (SELECT id from media WHERE medium='LB')),
	('ura', 'Uracil', (SELECT id from media WHERE medium='LB')),
	('uri', 'Uridine', (SELECT id from media WHERE medium='LB')),
	('dad_2', 'Deoxyadenosine', (SELECT id from media WHERE medium='LB')),
	('adn', 'Adenosine', (SELECT id from media WHERE medium='LB')),
	('chor', 'Chorismate', (SELECT id from media WHERE medium='LB')),
	-- LB: Standard metabolites
	('o2', 'O2', (SELECT id from media WHERE medium='LB')),
	('h', 'H+', (SELECT id from media WHERE medium='LB')),
	('h2o', 'H2O', (SELECT id from media WHERE medium='LB')),
	-- LB: From CarveMe definition
	('amp', 'AMP', (SELECT id from media WHERE medium='LB')),
	('cmp', 'CMP', (SELECT id from media WHERE medium='LB')),
	('cro4', 'Chromate', (SELECT id from media WHERE medium='LB')),
	('cobalt2', 'Co2+', (SELECT id from media WHERE medium='LB')),
	('cu2', 'Cu2+', (SELECT id from media WHERE medium='LB')),
	('fe2', 'Fe2+', (SELECT id from media WHERE medium='LB')),
	('fe3', 'Fe3+', (SELECT id from media WHERE medium='LB')),
	('gmp', 'GMP', (SELECT id from media WHERE medium='LB')),
	('gsn', 'Guanosine', (SELECT id from media WHERE medium='LB')),
	('h2s', 'Hydrogen sulfide', (SELECT id from media WHERE medium='LB')),
	('lipoate', 'Lipoate', (SELECT id from media WHERE medium='LB')),
	('mn2', 'Mn2+', (SELECT id from media WHERE medium='LB')),
	('mobd', 'Molybdate', (SELECT id from media WHERE medium='LB')),
	('nac', 'Nicotinic acid', (SELECT id from media WHERE medium='LB')),
	('nh4', 'Ammonium', (SELECT id from media WHERE medium='LB')),
	('ni2', 'Ni2+', (SELECT id from media WHERE medium='LB')),
	('pheme', 'Protoheme', (SELECT id from media WHERE medium='LB')),
	('ump', 'UMP', (SELECT id from media WHERE medium='LB')),
-- M9
	('ca2', 'Ca2+', (SELECT id from media WHERE medium='M9')),
	('cl', 'Cl-', (SELECT id from media WHERE medium='M9')),
	('glc__D', 'D-Glucose', (SELECT id from media WHERE medium='M9')),
	('h2o', 'H2O', (SELECT id from media WHERE medium='M9')),
	('h', 'H+', (SELECT id from media WHERE medium='M9')),
	('k', 'K+', (SELECT id from media WHERE medium='M9')),
	('mg2', 'Mg', (SELECT id from media WHERE medium='M9')),
	('na1', 'Na+', (SELECT id from media WHERE medium='M9')),
	('nh4', 'Ammonium', (SELECT id from media WHERE medium='M9')),
	('o2', 'O2', (SELECT id from media WHERE medium='M9')),
	('pi', 'Phosphate', (SELECT id from media WHERE medium='M9')),
	('so4', 'Sulfate', (SELECT id from media WHERE medium='M9')),
-- SNM3
	('ala__L', 'Alanine', (SELECT id from media WHERE medium='SNM3')),
	('arg__L', 'Arginine', (SELECT id from media WHERE medium='SNM3')),
	('cys__L', 'Cysteine', (SELECT id from media WHERE medium='SNM3')),
	('glu__L', 'Glutamate [Glutamic acid]', (SELECT id from media WHERE medium='SNM3')),
	('gly', 'Glycine', (SELECT id from media WHERE medium='SNM3')),
	('his__L', 'Histidine', (SELECT id from media WHERE medium='SNM3')),
	('leu__L', 'Leucine', (SELECT id from media WHERE medium='SNM3')),
	('lys__L', 'Lysine', (SELECT id from media WHERE medium='SNM3')),
	('orn', 'Ornithine', (SELECT id from media WHERE medium='SNM3')),
	('phe__L', 'Phenylalanine', (SELECT id from media WHERE medium='SNM3')),
	('pro__L', 'Proline', (SELECT id from media WHERE medium='SNM3')),
	('ser__L', 'Serine', (SELECT id from media WHERE medium='SNM3')),
	('thr__L', 'Threonine', (SELECT id from media WHERE medium='SNM3')),
	('trp__L', 'Tryptophane', (SELECT id from media WHERE medium='SNM3')),
	('val__L', 'Valine', (SELECT id from media WHERE medium='SNM3')),
	('cit', 'Citrate [Citric acid]', (SELECT id from media WHERE medium='SNM3')),
	('fum', 'Fumarate [Fumaric acid]', (SELECT id from media WHERE medium='SNM3')),
	('male', 'Malate [Maleic acid]', (SELECT id from media WHERE medium='SNM3')),
	('pyr', 'Pyruvate [Pyruvic acid]', (SELECT id from media WHERE medium='SNM3')),
	('succ', 'Succinate [Succinic acid]', (SELECT id from media WHERE medium='SNM3')),
	('glc__D', 'Glucose', (SELECT id from media WHERE medium='SNM3')),
	('glc__bD', 'Glucose', (SELECT id from media WHERE medium='SNM3')),
	('urea', 'Urea', (SELECT id from media WHERE medium='SNM3')),
	('na1', 'Sodium', (SELECT id from media WHERE medium='SNM3')),
	('cl', 'Chloride', (SELECT id from media WHERE medium='SNM3')),
	('k', 'Potassium', (SELECT id from media WHERE medium='SNM3')),
	('pi', 'Phosphate', (SELECT id from media WHERE medium='SNM3')),
	('mg2', 'Magnesium', (SELECT id from media WHERE medium='SNM3')),
	('so4', 'Sulphate', (SELECT id from media WHERE medium='SNM3')),
	(NULL, '2,2-Bipyridine', (SELECT id from media WHERE medium='SNM3')),
	('ca2', 'Calcium', (SELECT id from media WHERE medium='SNM3')),
	('zn2', 'Zinc [ZnCl2]', (SELECT id from media WHERE medium='SNM3')),
	('mn2', 'Manganese [MnCl2]', (SELECT id from media WHERE medium='SNM3')),
	(NULL, 'H3BO3', (SELECT id from media WHERE medium='SNM3')),
	('cobalt2', 'Co2+ [CoCl2]', (SELECT id from media WHERE medium='SNM3')),
	('cu2', 'Copper [CuCl2]', (SELECT id from media WHERE medium='SNM3')),
	('ni2', 'Nickel [NiCl2]', (SELECT id from media WHERE medium='SNM3')),
	('mobd', 'Molybdate [MoNa2O4]', (SELECT id from media WHERE medium='SNM3')),
	('cbl1', 'Cob(I)alamin [Cyanocobalamine]', (SELECT id from media WHERE medium='SNM3')),
	('cbl2', 'Cob(II)alamin [Cyanocobalamine]', (SELECT id from media WHERE medium='SNM3')),
	('b12', 'Vitamin B12 [Cyanocobalamine]', (SELECT id from media WHERE medium='SNM3')),
	('4abz', '4-Aminobenzoate [p-Aminobenzoic acid]', (SELECT id from media WHERE medium='SNM3')),
	('btn', 'Biotin', (SELECT id from media WHERE medium='SNM3')),
	('nac', 'Nicotinate [Nicotinic acid]', (SELECT id from media WHERE medium='SNM3')),
	('pnto__R', '(R)-Pantothenate [Ca-D-Pantothenic acid]', (SELECT id from media WHERE medium='SNM3')),
	('pydam', 'Pyridoxamine [Pyridoxamine-2HCl]', (SELECT id from media WHERE medium='SNM3')),
	('thm', 'Thiamin [Thiamine-dichloride]', (SELECT id from media WHERE medium='SNM3')),
	('ribflv', 'Riboflavin', (SELECT id from media WHERE medium='SNM3')),
	('o2', 'O2 [Oxygen]', (SELECT id from media WHERE medium='SNM3')),
	('fe2', 'Iron (Fe2+)', (SELECT id from media WHERE medium='SNM3')),
	('fe3', 'Iron (Fe3+)', (SELECT id from media WHERE medium='SNM3')),
	('h2o', 'H2O [Water]', (SELECT id from media WHERE medium='SNM3')),
	('co2', 'CO2', (SELECT id from media WHERE medium='SNM3')),
-- RPMI
	('ca2', 'Calcium', (SELECT id from media WHERE medium='RPMI')),
	('no3', 'Nitrate', (SELECT id from media WHERE medium='RPMI')),
	('mg2', 'Magnesium', (SELECT id from media WHERE medium='RPMI')),
	('so4', 'Sulfate', (SELECT id from media WHERE medium='RPMI')),
	('cl', 'Chloride', (SELECT id from media WHERE medium='RPMI')),
	('k', 'Potassium', (SELECT id from media WHERE medium='RPMI')),
	('na1', 'Sodium', (SELECT id from media WHERE medium='RPMI')),
	('pi', 'Phosphate', (SELECT id from media WHERE medium='RPMI')),
	('gly', 'Glycine', (SELECT id from media WHERE medium='RPMI')),
	('arg__L', 'Arginine', (SELECT id from media WHERE medium='RPMI')),
	('asn__L', 'L-Asparagine', (SELECT id from media WHERE medium='RPMI')),
	('asp__L', 'Aspartic acid', (SELECT id from media WHERE medium='RPMI')),
	('cys__L', 'L-Cysteine', (SELECT id from media WHERE medium='RPMI')),
	('glu__L', 'L-Glutamate', (SELECT id from media WHERE medium='RPMI')),
	('gln__L', 'L-Glutamine', (SELECT id from media WHERE medium='RPMI')),
	('his__L','Histidine', (SELECT id from media WHERE medium='RPMI')),
	('ile__L', 'Isoleucine', (SELECT id from media WHERE medium='RPMI')),
	('leu__L', 'Leucine', (SELECT id from media WHERE medium='RPMI')),
	('met__L', 'Methionine', (SELECT id from media WHERE medium='RPMI')),
	('phe__L', 'Phenylalanine', (SELECT id from media WHERE medium='RPMI')),
	('pro__L', 'Proline', (SELECT id from media WHERE medium='RPMI')),
	('ser__L', 'Serine', (SELECT id from media WHERE medium='RPMI')),
	('thr__L', 'Threonine', (SELECT id from media WHERE medium='RPMI')),
	('trp__L', 'L-Tryptophan', (SELECT id from media WHERE medium='RPMI')),
	('tyr__L', 'L-Tyrosine disodium salt dihydrate', (SELECT id from media WHERE medium='RPMI')),
	('val__L', 'L-Valine', (SELECT id from media WHERE medium='RPMI')),
	('lys__L', 'L-Lysine', (SELECT id from media WHERE medium='RPMI')),
	('btn', 'Biotin', (SELECT id from media WHERE medium='RPMI')),
	('chol', 'Choline', (SELECT id from media WHERE medium='RPMI')),
	('ncam', 'Niacinamide', (SELECT id from media WHERE medium='RPMI')),
	('4abz', '4-Aminobenzoate', (SELECT id from media WHERE medium='RPMI')),
	('ribflv', 'Riboflavin', (SELECT id from media WHERE medium='RPMI')),
	('thm', 'Thiamin', (SELECT id from media WHERE medium='RPMI')),
	('inost', 'Myo-Inositol; should be I-Inositol', (SELECT id from media WHERE medium='RPMI')),
	('pnto__R', 'Pantothenic acid; (R)-Pantothenate', (SELECT id from media WHERE medium='RPMI')),
	('fol', 'Folate', (SELECT id from media WHERE medium='RPMI')),
	('pydxn', '	Pyridoxine', (SELECT id from media WHERE medium='RPMI')),
	('cbl1', 'Vitamin B12', (SELECT id from media WHERE medium='RPMI')),
	('glc__D', 'Glucose', (SELECT id from media WHERE medium='RPMI')),
	('gthrd', 'Reduced glutathione', (SELECT id from media WHERE medium='RPMI')),
	('h2o', 'Water', (SELECT id from media WHERE medium='RPMI')),
	('o2', 'Oxygen', (SELECT id from media WHERE medium='RPMI')),
	('hco3', 'Bicarbonate', (SELECT id from media WHERE medium='RPMI')),
	('4hpro_LT', 'Trans-4-Hydroxy-L-proline', (SELECT id from media WHERE medium='RPMI')),
	('b12', 'Vitamin B12', (SELECT id from media WHERE medium='RPMI')),
	('co2', 'Carbondioxide', (SELECT id from media WHERE medium='RPMI')),
	('h', 'H+; Hydrogen', (SELECT id from media WHERE medium='RPMI')),
	(NULL, 'Phenol Red (KEGG: C12600)', (SELECT id from media WHERE medium='RPMI')),
-- Casamino acids
	('lys__L', 'Lysine', (SELECT id from media WHERE medium='CasA')),
	('his__L', 'Histidine', (SELECT id from media WHERE medium='CasA')),
	('arg__L', 'Arginine', (SELECT id from media WHERE medium='CasA')),
	('asp__L', 'Aspartic acid', (SELECT id from media WHERE medium='CasA')),
	('thr__L', 'Threonine', (SELECT id from media WHERE medium='CasA')),
	('glu__L', 'Glutamic acid', (SELECT id from media WHERE medium='CasA')),
	('gly', 'Glycine', (SELECT id from media WHERE medium='CasA')),
	('val__L', 'Valine', (SELECT id from media WHERE medium='CasA')),
	('met__L', 'Methionine', (SELECT id from media WHERE medium='CasA')),
	('ile__L', 'Isoleucine', (SELECT id from media WHERE medium='CasA')),
	('leu__L', 'Leucine', (SELECT id from media WHERE medium='CasA')),
	('tyr__L', 'Tyrosine', (SELECT id from media WHERE medium='CasA')),
	('phe__L', 'Phenylalanine', (SELECT id from media WHERE medium='CasA')),
-- CGXII
	('nh4', 'Ammonium', (SELECT id from media WHERE medium='CGXII')),
	('so4', 'Sulfate', (SELECT id from media WHERE medium='CGXII')),
	('k', 'Potassium', (SELECT id from media WHERE medium='CGXII')),
	('pi', 'Phosphate', (SELECT id from media WHERE medium='CGXII')),
	('urea', 'Urea; Carbamide', (SELECT id from media WHERE medium='CGXII')),
	('ca2', 'Calcium', (SELECT id from media WHERE medium='CGXII')),
	('cl', 'Chloride', (SELECT id from media WHERE medium='CGXII')),
	('mg2', 'Magnesium', (SELECT id from media WHERE medium='CGXII')),
	('fe2', 'Iron', (SELECT id from media WHERE medium='CGXII')),
	('mn2', 'Manganese', (SELECT id from media WHERE medium='CGXII')),
	('ni2', 'Nickel', (SELECT id from media WHERE medium='CGXII')),
	('cu2', 'Copper', (SELECT id from media WHERE medium='CGXII')),
	('zn2', 'Zinc', (SELECT id from media WHERE medium='CGXII')),
	('btn', 'Biotin', (SELECT id from media WHERE medium='CGXII')),
	('glc__D', 'Glucose', (SELECT id from media WHERE medium='CGXII')),
	('h2o', 'Water', (SELECT id from media WHERE medium='CGXII')),
	('o2', 'Oxygen', (SELECT id from media WHERE medium='CGXII')),
	('na1', 'Sodium', (SELECT id from media WHERE medium='CGXII')),
	('h', 'H+; Hydrogen', (SELECT id from media WHERE medium='CGXII')),
	('34dhbz', '3,4-Dihydroxybenzoate; Protocatechuic acid', (SELECT id from media WHERE medium='CGXII')),
-- Blood
	('akg', '2-Oxoglutarate [Oxoglutaric acid]', (SELECT id from media WHERE medium='Blood')),
	('acac', 'Acetoacetate [Acetoacetic acid]', (SELECT id from media WHERE medium='Blood')),
	('adn', 'Adenosine', (SELECT id from media WHERE medium='Blood')),
	('but', 'Butyrate [Butyric acid]', (SELECT id from media WHERE medium='Blood')),
	('cit', 'Citrate [Citric acid]', (SELECT id from media WHERE medium='Blood')),
	('fum', 'Fumarate [Fumeric acid]', (SELECT id from media WHERE medium='Blood')),
	('gam', 'Glucosamine', (SELECT id from media WHERE medium='Blood')),
	('glcur', 'Glucuronate [D-Glucuronic acid]', (SELECT id from media WHERE medium='Blood')),
	('lac__D', 'D-Lactate [D-Lactic acid]', (SELECT id from media WHERE medium='Blood')),
	('lac__L', 'L-Lactate [L-Lactic acid]', (SELECT id from media WHERE medium='Blood')),
	('mal__L', 'L-Malate [L-Malic acid]', (SELECT id from media WHERE medium='Blood')),
	('mal__D', 'D-Malate', (SELECT id from media WHERE medium='Blood')),
	('inost', 'Myo-Inositol', (SELECT id from media WHERE medium='Blood')),
	('nac', 'Nicotinate [Nicotinic acid]', (SELECT id from media WHERE medium='Blood')),
	('nicnt', 'Nicotinate [Nicotinic acid]', (SELECT id from media WHERE medium='Blood')),
	('pyr', 'Pyruvate [Pyruvic acid]', (SELECT id from media WHERE medium='Blood')),
	('succ', 'Succinate [Succinic acid]', (SELECT id from media WHERE medium='Blood')),
	('thm', 'Thiamin [Thiamine]', (SELECT id from media WHERE medium='Blood')),
	('2hb', '2 Hydroxybutyrate [2-Hydroxybutyric acid]', (SELECT id from media WHERE medium='Blood')),
	('bhb', '(R)-3-Hydroxybutanoate [(R)-3-Hydroxybutyric acid]', (SELECT id from media WHERE medium='Blood')),
	('duri', 'Deoxyuridine', (SELECT id from media WHERE medium='Blood')),
	('dcyt', 'Deoxycytidine', (SELECT id from media WHERE medium='Blood')),
	('4pyrdx', '4-Pyridoxate [4-Pyridoxic acid]', (SELECT id from media WHERE medium='Blood')),
	('3mob', '3-Methyl-2-oxobutanoate [alpha-Ketoisovaleric acid]', (SELECT id from media WHERE medium='Blood')),
	('4hphac', '4-Hydroxyphenylacetate [p-Hydroxyphenylacetic acid]', (SELECT id from media WHERE medium='Blood')),
	('btn', 'Biotin', (SELECT id from media WHERE medium='Blood')),
	('andrstrn', 'Andrstrn [Androsterone]', (SELECT id from media WHERE medium='Blood')),
	('carn', 'L-Carnosine [Carnosine]', (SELECT id from media WHERE medium='Blood')),
	('ade', 'Adenine', (SELECT id from media WHERE medium='Blood')),
	('tchola', 'Taurocholic acid', (SELECT id from media WHERE medium='Blood')),
	('ac', 'Acetate [Acetic acid]', (SELECT id from media WHERE medium='Blood')),
	('glyb', 'Glycine betaine [Betaine]', (SELECT id from media WHERE medium='Blood')),
	('ascb__L', 'L-Ascorbate [Ascorbic acid]', (SELECT id from media WHERE medium='Blood')),
	('amp', 'AMP [Adenosine monophosphate]', (SELECT id from media WHERE medium='Blood')),
	('nh3', 'Ammonia', (SELECT id from media WHERE medium='Blood')),
	('bilirub', 'Billirubin', (SELECT id from media WHERE medium='Blood')),
	('ala_B', 'beta-Alanine', (SELECT id from media WHERE medium='Blood')),
	('camp', 'CAMP [Cyclic AMP]', (SELECT id from media WHERE medium='Blood')),
	('crn', 'L-Carnitine', (SELECT id from media WHERE medium='Blood')),
	('crtsl', 'Crtsl [Cortisol]', (SELECT id from media WHERE medium='Blood')),
	('creat', 'Creatine', (SELECT id from media WHERE medium='Blood')),
	('chsterol', 'Chsterol [Cholesterol]', (SELECT id from media WHERE medium='Blood')),
	('cgly', 'Cys Gly [Cysteinylglycine]', (SELECT id from media WHERE medium='Blood')),
	('cytd', 'Cytidine', (SELECT id from media WHERE medium='Blood')),
	('chol', 'Choline', (SELECT id from media WHERE medium='Blood')),
	('xyl__D', 'D-Xylose', (SELECT id from media WHERE medium='Blood')),
	('etoh', 'Ethanol', (SELECT id from media WHERE medium='Blood')),
	('4abut', '4-Aminobutanoate [gamma-Aminobutyric acid]', (SELECT id from media WHERE medium='Blood')),
	('fol', 'Folate [Folic acid]', (SELECT id from media WHERE medium='Blood')),
	('gly', 'Glycine', (SELECT id from media WHERE medium='Blood')),
	('gthrd', 'Reduced glutathione [Glutathione]', (SELECT id from media WHERE medium='Blood')),
	('glyc3p', 'Glycerol 3-phosphate', (SELECT id from media WHERE medium='Blood')),
	('glyc', 'Glycerol', (SELECT id from media WHERE medium='Blood')),
	('gsn', 'Guanosine', (SELECT id from media WHERE medium='Blood')),
	('gchola', 'Glycocholate [Glycocholic acid]', (SELECT id from media WHERE medium='Blood')),
	('for ', 'Formate [Formic acid]', (SELECT id from media WHERE medium='Blood')),
	('gal', 'D-Galactose', (SELECT id from media WHERE medium='Blood')),
	('glu__L', 'L-Glutamate [L-Glutamic acid]', (SELECT id from media WHERE medium='Blood')),
	('hxan', 'Hypoxanthine', (SELECT id from media WHERE medium='Blood')),
	('tyr__L', 'L-Tyrosine', (SELECT id from media WHERE medium='Blood')),
	('phe__L', 'L-Phenylalanine', (SELECT id from media WHERE medium='Blood')),
	('ala__L', 'L-Alanine', (SELECT id from media WHERE medium='Blood')),
	('pro__L', 'L-Proline', (SELECT id from media WHERE medium='Blood')),
	('thr__L', 'L-Threonine', (SELECT id from media WHERE medium='Blood')),
	('asn__L', 'L-Asparagine', (SELECT id from media WHERE medium='Blood')),
	('man', 'D-Mannose', (SELECT id from media WHERE medium='Blood')),
	('ile__L', 'L-Isoleucine', (SELECT id from media WHERE medium='Blood')),
	('imp', 'IMP [Inosinic acid]', (SELECT id from media WHERE medium='Blood')),
	('his__L', 'L-Histidine', (SELECT id from media WHERE medium='Blood')),
	('34dhphe', '3,4-Dihydroxy-L-phenylalanine [L-Dopa]', (SELECT id from media WHERE medium='Blood')),
	('lys__L', 'L-Lysine', (SELECT id from media WHERE medium='Blood')),
	('ser__L', 'L-Serine', (SELECT id from media WHERE medium='Blood')),
	('asp__L', 'L-Aspartate [L-Aspartic acid]', (SELECT id from media WHERE medium='Blood')),
	('cysi__L', 'L Cystine [L-Cystine]', (SELECT id from media WHERE medium='Blood')),
	('cyst__L', 'L-Cystathionine [L-Cystine]', (SELECT id from media WHERE medium='Blood')),
	('ins', 'Inosine', (SELECT id from media WHERE medium='Blood')),
	('ocdcea', 'Octadecenoate [Oleic acid]', (SELECT id from media WHERE medium='Blood')),
	('pnto__R', '(R)-Pantothenate [Pantothenic acid]', (SELECT id from media WHERE medium='Blood')),
	('orn', 'Ornithine', (SELECT id from media WHERE medium='Blood')),
	('nrpphr', 'Norepinephrine', (SELECT id from media WHERE medium='Blood')),
	('nadp', 'Nicotinamide adenine dinucleotide phosphate [NADP]', (SELECT id from media WHERE medium='Blood')),
	('hdca', 'Hexadecanoate [Palmitic acid]', (SELECT id from media WHERE medium='Blood')),
	('orot', 'Orotate [Orotic acid]', (SELECT id from media WHERE medium='Blood')),
	('tststerone', 'Tststerone [Testosterone]', (SELECT id from media WHERE medium='Blood')),
	('ppa', 'Propionate [Propionic acid]', (SELECT id from media WHERE medium='Blood')),
	('pydxn', 'Pyridoxine', (SELECT id from media WHERE medium='Blood')),
	('so3', 'Sulfite', (SELECT id from media WHERE medium='Blood')),
	('ribflv', 'Riboflavin', (SELECT id from media WHERE medium='Blood')),
	('sbt__D', 'D-Sorbitol [Sorbitol]', (SELECT id from media WHERE medium='Blood')),
	('sbt__L', 'L-Sorbitol [Sorbitol]', (SELECT id from media WHERE medium='Blood')),
	('thyox__L', 'L-Thyroxine [Thyroxine]', (SELECT id from media WHERE medium='Blood')),
	('ppi', 'Diphosphate [Pyrophosphate]', (SELECT id from media WHERE medium='Blood')),
	('taur', 'Taurine', (SELECT id from media WHERE medium='Blood')),
	('tsul', 'Thiosulfate', (SELECT id from media WHERE medium='Blood')),
	('sucr', 'Sucrose', (SELECT id from media WHERE medium='Blood')),
	('srtn', 'Serotonin', (SELECT id from media WHERE medium='Blood')),
	('5oxpro', '5-Oxoproline [Pyroglutamic acid]', (SELECT id from media WHERE medium='Blood')),
	('sarcs', 'Sarcosine', (SELECT id from media WHERE medium='Blood')),
	('thymd', 'Thymidine', (SELECT id from media WHERE medium='Blood')),
	('sphs1p', 'Sphingosine 1-phosphate', (SELECT id from media WHERE medium='Blood')),
	('prpp', '5-Phospho-alpha-D-ribose 1-diphosphate [Phosphoribosyl pyrophosphate]', (SELECT id from media WHERE medium='Blood')),
	('rib__D', 'D-Ribose', (SELECT id from media WHERE medium='Blood')),
	('udpg', 'UDPglucose [Uridine diphosphate glucose]', (SELECT id from media WHERE medium='Blood')),
	('ump', 'UMP [Uridine 5''-monophosphate]', (SELECT id from media WHERE medium='Blood')),
	('urate', 'Urate [Uric acid]', (SELECT id from media WHERE medium='Blood')),
	('urea', 'Urea', (SELECT id from media WHERE medium='Blood')),
	('udp', 'UDP [Uridine 5''-diphosphate]', (SELECT id from media WHERE medium='Blood')),
	('uri', 'Uridine', (SELECT id from media WHERE medium='Blood')),
	('ura', 'Uracil', (SELECT id from media WHERE medium='Blood')),
	('retinol', 'All-trans-Retinol [Vitamin A]', (SELECT id from media WHERE medium='Blood')),
	('retinol_9_cis', '9-cis-retinol [Vitamin A]', (SELECT id from media WHERE medium='Blood')),
	('34dhoxpeg', '3,4-Dihydroxyphenylethyleneglycol [3,4-Dihydroxyphenylglycol]', (SELECT id from media WHERE medium='Blood')),
	('2mcit', '2-Methylcitrate [2-Methylcitric acid]', (SELECT id from media WHERE medium='Blood')),
	('ca2', 'Calcium', (SELECT id from media WHERE medium='Blood')),
	('5htrp', '5-Hydroxy-L-tryptophan', (SELECT id from media WHERE medium='Blood')),
	('octa', 'Octanoate [Caprylic acid]', (SELECT id from media WHERE medium='Blood')),
	('3mop', '(S)-3-Methyl-2-oxopentanoate [3-Methyl-2-Oxovaleric acid]', (SELECT id from media WHERE medium='Blood')),
	('cl', 'Chloride [Chloride ion]', (SELECT id from media WHERE medium='Blood')),
	('rbt', 'Ribitol', (SELECT id from media WHERE medium='Blood')),
	('dca', 'Decanoate [Capric acid]', (SELECT id from media WHERE medium='Blood')),
	('arg__L', 'L-Arginine', (SELECT id from media WHERE medium='Blood')),
	('C02528', 'Chenodeoxycholate [Chenodeoxycholic acid]', (SELECT id from media WHERE medium='Blood')),
	('atp', 'ATP [Adenosine triphosphate]', (SELECT id from media WHERE medium='Blood')),
	('caro', 'Beta-Carotene [B-Carotene]', (SELECT id from media WHERE medium='Blood')),
	('elaid', 'Elaidic acid', (SELECT id from media WHERE medium='Blood')),
	('cys__L', 'L-Cysteine', (SELECT id from media WHERE medium='Blood')),
	('k', 'Potassium', (SELECT id from media WHERE medium='Blood')),
	('na1', 'Sodium', (SELECT id from media WHERE medium='Blood')),
	('hco3', 'Bicarbonate [Hydrogen carbonate]', (SELECT id from media WHERE medium='Blood')),
	('cholate', 'Cholate [Cholic acid]', (SELECT id from media WHERE medium='Blood')),
	('dchac', 'Deoxycholate [Deoxycholic acid]', (SELECT id from media WHERE medium='Blood')),
	('csn', 'Cytosine', (SELECT id from media WHERE medium='Blood')),
	('dgchol', 'Chenodeoxyglycocholate [Chenodeoxycholic acid glycine conjugate]', (SELECT id from media WHERE medium='Blood')),
	('ddca', 'Dodecanoate [Dodecanoic acid]', (SELECT id from media WHERE medium='Blood')),
	('gln__L', 'L-Glutamine', (SELECT id from media WHERE medium='Blood')),
	('arab__L', 'L-Arabinose', (SELECT id from media WHERE medium='Blood')),
	('c10crn', 'Decanoyl Carnitine [Decanoylcarnithine]', (SELECT id from media WHERE medium='Blood')),
	('fru', 'D-Fructose', (SELECT id from media WHERE medium='Blood')),
	('lnlc', 'Linoleic acid', (SELECT id from media WHERE medium='Blood')),
	('leu__L', 'L-Leucine', (SELECT id from media WHERE medium='Blood')),
	('ivcrn', 'Isovaleryl Carnitine', (SELECT id from media WHERE medium='Blood')),
	('fe2', 'Fe2+', (SELECT id from media WHERE medium='Blood')),
	('fe3', 'Iron (Fe3+)', (SELECT id from media WHERE medium='Blood')),
	('4mop', '4-Methyl-2-oxopentanoate [Ketoleucine]', (SELECT id from media WHERE medium='Blood')),
	('met__L', 'L-Methionine', (SELECT id from media WHERE medium='Blood')),
	('HC02193', 'Glycolithocolate [Lithocholic acid glycine conjugate]', (SELECT id from media WHERE medium='Blood')),
	('1mncam', '1 Methylnicotinamide [1-Methylnicothinamide]', (SELECT id from media WHERE medium='Blood')),
	('34hpp', '3-(4-Hydroxyphenyl)pyruvate [4-Hydroxyphenylpyruvic acid]', (SELECT id from media WHERE medium='Blood')),
	('HC02196', 'Glycoursodeoxycholate [Glycoursodeoxycholic acid]', (SELECT id from media WHERE medium='Blood')),
	('hom__L', 'L-Homoserine', (SELECT id from media WHERE medium='Blood')),
	('HC02192', 'Taurolithocholate [Lithocholyltaurine]', (SELECT id from media WHERE medium='Blood')),
	('HC02191', 'Lithocholate [Lithocholic acid]', (SELECT id from media WHERE medium='Blood')),
	('c8crn', 'Octanoyl carnitine [L-Octanoylcarnitine]', (SELECT id from media WHERE medium='Blood')),
	('phyt', 'Phytanic acid', (SELECT id from media WHERE medium='Blood')),
	('ttdca', 'Tetradecanoate [Myristic acid]', (SELECT id from media WHERE medium='Blood')),
	('ptdca', 'Pentadecanoate [Pentadecanoic acid]', (SELECT id from media WHERE medium='Blood')),
	('ocdca', 'Octadecanoate [Stearic acid]', (SELECT id from media WHERE medium='Blood')),
	('vitd3', 'Calciol; (+)-Vitamin D3 [Vitamin D3]', (SELECT id from media WHERE medium='Blood')),
	('C02470', 'Xanthurenic acid', (SELECT id from media WHERE medium='Blood')),
	('val__L', 'L-Valine', (SELECT id from media WHERE medium='Blood')),
	('tdechola', 'Taurodeoxycholate [Taurodeoxycholic acid]', (SELECT id from media WHERE medium='Blood')),
	('vitd2', 'Vitamin D2; Ergocalciferol', (SELECT id from media WHERE medium='Blood')),
	('nad', 'Nicotinamide adenine dinucleotide [NAD]', (SELECT id from media WHERE medium='Blood')),
	('citr__L', 'L-Citrulline [Citrulline]', (SELECT id from media WHERE medium='Blood')),
	('trp__L', 'L-Tryptophan', (SELECT id from media WHERE medium='Blood')),
	('docosac', 'Behenate, Docosanoate [Behenic acid]', (SELECT id from media WHERE medium='Blood')),
	('HC02194', 'Ursodeoxycholate [Ursodeoxycholic acid]', (SELECT id from media WHERE medium='Blood')),
	('tdchola', 'Taurochenodeoxycholate [Taurochenodesoxycholic acid]', (SELECT id from media WHERE medium='Blood')),
	('acald', 'Acetaldehyde', (SELECT id from media WHERE medium='Blood')),
	('dheas', 'Dehydroepiandrosterone sulfate', (SELECT id from media WHERE medium='Blood')),
	('arachd', 'Arachidonic acid', (SELECT id from media WHERE medium='Blood')),
	('dhf', '7,8-Dihydrofolate [Dihydrofolic acid]', (SELECT id from media WHERE medium='Blood')),
	('anth', 'Anthranilate [2-Aminobenzoic acid]', (SELECT id from media WHERE medium='Blood')),
	('mthgxl', 'Methylglyoxal [Pyruvaldehyde]', (SELECT id from media WHERE medium='Blood')),
	('gdp', 'GDP [Guanosine diphosphate]', (SELECT id from media WHERE medium='Blood')),
	('fad', 'Flavin adenine dinucleotide oxidized [FAD]', (SELECT id from media WHERE medium='Blood')),
	('sprm', 'Spermine', (SELECT id from media WHERE medium='Blood')),
	('spmd', 'Spermidine', (SELECT id from media WHERE medium='Blood')),
	('dhdascb', 'Dehydroascorbate [Dehydroascorbic acid]', (SELECT id from media WHERE medium='Blood')),
	('gtp', 'GTP [Guanosine triphosphate]', (SELECT id from media WHERE medium='Blood')),
	('ala__D', 'D-Alanine', (SELECT id from media WHERE medium='Blood')),
	('23cgmp', '2'',3''-Cyclic GMP [Cyclic GMP]', (SELECT id from media WHERE medium='Blood')),
	('35cgmp', '3'',5''-Cyclic GMP [Cyclic GMP]', (SELECT id from media WHERE medium='Blood')),
	('adp', 'ADP', (SELECT id from media WHERE medium='Blood')),
	('retinal', 'All-trans-Retinal [Retinal]', (SELECT id from media WHERE medium='Blood')),
	('co', 'Carbon monoxide', (SELECT id from media WHERE medium='Blood')),
	('o2', 'O2 [Oxygen]', (SELECT id from media WHERE medium='Blood')),
	('sph1p', 'Sphinganine 1 phosphate [Sphinganine 1-phosphate]', (SELECT id from media WHERE medium='Blood')),
	('lnlnca', 'Alpha-Linolenic acid', (SELECT id from media WHERE medium='Blood')),
	('alpla', 'Alpha linolenic acid [Alpha-Linolenic acid]', (SELECT id from media WHERE medium='Blood')),
	('5mthf', '5-Methyltetrahydrofolate [5-Methyltetrahydrofolic acid]', (SELECT id from media WHERE medium='Blood')),
	('gmp', 'GMP [Guanosine monophosphate]', (SELECT id from media WHERE medium='Blood')),
	('ncam', 'Niacinamide', (SELECT id from media WHERE medium='Blood')),
	('ptrc', 'Putrescine', (SELECT id from media WHERE medium='Blood')),
	('estrones', 'Estrone sulfate', (SELECT id from media WHERE medium='Blood')),
	('fald', 'Formaldehyde', (SELECT id from media WHERE medium='Blood')),
	('pi', 'Phosphate', (SELECT id from media WHERE medium='Blood')),
	('pydam', 'Pyridoxamine', (SELECT id from media WHERE medium='Blood')),
	('25hvitd2', '25-Hydroxyvitamin D2', (SELECT id from media WHERE medium='Blood')),
	('so4', 'Sulfate', (SELECT id from media WHERE medium='Blood')),
	('lipt', 'Lipoate [(R)-lipoic acid]', (SELECT id from media WHERE medium='Blood')),
	('lipoate', 'Lipoate [(R)-lipoic acid]', (SELECT id from media WHERE medium='Blood')),
	('tcynt', 'Thiocyanate', (SELECT id from media WHERE medium='Blood')),
	('thioc', 'Thiocyanate', (SELECT id from media WHERE medium='Blood')),
	('dhap', 'Dihydroxyacetone phosphate', (SELECT id from media WHERE medium='Blood')),
	('pydx5p', 'Pyridoxal 5''-phosphate', (SELECT id from media WHERE medium='Blood')),
	('fmn', 'FMN [Flavin Mononucleotide]', (SELECT id from media WHERE medium='Blood')),
	('pydx', 'Pyridoxal', (SELECT id from media WHERE medium='Blood')),
	('cdp', 'CDP', (SELECT id from media WHERE medium='Blood')),
	('crtstrn', 'Corticosterone', (SELECT id from media WHERE medium='Blood')),
	('5fthf', '5-Formyltetrahydrofolate [Folinic acid]', (SELECT id from media WHERE medium='Blood')),
	('5fothf', '5 Formyltetrahydrofolate [Folinic acid]', (SELECT id from media WHERE medium='Blood')),
	('acetone', 'Acetone', (SELECT id from media WHERE medium='Blood')),
	('prgstrn', 'Prgstrn [Progesterone]', (SELECT id from media WHERE medium='Blood')),
	('thf', '5,6,7,8-Tetrahydrofolate [Tetrahydrofolic acid]', (SELECT id from media WHERE medium='Blood')),
	('abt', 'L Arabinitol [L-Arabitol]', (SELECT id from media WHERE medium='Blood')),
	('abt__L', 'L Arabinitol [L-Arabitol]', (SELECT id from media WHERE medium='Blood')),
	('retn', 'Retinoate [All-trans-retinoic acid]', (SELECT id from media WHERE medium='Blood')),
	('bz', 'Benzoate [Benzoic acid]', (SELECT id from media WHERE medium='Blood')),
	('meoh', 'Methanol', (SELECT id from media WHERE medium='Blood')),
	('avite1', 'Alpha-Tocopherol', (SELECT id from media WHERE medium='Blood')),
	('co2', 'CO2 [Carbon dioxide]', (SELECT id from media WHERE medium='Blood')),
	('tmndnc', 'Timnodonic acid [Eicosapentaenoic acid]', (SELECT id from media WHERE medium='Blood')),
	('lgn', 'Lignoceric acid or tetracosanoicacid [Tetracosanoic acid]', (SELECT id from media WHERE medium='Blood')),
	('lgnc', 'Lignoceric acid [Tetracosanoic acid]', (SELECT id from media WHERE medium='Blood')),
	('q10', 'Ubiquinone-10', (SELECT id from media WHERE medium='Blood')),
	('c4crn', 'Butyryl carnitine', (SELECT id from media WHERE medium='Blood')),
	('ha', 'Hyaluronan [Hyaluronic acid]', (SELECT id from media WHERE medium='Blood')),
	('nrpphrsf', 'Sulfate derivative of norepinephrine [Norepinephrine sulfate]', (SELECT id from media WHERE medium='Blood')),
	('doco13ac', '13Z)-13-docosenoic acid [Erucic acid]', (SELECT id from media WHERE medium='Blood')),
	('cynt', 'Cyanate', (SELECT id from media WHERE medium='Blood')),
	('h2o', 'H2O [Water]', (SELECT id from media WHERE medium='Blood')),
	('3aib', 'L-3-Amino-isobutanoate [(S)-b-aminoisobutyric acid]', (SELECT id from media WHERE medium='Blood')),
	('eicostet', 'Eicosatetranoic acid [Cis-8,11,14,17-Eicosatetranoic acid]', (SELECT id from media WHERE medium='Blood')),
	('crvnc', 'Cervonic acid [Docosahexaenoic acid]', (SELECT id from media WHERE medium='Blood')),
	('arach', 'Arachidic acid', (SELECT id from media WHERE medium='Blood')),
	('adrn', 'Adrenic acid', (SELECT id from media WHERE medium='Blood')),
	('hpdca', 'Heptadecanoate [Heptadecanoic acid]', (SELECT id from media WHERE medium='Blood')),
	('oxa', 'Oxalate [Oxalic acid]', (SELECT id from media WHERE medium='Blood')),
	('hexc', 'Hexacosanoate [Hexacosanoic acid]', (SELECT id from media WHERE medium='Blood')),
	('nrvnc', 'Nervonic acid', (SELECT id from media WHERE medium='Blood')),
	('HC02197', 'Sulfoglycolithocholate [Sulfolithocholylglycine]', (SELECT id from media WHERE medium='Blood')),
	('no2', 'Nitrite', (SELECT id from media WHERE medium='Blood')),
	('3mlda', '3-Methylimidazoleacetic acid [Methylimidazoleacetic acid]', (SELECT id from media WHERE medium='Blood')),
	('andrstrnglc', 'Androsterone glucuronide', (SELECT id from media WHERE medium='Blood')),
	('xylt', 'Xylitol [D-Xylitol]', (SELECT id from media WHERE medium='Blood')),
	('dlnlcg', 'Dihomo-gamma-linolenic acid [8,11,14-Eicosatrienoic acid]', (SELECT id from media WHERE medium='Blood')),
	('5adtststerone', '5alpha-Dihydrotestosterone [Dihydrotestosterone]', (SELECT id from media WHERE medium='Blood')),
	('aprgstrn', '20alpha-Dihydroprogesterone [20a-Dihydroprogesterone]', (SELECT id from media WHERE medium='Blood')),
	('lnlncg', 'Gamma-Linolenic acid', (SELECT id from media WHERE medium='Blood')),
	('h2o2', 'Hydrogen peroxide', (SELECT id from media WHERE medium='Blood')),
	('retnglc', 'Retinoyl glucuronide [Retinoyl b-glucuronide]', (SELECT id from media WHERE medium='Blood')),
	('hdcea', 'Hexadecenoate [Palmitoleic acid]', (SELECT id from media WHERE medium='Blood')),
	('vacc', 'Vaccenic acid', (SELECT id from media WHERE medium='Blood')),
	('HC02180', 'Thromboxane-b2 [Thromboxane B2]', (SELECT id from media WHERE medium='Blood')),
	('HC00250', 'Hydrosulfide [Hydrogen sulfide]', (SELECT id from media WHERE medium='Blood')),
	('h2s', 'Hydrogen sulfide', (SELECT id from media WHERE medium='Blood')),
	('gthox', 'Oxidized glutathione', (SELECT id from media WHERE medium='Blood')),
	('limnen', 'Limnen (D-Limonene)', (SELECT id from media WHERE medium='Blood')),
	('ser__D', 'D-Serine', (SELECT id from media WHERE medium='Blood')),
	('25hvitd3', '25-Hydroxyvitamin D3 [Calcidiol]', (SELECT id from media WHERE medium='Blood')),
	('phyQ', 'Phylloquinone (old identifier for [Vitamin K1])', (SELECT id from media WHERE medium='Blood')),
	('phllqne', 'Phylloquinone [Vitamin K1]', (SELECT id from media WHERE medium='Blood')),
	('mepi', 'Metanephrine', (SELECT id from media WHERE medium='Blood')),
	('gbside_hs', 'Globoside (homo sapiens) [Tetrahexosylceramide (d18:1/12:0)]', (SELECT id from media WHERE medium='Blood')),
	('dopasf', 'Dopamine 3-O-Sulfate', (SELECT id from media WHERE medium='Blood')),
	('avite2', 'Alpha-Tocotrienol', (SELECT id from media WHERE medium='Blood')),
	('bvite', 'Beta-Tocopherol', (SELECT id from media WHERE medium='Blood')),
	('pheacgln', 'Alpha-N-Phenylacetyl-L-glutamine', (SELECT id from media WHERE medium='Blood')),
	('glyc__S', '(S)-Glycerate [L-Glyceric acid]', (SELECT id from media WHERE medium='Blood')),
	('4hdebrisoquine', '4hdebrisoquine [4-Hydroxydebrisoquine]', (SELECT id from media WHERE medium='Blood')),
	('debrisoquine', 'Debrisoquine', (SELECT id from media WHERE medium='Blood')),
	('strdnc', 'Stearidonic acid', (SELECT id from media WHERE medium='Blood')),
	('c81crn', 'Octenoyl Carnithine [2-Octenoylcarnithine]', (SELECT id from media WHERE medium='Blood')),
	('3hexdcrn', '3-Hydroxyhexadecanoylcarnithine', (SELECT id from media WHERE medium='Blood')),
	('h', 'H+ [Protons]', (SELECT id from media WHERE medium='Blood')),
-- MP-AU
	('na1', 'Sodium [NaCl]', (SELECT id from media WHERE medium='MP-AU')),
	('cl', 'Chloride [NaCl]', (SELECT id from media WHERE medium='MP-AU')),
	('so4', 'Sulfate [Na2SO4]', (SELECT id from media WHERE medium='MP-AU')),
	('urate', 'Urate [Uric acid (C5H4N4O3)]', (SELECT id from media WHERE medium='MP-AU')),
	('cit', 'Citrate [Sodium citrate (Na3C6H5O7.2H2O)]', (SELECT id from media WHERE medium='MP-AU')),
	('crtn', 'Creatinine [C4H7N3O]', (SELECT id from media WHERE medium='MP-AU')),
	('urea', 'Urea [CH4N2O]', (SELECT id from media WHERE medium='MP-AU')),
	('k', 'Potassium [KCl]', (SELECT id from media WHERE medium='MP-AU')),
	('ca2', 'Calcium [CaCl2]', (SELECT id from media WHERE medium='MP-AU')),
	('nh4', 'Ammonium [NH4Cl]', (SELECT id from media WHERE medium='MP-AU')),
	('oxa', 'Oxalate [Potassium Oxalate (K2C2O4.H2O)]', (SELECT id from media WHERE medium='MP-AU')),
	('mg2', 'Magnesium [MgSO4.7H2O]', (SELECT id from media WHERE medium='MP-AU')),
	('h2', 'Hydrogen [NaH2PO4.2H2O]', (SELECT id from media WHERE medium='MP-AU')),
	('pi', 'Phosphate [NaH2PO4.2H2O]', (SELECT id from media WHERE medium='MP-AU')),
	('h', 'H+ [Na2HPO4.2H2O]', (SELECT id from media WHERE medium='MP-AU')),
	('h2o', 'H2O', (SELECT id from media WHERE medium='MP-AU')),
	('o2', 'O2 [Oxygen]', (SELECT id from media WHERE medium='MP-AU')),
--dGMM
	('glc__D', 'D-Glucose', (SELECT id from media WHERE medium='dGMM')),
	('glc__bD', 'D-Glucose', (SELECT id from media WHERE medium='dGMM')),
	('fru', 'Fructose', (SELECT id from media WHERE medium='dGMM')),
	('cellb', 'Cellobiose', (SELECT id from media WHERE medium='dGMM')),
	('malt', 'Maltose', (SELECT id from media WHERE medium='dGMM')),
	(NULL, 'Resazurin (KEGG: C11178)', (SELECT id from media WHERE medium='dGMM')),
	('hemeD', 'Heme D [Hematin]', (SELECT id from media WHERE medium='dGMM')),
	('his__L', 'L-Histidine', (SELECT id from media WHERE medium='dGMM')),
	('cys__L', 'L-Cysteine', (SELECT id from media WHERE medium='dGMM')),
	('fe2', 'Fe2+ [FeSO4 . 7H2O]', (SELECT id from media WHERE medium='dGMM')),
	('so4', 'Sulfate [FeSO4 . 7H2O]', (SELECT id from media WHERE medium='dGMM')),
	('h2o', 'H2O [FeSO4 . 7H2O]', (SELECT id from media WHERE medium='dGMM')),
	('zn2', 'Zinc [ZnSO4 * 7H2O]', (SELECT id from media WHERE medium='dGMM')),
	('cobalt2', 'Co2+ [Co(NO3)2 . 6H2O]', (SELECT id from media WHERE medium='dGMM')),
	('no3', 'Nitrate [Co(NO3)2 . 6H2O]', (SELECT id from media WHERE medium='dGMM')),
	('k', 'Potassium [AlK(SO4)2 (anhydrous)]', (SELECT id from media WHERE medium='dGMM')),
	('na1', 'Sodium [NaCl]', (SELECT id from media WHERE medium='dGMM')),
	('cl', 'Chloride [NaCl]', (SELECT id from media WHERE medium='dGMM')),
	('slnt', 'Selenite [Na2SeO3 (anhydrous)]', (SELECT id from media WHERE medium='dGMM')),
	('tungs', 'Tungstate [Na2WO4 . 2H2O]', (SELECT id from media WHERE medium='dGMM')),
	('ni2', 'Nickel [NiCl2 . 6H2O]', (SELECT id from media WHERE medium='dGMM')),
	('ca2', 'Calcium [CaCl2 (anhydrous)]', (SELECT id from media WHERE medium='dGMM')),
	('cu2', 'Copper [CuSO4 (anhydrous)]', (SELECT id from media WHERE medium='dGMM')),
	(NULL, 'H3BO3', (SELECT id from media WHERE medium='dGMM')),
	('mn2', 'Manganese [MnSO4 * H2O]', (SELECT id from media WHERE medium='dGMM')),
	('mg2', 'Magnesium [MgSO4 * 7H2O]', (SELECT id from media WHERE medium='dGMM')),
	('hco3', 'Bicarbonate [NaHCO3]', (SELECT id from media WHERE medium='dGMM')),
	('mobd', 'Molybdate [Na2MoO4 . 2H2O]', (SELECT id from media WHERE medium='dGMM')),
	('btn', 'Biotin', (SELECT id from media WHERE medium='dGMM')),
	('thm', 'Thiamin [Thiamine HCl]', (SELECT id from media WHERE medium='dGMM')),
	('ribflv', 'Riboflavin', (SELECT id from media WHERE medium='dGMM')),
	('nac', 'Nicotinate [Niacin]', (SELECT id from media WHERE medium='dGMM')),
	('nicnt', 'Nicotinate [Niacin]', (SELECT id from media WHERE medium='dGMM')),
	('pydxn', 'Pyridoxine [Pyridoxine HCl]', (SELECT id from media WHERE medium='dGMM')),
	('pnto__R', '(R)-Pantothenate [Calcium Pantothenate]', (SELECT id from media WHERE medium='dGMM')),
	('fol', 'Folate [Folic acid]', (SELECT id from media WHERE medium='dGMM')),
	('4abz', '4-Aminobenzoate [p-Aminobenzoic acid]', (SELECT id from media WHERE medium='dGMM')),
	('lipoate', 'Lipoate [Lipoic acid]', (SELECT id from media WHERE medium='dGMM')),
	('lipopb', 'Lipoate (protein bound) [Lipoic acid]', (SELECT id from media WHERE medium='dGMM')),
	('b12', 'Vitamin B12', (SELECT id from media WHERE medium='dGMM')),
	('cbl1', 'Cob(I)alamin [Vitamin B12]', (SELECT id from media WHERE medium='dGMM')),
	('cbl2', 'Cob(II)alamin [Vitamin B12]', (SELECT id from media WHERE medium='dGMM')),
	('mndn', 'Menadione [Vitamin K (menadione)]', (SELECT id from media WHERE medium='dGMM')),
	('ac', 'Acetate [Acetic acid]', (SELECT id from media WHERE medium='dGMM')),
	('M03134', 'Valeric acid [Isovaleric acid]', (SELECT id from media WHERE medium='dGMM')),
	('ival', 'Isovalerate [Isovaleric acid]', (SELECT id from media WHERE medium='dGMM')),
	('ppa', 'Propionate [Propionic acid]', (SELECT id from media WHERE medium='dGMM')),
	('but', 'Butyrate [Butyric acid]', (SELECT id from media WHERE medium='dGMM')),
	('isobuta', 'Isobutyric acid [Butyric acid]', (SELECT id from media WHERE medium='dGMM')),
	('ibt', 'Isobutyrate [Butyric acid]', (SELECT id from media WHERE medium='dGMM')),
	('h2', 'Hydrogen [KH2PO4]', (SELECT id from media WHERE medium='dGMM')),
	('pi', 'Phosphate [KH2PO4]', (SELECT id from media WHERE medium='dGMM')),
	(NULL, 'EDTA (KEGG: C00284)', (SELECT id from media WHERE medium='dGMM')),
	('co2', 'CO2 [Carbon dioxide]', (SELECT id from media WHERE medium='dGMM')),
	('n2', 'Nitrogen', (SELECT id from media WHERE medium='dGMM'));

END;
