"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/funcs/log-archiver.lambda.ts
var log_archiver_lambda_exports = {};
__export(log_archiver_lambda_exports, {
  EnvironmentVariableError: () => EnvironmentVariableError,
  InputVariableError: () => InputVariableError,
  handler: () => handler
});
module.exports = __toCommonJS(log_archiver_lambda_exports);
var import_client_cloudwatch_logs = require("@aws-sdk/client-cloudwatch-logs");
var EnvironmentVariableError = class extends Error {
  constructor(message) {
    super(message);
    this.name = "EnvironmentVariableError";
  }
};
var InputVariableError = class extends Error {
  constructor(message) {
    super(message);
    this.name = "InputVariableError";
  }
};
var handler = async (event, context) => {
  console.log(`Event: ${JSON.stringify(event, null, 2)}`);
  console.log(`Context: ${JSON.stringify(context, null, 2)}`);
  if (!process.env.BUCKET_NAME) {
    throw new EnvironmentVariableError("BUCKET_NAME environment variable not set.");
  }
  if (!event.TargetLogGroupName) {
    throw new InputVariableError("event input logGroupName environment variable not set.");
  }
  const destinationPrefix = event.TargetLogGroupName.replace(/\//g, "-").replace(/^-/, "").replace(/\./g, "--");
  const now = /* @__PURE__ */ new Date();
  const targetFromTime = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0).getTime() - 1e3 * 60 * 60 * 24;
  const targetToTime = targetFromTime + 1e3 * 60 * 60 * 24 + 999;
  const targetDate = new Date(targetFromTime);
  const y = targetDate.getFullYear();
  const m = ("00" + (targetDate.getMonth() + 1)).slice(-2);
  const d = ("00" + targetDate.getDate()).slice(-2);
  const cwLogsClient = new import_client_cloudwatch_logs.CloudWatchLogsClient({});
  const params = {
    destination: process.env.BUCKET_NAME,
    logGroupName: event.TargetLogGroupName,
    from: targetFromTime,
    to: targetToTime,
    destinationPrefix: `${destinationPrefix}/${y}/${y}-${m}/${m}-${d}`
  };
  console.log(`CommandParams: ${JSON.stringify(params)}`);
  const result = await cwLogsClient.send(new import_client_cloudwatch_logs.CreateExportTaskCommand(params));
  console.log(`CommandResult: ${JSON.stringify(result)}`);
  return { TaskId: result.taskId };
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EnvironmentVariableError,
  InputVariableError,
  handler
});
//# sourceMappingURL=index.js.map
