"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = exports.InputVariableError = exports.EnvironmentVariableError = void 0;
const client_cloudwatch_logs_1 = require("@aws-sdk/client-cloudwatch-logs");
class EnvironmentVariableError extends Error {
    constructor(message) {
        super(message);
        this.name = 'EnvironmentVariableError';
    }
}
exports.EnvironmentVariableError = EnvironmentVariableError;
class InputVariableError extends Error {
    constructor(message) {
        super(message);
        this.name = 'InputVariableError';
    }
}
exports.InputVariableError = InputVariableError;
const handler = async (event, context) => {
    console.log(`Event: ${JSON.stringify(event, null, 2)}`);
    console.log(`Context: ${JSON.stringify(context, null, 2)}`);
    // do validation
    if (!process.env.BUCKET_NAME) {
        throw new EnvironmentVariableError('BUCKET_NAME environment variable not set.');
    }
    if (!event.TargetLogGroupName) {
        throw new InputVariableError('event input logGroupName environment variable not set.');
    }
    // create destination prefix
    const destinationPrefix = event.TargetLogGroupName.replace(/\//g, '-').replace(/^-/, '').replace(/\./g, '--');
    const now = new Date();
    const targetFromTime = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0).getTime() - (1000 * 60 * 60 * 24);
    const targetToTime = targetFromTime + (1000 * 60 * 60 * 24) + 999;
    const targetDate = new Date(targetFromTime);
    const y = targetDate.getFullYear();
    const m = ('00' + (targetDate.getMonth() + 1)).slice(-2);
    const d = ('00' + (targetDate.getDate())).slice(-2);
    const cwLogsClient = new client_cloudwatch_logs_1.CloudWatchLogsClient({});
    const params = {
        destination: process.env.BUCKET_NAME,
        logGroupName: event.TargetLogGroupName,
        from: targetFromTime,
        to: targetToTime,
        destinationPrefix: `${destinationPrefix}/${y}/${y}-${m}/${m}-${d}`,
    };
    console.log(`CommandParams: ${JSON.stringify(params)}`);
    const result = await cwLogsClient.send(new client_cloudwatch_logs_1.CreateExportTaskCommand(params));
    console.log(`CommandResult: ${JSON.stringify(result)}`);
    return { TaskId: result.taskId };
};
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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