# Copyright 2021 Alibaba Group Holding Limited. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# =============================================================================

r'''Pipeline related classes and functions.
'''

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from hybridbackend.tensorflow.framework.context import Context as _ctx
from hybridbackend.tensorflow.pipeline.pipeline_lib import compute_embedding
from hybridbackend.tensorflow.pipeline.pipeline_lib import compute_logits
from hybridbackend.tensorflow.pipeline.pipeline_lib import \
  EnablePipeline as scope
from hybridbackend.tensorflow.pipeline.pipeline_lib import Pipeline

_ = (
  _ctx.get().options
  .register('pipeline_num', -1, env='HB_PIPELINE_NUM')
  .register('pipeline_dense_ga_only', False, env='HB_PIPELINE_DENSE_GA_ONLY'))
