"""
Module containing functions to align pairs of points in 3D
"""
from __future__ import annotations
import typing
__all__: list[str] = ['GetAlignmentTransform']
def GetAlignmentTransform(refPoints: typing.Any, probePoints: typing.Any, weights: typing.Any = [], reflect: bool = False, maxIterations: int = 50) -> typing.Any:
    """
        Compute the optimal alignment (minimum RMSD) between two set of points 
        
         
         ARGUMENTS:
        
            - refPoints : reference points specified as a N by 3 Numeric array or 
                          sequence of 3-sequences or sequence of Point3Ds 
            - probePoints : probe points to align to reference points - same format 
                          restrictions as reference points apply here 
            - weights : optional numeric vector or list of weights to associate to each pair of points
            - reflect : reflect the probe points before attempting alignment
            - maxIteration : maximum number of iterations to try to minimize RMSD 
                          
         RETURNS:
        
            a 2-tuple:
              - SSD value for the alignment
              - the 4x4 transform matrix, as a Numeric array
        
        
    
        C++ signature :
            _object* GetAlignmentTransform(boost::python::api::object,boost::python::api::object [,boost::python::api::object=[] [,bool=False [,unsigned int=50]]])
    """
