"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _FileMediaType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FileMediaTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FileMediaType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FILE_MEDIA_TYPE_UNSPECIFIED: _FileMediaType.ValueType  # 0
    """Unspecified."""
    FILE_MEDIA_TYPE_DOCUMENT: _FileMediaType.ValueType  # 1
    """Document."""
    FILE_MEDIA_TYPE_IMAGE: _FileMediaType.ValueType  # 2
    """Image."""
    FILE_MEDIA_TYPE_AUDIO: _FileMediaType.ValueType  # 3
    """Audio."""
    FILE_MEDIA_TYPE_VIDEO: _FileMediaType.ValueType  # 4
    """Video."""

class FileMediaType(_FileMediaType, metaclass=_FileMediaTypeEnumTypeWrapper):
    """FileMediaType describes the type of a catalog file."""

FILE_MEDIA_TYPE_UNSPECIFIED: FileMediaType.ValueType  # 0
"""Unspecified."""
FILE_MEDIA_TYPE_DOCUMENT: FileMediaType.ValueType  # 1
"""Document."""
FILE_MEDIA_TYPE_IMAGE: FileMediaType.ValueType  # 2
"""Image."""
FILE_MEDIA_TYPE_AUDIO: FileMediaType.ValueType  # 3
"""Audio."""
FILE_MEDIA_TYPE_VIDEO: FileMediaType.ValueType  # 4
"""Video."""
global___FileMediaType = FileMediaType

class _ContentType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ContentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ContentType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONTENT_TYPE_UNSPECIFIED: _ContentType.ValueType  # 0
    """Unspecified."""
    CONTENT_TYPE_CHUNK: _ContentType.ValueType  # 1
    """Chunk."""
    CONTENT_TYPE_SUMMARY: _ContentType.ValueType  # 2
    """Summary."""
    CONTENT_TYPE_AUGMENTED: _ContentType.ValueType  # 3
    """Augmented."""

class ContentType(_ContentType, metaclass=_ContentTypeEnumTypeWrapper):
    """ContentType describes the type of a chunk content."""

CONTENT_TYPE_UNSPECIFIED: ContentType.ValueType  # 0
"""Unspecified."""
CONTENT_TYPE_CHUNK: ContentType.ValueType  # 1
"""Chunk."""
CONTENT_TYPE_SUMMARY: ContentType.ValueType  # 2
"""Summary."""
CONTENT_TYPE_AUGMENTED: ContentType.ValueType  # 3
"""Augmented."""
global___ContentType = ContentType

@typing_extensions.final
class Chunk(google.protobuf.message.Message):
    """The Chunk message represents a chunk of data in the artifact system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_UID_FIELD_NUMBER: builtins.int
    RETRIEVABLE_FIELD_NUMBER: builtins.int
    START_POS_FIELD_NUMBER: builtins.int
    END_POS_FIELD_NUMBER: builtins.int
    TOKENS_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    ORIGINAL_FILE_UID_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    chunk_uid: builtins.str
    """unique identifier of the chunk"""
    retrievable: builtins.bool
    """whether the chunk is retrievable"""
    start_pos: builtins.int
    """start position of the chunk in the source file"""
    end_pos: builtins.int
    """end position of the chunk in the source file"""
    tokens: builtins.int
    """tokens of the chunk"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """creation time of the chunk"""
    original_file_uid: builtins.str
    """original file unique identifier"""
    content_type: global___ContentType.ValueType
    """content type"""
    def __init__(
        self,
        *,
        chunk_uid: builtins.str = ...,
        retrievable: builtins.bool = ...,
        start_pos: builtins.int = ...,
        end_pos: builtins.int = ...,
        tokens: builtins.int = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        original_file_uid: builtins.str = ...,
        content_type: global___ContentType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk_uid", b"chunk_uid", "content_type", b"content_type", "create_time", b"create_time", "end_pos", b"end_pos", "original_file_uid", b"original_file_uid", "retrievable", b"retrievable", "start_pos", b"start_pos", "tokens", b"tokens"]) -> None: ...

global___Chunk = Chunk

@typing_extensions.final
class ListChunksRequest(google.protobuf.message.Message):
    """The ListChunksRequest message represents a request to list chunks in the artifact system.
    The response will be a list of chunks based on the request, i.e., response will
    have chunks of the file with file_uid and chunks specified in chunk_uids.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner/namespace id (not uid)"""
    catalog_id: builtins.str
    """catalog id (not uid)"""
    file_uid: builtins.str
    """unique identifier of the file"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "file_uid", b"file_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___ListChunksRequest = ListChunksRequest

@typing_extensions.final
class ListChunksResponse(google.protobuf.message.Message):
    """The ListChunksResponse message represents a response containing a list of chunks in the artifact system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNKS_FIELD_NUMBER: builtins.int
    @property
    def chunks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Chunk]:
        """repeated chunks"""
    def __init__(
        self,
        *,
        chunks: collections.abc.Iterable[global___Chunk] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunks", b"chunks"]) -> None: ...

global___ListChunksResponse = ListChunksResponse

@typing_extensions.final
class SearchChunksRequest(google.protobuf.message.Message):
    """Search chunks request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHUNK_UIDS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner/namespace id (not uid)"""
    @property
    def chunk_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """chunk uids"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chunk_uids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk_uids", b"chunk_uids", "namespace_id", b"namespace_id"]) -> None: ...

global___SearchChunksRequest = SearchChunksRequest

@typing_extensions.final
class SearchChunksResponse(google.protobuf.message.Message):
    """Search chunks response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNKS_FIELD_NUMBER: builtins.int
    @property
    def chunks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Chunk]:
        """repeated chunks"""
    def __init__(
        self,
        *,
        chunks: collections.abc.Iterable[global___Chunk] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunks", b"chunks"]) -> None: ...

global___SearchChunksResponse = SearchChunksResponse

@typing_extensions.final
class SourceFile(google.protobuf.message.Message):
    """The SourceFile message represents a source file in the artifact system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGINAL_FILE_UID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    ORIGINAL_FILE_NAME_FIELD_NUMBER: builtins.int
    original_file_uid: builtins.str
    """original file unique identifier"""
    content: builtins.str
    """content"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """creation time of the source file"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """update time of the source file"""
    original_file_name: builtins.str
    """original file name"""
    def __init__(
        self,
        *,
        original_file_uid: builtins.str = ...,
        content: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        original_file_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "create_time", b"create_time", "original_file_name", b"original_file_name", "original_file_uid", b"original_file_uid", "update_time", b"update_time"]) -> None: ...

global___SourceFile = SourceFile

@typing_extensions.final
class GetSourceFileRequest(google.protobuf.message.Message):
    """get source file request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner/namespace id"""
    catalog_id: builtins.str
    """catalog id"""
    file_uid: builtins.str
    """unique identifier of the original uploaded file"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "file_uid", b"file_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___GetSourceFileRequest = GetSourceFileRequest

@typing_extensions.final
class GetSourceFileResponse(google.protobuf.message.Message):
    """get source file response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_FILE_FIELD_NUMBER: builtins.int
    @property
    def source_file(self) -> global___SourceFile:
        """source file(either original file or converted file)"""
    def __init__(
        self,
        *,
        source_file: global___SourceFile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["source_file", b"source_file"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["source_file", b"source_file"]) -> None: ...

global___GetSourceFileResponse = GetSourceFileResponse

@typing_extensions.final
class GetFileSummaryRequest(google.protobuf.message.Message):
    """get file summary request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner/namespace id"""
    catalog_id: builtins.str
    """catalog id"""
    file_uid: builtins.str
    """unique identifier of the original uploaded file"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        file_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "file_uid", b"file_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___GetFileSummaryRequest = GetFileSummaryRequest

@typing_extensions.final
class GetFileSummaryResponse(google.protobuf.message.Message):
    """get file summary response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUMMARY_FIELD_NUMBER: builtins.int
    summary: builtins.str
    """summary of the file"""
    def __init__(
        self,
        *,
        summary: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["summary", b"summary"]) -> None: ...

global___GetFileSummaryResponse = GetFileSummaryResponse

@typing_extensions.final
class SearchSourceFilesRequest(google.protobuf.message.Message):
    """search source file request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    FILE_UIDS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner/namespace id"""
    @property
    def file_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """search file uid"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        file_uids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uids", b"file_uids", "namespace_id", b"namespace_id"]) -> None: ...

global___SearchSourceFilesRequest = SearchSourceFilesRequest

@typing_extensions.final
class SearchSourceFilesResponse(google.protobuf.message.Message):
    """search source file response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SOURCE_FILES_FIELD_NUMBER: builtins.int
    @property
    def source_files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceFile]:
        """source files"""
    def __init__(
        self,
        *,
        source_files: collections.abc.Iterable[global___SourceFile] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["source_files", b"source_files"]) -> None: ...

global___SearchSourceFilesResponse = SearchSourceFilesResponse

@typing_extensions.final
class UpdateChunkRequest(google.protobuf.message.Message):
    """Create chunk response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_UID_FIELD_NUMBER: builtins.int
    RETRIEVABLE_FIELD_NUMBER: builtins.int
    chunk_uid: builtins.str
    """chunk uid"""
    retrievable: builtins.bool
    """whether the chunk is retrievable"""
    def __init__(
        self,
        *,
        chunk_uid: builtins.str = ...,
        retrievable: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk_uid", b"chunk_uid", "retrievable", b"retrievable"]) -> None: ...

global___UpdateChunkRequest = UpdateChunkRequest

@typing_extensions.final
class UpdateChunkResponse(google.protobuf.message.Message):
    """update chunk response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_FIELD_NUMBER: builtins.int
    @property
    def chunk(self) -> global___Chunk:
        """chunk"""
    def __init__(
        self,
        *,
        chunk: global___Chunk | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["chunk", b"chunk"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk", b"chunk"]) -> None: ...

global___UpdateChunkResponse = UpdateChunkResponse

@typing_extensions.final
class SimilarityChunksSearchRequest(google.protobuf.message.Message):
    """Similar chunk search request"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    TEXT_PROMPT_FIELD_NUMBER: builtins.int
    TOP_K_FIELD_NUMBER: builtins.int
    FILE_NAME_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    FILE_MEDIA_TYPE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """owner/namespace id"""
    catalog_id: builtins.str
    """catalog id"""
    text_prompt: builtins.str
    """text prompt"""
    top_k: builtins.int
    """top k"""
    file_name: builtins.str
    """file name"""
    content_type: global___ContentType.ValueType
    """content type"""
    file_media_type: global___FileMediaType.ValueType
    """file type"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        text_prompt: builtins.str = ...,
        top_k: builtins.int = ...,
        file_name: builtins.str = ...,
        content_type: global___ContentType.ValueType = ...,
        file_media_type: global___FileMediaType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "content_type", b"content_type", "file_media_type", b"file_media_type", "file_name", b"file_name", "namespace_id", b"namespace_id", "text_prompt", b"text_prompt", "top_k", b"top_k"]) -> None: ...

global___SimilarityChunksSearchRequest = SimilarityChunksSearchRequest

@typing_extensions.final
class SimilarityChunksSearchResponse(google.protobuf.message.Message):
    """Similar chunk search response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMILAR_CHUNKS_FIELD_NUMBER: builtins.int
    @property
    def similar_chunks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SimilarityChunk]:
        """chunks"""
    def __init__(
        self,
        *,
        similar_chunks: collections.abc.Iterable[global___SimilarityChunk] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["similar_chunks", b"similar_chunks"]) -> None: ...

global___SimilarityChunksSearchResponse = SimilarityChunksSearchResponse

@typing_extensions.final
class SimilarityChunk(google.protobuf.message.Message):
    """similarity chunks"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHUNK_UID_FIELD_NUMBER: builtins.int
    SIMILARITY_SCORE_FIELD_NUMBER: builtins.int
    TEXT_CONTENT_FIELD_NUMBER: builtins.int
    SOURCE_FILE_FIELD_NUMBER: builtins.int
    CHUNK_METADATA_FIELD_NUMBER: builtins.int
    chunk_uid: builtins.str
    """chunk uid"""
    similarity_score: builtins.float
    """similarity score"""
    text_content: builtins.str
    """content"""
    source_file: builtins.str
    """source file's name"""
    @property
    def chunk_metadata(self) -> global___Chunk:
        """chunk"""
    def __init__(
        self,
        *,
        chunk_uid: builtins.str = ...,
        similarity_score: builtins.float = ...,
        text_content: builtins.str = ...,
        source_file: builtins.str = ...,
        chunk_metadata: global___Chunk | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["chunk_metadata", b"chunk_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunk_metadata", b"chunk_metadata", "chunk_uid", b"chunk_uid", "similarity_score", b"similarity_score", "source_file", b"source_file", "text_content", b"text_content"]) -> None: ...

global___SimilarityChunk = SimilarityChunk
