"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2017 The Ray Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _EncodingType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EncodingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EncodingType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TEXT: _EncodingType.ValueType  # 0
    JSON: _EncodingType.ValueType  # 1

class EncodingType(_EncodingType, metaclass=_EncodingTypeEnumTypeWrapper):
    """[Begin] LOGGING CONFIG
    Encoding type
    """

TEXT: EncodingType.ValueType  # 0
JSON: EncodingType.ValueType  # 1
global___EncodingType = EncodingType

class _DeploymentLanguage:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentLanguageEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentLanguage.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PYTHON: _DeploymentLanguage.ValueType  # 0
    JAVA: _DeploymentLanguage.ValueType  # 1

class DeploymentLanguage(_DeploymentLanguage, metaclass=_DeploymentLanguageEnumTypeWrapper):
    """Deployment language."""

PYTHON: DeploymentLanguage.ValueType  # 0
JAVA: DeploymentLanguage.ValueType  # 1
global___DeploymentLanguage = DeploymentLanguage

class _TargetCapacityDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TargetCapacityDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TargetCapacityDirection.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNSET: _TargetCapacityDirection.ValueType  # 0
    UP: _TargetCapacityDirection.ValueType  # 1
    DOWN: _TargetCapacityDirection.ValueType  # 2

class TargetCapacityDirection(_TargetCapacityDirection, metaclass=_TargetCapacityDirectionEnumTypeWrapper): ...

UNSET: TargetCapacityDirection.ValueType  # 0
UP: TargetCapacityDirection.ValueType  # 1
DOWN: TargetCapacityDirection.ValueType  # 2
global___TargetCapacityDirection = TargetCapacityDirection

class _DeploymentStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DEPLOYMENT_STATUS_UPDATING: _DeploymentStatus.ValueType  # 0
    """Keep frontend code of ServeDeploymentStatus in
    dashboard/client/src/type/serve.ts in sync with this enum
    """
    DEPLOYMENT_STATUS_HEALTHY: _DeploymentStatus.ValueType  # 1
    DEPLOYMENT_STATUS_UNHEALTHY: _DeploymentStatus.ValueType  # 2
    DEPLOYMENT_STATUS_DEPLOY_FAILED: _DeploymentStatus.ValueType  # 3
    DEPLOYMENT_STATUS_UPSCALING: _DeploymentStatus.ValueType  # 4
    DEPLOYMENT_STATUS_DOWNSCALING: _DeploymentStatus.ValueType  # 5

class DeploymentStatus(_DeploymentStatus, metaclass=_DeploymentStatusEnumTypeWrapper): ...

DEPLOYMENT_STATUS_UPDATING: DeploymentStatus.ValueType  # 0
"""Keep frontend code of ServeDeploymentStatus in
dashboard/client/src/type/serve.ts in sync with this enum
"""
DEPLOYMENT_STATUS_HEALTHY: DeploymentStatus.ValueType  # 1
DEPLOYMENT_STATUS_UNHEALTHY: DeploymentStatus.ValueType  # 2
DEPLOYMENT_STATUS_DEPLOY_FAILED: DeploymentStatus.ValueType  # 3
DEPLOYMENT_STATUS_UPSCALING: DeploymentStatus.ValueType  # 4
DEPLOYMENT_STATUS_DOWNSCALING: DeploymentStatus.ValueType  # 5
global___DeploymentStatus = DeploymentStatus

class _DeploymentStatusTrigger:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeploymentStatusTriggerEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeploymentStatusTrigger.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DEPLOYMENT_STATUS_TRIGGER_UNSPECIFIED: _DeploymentStatusTrigger.ValueType  # 0
    DEPLOYMENT_STATUS_TRIGGER_CONFIG_UPDATE_STARTED: _DeploymentStatusTrigger.ValueType  # 1
    DEPLOYMENT_STATUS_TRIGGER_CONFIG_UPDATE_COMPLETED: _DeploymentStatusTrigger.ValueType  # 2
    DEPLOYMENT_STATUS_TRIGGER_UPSCALE_COMPLETED: _DeploymentStatusTrigger.ValueType  # 3
    DEPLOYMENT_STATUS_TRIGGER_DOWNSCALE_COMPLETED: _DeploymentStatusTrigger.ValueType  # 4
    DEPLOYMENT_STATUS_TRIGGER_AUTOSCALING: _DeploymentStatusTrigger.ValueType  # 5
    DEPLOYMENT_STATUS_TRIGGER_REPLICA_STARTUP_FAILED: _DeploymentStatusTrigger.ValueType  # 6
    DEPLOYMENT_STATUS_TRIGGER_HEALTH_CHECK_FAILED: _DeploymentStatusTrigger.ValueType  # 7
    DEPLOYMENT_STATUS_TRIGGER_INTERNAL_ERROR: _DeploymentStatusTrigger.ValueType  # 8
    DEPLOYMENT_STATUS_TRIGGER_DELETING: _DeploymentStatusTrigger.ValueType  # 9

class DeploymentStatusTrigger(_DeploymentStatusTrigger, metaclass=_DeploymentStatusTriggerEnumTypeWrapper): ...

DEPLOYMENT_STATUS_TRIGGER_UNSPECIFIED: DeploymentStatusTrigger.ValueType  # 0
DEPLOYMENT_STATUS_TRIGGER_CONFIG_UPDATE_STARTED: DeploymentStatusTrigger.ValueType  # 1
DEPLOYMENT_STATUS_TRIGGER_CONFIG_UPDATE_COMPLETED: DeploymentStatusTrigger.ValueType  # 2
DEPLOYMENT_STATUS_TRIGGER_UPSCALE_COMPLETED: DeploymentStatusTrigger.ValueType  # 3
DEPLOYMENT_STATUS_TRIGGER_DOWNSCALE_COMPLETED: DeploymentStatusTrigger.ValueType  # 4
DEPLOYMENT_STATUS_TRIGGER_AUTOSCALING: DeploymentStatusTrigger.ValueType  # 5
DEPLOYMENT_STATUS_TRIGGER_REPLICA_STARTUP_FAILED: DeploymentStatusTrigger.ValueType  # 6
DEPLOYMENT_STATUS_TRIGGER_HEALTH_CHECK_FAILED: DeploymentStatusTrigger.ValueType  # 7
DEPLOYMENT_STATUS_TRIGGER_INTERNAL_ERROR: DeploymentStatusTrigger.ValueType  # 8
DEPLOYMENT_STATUS_TRIGGER_DELETING: DeploymentStatusTrigger.ValueType  # 9
global___DeploymentStatusTrigger = DeploymentStatusTrigger

class _ApplicationStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ApplicationStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ApplicationStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    APPLICATION_STATUS_DEPLOYING: _ApplicationStatus.ValueType  # 0
    """Keep frontend code of ServeApplicationStatus in
    dashboard/client/src/type/serve.ts in sync with this enum
    """
    APPLICATION_STATUS_RUNNING: _ApplicationStatus.ValueType  # 1
    APPLICATION_STATUS_DEPLOY_FAILED: _ApplicationStatus.ValueType  # 2
    APPLICATION_STATUS_DELETING: _ApplicationStatus.ValueType  # 3
    APPLICATION_STATUS_NOT_STARTED: _ApplicationStatus.ValueType  # 5
    APPLICATION_STATUS_UNHEALTHY: _ApplicationStatus.ValueType  # 6

class ApplicationStatus(_ApplicationStatus, metaclass=_ApplicationStatusEnumTypeWrapper): ...

APPLICATION_STATUS_DEPLOYING: ApplicationStatus.ValueType  # 0
"""Keep frontend code of ServeApplicationStatus in
dashboard/client/src/type/serve.ts in sync with this enum
"""
APPLICATION_STATUS_RUNNING: ApplicationStatus.ValueType  # 1
APPLICATION_STATUS_DEPLOY_FAILED: ApplicationStatus.ValueType  # 2
APPLICATION_STATUS_DELETING: ApplicationStatus.ValueType  # 3
APPLICATION_STATUS_NOT_STARTED: ApplicationStatus.ValueType  # 5
APPLICATION_STATUS_UNHEALTHY: ApplicationStatus.ValueType  # 6
global___ApplicationStatus = ApplicationStatus

@typing_extensions.final
class AutoscalingConfig(google.protobuf.message.Message):
    """Configuration options for Serve's replica autoscaler."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_REPLICAS_FIELD_NUMBER: builtins.int
    MAX_REPLICAS_FIELD_NUMBER: builtins.int
    METRICS_INTERVAL_S_FIELD_NUMBER: builtins.int
    LOOK_BACK_PERIOD_S_FIELD_NUMBER: builtins.int
    SMOOTHING_FACTOR_FIELD_NUMBER: builtins.int
    DOWNSCALE_DELAY_S_FIELD_NUMBER: builtins.int
    UPSCALE_DELAY_S_FIELD_NUMBER: builtins.int
    INITIAL_REPLICAS_FIELD_NUMBER: builtins.int
    UPSCALE_SMOOTHING_FACTOR_FIELD_NUMBER: builtins.int
    DOWNSCALE_SMOOTHING_FACTOR_FIELD_NUMBER: builtins.int
    _SERIALIZED_POLICY_DEF_FIELD_NUMBER: builtins.int
    _POLICY_FIELD_NUMBER: builtins.int
    TARGET_ONGOING_REQUESTS_FIELD_NUMBER: builtins.int
    UPSCALING_FACTOR_FIELD_NUMBER: builtins.int
    DOWNSCALING_FACTOR_FIELD_NUMBER: builtins.int
    min_replicas: builtins.int
    """Minimal number of replicas, must be a non-negative integer."""
    max_replicas: builtins.int
    """Maximal number of replicas, must be a non-negative integer and greater or
    equals to min_replicas.
    """
    metrics_interval_s: builtins.float
    """The frequency of how long does each replica sending metrics to autoscaler."""
    look_back_period_s: builtins.float
    """The window (in seconds) for autoscaler to calculate rolling average of
    metrics on.
    """
    smoothing_factor: builtins.float
    """[DEPRECATED] Use `upscaling_factor` and/or `downscaling_factor` instead."""
    downscale_delay_s: builtins.float
    """How long to wait before scaling down replicas."""
    upscale_delay_s: builtins.float
    """How long to wait before scaling up replicas."""
    initial_replicas: builtins.int
    """Initial number of replicas deployment should start with. Must be
    non-negative.
    """
    upscale_smoothing_factor: builtins.float
    """[DEPRECATED] Use `upscaling_factor` instead."""
    downscale_smoothing_factor: builtins.float
    """[DEPRECATED] Use `downscaling_factor` instead."""
    _serialized_policy_def: builtins.bytes
    """The cloudpickled policy definition."""
    _policy: builtins.str
    """The import path of the policy if user passed a string. Will be the
    concatenation of the policy module and the policy name if user passed a
    callable.
    """
    target_ongoing_requests: builtins.float
    """Target number of in flight requests per replica. This is the primary
    configuration knob for replica autoscaler. Lower the number, the more
    rapidly the replicas scales up. Must be a non-negative integer.
    """
    upscaling_factor: builtins.float
    """The multiplicative "gain" factor to limit upscale."""
    downscaling_factor: builtins.float
    """The multiplicative "gain" factor to limit downscale."""
    def __init__(
        self,
        *,
        min_replicas: builtins.int = ...,
        max_replicas: builtins.int = ...,
        metrics_interval_s: builtins.float = ...,
        look_back_period_s: builtins.float = ...,
        smoothing_factor: builtins.float = ...,
        downscale_delay_s: builtins.float = ...,
        upscale_delay_s: builtins.float = ...,
        initial_replicas: builtins.int | None = ...,
        upscale_smoothing_factor: builtins.float | None = ...,
        downscale_smoothing_factor: builtins.float | None = ...,
        _serialized_policy_def: builtins.bytes = ...,
        _policy: builtins.str = ...,
        target_ongoing_requests: builtins.float = ...,
        upscaling_factor: builtins.float | None = ...,
        downscaling_factor: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_downscale_smoothing_factor", b"_downscale_smoothing_factor", "_downscaling_factor", b"_downscaling_factor", "_initial_replicas", b"_initial_replicas", "_upscale_smoothing_factor", b"_upscale_smoothing_factor", "_upscaling_factor", b"_upscaling_factor", "downscale_smoothing_factor", b"downscale_smoothing_factor", "downscaling_factor", b"downscaling_factor", "initial_replicas", b"initial_replicas", "upscale_smoothing_factor", b"upscale_smoothing_factor", "upscaling_factor", b"upscaling_factor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_downscale_smoothing_factor", b"_downscale_smoothing_factor", "_downscaling_factor", b"_downscaling_factor", "_initial_replicas", b"_initial_replicas", "_policy", b"_policy", "_serialized_policy_def", b"_serialized_policy_def", "_upscale_smoothing_factor", b"_upscale_smoothing_factor", "_upscaling_factor", b"_upscaling_factor", "downscale_delay_s", b"downscale_delay_s", "downscale_smoothing_factor", b"downscale_smoothing_factor", "downscaling_factor", b"downscaling_factor", "initial_replicas", b"initial_replicas", "look_back_period_s", b"look_back_period_s", "max_replicas", b"max_replicas", "metrics_interval_s", b"metrics_interval_s", "min_replicas", b"min_replicas", "smoothing_factor", b"smoothing_factor", "target_ongoing_requests", b"target_ongoing_requests", "upscale_delay_s", b"upscale_delay_s", "upscale_smoothing_factor", b"upscale_smoothing_factor", "upscaling_factor", b"upscaling_factor"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_downscale_smoothing_factor", b"_downscale_smoothing_factor"]) -> typing_extensions.Literal["downscale_smoothing_factor"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_downscaling_factor", b"_downscaling_factor"]) -> typing_extensions.Literal["downscaling_factor"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_initial_replicas", b"_initial_replicas"]) -> typing_extensions.Literal["initial_replicas"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_upscale_smoothing_factor", b"_upscale_smoothing_factor"]) -> typing_extensions.Literal["upscale_smoothing_factor"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_upscaling_factor", b"_upscaling_factor"]) -> typing_extensions.Literal["upscaling_factor"] | None: ...

global___AutoscalingConfig = AutoscalingConfig

@typing_extensions.final
class LoggingConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENCODING_FIELD_NUMBER: builtins.int
    LOG_LEVEL_FIELD_NUMBER: builtins.int
    LOGS_DIR_FIELD_NUMBER: builtins.int
    ENABLE_ACCESS_LOG_FIELD_NUMBER: builtins.int
    ADDITIONAL_LOG_STANDARD_ATTRS_FIELD_NUMBER: builtins.int
    encoding: global___EncodingType.ValueType
    log_level: builtins.str
    logs_dir: builtins.str
    enable_access_log: builtins.bool
    @property
    def additional_log_standard_attrs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        encoding: global___EncodingType.ValueType = ...,
        log_level: builtins.str = ...,
        logs_dir: builtins.str = ...,
        enable_access_log: builtins.bool = ...,
        additional_log_standard_attrs: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["additional_log_standard_attrs", b"additional_log_standard_attrs", "enable_access_log", b"enable_access_log", "encoding", b"encoding", "log_level", b"log_level", "logs_dir", b"logs_dir"]) -> None: ...

global___LoggingConfig = LoggingConfig

@typing_extensions.final
class DeploymentConfig(google.protobuf.message.Message):
    """[End] Logging Config

    Configuration options for a deployment, to be set by the user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_REPLICAS_FIELD_NUMBER: builtins.int
    MAX_ONGOING_REQUESTS_FIELD_NUMBER: builtins.int
    MAX_QUEUED_REQUESTS_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    GRACEFUL_SHUTDOWN_WAIT_LOOP_S_FIELD_NUMBER: builtins.int
    GRACEFUL_SHUTDOWN_TIMEOUT_S_FIELD_NUMBER: builtins.int
    HEALTH_CHECK_PERIOD_S_FIELD_NUMBER: builtins.int
    HEALTH_CHECK_TIMEOUT_S_FIELD_NUMBER: builtins.int
    IS_CROSS_LANGUAGE_FIELD_NUMBER: builtins.int
    DEPLOYMENT_LANGUAGE_FIELD_NUMBER: builtins.int
    AUTOSCALING_CONFIG_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    USER_CONFIGURED_OPTION_NAMES_FIELD_NUMBER: builtins.int
    LOGGING_CONFIG_FIELD_NUMBER: builtins.int
    num_replicas: builtins.int
    """The number of processes to start up that will handle requests to this
    deployment.
    """
    max_ongoing_requests: builtins.int
    """The maximum number of queries that will be sent to a replica of this
    deployment without receiving a response.
    """
    max_queued_requests: builtins.int
    """The maximum number of requests that will be queued in deployment handles."""
    user_config: builtins.bytes
    """Arguments to pass to the reconfigure method of the deployment. The
    reconfigure method is called if user_config is not None.
    """
    graceful_shutdown_wait_loop_s: builtins.float
    """Duration that deployment replicas will wait until there is no more work to
    be done before shutting down.
    """
    graceful_shutdown_timeout_s: builtins.float
    """Controller waits for this duration to forcefully kill the replica for
    shutdown.
    """
    health_check_period_s: builtins.float
    """Frequency at which the controller health checks replicas."""
    health_check_timeout_s: builtins.float
    """Timeout after which a replica is marked unhealthy without a response."""
    is_cross_language: builtins.bool
    """Is the construction of deployment is cross language?"""
    deployment_language: global___DeploymentLanguage.ValueType
    """The deployment's programming language."""
    @property
    def autoscaling_config(self) -> global___AutoscalingConfig:
        """The deployment's autoscaling configuration."""
    version: builtins.str
    @property
    def user_configured_option_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def logging_config(self) -> global___LoggingConfig: ...
    def __init__(
        self,
        *,
        num_replicas: builtins.int = ...,
        max_ongoing_requests: builtins.int = ...,
        max_queued_requests: builtins.int = ...,
        user_config: builtins.bytes = ...,
        graceful_shutdown_wait_loop_s: builtins.float = ...,
        graceful_shutdown_timeout_s: builtins.float = ...,
        health_check_period_s: builtins.float = ...,
        health_check_timeout_s: builtins.float = ...,
        is_cross_language: builtins.bool = ...,
        deployment_language: global___DeploymentLanguage.ValueType = ...,
        autoscaling_config: global___AutoscalingConfig | None = ...,
        version: builtins.str = ...,
        user_configured_option_names: collections.abc.Iterable[builtins.str] | None = ...,
        logging_config: global___LoggingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["autoscaling_config", b"autoscaling_config", "logging_config", b"logging_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["autoscaling_config", b"autoscaling_config", "deployment_language", b"deployment_language", "graceful_shutdown_timeout_s", b"graceful_shutdown_timeout_s", "graceful_shutdown_wait_loop_s", b"graceful_shutdown_wait_loop_s", "health_check_period_s", b"health_check_period_s", "health_check_timeout_s", b"health_check_timeout_s", "is_cross_language", b"is_cross_language", "logging_config", b"logging_config", "max_ongoing_requests", b"max_ongoing_requests", "max_queued_requests", b"max_queued_requests", "num_replicas", b"num_replicas", "user_config", b"user_config", "user_configured_option_names", b"user_configured_option_names", "version", b"version"]) -> None: ...

global___DeploymentConfig = DeploymentConfig

@typing_extensions.final
class RequestMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ContextEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REQUEST_ID_FIELD_NUMBER: builtins.int
    INTERNAL_REQUEST_ID_FIELD_NUMBER: builtins.int
    CALL_METHOD_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    MULTIPLEXED_MODEL_ID_FIELD_NUMBER: builtins.int
    ROUTE_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    internal_request_id: builtins.str
    call_method: builtins.str
    @property
    def context(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    multiplexed_model_id: builtins.str
    route: builtins.str
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        internal_request_id: builtins.str = ...,
        call_method: builtins.str = ...,
        context: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        multiplexed_model_id: builtins.str = ...,
        route: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["call_method", b"call_method", "context", b"context", "internal_request_id", b"internal_request_id", "multiplexed_model_id", b"multiplexed_model_id", "request_id", b"request_id", "route", b"route"]) -> None: ...

global___RequestMetadata = RequestMetadata

@typing_extensions.final
class RequestWrapper(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BODY_FIELD_NUMBER: builtins.int
    body: builtins.bytes
    def __init__(
        self,
        *,
        body: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["body", b"body"]) -> None: ...

global___RequestWrapper = RequestWrapper

@typing_extensions.final
class UpdatedObject(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OBJECT_SNAPSHOT_FIELD_NUMBER: builtins.int
    SNAPSHOT_ID_FIELD_NUMBER: builtins.int
    object_snapshot: builtins.bytes
    snapshot_id: builtins.int
    def __init__(
        self,
        *,
        object_snapshot: builtins.bytes = ...,
        snapshot_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["object_snapshot", b"object_snapshot", "snapshot_id", b"snapshot_id"]) -> None: ...

global___UpdatedObject = UpdatedObject

@typing_extensions.final
class LongPollRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class KeysToSnapshotIdsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    KEYS_TO_SNAPSHOT_IDS_FIELD_NUMBER: builtins.int
    @property
    def keys_to_snapshot_ids(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]: ...
    def __init__(
        self,
        *,
        keys_to_snapshot_ids: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["keys_to_snapshot_ids", b"keys_to_snapshot_ids"]) -> None: ...

global___LongPollRequest = LongPollRequest

@typing_extensions.final
class LongPollResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class UpdatedObjectsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___UpdatedObject: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___UpdatedObject | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    UPDATED_OBJECTS_FIELD_NUMBER: builtins.int
    @property
    def updated_objects(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___UpdatedObject]: ...
    def __init__(
        self,
        *,
        updated_objects: collections.abc.Mapping[builtins.str, global___UpdatedObject] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["updated_objects", b"updated_objects"]) -> None: ...

global___LongPollResult = LongPollResult

@typing_extensions.final
class EndpointInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ConfigEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENDPOINT_NAME_FIELD_NUMBER: builtins.int
    ROUTE_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    endpoint_name: builtins.str
    route: builtins.str
    @property
    def config(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        endpoint_name: builtins.str = ...,
        route: builtins.str = ...,
        config: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "endpoint_name", b"endpoint_name", "route", b"route"]) -> None: ...

global___EndpointInfo = EndpointInfo

@typing_extensions.final
class EndpointSet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class EndpointsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___EndpointInfo: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___EndpointInfo | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENDPOINTS_FIELD_NUMBER: builtins.int
    @property
    def endpoints(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___EndpointInfo]: ...
    def __init__(
        self,
        *,
        endpoints: collections.abc.Mapping[builtins.str, global___EndpointInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["endpoints", b"endpoints"]) -> None: ...

global___EndpointSet = EndpointSet

@typing_extensions.final
class ActorNameList(google.protobuf.message.Message):
    """Now Actor handle can be transfered across language through ray call, but the
    list of Actor handles can't. So we use this message wrapped a Actor name list
    to pass actor list across language. When Actor handle list supports across
    language, this message can be replaced.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMES_FIELD_NUMBER: builtins.int
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["names", b"names"]) -> None: ...

global___ActorNameList = ActorNameList

@typing_extensions.final
class DeploymentTargetInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPLICA_NAMES_FIELD_NUMBER: builtins.int
    IS_AVAILABLE_FIELD_NUMBER: builtins.int
    @property
    def replica_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    is_available: builtins.bool
    def __init__(
        self,
        *,
        replica_names: collections.abc.Iterable[builtins.str] | None = ...,
        is_available: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_available", b"is_available", "replica_names", b"replica_names"]) -> None: ...

global___DeploymentTargetInfo = DeploymentTargetInfo

@typing_extensions.final
class DeploymentVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_VERSION_FIELD_NUMBER: builtins.int
    DEPLOYMENT_CONFIG_FIELD_NUMBER: builtins.int
    RAY_ACTOR_OPTIONS_FIELD_NUMBER: builtins.int
    PLACEMENT_GROUP_BUNDLES_FIELD_NUMBER: builtins.int
    PLACEMENT_GROUP_STRATEGY_FIELD_NUMBER: builtins.int
    MAX_REPLICAS_PER_NODE_FIELD_NUMBER: builtins.int
    code_version: builtins.str
    @property
    def deployment_config(self) -> global___DeploymentConfig: ...
    ray_actor_options: builtins.str
    placement_group_bundles: builtins.str
    placement_group_strategy: builtins.str
    max_replicas_per_node: builtins.int
    def __init__(
        self,
        *,
        code_version: builtins.str = ...,
        deployment_config: global___DeploymentConfig | None = ...,
        ray_actor_options: builtins.str = ...,
        placement_group_bundles: builtins.str = ...,
        placement_group_strategy: builtins.str = ...,
        max_replicas_per_node: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_config", b"deployment_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["code_version", b"code_version", "deployment_config", b"deployment_config", "max_replicas_per_node", b"max_replicas_per_node", "placement_group_bundles", b"placement_group_bundles", "placement_group_strategy", b"placement_group_strategy", "ray_actor_options", b"ray_actor_options"]) -> None: ...

global___DeploymentVersion = DeploymentVersion

@typing_extensions.final
class ReplicaConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_DEF_NAME_FIELD_NUMBER: builtins.int
    DEPLOYMENT_DEF_FIELD_NUMBER: builtins.int
    INIT_ARGS_FIELD_NUMBER: builtins.int
    INIT_KWARGS_FIELD_NUMBER: builtins.int
    RAY_ACTOR_OPTIONS_FIELD_NUMBER: builtins.int
    PLACEMENT_GROUP_BUNDLES_FIELD_NUMBER: builtins.int
    PLACEMENT_GROUP_STRATEGY_FIELD_NUMBER: builtins.int
    MAX_REPLICAS_PER_NODE_FIELD_NUMBER: builtins.int
    deployment_def_name: builtins.str
    deployment_def: builtins.bytes
    init_args: builtins.bytes
    init_kwargs: builtins.bytes
    ray_actor_options: builtins.str
    placement_group_bundles: builtins.str
    placement_group_strategy: builtins.str
    max_replicas_per_node: builtins.int
    def __init__(
        self,
        *,
        deployment_def_name: builtins.str = ...,
        deployment_def: builtins.bytes = ...,
        init_args: builtins.bytes = ...,
        init_kwargs: builtins.bytes = ...,
        ray_actor_options: builtins.str = ...,
        placement_group_bundles: builtins.str = ...,
        placement_group_strategy: builtins.str = ...,
        max_replicas_per_node: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_def", b"deployment_def", "deployment_def_name", b"deployment_def_name", "init_args", b"init_args", "init_kwargs", b"init_kwargs", "max_replicas_per_node", b"max_replicas_per_node", "placement_group_bundles", b"placement_group_bundles", "placement_group_strategy", b"placement_group_strategy", "ray_actor_options", b"ray_actor_options"]) -> None: ...

global___ReplicaConfig = ReplicaConfig

@typing_extensions.final
class DeploymentInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DEPLOYMENT_CONFIG_FIELD_NUMBER: builtins.int
    REPLICA_CONFIG_FIELD_NUMBER: builtins.int
    START_TIME_MS_FIELD_NUMBER: builtins.int
    ACTOR_NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    END_TIME_MS_FIELD_NUMBER: builtins.int
    TARGET_CAPACITY_FIELD_NUMBER: builtins.int
    TARGET_CAPACITY_DIRECTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def deployment_config(self) -> global___DeploymentConfig: ...
    @property
    def replica_config(self) -> global___ReplicaConfig: ...
    start_time_ms: builtins.int
    actor_name: builtins.str
    version: builtins.str
    end_time_ms: builtins.int
    target_capacity: builtins.float
    target_capacity_direction: global___TargetCapacityDirection.ValueType
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        deployment_config: global___DeploymentConfig | None = ...,
        replica_config: global___ReplicaConfig | None = ...,
        start_time_ms: builtins.int = ...,
        actor_name: builtins.str = ...,
        version: builtins.str = ...,
        end_time_ms: builtins.int = ...,
        target_capacity: builtins.float = ...,
        target_capacity_direction: global___TargetCapacityDirection.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_config", b"deployment_config", "replica_config", b"replica_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["actor_name", b"actor_name", "deployment_config", b"deployment_config", "end_time_ms", b"end_time_ms", "name", b"name", "replica_config", b"replica_config", "start_time_ms", b"start_time_ms", "target_capacity", b"target_capacity", "target_capacity_direction", b"target_capacity_direction", "version", b"version"]) -> None: ...

global___DeploymentInfo = DeploymentInfo

@typing_extensions.final
class DeploymentRoute(google.protobuf.message.Message):
    """Wrap DeploymentInfo and route. The "" route value need to be convert to
    None/null.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_INFO_FIELD_NUMBER: builtins.int
    ROUTE_FIELD_NUMBER: builtins.int
    @property
    def deployment_info(self) -> global___DeploymentInfo: ...
    route: builtins.str
    def __init__(
        self,
        *,
        deployment_info: global___DeploymentInfo | None = ...,
        route: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deployment_info", b"deployment_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_info", b"deployment_info", "route", b"route"]) -> None: ...

global___DeploymentRoute = DeploymentRoute

@typing_extensions.final
class DeploymentRouteList(google.protobuf.message.Message):
    """Wrap a list for DeploymentRoute."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_ROUTES_FIELD_NUMBER: builtins.int
    @property
    def deployment_routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeploymentRoute]: ...
    def __init__(
        self,
        *,
        deployment_routes: collections.abc.Iterable[global___DeploymentRoute] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_routes", b"deployment_routes"]) -> None: ...

global___DeploymentRouteList = DeploymentRouteList

@typing_extensions.final
class DeploymentStatusInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    STATUS_TRIGGER_FIELD_NUMBER: builtins.int
    name: builtins.str
    status: global___DeploymentStatus.ValueType
    message: builtins.str
    status_trigger: global___DeploymentStatusTrigger.ValueType
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        status: global___DeploymentStatus.ValueType = ...,
        message: builtins.str = ...,
        status_trigger: global___DeploymentStatusTrigger.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "name", b"name", "status", b"status", "status_trigger", b"status_trigger"]) -> None: ...

global___DeploymentStatusInfo = DeploymentStatusInfo

@typing_extensions.final
class DeploymentStatusInfoList(google.protobuf.message.Message):
    """Wrap a list for DeploymentStatusInfo."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_STATUS_INFOS_FIELD_NUMBER: builtins.int
    @property
    def deployment_status_infos(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeploymentStatusInfo]: ...
    def __init__(
        self,
        *,
        deployment_status_infos: collections.abc.Iterable[global___DeploymentStatusInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_status_infos", b"deployment_status_infos"]) -> None: ...

global___DeploymentStatusInfoList = DeploymentStatusInfoList

@typing_extensions.final
class ApplicationStatusInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    DEPLOYMENT_TIMESTAMP_FIELD_NUMBER: builtins.int
    status: global___ApplicationStatus.ValueType
    message: builtins.str
    deployment_timestamp: builtins.float
    def __init__(
        self,
        *,
        status: global___ApplicationStatus.ValueType = ...,
        message: builtins.str = ...,
        deployment_timestamp: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deployment_timestamp", b"deployment_timestamp", "message", b"message", "status", b"status"]) -> None: ...

global___ApplicationStatusInfo = ApplicationStatusInfo

@typing_extensions.final
class StatusOverview(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_STATUS_FIELD_NUMBER: builtins.int
    DEPLOYMENT_STATUSES_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def app_status(self) -> global___ApplicationStatusInfo: ...
    @property
    def deployment_statuses(self) -> global___DeploymentStatusInfoList: ...
    name: builtins.str
    def __init__(
        self,
        *,
        app_status: global___ApplicationStatusInfo | None = ...,
        deployment_statuses: global___DeploymentStatusInfoList | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["app_status", b"app_status", "deployment_statuses", b"deployment_statuses"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_status", b"app_status", "deployment_statuses", b"deployment_statuses", "name", b"name"]) -> None: ...

global___StatusOverview = StatusOverview

@typing_extensions.final
class ListApplicationsRequest(google.protobuf.message.Message):
    """Used for gRPC proxy health check"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListApplicationsRequest = ListApplicationsRequest

@typing_extensions.final
class ListApplicationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_NAMES_FIELD_NUMBER: builtins.int
    @property
    def application_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        application_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["application_names", b"application_names"]) -> None: ...

global___ListApplicationsResponse = ListApplicationsResponse

@typing_extensions.final
class HealthzRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___HealthzRequest = HealthzRequest

@typing_extensions.final
class HealthzResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    message: builtins.str
    def __init__(
        self,
        *,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message"]) -> None: ...

global___HealthzResponse = HealthzResponse

@typing_extensions.final
class UserDefinedMessage(google.protobuf.message.Message):
    """Used for gRPC related tests"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    FOO_FIELD_NUMBER: builtins.int
    NUM_FIELD_NUMBER: builtins.int
    name: builtins.str
    foo: builtins.str
    num: builtins.int
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        foo: builtins.str = ...,
        num: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["foo", b"foo", "name", b"name", "num", b"num"]) -> None: ...

global___UserDefinedMessage = UserDefinedMessage

@typing_extensions.final
class UserDefinedResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GREETING_FIELD_NUMBER: builtins.int
    NUM_X2_FIELD_NUMBER: builtins.int
    greeting: builtins.str
    num_x2: builtins.int
    def __init__(
        self,
        *,
        greeting: builtins.str = ...,
        num_x2: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["greeting", b"greeting", "num_x2", b"num_x2"]) -> None: ...

global___UserDefinedResponse = UserDefinedResponse

@typing_extensions.final
class UserDefinedMessage2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UserDefinedMessage2 = UserDefinedMessage2

@typing_extensions.final
class UserDefinedResponse2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GREETING_FIELD_NUMBER: builtins.int
    greeting: builtins.str
    def __init__(
        self,
        *,
        greeting: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["greeting", b"greeting"]) -> None: ...

global___UserDefinedResponse2 = UserDefinedResponse2

@typing_extensions.final
class FruitAmounts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORANGE_FIELD_NUMBER: builtins.int
    APPLE_FIELD_NUMBER: builtins.int
    BANANA_FIELD_NUMBER: builtins.int
    orange: builtins.int
    apple: builtins.int
    banana: builtins.int
    def __init__(
        self,
        *,
        orange: builtins.int = ...,
        apple: builtins.int = ...,
        banana: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["apple", b"apple", "banana", b"banana", "orange", b"orange"]) -> None: ...

global___FruitAmounts = FruitAmounts

@typing_extensions.final
class FruitCosts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COSTS_FIELD_NUMBER: builtins.int
    costs: builtins.float
    def __init__(
        self,
        *,
        costs: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["costs", b"costs"]) -> None: ...

global___FruitCosts = FruitCosts

@typing_extensions.final
class ArrayData(google.protobuf.message.Message):
    """Used for gRPC benchmark"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUMS_FIELD_NUMBER: builtins.int
    @property
    def nums(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        nums: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["nums", b"nums"]) -> None: ...

global___ArrayData = ArrayData

@typing_extensions.final
class StringData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.str
    def __init__(
        self,
        *,
        data: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___StringData = StringData

@typing_extensions.final
class ModelOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUT_FIELD_NUMBER: builtins.int
    output: builtins.float
    def __init__(
        self,
        *,
        output: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["output", b"output"]) -> None: ...

global___ModelOutput = ModelOutput

@typing_extensions.final
class DeploymentArgs(google.protobuf.message.Message):
    """The required deployment parameters when deploying an application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOYMENT_NAME_FIELD_NUMBER: builtins.int
    DEPLOYMENT_CONFIG_FIELD_NUMBER: builtins.int
    REPLICA_CONFIG_FIELD_NUMBER: builtins.int
    DEPLOYER_JOB_ID_FIELD_NUMBER: builtins.int
    ROUTE_PREFIX_FIELD_NUMBER: builtins.int
    INGRESS_FIELD_NUMBER: builtins.int
    DOCS_PATH_FIELD_NUMBER: builtins.int
    deployment_name: builtins.str
    deployment_config: builtins.bytes
    replica_config: builtins.bytes
    deployer_job_id: builtins.str
    route_prefix: builtins.str
    ingress: builtins.bool
    docs_path: builtins.str
    def __init__(
        self,
        *,
        deployment_name: builtins.str = ...,
        deployment_config: builtins.bytes = ...,
        replica_config: builtins.bytes = ...,
        deployer_job_id: builtins.str = ...,
        route_prefix: builtins.str | None = ...,
        ingress: builtins.bool = ...,
        docs_path: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_docs_path", b"_docs_path", "_route_prefix", b"_route_prefix", "docs_path", b"docs_path", "route_prefix", b"route_prefix"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_docs_path", b"_docs_path", "_route_prefix", b"_route_prefix", "deployer_job_id", b"deployer_job_id", "deployment_config", b"deployment_config", "deployment_name", b"deployment_name", "docs_path", b"docs_path", "ingress", b"ingress", "replica_config", b"replica_config", "route_prefix", b"route_prefix"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_docs_path", b"_docs_path"]) -> typing_extensions.Literal["docs_path"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_route_prefix", b"_route_prefix"]) -> typing_extensions.Literal["route_prefix"] | None: ...

global___DeploymentArgs = DeploymentArgs
