"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import collections.abc
import grpc
import grpc.aio
import pipeline.pipeline.v1beta.common_pb2
import pipeline.pipeline.v1beta.component_definition_pb2
import pipeline.pipeline.v1beta.integration_pb2
import pipeline.pipeline.v1beta.pipeline_pb2
import pipeline.pipeline.v1beta.secret_pb2
import typing

_T = typing.TypeVar('_T')

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta):
    ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore
    ...

class PipelinePublicServiceStub:
    """Pipeline

    PipelinePublicService exposes the public endpoints that allow clients to
    manage pipelines.
    """

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Liveness: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.LivenessRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.LivenessResponse,
    ]
    """Check if the pipeline server is alive

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
    """
    Readiness: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ReadinessRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ReadinessResponse,
    ]
    """Check if the pipeline server is ready

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
    """
    GetHubStats: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetHubStatsRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse,
    ]
    """Get hub status

    Return the stats of the hub
    """
    ListPipelines: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse,
    ]
    """List accessible pipelines

    Returns a paginated list of pipelines that are visible to the requester.
    """
    LookUpPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.LookUpPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse,
    ]
    """Get a pipeline by UID

    Returns the details of a pipeline by a permalink defined by the resource
    UID.
    """
    ListNamespacePipelines: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelinesResponse,
    ]
    """List namespace pipelines

    Returns a paginated list of pipelines of a namespace
    """
    CreateNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineResponse,
    ]
    """Create a new pipeline

    Creates a new pipeline under a namespace.
    """
    GetNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineResponse,
    ]
    """Get a pipeline

    Returns the details of a pipeline.
    """
    UpdateNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineResponse,
    ]
    """Update a pipeline

    Udpates a pipeline, accessing it by its resource name, which is defined by
    the parent namespace and the ID of the pipeline. The authenticated namespace must be
    the parent of the pipeline in order to modify it.

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineResponse,
    ]
    """Delete a pipeline

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent namespace and the ID of the pipeline. The authenticated namespace must be
    the parent of the pipeline in order to delete it.
    """
    ValidateNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateNamespacePipelineResponse,
    ]
    """Validate a pipeline

    Validates a pipeline by its resource name, which is defined by the parent
    namespace and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its components.
    """
    RenameNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameNamespacePipelineResponse,
    ]
    """Rename a pipeline

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent namespace and ID of the pipeline (e.g.
    `namespaces/luigi/pipelines/pizza-recipe-generator`).

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    CloneNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineResponse,
    ]
    """Clone a pipeline

    Clones a pipeline owned by a namespace. The new pipeline may have a different
    parent, and this can be either a namespace or an organization.
    """
    DispatchPipelineWebhookEvent: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DispatchPipelineWebhookEventRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DispatchPipelineWebhookEventResponse,
    ]
    """Dispatch Pipeline Webhook Event

    Handles webhook events by routing them to the appropriate pipeline based on the webhook type and message.
    The webhook type determines which component processes the event, while the message payload contains data
    that triggers pipeline execution. The pipeline processes the event using configured handlers and returns
    a response to the webhook sender.
    """
    TriggerNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineResponse,
    ]
    """Trigger a pipeline

    Triggers the execution of a pipeline synchronously, i.e., the result is
    sent back to the namespace right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent namespace
    and ID of the pipeline.

    For more information, see [Run NamespacePipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerNamespacePipelineWithStream: grpc.UnaryStreamMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineWithStreamRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineWithStreamResponse,
    ]
    """Trigger a pipeline via streaming

    Triggers the execution of a pipeline asynchronously and streams back the response.
    This method is intended for real-time inference when low latency is of concern
    and the response needs to be processed incrementally.

    The pipeline is identified by its resource name, formed by the parent namespace
    and ID of the pipeline.
    """
    TriggerAsyncNamespacePipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineResponse,
    ]
    """Trigger a pipeline asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent namespace
    and ID of the pipeline.

    For more information, see [Run NamespacePipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    CreateNamespacePipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineReleaseResponse,
    ]
    """Create a pipeline release

    Commits the version of a pipeline, identified by its resource name, which
    is formed by the parent namespace and ID of the pipeline.

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    ListNamespacePipelineReleases: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelineReleasesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelineReleasesResponse,
    ]
    """List the releases in a pipeline

    Lists the commited versions of a pipeline, identified by its resource
    name, which is formed by the parent namespace and ID of the pipeline.
    """
    GetNamespacePipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineReleaseResponse,
    ]
    """Get a pipeline release

    Gets the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent namespace and ID.
    """
    UpdateNamespacePipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineReleaseResponse,
    ]
    """Update a pipeline release

    Updates the details of a pipeline release, where the pipeline is
    identified by its resource name, formed by its parent namespace and ID.

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    DeleteNamespacePipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineReleaseResponse,
    ]
    """Delete a pipeline release

    Deletes a pipeline release, where the pipeline is identified by its
    resource name, formed by its parent namespace and ID.

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    CloneNamespacePipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineReleaseResponse,
    ]
    """Clone a pipeline release

    Clones a pipeline release owned by a namespace. The new pipeline may have a different
    parent, and this can be either a namespace or an organization.
    """
    TriggerNamespacePipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineReleaseResponse,
    ]
    """Trigger a pipeline release

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent namespace
    and ID.
    """
    TriggerAsyncNamespacePipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineReleaseResponse,
    ]
    """Trigger a pipeline release asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent namespace
    and ID.
    """
    CreateNamespaceSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.CreateNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.CreateNamespaceSecretResponse,
    ]
    """Create a secret

    Creates a new secret under the parenthood of an namespace.
    """
    ListNamespaceSecrets: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.ListNamespaceSecretsRequest,
        pipeline.pipeline.v1beta.secret_pb2.ListNamespaceSecretsResponse,
    ]
    """List secrets

    Returns a paginated list of secrets that belong to the specified
    namespace.
    """
    GetNamespaceSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.GetNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.GetNamespaceSecretResponse,
    ]
    """Get a secret

    Returns the details of an namespace-owned secret by its resource name,
    which is defined by the parent namespace and the ID of the secret.
    """
    UpdateNamespaceSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.UpdateNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.UpdateNamespaceSecretResponse,
    ]
    """Update a secret

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteNamespaceSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.DeleteNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.DeleteNamespaceSecretResponse,
    ]
    """Delete a secret

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent namespace and the ID of the secret.
    """
    ListComponentDefinitions: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsRequest,
        pipeline.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse,
    ]
    """List component definitions

    Returns a paginated list of component definitions, regardless their type.
    This offers a single source of truth, with pagination and filter
    capabilities, for the components that might be used in a pipeline.
    """
    GetOperation: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetOperationRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetOperationResponse,
    ]
    """Get the details of a long-running operation

    This method allows requesters to request the status and outcome of
    long-running operations such as asynchronous pipeline triggers.
    """
    CreateUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse,
    ]
    """The following endpoints are all deprecated

    Create a new user pipeline

    Creates a new pipeline under the parenthood of a user. Users can only
    create a pipeline as the parent of that resource (i.e. the authenticated
    user must match the `parent` path parameter).
    """
    ListUserPipelines: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse,
    ]
    """List user pipelines

    Returns a paginated list of pipelines that belong to the specified user.
    The parent user may be different from the authenticated user, in which
    case the results will contain the pipelines that are visible to the
    latter.
    """
    GetUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse,
    ]
    """Get a pipeline owned by a user

    Returns the details of a user-owned pipeline by its resource name, which is defined
    by the parent user and the ID of the pipeline.
    """
    UpdateUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse,
    ]
    """Update a pipeline owned by a user

    Udpates a pipeline, accessing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to modify it.

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse,
    ]
    """Delete a pipeline owned by a user

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to delete it.
    """
    ValidateUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by a user

    Validates a pipeline by its resource name, which is defined by the parent
    user and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its components.
    """
    RenameUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse,
    ]
    """Rename a pipeline owned by a user

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent user and ID of the pipeline (e.g.
    `users/luigi/pipelines/pizza-recipe-generator`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    TriggerUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user

    Triggers the execution of a pipeline synchronously, i.e., the result is
    sent back to the user right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerUserPipelineWithStream: grpc.UnaryStreamMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse,
    ]
    """Trigger a pipeline owned by a user and stream back the response

    Triggers the execution of a pipeline asynchronously and streams back the response.
    This method is intended for real-time inference when low latency is of concern
    and the response needs to be processed incrementally.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.
    """
    TriggerAsyncUserPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    CreateUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by a user

    Commits the version of a pipeline, identified by its resource name, which
    is formed by the parent user and ID of the pipeline.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    ListUserPipelineReleases: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by a user

    Lists the commited versions of a pipeline, identified by its resource
    name, which is formed by the parent user and ID of the pipeline.
    """
    GetUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by a user

    Gets the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent user and ID.
    """
    UpdateUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by a user

    Updates the details of a pipeline release, where the pipeline is
    identified by its resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    DeleteUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by a user

    Deletes a pipeline release, where the pipeline is identified by its
    resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RestoreUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by a user to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RenameUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by a user

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent user and ID. Since this is an
    output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed
    by the pipeline name and the ID of the release (e.g.
    `users/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    TriggerUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    TriggerAsyncUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    CreateOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse,
    ]
    """Create a new organization pipeline

    Creates a new pipeline under the parenthood of an organization.
    """
    ListOrganizationPipelines: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse,
    ]
    """List organization pipelines

    Returns a paginated list of pipelines that belong to the specified
    organization.
    """
    GetOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse,
    ]
    """Get a pipeline owned by an organization

    Returns the details of an organization-owned pipeline by its resource name,
    which is defined by the parent organization and the ID of the pipeline.
    """
    UpdateOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse,
    ]
    """Update a pipeline owned by an organization

    Udpates a pipeline, accessing it by its resource name, which is defined by

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse,
    ]
    """Delete a pipeline owned by an organization

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent organization and the ID of the pipeline.
    """
    ValidateOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by an organization

    Validates a pipeline by its resource name, which is defined by the parent
    organization and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its
    components.
    """
    RenameOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse,
    ]
    """Rename a pipeline owned by an organization

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent organization and ID of the pipeline (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator`).
    """
    TriggerOrganizationPipelineStream: grpc.UnaryStreamMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerAsyncOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    CreateOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by an organization

    Commits the version of a pipeline, identified by its resource name, which is
    formed by the parent organization and ID of the pipeline.
    """
    ListOrganizationPipelineReleases: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by an organization

    Lists the commited versions of a pipeline, identified by its resource name,
    which is formed by the parent organization and ID of the pipeline.
    """
    GetOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by an organization

    Gets the details of a pipeline release, where the pipeline is identified by
    its resource name, formed by its parent organization and ID.
    """
    UpdateOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by an organization

    Updates the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent organization and ID.
    """
    DeleteOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by an organization

    Deletes a pipeline release, where the pipeline is identified by its resource
    name, formed by its parent organization and ID.
    """
    RestoreOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by an organization to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    RenameOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by an organization

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent organization and ID. Since this is
    an output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed by
    the pipeline name and the ID of the release (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).
    """
    TriggerOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    TriggerAsyncOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    CheckName: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.common_pb2.CheckNameRequest,
        pipeline.pipeline.v1beta.common_pb2.CheckNameResponse,
    ]
    """Check the availibity of a resource name

    Check whether a resource name is already in use. Currently this endpoint
    only supports pipeline and connector resource names.
    """
    CreateUserSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.CreateUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.CreateUserSecretResponse,
    ]
    """Create a new user secret

    Creates a new secret under the parenthood of an user.
    """
    ListUserSecrets: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.ListUserSecretsRequest,
        pipeline.pipeline.v1beta.secret_pb2.ListUserSecretsResponse,
    ]
    """List user secrets

    Returns a paginated list of secrets that belong to the specified
    user.
    """
    GetUserSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.GetUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.GetUserSecretResponse,
    ]
    """Get a secret owned by an user

    Returns the details of an user-owned secret by its resource name,
    which is defined by the parent user and the ID of the secret.
    """
    UpdateUserSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.UpdateUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse,
    ]
    """Update a secret owned by an user

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteUserSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.DeleteUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse,
    ]
    """Delete a secret owned by an user

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent user and the ID of the secret.
    """
    CreateOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.CreateOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse,
    ]
    """Create a new organization secret

    Creates a new secret under the parenthood of an organization.
    """
    ListOrganizationSecrets: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.ListOrganizationSecretsRequest,
        pipeline.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse,
    ]
    """List organization secrets

    Returns a paginated list of secrets that belong to the specified
    organization.
    """
    GetOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.GetOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse,
    ]
    """Get a secret owned by an organization

    Returns the details of an organization-owned secret by its resource name,
    which is defined by the parent organization and the ID of the secret.
    """
    UpdateOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse,
    ]
    """Update a secret owned by an organization

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse,
    ]
    """Delete a secret owned by an organization

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent organization and the ID of the secret.
    """
    ListPipelineRuns: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsResponse,
    ]
    """List Pipeline Runs

    Returns a paginated list of runs for a given pipeline. When the requester
    is the owner of the pipeline, they will be able to all the pipeline runs,
    regardless who requested the trigger (the view will be partial to hide
    sensitive data like e.g. the trigger input and output). Other requesters
    will only be able to see the runs requested by themselves.
    """
    ListComponentRuns: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListComponentRunsRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListComponentRunsResponse,
    ]
    """List Component Runs

    Returns the information of each component execution within a pipeline run.
    """
    ListPipelineRunsByRequester: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsByRequesterRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsByRequesterResponse,
    ]
    """List Pipeline Runs By Requester

    Returns a paginated list of runs for requested by a namespace. The
    response may contain runs from several pipelines.
    """
    ListNamespaceConnections: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.ListNamespaceConnectionsRequest,
        pipeline.pipeline.v1beta.integration_pb2.ListNamespaceConnectionsResponse,
    ]
    """List namespace connections

    Returns a paginated list of connections created by a namespace.
    """
    GetNamespaceConnection: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.GetNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.GetNamespaceConnectionResponse,
    ]
    """Get a namespace connection

    Returns the details of a connection.
    """
    CreateNamespaceConnection: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.CreateNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.CreateNamespaceConnectionResponse,
    ]
    """Create a connection

    Creates a connection under the ownership of a namespace.
    """
    UpdateNamespaceConnection: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.UpdateNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.UpdateNamespaceConnectionResponse,
    ]
    """Update a connection

    Updates a connection with the supplied connection fields.
    """
    DeleteNamespaceConnection: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.DeleteNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.DeleteNamespaceConnectionResponse,
    ]
    """Delete a connection

    Deletes a connection.
    """
    TestNamespaceConnection: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.TestNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.TestNamespaceConnectionResponse,
    ]
    """Test a connection

    Makes a request to the 3rd party app that the connection is configured to
    communicate with, and checks the result of the call. If the test fails,
    the response status and error message will provide more information about
    the failure.

    Note that this action might affect the quota or billing of the integrated
    account in the 3rd party app.
    """
    ListPipelineIDsByConnectionID: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.ListPipelineIDsByConnectionIDRequest,
        pipeline.pipeline.v1beta.integration_pb2.ListPipelineIDsByConnectionIDResponse,
    ]
    """List pipelines that reference a connection

    Returns a paginated list with the IDs of the pipelines that reference a
    given connection. All the pipelines will belong to the same namespace as
    the connection.
    """
    ListIntegrations: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.ListIntegrationsRequest,
        pipeline.pipeline.v1beta.integration_pb2.ListIntegrationsResponse,
    ]
    """List integrations

    Returns a paginated list of available integrations.
    """
    GetIntegration: grpc.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.GetIntegrationRequest,
        pipeline.pipeline.v1beta.integration_pb2.GetIntegrationResponse,
    ]
    """Get an integration

    Returns the details of an integration.
    """

class PipelinePublicServiceAsyncStub:
    """Pipeline

    PipelinePublicService exposes the public endpoints that allow clients to
    manage pipelines.
    """

    Liveness: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.LivenessRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.LivenessResponse,
    ]
    """Check if the pipeline server is alive

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
    """
    Readiness: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ReadinessRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ReadinessResponse,
    ]
    """Check if the pipeline server is ready

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
    """
    GetHubStats: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetHubStatsRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse,
    ]
    """Get hub status

    Return the stats of the hub
    """
    ListPipelines: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse,
    ]
    """List accessible pipelines

    Returns a paginated list of pipelines that are visible to the requester.
    """
    LookUpPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.LookUpPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse,
    ]
    """Get a pipeline by UID

    Returns the details of a pipeline by a permalink defined by the resource
    UID.
    """
    ListNamespacePipelines: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelinesResponse,
    ]
    """List namespace pipelines

    Returns a paginated list of pipelines of a namespace
    """
    CreateNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineResponse,
    ]
    """Create a new pipeline

    Creates a new pipeline under a namespace.
    """
    GetNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineResponse,
    ]
    """Get a pipeline

    Returns the details of a pipeline.
    """
    UpdateNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineResponse,
    ]
    """Update a pipeline

    Udpates a pipeline, accessing it by its resource name, which is defined by
    the parent namespace and the ID of the pipeline. The authenticated namespace must be
    the parent of the pipeline in order to modify it.

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineResponse,
    ]
    """Delete a pipeline

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent namespace and the ID of the pipeline. The authenticated namespace must be
    the parent of the pipeline in order to delete it.
    """
    ValidateNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateNamespacePipelineResponse,
    ]
    """Validate a pipeline

    Validates a pipeline by its resource name, which is defined by the parent
    namespace and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its components.
    """
    RenameNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameNamespacePipelineResponse,
    ]
    """Rename a pipeline

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent namespace and ID of the pipeline (e.g.
    `namespaces/luigi/pipelines/pizza-recipe-generator`).

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    CloneNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineResponse,
    ]
    """Clone a pipeline

    Clones a pipeline owned by a namespace. The new pipeline may have a different
    parent, and this can be either a namespace or an organization.
    """
    DispatchPipelineWebhookEvent: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DispatchPipelineWebhookEventRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DispatchPipelineWebhookEventResponse,
    ]
    """Dispatch Pipeline Webhook Event

    Handles webhook events by routing them to the appropriate pipeline based on the webhook type and message.
    The webhook type determines which component processes the event, while the message payload contains data
    that triggers pipeline execution. The pipeline processes the event using configured handlers and returns
    a response to the webhook sender.
    """
    TriggerNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineResponse,
    ]
    """Trigger a pipeline

    Triggers the execution of a pipeline synchronously, i.e., the result is
    sent back to the namespace right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent namespace
    and ID of the pipeline.

    For more information, see [Run NamespacePipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerNamespacePipelineWithStream: grpc.aio.UnaryStreamMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineWithStreamRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineWithStreamResponse,
    ]
    """Trigger a pipeline via streaming

    Triggers the execution of a pipeline asynchronously and streams back the response.
    This method is intended for real-time inference when low latency is of concern
    and the response needs to be processed incrementally.

    The pipeline is identified by its resource name, formed by the parent namespace
    and ID of the pipeline.
    """
    TriggerAsyncNamespacePipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineResponse,
    ]
    """Trigger a pipeline asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent namespace
    and ID of the pipeline.

    For more information, see [Run NamespacePipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    CreateNamespacePipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineReleaseResponse,
    ]
    """Create a pipeline release

    Commits the version of a pipeline, identified by its resource name, which
    is formed by the parent namespace and ID of the pipeline.

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    ListNamespacePipelineReleases: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelineReleasesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelineReleasesResponse,
    ]
    """List the releases in a pipeline

    Lists the commited versions of a pipeline, identified by its resource
    name, which is formed by the parent namespace and ID of the pipeline.
    """
    GetNamespacePipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineReleaseResponse,
    ]
    """Get a pipeline release

    Gets the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent namespace and ID.
    """
    UpdateNamespacePipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineReleaseResponse,
    ]
    """Update a pipeline release

    Updates the details of a pipeline release, where the pipeline is
    identified by its resource name, formed by its parent namespace and ID.

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    DeleteNamespacePipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineReleaseResponse,
    ]
    """Delete a pipeline release

    Deletes a pipeline release, where the pipeline is identified by its
    resource name, formed by its parent namespace and ID.

    The authenticated namespace must be the parent of the pipeline in order to
    perform this action.
    """
    CloneNamespacePipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineReleaseResponse,
    ]
    """Clone a pipeline release

    Clones a pipeline release owned by a namespace. The new pipeline may have a different
    parent, and this can be either a namespace or an organization.
    """
    TriggerNamespacePipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineReleaseResponse,
    ]
    """Trigger a pipeline release

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent namespace
    and ID.
    """
    TriggerAsyncNamespacePipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineReleaseResponse,
    ]
    """Trigger a pipeline release asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent namespace
    and ID.
    """
    CreateNamespaceSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.CreateNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.CreateNamespaceSecretResponse,
    ]
    """Create a secret

    Creates a new secret under the parenthood of an namespace.
    """
    ListNamespaceSecrets: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.ListNamespaceSecretsRequest,
        pipeline.pipeline.v1beta.secret_pb2.ListNamespaceSecretsResponse,
    ]
    """List secrets

    Returns a paginated list of secrets that belong to the specified
    namespace.
    """
    GetNamespaceSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.GetNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.GetNamespaceSecretResponse,
    ]
    """Get a secret

    Returns the details of an namespace-owned secret by its resource name,
    which is defined by the parent namespace and the ID of the secret.
    """
    UpdateNamespaceSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.UpdateNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.UpdateNamespaceSecretResponse,
    ]
    """Update a secret

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteNamespaceSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.DeleteNamespaceSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.DeleteNamespaceSecretResponse,
    ]
    """Delete a secret

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent namespace and the ID of the secret.
    """
    ListComponentDefinitions: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsRequest,
        pipeline.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse,
    ]
    """List component definitions

    Returns a paginated list of component definitions, regardless their type.
    This offers a single source of truth, with pagination and filter
    capabilities, for the components that might be used in a pipeline.
    """
    GetOperation: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetOperationRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetOperationResponse,
    ]
    """Get the details of a long-running operation

    This method allows requesters to request the status and outcome of
    long-running operations such as asynchronous pipeline triggers.
    """
    CreateUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse,
    ]
    """The following endpoints are all deprecated

    Create a new user pipeline

    Creates a new pipeline under the parenthood of a user. Users can only
    create a pipeline as the parent of that resource (i.e. the authenticated
    user must match the `parent` path parameter).
    """
    ListUserPipelines: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse,
    ]
    """List user pipelines

    Returns a paginated list of pipelines that belong to the specified user.
    The parent user may be different from the authenticated user, in which
    case the results will contain the pipelines that are visible to the
    latter.
    """
    GetUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse,
    ]
    """Get a pipeline owned by a user

    Returns the details of a user-owned pipeline by its resource name, which is defined
    by the parent user and the ID of the pipeline.
    """
    UpdateUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse,
    ]
    """Update a pipeline owned by a user

    Udpates a pipeline, accessing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to modify it.

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse,
    ]
    """Delete a pipeline owned by a user

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to delete it.
    """
    ValidateUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by a user

    Validates a pipeline by its resource name, which is defined by the parent
    user and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its components.
    """
    RenameUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse,
    ]
    """Rename a pipeline owned by a user

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent user and ID of the pipeline (e.g.
    `users/luigi/pipelines/pizza-recipe-generator`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    TriggerUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user

    Triggers the execution of a pipeline synchronously, i.e., the result is
    sent back to the user right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerUserPipelineWithStream: grpc.aio.UnaryStreamMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse,
    ]
    """Trigger a pipeline owned by a user and stream back the response

    Triggers the execution of a pipeline asynchronously and streams back the response.
    This method is intended for real-time inference when low latency is of concern
    and the response needs to be processed incrementally.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.
    """
    TriggerAsyncUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    CreateUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by a user

    Commits the version of a pipeline, identified by its resource name, which
    is formed by the parent user and ID of the pipeline.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    ListUserPipelineReleases: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by a user

    Lists the commited versions of a pipeline, identified by its resource
    name, which is formed by the parent user and ID of the pipeline.
    """
    GetUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by a user

    Gets the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent user and ID.
    """
    UpdateUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by a user

    Updates the details of a pipeline release, where the pipeline is
    identified by its resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    DeleteUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by a user

    Deletes a pipeline release, where the pipeline is identified by its
    resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RestoreUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by a user to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RenameUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by a user

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent user and ID. Since this is an
    output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed
    by the pipeline name and the ID of the release (e.g.
    `users/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    TriggerUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    TriggerAsyncUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    CreateOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse,
    ]
    """Create a new organization pipeline

    Creates a new pipeline under the parenthood of an organization.
    """
    ListOrganizationPipelines: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse,
    ]
    """List organization pipelines

    Returns a paginated list of pipelines that belong to the specified
    organization.
    """
    GetOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse,
    ]
    """Get a pipeline owned by an organization

    Returns the details of an organization-owned pipeline by its resource name,
    which is defined by the parent organization and the ID of the pipeline.
    """
    UpdateOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse,
    ]
    """Update a pipeline owned by an organization

    Udpates a pipeline, accessing it by its resource name, which is defined by

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse,
    ]
    """Delete a pipeline owned by an organization

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent organization and the ID of the pipeline.
    """
    ValidateOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by an organization

    Validates a pipeline by its resource name, which is defined by the parent
    organization and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its
    components.
    """
    RenameOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse,
    ]
    """Rename a pipeline owned by an organization

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent organization and ID of the pipeline (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator`).
    """
    TriggerOrganizationPipelineStream: grpc.aio.UnaryStreamMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    TriggerAsyncOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
    """
    CreateOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by an organization

    Commits the version of a pipeline, identified by its resource name, which is
    formed by the parent organization and ID of the pipeline.
    """
    ListOrganizationPipelineReleases: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by an organization

    Lists the commited versions of a pipeline, identified by its resource name,
    which is formed by the parent organization and ID of the pipeline.
    """
    GetOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by an organization

    Gets the details of a pipeline release, where the pipeline is identified by
    its resource name, formed by its parent organization and ID.
    """
    UpdateOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by an organization

    Updates the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent organization and ID.
    """
    DeleteOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by an organization

    Deletes a pipeline release, where the pipeline is identified by its resource
    name, formed by its parent organization and ID.
    """
    RestoreOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by an organization to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    RenameOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by an organization

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent organization and ID. Since this is
    an output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed by
    the pipeline name and the ID of the release (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).
    """
    TriggerOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    TriggerAsyncOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    CheckName: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.common_pb2.CheckNameRequest,
        pipeline.pipeline.v1beta.common_pb2.CheckNameResponse,
    ]
    """Check the availibity of a resource name

    Check whether a resource name is already in use. Currently this endpoint
    only supports pipeline and connector resource names.
    """
    CreateUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.CreateUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.CreateUserSecretResponse,
    ]
    """Create a new user secret

    Creates a new secret under the parenthood of an user.
    """
    ListUserSecrets: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.ListUserSecretsRequest,
        pipeline.pipeline.v1beta.secret_pb2.ListUserSecretsResponse,
    ]
    """List user secrets

    Returns a paginated list of secrets that belong to the specified
    user.
    """
    GetUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.GetUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.GetUserSecretResponse,
    ]
    """Get a secret owned by an user

    Returns the details of an user-owned secret by its resource name,
    which is defined by the parent user and the ID of the secret.
    """
    UpdateUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.UpdateUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse,
    ]
    """Update a secret owned by an user

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.DeleteUserSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse,
    ]
    """Delete a secret owned by an user

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent user and the ID of the secret.
    """
    CreateOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.CreateOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse,
    ]
    """Create a new organization secret

    Creates a new secret under the parenthood of an organization.
    """
    ListOrganizationSecrets: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.ListOrganizationSecretsRequest,
        pipeline.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse,
    ]
    """List organization secrets

    Returns a paginated list of secrets that belong to the specified
    organization.
    """
    GetOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.GetOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse,
    ]
    """Get a secret owned by an organization

    Returns the details of an organization-owned secret by its resource name,
    which is defined by the parent organization and the ID of the secret.
    """
    UpdateOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse,
    ]
    """Update a secret owned by an organization

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretRequest,
        pipeline.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse,
    ]
    """Delete a secret owned by an organization

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent organization and the ID of the secret.
    """
    ListPipelineRuns: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsResponse,
    ]
    """List Pipeline Runs

    Returns a paginated list of runs for a given pipeline. When the requester
    is the owner of the pipeline, they will be able to all the pipeline runs,
    regardless who requested the trigger (the view will be partial to hide
    sensitive data like e.g. the trigger input and output). Other requesters
    will only be able to see the runs requested by themselves.
    """
    ListComponentRuns: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListComponentRunsRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListComponentRunsResponse,
    ]
    """List Component Runs

    Returns the information of each component execution within a pipeline run.
    """
    ListPipelineRunsByRequester: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsByRequesterRequest,
        pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsByRequesterResponse,
    ]
    """List Pipeline Runs By Requester

    Returns a paginated list of runs for requested by a namespace. The
    response may contain runs from several pipelines.
    """
    ListNamespaceConnections: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.ListNamespaceConnectionsRequest,
        pipeline.pipeline.v1beta.integration_pb2.ListNamespaceConnectionsResponse,
    ]
    """List namespace connections

    Returns a paginated list of connections created by a namespace.
    """
    GetNamespaceConnection: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.GetNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.GetNamespaceConnectionResponse,
    ]
    """Get a namespace connection

    Returns the details of a connection.
    """
    CreateNamespaceConnection: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.CreateNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.CreateNamespaceConnectionResponse,
    ]
    """Create a connection

    Creates a connection under the ownership of a namespace.
    """
    UpdateNamespaceConnection: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.UpdateNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.UpdateNamespaceConnectionResponse,
    ]
    """Update a connection

    Updates a connection with the supplied connection fields.
    """
    DeleteNamespaceConnection: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.DeleteNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.DeleteNamespaceConnectionResponse,
    ]
    """Delete a connection

    Deletes a connection.
    """
    TestNamespaceConnection: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.TestNamespaceConnectionRequest,
        pipeline.pipeline.v1beta.integration_pb2.TestNamespaceConnectionResponse,
    ]
    """Test a connection

    Makes a request to the 3rd party app that the connection is configured to
    communicate with, and checks the result of the call. If the test fails,
    the response status and error message will provide more information about
    the failure.

    Note that this action might affect the quota or billing of the integrated
    account in the 3rd party app.
    """
    ListPipelineIDsByConnectionID: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.ListPipelineIDsByConnectionIDRequest,
        pipeline.pipeline.v1beta.integration_pb2.ListPipelineIDsByConnectionIDResponse,
    ]
    """List pipelines that reference a connection

    Returns a paginated list with the IDs of the pipelines that reference a
    given connection. All the pipelines will belong to the same namespace as
    the connection.
    """
    ListIntegrations: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.ListIntegrationsRequest,
        pipeline.pipeline.v1beta.integration_pb2.ListIntegrationsResponse,
    ]
    """List integrations

    Returns a paginated list of available integrations.
    """
    GetIntegration: grpc.aio.UnaryUnaryMultiCallable[
        pipeline.pipeline.v1beta.integration_pb2.GetIntegrationRequest,
        pipeline.pipeline.v1beta.integration_pb2.GetIntegrationResponse,
    ]
    """Get an integration

    Returns the details of an integration.
    """

class PipelinePublicServiceServicer(metaclass=abc.ABCMeta):
    """Pipeline

    PipelinePublicService exposes the public endpoints that allow clients to
    manage pipelines.
    """

    @abc.abstractmethod
    def Liveness(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.LivenessRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.LivenessResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.LivenessResponse]]:
        """Check if the pipeline server is alive

        See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
        """
    @abc.abstractmethod
    def Readiness(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ReadinessRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ReadinessResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ReadinessResponse]]:
        """Check if the pipeline server is ready

        See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
        """
    @abc.abstractmethod
    def GetHubStats(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetHubStatsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse]]:
        """Get hub status

        Return the stats of the hub
        """
    @abc.abstractmethod
    def ListPipelines(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListPipelinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse]]:
        """List accessible pipelines

        Returns a paginated list of pipelines that are visible to the requester.
        """
    @abc.abstractmethod
    def LookUpPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.LookUpPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse]]:
        """Get a pipeline by UID

        Returns the details of a pipeline by a permalink defined by the resource
        UID.
        """
    @abc.abstractmethod
    def ListNamespacePipelines(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelinesResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelinesResponse]]:
        """List namespace pipelines

        Returns a paginated list of pipelines of a namespace
        """
    @abc.abstractmethod
    def CreateNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineResponse]]:
        """Create a new pipeline

        Creates a new pipeline under a namespace.
        """
    @abc.abstractmethod
    def GetNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineResponse]]:
        """Get a pipeline

        Returns the details of a pipeline.
        """
    @abc.abstractmethod
    def UpdateNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineResponse]]:
        """Update a pipeline

        Udpates a pipeline, accessing it by its resource name, which is defined by
        the parent namespace and the ID of the pipeline. The authenticated namespace must be
        the parent of the pipeline in order to modify it.

        In REST requests, only the supplied pipeline fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineResponse]]:
        """Delete a pipeline

        Deletes a pipeline, accesing it by its resource name, which is defined by
        the parent namespace and the ID of the pipeline. The authenticated namespace must be
        the parent of the pipeline in order to delete it.
        """
    @abc.abstractmethod
    def ValidateNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ValidateNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ValidateNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ValidateNamespacePipelineResponse]]:
        """Validate a pipeline

        Validates a pipeline by its resource name, which is defined by the parent
        namespace and the ID of the pipeline.

        Validation checks the recipe of the pipeline and the status of its components.
        """
    @abc.abstractmethod
    def RenameNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.RenameNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.RenameNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.RenameNamespacePipelineResponse]]:
        """Rename a pipeline

        Updates the ID of a pipeline. Since this is an output-only field, a custom
        method is required to modify it.

        The pipeline name will be updated accordingly, as it is  composed by the
        parent namespace and ID of the pipeline (e.g.
        `namespaces/luigi/pipelines/pizza-recipe-generator`).

        The authenticated namespace must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def CloneNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineResponse]]:
        """Clone a pipeline

        Clones a pipeline owned by a namespace. The new pipeline may have a different
        parent, and this can be either a namespace or an organization.
        """
    @abc.abstractmethod
    def DispatchPipelineWebhookEvent(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.DispatchPipelineWebhookEventRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.DispatchPipelineWebhookEventResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.DispatchPipelineWebhookEventResponse]]:
        """Dispatch Pipeline Webhook Event

        Handles webhook events by routing them to the appropriate pipeline based on the webhook type and message.
        The webhook type determines which component processes the event, while the message payload contains data
        that triggers pipeline execution. The pipeline processes the event using configured handlers and returns
        a response to the webhook sender.
        """
    @abc.abstractmethod
    def TriggerNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineResponse]]:
        """Trigger a pipeline

        Triggers the execution of a pipeline synchronously, i.e., the result is
        sent back to the namespace right after the data is processed. This method is
        intended for real-time inference when low latency is of concern.

        The pipeline is identified by its resource name, formed by the parent namespace
        and ID of the pipeline.

        For more information, see [Run NamespacePipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
        """
    @abc.abstractmethod
    def TriggerNamespacePipelineWithStream(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineWithStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineWithStreamResponse], collections.abc.AsyncIterator[pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineWithStreamResponse]]:
        """Trigger a pipeline via streaming

        Triggers the execution of a pipeline asynchronously and streams back the response.
        This method is intended for real-time inference when low latency is of concern
        and the response needs to be processed incrementally.

        The pipeline is identified by its resource name, formed by the parent namespace
        and ID of the pipeline.
        """
    @abc.abstractmethod
    def TriggerAsyncNamespacePipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineResponse]]:
        """Trigger a pipeline asynchronously

        Triggers the execution of a pipeline asynchronously, i.e., the result
        contains the necessary information to access the result and status of the
        operation. This method is intended for cases that require long-running
        workloads.

        The pipeline is identified by its resource name, formed by the parent namespace
        and ID of the pipeline.

        For more information, see [Run NamespacePipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
        """
    @abc.abstractmethod
    def CreateNamespacePipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CreateNamespacePipelineReleaseResponse]]:
        """Create a pipeline release

        Commits the version of a pipeline, identified by its resource name, which
        is formed by the parent namespace and ID of the pipeline.

        The authenticated namespace must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def ListNamespacePipelineReleases(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelineReleasesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelineReleasesResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListNamespacePipelineReleasesResponse]]:
        """List the releases in a pipeline

        Lists the commited versions of a pipeline, identified by its resource
        name, which is formed by the parent namespace and ID of the pipeline.
        """
    @abc.abstractmethod
    def GetNamespacePipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetNamespacePipelineReleaseResponse]]:
        """Get a pipeline release

        Gets the details of a pipeline release, where the pipeline is identified
        by its resource name, formed by its parent namespace and ID.
        """
    @abc.abstractmethod
    def UpdateNamespacePipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.UpdateNamespacePipelineReleaseResponse]]:
        """Update a pipeline release

        Updates the details of a pipeline release, where the pipeline is
        identified by its resource name, formed by its parent namespace and ID.

        The authenticated namespace must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def DeleteNamespacePipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.DeleteNamespacePipelineReleaseResponse]]:
        """Delete a pipeline release

        Deletes a pipeline release, where the pipeline is identified by its
        resource name, formed by its parent namespace and ID.

        The authenticated namespace must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def CloneNamespacePipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CloneNamespacePipelineReleaseResponse]]:
        """Clone a pipeline release

        Clones a pipeline release owned by a namespace. The new pipeline may have a different
        parent, and this can be either a namespace or an organization.
        """
    @abc.abstractmethod
    def TriggerNamespacePipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerNamespacePipelineReleaseResponse]]:
        """Trigger a pipeline release

        Triggers the synchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent namespace
        and ID.
        """
    @abc.abstractmethod
    def TriggerAsyncNamespacePipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncNamespacePipelineReleaseResponse]]:
        """Trigger a pipeline release asynchronously

        Triggers the asynchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent namespace
        and ID.
        """
    @abc.abstractmethod
    def CreateNamespaceSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.CreateNamespaceSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.CreateNamespaceSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.CreateNamespaceSecretResponse]]:
        """Create a secret

        Creates a new secret under the parenthood of an namespace.
        """
    @abc.abstractmethod
    def ListNamespaceSecrets(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.ListNamespaceSecretsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.ListNamespaceSecretsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.ListNamespaceSecretsResponse]]:
        """List secrets

        Returns a paginated list of secrets that belong to the specified
        namespace.
        """
    @abc.abstractmethod
    def GetNamespaceSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.GetNamespaceSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.GetNamespaceSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.GetNamespaceSecretResponse]]:
        """Get a secret

        Returns the details of an namespace-owned secret by its resource name,
        which is defined by the parent namespace and the ID of the secret.
        """
    @abc.abstractmethod
    def UpdateNamespaceSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.UpdateNamespaceSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.UpdateNamespaceSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.UpdateNamespaceSecretResponse]]:
        """Update a secret

        Udpates a secret, accessing it by its resource name, which is defined by

        In REST requests, only the supplied secret fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteNamespaceSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.DeleteNamespaceSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.DeleteNamespaceSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.DeleteNamespaceSecretResponse]]:
        """Delete a secret

        Deletes a secret, accesing it by its resource name, which is defined by
        the parent namespace and the ID of the secret.
        """
    @abc.abstractmethod
    def ListComponentDefinitions(
        self,
        request: pipeline.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse]]:
        """List component definitions

        Returns a paginated list of component definitions, regardless their type.
        This offers a single source of truth, with pagination and filter
        capabilities, for the components that might be used in a pipeline.
        """
    @abc.abstractmethod
    def GetOperation(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetOperationRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetOperationResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetOperationResponse]]:
        """Get the details of a long-running operation

        This method allows requesters to request the status and outcome of
        long-running operations such as asynchronous pipeline triggers.
        """
    @abc.abstractmethod
    def CreateUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse]]:
        """The following endpoints are all deprecated

        Create a new user pipeline

        Creates a new pipeline under the parenthood of a user. Users can only
        create a pipeline as the parent of that resource (i.e. the authenticated
        user must match the `parent` path parameter).
        """
    @abc.abstractmethod
    def ListUserPipelines(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse]]:
        """List user pipelines

        Returns a paginated list of pipelines that belong to the specified user.
        The parent user may be different from the authenticated user, in which
        case the results will contain the pipelines that are visible to the
        latter.
        """
    @abc.abstractmethod
    def GetUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse]]:
        """Get a pipeline owned by a user

        Returns the details of a user-owned pipeline by its resource name, which is defined
        by the parent user and the ID of the pipeline.
        """
    @abc.abstractmethod
    def UpdateUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse]]:
        """Update a pipeline owned by a user

        Udpates a pipeline, accessing it by its resource name, which is defined by
        the parent user and the ID of the pipeline. The authenticated user must be
        the parent of the pipeline in order to modify it.

        In REST requests, only the supplied pipeline fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse]]:
        """Delete a pipeline owned by a user

        Deletes a pipeline, accesing it by its resource name, which is defined by
        the parent user and the ID of the pipeline. The authenticated user must be
        the parent of the pipeline in order to delete it.
        """
    @abc.abstractmethod
    def ValidateUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse]]:
        """Validate a pipeline a pipeline owned by a user

        Validates a pipeline by its resource name, which is defined by the parent
        user and the ID of the pipeline.

        Validation checks the recipe of the pipeline and the status of its components.
        """
    @abc.abstractmethod
    def RenameUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse]]:
        """Rename a pipeline owned by a user

        Updates the ID of a pipeline. Since this is an output-only field, a custom
        method is required to modify it.

        The pipeline name will be updated accordingly, as it is  composed by the
        parent user and ID of the pipeline (e.g.
        `users/luigi/pipelines/pizza-recipe-generator`).

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def TriggerUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse]]:
        """Trigger a pipeline owned by a user

        Triggers the execution of a pipeline synchronously, i.e., the result is
        sent back to the user right after the data is processed. This method is
        intended for real-time inference when low latency is of concern.

        The pipeline is identified by its resource name, formed by the parent user
        and ID of the pipeline.

        For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
        """
    @abc.abstractmethod
    def TriggerUserPipelineWithStream(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse], collections.abc.AsyncIterator[pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse]]:
        """Trigger a pipeline owned by a user and stream back the response

        Triggers the execution of a pipeline asynchronously and streams back the response.
        This method is intended for real-time inference when low latency is of concern
        and the response needs to be processed incrementally.

        The pipeline is identified by its resource name, formed by the parent user
        and ID of the pipeline.
        """
    @abc.abstractmethod
    def TriggerAsyncUserPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse]]:
        """Trigger a pipeline owned by a user asynchronously

        Triggers the execution of a pipeline asynchronously, i.e., the result
        contains the necessary information to access the result and status of the
        operation. This method is intended for cases that require long-running
        workloads.

        The pipeline is identified by its resource name, formed by the parent user
        and ID of the pipeline.

        For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
        """
    @abc.abstractmethod
    def CreateUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse]]:
        """Release a version of a pipeline owned by a user

        Commits the version of a pipeline, identified by its resource name, which
        is formed by the parent user and ID of the pipeline.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def ListUserPipelineReleases(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse]]:
        """List the releases in a pipeline owned by a user

        Lists the commited versions of a pipeline, identified by its resource
        name, which is formed by the parent user and ID of the pipeline.
        """
    @abc.abstractmethod
    def GetUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse]]:
        """Get a release in a pipeline owned by a user

        Gets the details of a pipeline release, where the pipeline is identified
        by its resource name, formed by its parent user and ID.
        """
    @abc.abstractmethod
    def UpdateUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse]]:
        """Update a release in a pipeline owned by a user

        Updates the details of a pipeline release, where the pipeline is
        identified by its resource name, formed by its parent user and ID.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def DeleteUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse]]:
        """Delete a release in a pipeline owned by a user

        Deletes a pipeline release, where the pipeline is identified by its
        resource name, formed by its parent user and ID.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def RestoreUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse]]:
        """Set the version of a pipeline owned by a user to a pinned release

        Sets the pipeline configuration to a pinned version defined by a release.

        The pipeline is identified by its resource name, formed by its parent user
        and ID.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def RenameUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse]]:
        """Rename a release in a pipeline owned by a user

        Updates the ID of a pipeline release, where the pipeline is identified by
        its resource name, formed by the parent user and ID. Since this is an
        output-only field, a custom method is required to modify it.

        The pipeline release name will be updated accordingly, as it is  composed
        by the pipeline name and the ID of the release (e.g.
        `users/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def TriggerUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by a user

        Triggers the synchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent user
        and ID.
        """
    @abc.abstractmethod
    def TriggerAsyncUserPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by a user asynchronously

        Triggers the asynchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent user
        and ID.
        """
    @abc.abstractmethod
    def CreateOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse]]:
        """Create a new organization pipeline

        Creates a new pipeline under the parenthood of an organization.
        """
    @abc.abstractmethod
    def ListOrganizationPipelines(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse]]:
        """List organization pipelines

        Returns a paginated list of pipelines that belong to the specified
        organization.
        """
    @abc.abstractmethod
    def GetOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse]]:
        """Get a pipeline owned by an organization

        Returns the details of an organization-owned pipeline by its resource name,
        which is defined by the parent organization and the ID of the pipeline.
        """
    @abc.abstractmethod
    def UpdateOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse]]:
        """Update a pipeline owned by an organization

        Udpates a pipeline, accessing it by its resource name, which is defined by

        In REST requests, only the supplied pipeline fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse]]:
        """Delete a pipeline owned by an organization

        Deletes a pipeline, accesing it by its resource name, which is defined by
        the parent organization and the ID of the pipeline.
        """
    @abc.abstractmethod
    def ValidateOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse]]:
        """Validate a pipeline a pipeline owned by an organization

        Validates a pipeline by its resource name, which is defined by the parent
        organization and the ID of the pipeline.

        Validation checks the recipe of the pipeline and the status of its
        components.
        """
    @abc.abstractmethod
    def RenameOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse]]:
        """Rename a pipeline owned by an organization

        Updates the ID of a pipeline. Since this is an output-only field, a custom
        method is required to modify it.

        The pipeline name will be updated accordingly, as it is  composed by the
        parent organization and ID of the pipeline (e.g.
        `organizations/luigi/pipelines/pizza-recipe-generator`).
        """
    @abc.abstractmethod
    def TriggerOrganizationPipelineStream(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse], collections.abc.AsyncIterator[pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse]]:
        """Trigger a pipeline owned by an organization

        Triggers the execution of a pipeline synchronously, i.e., the result is sent
        back to the organization right after the data is processed. This method is
        intended for real-time inference when low latency is of concern.

        The pipeline is identified by its resource name, formed by the parent
        organization and ID of the pipeline.

        For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
        """
    @abc.abstractmethod
    def TriggerOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse]]:
        """Trigger a pipeline owned by an organization

        Triggers the execution of a pipeline synchronously, i.e., the result is sent
        back to the organization right after the data is processed. This method is
        intended for real-time inference when low latency is of concern.

        The pipeline is identified by its resource name, formed by the parent
        organization and ID of the pipeline.

        For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
        """
    @abc.abstractmethod
    def TriggerAsyncOrganizationPipeline(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse]]:
        """Trigger a pipeline owned by an organization asynchronously

        Triggers the execution of a pipeline asynchronously, i.e., the result
        contains the necessary information to access the result and status of the
        operation. This method is intended for cases that require long-running
        workloads.

        The pipeline is identified by its resource name, formed by the parent
        organization and ID of the pipeline.

        For more information, see [Run Pipeline](https://instill-ai.dev/docs/pipeline/run-pipeline).
        """
    @abc.abstractmethod
    def CreateOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse]]:
        """Release a version of a pipeline owned by an organization

        Commits the version of a pipeline, identified by its resource name, which is
        formed by the parent organization and ID of the pipeline.
        """
    @abc.abstractmethod
    def ListOrganizationPipelineReleases(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse]]:
        """List the releases in a pipeline owned by an organization

        Lists the commited versions of a pipeline, identified by its resource name,
        which is formed by the parent organization and ID of the pipeline.
        """
    @abc.abstractmethod
    def GetOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse]]:
        """Get a release in a pipeline owned by an organization

        Gets the details of a pipeline release, where the pipeline is identified by
        its resource name, formed by its parent organization and ID.
        """
    @abc.abstractmethod
    def UpdateOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse]]:
        """Update a release in a pipeline owned by an organization

        Updates the details of a pipeline release, where the pipeline is identified
        by its resource name, formed by its parent organization and ID.
        """
    @abc.abstractmethod
    def DeleteOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse]]:
        """Delete a release in a pipeline owned by an organization

        Deletes a pipeline release, where the pipeline is identified by its resource
        name, formed by its parent organization and ID.
        """
    @abc.abstractmethod
    def RestoreOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse]]:
        """Set the version of a pipeline owned by an organization to a pinned release

        Sets the pipeline configuration to a pinned version defined by a release.

        The pipeline is identified by its resource name, formed by its parent
        organization and ID.
        """
    @abc.abstractmethod
    def RenameOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse]]:
        """Rename a release in a pipeline owned by an organization

        Updates the ID of a pipeline release, where the pipeline is identified by
        its resource name, formed by the parent organization and ID. Since this is
        an output-only field, a custom method is required to modify it.

        The pipeline release name will be updated accordingly, as it is  composed by
        the pipeline name and the ID of the release (e.g.
        `organizations/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).
        """
    @abc.abstractmethod
    def TriggerOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by an organization

        Triggers the synchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent
        organization and ID.
        """
    @abc.abstractmethod
    def TriggerAsyncOrganizationPipelineRelease(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by an organization asynchronously

        Triggers the asynchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent
        organization and ID.
        """
    @abc.abstractmethod
    def CheckName(
        self,
        request: pipeline.pipeline.v1beta.common_pb2.CheckNameRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.common_pb2.CheckNameResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.common_pb2.CheckNameResponse]]:
        """Check the availibity of a resource name

        Check whether a resource name is already in use. Currently this endpoint
        only supports pipeline and connector resource names.
        """
    @abc.abstractmethod
    def CreateUserSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.CreateUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.CreateUserSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.CreateUserSecretResponse]]:
        """Create a new user secret

        Creates a new secret under the parenthood of an user.
        """
    @abc.abstractmethod
    def ListUserSecrets(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.ListUserSecretsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.ListUserSecretsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.ListUserSecretsResponse]]:
        """List user secrets

        Returns a paginated list of secrets that belong to the specified
        user.
        """
    @abc.abstractmethod
    def GetUserSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.GetUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.GetUserSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.GetUserSecretResponse]]:
        """Get a secret owned by an user

        Returns the details of an user-owned secret by its resource name,
        which is defined by the parent user and the ID of the secret.
        """
    @abc.abstractmethod
    def UpdateUserSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.UpdateUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse]]:
        """Update a secret owned by an user

        Udpates a secret, accessing it by its resource name, which is defined by

        In REST requests, only the supplied secret fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteUserSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.DeleteUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse]]:
        """Delete a secret owned by an user

        Deletes a secret, accesing it by its resource name, which is defined by
        the parent user and the ID of the secret.
        """
    @abc.abstractmethod
    def CreateOrganizationSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.CreateOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse]]:
        """Create a new organization secret

        Creates a new secret under the parenthood of an organization.
        """
    @abc.abstractmethod
    def ListOrganizationSecrets(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.ListOrganizationSecretsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse]]:
        """List organization secrets

        Returns a paginated list of secrets that belong to the specified
        organization.
        """
    @abc.abstractmethod
    def GetOrganizationSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.GetOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse]]:
        """Get a secret owned by an organization

        Returns the details of an organization-owned secret by its resource name,
        which is defined by the parent organization and the ID of the secret.
        """
    @abc.abstractmethod
    def UpdateOrganizationSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse]]:
        """Update a secret owned by an organization

        Udpates a secret, accessing it by its resource name, which is defined by

        In REST requests, only the supplied secret fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteOrganizationSecret(
        self,
        request: pipeline.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse]]:
        """Delete a secret owned by an organization

        Deletes a secret, accesing it by its resource name, which is defined by
        the parent organization and the ID of the secret.
        """
    @abc.abstractmethod
    def ListPipelineRuns(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsResponse]]:
        """List Pipeline Runs

        Returns a paginated list of runs for a given pipeline. When the requester
        is the owner of the pipeline, they will be able to all the pipeline runs,
        regardless who requested the trigger (the view will be partial to hide
        sensitive data like e.g. the trigger input and output). Other requesters
        will only be able to see the runs requested by themselves.
        """
    @abc.abstractmethod
    def ListComponentRuns(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListComponentRunsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListComponentRunsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListComponentRunsResponse]]:
        """List Component Runs

        Returns the information of each component execution within a pipeline run.
        """
    @abc.abstractmethod
    def ListPipelineRunsByRequester(
        self,
        request: pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsByRequesterRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsByRequesterResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.pipeline_pb2.ListPipelineRunsByRequesterResponse]]:
        """List Pipeline Runs By Requester

        Returns a paginated list of runs for requested by a namespace. The
        response may contain runs from several pipelines.
        """
    @abc.abstractmethod
    def ListNamespaceConnections(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.ListNamespaceConnectionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.ListNamespaceConnectionsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.ListNamespaceConnectionsResponse]]:
        """List namespace connections

        Returns a paginated list of connections created by a namespace.
        """
    @abc.abstractmethod
    def GetNamespaceConnection(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.GetNamespaceConnectionRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.GetNamespaceConnectionResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.GetNamespaceConnectionResponse]]:
        """Get a namespace connection

        Returns the details of a connection.
        """
    @abc.abstractmethod
    def CreateNamespaceConnection(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.CreateNamespaceConnectionRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.CreateNamespaceConnectionResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.CreateNamespaceConnectionResponse]]:
        """Create a connection

        Creates a connection under the ownership of a namespace.
        """
    @abc.abstractmethod
    def UpdateNamespaceConnection(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.UpdateNamespaceConnectionRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.UpdateNamespaceConnectionResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.UpdateNamespaceConnectionResponse]]:
        """Update a connection

        Updates a connection with the supplied connection fields.
        """
    @abc.abstractmethod
    def DeleteNamespaceConnection(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.DeleteNamespaceConnectionRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.DeleteNamespaceConnectionResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.DeleteNamespaceConnectionResponse]]:
        """Delete a connection

        Deletes a connection.
        """
    @abc.abstractmethod
    def TestNamespaceConnection(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.TestNamespaceConnectionRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.TestNamespaceConnectionResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.TestNamespaceConnectionResponse]]:
        """Test a connection

        Makes a request to the 3rd party app that the connection is configured to
        communicate with, and checks the result of the call. If the test fails,
        the response status and error message will provide more information about
        the failure.

        Note that this action might affect the quota or billing of the integrated
        account in the 3rd party app.
        """
    @abc.abstractmethod
    def ListPipelineIDsByConnectionID(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.ListPipelineIDsByConnectionIDRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.ListPipelineIDsByConnectionIDResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.ListPipelineIDsByConnectionIDResponse]]:
        """List pipelines that reference a connection

        Returns a paginated list with the IDs of the pipelines that reference a
        given connection. All the pipelines will belong to the same namespace as
        the connection.
        """
    @abc.abstractmethod
    def ListIntegrations(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.ListIntegrationsRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.ListIntegrationsResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.ListIntegrationsResponse]]:
        """List integrations

        Returns a paginated list of available integrations.
        """
    @abc.abstractmethod
    def GetIntegration(
        self,
        request: pipeline.pipeline.v1beta.integration_pb2.GetIntegrationRequest,
        context: _ServicerContext,
    ) -> typing.Union[pipeline.pipeline.v1beta.integration_pb2.GetIntegrationResponse, collections.abc.Awaitable[pipeline.pipeline.v1beta.integration_pb2.GetIntegrationResponse]]:
        """Get an integration

        Returns the details of an integration.
        """

def add_PipelinePublicServiceServicer_to_server(servicer: PipelinePublicServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
