"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .locale import Locale
from .sequence_type import SequenceType
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetMethodRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    locale: NotRequired[Nullable[Locale]]
    r"""Response language"""
    currency: NotRequired[str]
    r"""If provided, the `minimumAmount` and `maximumAmount` will be converted
    to the given currency. An error is returned if the currency is not supported by the payment method.
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    sequence_type: NotRequired[SequenceType]
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class GetMethodRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    locale: Annotated[
        OptionalNullable[Locale],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Response language"""

    currency: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If provided, the `minimumAmount` and `maximumAmount` will be converted
    to the given currency. An error is returned if the currency is not supported by the payment method.
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    sequence_type: Annotated[
        Optional[SequenceType],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "locale",
            "currency",
            "profileId",
            "include",
            "sequenceType",
            "testmode",
            "idempotency-key",
        ]
        nullable_fields = ["locale", "include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
