<div align="center">
    <img alt="logo" src="https://github.com/volopivoshenko/poetry-plugin-dotenv/blob/main/docs/logo.svg?raw=True" height=200>
</div>

<p align="center">
    <a href="https://opensource.org/licenses/MIT">
        <img alt="license" src="https://img.shields.io/pypi/l/poetry-plugin-dotenv?logo=opensourceinitiative">
    </a>
    <a href="https://pypi.org/project/poetry-plugin-dotenv">
        <img alt="python" src="https://img.shields.io/pypi/pyversions/poetry-plugin-dotenv?logo=python">
    </a>
    <a href="https://pypi.org/project/poetry-plugin-dotenv">
        <img alt="pypi" src="https://img.shields.io/pypi/v/poetry-plugin-dotenv?logo=pypi">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/releases">
        <img alt="release" src="https://img.shields.io/github/v/release/volopivoshenko/poetry-plugin-dotenv?logo=github">
    </a>
</p>

<p align="center">
    <a href="https://github.com/psf/black">
        <img alt="black" src="https://img.shields.io/badge/code_style-black-black.svg?logo=windowsterminal">
    </a>
    <a href="https://pycqa.github.io/isort/index.html">
        <img alt="isort" src="https://img.shields.io/badge/imports-isort-black.svg?logo=windowsterminal">
    </a>
    <a href="https://beta.ruff.rs/docs/">
        <img alt="ruff" src="https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/charliermarsh/ruff/main/assets/badge/v2.json">
    </a>
    <a href="https://mypy.readthedocs.io/en/stable/index.html">
        <img alt="mypy" src="https://img.shields.io/badge/mypy-checked-success.svg?logo=python">
    </a>
    <a href="https://github.com/semantic-release/semantic-release">
        <img alt="semantic_release" src="https://img.shields.io/badge/semantic_release-angular-e10079?logo=semantic-release">
    </a>
    <a href="https://python-poetry.org">
        <img alt="poetry" src="https://img.shields.io/endpoint?url=https://python-poetry.org/badge/v0.json">
    </a>
    <a href="https://numpydoc.readthedocs.io/en/latest/format.html">
        <img alt="numpydoc" src="https://img.shields.io/badge/docstrings-numpy-1f425f.svg?logo=numpy">
    </a>
</p>

<p align="center">
    <a href="https://github.com/dependabot">
        <img alt="dependabot" src="https://img.shields.io/badge/dependabot-enable-success?logo=Dependabot">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/actions/workflows/ci.yaml">
        <img alt="CI" src="https://img.shields.io/github/actions/workflow/status/volopivoshenko/poetry-plugin-dotenv/ci.yaml?label=CI&logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/actions/workflows/cd.yaml">
        <img alt="CD" src="https://img.shields.io/github/actions/workflow/status/volopivoshenko/poetry-plugin-dotenv/cd.yaml?label=CD&logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/actions/workflows/codeql.yaml">
        <img alt="CodeQL" src="https://img.shields.io/github/actions/workflow/status/volopivoshenko/poetry-plugin-dotenv/codeql.yaml?label=CodeQL&logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/actions/workflows/dependency-review.yaml">
        <img alt="Dependency Review" src="https://img.shields.io/github/actions/workflow/status/volopivoshenko/poetry-plugin-dotenv/dependency-review.yaml?label=Dependency%20Review&logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/blob/main/.pre-commit-config.yaml">
        <img alt="hooks" src="https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit">
    </a>
    <a href="https://pypi.org/project/poetry-plugin-dotenv">
        <img alt="wheel" src="https://img.shields.io/pypi/wheel/poetry-plugin-dotenv?logo=pypi">
    </a>
</p>

<p align="center">
    <a href="https://codecov.io/gh/volopivoshenko/poetry-plugin-dotenv">
        <img alt="coverage" src="https://img.shields.io/codecov/c/gh/volopivoshenko/poetry-plugin-dotenv?logo=codecov&token=yyck08xfTN"/>
    </a>
    <a href="https://codeclimate.com/github/volopivoshenko/poetry-plugin-dotenv/maintainability">
        <img alt="codeclimate" src="https://img.shields.io/codeclimate/maintainability/volopivoshenko/poetry-plugin-dotenv?logo=codeclimate">
    </a>
    <a href="https://pypi.org/project/poetry-plugin-dotenv">
        <img alt="downloads" src="https://img.shields.io/pypi/dm/poetry-plugin-dotenv?logo=pypi">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/">
        <img alt="stars" src="https://img.shields.io/github/stars/volopivoshenko/poetry-plugin-dotenv?style=flat&logo=github">
    </a>
    <a href="https://wakatime.com/badge/user/9862508c-0a86-427a-929c-46186f2d191a/project/36344bbb-7f11-4dcd-a36d-e54c81551119">
        <img alt="wakatime" src="https://wakatime.com/badge/user/9862508c-0a86-427a-929c-46186f2d191a/project/36344bbb-7f11-4dcd-a36d-e54c81551119.svg">
    </a>
</p>

<p align="center">
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/issues">
        <img alt="issues" src="https://img.shields.io/github/issues/volopivoshenko/poetry-plugin-dotenv?logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/issues">
        <img alt="issues" src="https://img.shields.io/github/issues-closed/volopivoshenko/poetry-plugin-dotenv?logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/pulls">
        <img alt="pr" src="https://img.shields.io/github/issues-pr/volopivoshenko/poetry-plugin-dotenv?logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/pulls">
        <img alt="pr" src="https://img.shields.io/github/issues-pr-closed/volopivoshenko/poetry-plugin-dotenv?logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/graphs/contributors">
        <img alt="contributors" src="https://img.shields.io/github/contributors/volopivoshenko/poetry-plugin-dotenv?logo=github">
    </a>
    <a href="https://github.com/volopivoshenko/poetry-plugin-dotenv/commits/main">
        <img alt="commit" src="https://img.shields.io/github/last-commit/volopivoshenko/poetry-plugin-dotenv?logo=github">
    </a>
</p>

<p align="center">
    <a href="https://www.buymeacoffee.com/volopivoshenko" target="_blank">
        <img alt="buymeacoffee" src="https://img.shields.io/badge/buy_me_-a_coffee-ff6964?logo=buymeacoffee">
    </a>
    <a href="https://stand-with-ukraine.pp.ua/">
        <img alt="standwithukraine" src="https://img.shields.io/badge/Support-Ukraine-FFD500?style=flat&labelColor=005BBB">
    </a>
    <a href="https://stand-with-ukraine.pp.ua">
        <img alt="standwithukraine" src="https://img.shields.io/badge/made_in-Ukraine-ffd700.svg?labelColor=0057b7">
    </a>
</p>

- [🔮 Overview](#-overview)
- [⚙️ Installation](#️-installation)
- [👩🏻‍💻 Usage](#-usage)

# 🔮 Overview

`poetry-plugin-dotenv` - is the plugin that automatically loads environment variables from a dotenv file into the environment before `poetry` commands are run.

**Features**

- 📦 Doesn't require any dependencies
- 📝 Supports templates, interpolating variables using POSIX variable expansions
- 🔮 Fully type safe
- 🥷🏻 100% tests coverage and "A" grade for maintainability

# ⚙️ Installation

```bash
poetry self add poetry-plugin-dotenv
```

# 👩🏻‍💻 Usage

By default, plugin will load the `.env` file from the current working directory or "higher directories".

To prevent ``poetry`` from loading the dotenv file, set the ``POETRY_DONT_LOAD_DOTENV`` environment variable.

If your dotenv file is located in a different path or has a different name you may set the ``POETRY_DOTENV_LOCATION`` environment variable.

<img alt="logo" src="https://github.com/volopivoshenko/poetry-plugin-dotenv/blob/main/docs/demo.gif?raw=True">

```dotenv
# .env
DB__HOST=localhost
DB__DBNAME=prod
DB__USER=admin
DB__PASSWORD=admin
DB__ENGINE=postgresql://${DB__USER}:${DB__PASSWORD}@${DB__HOST}/${DB__DBNAME}
```

```dotenv
# .env.dev
DB__HOST=localhost
DB__DBNAME=dev
DB__USER=root
DB__PASSWORD=root
DB__ENGINE=postgresql://${DB__USER}:${DB__PASSWORD}@${DB__HOST}/${DB__DBNAME}
```

```python
# main.py
import os


if __name__ == "__main__":
    try:
        print(f"Host: {os.environ['DB__HOST']!r}")
        print(f"Name: {os.environ['DB__DBNAME']!r}")
        print(f"Username: {os.environ['DB__USER']!r}")
        print(f"Password: {os.environ['DB__PASSWORD']!r}")
        print(f"Engine: {os.environ['DB__ENGINE']!r}")

    except KeyError:
        print("Environment variables not set!")
```

```bash
poetry run -vvv python main.py
# Loading environment variables from '.env'.
# Host: 'localhost'
# Name: 'prod'
# Username: 'admin'
# Password: 'admin'
# Engine 'postgresql://admin:admin@localhost/prod'

export POETRY_DOTENV_LOCATION=.env.dev && poetry run -vvv python main.py
# Loading environment variables from '.env.dev'.
# Host: 'localhost'
# Name: 'dev'
# Username: 'root'
# Password: 'root'
# Engine 'postgresql://root:root@localhost/dev'

export POETRY_DONT_LOAD_DOTENV=1 && poetry run -vvv python main.py
# Not loading environment variables.
```
