/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.demos.autoanalysis.AutoAnalyserAIS;
import infodynamics.demos.autoanalysis.AutoAnalyserCMI;
import infodynamics.demos.autoanalysis.AutoAnalyserCTE;
import infodynamics.demos.autoanalysis.AutoAnalyserEntropy;
import infodynamics.demos.autoanalysis.AutoAnalyserMI;
import infodynamics.demos.autoanalysis.AutoAnalyserTE;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class AutoAnalyserLauncher
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JButton[] launcherButtons;
    protected String[] buttonLabels = new String[]{"Entropy", "Mutual Info", "Conditional Mutual Info", "Active Info Storage", "Transfer Entropy", "Conditional Transfer Entropy"};
    protected Class[] launcherClasses = new Class[]{AutoAnalyserEntropy.class, AutoAnalyserMI.class, AutoAnalyserCMI.class, AutoAnalyserAIS.class, AutoAnalyserTE.class, AutoAnalyserCTE.class};
    protected String appletTitle = "JIDT AutoAnalyser Launcher";
    protected String offsetFromJidtToAutoAnalyserFolder = "demos/AutoAnalyser/";
    protected String autoAnalyserFolder = null;

    public AutoAnalyserLauncher(boolean bl) {
        Serializable serializable;
        String string = null;
        if (!bl && ((URL)(serializable = this.getClass().getProtectionDomain().getCodeSource().getLocation())).getPath().endsWith("jar")) {
            string = ((URL)serializable).getPath().replaceFirst("infodynamics.jar", "");
            this.autoAnalyserFolder = string + this.offsetFromJidtToAutoAnalyserFolder;
        }
        if (this.autoAnalyserFolder == null) {
            this.autoAnalyserFolder = System.getProperty("user.dir") + "/";
            string = this.autoAnalyserFolder + "/../../";
        }
        if (((ImageIcon)(serializable = new ImageIcon(string + "JIDT-logo.png"))).getImageLoadStatus() != 8) {
            serializable = new ImageIcon(string + "web/JIDT-logo.png");
        }
        this.setIconImage(((ImageIcon)serializable).getImage());
        this.setDefaultCloseOperation(3);
        this.setSize(250, 300);
        this.setTitle(this.appletTitle);
        this.setLocationRelativeTo(null);
        this.launcherButtons = new JButton[this.buttonLabels.length];
        for (int i = 0; i < this.launcherButtons.length; ++i) {
            this.launcherButtons[i] = new JButton(this.buttonLabels[i]);
            this.launcherButtons[i].addActionListener(this);
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel("Select AutoAnalyser to launch:");
        jLabel.setSize(10, 10);
        jLabel.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setSize(10, 10);
        jLabel2.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        for (int i = 0; i < this.launcherButtons.length; ++i) {
            this.launcherButtons[i].setHorizontalAlignment(0);
            jPanel.add((Component)this.launcherButtons[i], gridBagConstraints);
            JLabel jLabel3 = new JLabel(" ");
            jLabel3.setSize(10, 10);
            jPanel.add((Component)jLabel3, gridBagConstraints);
        }
        this.add((Component)jPanel, "West");
        this.setVisible(true);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.launcherButtons.length; ++i) {
            if (actionEvent.getSource() != this.launcherButtons[i]) continue;
            try {
                Constructor constructor = this.launcherClasses[i].getConstructor(String.class);
                constructor.newInstance(this.autoAnalyserFolder);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.getMessage(), "Error launching " + this.buttonLabels[i] + " AutoAnalyser", 0);
                exception.printStackTrace();
                System.out.println();
                return;
            }
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        new AutoAnalyserLauncher(stringArray.length > 0);
    }
}

