/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.ActiveInfoStorageCalculatorMultiVariateViaMutualInfo;
import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov1;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov2;
import infodynamics.utils.MatrixUtils;
import java.util.Hashtable;

public class ActiveInfoStorageCalculatorMultiVariateKraskov
extends ActiveInfoStorageCalculatorMultiVariateViaMutualInfo {
    public static final String MI_CALCULATOR_KRASKOV1 = MutualInfoCalculatorMultiVariateKraskov1.class.getName();
    public static final String MI_CALCULATOR_KRASKOV2 = MutualInfoCalculatorMultiVariateKraskov2.class.getName();
    public static final String PROP_KRASKOV_ALG_NUM = "ALG_NUM";
    protected int kraskovAlgorithmNumber = 2;
    protected boolean algChanged = false;
    protected Hashtable<String, String> props;
    public static final String PROP_AUTO_EMBED_METHOD = "AUTO_EMBED_METHOD";
    public static final String AUTO_EMBED_METHOD_NONE = "NONE";
    public static final String AUTO_EMBED_METHOD_RAGWITZ = "RAGWITZ";
    protected String autoEmbeddingMethod = "NONE";
    public static final String PROP_K_SEARCH_MAX = "AUTO_EMBED_K_SEARCH_MAX";
    protected int k_search_max = 1;
    public static final String PROP_TAU_SEARCH_MAX = "AUTO_EMBED_TAU_SEARCH_MAX";
    protected int tau_search_max = 1;
    public static final String PROP_RAGWITZ_NUM_NNS = "AUTO_EMBED_RAGWITZ_NUM_NNS";
    protected int ragwitz_num_nns = 1;
    protected boolean ragwitz_num_nns_set = false;

    public ActiveInfoStorageCalculatorMultiVariateKraskov() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(MI_CALCULATOR_KRASKOV2);
        this.props = new Hashtable();
    }

    public ActiveInfoStorageCalculatorMultiVariateKraskov(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(string);
        if (!string.equalsIgnoreCase(MI_CALCULATOR_KRASKOV1) && !string.equalsIgnoreCase(MI_CALCULATOR_KRASKOV2)) {
            throw new ClassNotFoundException("Must be an underlying Kraskov-Stoegbauer-Grassberger calculator");
        }
        this.props = new Hashtable();
    }

    public ActiveInfoStorageCalculatorMultiVariateKraskov(int n) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(n == 1 ? MI_CALCULATOR_KRASKOV1 : MI_CALCULATOR_KRASKOV2);
        if (n != 1 && n != 2) {
            throw new ClassNotFoundException("Algorithm must be 1 or 2");
        }
        this.props = new Hashtable();
    }

    @Override
    public void initialise(int n, int n2, int n3) throws Exception {
        if (this.algChanged) {
            String string = MI_CALCULATOR_KRASKOV1;
            if (this.kraskovAlgorithmNumber == 2) {
                string = MI_CALCULATOR_KRASKOV2;
            }
            Class<?> clazz = Class.forName(string);
            MutualInfoCalculatorMultiVariate mutualInfoCalculatorMultiVariate = (MutualInfoCalculatorMultiVariate)clazz.newInstance();
            this.construct(mutualInfoCalculatorMultiVariate);
            for (String string2 : this.props.keySet()) {
                mutualInfoCalculatorMultiVariate.setProperty(string2, this.props.get(string2));
            }
            this.algChanged = false;
        }
        super.initialise(n, n2, n3);
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase(PROP_AUTO_EMBED_METHOD)) {
            this.autoEmbeddingMethod = string2;
        } else if (string.equalsIgnoreCase(PROP_K_SEARCH_MAX)) {
            this.k_search_max = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_TAU_SEARCH_MAX)) {
            this.tau_search_max = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_RAGWITZ_NUM_NNS)) {
            this.ragwitz_num_nns = Integer.parseInt(string2);
            this.ragwitz_num_nns_set = true;
        } else if (string.equalsIgnoreCase(PROP_KRASKOV_ALG_NUM)) {
            int n = this.kraskovAlgorithmNumber;
            this.kraskovAlgorithmNumber = Integer.parseInt(string2);
            if (this.kraskovAlgorithmNumber != 1 && this.kraskovAlgorithmNumber != 2) {
                throw new Exception("Kraskov algorithm number (" + this.kraskovAlgorithmNumber + ") must be either 1 or 2");
            }
            if (this.kraskovAlgorithmNumber != n) {
                this.algChanged = true;
            }
        } else {
            bl = false;
            super.setProperty(string, string2);
            this.props.put(string, string2);
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public void preFinaliseAddObservations() throws Exception {
        if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_NONE)) {
            return;
        }
        double d = Double.POSITIVE_INFINITY;
        int n = 1;
        int n2 = 1;
        if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_RAGWITZ)) {
            if (this.debug) {
                System.out.printf("Beginning Ragwitz auto-embedding with k_max=%d, tau_max=%d\n", this.k_search_max, this.tau_search_max);
            }
            block0: for (int i = 1; i <= this.k_search_max; ++i) {
                for (int j = 1; j <= this.tau_search_max; ++j) {
                    Object object;
                    double[][] dArray;
                    double[][] dArray2;
                    this.miCalc.initialise(i * this.dimensions, this.dimensions);
                    this.miCalc.startAddObservations();
                    if (this.dimensions == 1) {
                        for (Object object2 : this.vectorOfObservationTimeSeries) {
                            dArray2 = MatrixUtils.makeDelayEmbeddingVector(object2, i, j, (i - 1) * j, ((double[])object2).length - (i - 1) * j - 1);
                            dArray = MatrixUtils.makeDelayEmbeddingVector(object2, 1, (i - 1) * j + 1, ((double[])object2).length - (i - 1) * j - 1);
                            this.miCalc.addObservations(dArray2, dArray);
                        }
                    } else {
                        object = this.vectorOfMultiVariateObservationTimeSeries.iterator();
                        while (object.hasNext()) {
                            Object object2;
                            object2 = (double[][])object.next();
                            dArray2 = MatrixUtils.makeDelayEmbeddingVector((double[][])object2, i, j, (i - 1) * j, ((double[])object2).length - (i - 1) * j - 1);
                            dArray = MatrixUtils.makeDelayEmbeddingVector((double[][])object2, 1, (i - 1) * j + 1, ((double[])object2).length - (i - 1) * j - 1);
                            this.miCalc.addObservations(dArray2, dArray);
                        }
                    }
                    this.miCalc.finaliseAddObservations();
                    object = this.ragwitz_num_nns_set ? (Object)((MutualInfoCalculatorMultiVariateKraskov)this.miCalc).computePredictionErrorsFromObservations(false, this.ragwitz_num_nns) : (Object)((MutualInfoCalculatorMultiVariateKraskov)this.miCalc).computePredictionErrorsFromObservations(false);
                    if (this.debug) {
                        System.out.printf("Embedding prediction error (dim=%d) for k=%d,tau=%d is %.3f\n", ((Object)object).length, i, j, MatrixUtils.sum((double[])object) / (double)this.miCalc.getNumObservations());
                    }
                    if (MatrixUtils.sum((double[])object) / (double)this.miCalc.getNumObservations() < d) {
                        d = MatrixUtils.sum((double[])object) / (double)this.miCalc.getNumObservations();
                        n = i;
                        n2 = j;
                    }
                    if (i == 1) continue block0;
                }
            }
        }
        this.k = n;
        this.tau = n2;
        if (this.debug) {
            System.out.printf("Embedding parameters set to k=%d,tau=%d (for prediction error %.3f)\n", this.k, this.tau, d);
        }
    }
}

