/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.BlockEntropyCalculatorDiscrete;
import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.measures.discrete.SingleAgentMeasureDiscrete;
import infodynamics.utils.MatrixUtils;

public class EntropyCalculatorDiscrete
extends InfoMeasureCalculatorDiscrete
implements SingleAgentMeasureDiscrete {
    protected int[] stateCount = null;

    public static EntropyCalculatorDiscrete newInstance(int n, int n2) {
        if (n2 > 1) {
            return BlockEntropyCalculatorDiscrete.newInstance(n2, n);
        }
        return EntropyCalculatorDiscrete.newInstance(n);
    }

    public static EntropyCalculatorDiscrete newInstance(int n) {
        return new EntropyCalculatorDiscrete(n);
    }

    public EntropyCalculatorDiscrete(int n) {
        super(n);
        this.stateCount = new int[n];
    }

    @Override
    public void initialise() {
        super.initialise();
        MatrixUtils.fill(this.stateCount, 0);
    }

    @Override
    public void addObservations(int[] nArray) {
        int n = nArray.length;
        this.observations += n;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            this.stateCount[n2] = this.stateCount[n2] + 1;
        }
    }

    @Override
    public void addObservations(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        this.observations += n * n2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = nArray[i][j];
                this.stateCount[n3] = this.stateCount[n3] + 1;
            }
        }
    }

    @Override
    public void addObservations(int[][][] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = nArray[0].length;
        if (n2 == 0) {
            return;
        }
        int n3 = nArray[0][0].length;
        this.observations += n * n2 * n3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n4 = nArray[i][j][k];
                    this.stateCount[n4] = this.stateCount[n4] + 1;
                }
            }
        }
    }

    @Override
    public void addObservations(int[][] nArray, int n) {
        int n2 = nArray.length;
        this.observations += n2;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i][n];
            this.stateCount[n3] = this.stateCount[n3] + 1;
        }
    }

    @Override
    public void addObservations(int[][][] nArray, int n, int n2) {
        int n3 = nArray.length;
        this.observations += n3;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i][n][n2];
            this.stateCount[n4] = this.stateCount[n4] + 1;
        }
    }

    public int getStateCount(int n) {
        return this.stateCount[n];
    }

    public double getStateProbability(int n) {
        return (double)this.stateCount[n] / (double)this.observations;
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < this.base; ++i) {
            double d3 = (double)this.stateCount[i] / (double)this.observations;
            if (d3 > 0.0) {
                double d4 = -Math.log(d3) / this.log_2;
                d2 = d3 * d4;
                if (d4 > this.max) {
                    this.max = d4;
                } else if (d4 < this.min) {
                    this.min = d4;
                }
            } else {
                d2 = 0.0;
            }
            d += d2;
        }
        this.average = d;
        return d;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[] nArray) {
        int n = nArray.length;
        double[] dArray = new double[n];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < n; ++i) {
            double d = (double)this.stateCount[nArray[i]] / (double)this.observations;
            dArray[i] = -Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
                continue;
            }
            if (!(dArray[i] < this.min)) continue;
            this.min = dArray[i];
        }
        this.average /= (double)n;
        return dArray;
    }

    @Override
    public double[][] computeLocalFromPreviousObservations(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        double[][] dArray = new double[n][n2];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = (double)this.stateCount[nArray[i][j]] / (double)this.observations;
                dArray[i][j] = -Math.log(d) / this.log_2;
                this.average += dArray[i][j];
                if (dArray[i][j] > this.max) {
                    this.max = dArray[i][j];
                    continue;
                }
                if (!(dArray[i][j] < this.min)) continue;
                this.min = dArray[i][j];
            }
        }
        this.average /= (double)(n2 * n);
        return dArray;
    }

    @Override
    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        if (n3 == 0) {
            n2 = 0;
            n = 0;
        } else {
            n2 = nArray[0].length;
            n = n2 == 0 ? 0 : nArray[0][0].length;
        }
        double[][][] dArray = new double[n3][n2][n];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    double d = (double)this.stateCount[nArray[i][j][k]] / (double)this.observations;
                    dArray[i][j][k] = -Math.log(d) / this.log_2;
                    this.average += dArray[i][j][k];
                    if (dArray[i][j][k] > this.max) {
                        this.max = dArray[i][j][k];
                        continue;
                    }
                    if (!(dArray[i][j][k] < this.min)) continue;
                    this.min = dArray[i][j][k];
                }
            }
        }
        this.average /= (double)(n2 * n * n3);
        return dArray;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n) {
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d = (double)this.stateCount[nArray[i][n]] / (double)this.observations;
            dArray[i] = -Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
                continue;
            }
            if (!(dArray[i] < this.min)) continue;
            this.min = dArray[i];
        }
        this.average /= (double)n2;
        return dArray;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2) {
        int n3 = nArray.length;
        double[] dArray = new double[n3];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < n3; ++i) {
            double d = (double)this.stateCount[nArray[i][n][n2]] / (double)this.observations;
            dArray[i] = -Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
                continue;
            }
            if (!(dArray[i] < this.min)) continue;
            this.min = dArray[i];
        }
        this.average /= (double)n3;
        return dArray;
    }

    @Override
    public final double[] computeLocal(int[] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeLocalFromPreviousObservations(nArray);
    }

    @Override
    public final double[][] computeLocal(int[][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeLocalFromPreviousObservations(nArray);
    }

    @Override
    public final double[][][] computeLocal(int[][][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeLocalFromPreviousObservations(nArray);
    }

    @Override
    public final double computeAverageLocal(int[] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeAverageLocalOfObservations();
    }

    @Override
    public final double computeAverageLocal(int[][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeAverageLocalOfObservations();
    }

    @Override
    public final double computeAverageLocal(int[][][] nArray) {
        this.initialise();
        this.addObservations(nArray);
        return this.computeAverageLocalOfObservations();
    }

    @Override
    public final double[] computeLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeLocalFromPreviousObservations(nArray, n);
    }

    @Override
    public final double[] computeLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeLocalFromPreviousObservations(nArray, n, n2);
    }

    @Override
    public final double computeAverageLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeAverageLocalOfObservations();
    }

    @Override
    public final double computeAverageLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeAverageLocalOfObservations();
    }
}

