/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.distribution;

import infodynamics.utils.commonsmath3.distribution.AbstractIntegerDistribution;
import infodynamics.utils.commonsmath3.exception.NotStrictlyPositiveException;
import infodynamics.utils.commonsmath3.exception.OutOfRangeException;
import infodynamics.utils.commonsmath3.exception.util.Localizable;
import infodynamics.utils.commonsmath3.exception.util.LocalizedFormats;
import infodynamics.utils.commonsmath3.random.RandomGenerator;
import infodynamics.utils.commonsmath3.random.Well19937c;
import infodynamics.utils.commonsmath3.special.Beta;
import infodynamics.utils.commonsmath3.util.CombinatoricsUtils;
import infodynamics.utils.commonsmath3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public PascalDistribution(int n, double d) throws NotStrictlyPositiveException, OutOfRangeException {
        this(new Well19937c(), n, d);
    }

    public PascalDistribution(RandomGenerator randomGenerator, int n, double d) throws NotStrictlyPositiveException, OutOfRangeException {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n);
        }
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        this.numberOfSuccesses = n;
        this.probabilityOfSuccess = d;
        this.logProbabilityOfSuccess = FastMath.log(d);
        this.log1mProbabilityOfSuccess = FastMath.log1p(-d);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int n) {
        double d = n < 0 ? 0.0 : CombinatoricsUtils.binomialCoefficientDouble(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, n);
        return d;
    }

    @Override
    public double logProbability(int n) {
        double d = n < 0 ? Double.NEGATIVE_INFINITY : CombinatoricsUtils.binomialCoefficientLog(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) + this.logProbabilityOfSuccess * (double)this.numberOfSuccesses + this.log1mProbabilityOfSuccess * (double)n;
        return d;
    }

    @Override
    public double cumulativeProbability(int n) {
        double d = n < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, (double)n + 1.0);
        return d;
    }

    @Override
    public double getNumericalMean() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / d;
    }

    @Override
    public double getNumericalVariance() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / (d * d);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

