# -*- coding: utf-8 -*-
# Copyright 2023 OpenSPG Authors
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
# in compliance with the License. You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License
# is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
# or implied.
from abc import ABC

from kag.interface.builder.base import BuilderComponent
from kag.builder.model.chunk import Chunk
from knext.common.base.runnable import Input, Output


class ReaderABC(BuilderComponent, ABC):
    """
    Abstract base class for reading content generated by upstream scanner into a list of text chunks.

    This class defines the interface for components that reading content generated by upstream scanner
    and convert them into a list of text chunks. It inherits from `BuilderComponent` and `ABC` (Abstract Base Class).
    """

    @property
    def input_types(self) -> Input:
        return str

    @property
    def output_types(self) -> Output:
        return Chunk

    @property
    def ckpt_subdir(self):
        return "reader"
