# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute key        | Parent entity | Purpose                                                                                                                                                                                      | |:---------------------|:--------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------| | `ICON_NAME`          | location      | The attribute value is written to the `web_location_geopoint.icon_name` field                                                                                                                | | `FORCED_GEOPROVIDER` | geo_settings  | The attribute value determines the geodata provider for rendering flights on the map, which will be used instead of the one specified in the `plan_settings.geo_settings.geo_provider` field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.21.2849
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.geopoint import Geopoint
from typing import Optional, Set
from typing_extensions import Self

class WebPerformerGeopoint(BaseModel):
    """
    Geopoint for map.
    """ # noqa: E501
    geopoint: Geopoint
    performer_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer's key.")
    shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Shift key, unique identifier.")
    point_type: StrictStr = Field(description="The point type.")
    trip_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Essence key, unique identifier, may be `null`.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=128)]] = Field(default='', description="Name, information field.")
    stop_number: Optional[Annotated[int, Field(le=1000, strict=True, ge=0)]] = Field(default=0, description="Sequence number of the stop in the trip.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["geopoint", "performer_key", "shift_key", "point_type", "trip_key", "trip_name", "stop_number"]

    @field_validator('point_type')
    def point_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['START', 'FINISH']):
            raise ValueError("must be one of enum values ('START', 'FINISH')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebPerformerGeopoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if trip_key (nullable) is None
        # and model_fields_set contains the field
        if self.trip_key is None and "trip_key" in self.model_fields_set:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebPerformerGeopoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "geopoint": Geopoint.from_dict(obj["geopoint"]) if obj.get("geopoint") is not None else None,
            "performer_key": obj.get("performer_key"),
            "shift_key": obj.get("shift_key"),
            "point_type": obj.get("point_type"),
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "stop_number": obj.get("stop_number") if obj.get("stop_number") is not None else 0
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


