"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuildBadge = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// import * as path from 'path';
const apigateway = require("@aws-cdk/aws-apigateway");
// import * as lambda from '@aws-cdk/aws-lambda';
const iam = require("@aws-cdk/aws-iam");
const lambdajs = require("@aws-cdk/aws-lambda-nodejs");
const core = require("@aws-cdk/core");
/**
 * @stability stable
 */
class BuildBadge extends core.Construct {
    /**
     * @stability stable
     */
    constructor(parent, id, props) {
        super(parent, id);
        const badgeLambda = new lambdajs.NodejsFunction(this, 'badge', {
            bundling: {
                commandHooks: {
                    afterBundling(inputDir, outputDir) {
                        return [`mkdir ${outputDir}/badges`, `cp -r ${inputDir}/node_modules/aws-cdk-build-badge/badges ${outputDir} 2>/dev/null || cp -r ${inputDir}/badges ${outputDir}`];
                    },
                    beforeInstall(_inputDir, _outputDir) {
                        return [];
                    },
                    beforeBundling(_inputDir, _outputDir) {
                        return [];
                    },
                },
            },
            environment: {
                ACCOUNT: (props === null || props === void 0 ? void 0 : props.hideAccountID) ? (props.hideAccountID === 'no' ? parent.account : props.hideAccountID) : '123',
                DEFAULT_PROJECT_NAME: (props === null || props === void 0 ? void 0 : props.defaultProjectName) || '',
            },
            timeout: core.Duration.minutes(15),
        });
        badgeLambda.addToRolePolicy(new iam.PolicyStatement({
            actions: ['codebuild:ListBuildsForProject', 'codebuild:BatchGetBuilds'],
            resources: ['*'],
        }));
        const lambdaRestApi = new apigateway.LambdaRestApi(this, 'LambdaRestApi', {
            handler: badgeLambda,
            binaryMediaTypes: ['*/*'],
        });
        this.badgeUrl = lambdaRestApi.url;
        new core.CfnOutput(this, 'BadgeBuildUrl', {
            value: `${this.badgeUrl}?url=true&projectName=XXX`,
        });
        new core.CfnOutput(this, 'BadgeUrl', {
            value: `${this.badgeUrl}?projectName=XXX`,
        });
    }
}
exports.BuildBadge = BuildBadge;
_a = JSII_RTTI_SYMBOL_1;
BuildBadge[_a] = { fqn: "aws-cdk-build-badge.BuildBadge", version: "1.97.8" };
//# sourceMappingURL=data:application/json;base64,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