"use strict";
const massage_spec_1 = require("../build-tools/massage-spec");
module.exports = {
    'dropTypelessAttributes works correctly'(test) {
        const spec = {
            Fingerprint: 'some-fingerprint',
            PropertyTypes: {
                'CDK::Test::Property': {
                    Properties: {
                        Type: {
                            PrimitiveType: 'String',
                        },
                    },
                },
            },
            ResourceTypes: {
                'CDK::Test::Resource': {
                    Attributes: {
                        Attribute1: {
                            PrimitiveType: 'String',
                        },
                        Attribute2: {},
                    },
                    Documentation: 'https://documentation-url/cdk/test/resource',
                    Properties: {
                        ResourceArn: {
                            PrimitiveType: 'String',
                        },
                    },
                },
            },
        };
        massage_spec_1.massageSpec(spec);
        test.deepEqual(spec, {
            Fingerprint: 'some-fingerprint',
            PropertyTypes: {
                'CDK::Test::Property': {
                    Properties: {
                        Type: {
                            PrimitiveType: 'String',
                        },
                    },
                },
            },
            ResourceTypes: {
                'CDK::Test::Resource': {
                    Attributes: {
                        Attribute1: ({
                            PrimitiveType: 'String',
                        }),
                    },
                    Documentation: 'https://documentation-url/cdk/test/resource',
                    Properties: {
                        ResourceArn: {
                            PrimitiveType: 'String',
                        },
                    },
                },
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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