"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfnspec = require("../lib");
module.exports = {
    'spot-check Bucket statefulness'(test) {
        const anno = cfnspec.cfnLintAnnotations('AWS::S3::Bucket');
        test.equal(anno.stateful, true);
        test.equal(anno.mustBeEmptyToDelete, true);
        test.done();
    },
    'spot-check Table statefulness'(test) {
        const anno = cfnspec.cfnLintAnnotations('AWS::DynamoDB::Table');
        test.equal(anno.stateful, true);
        test.equal(anno.mustBeEmptyToDelete, false);
        test.done();
    },
    'spot-check MediaStore metrics'(test) {
        const anno = cfnspec.cfnLintAnnotations('AWS::MediaStore::Thingy');
        test.equal(anno.stateful, false);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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