"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.APPMESH_ECR_ACCOUNTS = exports.DLC_REPOSITORY_ACCOUNTS = exports.ELBV2_ACCOUNTS = exports.PARTITION_MAP = exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = exports.AWS_CDK_METADATA = exports.AWS_OLDER_REGIONS = void 0;
exports.AWS_OLDER_REGIONS = new Set([
    'us-east-1',
    'us-west-1',
    'us-west-2',
    'us-gov-west-1',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'sa-east-1',
    'eu-west-1',
]);
exports.AWS_CDK_METADATA = new Set([
    'us-east-2',
    'us-east-1',
    'us-west-1',
    'us-west-2',
    // 'us-gov-east-1',
    // 'us-gov-west-1',
    // 'us-iso-east-1',
    // 'us-isob-east-1',
    'af-south-1',
    'ap-south-1',
    'ap-east-1',
    // 'ap-northeast-3',
    'ap-northeast-2',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'eu-north-1',
    'eu-south-1',
    'me-south-1',
    'sa-east-1',
]);
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints
 */
exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = {
    'af-south-1': 'Z11KHD8FBVPUYU',
    'ap-east-1': 'ZNB98KWMFR0R6',
    'ap-northeast-1': 'Z2M4EHUR26P7ZW',
    'ap-northeast-2': 'Z3W03O7B5YMIYP',
    'ap-northeast-3': 'Z2YQB5RD63NC85',
    'ap-south-1': 'Z11RGJOFQNVJUP',
    'ap-southeast-1': 'Z3O0J2DXBE1FTB',
    'ap-southeast-2': 'Z1WCIGYICN2BYD',
    'ca-central-1': 'Z1QDHH18159H29',
    'eu-central-1': 'Z21DNDUVLTQW6Q',
    'eu-north-1': 'Z3BAZG2TWCNX0D',
    'eu-south-1': 'Z3IXVV8C73GIO3',
    'eu-west-1': 'Z1BKCTXD74EZPE',
    'eu-west-2': 'Z3GKZC51ZF0DB4',
    'eu-west-3': 'Z3R1K369G5AVDG',
    'me-south-1': 'Z1MPMWCPA7YB62',
    'sa-east-1': 'Z7KQH4QJS55SO',
    'us-east-1': 'Z3AQBSTGFYJSTF',
    'us-east-2': 'Z2O1EMRO9K5GLX',
    'us-gov-east-1': 'Z2NIFVYYW2VKV1',
    'us-gov-west-1': 'Z31GFT0UA1I2HV',
    'us-west-1': 'Z2F56UZL2M1ACD',
    'us-west-2': 'Z3BJ6K6RIION7M',
};
exports.PARTITION_MAP = {
    'default': { partition: 'aws', domainSuffix: 'amazonaws.com' },
    'cn-': { partition: 'aws-cn', domainSuffix: 'amazonaws.com.cn' },
    'us-gov-': { partition: 'aws-us-gov', domainSuffix: 'amazonaws.com' },
    'us-iso-': { partition: 'aws-iso', domainSuffix: 'c2s.ic.gov' },
    'us-isob-': { partition: 'aws-iso-b', domainSuffix: 'sc2s.sgov.gov' },
};
// https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html#access-logging-bucket-permissions
exports.ELBV2_ACCOUNTS = {
    'af-south-1': '098369216593',
    'ap-east-1': '754344448648',
    'ap-northeast-1': '582318560864',
    'ap-northeast-2': '600734575887',
    'ap-northeast-3': '383597477331',
    'ap-south-1': '718504428378',
    'ap-southeast-1': '114774131450',
    'ap-southeast-2': '783225319266',
    'ca-central-1': '985666609251',
    'cn-north-1': '638102146993',
    'cn-northwest-1': '037604701340',
    'eu-central-1': '054676820928',
    'eu-north-1': '897822967062',
    'eu-south-1': '635631232127',
    'eu-west-1': '156460612806',
    'eu-west-2': '652711504416',
    'eu-west-3': '009996457667',
    'me-south-1': '076674570225',
    'sa-east-1': '507241528517',
    'us-east-1': '127311923021',
    'us-east-2': '033677994240',
    'us-gov-east-1': '190560391635',
    'us-gov-west-1': '048591011584',
    'us-west-1': '027434742980',
    'us-west-2': '797873946194',
};
// https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
exports.DLC_REPOSITORY_ACCOUNTS = {
    'ap-east-1': '871362719292',
    'ap-northeast-1': '763104351884',
    'ap-northeast-2': '763104351884',
    'ap-south-1': '763104351884',
    'ap-southeast-1': '763104351884',
    'ap-southeast-2': '763104351884',
    'ca-central-1': '763104351884',
    'cn-north-1': '727897471807',
    'cn-northwest-1': '727897471807',
    'eu-central-1': '763104351884',
    'eu-north-1': '763104351884',
    'eu-west-1': '763104351884',
    'eu-west-2': '763104351884',
    'eu-west-3': '763104351884',
    'me-south-1': '217643126080',
    'sa-east-1': '763104351884',
    'us-east-1': '763104351884',
    'us-east-2': '763104351884',
    'us-west-1': '763104351884',
    'us-west-2': '763104351884',
};
// https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html
exports.APPMESH_ECR_ACCOUNTS = {
    'af-south-1': '924023996002',
    'ap-east-1': '856666278305',
    'ap-northeast-1': '840364872350',
    'ap-northeast-2': '840364872350',
    'ap-northeast-3': '840364872350',
    'ap-south-1': '840364872350',
    'ap-southeast-1': '840364872350',
    'ap-southeast-2': '840364872350',
    'ca-central-1': '840364872350',
    'eu-central-1': '840364872350',
    'eu-north-1': '840364872350',
    'eu-south-1': '422531588944',
    'eu-west-1': '840364872350',
    'eu-west-2': '840364872350',
    'eu-west-3': '840364872350',
    'me-south-1': '772975370895',
    'sa-east-1': '840364872350',
    'us-east-1': '840364872350',
    'us-east-2': '840364872350',
    'us-west-1': '840364872350',
    'us-west-2': '840364872350',
};
//# sourceMappingURL=data:application/json;base64,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