import * as core from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface BuildBadgeProps {
    /**
     * Thats a little safety feature.
     *
     * Set it to 'no' for allowing to see your account id when retrieving the CodeBuild URL.
     * You can as well use a pattern which hides part of your account id like XX1237193288
     *
     * @default - not set and account id will be shown as 123
     * @stability stable
     */
    readonly hideAccountID?: string;
    /**
     * Specify a default project name.
     *
     * Than you don't need to add it in the url. If you do so anyway the default here will be ignored.
     *
     * @default - not set
     * @stability stable
     */
    readonly defaultProjectName?: string;
}
/**
 * @stability stable
 */
export declare class BuildBadge extends core.Construct {
    /**
     * @stability stable
     */
    readonly badgeUrl: string;
    /**
     * @stability stable
     */
    constructor(parent: core.Stack, id: string, props?: BuildBadgeProps);
}
