"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.haveType = void 0;
const assertion_1 = require("../assertion");
function haveType(type) {
    return new StackPathHasTypeAssertion(type);
}
exports.haveType = haveType;
class StackPathHasTypeAssertion extends assertion_1.Assertion {
    constructor(type) {
        super();
        this.type = type;
    }
    assertUsing(inspector) {
        const resource = inspector.value;
        return resource !== undefined && resource.Type === this.type;
    }
    get description() {
        return `resource of type ${this.type}`;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGF2ZS10eXBlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaGF2ZS10eXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDRDQUF5QztBQUd6QyxTQUFnQixRQUFRLENBQUMsSUFBWTtJQUNuQyxPQUFPLElBQUkseUJBQXlCLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDN0MsQ0FBQztBQUZELDRCQUVDO0FBRUQsTUFBTSx5QkFBMEIsU0FBUSxxQkFBNkI7SUFDbkUsWUFBNkIsSUFBWTtRQUN2QyxLQUFLLEVBQUUsQ0FBQztRQURtQixTQUFJLEdBQUosSUFBSSxDQUFRO0lBRXpDLENBQUM7SUFFTSxXQUFXLENBQUMsU0FBNkI7UUFDOUMsTUFBTSxRQUFRLEdBQUcsU0FBUyxDQUFDLEtBQUssQ0FBQztRQUNqQyxPQUFPLFFBQVEsS0FBSyxTQUFTLElBQUksUUFBUSxDQUFDLElBQUksS0FBSyxJQUFJLENBQUMsSUFBSSxDQUFDO0lBQy9ELENBQUM7SUFFRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxvQkFBb0IsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ3pDLENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFzc2VydGlvbiB9IGZyb20gJy4uL2Fzc2VydGlvbic7XG5pbXBvcnQgeyBTdGFja1BhdGhJbnNwZWN0b3IgfSBmcm9tICcuLi9pbnNwZWN0b3InO1xuXG5leHBvcnQgZnVuY3Rpb24gaGF2ZVR5cGUodHlwZTogc3RyaW5nKTogQXNzZXJ0aW9uPFN0YWNrUGF0aEluc3BlY3Rvcj4ge1xuICByZXR1cm4gbmV3IFN0YWNrUGF0aEhhc1R5cGVBc3NlcnRpb24odHlwZSk7XG59XG5cbmNsYXNzIFN0YWNrUGF0aEhhc1R5cGVBc3NlcnRpb24gZXh0ZW5kcyBBc3NlcnRpb248U3RhY2tQYXRoSW5zcGVjdG9yPiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdHlwZTogc3RyaW5nKSB7XG4gICAgc3VwZXIoKTtcbiAgfVxuXG4gIHB1YmxpYyBhc3NlcnRVc2luZyhpbnNwZWN0b3I6IFN0YWNrUGF0aEluc3BlY3Rvcik6IGJvb2xlYW4ge1xuICAgIGNvbnN0IHJlc291cmNlID0gaW5zcGVjdG9yLnZhbHVlO1xuICAgIHJldHVybiByZXNvdXJjZSAhPT0gdW5kZWZpbmVkICYmIHJlc291cmNlLlR5cGUgPT09IHRoaXMudHlwZTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgZGVzY3JpcHRpb24oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYHJlc291cmNlIG9mIHR5cGUgJHt0aGlzLnR5cGV9YDtcbiAgfVxufVxuIl19