"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
/**
 * @stability stable
 */
class EnvironmentUtils {
    /**
     * @stability stable
     */
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                'Expected format: aws://account/region');
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    /**
     * Build an environment object from an account and region.
     *
     * @stability stable
     */
    static make(account, region) {
        return { account, region, name: this.format(account, region) };
    }
    /**
     * Format an environment string from an account and region.
     *
     * @stability stable
     */
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentUtils[_a] = { fqn: "@aws-cdk/cx-api.EnvironmentUtils", version: "1.97.0" };
//# sourceMappingURL=data:application/json;base64,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