"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, 'aws-cdk-s3');
// Test a lifecycle rule with an expiration DATE
new lib_1.Bucket(stack, 'MyBucket', {
    lifecycleRules: [{
            expirationDate: new Date('2019-10-01')
        }],
    removalPolicy: cdk_1.RemovalPolicy.Destroy
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubGlmZWN5Y2xlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcubGlmZWN5Y2xlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsc0NBQXlEO0FBQ3pELGdDQUFnQztBQUVoQyxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sS0FBSyxHQUFHLElBQUksV0FBSyxDQUFDLEdBQUcsRUFBRSxZQUFZLENBQUMsQ0FBQztBQUUzQyxnREFBZ0Q7QUFDaEQsSUFBSSxZQUFNLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRTtJQUM1QixjQUFjLEVBQUUsQ0FBQztZQUNmLGNBQWMsRUFBRSxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDdkMsQ0FBQztJQUNGLGFBQWEsRUFBRSxtQkFBYSxDQUFDLE9BQU87Q0FDckMsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXBwLCBSZW1vdmFsUG9saWN5LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2Nkayc7XG5pbXBvcnQgeyBCdWNrZXQgfSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ2F3cy1jZGstczMnKTtcblxuLy8gVGVzdCBhIGxpZmVjeWNsZSBydWxlIHdpdGggYW4gZXhwaXJhdGlvbiBEQVRFXG5uZXcgQnVja2V0KHN0YWNrLCAnTXlCdWNrZXQnLCB7XG4gIGxpZmVjeWNsZVJ1bGVzOiBbe1xuICAgIGV4cGlyYXRpb25EYXRlOiBuZXcgRGF0ZSgnMjAxOS0xMC0wMScpXG4gIH1dLFxuICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRlc3Ryb3lcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==