"""
    Lookup/Ibis web service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.2
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.lookup_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.lookup_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.lookup_client.model.group_all_groups200_response import GroupAllGroups200Response
from identitylib.lookup_client.model.group_all_groups_default_response import GroupAllGroupsDefaultResponse
from identitylib.lookup_client.model.group_get_cancelled_members200_response import GroupGetCancelledMembers200Response
from identitylib.lookup_client.model.group_get_group200_response import GroupGetGroup200Response
from identitylib.lookup_client.model.group_search_count200_response import GroupSearchCount200Response


class GroupApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.group_all_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GroupAllGroups200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/all-groups',
                'operation_id': 'group_all_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'include_cancelled',
                    'fetch',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'include_cancelled':
                        (bool,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'include_cancelled': 'includeCancelled',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'include_cancelled': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_get_cancelled_members_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/{groupid}/cancelled-members',
                'operation_id': 'group_get_cancelled_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'groupid',
                    'fetch',
                ],
                'required': [
                    'groupid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'groupid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'groupid': 'groupid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'groupid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_get_direct_members_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/{groupid}/direct-members',
                'operation_id': 'group_get_direct_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'groupid',
                    'fetch',
                ],
                'required': [
                    'groupid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'groupid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'groupid': 'groupid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'groupid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_get_group_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetGroup200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/{groupid}',
                'operation_id': 'group_get_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'groupid',
                    'fetch',
                ],
                'required': [
                    'groupid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'groupid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'groupid': 'groupid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'groupid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_get_members_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/{groupid}/members',
                'operation_id': 'group_get_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'groupid',
                    'fetch',
                ],
                'required': [
                    'groupid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'groupid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'groupid': 'groupid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'groupid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_list_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GroupAllGroups200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/list',
                'operation_id': 'group_list_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'groupids',
                    'fetch',
                ],
                'required': [
                    'groupids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'groupids':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'groupids': 'groupids',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'groupids': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_modified_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GroupAllGroups200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/modified-groups',
                'operation_id': 'group_modified_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'min_tx_id',
                    'max_tx_id',
                    'groupids',
                    'include_cancelled',
                    'membership_changes',
                    'fetch',
                ],
                'required': [
                    'min_tx_id',
                    'max_tx_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'min_tx_id':
                        (int,),
                    'max_tx_id':
                        (int,),
                    'groupids':
                        (str,),
                    'include_cancelled':
                        (bool,),
                    'membership_changes':
                        (bool,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'min_tx_id': 'minTxId',
                    'max_tx_id': 'maxTxId',
                    'groupids': 'groupids',
                    'include_cancelled': 'includeCancelled',
                    'membership_changes': 'membershipChanges',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'min_tx_id': 'query',
                    'max_tx_id': 'query',
                    'groupids': 'query',
                    'include_cancelled': 'query',
                    'membership_changes': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_search_endpoint = _Endpoint(
            settings={
                'response_type': (GroupAllGroups200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/search',
                'operation_id': 'group_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query',
                    'approx_matches',
                    'include_cancelled',
                    'offset',
                    'limit',
                    'order_by',
                    'fetch',
                ],
                'required': [
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'approx_matches':
                        (bool,),
                    'include_cancelled':
                        (bool,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'order_by':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'query': 'query',
                    'approx_matches': 'approxMatches',
                    'include_cancelled': 'includeCancelled',
                    'offset': 'offset',
                    'limit': 'limit',
                    'order_by': 'orderBy',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'query': 'query',
                    'approx_matches': 'query',
                    'include_cancelled': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'order_by': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.group_search_count_endpoint = _Endpoint(
            settings={
                'response_type': (GroupSearchCount200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/group/search-count',
                'operation_id': 'group_search_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query',
                    'approx_matches',
                    'include_cancelled',
                ],
                'required': [
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'approx_matches':
                        (bool,),
                    'include_cancelled':
                        (bool,),
                },
                'attribute_map': {
                    'query': 'query',
                    'approx_matches': 'approxMatches',
                    'include_cancelled': 'includeCancelled',
                },
                'location_map': {
                    'query': 'query',
                    'approx_matches': 'query',
                    'include_cancelled': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def group_all_groups(
        self,
        **kwargs
    ):
        """Return a list of all groups.  # noqa: E501

        Return a list of all groups.  By default, only a few basic details about each group are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_all_groups(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            include_cancelled (bool): Whether or not to include cancelled groups. By default, only live groups are returned.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupAllGroups200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.group_all_groups_endpoint.call_with_http_info(**kwargs)

    def group_get_cancelled_members(
        self,
        groupid,
        **kwargs
    ):
        """Get all the cancelled members of the specified group, including cancelled members of groups included by the group, and groups included by those groups, and so on.  # noqa: E501

        Get all the cancelled members of the specified group, including cancelled members of groups included by the group, and groups included by those groups, and so on.  By default, only a few basic details about each member are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each person.  NOTE: This method returns only cancelled people. It does not include people who were removed from the group. Cancelled people are no longer considered to be current staff, students or accredited visitors, and are no longer regarded as belonging to any groups or institutions. The list returned here reflects their group memberships just before they were cancelled, and so is out-of-date data that should be used with caution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_get_cancelled_members(groupid, async_req=True)
        >>> result = thread.get()

        Args:
            groupid (str): The ID or name of the group.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch for each person.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['groupid'] = \
            groupid
        return self.group_get_cancelled_members_endpoint.call_with_http_info(**kwargs)

    def group_get_direct_members(
        self,
        groupid,
        **kwargs
    ):
        """Get the direct members of the specified group, not including members included via groups included by the group.  # noqa: E501

        Get the direct members of the specified group, not including members included via groups included by the group.  By default, only a few basic details about each member are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each person.  NOTE: This method will not include cancelled people.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_get_direct_members(groupid, async_req=True)
        >>> result = thread.get()

        Args:
            groupid (str): The ID or name of the group.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch for each person.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['groupid'] = \
            groupid
        return self.group_get_direct_members_endpoint.call_with_http_info(**kwargs)

    def group_get_group(
        self,
        groupid,
        **kwargs
    ):
        """Get the group with the specified ID or name.  # noqa: E501

        Get the group with the specified ID or name.  By default, only a few basic details about the group are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of the group.  NOTE: The group returned may be a cancelled group. It is the caller's repsonsibility to check its cancelled flag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_get_group(groupid, async_req=True)
        >>> result = thread.get()

        Args:
            groupid (str): The ID or name of the group to fetch. This may be either the numeric ID or the short hyphenated group name (for example `\"100656\"` or `\"cs-editors\"`).

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetGroup200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['groupid'] = \
            groupid
        return self.group_get_group_endpoint.call_with_http_info(**kwargs)

    def group_get_members(
        self,
        groupid,
        **kwargs
    ):
        """Get all the members of the specified group, including members of groups included by the group, and groups included by those groups, and so on.  # noqa: E501

        Get all the members of the specified group, including members of groups included by the group, and groups included by those groups, and so on.  By default, only a few basic details about each member are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each person.  NOTE: This method will not include cancelled people.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_get_members(groupid, async_req=True)
        >>> result = thread.get()

        Args:
            groupid (str): The ID or name of the group.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch for each person.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['groupid'] = \
            groupid
        return self.group_get_members_endpoint.call_with_http_info(**kwargs)

    def group_list_groups(
        self,
        groupids,
        **kwargs
    ):
        """Get the groups with the specified IDs or names.  # noqa: E501

        Get the groups with the specified IDs or names.  By default, only a few basic details about each group are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  The results are sorted by groupid.  NOTE: The URL path length is limited to around 8000 characters, which limits the number of groups that this method can fetch. Group IDs are currently 6 characters long, and must be comma separated and URL encoded, which limits this method to around 800 groups by ID, but probably fewer by name, depending on the group name lengths.  NOTE: The groups returned may include cancelled groups. It is the caller's repsonsibility to check their cancelled flags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_list_groups(groupids, async_req=True)
        >>> result = thread.get()

        Args:
            groupids (str): A comma-separated list of group IDs or group names (may be a mix of both).

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupAllGroups200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['groupids'] = \
            groupids
        return self.group_list_groups_endpoint.call_with_http_info(**kwargs)

    def group_modified_groups(
        self,
        min_tx_id,
        max_tx_id,
        **kwargs
    ):
        """Find all groups modified between the specified pair of transactions.  # noqa: E501

        Find all groups modified between the specified pair of transactions.  The transaction IDs specified should be the IDs from two different requests for the last (most recent) transaction ID, made at different times, that returned different values, indicating that some Lookup data was modified in the period between the two requests. This method then determines which (if any) groups were affected.  By default, only a few basic details about each group are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  NOTE: All data returned reflects the latest available data about each group. It is not possible to query for old data, or more detailed information about the specific changes made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_modified_groups(min_tx_id, max_tx_id, async_req=True)
        >>> result = thread.get()

        Args:
            min_tx_id (int): Include modifications made in transactions after (but not including) this one.
            max_tx_id (int): Include modifications made in transactions up to and including this one.

        Keyword Args:
            groupids (str): Only include groups with IDs or names in this list. By default, all modified groups will be included.. [optional]
            include_cancelled (bool): Include cancelled groups. By default, cancelled groups are excluded.. [optional]
            membership_changes (bool): Include groups whose members have changed. By default, changes to group memberships are not taken into consideration.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupAllGroups200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['min_tx_id'] = \
            min_tx_id
        kwargs['max_tx_id'] = \
            max_tx_id
        return self.group_modified_groups_endpoint.call_with_http_info(**kwargs)

    def group_search(
        self,
        query,
        **kwargs
    ):
        """Search for groups using a free text query string.  # noqa: E501

        Search for groups using a free text query string. This is the same search function that is used in the Lookup web application.  By default, only a few basic details about each group are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  NOTE: If the query string starts with the prefix `\"group:\"`, it is treated as an [LQL query](/lql), allowing more advanced searches. An LQL query will ignore the `approxMatches` parameter, but it will respect the value of `includeCancelled`. In addition, an LQL query will ignore the `orderBy` parameter, since LQL queries always return results in ID order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_search(query, async_req=True)
        >>> result = thread.get()

        Args:
            query (str): The search string.

        Keyword Args:
            approx_matches (bool): Flag to enable more approximate matching in the search, causing more results to be returned. Defaults to `false`. This is ignored for LQL queries.. [optional]
            include_cancelled (bool): Flag to allow cancelled groups to be included. Defaults to `false`.. [optional]
            offset (int): The number of results to skip at the start of the search. Defaults to 0.. [optional]
            limit (int): The maximum number of results to return. Defaults to 100.. [optional]
            order_by (str): The order in which to list the results. This may be `\"groupid\"`, `\"name\"` (the default for non-LQL queries) or `\"title\"`. This is ignored for LQL queries, which always return results in groupid order.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupAllGroups200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['query'] = \
            query
        return self.group_search_endpoint.call_with_http_info(**kwargs)

    def group_search_count(
        self,
        query,
        **kwargs
    ):
        """Count the number of groups that would be returned by a search using a free text query string.  # noqa: E501

        Count the number of groups that would be returned by a search using a free text query string.  NOTE: If the query string starts with the prefix `\"group:\"`, it is treated as an [LQL query](/lql), allowing more advanced searches. An LQL query will ignore the `approxMatches` parameter, but it will respect the value of `includeCancelled`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.group_search_count(query, async_req=True)
        >>> result = thread.get()

        Args:
            query (str): The search string.

        Keyword Args:
            approx_matches (bool): Flag to enable more approximate matching in the search, causing more results to be returned. Defaults to `false`. This is ignored for LQL queries.. [optional]
            include_cancelled (bool): Flag to allow cancelled groups to be included. Defaults to `false`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupSearchCount200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['query'] = \
            query
        return self.group_search_count_endpoint.call_with_http_info(**kwargs)

