"""
    Lookup/Ibis web service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.2
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.lookup_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.lookup_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.lookup_client.model.group_all_groups200_response import GroupAllGroups200Response
from identitylib.lookup_client.model.group_all_groups_default_response import GroupAllGroupsDefaultResponse
from identitylib.lookup_client.model.group_get_cancelled_members200_response import GroupGetCancelledMembers200Response
from identitylib.lookup_client.model.group_search_count200_response import GroupSearchCount200Response
from identitylib.lookup_client.model.institution_all_attribute_schemes200_response import InstitutionAllAttributeSchemes200Response
from identitylib.lookup_client.model.institution_all_insts200_response import InstitutionAllInsts200Response
from identitylib.lookup_client.model.institution_get_attribute200_response import InstitutionGetAttribute200Response
from identitylib.lookup_client.model.institution_get_attributes200_response import InstitutionGetAttributes200Response
from identitylib.lookup_client.model.person_get_person200_response import PersonGetPerson200Response
from identitylib.lookup_client.model.person_is_member_of_group200_response import PersonIsMemberOfGroup200Response


class PersonApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.person_all_attribute_schemes_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllAttributeSchemes200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/all-attr-schemes',
                'operation_id': 'person_all_attribute_schemes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_all_people_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/all-people',
                'operation_id': 'person_all_people',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'include_cancelled',
                    'identifier',
                    'limit',
                    'fetch',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'include_cancelled':
                        (bool,),
                    'identifier':
                        (str,),
                    'limit':
                        (int,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'include_cancelled': 'includeCancelled',
                    'identifier': 'identifier',
                    'limit': 'limit',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'include_cancelled': 'query',
                    'identifier': 'query',
                    'limit': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_get_attribute_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionGetAttribute200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/{attrid}',
                'operation_id': 'person_get_attribute',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'attrid',
                ],
                'required': [
                    'scheme',
                    'identifier',
                    'attrid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'attrid':
                        (int,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'attrid': 'attrid',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'attrid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_get_attributes_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionGetAttributes200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/get-attributes',
                'operation_id': 'person_get_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'attrs',
                ],
                'required': [
                    'scheme',
                    'identifier',
                    'attrs',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'attrs':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'attrs': 'attrs',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'attrs': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_get_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GroupAllGroups200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/groups',
                'operation_id': 'person_get_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'fetch',
                ],
                'required': [
                    'scheme',
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_get_insts_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllInsts200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/insts',
                'operation_id': 'person_get_insts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'fetch',
                ],
                'required': [
                    'scheme',
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_get_managed_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GroupAllGroups200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/manages-groups',
                'operation_id': 'person_get_managed_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'fetch',
                ],
                'required': [
                    'scheme',
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_get_managed_insts_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllInsts200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/manages-insts',
                'operation_id': 'person_get_managed_insts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'fetch',
                ],
                'required': [
                    'scheme',
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_get_person_endpoint = _Endpoint(
            settings={
                'response_type': (PersonGetPerson200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}',
                'operation_id': 'person_get_person',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'fetch',
                ],
                'required': [
                    'scheme',
                    'identifier',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_is_member_of_group_endpoint = _Endpoint(
            settings={
                'response_type': (PersonIsMemberOfGroup200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/is-member-of-group/{groupid}',
                'operation_id': 'person_is_member_of_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'groupid',
                ],
                'required': [
                    'scheme',
                    'identifier',
                    'groupid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'groupid':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'groupid': 'groupid',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'groupid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_is_member_of_inst_endpoint = _Endpoint(
            settings={
                'response_type': (PersonIsMemberOfGroup200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/{scheme}/{identifier}/is-member-of-inst/{instid}',
                'operation_id': 'person_is_member_of_inst',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'scheme',
                    'identifier',
                    'instid',
                ],
                'required': [
                    'scheme',
                    'identifier',
                    'instid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'scheme':
                        (str,),
                    'identifier':
                        (str,),
                    'instid':
                        (str,),
                },
                'attribute_map': {
                    'scheme': 'scheme',
                    'identifier': 'identifier',
                    'instid': 'instid',
                },
                'location_map': {
                    'scheme': 'path',
                    'identifier': 'path',
                    'instid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_list_people_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/list',
                'operation_id': 'person_list_people',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'crsids',
                    'fetch',
                ],
                'required': [
                    'crsids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'crsids':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'crsids': 'crsids',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'crsids': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_modified_people_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/modified-people',
                'operation_id': 'person_modified_people',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'min_tx_id',
                    'max_tx_id',
                    'crsids',
                    'include_cancelled',
                    'membership_changes',
                    'inst_name_changes',
                    'fetch',
                ],
                'required': [
                    'min_tx_id',
                    'max_tx_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'min_tx_id':
                        (int,),
                    'max_tx_id':
                        (int,),
                    'crsids':
                        (str,),
                    'include_cancelled':
                        (bool,),
                    'membership_changes':
                        (bool,),
                    'inst_name_changes':
                        (bool,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'min_tx_id': 'minTxId',
                    'max_tx_id': 'maxTxId',
                    'crsids': 'crsids',
                    'include_cancelled': 'includeCancelled',
                    'membership_changes': 'membershipChanges',
                    'inst_name_changes': 'instNameChanges',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'min_tx_id': 'query',
                    'max_tx_id': 'query',
                    'crsids': 'query',
                    'include_cancelled': 'query',
                    'membership_changes': 'query',
                    'inst_name_changes': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_search_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/search',
                'operation_id': 'person_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query',
                    'approx_matches',
                    'include_cancelled',
                    'mis_status',
                    'attributes',
                    'offset',
                    'limit',
                    'order_by',
                    'fetch',
                ],
                'required': [
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'approx_matches':
                        (bool,),
                    'include_cancelled':
                        (bool,),
                    'mis_status':
                        (str,),
                    'attributes':
                        (str,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'order_by':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'query': 'query',
                    'approx_matches': 'approxMatches',
                    'include_cancelled': 'includeCancelled',
                    'mis_status': 'misStatus',
                    'attributes': 'attributes',
                    'offset': 'offset',
                    'limit': 'limit',
                    'order_by': 'orderBy',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'query': 'query',
                    'approx_matches': 'query',
                    'include_cancelled': 'query',
                    'mis_status': 'query',
                    'attributes': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'order_by': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.person_search_count_endpoint = _Endpoint(
            settings={
                'response_type': (GroupSearchCount200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/person/search-count',
                'operation_id': 'person_search_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query',
                    'approx_matches',
                    'include_cancelled',
                    'mis_status',
                    'attributes',
                ],
                'required': [
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'approx_matches':
                        (bool,),
                    'include_cancelled':
                        (bool,),
                    'mis_status':
                        (str,),
                    'attributes':
                        (str,),
                },
                'attribute_map': {
                    'query': 'query',
                    'approx_matches': 'approxMatches',
                    'include_cancelled': 'includeCancelled',
                    'mis_status': 'misStatus',
                    'attributes': 'attributes',
                },
                'location_map': {
                    'query': 'query',
                    'approx_matches': 'query',
                    'include_cancelled': 'query',
                    'mis_status': 'query',
                    'attributes': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def person_all_attribute_schemes(
        self,
        **kwargs
    ):
        """Return a list of all the person attribute schemes available.  # noqa: E501

        Return a list of all the person attribute schemes available. The `schemeid` values of these schemes may be used in the `fetch` parameter of other methods that return people.  NOTE: Some of these attribute schemes are not currently used (no people have attribute values in the scheme). These schemes are reserved for possible future use.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_all_attribute_schemes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllAttributeSchemes200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.person_all_attribute_schemes_endpoint.call_with_http_info(**kwargs)

    def person_all_people(
        self,
        **kwargs
    ):
        """Return a list of all people (in batches).  # noqa: E501

        Return a list of all people (in batches).  The results are sorted by identifier, starting with the first person after the person with the specified identifier. Thus, to iterate over all people, pass a `null` identifier to get the first batch of people, then pass the last identifier from the previous batch to get the next batch, and repeat until no more people are returned.  By default, only a few basic details about each person are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_all_people(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            include_cancelled (bool): Flag to allow cancelled people to be included (people who are no longer members of the University). Defaults to `false`.. [optional]
            identifier (str): The identifier (CRSid) of the person to start after, or `null` to start from the first person.. [optional]
            limit (int): The maximum number of people to return. Defaults to 100.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.person_all_people_endpoint.call_with_http_info(**kwargs)

    def person_get_attribute(
        self,
        scheme,
        identifier,
        attrid,
        **kwargs
    ):
        """Get a specific attribute of a person.  # noqa: E501

        Get a specific attribute of a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_get_attribute(scheme, identifier, attrid, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).
            attrid (int): The ID of the attribute to fetch.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionGetAttribute200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        kwargs['attrid'] = \
            attrid
        return self.person_get_attribute_endpoint.call_with_http_info(**kwargs)

    def person_get_attributes(
        self,
        scheme,
        identifier,
        attrs,
        **kwargs
    ):
        """Get one or more (possibly multi-valued) attributes of a person.  # noqa: E501

        Get one or more (possibly multi-valued) attributes of a person. The returned attributes are sorted by attribute scheme precedence and then attribute precedence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_get_attributes(scheme, identifier, attrs, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).
            attrs (str): The attribute scheme(s) to fetch. This may include any number of the attributes or pseudo-attributes, but it may not include references or attribute chains (see the documentation for the `fetch` parameter in this class).

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionGetAttributes200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        kwargs['attrs'] = \
            attrs
        return self.person_get_attributes_endpoint.call_with_http_info(**kwargs)

    def person_get_groups(
        self,
        scheme,
        identifier,
        **kwargs
    ):
        """Get all the groups to which the specified person belongs, including indirect group memberships, via groups that include other groups.  # noqa: E501

        Get all the groups to which the specified person belongs, including indirect group memberships, via groups that include other groups. The returned list of groups is sorted by groupid.  Note that some group memberships may not be visible to you. This method will only return those group memberships that you have permission to see.  By default, only a few basic details about each group are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each group.  NOTE: This method will not include cancelled groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_get_groups(scheme, identifier, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupAllGroups200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        return self.person_get_groups_endpoint.call_with_http_info(**kwargs)

    def person_get_insts(
        self,
        scheme,
        identifier,
        **kwargs
    ):
        """Get all the institutions to which the specified person belongs.  # noqa: E501

        Get all the institutions to which the specified person belongs. The returned list of institutions is sorted by name.  By default, only a few basic details about each institution are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each institution.  NOTE: This method will not include cancelled institutions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_get_insts(scheme, identifier, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllInsts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        return self.person_get_insts_endpoint.call_with_http_info(**kwargs)

    def person_get_managed_groups(
        self,
        scheme,
        identifier,
        **kwargs
    ):
        """Get all the groups that the specified person has persmission to edit.  # noqa: E501

        Get all the groups that the specified person has persmission to edit. The returned list of groups is sorted by groupid.  Note that some group memberships may not be visible to you. This method will only include groups for which you have persmission to see the applicable manager group memberships.  By default, only a few basic details about each group are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each group.  NOTE: This method will not include cancelled groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_get_managed_groups(scheme, identifier, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupAllGroups200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        return self.person_get_managed_groups_endpoint.call_with_http_info(**kwargs)

    def person_get_managed_insts(
        self,
        scheme,
        identifier,
        **kwargs
    ):
        """Get all the institutions that the specified person has permission to edit.  # noqa: E501

        Get all the institutions that the specified person has permission to edit. The returned list of institutions is sorted by name.  Note that some group memberships may not be visible to you. This method will only include institutions for which you have permission to see the applicable editor group memberships.  By default, only a few basic details about each institution are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each institution.  NOTE: This method will not include cancelled institutions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_get_managed_insts(scheme, identifier, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllInsts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        return self.person_get_managed_insts_endpoint.call_with_http_info(**kwargs)

    def person_get_person(
        self,
        scheme,
        identifier,
        **kwargs
    ):
        """Get the person with the specified identifier.  # noqa: E501

        Get the person with the specified identifier.  By default, only a few basic details about the person are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of the person.  NOTE: The person returned may be a cancelled person. It is the caller's repsonsibility to check its cancelled flag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_get_person(scheme, identifier, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person to fetch (typically their CRSid).

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PersonGetPerson200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        return self.person_get_person_endpoint.call_with_http_info(**kwargs)

    def person_is_member_of_group(
        self,
        scheme,
        identifier,
        groupid,
        **kwargs
    ):
        """Test if the specified person is a member of the specified group.  # noqa: E501

        Test if the specified person is a member of the specified group.  NOTE: This may be used with cancelled people and groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_is_member_of_group(scheme, identifier, groupid, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).
            groupid (str): The ID or name of the group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PersonIsMemberOfGroup200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        kwargs['groupid'] = \
            groupid
        return self.person_is_member_of_group_endpoint.call_with_http_info(**kwargs)

    def person_is_member_of_inst(
        self,
        scheme,
        identifier,
        instid,
        **kwargs
    ):
        """Test if the specified person is a member of the specified institution.  # noqa: E501

        Test if the specified person is a member of the specified institution.  NOTE: This may be used with cancelled people and institutions, but it will not include cancelled membership groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_is_member_of_inst(scheme, identifier, instid, async_req=True)
        >>> result = thread.get()

        Args:
            scheme (str): The person identifier scheme. Typically this should be `\"crsid\"`, but other identifier schemes may be available in the future, such as `\"usn\"` or `\"staffNumber\"`.
            identifier (str): The identifier of the person (typically their CRSid).
            instid (str): The ID of the institution.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PersonIsMemberOfGroup200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['scheme'] = \
            scheme
        kwargs['identifier'] = \
            identifier
        kwargs['instid'] = \
            instid
        return self.person_is_member_of_inst_endpoint.call_with_http_info(**kwargs)

    def person_list_people(
        self,
        crsids,
        **kwargs
    ):
        """Get the people with the specified identifiers (typically CRSids).  # noqa: E501

        Get the people with the specified identifiers (typically CRSids).  Each identifier may be either a CRSid, or an identifier from another identifier scheme, prefixed with that scheme's name and a slash. For example `\"mug99\"` or `\"usn/123456789\"`.  By default, only a few basic details about each person are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  The results are sorted by identifier scheme and value.  NOTE: The number of people that may be fetched in a single call is limited by the URL path length limit (around 8000 characters). A CRSid is up to 7 characters long, and other identifiers are typically longer, since they must also include the identifier scheme. Thus the number of people that this method may fetch is typically limited to a few hundred.  NOTE: The people returned may include cancelled people. It is the caller's repsonsibility to check their cancelled flags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_list_people(crsids, async_req=True)
        >>> result = thread.get()

        Args:
            crsids (str): A comma-separated list of identifiers.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['crsids'] = \
            crsids
        return self.person_list_people_endpoint.call_with_http_info(**kwargs)

    def person_modified_people(
        self,
        min_tx_id,
        max_tx_id,
        **kwargs
    ):
        """Find all people modified between the specified pair of transactions.  # noqa: E501

        Find all people modified between the specified pair of transactions.  The transaction IDs specified should be the IDs from two different requests for the last (most recent) transaction ID, made at different times, that returned different values, indicating that some Lookup data was modified in the period between the two requests. This method then determines which (if any) people were affected.  By default, only a few basic details about each person are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  NOTE: All data returned reflects the latest available data about each person. It is not possible to query for old data, or more detailed information about the specific changes made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_modified_people(min_tx_id, max_tx_id, async_req=True)
        >>> result = thread.get()

        Args:
            min_tx_id (int): Include modifications made in transactions after (but not including) this one.
            max_tx_id (int): Include modifications made in transactions up to and including this one.

        Keyword Args:
            crsids (str): Only include people with identifiers in this list. By default, all modified people will be included.. [optional]
            include_cancelled (bool): Include cancelled people (people who are no longer members of the University). By default, cancelled people are excluded.. [optional]
            membership_changes (bool): Include people whose group or institutional memberships have changed. By default, only people whose attributes have been directly modified are included.. [optional]
            inst_name_changes (bool): Include people who are members of instituions whose names have changed. This will also cause people whose group or institutional memberships have changed to be included. By default, changes to institution names do not propagate to people.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['min_tx_id'] = \
            min_tx_id
        kwargs['max_tx_id'] = \
            max_tx_id
        return self.person_modified_people_endpoint.call_with_http_info(**kwargs)

    def person_search(
        self,
        query,
        **kwargs
    ):
        """Search for people using a free text query string.  # noqa: E501

        Search for people using a free text query string. This is the same search function that is used in the Lookup web application.  By default, only a few basic details about each person are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  NOTE: If the query string starts with the prefix `\"person:\"`, it is treated as an [LQL query](/lql), allowing more advanced searches. An LQL query will ignore the `approxMatches` and `attributes` parameters, but it will respect the values of `includeCancelled` and `misStatus`. In addition, an LQL query will ignore the `orderBy` parameter, since LQL queries always return results in ID order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_search(query, async_req=True)
        >>> result = thread.get()

        Args:
            query (str): The search string.

        Keyword Args:
            approx_matches (bool): Flag to enable more approximate matching in the search, causing more results to be returned. Defaults to `false`. This is ignored for LQL queries.. [optional]
            include_cancelled (bool): Flag to allow cancelled people to be included (people who are no longer members of the University). Defaults to `false`.. [optional]
            mis_status (str): The type of people to search for. This may be  * `\"staff\"` - only include people whose MIS status is   `\"\"` (empty string), `\"staff\"`, or   `\"staff,student\"`.  * `\"student\"` - only include people whose MIS status is set to   `\"student\"` or `\"staff,student\"`.  Otherwise all matching people will be included (the default). Note that the `\"staff\"` and `\"student\"` options are not mutually exclusive.. [optional]
            attributes (str): A comma-separated list of attributes to consider when searching. If this is `null` (the default) then all attribute schemes marked as searchable will be included. This is ignored for LQL queries.. [optional]
            offset (int): The number of results to skip at the start of the search. Defaults to 0.. [optional]
            limit (int): The maximum number of results to return. Defaults to 100.. [optional]
            order_by (str): The order in which to list the results. This may be either `\"identifier\"` or `\"surname\"` (the default for non-LQL queries). This is ignored for LQL queries, which always return results in identifier order.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['query'] = \
            query
        return self.person_search_endpoint.call_with_http_info(**kwargs)

    def person_search_count(
        self,
        query,
        **kwargs
    ):
        """Count the number of people that would be returned by a search using a free text query string.  # noqa: E501

        Count the number of people that would be returned by a search using a free text query string.  NOTE: If the query string starts with the prefix `\"person:\"`, it is treated as an [LQL query](/lql), allowing more advanced searches. An LQL query will ignore the `approxMatches` and `attributes` parameters, but it will respect the values of `includeCancelled` and `misStatus`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_search_count(query, async_req=True)
        >>> result = thread.get()

        Args:
            query (str): The search string.

        Keyword Args:
            approx_matches (bool): Flag to enable more approximate matching in the search, causing more results to be returned. Defaults to `false`. This is ignored for LQL queries.. [optional]
            include_cancelled (bool): Flag to allow cancelled people to be included (people who are no longer members of the University). Defaults to `false`.. [optional]
            mis_status (str): The type of people to search for. This may be  * `\"staff\"` - only include people whose MIS status is   `\"\"` (empty string), `\"staff\"`, or   `\"staff,student\"`.  * `\"student\"` - only include people whose MIS status is set to   `\"student\"` or `\"staff,student\"`.  Otherwise all matching people will be included (the default). Note that the `\"staff\"` and `\"student\"` options are not mutually exclusive.. [optional]
            attributes (str): A comma-separated list of attributes to consider when searching. If this is `null` (the default) then all attribute schemes marked as searchable will be included. This is ignored for LQL queries.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupSearchCount200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['query'] = \
            query
        return self.person_search_count_endpoint.call_with_http_info(**kwargs)

