/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.common.util;

import com.healthmarketscience.common.util.UnreachableStatementException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionFactory<RetType, ExType extends Throwable> {
    private final Class<? extends RetType> _requiredType;
    private final Class<? extends ExType> _exType;
    private final String _constructorMethodName;
    private final Class<?>[] _constructorParamTypes;
    private final String _configureMethodName;
    private final Class<?>[] _configureParamTypes;

    public ReflectionFactory(Class<? extends RetType> requiredType, Class<? extends ExType> exType, Class<?> ... constructorParamTypes) {
        this(requiredType, exType, (String)null, constructorParamTypes, (String)null, (Class<?>[])null);
    }

    public ReflectionFactory(Class<? extends RetType> requiredType, Class<? extends ExType> exType, String configureMethodName) {
        this(requiredType, exType, null, null, configureMethodName, null);
    }

    public ReflectionFactory(Class<? extends RetType> requiredType, Class<? extends ExType> exType, Class<?>[] constructorParamTypes, String configureMethodName, Class<?>[] configureParamTypes) {
        this(requiredType, exType, null, constructorParamTypes, configureMethodName, configureParamTypes);
    }

    public ReflectionFactory(Class<? extends RetType> requiredType, Class<? extends ExType> exType, String constructorMethodName, Class<?>[] constructorParamTypes, String configureMethodName, Class<?>[] configureParamTypes) {
        this._requiredType = requiredType;
        this._exType = exType;
        this._constructorMethodName = constructorMethodName;
        this._constructorParamTypes = constructorParamTypes;
        this._configureMethodName = configureMethodName;
        this._configureParamTypes = configureParamTypes;
    }

    protected Class<? extends RetType> getRequiredType() {
        return this._requiredType;
    }

    protected Class<? extends ExType> getExceptionType() {
        return this._exType;
    }

    protected String getConstructorMethodName() {
        return this._constructorMethodName;
    }

    protected Class<?>[] getConstructorParamTypes() {
        return this._constructorParamTypes;
    }

    protected String getConfigureMethodName() {
        return this._configureMethodName;
    }

    protected Class<?>[] getConfigureParamTypes() {
        return this._configureParamTypes;
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected List<String> expandType(String typeName) throws ExType {
        return Collections.singletonList(typeName);
    }

    public RetType create(String typeName, Object ... constructorParams) throws ExType {
        return this.create(typeName, constructorParams, null);
    }

    public RetType create(String typeName, Object[] constructorParams, Object[] configureParams) throws ExType {
        if (this.getConfigureMethodName() == null && !ArrayUtils.isEmpty(configureParams)) {
            throw new IllegalArgumentException("configure params given but no configure method defined");
        }
        try {
            RetType obj;
            List<String> expandedTypeNames = this.expandType(typeName);
            Class<?> tmpClazz = null;
            for (String expandedTypeName : expandedTypeNames) {
                try {
                    tmpClazz = Class.forName(expandedTypeName, true, this.getClassLoader());
                    typeName = expandedTypeName;
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
            if (tmpClazz == null) {
                this.throwException("failed to find type(s) " + expandedTypeNames, null);
                throw new UnreachableStatementException();
            }
            Class<RetType> objClazz = tmpClazz.asSubclass(this.getRequiredType());
            RetType RetType = obj = this.getConstructorMethodName() == null ? objClazz.getConstructor(this.getConstructorParamTypes()).newInstance(constructorParams) : this.getRequiredType().cast(objClazz.getMethod(this.getConstructorMethodName(), this.getConstructorParamTypes()).invoke(null, constructorParams));
            if (this.getConfigureMethodName() != null) {
                obj.getClass().getMethod(this.getConfigureMethodName(), this.getConfigureParamTypes()).invoke(obj, configureParams);
            }
            return obj;
        }
        catch (Exception e) {
            this.throwException("failed instantiating type " + typeName, e);
            throw new UnreachableStatementException(e);
        }
    }

    protected void throwException(String msg, Throwable t) throws ExType {
        if (this.getExceptionType().isInstance(t)) {
            throw (Throwable)this._exType.cast(t);
        }
        Throwable newEx = null;
        try {
            newEx = (Throwable)this.getExceptionType().getConstructor(String.class, Throwable.class).newInstance(msg, t);
        }
        catch (Exception e) {
            throw new RuntimeException("failed instantiating exception " + this.getExceptionType(), e);
        }
        throw newEx;
    }
}

