/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.bayesian;

import org.linqs.psl.config.Options;
import org.linqs.psl.util.FloatMatrix;

public abstract class GaussianProcessKernel {
    protected final FloatMatrix scalingWeights;
    protected final boolean weighted;
    protected final float scale;
    protected final float relDep;
    protected final Space space;

    public GaussianProcessKernel() {
        this(null, false);
    }

    public GaussianProcessKernel(float[] scalingWeights) {
        this(FloatMatrix.columnVector(scalingWeights), true);
    }

    private GaussianProcessKernel(FloatMatrix scalingWeights, boolean weighted) {
        this.scalingWeights = scalingWeights;
        this.weighted = weighted;
        this.scale = Options.WLA_GPP_KERNEL_SCALE.getFloat();
        this.relDep = Options.WLA_GPP_KERNEL_REL_DEP.getFloat();
        this.space = Space.valueOf(Options.WLA_GPP_KERNEL_SPACE.getString().toUpperCase());
    }

    public abstract float kernel(FloatMatrix var1, FloatMatrix var2);

    public float kernel(float[] point1, float[] point2, float[] buffer1, float[] buffer2, FloatMatrix matrixShell1, FloatMatrix matrixShell2) {
        assert (point1.length == point2.length);
        assert (buffer1.length == buffer2.length);
        assert (point1.length == buffer1.length);
        for (int i = 0; i < point1.length; ++i) {
            buffer1[i] = point1[i];
            buffer2[i] = point2[i];
        }
        matrixShell1.assume(buffer1, buffer1.length, 1);
        matrixShell2.assume(buffer2, buffer2.length, 1);
        return this.kernel(matrixShell1, matrixShell2);
    }

    public float kernel(float[] point1, float[] point2) {
        return this.kernel(point1, point2, new float[point1.length], new float[point2.length], new FloatMatrix(), new FloatMatrix());
    }

    public static enum Space {
        SS,
        OS,
        LS;

    }
}

