/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.util.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreMetadata {
    private static final Logger log = LoggerFactory.getLogger(DataStoreMetadata.class);
    public static final String METADATA_TABLENAME = "pslmetadata";
    public static final String ANONYMOUS_PARTITION_PREFIX = "AnonymousPartition_";
    public static final String PARTITION_NAMESPACE = "partition";
    public static final String NAME_KEY = "name";
    private RDBMSDataStore dataStore;
    private Map<String, Integer> partitions;
    private int nextPartition;

    public DataStoreMetadata(RDBMSDataStore dataStore) {
        this.dataStore = dataStore;
        this.initialize();
        this.partitions = this.fetchPartitions();
        this.nextPartition = 1;
        for (Integer partition : this.partitions.values()) {
            if (partition < this.nextPartition) continue;
            this.nextPartition = partition + 1;
        }
    }

    private void initialize() {
        if (this.exists()) {
            return;
        }
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("CREATE TABLE IF NOT EXISTS pslmetadata (");
        sql.add("  namespace VARCHAR(255),");
        sql.add("  keytype VARCHAR(255),");
        sql.add("  keyvalue VARCHAR(255),");
        sql.add("  value VARCHAR(255),");
        sql.add("  PRIMARY KEY(namespace, keytype, keyvalue)");
        sql.add(")");
        try (Connection connection = this.dataStore.getConnection();
             PreparedStatement statement = connection.prepareStatement(ListUtils.join("\n", sql));){
            statement.execute();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error creating metadata table.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exists() {
        try (Connection connection = this.dataStore.getConnection();
             ResultSet resultSet = connection.getMetaData().getTables(null, null, METADATA_TABLENAME, null);){
            if (!resultSet.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error finding metadata table.", ex);
        }
    }

    private void addRow(String namespace, String type, String keyvalue, String val) {
        try (Connection connection = this.dataStore.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO pslmetadata VALUES(?, ?, ?, ?)");){
            statement.setString(1, namespace);
            statement.setString(2, type);
            statement.setString(3, keyvalue);
            statement.setString(4, val);
            statement.execute();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error adding row to metadata table.", ex);
        }
    }

    private String getValue(String namespace, String type, String keyvalue) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("SELECT value");
        sql.add("FROM pslmetadata");
        sql.add("WHERE");
        sql.add("  namespace = ?");
        sql.add("  AND keytype = ?");
        sql.add("  AND keyvalue = ?");
        ResultSet resultSet = null;
        try (Connection connection = this.dataStore.getConnection();
             PreparedStatement statement = connection.prepareStatement(ListUtils.join("\n", sql));){
            statement.setString(1, namespace);
            statement.setString(2, type);
            statement.setString(3, keyvalue);
            statement.execute();
            resultSet = statement.getResultSet();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error fetching value from metadata table.", ex);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private void removeRow(String namespace, String type, String keyvalue) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("DELETE");
        sql.add("FROM pslmetadata");
        sql.add("WHERE");
        sql.add("  namespace = ?");
        sql.add("  AND keytype = ?");
        sql.add("  AND keyvalue = ?");
        try (Connection connection = this.dataStore.getConnection();
             PreparedStatement statement = connection.prepareStatement(ListUtils.join("\n", sql));){
            statement.setString(1, namespace);
            statement.setString(2, type);
            statement.setString(3, keyvalue);
            statement.execute();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error removing metadata row", ex);
        }
    }

    public Map<String, String> getAllValuesByType(String namespace, String type) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("SELECT keyvalue, value");
        sql.add("FROM pslmetadata");
        sql.add("WHERE");
        sql.add("  namespace = ?");
        sql.add("  AND keytype = ?");
        ResultSet resultSet = null;
        HashMap<String, String> vals = new HashMap<String, String>();
        try (Connection connection = this.dataStore.getConnection();
             PreparedStatement statement = connection.prepareStatement(ListUtils.join("\n", sql));){
            statement.setString(1, namespace);
            statement.setString(2, type);
            statement.execute();
            resultSet = statement.getResultSet();
            while (resultSet.next()) {
                vals.put(resultSet.getString(1), resultSet.getString(2));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error retrieving metadata values", ex);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return vals;
    }

    private Map<String, Integer> fetchPartitions() {
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        Map<String, String> vals = this.getAllValuesByType(PARTITION_NAMESPACE, NAME_KEY);
        for (String name : vals.keySet()) {
            names.put(name, Integer.parseInt(vals.get(name)));
        }
        return names;
    }

    private Partition addPartition(int id, String name) {
        this.addRow(PARTITION_NAMESPACE, NAME_KEY, name, "" + id);
        return new Partition(id, name);
    }

    public Partition getPartition(String name) {
        String idString = this.getValue(PARTITION_NAMESPACE, NAME_KEY, name);
        if (idString != null) {
            return new Partition(Integer.parseInt(idString), name);
        }
        return this.addPartition(this.nextPartition++, name);
    }

    public Partition getNewPartition() {
        return this.getPartition(ANONYMOUS_PARTITION_PREFIX + this.nextPartition);
    }

    public Set<Partition> getAllPartitions() {
        HashSet<Partition> partitions = new HashSet<Partition>();
        for (Map.Entry<String, String> entry : this.getAllValuesByType(PARTITION_NAMESPACE, NAME_KEY).entrySet()) {
            partitions.add(new Partition(Integer.parseInt(entry.getValue()), entry.getKey()));
        }
        return partitions;
    }

    public void removePartition(Partition partition) {
        this.removeRow(PARTITION_NAMESPACE, NAME_KEY, partition.getName());
        this.partitions.remove(partition.getName());
    }
}

