/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics;

import org.linqs.psl.application.learning.weight.TrainingMap;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.model.predicate.StandardPredicate;

public abstract class Evaluator {
    public abstract void compute(TrainingMap var1);

    public abstract void compute(TrainingMap var1, StandardPredicate var2);

    public abstract double getRepMetric();

    public abstract boolean isHigherRepBetter();

    public double getNormalizedRepMetric() {
        double value = this.getRepMetric();
        if (!this.isHigherRepBetter()) {
            value = -value;
        }
        return value;
    }

    public abstract String getAllStats();

    public void compute(Database rvDB, Database truthDB, StandardPredicate predicate, boolean rvDBCached) {
        PersistedAtomManager atomManager = new PersistedAtomManager(rvDB, rvDBCached);
        TrainingMap map = new TrainingMap(atomManager, truthDB);
        this.compute(map, predicate);
    }

    public void compute(Database rvDB, Database truthDB, StandardPredicate predicate) {
        this.compute(rvDB, truthDB, predicate, false);
    }
}

