/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate;

import java.util.HashMap;
import java.util.Map;
import org.linqs.psl.model.term.ConstantType;

public abstract class Predicate {
    private static Map<String, Predicate> predicates = new HashMap<String, Predicate>();
    private final String name;
    private final ConstantType[] types;

    protected Predicate(String name, ConstantType[] types) {
        this(name, types, true);
    }

    protected Predicate(String name, ConstantType[] types, boolean checkName) {
        if (checkName && !name.matches("\\w+")) {
            throw new IllegalArgumentException("Predicate name must match: /\\w+/.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("All predicates must have a non-zero length name.");
        }
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("All predicates must have at least one argument.");
        }
        this.name = name.toUpperCase();
        this.types = types;
        if (predicates.containsKey(this.name)) {
            throw new RuntimeException("Predicate with name '" + name + "' already exists.");
        }
        predicates.put(this.name, this);
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.types.length;
    }

    public ConstantType getArgumentType(int position) {
        return this.types[position];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append("(");
        for (int i = 0; i < this.types.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((Object)this.types[i]);
        }
        builder.append(")");
        return builder.toString();
    }

    public static Predicate get(String name) {
        return predicates.get(name.toUpperCase());
    }

    public static void clearForTesting() {
        predicates.clear();
    }
}

