/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate.model;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SupportingModel {
    private static final Logger log = LoggerFactory.getLogger(SupportingModel.class);
    protected static final String DELIM = "\t";
    protected static final String CONFIG_FEATURES = "features";
    protected static final String CONFIG_LABELS = "labels";
    protected static final String CONFIG_MODEL = "model";
    protected int[] entityArgumentIndexes = StringUtils.splitInt(Options.MODEL_PREDICATE_ENTITY_ARGS.getString(), ",");
    protected int[] labelArgumentIndexes = StringUtils.splitInt(Options.MODEL_PREDICATE_LABEL_ARGS.getString(), ",");
    protected Map<String, Integer> entityIndexMapping = null;
    protected Map<String, Integer> labelIndexMapping = null;
    protected int numFeatures = -1;
    protected float[][] manualLabels = null;

    public abstract void load(Map<String, String> var1, String var2);

    public abstract float getValue(RandomVariableAtom var1, int var2, int var3);

    public abstract void run();

    public abstract void fit();

    public float getValue(RandomVariableAtom atom) {
        AtomIndexes indexes = this.getAtomIndexes(atom);
        if (indexes == null) {
            return 0.0f;
        }
        return this.getValue(atom, indexes.entityIndex, indexes.labelIndex);
    }

    public void resetLabels() {
        for (int i = 0; i < this.manualLabels.length; ++i) {
            for (int j = 0; j < this.manualLabels[i].length; ++j) {
                this.manualLabels[i][j] = 0.0f;
            }
        }
    }

    public void setLabel(RandomVariableAtom atom, float labelValue) {
        AtomIndexes indexes = this.getAtomIndexes(atom);
        if (indexes == null) {
            return;
        }
        this.manualLabels[indexes.entityIndex][indexes.labelIndex] = labelValue;
    }

    protected void loadLabels(String path) {
        log.debug("Loading labels for {} from {}", (Object)this, (Object)path);
        this.labelIndexMapping = new HashMap<String, Integer>();
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(DELIM);
                if (parts.length != this.labelArgumentIndexes.length) {
                    throw new RuntimeException(String.format("Incorrectly sized label line (%d). Expected: %d, found: %d", lineNumber, this.labelArgumentIndexes.length, parts.length));
                }
                this.labelIndexMapping.put(line, this.labelIndexMapping.size());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse labels file: " + path, ex);
        }
    }

    protected float[][] loadFeatures(String path) {
        log.debug("Loading features for {} from {}", (Object)this, (Object)path);
        this.entityIndexMapping = new HashMap<String, Integer>();
        int width = -1;
        StringBuilder entityIDBuilder = new StringBuilder();
        ArrayList<float[]> rawFeatures = new ArrayList<float[]>();
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(DELIM);
                if (width == -1) {
                    width = parts.length;
                    this.numFeatures = width - this.entityArgumentIndexes.length;
                    if (this.numFeatures <= 0) {
                        throw new RuntimeException(String.format("Line too short (%d). Expected at least %d, found %d.", lineNumber, this.entityArgumentIndexes.length + 1, width));
                    }
                } else if (parts.length != width) {
                    throw new RuntimeException(String.format("Incorrectly sized line (%d). Expected: %d, found: %d.", lineNumber, width, parts.length));
                }
                float[] features = new float[this.numFeatures];
                for (int i = 0; i < this.numFeatures; ++i) {
                    features[i] = Float.valueOf(parts[i + this.entityArgumentIndexes.length]).floatValue();
                }
                rawFeatures.add(features);
                this.entityIndexMapping.put(this.getAtomIdentifier(parts, this.entityArgumentIndexes), this.entityIndexMapping.size());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse features file: " + path, ex);
        }
        float[][] arrayFeatures = new float[rawFeatures.size()][this.numFeatures];
        for (int i = 0; i < rawFeatures.size(); ++i) {
            for (int j = 0; j < this.numFeatures; ++j) {
                arrayFeatures[i][j] = ((float[])rawFeatures.get(i))[j];
            }
        }
        log.debug("Loaded features for {} [{} x {}]", this, arrayFeatures.length, this.numFeatures);
        return arrayFeatures;
    }

    protected AtomIndexes getAtomIndexes(RandomVariableAtom atom) {
        int entityIndex = this.getEntityIndex(atom);
        if (entityIndex < 0) {
            log.warn("Could not locate entity for atom: {}", (Object)atom);
            return null;
        }
        int labelIndex = this.getLabelIndex(atom);
        if (labelIndex < 0) {
            log.warn("Could not locate label for atom: {}", (Object)atom);
            return null;
        }
        return new AtomIndexes(entityIndex, labelIndex);
    }

    protected int getEntityIndex(RandomVariableAtom atom) {
        String key = this.getAtomIdentifier(atom, this.entityArgumentIndexes);
        Integer index = this.entityIndexMapping.get(key);
        if (index == null) {
            return -1;
        }
        return index;
    }

    protected int getLabelIndex(RandomVariableAtom atom) {
        String key = this.getAtomIdentifier(atom, this.labelArgumentIndexes);
        Integer index = this.labelIndexMapping.get(key);
        if (index == null) {
            return -1;
        }
        return index;
    }

    protected String getAtomIdentifier(String[] stringArgs, int[] argumentIndexes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < argumentIndexes.length; ++i) {
            if (i != 0) {
                builder.append(DELIM);
            }
            builder.append(stringArgs[argumentIndexes[i]]);
        }
        return builder.toString();
    }

    protected String getAtomIdentifier(RandomVariableAtom atom, int[] argumentIndexes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < argumentIndexes.length; ++i) {
            if (i != 0) {
                builder.append(DELIM);
            }
            builder.append(atom.getArguments()[argumentIndexes[i]].rawToString());
        }
        return builder.toString();
    }

    protected static String makePath(String relativeDir, String basePath) {
        if (Paths.get(basePath, new String[0]).isAbsolute()) {
            return basePath;
        }
        return Paths.get(relativeDir, basePath).toString();
    }

    protected static final class AtomIndexes {
        public int entityIndex;
        public int labelIndex;

        public AtomIndexes(int entityIndex, int labelIndex) {
            this.entityIndex = entityIndex;
            this.labelIndex = labelIndex;
        }
    }
}

