/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd;

import java.util.Iterator;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.dcd.term.DCDObjectiveTerm;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCDReasoner
extends Reasoner {
    private static final Logger log = LoggerFactory.getLogger(DCDReasoner.class);
    private int maxIterations = Options.DCD_MAX_ITER.getInt();
    private float c = Options.DCD_C.getFloat();
    private boolean truncateEveryStep = Options.DCD_TRUNCATE_EVERY_STEP.getBoolean();

    @Override
    public void optimize(TermStore baseTermStore) {
        if (!(baseTermStore instanceof VariableTermStore)) {
            throw new IllegalArgumentException("DCDReasoner requires an VariableTermStore (found " + baseTermStore.getClass().getName() + ").");
        }
        VariableTermStore termStore = (VariableTermStore)baseTermStore;
        termStore.initForOptimization();
        float[] variableValues = termStore.getVariableValues();
        float objective = -1.0f;
        float oldObjective = Float.POSITIVE_INFINITY;
        if (this.printInitialObj && log.isTraceEnabled()) {
            objective = this.computeObjective(termStore, variableValues);
            log.trace("Iteration {} -- Objective: {}, Iteration Time: {}, Total Optimiztion Time: {}", 0, Float.valueOf(objective), 0, 0);
        }
        int iteration = 1;
        long totalTime = 0L;
        do {
            long start = System.currentTimeMillis();
            for (DCDObjectiveTerm term : termStore) {
                term.minimize(this.truncateEveryStep, variableValues);
            }
            if (!this.truncateEveryStep) {
                for (RandomVariableAtom variable : termStore.getVariables()) {
                    variable.setValue(Math.max(Math.min(variable.getValue(), 1.0f), 0.0f));
                }
            }
            long end = System.currentTimeMillis();
            oldObjective = objective;
            objective = this.computeObjective(termStore, variableValues);
            totalTime += end - start;
            if (log.isTraceEnabled()) {
                log.trace("Iteration {} -- Objective: {}, Iteration Time: {}, Total Optimiztion Time: {}", iteration, Float.valueOf(objective), end - start, totalTime);
            }
            termStore.iterationComplete();
        } while (!this.breakOptimization(++iteration, objective, oldObjective));
        termStore.syncAtoms();
        log.info("Optimization completed in {} iterations. Objective: {}, Total Optimiztion Time: {}", iteration - 1, Float.valueOf(objective), totalTime);
        log.debug("Optimized with {} variables and {} terms.", (Object)termStore.getNumVariables(), (Object)termStore.size());
    }

    private boolean breakOptimization(int iteration, float objective, float oldObjective) {
        if (iteration > (int)((double)this.maxIterations * this.budget)) {
            return true;
        }
        return this.objectiveBreak && MathUtils.equals(objective, oldObjective, this.tolerance);
    }

    private float computeObjective(VariableTermStore<DCDObjectiveTerm, RandomVariableAtom> termStore, float[] variableValues) {
        float objective = 0.0f;
        int termCount = 0;
        Iterator termIterator = null;
        termIterator = termStore.isLoaded() ? termStore.noWriteIterator() : termStore.iterator();
        for (DCDObjectiveTerm term : IteratorUtils.newIterable(termIterator)) {
            objective += term.evaluate(variableValues) / this.c;
            ++termCount;
        }
        return objective / (float)termCount;
    }

    @Override
    public void close() {
    }
}

