/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.function;

import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.reasoner.function.FunctionTerm;

public class GeneralFunction
implements FunctionTerm {
    private final float[] coefficients;
    private final FunctionTerm[] terms;
    private int size;
    private float constant;
    private boolean constantTerms;
    private boolean linearTerms;
    private boolean nonNegative;
    private boolean squared;

    public GeneralFunction(boolean nonNegative, boolean squared, int maxSize) {
        this.coefficients = new float[maxSize];
        this.terms = new FunctionTerm[maxSize];
        this.size = 0;
        this.constant = 0.0f;
        this.nonNegative = nonNegative;
        this.squared = squared;
        this.constantTerms = true;
        this.linearTerms = true;
    }

    public float getConstant() {
        return this.constant;
    }

    public boolean isSquared() {
        return this.squared;
    }

    public boolean isNonNegative() {
        return this.nonNegative;
    }

    @Override
    public boolean isLinear() {
        return !this.squared && this.linearTerms;
    }

    @Override
    public boolean isConstant() {
        return this.constantTerms;
    }

    public void setSquared(boolean squared) {
        this.squared = squared;
    }

    public void setNonNegative(boolean nonNegative) {
        this.nonNegative = nonNegative;
    }

    public void add(float value) {
        this.constant += value;
    }

    public void add(float coefficient, FunctionTerm term) {
        if (term.isConstant()) {
            this.constant += coefficient * term.getValue();
            return;
        }
        if (this.size == this.terms.length) {
            throw new IllegalStateException("More than the max terms added to the function. Max: " + this.terms.length);
        }
        this.terms[this.size] = term;
        this.coefficients[this.size] = coefficient;
        ++this.size;
        this.constantTerms = this.constantTerms && term.isConstant();
        this.linearTerms = this.linearTerms && term.isLinear();
    }

    public int size() {
        return this.size;
    }

    public float getCoefficient(int index) {
        return this.coefficients[index];
    }

    public FunctionTerm getTerm(int index) {
        return this.terms[index];
    }

    @Override
    public float getValue() {
        float val = this.constant;
        for (int i = 0; i < this.size; ++i) {
            val += this.terms[i].getValue() * this.coefficients[i];
        }
        if (this.nonNegative && (double)val < 0.0) {
            return 0.0f;
        }
        return this.squared ? val * val : val;
    }

    public float getValue(float[] values) {
        float val = this.constant;
        for (int i = 0; i < this.size; ++i) {
            val += this.coefficients[i] * values[i];
        }
        if (this.nonNegative && (double)val < 0.0) {
            return 0.0f;
        }
        return this.squared ? val * val : val;
    }

    public float getValue(GroundAtom replacementAtom, float replacementValue) {
        float val = this.constant;
        for (int i = 0; i < this.size; ++i) {
            FunctionTerm term = this.terms[i];
            float coefficient = this.coefficients[i];
            if (term == replacementAtom) {
                val += coefficient * replacementValue;
                continue;
            }
            val += coefficient * term.getValue();
        }
        if (this.nonNegative && (double)val < 0.0) {
            return 0.0f;
        }
        return this.squared ? val * val : val;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        if (this.nonNegative) {
            string.append("max(0.0, ");
        } else {
            string.append("(");
        }
        string.append(this.constant);
        for (int i = 0; i < this.size; ++i) {
            FunctionTerm term = this.terms[i];
            float coefficient = this.coefficients[i];
            string.append(" + ");
            string.append("" + coefficient + " * " + term.toString());
        }
        string.append(")");
        if (this.squared) {
            string.append("^2");
        }
        return string.toString();
    }
}

