/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.ArrayList;
import java.util.Iterator;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.RandUtils;

public class MemoryTermStore<T extends ReasonerTerm>
implements TermStore<T, RandomVariableAtom> {
    private ArrayList<T> store;

    public MemoryTermStore() {
        this(Options.MEMORY_TS_INITIAL_SIZE.getInt());
    }

    public MemoryTermStore(int initialSize) {
        this.store = new ArrayList(initialSize);
    }

    @Override
    public synchronized void add(GroundRule rule, T term) {
        this.store.add(term);
    }

    @Override
    public void clear() {
        if (this.store != null) {
            this.store.clear();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void close() {
        this.clear();
        this.store = null;
    }

    @Override
    public void initForOptimization() {
    }

    @Override
    public void iterationComplete() {
    }

    @Override
    public T get(int index) {
        return (T)((ReasonerTerm)this.store.get(index));
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public void ensureCapacity(int capacity) {
        assert (capacity >= 0);
        if (capacity == 0) {
            return;
        }
        this.store.ensureCapacity(capacity);
    }

    @Override
    public Iterator<T> iterator() {
        return this.store.iterator();
    }

    @Override
    public Iterator<T> noWriteIterator() {
        return this.iterator();
    }

    @Override
    public RandomVariableAtom createLocalVariable(RandomVariableAtom atom) {
        return atom;
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
    }

    public void shuffle() {
        RandUtils.shuffle(this.store);
    }
}

