/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.model.ModelPredicate;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.term.MemoryTermStore;
import org.linqs.psl.reasoner.term.ReasonerLocalVariable;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MemoryVariableTermStore<T extends ReasonerTerm, V extends ReasonerLocalVariable>
implements VariableTermStore<T, V> {
    private static final Logger log = LoggerFactory.getLogger(MemoryVariableTermStore.class);
    private MemoryTermStore<T> store;
    private Map<V, Integer> variables;
    private float[] variableValues;
    private RandomVariableAtom[] variableAtoms;
    private boolean shuffle = Options.MEMORY_VTS_SHUFFLE.getBoolean();
    private int defaultSize = Options.MEMORY_VTS_DEFAULT_SIZE.getInt();
    private Set<ModelPredicate> modelPredicates;

    public MemoryVariableTermStore() {
        this.store = new MemoryTermStore();
        this.ensureVariableCapacity(this.defaultSize);
        this.modelPredicates = new HashSet<ModelPredicate>();
    }

    @Override
    public int getVariableIndex(V variable) {
        return this.variables.get(variable);
    }

    @Override
    public float getVariableValue(int index) {
        return this.variableValues[index];
    }

    @Override
    public void updateVariableValue(int index, float gradient, float gradientStep) {
        this.variableValues[index] = Math.max(0.0f, Math.min(1.0f, this.variableValues[index] - gradientStep));
    }

    @Override
    public float[] getVariableValues() {
        return this.variableValues;
    }

    @Override
    public void syncAtoms() {
        for (int i = 0; i < this.variables.size(); ++i) {
            this.variableAtoms[i].setValue(this.variableValues[i]);
        }
    }

    @Override
    public int getNumVariables() {
        return this.variables.size();
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public synchronized V createLocalVariable(RandomVariableAtom atom) {
        V variable = this.convertAtomToVariable(atom);
        if (this.variables.containsKey(variable)) {
            return variable;
        }
        if (this.variables.size() >= this.variableAtoms.length) {
            this.ensureVariableCapacity(this.variables.size() * 2);
        }
        int index = this.variables.size();
        this.variables.put((Integer)variable, index);
        this.variableValues[index] = atom.getValue();
        this.variableAtoms[index] = atom;
        if (atom.getPredicate() instanceof ModelPredicate) {
            this.modelPredicates.add((ModelPredicate)atom.getPredicate());
        }
        return variable;
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Variable capacity must be non-negative. Got: " + capacity);
        }
        if (this.variables == null || this.variables.size() == 0) {
            this.variables = new HashMap<V, Integer>((int)Math.ceil((double)capacity / 0.75));
            this.variableValues = new float[capacity];
            this.variableAtoms = new RandomVariableAtom[capacity];
        } else if (this.variables.size() < capacity) {
            if (capacity < this.variables.size() * 2) {
                capacity = this.variables.size() * 2;
            }
            HashMap<Integer, Integer> newVariables = new HashMap<Integer, Integer>((int)Math.ceil((double)capacity / 0.75));
            newVariables.putAll(this.variables);
            this.variables = newVariables;
            this.variableValues = Arrays.copyOf(this.variableValues, capacity);
            this.variableAtoms = Arrays.copyOf(this.variableAtoms, capacity);
        }
    }

    @Override
    public Iterable<V> getVariables() {
        return this.variables.keySet();
    }

    @Override
    public void add(GroundRule rule, T term) {
        this.store.add(rule, term);
    }

    @Override
    public void clear() {
        if (this.store != null) {
            this.store.clear();
        }
        if (this.variables != null) {
            this.variables.clear();
        }
        if (this.modelPredicates != null) {
            this.modelPredicates.clear();
        }
        this.variableValues = null;
        this.variableAtoms = null;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.variables.size(); ++i) {
            this.variableValues[i] = this.variableAtoms[i].getValue();
        }
    }

    @Override
    public void close() {
        this.clear();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.variables = null;
    }

    @Override
    public void initForOptimization() {
        this.updateModelAtoms();
    }

    @Override
    public void iterationComplete() {
        this.fitModelAtoms();
        this.updateModelAtoms();
    }

    private void updateModelAtoms() {
        if (this.modelPredicates.size() == 0) {
            return;
        }
        for (ModelPredicate predicate : this.modelPredicates) {
            predicate.runModel();
        }
        int count = 0;
        for (int i = 0; i < this.variableAtoms.length; ++i) {
            if (!(this.variableAtoms[i].getPredicate() instanceof ModelPredicate)) continue;
            this.variableValues[i] = ((ModelPredicate)this.variableAtoms[i].getPredicate()).getValue(this.variableAtoms[i]);
            ++count;
        }
        log.debug("Batch update of {} model atoms.", (Object)count);
    }

    private void fitModelAtoms() {
        if (this.modelPredicates.size() == 0) {
            return;
        }
        for (ModelPredicate predicate : this.modelPredicates) {
            predicate.resetLabels();
        }
        int count = 0;
        for (int i = 0; i < this.variableAtoms.length; ++i) {
            if (!(this.variableAtoms[i].getPredicate() instanceof ModelPredicate)) continue;
            ((ModelPredicate)this.variableAtoms[i].getPredicate()).setLabel(this.variableAtoms[i], this.variableValues[i]);
            ++count;
        }
        for (ModelPredicate predicate : this.modelPredicates) {
            predicate.fit();
        }
        log.debug("Batch fit of {} model atoms.", (Object)count);
    }

    @Override
    public T get(int index) {
        return this.store.get(index);
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public void ensureCapacity(int capacity) {
        this.store.ensureCapacity(capacity);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.shuffle) {
            this.store.shuffle();
        }
        return this.store.iterator();
    }

    @Override
    public Iterator<T> noWriteIterator() {
        return this.iterator();
    }

    protected abstract V convertAtomToVariable(RandomVariableAtom var1);
}

