/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.linqs.psl.config.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandUtils {
    private static final Logger log = LoggerFactory.getLogger(RandUtils.class);
    private static Random rng = null;

    private RandUtils() {
    }

    private static synchronized void ensureRNG() {
        if (rng != null) {
            return;
        }
        long seed = Options.RANDOM_SEED.getInt();
        log.info("Using random seed: " + seed);
        rng = new Random(seed);
    }

    public static synchronized void seed(int seed) {
        RandUtils.ensureRNG();
        rng.setSeed(seed);
    }

    public static synchronized boolean nextBoolean() {
        RandUtils.ensureRNG();
        return rng.nextBoolean();
    }

    public static synchronized double nextDouble() {
        RandUtils.ensureRNG();
        return rng.nextDouble();
    }

    public static synchronized float nextFloat() {
        RandUtils.ensureRNG();
        return rng.nextFloat();
    }

    public static synchronized float nextFloat(float min, float max) {
        RandUtils.ensureRNG();
        if (min >= max) {
            throw new IllegalArgumentException(String.format("Min (%f) must be strictly less than max (%f).", Float.valueOf(min), Float.valueOf(max)));
        }
        return rng.nextFloat() * (max - min) + min;
    }

    public static synchronized double nextGaussian() {
        RandUtils.ensureRNG();
        return rng.nextGaussian();
    }

    public static synchronized int nextInt() {
        RandUtils.ensureRNG();
        return rng.nextInt();
    }

    public static synchronized int nextInt(int max) {
        RandUtils.ensureRNG();
        return rng.nextInt(max);
    }

    public static synchronized long nextLong() {
        RandUtils.ensureRNG();
        return rng.nextLong();
    }

    public static synchronized void shuffle(List<?> list) {
        RandUtils.ensureRNG();
        Collections.shuffle(list, rng);
    }

    @SafeVarargs
    public static synchronized void pairedShuffle(List ... lists) {
        RandUtils.ensureRNG();
        if (lists.length == 0) {
            return;
        }
        for (List list : lists) {
            if (list.size() == lists[0].size()) continue;
            throw new IllegalArgumentException(String.format("Lists must all have a matching size, found %d and %d.", list.size(), lists[0].size()));
        }
        for (int i = lists[0].size() - 1; i >= 0; --i) {
            int swapIndex = RandUtils.nextInt(i + 1);
            for (List list : lists) {
                Object temp = list.get(i);
                list.set(i, list.get(swapIndex));
                list.set(swapIndex, temp);
            }
        }
    }

    public static synchronized <T> void pairedShuffleIndexes(List<T> list, int[] indexes) {
        RandUtils.ensureRNG();
        if (list.size() > indexes.length) {
            throw new IllegalArgumentException(String.format("List size (%d) must be greater than or equal to array size (%d).", list.size(), indexes.length));
        }
        Object temp = null;
        int tempIndex = -1;
        for (int i = list.size() - 1; i >= 0; --i) {
            int swapIndex = RandUtils.nextInt(i + 1);
            temp = list.get(i);
            list.set(i, list.get(swapIndex));
            list.set(swapIndex, temp);
            tempIndex = indexes[i];
            indexes[i] = indexes[swapIndex];
            indexes[swapIndex] = indexes[i];
        }
    }
}

