/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.demos.autoanalysis.AutoAnalyser;
import infodynamics.measures.continuous.ChannelCalculator;
import infodynamics.measures.continuous.InfoMeasureCalculatorContinuous;
import infodynamics.measures.discrete.ChannelCalculatorDiscrete;
import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.MatrixUtils;
import java.util.Vector;

public abstract class AutoAnalyserChannelCalculator
extends AutoAnalyser {
    private static final long serialVersionUID = 1L;
    protected String[] gaussianProperties;
    protected String[] gaussianPropertiesFieldNames;
    protected String[] gaussianPropertyDescriptions;
    protected String[] kernelProperties;
    protected String[] kernelPropertiesFieldNames;
    protected String[] kernelPropertyDescriptions;
    protected String[] kraskovProperties;
    protected String[] kraskovPropertiesFieldNames;
    protected String[] kraskovPropertyDescriptions;

    public AutoAnalyserChannelCalculator() {
    }

    public AutoAnalyserChannelCalculator(String string) {
        super(string);
    }

    @Override
    protected void makeSpecificInitialisations() {
        this.numVariables = 2;
        this.variableColNumLabels = new String[]{"Source", "Destination"};
        this.useAllCombosCheckBox = true;
        this.useStatSigCheckBox = true;
        this.wordForCombinations = "pairs";
        this.variableRelationshipFormatString = "col_%d -> col_%d";
        this.disableVariableColTextFieldsForAllCombos = new boolean[]{true, true};
        this.indentsForAllCombos = 2;
    }

    @Override
    protected void fillOutAllCombinations(Vector<int[]> vector) {
        for (int i = 0; i < this.dataColumns; ++i) {
            int n = 0;
            while (n < this.dataColumns) {
                vector.add(new int[]{i, n++});
            }
        }
    }

    @Override
    protected String[] setUpLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        stringBuffer.append("    \n");
        stringBuffer.append("    // Compute for all pairs:\n");
        stringBuffer.append("    for (int s = 0; s < " + this.dataColumns + "; s++) {\n");
        stringBuffer.append("        for (int d = 0; d < " + this.dataColumns + "; d++) {\n");
        String string = "            ";
        stringBuffer.append(string + "// For each source-dest pair:\n");
        stringBuffer.append(string + "if (s == d) {\n");
        stringBuffer.append(string + "    continue;\n");
        stringBuffer.append(string + "}\n");
        stringBuffer2.append("\n");
        stringBuffer2.append("# Compute for all pairs:\n");
        stringBuffer2.append("for s in range(" + this.dataColumns + "):\n");
        stringBuffer2.append("    for d in range(" + this.dataColumns + "):\n");
        String string2 = "        ";
        stringBuffer2.append(string2 + "# For each source-dest pair:\n");
        stringBuffer2.append(string2 + "if (s == d):\n");
        stringBuffer2.append(string2 + "    continue\n");
        stringBuffer3.append("\n");
        stringBuffer3.append("% Compute for all pairs:\n");
        stringBuffer3.append("for s = 1:" + this.dataColumns + "\n");
        stringBuffer3.append("\tfor d = 1:" + this.dataColumns + "\n");
        String string3 = "\t\t";
        stringBuffer3.append(string3 + "% For each source-dest pair:\n");
        stringBuffer3.append(string3 + "if (s == d)\n");
        stringBuffer3.append(string3 + "\tcontinue;\n");
        stringBuffer3.append(string3 + "end\n");
        return new String[]{"s", "d"};
    }

    @Override
    protected void finaliseLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        stringBuffer.append("        }\n");
        stringBuffer.append("    }\n");
        stringBuffer3.append("\tend\n");
        stringBuffer3.append("end\n");
    }

    @Override
    protected String formatStringWithColumnNumbers(String string, int[] nArray) {
        return String.format(string, nArray[0], nArray[1]);
    }

    @Override
    protected boolean skipColumnCombo(int[] nArray) {
        return nArray[0] == nArray[1];
    }

    @Override
    protected void setObservations(InfoMeasureCalculatorDiscrete infoMeasureCalculatorDiscrete, InfoMeasureCalculatorContinuous infoMeasureCalculatorContinuous, int[] nArray) throws Exception {
        String string = (String)this.calcTypeComboBox.getSelectedItem();
        int n = nArray[0];
        int n2 = nArray[1];
        if (string.equalsIgnoreCase("Discrete")) {
            ChannelCalculatorDiscrete channelCalculatorDiscrete = (ChannelCalculatorDiscrete)((Object)infoMeasureCalculatorDiscrete);
            channelCalculatorDiscrete.addObservations(MatrixUtils.selectColumn(this.dataDiscrete, n), MatrixUtils.selectColumn(this.dataDiscrete, n2));
        } else if (string.equalsIgnoreCase("Binned")) {
            ChannelCalculatorDiscrete channelCalculatorDiscrete = (ChannelCalculatorDiscrete)((Object)infoMeasureCalculatorDiscrete);
            channelCalculatorDiscrete.addObservations(MatrixUtils.discretise(MatrixUtils.selectColumn(this.data, n), Integer.parseInt((String)this.propertyValues.get("base"))), MatrixUtils.discretise(MatrixUtils.selectColumn(this.data, n2), Integer.parseInt((String)this.propertyValues.get("base"))));
        } else {
            ChannelCalculator channelCalculator = (ChannelCalculator)infoMeasureCalculatorContinuous;
            channelCalculator.setObservations(MatrixUtils.selectColumn(this.data, n), MatrixUtils.selectColumn(this.data, n2));
        }
    }

    @Override
    protected AutoAnalyser.CalcProperties assignCalcProperties(String string) throws Exception {
        AutoAnalyser.CalcProperties calcProperties = super.assignCalcProperties(string);
        if (calcProperties == null) {
            calcProperties = new AutoAnalyser.CalcProperties();
            calcProperties.calc = this.assignCalcObjectContinuous(string);
            calcProperties.calcClass = calcProperties.calc.getClass();
            if (string.equalsIgnoreCase("Gaussian")) {
                calcProperties.classSpecificPropertyNames = this.gaussianProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.gaussianPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.gaussianPropertyDescriptions;
            } else if (string.startsWith("Kraskov (KSG)")) {
                calcProperties.classSpecificPropertyNames = this.kraskovProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.kraskovPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.kraskovPropertyDescriptions;
            } else if (string.equalsIgnoreCase("Kernel")) {
                calcProperties.classSpecificPropertyNames = this.kernelProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.kernelPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.kernelPropertyDescriptions;
            } else {
                calcProperties = null;
                throw new Exception("No recognised calculator selected: " + string);
            }
        }
        return calcProperties;
    }
}

