/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.ActiveInfoStorageCalculatorMultiVariate;
import infodynamics.measures.continuous.ActiveInfoStorageCalculatorViaMutualInfo;
import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.utils.MatrixUtils;
import java.util.Iterator;
import java.util.Vector;

public class ActiveInfoStorageCalculatorMultiVariateViaMutualInfo
extends ActiveInfoStorageCalculatorViaMutualInfo
implements ActiveInfoStorageCalculatorMultiVariate {
    protected int dimensions = 1;
    protected int timeForFirstEmbedding;
    protected Vector<double[][]> vectorOfMultiVariateObservationTimeSeries;
    protected Vector<boolean[]> vectorOfValidityOfObservations;

    public ActiveInfoStorageCalculatorMultiVariateViaMutualInfo(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(string);
    }

    protected ActiveInfoStorageCalculatorMultiVariateViaMutualInfo(Class<MutualInfoCalculatorMultiVariate> clazz) throws InstantiationException, IllegalAccessException {
        super(clazz);
    }

    protected ActiveInfoStorageCalculatorMultiVariateViaMutualInfo(MutualInfoCalculatorMultiVariate mutualInfoCalculatorMultiVariate) {
        super(mutualInfoCalculatorMultiVariate);
    }

    @Override
    public void initialise(int n) throws Exception {
        this.initialise(n, this.k, this.tau);
    }

    @Override
    public void initialise(int n, int n2) throws Exception {
        this.initialise(n, n2, this.tau);
    }

    @Override
    public void initialise(int n, int n2, int n3) throws Exception {
        this.dimensions = n;
        this.k = n2;
        this.tau = n3;
        this.timeForFirstEmbedding = n3 * (n2 - 1);
    }

    @Override
    public void setObservations(double[] dArray) throws Exception {
        if (this.dimensions != 1) {
            throw new Exception("Cannot call the univariate setObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.setObservations(dArray);
    }

    public void setObservations(double[][] dArray) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray);
        this.finaliseAddObservations();
    }

    @Override
    public void startAddObservations() {
        if (this.dimensions == 1) {
            super.startAddObservations();
        } else {
            this.miCalc.startAddObservations();
            this.vectorOfMultiVariateObservationTimeSeries = new Vector();
            this.vectorOfValidityOfObservations = new Vector();
        }
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        if (this.dimensions == 1) {
            super.finaliseAddObservations();
        } else {
            this.preFinaliseAddObservations();
            this.miCalc.initialise(this.dimensions * this.k, this.dimensions);
            this.miCalc.startAddObservations();
            Iterator<boolean[]> iterator = this.vectorOfValidityOfObservations.iterator();
            for (double[][] dArray : this.vectorOfMultiVariateObservationTimeSeries) {
                boolean[] blArray = iterator.next();
                if (blArray == null) {
                    this.addObservationsAfterParamsDetermined(dArray);
                    continue;
                }
                this.addObservationsAfterParamsDetermined(dArray, blArray);
            }
            this.vectorOfMultiVariateObservationTimeSeries = null;
            this.vectorOfValidityOfObservations = null;
            this.miCalc.finaliseAddObservations();
        }
    }

    @Override
    public void addObservations(double[] dArray) throws Exception {
        if (this.dimensions != 1) {
            throw new Exception("Cannot call the univariate addObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.addObservations(dArray);
    }

    public void addObservations(double[][] dArray) throws Exception {
        this.vectorOfMultiVariateObservationTimeSeries.add(dArray);
        this.vectorOfValidityOfObservations.add(null);
    }

    @Override
    public void addObservations(double[] dArray, int n, int n2) throws Exception {
        if (this.dimensions != 1) {
            throw new Exception("Cannot call the univariate addObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.addObservations(dArray, n, n2);
    }

    public void addObservations(double[][] dArray, int n, int n2) throws Exception {
        if (dArray.length < n + n2) {
            throw new Exception("Not enough observations to set here given startTime and numTimeSteps parameters");
        }
        this.addObservations(MatrixUtils.selectRows(dArray, n, n2));
    }

    @Override
    public void setObservations(double[] dArray, boolean[] blArray) throws Exception {
        if (this.dimensions != 1) {
            throw new Exception("Cannot call the univariate addObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.setObservations(dArray, blArray);
    }

    public void setObservations(double[][] dArray, boolean[] blArray) throws Exception {
        this.startAddObservations();
        this.vectorOfMultiVariateObservationTimeSeries.add(dArray);
        this.vectorOfValidityOfObservations.add(blArray);
        this.finaliseAddObservations();
    }

    protected void addObservationsAfterParamsDetermined(double[][] dArray) throws Exception {
        if (dArray.length - (this.k - 1) * this.tau - 1 <= 0) {
            return;
        }
        double[][] dArray2 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, this.tau, (this.k - 1) * this.tau, dArray.length - (this.k - 1) * this.tau - 1);
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray, 1, (this.k - 1) * this.tau + 1, dArray.length - (this.k - 1) * this.tau - 1);
        this.miCalc.addObservations(dArray2, dArray3);
    }

    protected void addObservationsAfterParamsDetermined(double[][] dArray, boolean[] blArray) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray);
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservationsAfterParamsDetermined(MatrixUtils.selectRows(dArray, n, n2 - n + 1));
        }
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray) throws Exception {
        if (this.dimensions != 1) {
            throw new Exception("Cannot call the univariate computeLocalUsingPreviousObservations if you have initialised with dimension > 1 for either source or destination");
        }
        return super.computeLocalUsingPreviousObservations(dArray);
    }

    public double[] computeLocalUsingPreviousObservations(double[][] dArray) throws Exception {
        double[][] dArray2 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.k, this.tau, (this.k - 1) * this.tau, dArray.length - (this.k - 1) * this.tau - 1);
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray, 1, (this.k - 1) * this.tau + 1, dArray.length - (this.k - 1) * this.tau - 1);
        double[] dArray4 = this.miCalc.computeLocalUsingPreviousObservations(dArray2, dArray3);
        double[] dArray5 = new double[dArray4.length + (this.k - 1) * this.tau + 1];
        System.arraycopy(dArray4, 0, dArray5, (this.k - 1) * this.tau + 1, dArray4.length);
        return dArray5;
    }
}

