/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.MultiInfoCalculatorKraskov;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.NeighbourNodeData;
import java.util.Calendar;
import java.util.PriorityQueue;

public class MultiInfoCalculatorKraskov2
extends MultiInfoCalculatorKraskov {
    public MultiInfoCalculatorKraskov2() {
        this.isAlgorithm1 = false;
    }

    @Override
    protected double[] partialComputeFromObservations(int n, int n2, boolean bl) throws Exception {
        double d = Calendar.getInstance().getTimeInMillis();
        double[] dArray = null;
        if (bl) {
            dArray = new double[n2];
        }
        double d2 = (double)(this.dimensions - 1) / (double)this.k;
        double d3 = (double)(this.dimensions - 1) * this.digammaN;
        double d4 = 0.0;
        double[] dArray2 = new double[this.dimensions];
        for (int i = n; i < n + n2; ++i) {
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, i, this.dynCorrExclTime);
            double[] dArray3 = new double[this.dimensions];
            for (int j = 0; j < this.k; ++j) {
                NeighbourNodeData neighbourNodeData = priorityQueue.poll();
                for (int k = 0; k < this.dimensions; ++k) {
                    if (!(neighbourNodeData.norms[k] > dArray3[k])) continue;
                    dArray3[k] = neighbourNodeData.norms[k];
                }
            }
            int[] nArray = new int[this.dimensions];
            double d5 = 0.0;
            for (int j = 0; j < this.dimensions; ++j) {
                nArray[j] = this.rangeSearchersInMarginals[j].countPointsWithinOrOnR(i, dArray3[j], this.dynCorrExclTime);
                int n3 = j;
                dArray2[n3] = dArray2[n3] + (double)nArray[j];
                d5 += MathsUtils.digamma(nArray[j]);
            }
            d4 += d5;
            if (!bl) continue;
            dArray[i - n] = this.digammaK - d2 - d5 + d3;
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
        }
        if (bl) {
            return dArray;
        }
        double[] dArray4 = new double[this.dimensions + 1];
        dArray4[0] = d4;
        System.arraycopy(dArray2, 0, dArray4, 1, this.dimensions);
        return dArray4;
    }
}

