/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;

public class CombinedActiveEntRateCalculatorDiscrete {
    private double averageActive = 0.0;
    private double maxActive = 0.0;
    private double minActive = 0.0;
    private double averageEntRate = 0.0;
    private double maxEntRate = 0.0;
    private double minEntRate = 0.0;
    private double averageEntropy = 0.0;
    private double maxEntropy = 0.0;
    private double minEntropy = 0.0;
    private int observations = 0;
    private int k = 0;
    private int base = 0;
    private int[][] jointCount = null;
    private int[] prevCount = null;
    private int[] nextCount = null;

    public void initialise(int n, int n2) {
        this.averageActive = 0.0;
        this.maxActive = 0.0;
        this.minActive = 0.0;
        this.observations = 0;
        boolean bl = true;
        if (this.base == n2 && this.k == n) {
            bl = false;
        }
        this.base = n2;
        this.k = n;
        if (n < 1) {
            throw new RuntimeException("History k " + n + " is not >= 1 for ActiveInfo Calculator");
        }
        if (bl) {
            this.jointCount = new int[n2][MathsUtils.power(n2, n)];
            this.prevCount = new int[MathsUtils.power(n2, n)];
            this.nextCount = new int[n2];
        } else {
            MatrixUtils.fill(this.jointCount, 0);
            MatrixUtils.fill(this.prevCount, 0);
            MatrixUtils.fill(this.nextCount, 0);
        }
    }

    public void addObservations(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        this.observations += (n - this.k) * n2;
        for (int i = this.k; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = nArray[i][j];
                int n4 = 0;
                int n5 = 1;
                for (int k = 1; k <= this.k; ++k) {
                    n4 += nArray[i - k][j] * n5;
                    n5 *= this.base;
                }
                int[] nArray2 = this.jointCount[n3];
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
                int n7 = n4;
                this.prevCount[n7] = this.prevCount[n7] + 1;
                int n8 = n3;
                this.nextCount[n8] = this.nextCount[n8] + 1;
            }
        }
    }

    public void addObservations(int[][] nArray, int n) {
        int n2 = nArray.length;
        this.observations += n2 - this.k;
        for (int i = this.k; i < n2; ++i) {
            int n3 = nArray[i][n];
            int n4 = 0;
            int n5 = 1;
            for (int j = 1; j <= this.k; ++j) {
                n4 += nArray[i - j][n] * n5;
                n5 *= this.base;
            }
            int[] nArray2 = this.jointCount[n3];
            int n6 = n4;
            nArray2[n6] = nArray2[n6] + 1;
            int n7 = n4;
            this.prevCount[n7] = this.prevCount[n7] + 1;
            int n8 = n3;
            this.nextCount[n8] = this.nextCount[n8] + 1;
        }
    }

    public void computeAverageLocalOfObservations() {
        this.resetOverallStats();
        for (int i = 0; i < this.base; ++i) {
            double d;
            double d2;
            double d3;
            block10: {
                block8: {
                    block9: {
                        d3 = (double)this.nextCount[i] / (double)this.observations;
                        if (!(d3 > 0.0)) break block8;
                        d2 = -Math.log(d3) / Math.log(this.base);
                        d = d3 * d2;
                        if (!(d2 > this.maxEntropy)) break block9;
                        this.maxEntropy = d2;
                        break block10;
                    }
                    if (!(d2 < this.minEntropy)) break block10;
                    this.minEntropy = d2;
                    break block10;
                }
                d2 = 0.0;
                d = 0.0;
                continue;
            }
            this.averageEntropy += d;
            for (int j = 0; j < MathsUtils.power(this.base, this.k); ++j) {
                double d4;
                double d5;
                double d6 = (double)this.prevCount[j] / (double)this.observations;
                double d7 = (double)this.jointCount[i][j] / (double)this.observations;
                if (d7 > 0.0) {
                    double d8 = d7 / (d3 * d6);
                    d5 = Math.log(d8) / Math.log(this.base);
                    d4 = d7 * d5;
                    if (d5 > this.maxActive) {
                        this.maxActive = d5;
                    } else if (d5 < this.minActive) {
                        this.minActive = d5;
                    }
                } else {
                    d5 = 0.0;
                    d4 = 0.0;
                }
                this.averageActive += d4;
                double d9 = d2 - d5;
                if (d9 > this.maxEntRate) {
                    this.maxEntRate = d9;
                    continue;
                }
                if (!(d9 < this.maxEntRate)) continue;
                this.maxEntRate = d9;
            }
        }
        this.averageEntRate = this.averageEntropy - this.averageActive;
    }

    public CombinedActiveEntRateLocalSTResults computeLocalFromPreviousObservations(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        double[][] dArray = new double[n][n2];
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        this.resetOverallStats();
        for (int i = this.k; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = nArray[i][j];
                int n4 = 0;
                int n5 = 1;
                for (int k = 1; k <= this.k; ++k) {
                    n4 += nArray[i - k][j] * n5;
                    n5 *= this.base;
                }
                double d = (double)this.nextCount[n3] / (double)this.observations;
                dArray3[i][j] = -Math.log(d) / Math.log(this.base);
                this.averageEntropy += dArray3[i][j];
                if (dArray3[i][j] > this.maxEntropy) {
                    this.maxEntropy = dArray3[i][j];
                } else if (dArray3[i][j] < this.minEntropy) {
                    this.minEntropy = dArray3[i][j];
                }
                double d2 = (double)this.jointCount[n3][n4] / ((double)this.nextCount[n3] * (double)this.prevCount[n4]);
                dArray[i][j] = Math.log(d2 *= (double)this.observations) / Math.log(this.base);
                this.averageActive += dArray[i][j];
                if (dArray[i][j] > this.maxActive) {
                    this.maxActive = dArray[i][j];
                } else if (dArray[i][j] < this.minActive) {
                    this.minActive = dArray[i][j];
                }
                dArray2[i][j] = dArray3[i][j] - dArray[i][j];
                if (dArray2[i][j] > this.maxEntRate) {
                    this.maxEntRate = dArray2[i][j];
                    continue;
                }
                if (!(dArray2[i][j] < this.minEntRate)) continue;
                this.minEntRate = dArray2[i][j];
            }
        }
        this.averageActive /= (double)(n2 * (n - this.k));
        this.averageEntropy /= (double)(n2 * (n - this.k));
        this.averageEntRate = this.averageEntropy - this.averageActive;
        CombinedActiveEntRateLocalSTResults combinedActiveEntRateLocalSTResults = new CombinedActiveEntRateLocalSTResults();
        combinedActiveEntRateLocalSTResults.localActiveInfo = dArray;
        combinedActiveEntRateLocalSTResults.localEntropyRate = dArray2;
        combinedActiveEntRateLocalSTResults.localEntropy = dArray3;
        return combinedActiveEntRateLocalSTResults;
    }

    public CombinedActiveEntRateLocalResults computeLocalFromPreviousObservations(int[][] nArray, int n) {
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        this.resetOverallStats();
        double d = 0.0;
        for (int i = this.k; i < n2; ++i) {
            int n3 = nArray[i][n];
            int n4 = 0;
            int n5 = 1;
            for (int j = 1; j <= this.k; ++j) {
                n4 += nArray[i - j][n] * n5;
                n5 *= this.base;
            }
            double d2 = (double)this.nextCount[n3] / (double)this.observations;
            dArray3[i] = -Math.log(d2) / Math.log(this.base);
            this.averageEntropy += dArray3[i];
            if (dArray3[i] > this.maxEntropy) {
                this.maxEntropy = dArray3[i];
            } else if (dArray3[i] < this.minEntropy) {
                this.minEntropy = dArray3[i];
            }
            d = (double)this.jointCount[n3][n4] / ((double)this.nextCount[n3] * (double)this.prevCount[n4]);
            dArray[i] = Math.log(d *= (double)this.observations) / Math.log(this.base);
            this.averageActive += dArray[i];
            if (dArray[i] > this.maxActive) {
                this.maxActive = dArray[i];
            } else if (dArray[i] < this.minActive) {
                this.minActive = dArray[i];
            }
            dArray2[i] = dArray3[i] - dArray[i];
            if (dArray2[i] > this.maxEntRate) {
                this.maxEntRate = dArray2[i];
                continue;
            }
            if (!(dArray2[i] < this.minEntRate)) continue;
            this.minEntRate = dArray2[i];
        }
        this.averageActive /= (double)(n2 - this.k);
        this.averageEntropy /= (double)(n2 - this.k);
        this.averageEntRate = this.averageEntropy - this.averageActive;
        CombinedActiveEntRateLocalResults combinedActiveEntRateLocalResults = new CombinedActiveEntRateLocalResults();
        combinedActiveEntRateLocalResults.localActiveInfo = dArray;
        combinedActiveEntRateLocalResults.localEntropyRate = dArray2;
        combinedActiveEntRateLocalResults.localEntropy = dArray3;
        return combinedActiveEntRateLocalResults;
    }

    public CombinedActiveEntRateLocalSTResults computeLocal(int n, int n2, int[][] nArray) {
        this.initialise(n, n2);
        this.addObservations(nArray);
        return this.computeLocalFromPreviousObservations(nArray);
    }

    public void computeAverageLocal(int n, int n2, int[][] nArray) {
        this.initialise(n, n2);
        this.addObservations(nArray);
        this.computeAverageLocalOfObservations();
    }

    public CombinedActiveEntRateLocalResults computeLocal(int n, int n2, int[][] nArray, int n3) {
        this.initialise(n, n2);
        this.addObservations(nArray, n3);
        return this.computeLocalFromPreviousObservations(nArray, n3);
    }

    public void computeAverageLocal(int n, int n2, int[][] nArray, int n3) {
        this.initialise(n, n2);
        this.addObservations(nArray, n3);
        this.computeAverageLocalOfObservations();
    }

    private void resetOverallStats() {
        this.averageActive = 0.0;
        this.maxActive = 0.0;
        this.minActive = 0.0;
        this.averageEntRate = 0.0;
        this.maxEntRate = 0.0;
        this.minEntRate = 0.0;
        this.averageEntropy = 0.0;
        this.maxEntropy = 0.0;
        this.minEntropy = 0.0;
    }

    public double getLastAverageActive() {
        return this.averageActive;
    }

    public double getLastMaxActive() {
        return this.maxActive;
    }

    public double getLastMinActive() {
        return this.minActive;
    }

    public double getLastAverageEntRate() {
        return this.averageEntRate;
    }

    public double getLastMaxEntRate() {
        return this.maxEntRate;
    }

    public double getLastMinEntRate() {
        return this.minEntRate;
    }

    public double getLastAverageEntropy() {
        return this.averageEntropy;
    }

    public double getLastMaxEntropy() {
        return this.maxEntropy;
    }

    public double getLastMinEntropy() {
        return this.minEntropy;
    }

    public class CombinedActiveEntRateLocalResults {
        public double[] localActiveInfo;
        public double[] localEntropyRate;
        public double[] localEntropy;
    }

    public class CombinedActiveEntRateLocalSTResults {
        public double[][] localActiveInfo;
        public double[][] localEntropyRate;
        public double[][] localEntropy;
    }
}

