/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.mixed.gaussian;

import infodynamics.measures.continuous.gaussian.EntropyCalculatorMultiVariateGaussian;
import infodynamics.measures.mixed.ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceCommon;
import infodynamics.utils.MatrixUtils;

public class ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian
extends ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceCommon
implements Cloneable {
    protected EntropyCalculatorMultiVariateGaussian entCalcZ;
    protected EntropyCalculatorMultiVariateGaussian entCalcCZ;
    protected EntropyCalculatorMultiVariateGaussian[] entCalcZForEachDiscrete;
    protected EntropyCalculatorMultiVariateGaussian[] entCalcCZForEachDiscrete;

    public ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian() {
        this.normalise = false;
        this.entCalcZ = new EntropyCalculatorMultiVariateGaussian();
        this.entCalcZForEachDiscrete = null;
        this.entCalcCZ = new EntropyCalculatorMultiVariateGaussian();
        this.entCalcCZForEachDiscrete = null;
    }

    @Override
    public void initialise(int n, int n2, int n3) {
        super.initialise(n, n2, n3);
        this.entCalcZ.initialise(n3);
        this.entCalcCZ.initialise(n + n3);
        this.entCalcZForEachDiscrete = new EntropyCalculatorMultiVariateGaussian[n2];
        this.entCalcCZForEachDiscrete = new EntropyCalculatorMultiVariateGaussian[n2];
        for (int i = 0; i < n2; ++i) {
            this.entCalcZForEachDiscrete[i] = new EntropyCalculatorMultiVariateGaussian();
            this.entCalcCZForEachDiscrete[i] = new EntropyCalculatorMultiVariateGaussian();
            this.entCalcZForEachDiscrete[i].initialise(n3);
            this.entCalcCZForEachDiscrete[i].initialise(n + n3);
        }
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        super.finaliseAddObservations();
        this.entCalcZ.setObservations(this.conditionedDataZ);
        double[][] dArray = MatrixUtils.appendColumns(this.continuousDataX, this.conditionedDataZ);
        this.entCalcCZ.setObservations(dArray);
        int n = 0;
        for (int i = 0; i < this.base; ++i) {
            double[][] dArray2 = MatrixUtils.extractSelectedPointsMatchingCondition(this.conditionedDataZ, this.discreteData, i);
            double[][] dArray3 = MatrixUtils.extractSelectedPointsMatchingCondition(dArray, this.discreteData, i);
            this.entCalcZForEachDiscrete[i].setObservations(dArray2);
            this.entCalcCZForEachDiscrete[i].setObservations(dArray3);
            n += dArray2.length;
        }
        if (n != this.discreteData.length) {
            throw new Exception("Some values in discreteObservations were not in the range 0..base-1");
        }
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.base; ++i) {
            double d3 = (double)this.counts[i] / (double)this.totalObservations;
            d2 += d3 * this.entCalcZForEachDiscrete[i].computeAverageLocalOfObservations();
            d += d3 * this.entCalcCZForEachDiscrete[i].computeAverageLocalOfObservations();
        }
        double d4 = this.entCalcCZ.computeAverageLocalOfObservations();
        double d5 = this.entCalcZ.computeAverageLocalOfObservations();
        this.condMi = d4 - d5 - d + d2;
        if (this.debug) {
            System.out.printf("H(C,Z)=%.4f - H(Z)=%.4f - H(C,Z|D)=%.4f + H(Z|D)=%.4f = %.4f\n", d4, d5, d, d2, this.condMi);
        }
        return this.condMi;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, int[] nArray, double[][] dArray2) throws Exception {
        throw new RuntimeException("Not implemented yet");
    }

    protected Object clone() throws CloneNotSupportedException {
        int n;
        ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian = (ConditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian)super.clone();
        conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian.entCalcZ = (EntropyCalculatorMultiVariateGaussian)this.entCalcZ.clone();
        if (this.entCalcZForEachDiscrete != null) {
            conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian.entCalcZForEachDiscrete = new EntropyCalculatorMultiVariateGaussian[this.base];
            for (n = 0; n < this.base; ++n) {
                conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian.entCalcZForEachDiscrete[n] = (EntropyCalculatorMultiVariateGaussian)this.entCalcZForEachDiscrete[n].clone();
            }
        }
        conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian.entCalcCZ = (EntropyCalculatorMultiVariateGaussian)this.entCalcCZ.clone();
        if (this.entCalcCZForEachDiscrete != null) {
            conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian.entCalcCZForEachDiscrete = new EntropyCalculatorMultiVariateGaussian[this.base];
            for (n = 0; n < this.base; ++n) {
                conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian.entCalcCZForEachDiscrete[n] = (EntropyCalculatorMultiVariateGaussian)this.entCalcCZForEachDiscrete[n].clone();
            }
        }
        return conditionalMutualInfoCalculatorMultiVariateWithDiscreteSourceGaussian;
    }
}

