/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ArrayFileWriter {
    public static void makeBooleanMatrixFile(boolean[][] blArray, String string) throws IOException {
        int n = blArray.length;
        int n2 = blArray[0].length;
        ArrayFileWriter.createDirectories(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!blArray[i][j]) {
                    bufferedWriter.write("0\t");
                } else {
                    bufferedWriter.write("1\t");
                }
                if (j != n2 - 1) continue;
                bufferedWriter.write("\n");
            }
        }
        bufferedWriter.close();
    }

    public static void makeDoubleMatrixFile(double[][] dArray, String string) throws IOException {
        int n = dArray.length;
        int n2 = dArray[0].length;
        ArrayFileWriter.createDirectories(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedWriter.write(String.valueOf(dArray[i][j]) + "\t");
                if (j != n2 - 1) continue;
                bufferedWriter.write("\n");
            }
        }
        bufferedWriter.close();
    }

    public static void makeDoubleMatrixFile(double[][] dArray, String string, int n) throws IOException {
        String string2 = String.format("%%.%df\t", n);
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        ArrayFileWriter.createDirectories(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                bufferedWriter.write(String.format(string2, dArray[i][j]));
                if (j != n3 - 1) continue;
                bufferedWriter.write("\n");
            }
        }
        bufferedWriter.close();
    }

    public static void makeIntMatrixFile(int[][] nArray, String string) throws IOException {
        int n = nArray.length;
        int n2 = nArray[0].length;
        ArrayFileWriter.createDirectories(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedWriter.write(String.valueOf(nArray[i][j]) + "\t");
                if (j != n2 - 1) continue;
                bufferedWriter.write("\n");
            }
        }
        bufferedWriter.close();
    }

    public static void makeMatrixFile(double[] dArray, String string) throws IOException {
        int n = dArray.length;
        ArrayFileWriter.createDirectories(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n; ++i) {
            bufferedWriter.write(String.valueOf(dArray[i]) + "\n");
        }
        bufferedWriter.close();
    }

    public static void makeMatrixFile(Number[][] numberArray, String string) throws IOException {
        int n = numberArray.length;
        int n2 = numberArray[0].length;
        ArrayFileWriter.createDirectories(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedWriter.write(String.valueOf(numberArray[i][j]) + "\t");
                if (j != n2 - 1) continue;
                bufferedWriter.write("\n");
            }
        }
        bufferedWriter.close();
    }

    public static void makeMatrixFile(Number[] numberArray, String string) throws IOException {
        int n = numberArray.length;
        ArrayFileWriter.createDirectories(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < n; ++i) {
            bufferedWriter.write(String.valueOf(numberArray[i]) + "\n");
        }
        bufferedWriter.close();
    }

    private static void createDirectories(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.isDirectory()) {
            file2.mkdirs();
        }
    }
}

