#!/usr/bin/env python

import os
import argparse

import numpy as np

_save = True
_here = os.path.abspath(os.path.dirname(__file__))
_Exp, _Cls, _name = os.path.split(__file__)[1].split('_')[:3]
assert not any([any([ss in s for ss in ['Notes','.']])
               for s in [_Exp, _Cls, _name]])

def get_notes():

    # Notes from creoView/python (R,Z)
    notes = {'C': np.r_[2.422, 0.],
             'r_in': 1.882/2.,
             'r_out': 1.992/2.} # r_out for later use (thick)

    return notes

def make_Poly(save=_save, path=_here):

    notes = get_notes()

    C = notes['C']
    nP = 100
    theta = np.linspace(0.,2*np.pi, nP, endpoint=False)
    Poly = np.array([C[0]+notes['r_in']*np.cos(theta),
                     C[1]+notes['r_in']*np.sin(theta)])

    if save:
        nn = _name+'V0'
        pfe = os.path.join(path, nn+'.txt')
        np.savetxt(pfe, Poly.T, comments='#',
                   header='Exp = %s\nName = %s\nCls = %s'%(_Exp,nn,_Cls))
    return P, notes



if __name__=='__main__':

    # Parse input arguments
    msg = 'Launch creation of polygons txt from bash'
    parser = argparse.ArgumentParser(description = msg)

    parser.add_argument('-save', type=bool, help='save ?', default=_save)
    parser.add_argument('-path', type=str, help='saving path ?', default=_here)

    args = parser.parse_args()

    # Call wrapper function
    make_Poly(save=args.save, path=args.path)
