import math

import numpy as np


def dq_b(m0, m1, m2, n0, n1, n2):
    """Stretch, first derivative wrt. cartesians"""

    x0 = m0 - n0
    x1 = m1 - n1
    x2 = m2 - n2
    x3 = 1/math.sqrt(x0**2 + x1**2 + x2**2)

    return np.array([x0*x3, x1*x3, x2*x3, x3*(-m0 + n0), x3*(-m1 + n1), x3*(-m2 + n2)])


def d2q_b(m0, m1, m2, n0, n1, n2):
    """Stretch, 2nd derivative wrt. cartesians"""

    x0 = m0 - n0
    x1 = x0**2
    x2 = m1 - n1
    x3 = x2**2
    x4 = m2 - n2
    x5 = x4**2
    x6 = x1 + x3 + x5
    x7 = 1/math.sqrt(x6)
    x8 = x6**(-3/2)
    x9 = -m0 + n0
    x10 = x8*x9
    x11 = x0*x10 + x7
    x12 = x10*x2
    x13 = x10*x4
    x14 = -x7
    x15 = -m1 + n1
    x16 = x10*x15
    x17 = -m2 + n2
    x18 = x10*x17
    x19 = x15*x8
    x20 = x0*x19
    x21 = x19*x2 + x7
    x22 = x19*x4
    x23 = x17*x19
    x24 = x17*x8
    x25 = x0*x24
    x26 = x2*x24
    x27 = x24*x4 + x7
    x28 = x0*x8
    x29 = x2*x28
    x30 = x28*x4
    x31 = x2*x4*x8

    return np.array([x11, x12, x13, x14 + x8*x9**2, x16, x18, x20, x21, x22, x16, x14 + x15**2*x8, x23, x25, x26, x27, x18, x23, x14 + x17**2*x8, x1*x8 + x14, x29, x30, x11, x20, x25, x29, x14 + x3*x8, x31, x12, x21, x26, x30, x31, x14 + x5*x8, x13, x22, x27])


def dq_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend, first derivative wrt. cartesians"""

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = m1 + x2
    x4 = -o2
    x5 = m2 + x4
    x6 = x1**2 + x3**2 + x5**2
    x7 = n0 + x0
    x8 = n1 + x2
    x9 = n2 + x4
    x10 = x7**2 + x8**2 + x9**2
    x11 = x1*x7 + x3*x8 + x5*x9
    x12 = 1/math.sqrt(1 - x11**2/(x10*x6))
    x13 = 1/math.sqrt(x6)
    x14 = 1/math.sqrt(x10)
    x15 = x13*x14
    x16 = -m0
    x17 = x11*x14/x6**(3/2)
    x18 = -m1
    x19 = -m2
    x20 = -n0
    x21 = x11*x13/x10**(3/2)
    x22 = -n1
    x23 = -n2

    return np.array([-x12*(x15*x7 + x17*(o0 + x16)), -x12*(x15*x8 + x17*(o1 + x18)), -x12*(x15*x9 + x17*(o2 + x19)), -x12*(x1*x17 + x15*(2*o0 + x16 + x20) + x21*x7), -x12*(x15*(2*o1 + x18 + x22) + x17*x3 + x21*x8), -x12*(x15*(2*o2 + x19 + x23) + x17*x5 + x21*x9), -x12*(x1*x15 + x21*(o0 + x20)), -x12*(x15*x3 + x21*(o1 + x22)), -x12*(x15*x5 + x21*(o2 + x23))])


def d2q_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend, 2nd derivative wrt. cartesians"""

    x0 = -o0
    x1 = m0 + x0
    x2 = n0 + x0
    x3 = x1*x2
    x4 = -o1
    x5 = m1 + x4
    x6 = n1 + x4
    x7 = x5*x6
    x8 = -o2
    x9 = m2 + x8
    x10 = n2 + x8
    x11 = x10*x9
    x12 = x11 + x3 + x7
    x13 = x12**2
    x14 = x1**2
    x15 = x5**2
    x16 = x9**2
    x17 = x14 + x15 + x16
    x18 = x17**(-1)
    x19 = x2**2
    x20 = x6**2
    x21 = x10**2
    x22 = x19 + x20 + x21
    x23 = x22**(-1)
    x24 = x18*x23
    x25 = -x13*x24 + 1
    x26 = 1/math.sqrt(x25)
    x27 = -m0
    x28 = o0 + x27
    x29 = 1/math.sqrt(x22)
    x30 = x17**(-3/2)
    x31 = x29*x30
    x32 = x2*x31
    x33 = x12*x31
    x34 = -x33
    x35 = x12*x28
    x36 = 3*m0
    x37 = 3*o0
    x38 = x29/x17**(5/2)
    x39 = x38*(-x36 + x37)
    x40 = 1/math.sqrt(x17)
    x41 = x29*x40
    x42 = x2*x41 + x28*x33
    x43 = x25**(-3/2)
    x44 = 2*n0
    x45 = 2*o0
    x46 = -x45
    x47 = (1/2)*x44 + (1/2)*x46
    x48 = x12*x24
    x49 = 2*m0
    x50 = -x49
    x51 = (1/2)*x13
    x52 = x23*x51/x17**2
    x53 = x43*(x47*x48 + x52*(x45 + x50))
    x54 = -m1
    x55 = o1 + x54
    x56 = x12*x39
    x57 = x28*x31
    x58 = x32*x55 + x57*x6
    x59 = x33*x55 + x41*x6
    x60 = -m2
    x61 = o2 + x60
    x62 = x10*x57 + x32*x61
    x63 = x10*x41 + x33*x61
    x64 = -n0
    x65 = x27 + x45 + x64
    x66 = x22**(-3/2)
    x67 = x40*x66
    x68 = x12*x67
    x69 = x1*x33 + x2*x68 + x41*x65
    x70 = x30*x66
    x71 = x35*x70
    x72 = -x41
    x73 = x33 + x72
    x74 = x19*x67 + x2*x71 + x3*x31 + x57*x65 + x73
    x75 = -n1
    x76 = 2*o1
    x77 = x54 + x75 + x76
    x78 = x2*x67
    x79 = x6*x78
    x80 = x32*x5 + x57*x77 + x6*x71 + x79
    x81 = x33*x5 + x41*x77 + x6*x68
    x82 = -n2
    x83 = 2*o2
    x84 = x60 + x82 + x83
    x85 = x10*x78
    x86 = x10*x71 + x32*x9 + x57*x84 + x85
    x87 = x10*x68 + x33*x9 + x41*x84
    x88 = o0 + x64
    x89 = -x26*(x1*x57 + x41 + x71*x88 + x78*x88)
    x90 = x1*x41 + x68*x88
    x91 = o1 + x75
    x92 = -x26*(x5*x57 + x71*x91 + x78*x91)
    x93 = x41*x5 + x68*x91
    x94 = o2 + x82
    x95 = -x26*(x57*x9 + x71*x94 + x78*x94)
    x96 = x41*x9 + x68*x94
    x97 = 3*m1
    x98 = 3*o1
    x99 = x38*(-x97 + x98)
    x100 = 2*n1
    x101 = -x76
    x102 = x100 + x101
    x103 = (1/2)*x48
    x104 = 2*m1
    x105 = -x104
    x106 = x43*(x102*x103 + x52*(x105 + x76))
    x107 = x31*x6
    x108 = x12*x99
    x109 = x31*x55
    x110 = x10*x109 + x107*x61
    x111 = x12*x55
    x112 = x111*x70
    x113 = x1*x107 + x109*x65 + x112*x2 + x79
    x114 = x109*x77 + x112*x6 + x20*x67 + x31*x7 + x73
    x115 = x6*x67
    x116 = x10*x115
    x117 = x10*x112 + x107*x9 + x109*x84 + x116
    x118 = -x26*(x1*x109 + x112*x88 + x115*x88)
    x119 = -x26*(x109*x5 + x112*x91 + x115*x91 + x41)
    x120 = -x26*(x109*x9 + x112*x94 + x115*x94)
    x121 = 3*m2
    x122 = 3*o2
    x123 = x38*(-x121 + x122)
    x124 = 2*n2
    x125 = -x83
    x126 = x124 + x125
    x127 = 2*m2
    x128 = -x127
    x129 = x43*(x103*x126 + x52*(x128 + x83))
    x130 = x10*x31
    x131 = x12*x123
    x132 = x31*x61
    x133 = x12*x61
    x134 = x133*x70
    x135 = x1*x130 + x132*x65 + x134*x2 + x85
    x136 = x116 + x130*x5 + x132*x77 + x134*x6
    x137 = x10*x134 + x11*x31 + x132*x84 + x21*x67 + x73
    x138 = x10*x67
    x139 = -x26*(x1*x132 + x134*x88 + x138*x88)
    x140 = -x26*(x132*x5 + x134*x91 + x138*x91)
    x141 = -x26*(x132*x9 + x134*x94 + x138*x94 + x41)
    x142 = x46 + x49
    x143 = x18/x22**2
    x144 = -x44
    x145 = x43*(x103*(4*o0 + x144 + x50) + x13*x143*x47 + x142*x52)
    x146 = -x37
    x147 = x38*(x146 + x36)
    x148 = x1*x31
    x149 = 2*x65
    x150 = x12*x147
    x151 = x12*x2
    x152 = 3*n0
    x153 = x40/x22**(5/2)
    x154 = x153*(x146 + x152)
    x155 = x12*x70
    x156 = 2*x155
    x157 = -x68
    x158 = x157 + x34 + 2*x41
    x159 = x12*x6
    x160 = x31*x65
    x161 = x1*x70
    x162 = x151*x70
    x163 = x115*x65 + x148*x77 + x159*x161 + x160*x5 + x162*x5 + x77*x78
    x164 = x10*x12
    x165 = x138*x65 + x148*x84 + x160*x9 + x161*x164 + x162*x9 + x78*x84
    x166 = x12*x88
    x167 = x65*x67
    x168 = x68 + x72
    x169 = x14*x31 + x161*x166 + x167*x88 + x168 + x3*x67
    x170 = x12*x91
    x171 = x148*x5
    x172 = x161*x170 + x167*x91 + x171 + x5*x78
    x173 = x12*x94
    x174 = x148*x9
    x175 = x161*x173 + x167*x94 + x174 + x78*x9
    x176 = -x98
    x177 = x38*(x176 + x97)
    x178 = x101 + x104
    x179 = x143*x51
    x180 = -x100
    x181 = x43*(x102*x179 + x103*(4*o1 + x105 + x180) + x178*x52)
    x182 = x12*x177
    x183 = 3*n1
    x184 = x153*(x176 + x183)
    x185 = x31*x5
    x186 = 2*x77
    x187 = x31*x9
    x188 = x5*x70
    x189 = x70*x9
    x190 = x115*x84 + x138*x77 + x159*x189 + x164*x188 + x185*x84 + x187*x77
    x191 = x67*x77
    x192 = x1*x115 + x166*x188 + x171 + x191*x88
    x193 = x15*x31 + x168 + x170*x188 + x191*x91 + x67*x7
    x194 = x185*x9
    x195 = x5*x94
    x196 = x115*x9 + x155*x195 + x191*x94 + x194
    x197 = -x122
    x198 = x38*(x121 + x197)
    x199 = x125 + x127
    x200 = -x124
    x201 = x43*(x103*(4*o2 + x128 + x200) + x126*x179 + x199*x52)
    x202 = x12*x198
    x203 = 3*n2
    x204 = x153*(x197 + x203)
    x205 = 2*x84
    x206 = x67*x84
    x207 = x1*x138 + x166*x189 + x174 + x206*x88
    x208 = x9*x91
    x209 = x138*x5 + x155*x208 + x194 + x206*x91
    x210 = x11*x67 + x16*x31 + x168 + x173*x189 + x206*x94
    x211 = x43*(x103*x142 + x179*(x144 + x45))
    x212 = x153*(-x152 + x37)
    x213 = x1*x67
    x214 = x67*x88
    x215 = x213*x91 + x214*x5
    x216 = x213*x94 + x214*x9
    x217 = x43*(x103*x178 + x179*(x180 + x76))
    x218 = x153*(-x183 + x98)
    x219 = 2*x67
    x220 = x195*x67 + x208*x67
    x221 = x43*(x103*x199 + x179*(x200 + x83))
    x222 = x153*(x122 - x203)

    return np.array([-x26*(2*x28*x32 + x34 + x35*x39) - x42*x53, -x26*(x55*x56 + x58) - x53*x59, -x26*(x56*x61 + x62) - x53*x63, -x26*(x1*x56 + x74) - x53*x69, -x26*(x5*x56 + x80) - x53*x81, -x26*(x56*x9 + x86) - x53*x87, -x53*x90 + x89, -x53*x93 + x92, -x53*x96 + x95, -x106*x42 - x26*(x35*x99 + x58), -x106*x59 - x26*(2*x107*x55 + x108*x55 + x34), -x106*x63 - x26*(x108*x61 + x110), -x106*x69 - x26*(x1*x108 + x113), -x106*x81 - x26*(x108*x5 + x114), -x106*x87 - x26*(x108*x9 + x117), -x106*x90 + x118, -x106*x93 + x119, -x106*x96 + x120, -x129*x42 - x26*(x123*x35 + x62), -x129*x59 - x26*(x110 + x111*x123), -x129*x63 - x26*(2*x130*x61 + x131*x61 + x34), -x129*x69 - x26*(x1*x131 + x135), -x129*x81 - x26*(x131*x5 + x136), -x129*x87 - x26*(x131*x9 + x137), -x129*x90 + x139, -x129*x93 + x140, -x129*x96 + x141, -x145*x42 - x26*(x147*x35 + x74), -x145*x59 - x26*(x111*x147 + x113), -x145*x63 - x26*(x133*x147 + x135), -x145*x69 - x26*(x1*x150 + x148*x149 + x149*x78 + x151*x154 + x156*x3 + x158), -x145*x81 - x26*(x150*x5 + x154*x159 + x163), -x145*x87 - x26*(x150*x9 + x154*x164 + x165), -x145*x90 - x26*(x154*x166 + x169), -x145*x93 - x26*(x154*x170 + x172), -x145*x96 - x26*(x154*x173 + x175), -x181*x42 - x26*(x177*x35 + x80), -x181*x59 - x26*(x111*x177 + x114), -x181*x63 - x26*(x133*x177 + x136), -x181*x69 - x26*(x1*x182 + x151*x184 + x163), -x181*x81 - x26*(x115*x186 + x156*x7 + x158 + x159*x184 + x182*x5 + x185*x186), -x181*x87 - x26*(x164*x184 + x182*x9 + x190), -x181*x90 - x26*(x166*x184 + x192), -x181*x93 - x26*(x170*x184 + x193), -x181*x96 - x26*(x173*x184 + x196), -x201*x42 - x26*(x198*x35 + x86), -x201*x59 - x26*(x111*x198 + x117), -x201*x63 - x26*(x133*x198 + x137), -x201*x69 - x26*(x1*x202 + x151*x204 + x165), -x201*x81 - x26*(x159*x204 + x190 + x202*x5), -x201*x87 - x26*(x11*x156 + x138*x205 + x158 + x164*x204 + x187*x205 + x202*x9), -x201*x90 - x26*(x166*x204 + x207), -x201*x93 - x26*(x170*x204 + x209), -x201*x96 - x26*(x173*x204 + x210), -x211*x42 + x89, x118 - x211*x59, x139 - x211*x63, -x211*x69 - x26*(x151*x212 + x169), -x211*x81 - x26*(x159*x212 + x192), -x211*x87 - x26*(x164*x212 + x207), -x211*x90 - x26*(x157 + x166*x212 + 2*x213*x88), -x211*x93 - x26*(x170*x212 + x215), -x211*x96 - x26*(x173*x212 + x216), -x217*x42 + x92, x119 - x217*x59, x140 - x217*x63, -x217*x69 - x26*(x151*x218 + x172), -x217*x81 - x26*(x159*x218 + x193), -x217*x87 - x26*(x164*x218 + x209), -x217*x90 - x26*(x166*x218 + x215), -x217*x93 - x26*(x157 + x170*x218 + x219*x5*x91), -x217*x96 - x26*(x173*x218 + x220), -x221*x42 + x95, x120 - x221*x59, x141 - x221*x63, -x221*x69 - x26*(x151*x222 + x175), -x221*x81 - x26*(x159*x222 + x196), -x221*x87 - x26*(x164*x222 + x210), -x221*x90 - x26*(x166*x222 + x216), -x221*x93 - x26*(x170*x222 + x220), -x221*x96 - x26*(x157 + x173*x222 + x219*x9*x94)])


def dq_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion, first derivative wrt. cartesians"""

    x0 = -o0
    x1 = m0 + x0
    x2 = p0 + x0
    x3 = x1**2
    x4 = -o1
    x5 = m1 + x4
    x6 = x5**2
    x7 = -o2
    x8 = m2 + x7
    x9 = x8**2
    x10 = x3 + x6 + x9
    x11 = 1/math.sqrt(x10)
    x12 = x2**2
    x13 = p1 + x4
    x14 = x13**2
    x15 = p2 + x7
    x16 = x15**2
    x17 = x12 + x14 + x16
    x18 = 1/math.sqrt(x17)
    x19 = x11*x18
    x20 = x19*x2
    x21 = x13*x19
    x22 = x15*x19
    x23 = x1*x20 + x21*x5 + x22*x8
    x24 = 1 - x23**2
    x25 = -p0
    x26 = n0 + x25
    x27 = x26**2
    x28 = -p1
    x29 = n1 + x28
    x30 = x29**2
    x31 = -p2
    x32 = n2 + x31
    x33 = x32**2
    x34 = x27 + x30 + x33
    x35 = 1/math.sqrt(x34)
    x36 = x18*x35
    x37 = x26*x36
    x38 = x29*x36
    x39 = x32*x36
    x40 = -x13*x38 - x15*x39 - x2*x37
    x41 = 1 - x40**2
    x42 = x1*x21 - x20*x5
    x43 = x13*x37 - x2*x38
    x44 = -x1*x22 + x20*x8
    x45 = -x15*x37 + x2*x39
    x46 = -x21*x8 + x22*x5
    x47 = -x13*x39 + x15*x38
    x48 = x42*x43 + x44*x45 + x46*x47
    x49 = 1/math.sqrt(1 - x48**2/(x24*x41))
    x50 = x18/x10**(3/2)
    x51 = x50*(-m0 + o0)
    x52 = x5*x51
    x53 = x51*x8
    x54 = x1*x13
    x55 = -x22
    x56 = x1*x15
    x57 = 1/math.sqrt(x24)
    x58 = 1/math.sqrt(x41)
    x59 = x57*x58
    x60 = 2*x20
    x61 = x1*x2
    x62 = 2*x61
    x63 = 2*x13
    x64 = 2*x15
    x65 = (1/2)*x48
    x66 = x23*x58*x65/x24**(3/2)
    x67 = x50*(-m1 + o1)
    x68 = x67*x8
    x69 = x5*x67
    x70 = -x20
    x71 = 2*x21
    x72 = x50*(-m2 + o2)
    x73 = x5*x72
    x74 = x72*x8
    x75 = -x21
    x76 = 2*x22
    x77 = 2*x37
    x78 = x17**(-3/2)
    x79 = x12*x78
    x80 = x35*x79
    x81 = 2*x26
    x82 = x2*x78
    x83 = x35*x82
    x84 = x13*x83
    x85 = x29*x84
    x86 = x15*x83
    x87 = x32*x86
    x88 = x40*x57*x65/x41**(3/2)
    x89 = x1*x19
    x90 = 2*x89
    x91 = x11*x79
    x92 = 2*x1
    x93 = x3*x50
    x94 = 2*x2
    x95 = x5*x50
    x96 = x54*x95
    x97 = x50*x8
    x98 = x56*x97
    x99 = x11*x82
    x100 = x5*x99
    x101 = x100*x13
    x102 = x8*x99
    x103 = x102*x15
    x104 = x29*x86
    x105 = x32*x84
    x106 = x13*x26
    x107 = x106*x83
    x108 = -x39
    x109 = x26*x86
    x110 = x56*x95
    x111 = x100*x15
    x112 = x54*x97
    x113 = x13*x8
    x114 = x113*x99
    x115 = x19*x5
    x116 = x54*x99
    x117 = x61*x95
    x118 = x19*x8
    x119 = -x118
    x120 = x61*x97
    x121 = x56*x99
    x122 = 2*x38
    x123 = x14*x78
    x124 = x123*x35
    x125 = 2*x29
    x126 = x15*x78
    x127 = x126*x35
    x128 = 2*x115
    x129 = x11*x123
    x130 = x50*x6
    x131 = x8*x95
    x132 = x131*x15
    x133 = x11*x126
    x134 = x113*x133
    x135 = x106*x127
    x136 = x13*x29
    x137 = x127*x136
    x138 = -x37
    x139 = x131*x2
    x140 = x133*x54
    x141 = -x89
    x142 = x133*x5
    x143 = x13*x142
    x144 = x113*x95
    x145 = 2*x39
    x146 = x16*x78
    x147 = x146*x35
    x148 = 2*x32
    x149 = 2*x118
    x150 = x11*x146
    x151 = 2*x8
    x152 = x50*x9
    x153 = -x38
    x154 = x13*x32
    x155 = -x115
    x156 = o0 + x25
    x157 = x92*x99
    x158 = x156*x78
    x159 = x11*x158
    x160 = x5*x63
    x161 = x133*x151
    x162 = x2*x36
    x163 = 2*x162
    x164 = x18/x34**(3/2)
    x165 = x164*x27
    x166 = x164*x32
    x167 = x15*x166
    x168 = x81*x83
    x169 = x158*x35
    x170 = 2*x136
    x171 = x127*x148
    x172 = x164*x29
    x173 = x172*x26
    x174 = x15*x173
    x175 = x156*x29
    x176 = x106*x166
    x177 = x15*x36
    x178 = x166*x26
    x179 = x32*x83
    x180 = x127*x26
    x181 = x13*x36
    x182 = -x181
    x183 = o1 + x28
    x184 = x183*x78
    x185 = x11*x184
    x186 = 2*x181
    x187 = x164*x30
    x188 = x184*x35
    x189 = x172*x32
    x190 = x189*x2
    x191 = x183*x29
    x192 = -x177
    x193 = o2 + x31
    x194 = x193*x78
    x195 = x11*x194
    x196 = 2*x177
    x197 = x164*x33
    x198 = x194*x35
    x199 = x193*x29
    x200 = -x162
    x201 = -n0 + p0
    x202 = x172*x201
    x203 = x164*x201
    x204 = x166*x2
    x205 = x15*x26
    x206 = x26*x94
    x207 = x166*x64
    x208 = -n1 + p1
    x209 = x164*x208
    x210 = x172*x208
    x211 = -n2 + p2
    x212 = x164*x211
    x213 = x172*x211

    return np.array([-x49*(x59*(x43*(-x2*x52 + x21 + x51*x54) + x45*(x2*x53 - x51*x56 + x55) + x47*(-x13*x53 + x15*x52)) + x66*(x51*x62 + x52*x63 + x53*x64 + x60)), -x49*(x59*(x43*(-x2*x69 + x54*x67 + x70) + x45*(x2*x68 - x56*x67) + x47*(-x13*x68 + x15*x69 + x22)) + x66*(x62*x67 + x63*x69 + x64*x68 + x71)), -x49*(x59*(x43*(-x2*x73 + x54*x72) + x45*(x2*x74 + x20 - x56*x72) + x47*(-x13*x74 + x15*x73 + x75)) + x66*(x62*x72 + x63*x73 + x64*x74 + x76)), -x49*(x59*(x42*(x107 - x29*x80 + x38) + x43*(x115 + x116 - x117 + x13*x93 - x5*x91 + x75) + x44*(x108 - x109 + x32*x80) + x45*(x119 + x120 - x121 - x15*x93 + x22 + x8*x91) + x46*(x104 - x105) + x47*(x110 + x111 - x112 - x114)) + x66*(2*x101 + 2*x103 - x60 - x90 + x91*x92 + x93*x94 + 2*x96 + 2*x98) + x88*(x77 - x80*x81 - 2*x85 - 2*x87)), -x49*(x59*(x42*(x124*x26 + x138 - x85) + x43*(x1*x129 - x101 - x130*x2 + x141 + x20 + x96) + x44*(x105 - x135) + x45*(-x110 + x114 + x139 - x140) + x46*(-x124*x32 + x137 + x39) + x47*(x118 - x129*x8 + x130*x15 + x143 - x144 + x55)) + x66*(2*x116 + 2*x117 - x128 + 2*x129*x5 + x130*x63 + 2*x132 + 2*x134 - x71) + x88*(-2*x107 + x122 - x124*x125 - x127*x32*x63)), -x49*(x59*(x42*(-x104 + x135) + x43*(-x111 + x112 - x139 + x140) + x44*(-x147*x26 + x37 + x87) + x45*(-x1*x150 + x103 + x152*x2 + x70 + x89 - x98) + x46*(-x127*x154 + x147*x29 + x153) + x47*(-x13*x152 + x132 - x134 + x150*x5 + x155 + x21)) + x66*(2*x120 + 2*x121 + 2*x143 + 2*x144 - x149 + x150*x151 + x152*x64 - x76) + x88*(-2*x109 - 2*x137 + x145 - x147*x148)), -x49*(x59*(x42*(x106*x169 + x13*x165 + x153 - x173*x2 - x175*x83 + x182) + x43*(-x100*x156 + x155 + x159*x54) + x44*(-x15*x165 + x156*x179 - x156*x180 + x177 + x178*x2 + x39) + x45*(x102*x156 + x118 - x159*x56) + x46*(x127*x175 - x154*x169 + x174 - x176) + x47*(-x113*x159 + x142*x156)) + x66*(x156*x157 + x156*x161 + x159*x160 + x90) + x88*(-x106*x125*x164 - x156*x168 - x156*x171 + x163 - x165*x94 - x167*x81 - x169*x170 - x77)), -x49*(x59*(x42*(x106*x172 + x106*x188 + x162 - x187*x2 - x191*x83 + x37) + x43*(-x100*x183 + x185*x54 + x89) + x44*(-x174 + x179*x183 - x180*x183 + x190) + x45*(x102*x183 - x185*x56) + x46*(x108 + x127*x191 - x136*x166 + x15*x187 - x154*x188 + x192) + x47*(-x113*x185 + x119 + x142*x183)) + x66*(x128 + x157*x183 + x160*x185 + x161*x183) + x88*(-x122 - x125*x167 - x168*x183 - x170*x188 - x171*x183 - x173*x94 + x186 - x187*x63)), -x49*(x59*(x42*(x106*x198 + x176 - x190 - x199*x83) + x43*(-x100*x193 + x195*x54) + x44*(x138 - x15*x178 + x179*x193 - x180*x193 + x197*x2 + x200) + x45*(x102*x193 + x141 - x195*x56) + x46*(x127*x199 - x13*x197 + x15*x189 - x154*x198 + x181 + x38) + x47*(-x113*x195 + x115 + x142*x193)) + x66*(x149 + x157*x193 + x160*x195 + x161*x193) + x88*(-x136*x148*x164 - x145 - x168*x193 - x170*x198 - x171*x193 - x178*x94 + x196 - x197*x64)), -x49*(x59*(x42*(x106*x203 + x181 - x2*x202) + x44*(x192 + x201*x204 - x203*x205) + x46*(x15*x202 - x154*x203)) + x88*(-x163 - x170*x203 - x201*x207 - x203*x206)), -x49*(x59*(x42*(x106*x209 - x2*x210 + x200) + x44*(x204*x208 - x205*x209) + x46*(x15*x210 - x154*x209 + x177)) + x88*(-x170*x209 - x186 - x206*x209 - x207*x208)), -x49*(x59*(x42*(x106*x212 - x2*x213) + x44*(x162 + x204*x211 - x205*x212) + x46*(x15*x213 - x154*x212 + x182)) + x88*(-x170*x212 - x196 - x206*x212 - x207*x211))])


def d2q_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion, 2nd derivative wrt. cartesians"""

    x0 = -o2
    x1 = p2 + x0
    x2 = -p1
    x3 = n1 + x2
    x4 = -p0
    x5 = n0 + x4
    x6 = x5**2
    x7 = x3**2
    x8 = -p2
    x9 = n2 + x8
    x10 = x9**2
    x11 = x10 + x6 + x7
    x12 = 1/math.sqrt(x11)
    x13 = -o0
    x14 = p0 + x13
    x15 = x14**2
    x16 = -o1
    x17 = p1 + x16
    x18 = x17**2
    x19 = x1**2
    x20 = x15 + x18 + x19
    x21 = 1/math.sqrt(x20)
    x22 = x12*x21
    x23 = x22*x3
    x24 = x22*x9
    x25 = x1*x23 - x17*x24
    x26 = -m0 + o0
    x27 = m1 + x16
    x28 = m0 + x13
    x29 = x28**2
    x30 = x27**2
    x31 = m2 + x0
    x32 = x31**2
    x33 = x29 + x30 + x32
    x34 = x33**(-3/2)
    x35 = x21*x34
    x36 = x27*x35
    x37 = x1*x36
    x38 = x17*x35
    x39 = x31*x38
    x40 = x26*x37 - x26*x39
    x41 = x25*x40
    x42 = x22*x5
    x43 = -x14*x23 + x17*x42
    x44 = 1/math.sqrt(x33)
    x45 = x21*x44
    x46 = x17*x45
    x47 = x28*x38
    x48 = x14*x36
    x49 = x26*x47 - x26*x48 + x46
    x50 = x43*x49
    x51 = -x1*x42 + x14*x24
    x52 = x1*x45
    x53 = -x52
    x54 = x14*x35
    x55 = x31*x54
    x56 = x1*x35
    x57 = x28*x56
    x58 = x26*x55 - x26*x57 + x53
    x59 = x51*x58
    x60 = x41 + x50 + x59
    x61 = x14*x45
    x62 = x27*x46 + x28*x61 + x31*x52
    x63 = x62**2
    x64 = 1 - x63
    x65 = 1/math.sqrt(x64)
    x66 = -x1*x24 - x14*x42 - x17*x23
    x67 = x66**2
    x68 = 1 - x67
    x69 = 1/math.sqrt(x68)
    x70 = x65*x69
    x71 = 2*x61
    x72 = x26*x54
    x73 = x28*x72
    x74 = x26*x36
    x75 = x17*x74
    x76 = x26*x56
    x77 = 2*x76
    x78 = x31*x77 + x71 + 2*x73 + 2*x75
    x79 = x62*x78
    x80 = x64**(-3/2)
    x81 = x69*x80
    x82 = x79*x81
    x83 = -x27*x61 + x28*x46
    x84 = -x28*x52 + x31*x61
    x85 = x27*x52 - x31*x46
    x86 = x25*x85 + x43*x83 + x51*x84
    x87 = (1/2)*x86
    x88 = x60*x70 + x82*x87
    x89 = x86**2
    x90 = x64**(-1)
    x91 = x68**(-1)
    x92 = x90*x91
    x93 = -x89*x92 + 1
    x94 = x93**(-3/2)
    x95 = (1/2)*x89
    x96 = x91*x95/x64**2
    x97 = x87*x92
    x98 = x94*(x79*x96 + x97*(2*x41 + 2*x50 + 2*x59))
    x99 = 1/math.sqrt(x93)
    x100 = (3/4)*x86
    x101 = x100*x63*x69/x64**(5/2)
    x102 = x81*x87
    x103 = x102*(x31*x76 + x61 + x73 + x75)
    x104 = 3*m0
    x105 = 3*o0
    x106 = x21/x33**(5/2)
    x107 = x106*(-x104 + x105)
    x108 = x107*x26
    x109 = x108*x27
    x110 = x108*x31
    x111 = -x37
    x112 = x111 + x39
    x113 = x26*x38
    x114 = 2*x113
    x115 = x17*x28
    x116 = -x47
    x117 = x116 + x48
    x118 = -x77
    x119 = x1*x28
    x120 = -x55
    x121 = x120 + x57
    x122 = 2*x14
    x123 = x122*x28
    x124 = 2*x17
    x125 = 2*x1
    x126 = x28*x54
    x127 = 2*x126
    x128 = x17*x36
    x129 = 2*x128
    x130 = x31*x56
    x131 = 2*x130
    x132 = -x127 - x129 - x131
    x133 = x62*x81
    x134 = x133*x87
    x135 = -m1 + o1
    x136 = x135*x55 - x135*x57
    x137 = x136*x51
    x138 = x135*x37 - x135*x39 + x52
    x139 = x138*x25
    x140 = -x61
    x141 = x135*x47 - x135*x48 + x140
    x142 = x141*x43
    x143 = x137 + x139 + x142
    x144 = 2*x46
    x145 = x135*x54
    x146 = 2*x145
    x147 = x135*x56
    x148 = x147*x31
    x149 = x129*x135 + x144 + x146*x28 + 2*x148
    x150 = x133*x149
    x151 = x143*x70 + x150*x87
    x152 = x107*x135
    x153 = x152*x27
    x154 = x152*x31
    x155 = -x147
    x156 = x135*x38
    x157 = -x72
    x158 = x156 + x157
    x159 = x114 + x146
    x160 = (1/2)*x60
    x161 = (1/2)*x82
    x162 = x101*x78
    x163 = x143*x161 + x149*x162 + x150*x160
    x164 = -m2 + o2
    x165 = x164*x47 - x164*x48
    x166 = x165*x43
    x167 = x164*x55 - x164*x57 + x61
    x168 = x167*x51
    x169 = -x46
    x170 = x164*x37 - x164*x39 + x169
    x171 = x170*x25
    x172 = x166 + x168 + x171
    x173 = 2*x52
    x174 = x164*x54
    x175 = 2*x174
    x176 = x164*x56
    x177 = x176*x31
    x178 = x129*x164 + x173 + x175*x28 + 2*x177
    x179 = x133*x178
    x180 = x172*x70 + x179*x87
    x181 = x164*x38
    x182 = x107*x164
    x183 = x182*x27
    x184 = -x113
    x185 = x182*x31
    x186 = -x176
    x187 = x186 + x72
    x188 = x175 + x77
    x189 = x160*x179 + x161*x172 + x162*x178
    x190 = 2*x42
    x191 = x20**(-3/2)
    x192 = x12*x191
    x193 = x15*x192
    x194 = x193*x5
    x195 = x192*x3
    x196 = x14*x195
    x197 = x17*x196
    x198 = x192*x9
    x199 = x14*x198
    x200 = x1*x199
    x201 = x190 - 2*x194 - 2*x197 - 2*x200
    x202 = x201*x66
    x203 = x68**(-3/2)
    x204 = x203*x65
    x205 = x202*x204
    x206 = 2*x45
    x207 = x206*x28
    x208 = x191*x44
    x209 = x15*x208
    x210 = 2*x209
    x211 = x29*x35
    x212 = x14*x211
    x213 = x31*x57
    x214 = x14*x208
    x215 = x17*x214
    x216 = 2*x215
    x217 = x1*x214
    x218 = 2*x217
    x219 = x129*x28 - x207 + x210*x28 + 2*x212 + 2*x213 + x216*x27 + x218*x31 - x71
    x220 = x133*x219
    x221 = x1*x196
    x222 = x17*x192
    x223 = x222*x9
    x224 = x14*x223
    x225 = x221 - x224
    x226 = x225*x85
    x227 = x222*x5
    x228 = x14*x227
    x229 = -x193*x3 + x228 + x23
    x230 = x229*x83
    x231 = -x24
    x232 = x192*x5
    x233 = x1*x232
    x234 = x14*x233
    x235 = -x234
    x236 = x193*x9 + x231 + x235
    x237 = x236*x84
    x238 = x28*x37
    x239 = x217*x27
    x240 = x31*x47
    x241 = x215*x31
    x242 = x238 + x239 - x240 - x241
    x243 = x242*x25
    x244 = x27*x45
    x245 = x28*x48
    x246 = x215*x28
    x247 = x169 + x246
    x248 = x17*x211 - x209*x27 + x244 - x245 + x247
    x249 = x248*x43
    x250 = x217*x28
    x251 = x31*x45
    x252 = -x251
    x253 = x28*x55
    x254 = x252 + x253
    x255 = -x1*x211 + x209*x31 - x250 + x254 + x52
    x256 = x255*x51
    x257 = x226 + x230 + x237 + x243 + x249 + x256
    x258 = x205*x87 + x220*x87 + x257*x70
    x259 = 2*m0
    x260 = 2*o0
    x261 = -x260
    x262 = x259 + x261
    x263 = x107*x29
    x264 = x27*x28
    x265 = x107*x264
    x266 = x14*x265
    x267 = -x48
    x268 = x191*x34
    x269 = x15*x268
    x270 = x26*x269
    x271 = x14*x268
    x272 = x26*x271
    x273 = x115*x272
    x274 = x184 + x215 + x267 - x27*x270 + x273 + x74
    x275 = x1*x265
    x276 = x28*x31
    x277 = x107*x276
    x278 = x17*x277
    x279 = -x39
    x280 = x27*x272
    x281 = x1*x280
    x282 = x17*x31
    x283 = x272*x282
    x284 = x279 + x281 - x283 + x37
    x285 = -x259 + x260
    x286 = x14*x277
    x287 = x26*x35
    x288 = x287*x31
    x289 = -x288
    x290 = -x217
    x291 = x119*x272
    x292 = x270*x31 + x289 + x290 - x291 + x55 + x76
    x293 = x225*x40 + x229*x49 + x236*x58
    x294 = 4*m0
    x295 = 4*o0
    x296 = -x295
    x297 = x17*x265
    x298 = x1*x277
    x299 = x28*x287
    x300 = 2*x299
    x301 = 2*x28
    x302 = x17*x280
    x303 = x272*x31
    x304 = x1*x303
    x305 = -x206
    x306 = x131 + x305
    x307 = x129 + x210 + x270*x301 - x300 + 2*x302 + 2*x304 + x306 - 2*x72
    x308 = x203*x80
    x309 = x202*x308
    x310 = (1/4)*x86
    x311 = x310*x79
    x312 = x160*x205 + x160*x220 + x161*x257 + x162*x219 + x309*x311
    x313 = 2*x23
    x314 = x18*x192
    x315 = x3*x314
    x316 = x1*x223
    x317 = -2*x228 + x313 - 2*x315 - 2*x316
    x318 = x204*x66
    x319 = x317*x318
    x320 = x206*x27
    x321 = x18*x208
    x322 = 2*x321
    x323 = x30*x35
    x324 = x17*x323
    x325 = x31*x37
    x326 = x17*x208
    x327 = x1*x326
    x328 = x31*x327
    x329 = -x144 + 2*x245 + 2*x246 + x27*x322 - x320 + 2*x324 + 2*x325 + 2*x328
    x330 = x133*x329
    x331 = x1*x227
    x332 = x224 - x331
    x333 = x332*x84
    x334 = x1*x195
    x335 = x17*x334
    x336 = x24 - x314*x9 + x335
    x337 = x336*x85
    x338 = -x42
    x339 = -x197
    x340 = x314*x5 + x338 + x339
    x341 = x340*x83
    x342 = x31*x48
    x343 = x28*x327
    x344 = -x238 + x241 + x342 - x343
    x345 = x344*x51
    x346 = x215*x27
    x347 = x28*x45
    x348 = -x347
    x349 = x128*x28 + x348
    x350 = -x14*x323 + x28*x321 - x346 + x349 + x61
    x351 = x350*x43
    x352 = x128*x31
    x353 = x27*x327
    x354 = x353 + x53
    x355 = x1*x323 + x251 - x31*x321 - x352 + x354
    x356 = x25*x355
    x357 = x333 + x337 + x341 + x345 + x351 + x356
    x358 = x319*x87 + x330*x87 + x357*x70
    x359 = x107*x30
    x360 = x18*x268
    x361 = x26*x360
    x362 = -x45
    x363 = -x299 + x362
    x364 = x128 + x321
    x365 = x28*x361 - x302 + x363 + x364 + x72
    x366 = x27*x31
    x367 = x107*x366
    x368 = x17*x367
    x369 = x26*x268
    x370 = x1*x27
    x371 = x17*x370
    x372 = x369*x371
    x373 = x288 - x31*x361 + x372 - x76
    x374 = x14*x367
    x375 = -x327
    x376 = x1*x369
    x377 = x115*x376
    x378 = x111 + x283 + x375 - x377
    x379 = x332*x58 + x336*x40 + x340*x49
    x380 = x1*x367
    x381 = 2*x74
    x382 = 2*x48
    x383 = 2*x27
    x384 = x282*x376
    x385 = -x114 + x216 + 2*x273 + x361*x383 - x381 + x382 + 2*x384
    x386 = x308*x66
    x387 = x311*x386
    x388 = x160*x319 + x160*x330 + x161*x357 + x162*x329 + x317*x387
    x389 = 2*x24
    x390 = x19*x192
    x391 = x390*x9
    x392 = -2*x234 - 2*x335 + x389 - 2*x391
    x393 = x318*x392
    x394 = x206*x31
    x395 = x19*x208
    x396 = 2*x395
    x397 = x32*x35
    x398 = x1*x397
    x399 = x129*x31 - x173 + 2*x250 + 2*x253 + x31*x396 + 2*x353 - x394 + 2*x398
    x400 = x133*x399
    x401 = -x221 + x331
    x402 = x401*x83
    x403 = x200 - x390*x5 + x42
    x404 = x403*x84
    x405 = -x23
    x406 = -x316
    x407 = x3*x390 + x405 + x406
    x408 = x407*x85
    x409 = -x239 + x240 - x342 + x343
    x410 = x409*x43
    x411 = x140 + x217*x31
    x412 = x14*x397 - x213 - x28*x395 + x347 + x411
    x413 = x412*x51
    x414 = -x244
    x415 = x325 + x414
    x416 = -x17*x397 + x27*x395 - x328 + x415 + x46
    x417 = x25*x416
    x418 = x402 + x404 + x408 + x410 + x413 + x417
    x419 = x393*x87 + x400*x87 + x418*x70
    x420 = -x281 + x327 + x377 + x39
    x421 = x107*x32
    x422 = -x74
    x423 = x19*x268
    x424 = x26*x423
    x425 = x113 + x27*x424 - x384 + x422
    x426 = x299 + x45
    x427 = -x130 - x395
    x428 = x157 - x28*x424 + x304 + x426 + x427
    x429 = x40*x407 + x401*x49 + x403*x58
    x430 = 2*x55
    x431 = 2*x288
    x432 = 2*x31
    x433 = x118 + x218 + 2*x291 + 2*x372 + x424*x432 + x430 - x431
    x434 = x160*x393 + x160*x400 + x161*x418 + x162*x399 + x387*x392
    x435 = o0 + x4
    x436 = x214*x435
    x437 = 2*x436
    x438 = x326*x435
    x439 = 2*x438
    x440 = x1*x208
    x441 = x435*x440
    x442 = 2*x441
    x443 = x207 + x27*x439 + x28*x437 + x31*x442
    x444 = x133*x443
    x445 = x14*x22
    x446 = 2*x445
    x447 = x11**(-3/2)
    x448 = x21*x447
    x449 = x448*x6
    x450 = 2*x449
    x451 = x448*x5
    x452 = x3*x451
    x453 = x17*x452
    x454 = x451*x9
    x455 = x1*x454
    x456 = x14*x232
    x457 = 2*x456
    x458 = x17*x195
    x459 = 2*x458
    x460 = x1*x198
    x461 = 2*x460
    x462 = -x14*x450 - x190 - x435*x457 - x435*x459 - x435*x461 + x446 - 2*x453 - 2*x455
    x463 = x318*x462
    x464 = x27*x441 - x31*x438
    x465 = x25*x464
    x466 = x251 - x28*x441 + x31*x436
    x467 = x466*x51
    x468 = -x27*x436 + x28*x438 + x414
    x469 = x43*x468
    x470 = x1*x452
    x471 = x17*x454
    x472 = -x223*x435 + x334*x435 + x470 - x471
    x473 = x472*x85
    x474 = x1*x22
    x475 = x14*x454
    x476 = -x1*x449 + x199*x435 - x233*x435 + x24 + x474 + x475
    x477 = x476*x84
    x478 = x17*x22
    x479 = -x478
    x480 = x14*x452
    x481 = x405 - x480
    x482 = x17*x449 - x196*x435 + x227*x435 + x479 + x481
    x483 = x482*x83
    x484 = x465 + x467 + x469 + x473 + x477 + x483
    x485 = x444*x87 + x463*x87 + x484*x70
    x486 = x369*x435
    x487 = -x441
    x488 = x272*x301
    x489 = x124*x27
    x490 = x376*x432
    x491 = x134*(x206 + x300 + x435*x488 + x435*x490 + x437 + x486*x489) + x160*x444 + x160*x463 + x161*x484 + x162*x443 + x387*x462 + x70*(x25*(-x282*x486 + x370*x486) + x40*x472 + x43*(x115*x486 - x280*x435 + x422 + x438) + x476*x58 + x482*x49 + x51*(-x119*x486 + x288 + x303*x435 + x487))
    x492 = o1 + x2
    x493 = x214*x492
    x494 = 2*x493
    x495 = x326*x492
    x496 = 2*x495
    x497 = x440*x492
    x498 = 2*x497
    x499 = x27*x496 + x28*x494 + x31*x498 + x320
    x500 = x133*x499
    x501 = 2*x478
    x502 = x448*x7
    x503 = 2*x502
    x504 = x3*x448
    x505 = x504*x9
    x506 = x1*x505
    x507 = -x17*x503 - x313 - x457*x492 - x459*x492 - x461*x492 - 2*x480 + x501 - 2*x506
    x508 = x318*x507
    x509 = -x28*x497 + x31*x493
    x510 = x509*x51
    x511 = -x27*x493 + x28*x495 + x347
    x512 = x43*x511
    x513 = x252 + x27*x497 - x31*x495
    x514 = x25*x513
    x515 = x14*x505
    x516 = x199*x492 - x233*x492 - x470 + x515
    x517 = x516*x84
    x518 = -x14*x502 - x196*x492 + x227*x492 + x42 + x445 + x453
    x519 = x518*x83
    x520 = -x474
    x521 = x17*x505
    x522 = x231 - x521
    x523 = x1*x502 - x223*x492 + x334*x492 + x520 + x522
    x524 = x523*x85
    x525 = x510 + x512 + x514 + x517 + x519 + x524
    x526 = x500*x87 + x508*x87 + x525*x70
    x527 = -x497
    x528 = x369*x492
    x529 = x134*(x381 + x488*x492 + x489*x528 + x490*x492 + x494) + x160*x500 + x160*x508 + x161*x525 + x162*x499 + x387*x507 + x70*(x25*(-x282*x528 + x289 + x370*x528) + x40*x523 + x43*(x115*x528 - x280*x492 + x426 + x495) + x49*x518 + x51*(-x119*x528 + x303*x492 + x527) + x516*x58)
    x530 = o2 + x8
    x531 = x214*x530
    x532 = 2*x531
    x533 = x326*x530
    x534 = 2*x533
    x535 = x440*x530
    x536 = 2*x535
    x537 = x27*x534 + x28*x532 + x31*x536 + x394
    x538 = x133*x537
    x539 = 2*x474
    x540 = x10*x448
    x541 = 2*x540
    x542 = -x1*x541 - x389 - x457*x530 - x459*x530 - x461*x530 - 2*x475 - 2*x521 + x539
    x543 = x318*x542
    x544 = -x27*x531 + x28*x533
    x545 = x43*x544
    x546 = x244 + x27*x535 - x31*x533
    x547 = x25*x546
    x548 = -x28*x535 + x31*x531 + x348
    x549 = x51*x548
    x550 = -x196*x530 + x227*x530 + x471 - x515
    x551 = x550*x83
    x552 = -x17*x540 - x223*x530 + x23 + x334*x530 + x478 + x506
    x553 = x552*x85
    x554 = -x445
    x555 = x338 - x455
    x556 = x14*x540 + x199*x530 - x233*x530 + x554 + x555
    x557 = x556*x84
    x558 = x545 + x547 + x549 + x551 + x553 + x557
    x559 = x538*x87 + x543*x87 + x558*x70
    x560 = x369*x530
    x561 = -x535
    x562 = x134*(x431 + x488*x530 + x489*x560 + x490*x530 + x532) + x160*x538 + x160*x543 + x161*x558 + x162*x537 + x387*x542 + x70*(x25*(-x282*x560 + x370*x560 + x74) + x40*x552 + x43*(x115*x560 - x280*x530 + x533) + x49*x550 + x51*(-x119*x560 + x303*x530 + x363 + x561) + x556*x58)
    x563 = -n0 + p0
    x564 = x504*x563
    x565 = x448*x9
    x566 = x563*x565
    x567 = x1*x564 - x17*x566
    x568 = x567*x85
    x569 = x451*x563
    x570 = -x14*x564 + x17*x569 + x478
    x571 = x570*x83
    x572 = -x1*x569 + x14*x566 + x520
    x573 = x572*x84
    x574 = x568 + x571 + x573
    x575 = 2*x569
    x576 = 2*x564
    x577 = 2*x566
    x578 = -x1*x577 - x14*x575 - x17*x576 - x446
    x579 = x318*x578
    x580 = x574*x70 + x579*x87
    x581 = -x99*(x160*x579 + x161*x574 + x387*x578 + x70*(x40*x567 + x49*x570 + x572*x58))
    x582 = -n1 + p1
    x583 = x565*x582
    x584 = x451*x582
    x585 = -x1*x584 + x14*x583
    x586 = x585*x84
    x587 = x504*x582
    x588 = x1*x587 - x17*x583 + x474
    x589 = x588*x85
    x590 = -x14*x587 + x17*x584 + x554
    x591 = x590*x83
    x592 = x586 + x589 + x591
    x593 = 2*x584
    x594 = 2*x587
    x595 = 2*x583
    x596 = -x1*x595 - x14*x593 - x17*x594 - x501
    x597 = x318*x596
    x598 = x592*x70 + x597*x87
    x599 = -x99*(x160*x597 + x161*x592 + x387*x596 + x70*(x40*x588 + x49*x590 + x58*x585))
    x600 = -n2 + p2
    x601 = x451*x600
    x602 = x504*x600
    x603 = -x14*x602 + x17*x601
    x604 = x603*x83
    x605 = x565*x600
    x606 = -x1*x601 + x14*x605 + x445
    x607 = x606*x84
    x608 = x1*x602 - x17*x605 + x479
    x609 = x608*x85
    x610 = x604 + x607 + x609
    x611 = 2*x601
    x612 = 2*x602
    x613 = 2*x605
    x614 = -x1*x613 - x14*x611 - x17*x612 - x539
    x615 = x318*x614
    x616 = x610*x70 + x615*x87
    x617 = -x99*(x160*x615 + x161*x610 + x387*x614 + x70*(x40*x608 + x49*x603 + x58*x606))
    x618 = x62*x96
    x619 = x94*(x149*x618 + x97*(2*x137 + 2*x139 + 2*x142))
    x620 = 3*m1
    x621 = 3*o1
    x622 = x106*(-x620 + x621)
    x623 = x26*x622
    x624 = x14*x623
    x625 = x125*x31
    x626 = x102*(x128*x135 + x145*x28 + x148 + x46)
    x627 = x135*x622
    x628 = x14*x627
    x629 = -x146
    x630 = 2*x147
    x631 = x164*x622
    x632 = x14*x631
    x633 = -x174
    x634 = -x156
    x635 = x176 + x634
    x636 = 2*x181
    x637 = x630 + x636
    x638 = (1/2)*x150
    x639 = (1/2)*x143
    x640 = x101*x149
    x641 = x172*x638 + x178*x640 + x179*x639
    x642 = x29*x622
    x643 = x264*x622
    x644 = x135*x269
    x645 = x135*x271
    x646 = x115*x645
    x647 = x135*x36
    x648 = x45 + x647
    x649 = -x126 - x209
    x650 = -x27*x644 + x634 + x646 + x648 + x649
    x651 = x1*x643
    x652 = x276*x622
    x653 = x17*x652
    x654 = x370*x645
    x655 = x282*x645
    x656 = x217 + x57 + x654 - x655
    x657 = x135*x35
    x658 = x31*x657
    x659 = -x658
    x660 = x119*x645
    x661 = x147 + x31*x644 + x659 - x660
    x662 = x136*x236 + x138*x225 + x141*x229
    x663 = 2*x47
    x664 = x28*x657
    x665 = 2*x664
    x666 = x27*x645
    x667 = x31*x645
    x668 = x124*x666 + x125*x667 + x216 + x301*x644 + x629 + x663 - x665
    x669 = x310*x62
    x670 = x149*x669
    x671 = x205*x639 + x219*x640 + x220*x639 + x257*x638 + x309*x670
    x672 = 2*m1
    x673 = 2*o1
    x674 = -x672 + x673
    x675 = x30*x622
    x676 = -x664
    x677 = -x215
    x678 = x135*x360
    x679 = x145 - x17*x666 + x28*x678 + x47 + x676 + x677
    x680 = -x673
    x681 = x672 + x680
    x682 = x366*x622
    x683 = x135*x268
    x684 = x371*x683
    x685 = x155 + x279 - x31*x678 + x327 + x658 + x684
    x686 = x14*x682
    x687 = -x57
    x688 = x1*x683
    x689 = x115*x688
    x690 = x55 + x655 + x687 - x689
    x691 = x136*x332 + x138*x336 + x141*x340
    x692 = 4*m1
    x693 = 4*o1
    x694 = -x693
    x695 = 2*x647
    x696 = x125*x282
    x697 = x127 - 2*x156 + x306 + x322 + x383*x678 + 2*x646 + x683*x696 - x695
    x698 = x386*x670
    x699 = x317*x698 + x319*x639 + x329*x640 + x330*x639 + x357*x638
    x700 = x120 + x290 - x654 + x689
    x701 = x32*x622
    x702 = x135*x423
    x703 = x362 - x647
    x704 = x130 + x395
    x705 = x156 + x27*x702 - x282*x688 + x703 + x704
    x706 = x1*x667 - x145 - x28*x702 + x664
    x707 = x136*x403 + x138*x407 + x141*x401
    x708 = 2*x658
    x709 = 2*x39
    x710 = 2*x327
    x711 = x432*x702 - x630 + 2*x660 + 2*x684 - x708 + x709 + x710
    x712 = x392*x698 + x393*x639 + x399*x640 + x400*x639 + x418*x638
    x713 = x435*x683
    x714 = -x436
    x715 = x301*x645
    x716 = x134*(x435*x715 + x439 + x489*x713 + x625*x713 + x665) + x443*x640 + x444*x639 + x462*x698 + x463*x639 + x484*x638 + x70*(x136*x476 + x138*x472 + x141*x482 + x25*(-x282*x713 + x370*x713 + x441) + x43*(x115*x713 - x435*x666 + x703 + x714) + x51*(-x119*x713 + x435*x667 + x658))
    x717 = x492*x683
    x718 = -x493
    x719 = x134*(x206 + x489*x717 + x492*x715 + x496 + x625*x717 + x695) + x499*x640 + x500*x639 + x507*x698 + x508*x639 + x525*x638 + x70*(x136*x516 + x138*x523 + x141*x518 + x25*(-x282*x717 + x370*x717 + x497 + x659) + x43*(x115*x717 - x492*x666 + x664 + x718) + x51*(-x119*x717 + x492*x667))
    x720 = -x531
    x721 = x530*x683
    x722 = x134*(x489*x721 + x530*x715 + x534 + x625*x721 + x708) + x537*x640 + x538*x639 + x542*x698 + x543*x639 + x558*x638 + x70*(x136*x556 + x138*x552 + x141*x550 + x25*(-x282*x721 + x370*x721 + x535 + x648) + x43*(x115*x721 - x530*x666 + x720) + x51*(-x119*x721 + x530*x667 + x676))
    x723 = -x99*(x574*x638 + x578*x698 + x579*x639 + x70*(x136*x572 + x138*x567 + x141*x570))
    x724 = -x99*(x592*x638 + x596*x698 + x597*x639 + x70*(x136*x585 + x138*x588 + x141*x590))
    x725 = -x99*(x610*x638 + x614*x698 + x615*x639 + x70*(x136*x606 + x138*x608 + x141*x603))
    x726 = x94*(x178*x618 + x97*(2*x166 + 2*x168 + 2*x171))
    x727 = 3*m2
    x728 = 3*o2
    x729 = x106*(-x727 + x728)
    x730 = x26*x729
    x731 = x14*x730
    x732 = x102*(x128*x164 + x174*x28 + x177 + x52)
    x733 = x135*x729
    x734 = x14*x733
    x735 = x164*x729
    x736 = x14*x735
    x737 = -x636
    x738 = x29*x729
    x739 = x264*x729
    x740 = x164*x36
    x741 = x164*x269
    x742 = x164*x271
    x743 = x115*x742
    x744 = -x181 - x27*x741 + x740 + x743
    x745 = x1*x739
    x746 = x276*x729
    x747 = x17*x746
    x748 = x370*x742
    x749 = x282*x742
    x750 = x116 + x677 + x748 - x749
    x751 = x119*x742
    x752 = x164*x35
    x753 = x31*x752
    x754 = x362 - x753
    x755 = x126 + x209
    x756 = x176 + x31*x741 - x751 + x754 + x755
    x757 = x165*x229 + x167*x236 + x170*x225
    x758 = x28*x752
    x759 = 2*x758
    x760 = 2*x57
    x761 = x27*x742
    x762 = x31*x742
    x763 = x124*x761 + x125*x762 - x175 + x218 + x301*x741 - x759 + x760
    x764 = (1/2)*x172
    x765 = (1/2)*x179
    x766 = x101*x178
    x767 = x178*x669
    x768 = x205*x764 + x219*x766 + x220*x764 + x257*x765 + x309*x767
    x769 = x30*x729
    x770 = -x758
    x771 = x164*x360
    x772 = -x17*x761 + x174 + x28*x771 + x770
    x773 = x366*x729
    x774 = x164*x268
    x775 = x371*x774
    x776 = x45 + x753
    x777 = -x128 - x321
    x778 = x186 - x31*x771 + x775 + x776 + x777
    x779 = x14*x773
    x780 = x1*x774
    x781 = x115*x780
    x782 = x215 + x48 + x749 - x781
    x783 = x165*x340 + x167*x332 + x170*x336
    x784 = 2*x37
    x785 = 2*x740
    x786 = x383*x771 + x696*x774 + x710 + x737 + 2*x743 + x784 - x785
    x787 = x386*x767
    x788 = x317*x787 + x319*x764 + x329*x766 + x330*x764 + x357*x765
    x789 = x267 + x47 - x748 + x781
    x790 = 2*m2
    x791 = 2*o2
    x792 = -x790 + x791
    x793 = x32*x729
    x794 = -x740
    x795 = x164*x423
    x796 = x181 + x27*x795 - x282*x780 + x37 + x375 + x794
    x797 = -x791
    x798 = x790 + x797
    x799 = x1*x762 + x217 - x28*x795 + x633 + x687 + x758
    x800 = x165*x401 + x167*x403 + x170*x407
    x801 = 4*m2
    x802 = 4*o2
    x803 = -x802
    x804 = 2*x753
    x805 = x127 + x129 - 2*x176 + x305 + x396 + x432*x795 + 2*x751 + 2*x775 - x804
    x806 = x392*x787 + x393*x764 + x399*x766 + x400*x764 + x418*x765
    x807 = x435*x774
    x808 = -x438
    x809 = x301*x742
    x810 = x134*(x435*x809 + x442 + x489*x807 + x625*x807 + x759) + x443*x766 + x444*x764 + x462*x787 + x463*x764 + x484*x765 + x70*(x165*x482 + x167*x476 + x170*x472 + x25*(-x282*x807 + x370*x807 + x808) + x43*(x115*x807 - x435*x761 + x794) + x51*(-x119*x807 + x435*x762 + x436 + x776))
    x811 = x492*x774
    x812 = -x495
    x813 = x134*(x489*x811 + x492*x809 + x498 + x625*x811 + x785) + x499*x766 + x500*x764 + x507*x787 + x508*x764 + x525*x765 + x70*(x165*x518 + x167*x516 + x170*x523 + x25*(-x282*x811 + x370*x811 + x754 + x812) + x43*(x115*x811 - x492*x761 + x758) + x51*(-x119*x811 + x492*x762 + x493))
    x814 = x530*x774
    x815 = -x533
    x816 = x134*(x206 + x489*x814 + x530*x809 + x536 + x625*x814 + x804) + x537*x766 + x538*x764 + x542*x787 + x543*x764 + x558*x765 + x70*(x165*x550 + x167*x556 + x170*x552 + x25*(-x282*x814 + x370*x814 + x740 + x815) + x43*(x115*x814 - x530*x761) + x51*(-x119*x814 + x530*x762 + x531 + x770))
    x817 = -x99*(x574*x765 + x578*x787 + x579*x764 + x70*(x165*x570 + x167*x572 + x170*x567))
    x818 = -x99*(x592*x765 + x596*x787 + x597*x764 + x70*(x165*x590 + x167*x585 + x170*x588))
    x819 = -x99*(x610*x765 + x614*x787 + x615*x764 + x70*(x165*x603 + x167*x606 + x170*x608))
    x820 = x90*x95/x68**2
    x821 = x94*(x202*x820 + x219*x618 + x97*(2*x226 + 2*x230 + 2*x237 + 2*x243 + 2*x249 + 2*x256))
    x822 = -x105
    x823 = x106*(x104 + x822)
    x824 = x26*x823
    x825 = x14*x824
    x826 = -x760
    x827 = x102*(x209*x28 + x212 + x213 + x346 + x349 + x411)
    x828 = x135*x823
    x829 = x14*x828
    x830 = x164*x823
    x831 = x14*x830
    x832 = x100*x65*x67/x68**(5/2)
    x833 = x204*x87
    x834 = x833*(-x194 - x200 + x339 + x42)
    x835 = 4*p0
    x836 = x296 + x835
    x837 = x20**(-5/2)
    x838 = 3*p0
    x839 = x837*(x822 + x838)
    x840 = x15*x839
    x841 = x12*x5
    x842 = 2*x841
    x843 = x12*x3
    x844 = x17*x843
    x845 = x122*x839
    x846 = x12*x9
    x847 = x1*x839
    x848 = x846*x847
    x849 = x457 + x459 + x461
    x850 = x318*x87
    x851 = x62*x87
    x852 = -x835
    x853 = x295 + x852
    x854 = x208*x28
    x855 = x268*x29
    x856 = x29*x823
    x857 = x44*x840
    x858 = x264*x823
    x859 = x276*x823
    x860 = x27*x44
    x861 = x17*x860
    x862 = x44*x847
    x863 = x271*x276
    x864 = 4*x1*x863
    x865 = 4*x45
    x866 = x264*x271
    x867 = x214*x28
    x868 = 2*x867
    x869 = x27*x326
    x870 = 2*x869
    x871 = x31*x440
    x872 = 2*x871
    x873 = -x868 - x870 - x872
    x874 = x132 + 4*x17*x866 + x865 + x873
    x875 = x14*x839
    x876 = x1*x875
    x877 = x843*x876
    x878 = x17*x875
    x879 = x846*x878
    x880 = -x334
    x881 = x223 + x880
    x882 = 2*p0
    x883 = x261 + x882
    x884 = x17*x841
    x885 = -x227
    x886 = x196 + x885
    x887 = -x882
    x888 = x260 + x887
    x889 = -x199
    x890 = x233 + x889
    x891 = x1*x858
    x892 = x44*x875
    x893 = x370*x892
    x894 = x17*x859
    x895 = x282*x892
    x896 = x124*x863
    x897 = x125*x866
    x898 = x31*x326
    x899 = x27*x440
    x900 = -x899
    x901 = x898 + x900
    x902 = x112 + x901
    x903 = x28*x36
    x904 = 2*x903
    x905 = x208*x27
    x906 = 2*x269
    x907 = x264*x906
    x908 = x17*x855
    x909 = x122*x908
    x910 = x214*x27
    x911 = x28*x326
    x912 = -x911
    x913 = x910 + x912
    x914 = x117 + x913
    x915 = x208*x31
    x916 = x276*x35
    x917 = 2*x916
    x918 = x1*x855
    x919 = x122*x918
    x920 = x276*x906
    x921 = x28*x440
    x922 = x214*x31
    x923 = -x922
    x924 = x921 + x923
    x925 = x121 + x924
    x926 = x18*x839
    x927 = -x456
    x928 = x458 + x927
    x929 = -x223
    x930 = x847*x884
    x931 = x44*x926
    x932 = x30*x823
    x933 = -x211 - x867
    x934 = x323 + x869
    x935 = x18*x855 - x269*x30 + x755 + x777 + x933 + x934
    x936 = x44*x839
    x937 = x371*x936
    x938 = x17*x366
    x939 = x1*x30
    x940 = x271*x939
    x941 = x276*x360
    x942 = x1*x264
    x943 = x17*x268
    x944 = -x271*x938 + x942*x943
    x945 = x290 + x687 + x916 + x922 + x940 - x941 + x944
    x946 = x366*x823
    x947 = x14*x946
    x948 = x115*x862
    x949 = -x898
    x950 = x31*x36
    x951 = -x950
    x952 = x269*x366
    x953 = x1*x908
    x954 = x17*x863 - x271*x942
    x955 = x327 + x37 + x949 + x951 + x952 - x953 + x954
    x956 = x225*x355 + x229*x350 + x236*x344 + x242*x336 + x248*x340 + x255*x332
    x957 = x122*x936
    x958 = 2*x910
    x959 = -x958
    x960 = -x382
    x961 = x1*x276
    x962 = x124*x268*x961
    x963 = 2*x360
    x964 = x264*x963
    x965 = 2*x911
    x966 = x271*x30
    x967 = x124*x966
    x968 = x271*x366
    x969 = x125*x968
    x970 = -4*x215 - x663 - 4*x903 + x907 + x909 + x959 + x960 + x962 + x964 - x965 + x967 + x969
    x971 = 2*x843
    x972 = 2*x227
    x973 = 2*x196
    x974 = x972 + x973
    x975 = (1/2)*x257
    x976 = (1/2)*x357
    x977 = x101*x219
    x978 = x201*x832
    x979 = x309*x669
    x980 = x317*x386
    x981 = x219*x669
    x982 = x205*x976 + x220*x976 + x317*x978 + x319*x975 + x329*x977 + x329*x979 + x330*x975 + x980*x981
    x983 = -x196
    x984 = x19*x839
    x985 = x17*x846
    x986 = -x460
    x987 = x456 + x986
    x988 = x279 + x375 + x899 + x950 - x952 + x953 + x954
    x989 = x44*x984
    x990 = x17*x32
    x991 = -x903
    x992 = -x910
    x993 = x264*x423
    x994 = x271*x990
    x995 = x1*x366
    x996 = x276*x943
    x997 = -x1*x996 + x271*x995
    x998 = x215 + x47 + x991 + x992 + x993 - x994 + x997
    x999 = x14*x32
    x1000 = x31*x44
    x1001 = x211 + x867
    x1002 = -x397 - x871
    x1003 = x1001 + x1002 - x19*x855 + x269*x32 + x649 + x704
    x1004 = x225*x416 + x229*x409 + x236*x412 + x242*x407 + x248*x401 + x255*x403
    x1005 = x125*x32
    x1006 = 2*x921
    x1007 = -x1006
    x1008 = x124*x968
    x1009 = x271*x32
    x1010 = x1009*x125
    x1011 = 2*x922
    x1012 = 2*x423
    x1013 = x1012*x276
    x1014 = x268*x942
    x1015 = x1014*x124
    x1016 = x1007 + x1008 + x1010 - x1011 + x1013 + x1015 - 4*x217 - x430 + x826 - 4*x916 + x919 + x920
    x1017 = 2*x846
    x1018 = x841*x847
    x1019 = x124*x843
    x1020 = 2*x233
    x1021 = 2*x199
    x1022 = x1020 + x1021
    x1023 = (1/2)*x418
    x1024 = x386*x981
    x1025 = x1023*x205 + x1023*x220 + x1024*x392 + x392*x978 + x393*x975 + x399*x977 + x399*x979 + x400*x975
    x1026 = -x973
    x1027 = x435*x839
    x1028 = x435*x843
    x1029 = x14*x222
    x1030 = -x1029
    x1031 = x191*x447
    x1032 = x1031*x14
    x1033 = x17*x6
    x1034 = x1032*x1033
    x1035 = x1031*x15
    x1036 = x1035*x5
    x1037 = x1036*x3
    x1038 = x195*x435
    x1039 = x1038 + x452
    x1040 = x1030 + x1034 - x1037 + x1039 + x227
    x1041 = x1*x1032
    x1042 = x3*x5
    x1043 = x1041*x1042
    x1044 = x1032*x17
    x1045 = x1044*x9
    x1046 = x1045*x5
    x1047 = x1043 - x1046 + x334 + x929
    x1048 = x846*x875
    x1049 = x14*x192
    x1050 = x1*x1049
    x1051 = -x233
    x1052 = x1036*x9
    x1053 = x1041*x6
    x1054 = -x454
    x1055 = x198*x435
    x1056 = x1054 - x1055
    x1057 = x1050 + x1051 + x1052 - x1053 + x1056
    x1058 = x435*x936
    x1059 = x435*x892
    x1060 = x435*x905
    x1061 = x435*x866
    x1062 = x1060 - x1061 + x435*x908 + x808 + x911 + x991
    x1063 = x1014*x435
    x1064 = x435*x996
    x1065 = x1063 - x1064 + x899 + x949
    x1066 = x435*x915
    x1067 = -x1066
    x1068 = -x921
    x1069 = x435*x863
    x1070 = x1067 + x1068 + x1069 - x435*x918 + x441 + x916
    x1071 = x225*x464 + x229*x468 + x236*x466 + x242*x472 + x248*x482 + x255*x476
    x1072 = x124*x860
    x1073 = x435*x854
    x1074 = x122*x855
    x1075 = x268*x435
    x1076 = x124*x264
    x1077 = x125*x276
    x1078 = x305 + x872
    x1079 = -2*x1073 + x1074*x435 + x1075*x1076 + x1075*x1077 + x1078 + 2*x211 - x437 + x870
    x1080 = x122*x841
    x1081 = x125*x846
    x1082 = 2*x193
    x1083 = 2*x6
    x1084 = x232*x435
    x1085 = 2*x22
    x1086 = -x1085
    x1087 = x1042*x1044
    x1088 = x1086 - 2*x1087 - x461
    x1089 = x1041*x9
    x1090 = x1089*x5
    x1091 = -2*x1090 - x459
    x1092 = -x1035*x1083 + x1082 + 2*x1084 + x1088 + x1091 + x450
    x1093 = (1/2)*x484
    x1094 = x1024*x462 + x1093*x205 + x1093*x220 + x443*x977 + x443*x979 + x444*x975 + x462*x978 + x463*x975
    x1095 = x492*x839
    x1096 = x492*x843
    x1097 = -x22
    x1098 = x1097 + x193
    x1099 = x195*x492
    x1100 = x1099 + x502
    x1101 = -x1035*x7 + x1087 + x1098 + x1100 + x456
    x1102 = -x1050
    x1103 = x1041*x7
    x1104 = x1045*x3
    x1105 = -x1104
    x1106 = x1102 + x1103 + x1105 + x889
    x1107 = -x505
    x1108 = x198*x492
    x1109 = x1035*x3
    x1110 = x1109*x9
    x1111 = -x1043
    x1112 = x1107 - x1108 + x1110 + x1111
    x1113 = x492*x936
    x1114 = x492*x892
    x1115 = x492*x905
    x1116 = x492*x866
    x1117 = x1001 + x1115 - x1116 + x362 + x492*x908 + x812
    x1118 = -x916
    x1119 = x1014*x492
    x1120 = x492*x996
    x1121 = x1118 + x1119 - x1120 + x923
    x1122 = x492*x915
    x1123 = x492*x863
    x1124 = -x1122 + x1123 - x492*x918 + x497
    x1125 = x225*x513 + x229*x511 + x236*x509 + x242*x523 + x248*x518 + x255*x516
    x1126 = x492*x854
    x1127 = 2*x1126
    x1128 = x268*x492
    x1129 = x1074*x492 + x1076*x1128 + x1077*x1128 - x1127 - x494 + x904 + x958
    x1130 = x232*x492
    x1131 = 2*x1130
    x1132 = x1044*x7
    x1133 = x1089*x3
    x1134 = 2*x452
    x1135 = 2*x1029
    x1136 = x1134 + x1135
    x1137 = x1026 - 2*x1037 + x1131 - 2*x1132 - 2*x1133 + x1136
    x1138 = (1/2)*x525
    x1139 = x1024*x507 + x1138*x205 + x1138*x220 + x499*x977 + x499*x979 + x500*x975 + x507*x978 + x508*x975
    x1140 = x530*x839
    x1141 = x530*x843
    x1142 = x195*x530
    x1143 = x1046 - x1110 + x1142 + x505
    x1144 = x10*x1044
    x1145 = x1029 + x1133 - x1144 + x196
    x1146 = -x193 + x22
    x1147 = x198*x530
    x1148 = -x1147 - x540
    x1149 = x10*x1035 - x1090 + x1146 + x1148 + x927
    x1150 = x530*x936
    x1151 = x530*x892
    x1152 = x530*x905
    x1153 = x530*x866
    x1154 = x1152 - x1153 + x530*x908 + x815
    x1155 = x1014*x530
    x1156 = x530*x996
    x1157 = x1155 - x1156 + x903 + x910
    x1158 = x530*x915
    x1159 = -x1158
    x1160 = x530*x863
    x1161 = x1159 + x1160 + x45 - x530*x918 + x535 + x933
    x1162 = x225*x546 + x229*x544 + x236*x548 + x242*x552 + x248*x550 + x255*x556
    x1163 = x530*x854
    x1164 = 2*x1163
    x1165 = -x1164
    x1166 = x268*x530
    x1167 = x1011 + x1074*x530 + x1076*x1166 + x1077*x1166 + x1165 - x532 + x917
    x1168 = x232*x530
    x1169 = 2*x1168
    x1170 = x10*x1041
    x1171 = 2*x454
    x1172 = 2*x1050
    x1173 = x1171 + x1172
    x1174 = -x1021 - 2*x1052 - 2*x1104 + x1169 - 2*x1170 + x1173
    x1175 = (1/2)*x558
    x1176 = x1024*x542 + x1175*x205 + x1175*x220 + x537*x977 + x537*x979 + x538*x975 + x542*x978 + x543*x975
    x1177 = x1041*x3
    x1178 = x1177*x563
    x1179 = x1045*x563
    x1180 = x5*x563
    x1181 = x1044*x1180
    x1182 = -x566
    x1183 = x1035*x9
    x1184 = x1041*x1180
    x1185 = (1/2)*x574
    x1186 = 2*x1036
    x1187 = x3*x563
    x1188 = x1044*x1187
    x1189 = x1089*x563
    x1190 = x1024*x578 + x1185*x205 + x1185*x220 + x578*x978 + x579*x975 + x70*(x242*x567 + x248*x570 + x255*x572 + x83*(x1029 - x1109*x563 + x1181 + x564) + x84*(x1102 + x1182 + x1183*x563 - x1184) + x85*(x1178 - x1179)) + x850*(-x1082 + x1085 - x1186*x563 - 2*x1188 - 2*x1189 + x575)
    x1191 = -x583
    x1192 = x5*x582
    x1193 = x1041*x1192
    x1194 = x1177*x582
    x1195 = x1045*x582
    x1196 = x1044*x1192
    x1197 = (1/2)*x592
    x1198 = -x1135
    x1199 = x3*x582
    x1200 = x1044*x1199
    x1201 = x1089*x582
    x1202 = x1024*x596 + x1197*x205 + x1197*x220 + x596*x978 + x597*x975 + x70*(x242*x588 + x248*x590 + x255*x585 + x83*(-x1109*x582 + x1146 + x1196 + x587) + x84*(x1183*x582 + x1191 - x1193) + x85*(x1050 + x1194 - x1195)) + x850*(-x1186*x582 + x1198 - 2*x1200 - 2*x1201 + x593)
    x1203 = x5*x600
    x1204 = x1044*x1203
    x1205 = x1177*x600
    x1206 = x1045*x600
    x1207 = -x605
    x1208 = x1041*x1203
    x1209 = (1/2)*x610
    x1210 = -x1172
    x1211 = x3*x600
    x1212 = x1044*x1211
    x1213 = x1089*x600
    x1214 = x1024*x614 + x1209*x205 + x1209*x220 + x614*x978 + x615*x975 + x70*(x242*x608 + x248*x603 + x255*x606 + x83*(-x1109*x600 + x1204 + x602) + x84*(x1098 + x1183*x600 + x1207 - x1208) + x85*(x1030 + x1205 - x1206)) + x850*(-x1186*x600 + x1210 - 2*x1212 - 2*x1213 + x611)
    x1215 = x66*x820
    x1216 = x94*(x1215*x317 + x329*x618 + x97*(2*x333 + 2*x337 + 2*x341 + 2*x345 + 2*x351 + 2*x356))
    x1217 = -x621
    x1218 = x106*(x1217 + x620)
    x1219 = x1218*x26
    x1220 = x1219*x14
    x1221 = x102*(x245 + x247 + x27*x321 + x324 + x328 + x415)
    x1222 = x1218*x135
    x1223 = x1222*x14
    x1224 = x1218*x164
    x1225 = x1224*x14
    x1226 = 3*p1
    x1227 = x837*(x1217 + x1226)
    x1228 = x1227*x15
    x1229 = x1227*x14
    x1230 = x1*x1229
    x1231 = x1230*x843
    x1232 = x1229*x985
    x1233 = x1218*x29
    x1234 = x1228*x44
    x1235 = x1229*x44
    x1236 = x1218*x14
    x1237 = x1218*x942
    x1238 = x1235*x370
    x1239 = x1218*x17
    x1240 = x1239*x276
    x1241 = x1235*x282
    x1242 = x122*x1227
    x1243 = x1*x1227
    x1244 = x122*x1243
    x1245 = x833*(-x228 + x23 - x315 + x406)
    x1246 = 4*p1
    x1247 = x1246 + x694
    x1248 = x1227*x18
    x1249 = x124*x846
    x1250 = -x1246
    x1251 = x1250 + x693
    x1252 = x124*x30
    x1253 = x1248*x44
    x1254 = x1218*x122
    x1255 = x1218*x366
    x1256 = x1227*x44
    x1257 = x122*x1256
    x1258 = 4*x943*x995
    x1259 = x1243*x884
    x1260 = 2*p1
    x1261 = -x1260
    x1262 = x1261 + x673
    x1263 = x1260 + x680
    x1264 = x1236*x366
    x1265 = x1243*x44
    x1266 = x115*x1265
    x1267 = x14*x30
    x1268 = x1229*x860
    x1269 = 2*x950
    x1270 = x366*x963
    x1271 = x268*x939
    x1272 = x124*x1271
    x1273 = x1256*x371
    x1274 = x1227*x19
    x1275 = -x458
    x1276 = x1275 + x460
    x1277 = x1068 + x1118 + x217 + x55 - x940 + x941 + x944
    x1278 = x1274*x44
    x1279 = -x323 - x869
    x1280 = x397 + x871
    x1281 = x1279 + x1280 + x30*x423 - x32*x360 + x364 + x427
    x1282 = x267 + x677 + x903 + x911 - x993 + x994 + x997
    x1283 = x332*x412 + x336*x416 + x340*x409 + x344*x403 + x350*x401 + x355*x407
    x1284 = 2*x898
    x1285 = -x1284
    x1286 = -x709
    x1287 = x1012*x366
    x1288 = 2*x899
    x1289 = x268*x990
    x1290 = x125*x1289
    x1291 = x1270 + x1272 + x1285 + x1286 + x1287 - x1288 + x1290 - 4*x327 - x784 + x896 + x897 - 4*x950
    x1292 = x1243*x841
    x1293 = 2*x334
    x1294 = 2*x223
    x1295 = x1293 + x1294
    x1296 = x101*x329
    x1297 = x317*x832
    x1298 = x669*x980
    x1299 = x386*x392
    x1300 = x329*x669
    x1301 = x1023*x319 + x1023*x330 + x1296*x399 + x1297*x392 + x1298*x399 + x1299*x1300 + x393*x976 + x400*x976
    x1302 = x1227*x435
    x1303 = x1031*x18
    x1304 = x22 - x314
    x1305 = -x1084 - x449
    x1306 = -x1087 + x1275 + x1303*x6 + x1304 + x1305
    x1307 = x1303*x5
    x1308 = x1307*x9
    x1309 = x1*x1031
    x1310 = x1309*x17
    x1311 = x1042*x1310
    x1312 = x1055 - x1308 + x1311 + x454
    x1313 = x1229*x435
    x1314 = x1*x222
    x1315 = x1033*x1309
    x1316 = x1046 + x1314 - x1315 + x223
    x1317 = x1256*x435
    x1318 = -x1073
    x1319 = x435*x943
    x1320 = x1279 + x1318 + x1319*x264 - x435*x966 + x436 + x45
    x1321 = x1066 + x1271*x435 - x1319*x366 + x487
    x1322 = x435*x968
    x1323 = -x1063 + x1322 + x898 + x950
    x1324 = x332*x466 + x336*x464 + x340*x468 + x344*x476 + x350*x482 + x355*x472
    x1325 = x1000*x125
    x1326 = 2*x1060
    x1327 = -x1326
    x1328 = x1252*x268
    x1329 = x125*x366
    x1330 = 2*x1061 + x1075*x1329 + x1327 + x1328*x435 - x439 + x904 + x965
    x1331 = x1227*x124
    x1332 = 2*x1038
    x1333 = x1307*x3
    x1334 = x1310*x9
    x1335 = x1334*x5
    x1336 = -2*x1034 + x1136 + x1332 - 2*x1333 - 2*x1335 - x972
    x1337 = x1300*x386
    x1338 = x1093*x319 + x1093*x330 + x1296*x443 + x1297*x462 + x1298*x443 + x1337*x462 + x444*x976 + x463*x976
    x1339 = x1227*x492
    x1340 = -x452
    x1341 = -x1130 + x1340
    x1342 = x1029 - x1132 + x1333 + x1341 + x983
    x1343 = -x1294
    x1344 = -x1314
    x1345 = x1310*x7
    x1346 = x1303*x9
    x1347 = x1346*x3
    x1348 = x1108 + x505
    x1349 = x1344 + x1345 - x1347 + x1348 + x334
    x1350 = x1229*x492
    x1351 = x1051 + x1104 - x1311 + x199
    x1352 = x1256*x492
    x1353 = -x1126
    x1354 = x492*x943
    x1355 = x1353 + x1354*x264 - x492*x966 + x493 + x903 + x992
    x1356 = x1122 + x1271*x492 - x1354*x366 + x527 + x899 + x951
    x1357 = x492*x968
    x1358 = x1068 - x1119 + x1357 + x922
    x1359 = x332*x509 + x336*x513 + x340*x511 + x344*x516 + x350*x518 + x355*x523
    x1360 = x1078 - 2*x1115 + 2*x1116 + x1128*x1329 + x1328*x492 + 2*x323 - x496 + x868
    x1361 = 2*x314
    x1362 = 2*x1303
    x1363 = x1334*x3
    x1364 = -2*x1363 - x457
    x1365 = x1088 + 2*x1099 + x1361 - x1362*x7 + x1364 + x503
    x1366 = x1138*x319 + x1138*x330 + x1296*x499 + x1297*x507 + x1298*x499 + x1337*x507 + x500*x976 + x508*x976
    x1367 = x1227*x530
    x1368 = x1054 + x1105 - x1168 + x1308
    x1369 = x1097 + x314
    x1370 = x1147 + x540
    x1371 = -x10*x1303 + x1363 + x1369 + x1370 + x458
    x1372 = x1229*x530
    x1373 = -x1335
    x1374 = x1030 + x1144 + x1373 + x885
    x1375 = x1256*x530
    x1376 = x530*x943
    x1377 = -x1163 + x1376*x264 - x530*x966 + x531
    x1378 = x1158 + x1271*x530 - x1376*x366 + x362 + x561 + x934
    x1379 = x530*x968
    x1380 = -x1155 + x1379 + x912 + x991
    x1381 = x332*x548 + x336*x546 + x340*x544 + x344*x556 + x350*x550 + x355*x552
    x1382 = 2*x1152
    x1383 = 2*x1153 + x1166*x1329 + x1269 + x1284 + x1328*x530 - x1382 - x534
    x1384 = 2*x1142
    x1385 = x10*x1310
    x1386 = 2*x505
    x1387 = 2*x1314
    x1388 = x1386 + x1387
    x1389 = -2*x1046 + x1343 - 2*x1347 + x1384 - 2*x1385 + x1388
    x1390 = x1175*x319 + x1175*x330 + x1296*x537 + x1297*x542 + x1298*x537 + x1337*x542 + x538*x976 + x543*x976
    x1391 = x1187*x1310
    x1392 = x1180*x1310
    x1393 = -x569
    x1394 = x1334*x563
    x1395 = x1185*x319 + x1185*x330 + x1297*x578 + x1337*x578 + x579*x976 + x70*(x344*x572 + x350*x570 + x355*x567 + x83*(-x1188 + x1307*x563 + x1369 + x1393) + x84*(x1179 + x1344 - x1392) + x85*(-x1346*x563 + x1391 + x566)) + x850*(-2*x1181 - x1187*x1362 + x1198 - 2*x1394 + x576)
    x1396 = x1192*x1310
    x1397 = x1199*x1310
    x1398 = -x584
    x1399 = x1334*x582
    x1400 = x1197*x319 + x1197*x330 + x1297*x596 + x1337*x596 + x597*x976 + x70*(x344*x585 + x350*x590 + x355*x588 + x83*(x1030 - x1200 + x1307*x582 + x1398) + x84*(x1195 - x1396) + x85*(x1314 - x1346*x582 + x1397 + x583)) + x850*(x1085 - 2*x1196 - x1199*x1362 - x1361 - 2*x1399 + x594)
    x1401 = -x601
    x1402 = x1203*x1310
    x1403 = x1211*x1310
    x1404 = -x1387
    x1405 = x1334*x600
    x1406 = x1209*x319 + x1209*x330 + x1297*x614 + x1337*x614 + x615*x976 + x70*(x344*x606 + x350*x603 + x355*x608 + x83*(-x1212 + x1307*x600 + x1401) + x84*(x1029 + x1206 - x1402) + x85*(x1304 - x1346*x600 + x1403 + x605)) + x850*(-2*x1204 - x1211*x1362 + x1404 - 2*x1405 + x612)
    x1407 = x94*(x1215*x392 + x399*x618 + x97*(2*x402 + 2*x404 + 2*x408 + 2*x410 + 2*x413 + 2*x417))
    x1408 = -x728
    x1409 = x106*(x1408 + x727)
    x1410 = x1409*x26
    x1411 = x14*x1410
    x1412 = x102*(x250 + x254 + x31*x395 + x352 + x354 + x398)
    x1413 = x135*x1409
    x1414 = x14*x1413
    x1415 = x1409*x164
    x1416 = x14*x1415
    x1417 = 3*p2
    x1418 = x837*(x1408 + x1417)
    x1419 = x1418*x15
    x1420 = x14*x1418
    x1421 = x1*x1420
    x1422 = x1421*x843
    x1423 = x1420*x985
    x1424 = x1409*x29
    x1425 = x1419*x44
    x1426 = x1420*x44
    x1427 = x14*x1409
    x1428 = x1409*x942
    x1429 = x1426*x370
    x1430 = x1409*x17
    x1431 = x1430*x276
    x1432 = x1426*x282
    x1433 = x122*x1418
    x1434 = x1*x1418
    x1435 = x122*x1434
    x1436 = x833*(x235 + x24 - x335 - x391)
    x1437 = x1418*x18
    x1438 = x1434*x884
    x1439 = x1437*x44
    x1440 = x1420*x860
    x1441 = x1418*x44
    x1442 = x1441*x371
    x1443 = x1427*x366
    x1444 = x1434*x44
    x1445 = x115*x1444
    x1446 = x122*x1409
    x1447 = x122*x1441
    x1448 = 4*p2
    x1449 = x1448 + x803
    x1450 = x1418*x19
    x1451 = x1434*x841
    x1452 = -x1448
    x1453 = x1452 + x802
    x1454 = x1450*x44
    x1455 = x124*x366
    x1456 = 2*p2
    x1457 = x1456 + x797
    x1458 = -x1456
    x1459 = x1458 + x791
    x1460 = x1418*x435
    x1461 = x1111 + x1315 + x1344 + x880
    x1462 = x1031*x19
    x1463 = x1462*x3
    x1464 = x1463*x5
    x1465 = -x1038 + x1340 + x1373 + x1464
    x1466 = x1420*x435
    x1467 = x1097 + x390
    x1468 = x1084 + x449
    x1469 = x1090 - x1462*x6 + x1467 + x1468 + x460
    x1470 = x1441*x435
    x1471 = x1064 - x1322 + x900 + x951
    x1472 = -x1060 + x1075*x995 - x1289*x435 + x438
    x1473 = x1009*x435 + x1073 - x1075*x961 + x1280 + x362 + x714
    x1474 = x401*x468 + x403*x466 + x407*x464 + x409*x482 + x412*x476 + x416*x472
    x1475 = 2*x1066
    x1476 = x1005*x1075 + x1006 + 2*x1069 + x1075*x1455 - x1475 - x442 + x917
    x1477 = x124*x1418
    x1478 = -x1020
    x1479 = 2*x1055
    x1480 = x1462*x5
    x1481 = x1480*x9
    x1482 = -2*x1053 + x1173 - 2*x1311 + x1478 + x1479 - 2*x1481
    x1483 = x101*x399
    x1484 = x392*x832
    x1485 = x1299*x669
    x1486 = x386*x462
    x1487 = x399*x669
    x1488 = x1023*x444 + x1023*x463 + x1093*x393 + x1093*x400 + x1483*x443 + x1484*x462 + x1485*x443 + x1486*x1487
    x1489 = x1418*x492
    x1490 = x1050 - x1103 + x1311 + x233
    x1491 = x22 - x390
    x1492 = -x1099 - x502
    x1493 = -x1363 + x1462*x7 + x1491 + x1492 + x986
    x1494 = x1420*x492
    x1495 = x1130 + x1133 - x1464 + x452
    x1496 = x1441*x492
    x1497 = x1120 - x1357 + x916 + x921
    x1498 = -x1115
    x1499 = x1002 + x1128*x995 - x1289*x492 + x1498 + x45 + x495
    x1500 = x1009*x492 + x1126 - x1128*x961 + x718
    x1501 = x401*x511 + x403*x509 + x407*x513 + x409*x518 + x412*x516 + x416*x523
    x1502 = 2*x1122
    x1503 = -x1502
    x1504 = x1005*x1128 + 2*x1123 + x1128*x1455 + x1269 + x1288 + x1503 - x498
    x1505 = 2*x1108
    x1506 = x1463*x9
    x1507 = -2*x1043 - x1293 - 2*x1345 + x1388 + x1505 - 2*x1506
    x1508 = x1487*x386
    x1509 = x1023*x500 + x1023*x508 + x1138*x393 + x1138*x400 + x1483*x499 + x1484*x507 + x1485*x499 + x1508*x507
    x1510 = x1418*x530
    x1511 = -x1133 + x1335 + x227 + x983
    x1512 = x1107 - x1142
    x1513 = x1314 - x1385 + x1506 + x1512 + x929
    x1514 = x1420*x530
    x1515 = x1168 + x454
    x1516 = x1102 + x1170 - x1481 + x1515 + x199
    x1517 = x1441*x530
    x1518 = x1156 - x1379 + x911 + x992
    x1519 = -x1152
    x1520 = x1166*x995 - x1289*x530 + x1519 + x533 + x949 + x950
    x1521 = x1009*x530 + x1118 + x1163 - x1166*x961 + x720 + x922
    x1522 = x401*x544 + x403*x548 + x407*x546 + x409*x550 + x412*x556 + x416*x552
    x1523 = x1005*x1166 - 2*x1158 + 2*x1160 + x1166*x1455 + x305 + 2*x397 - x536 + x868 + x870
    x1524 = 2*x390
    x1525 = 2*x1462
    x1526 = -x10*x1525 + x1086 + x1091 + 2*x1147 + x1364 + x1524 + x541
    x1527 = x1023*x538 + x1023*x543 + x1175*x393 + x1175*x400 + x1483*x537 + x1484*x542 + x1485*x537 + x1508*x542
    x1528 = -x564
    x1529 = x1525*x9
    x1530 = x1023*x579 + x1185*x393 + x1185*x400 + x1484*x578 + x1508*x578 + x70*(x409*x570 + x412*x572 + x416*x567 + x83*(-x1178 + x1314 + x1392) + x84*(x1189 - x1480*x563 + x1491 + x569) + x85*(-x1394 + x1463*x563 + x1528)) + x850*(-2*x1184 + x1210 - 2*x1391 - x1529*x563 + x577)
    x1531 = -x587
    x1532 = x1023*x597 + x1197*x393 + x1197*x400 + x1484*x596 + x1508*x596 + x70*(x409*x590 + x412*x585 + x416*x588 + x83*(x1102 - x1194 + x1396) + x84*(x1201 - x1480*x582 + x584) + x85*(-x1399 + x1463*x582 + x1467 + x1531)) + x850*(-2*x1193 - 2*x1397 + x1404 - x1529*x582 + x595)
    x1533 = -x602
    x1534 = x1023*x615 + x1209*x393 + x1209*x400 + x1484*x614 + x1508*x614 + x70*(x409*x603 + x412*x606 + x416*x608 + x83*(-x1205 + x1402) + x84*(x1050 + x1213 - x1480*x600 + x601) + x85*(x1344 - x1405 + x1463*x600 + x1533)) + x850*(x1085 - 2*x1208 - 2*x1403 - x1524 - x1529*x600 + x613)
    x1535 = x94*(x1215*x462 + x443*x618 + x97*(2*x465 + 2*x467 + 2*x469 + 2*x473 + 2*x477 + 2*x483))
    x1536 = x102*(x27*x438 + x28*x436 + x31*x441 + x347)
    x1537 = -x838
    x1538 = x837*(x105 + x1537)
    x1539 = x15*x1538
    x1540 = x14*x1538
    x1541 = x1*x1540
    x1542 = x1541*x843
    x1543 = x1540*x985
    x1544 = x1539*x44
    x1545 = x1540*x44
    x1546 = x1545*x370
    x1547 = x1545*x282
    x1548 = x122*x1538
    x1549 = x1*x1538
    x1550 = x122*x1549
    x1551 = x833*(-x14*x449 - x435*x456 - x435*x458 - x435*x460 + x445 - x453 + x555)
    x1552 = x1538*x18
    x1553 = x1549*x884
    x1554 = x1552*x44
    x1555 = x1540*x860
    x1556 = x1538*x44
    x1557 = x1556*x371
    x1558 = x1549*x44
    x1559 = x115*x1558
    x1560 = x122*x1556
    x1561 = x1538*x19
    x1562 = x1561*x44
    x1563 = x1549*x841
    x1564 = x1556*x435
    x1565 = x1538*x435
    x1566 = 4*n0
    x1567 = x14*x448
    x1568 = x1049*x435
    x1569 = x1032*x435
    x1570 = 3*n0
    x1571 = x21/x11**(5/2)
    x1572 = x1571*(x1537 + x1570)
    x1573 = x14*x1572
    x1574 = x1031*x17
    x1575 = x1574*x435
    x1576 = x1042*x1575
    x1577 = x5*x9
    x1578 = x1309*x435
    x1579 = x1577*x1578
    x1580 = x124*x1572
    x1581 = x1*x1572
    x1582 = x1577*x1581
    x1583 = x124*x1538
    x1584 = x14*x451
    x1585 = 2*x1584
    x1586 = x17*x504
    x1587 = 2*x1586
    x1588 = x1*x565
    x1589 = 2*x1588
    x1590 = x1585 + x1587 + x1589
    x1591 = x1590 + 4*x22 + x849
    x1592 = x1540*x435
    x1593 = x1042*x1581
    x1594 = x1572*x17
    x1595 = x1577*x1594
    x1596 = x1031*x124
    x1597 = x1596*x435
    x1598 = 2*x435
    x1599 = x1042*x1598
    x1600 = x17*x565
    x1601 = x1*x504
    x1602 = -x1601
    x1603 = x1600 + x1602
    x1604 = x1603 + x881
    x1605 = x222*x435
    x1606 = 2*x1605
    x1607 = -x1606
    x1608 = 2*n0
    x1609 = -x1608 + x882
    x1610 = x17*x448
    x1611 = x1031*x1033
    x1612 = x1042*x1573
    x1613 = x14*x504
    x1614 = x17*x451
    x1615 = -x1614
    x1616 = x1613 + x1615
    x1617 = x1616 + x886
    x1618 = -x1032*x1599 - x1332
    x1619 = x1608 + x887
    x1620 = x1*x448
    x1621 = x1*x192
    x1622 = x1621*x435
    x1623 = 2*x1622
    x1624 = x1573*x1577
    x1625 = x1032*x1598
    x1626 = x1577*x1625
    x1627 = x1*x451
    x1628 = x14*x565
    x1629 = -x1628
    x1630 = x1627 + x1629
    x1631 = x1630 + x890
    x1632 = x1538*x492
    x1633 = x435*x7
    x1634 = x1042*x492
    x1635 = x1032*x1634
    x1636 = x1568 + x1584
    x1637 = x222*x492
    x1638 = -x1586 - x1637
    x1639 = -x1032*x1633 + x1468 + x1492 + x1576 + x1611*x492 - x1635 + x1636 + x1638
    x1640 = x3*x9
    x1641 = -x1627
    x1642 = -x1622
    x1643 = x1309*x1634
    x1644 = x1577*x492
    x1645 = x1574*x1644
    x1646 = x1056 + x1309*x1633 - x1575*x1640 + x1641 + x1642 + x1643 - x1645
    x1647 = x1573*x1640
    x1648 = x1540*x492
    x1649 = x1621*x492
    x1650 = x1309*x6
    x1651 = x1032*x1644
    x1652 = x1569*x1640
    x1653 = -x1042*x1578 + x1348 + x1601 + x1649 - x1650*x492 + x1651 + x1652
    x1654 = x1556*x492
    x1655 = x1073 + x1498
    x1656 = x464*x523 + x466*x516 + x468*x518 + x472*x513 + x476*x509 + x482*x511
    x1657 = x1127 + x1326
    x1658 = x124*x7
    x1659 = x1581*x1640
    x1660 = 2*x1614
    x1661 = x1049*x492
    x1662 = 2*x1661
    x1663 = 2*x1613
    x1664 = x1032*x1083
    x1665 = x1596*x1634
    x1666 = 2*x1309
    x1667 = x1309*x1598
    x1668 = -x1131 - x1596*x1633 + x1606 + x1618 - x1640*x1667 - x1644*x1666 + x1660 + x1662 + x1663 - x1664*x492 - x1665 - 4*x452
    x1669 = x101*x443
    x1670 = x462*x832
    x1671 = x386*x507
    x1672 = x443*x669
    x1673 = x1486*x669
    x1674 = x1093*x500 + x1093*x508 + x1138*x444 + x1138*x463 + x1669*x499 + x1670*x507 + x1671*x1672 + x1673*x499
    x1675 = x1538*x530
    x1676 = -x1600
    x1677 = x222*x530
    x1678 = -x1677
    x1679 = x1042*x530
    x1680 = x1032*x1679
    x1681 = x1512 + x1575*x1577 + x1611*x530 - x1652 + x1676 + x1678 - x1680
    x1682 = x10*x17
    x1683 = x1031*x1682
    x1684 = x1309*x1679
    x1685 = x1577*x530
    x1686 = x1039 - x1574*x1685 + x1578*x1640 + x1605 + x1614 - x1683*x435 + x1684
    x1687 = x1540*x530
    x1688 = x10*x1032
    x1689 = x1032*x1685
    x1690 = -x1568 - x1584
    x1691 = x1621*x530
    x1692 = x1588 + x1691
    x1693 = x1305 + x1370 - x1579 - x1650*x530 + x1688*x435 + x1689 + x1690 + x1692
    x1694 = x1556*x530
    x1695 = x1158 + x1318
    x1696 = x464*x552 + x466*x556 + x468*x550 + x472*x546 + x476*x548 + x482*x544
    x1697 = x1164 + x1475
    x1698 = 2*x10
    x1699 = 2*x1628
    x1700 = 2*x1627
    x1701 = x1049*x530
    x1702 = 2*x1701
    x1703 = x10*x1309
    x1704 = -x1169 - x1666*x1685
    x1705 = -x1479 - x1596*x1679 - x1597*x1640 - x1598*x1703 + x1623 - x1626 - x1664*x530 + x1699 + x1700 + x1702 + x1704 - 4*x454
    x1706 = x1672*x386
    x1707 = x1093*x538 + x1093*x543 + x1175*x444 + x1175*x463 + x1669*x537 + x1670*x542 + x1673*x537 + x1706*x542
    x1708 = x1610*x563
    x1709 = -x1708
    x1710 = -x1613
    x1711 = x1180*x1575 - x1187*x1569 + x1528 + x1605 + x1709 + x1710
    x1712 = x563*x9
    x1713 = x1187*x1578 - x1575*x1712 + x1601 + x1676
    x1714 = -x1700
    x1715 = x1620*x563
    x1716 = -x1180*x1578 + x1569*x1712 + x1628 + x1642 + x1715 + x566
    x1717 = x464*x567 + x466*x572 + x468*x570
    x1718 = 2*x1573
    x1719 = 2*x1581
    x1720 = -x1587
    x1721 = x1567*x563
    x1722 = x1086 - x1589
    x1723 = -x1180*x1625 - x1187*x1597 - 2*x1568 - x1667*x1712 + x1720 + 2*x1721 + x1722 - x575
    x1724 = x1093*x579 + x1185*x444 + x1185*x463 + x1670*x578 + x1706*x578
    x1725 = x1610*x582
    x1726 = -x1725
    x1727 = x1097 + x1192*x1575 - x1199*x1569 + x1531 + x1690 + x1726
    x1728 = x582*x9
    x1729 = x1199*x1578 - x1575*x1728 + x1622 + x1627
    x1730 = x1620*x582
    x1731 = -x1192*x1578 + x1569*x1728 + x1730 + x583
    x1732 = x464*x588 + x466*x585 + x468*x590
    x1733 = x1567*x582
    x1734 = 2*x1733
    x1735 = -x1192*x1625 - x1199*x1597 + x1607 - x1660 - x1667*x1728 + x1734 - x593
    x1736 = x1093*x597 + x1197*x444 + x1197*x463 + x1670*x596 + x1706*x596
    x1737 = x1610*x600
    x1738 = x1203*x1575 - x1211*x1569 + x1533 - x1737
    x1739 = x600*x9
    x1740 = x1211*x1578 - x1575*x1739 - x1605 + x1615
    x1741 = x1620*x600
    x1742 = -x1203*x1578 + x1569*x1739 + x1636 + x1741 + x22 + x605
    x1743 = x464*x608 + x466*x606 + x468*x603
    x1744 = x1567*x600
    x1745 = 2*x1744
    x1746 = -x1203*x1625 - x1211*x1597 - x1623 - x1667*x1739 + x1714 + x1745 - x611
    x1747 = x1093*x615 + x1209*x444 + x1209*x463 + x1670*x614 + x1706*x614
    x1748 = x94*(x1215*x507 + x499*x618 + x97*(2*x510 + 2*x512 + 2*x514 + 2*x517 + 2*x519 + 2*x524))
    x1749 = x102*(x244 + x27*x495 + x28*x493 + x31*x497)
    x1750 = -x1226
    x1751 = x837*(x1750 + x621)
    x1752 = x15*x1751
    x1753 = x14*x1751
    x1754 = x1*x1753
    x1755 = x1754*x843
    x1756 = x1753*x985
    x1757 = x1752*x44
    x1758 = x1753*x44
    x1759 = x1758*x370
    x1760 = x1758*x282
    x1761 = x122*x1751
    x1762 = x1*x1751
    x1763 = x122*x1762
    x1764 = x833*(-x17*x502 - x456*x492 - x458*x492 - x460*x492 + x478 + x481 - x506)
    x1765 = x1751*x18
    x1766 = x1762*x884
    x1767 = x1765*x44
    x1768 = x1753*x860
    x1769 = x1751*x44
    x1770 = x1769*x371
    x1771 = x1762*x44
    x1772 = x115*x1771
    x1773 = x122*x1769
    x1774 = x1751*x19
    x1775 = x1774*x44
    x1776 = x1762*x841
    x1777 = 3*n1
    x1778 = x1571*(x1750 + x1777)
    x1779 = x1751*x435
    x1780 = x14*x1778
    x1781 = x1042*x1780
    x1782 = x1*x1778
    x1783 = x1042*x1782
    x1784 = x17*x1778
    x1785 = x1577*x1784
    x1786 = x1577*x1780
    x1787 = x1753*x435
    x1788 = x1769*x435
    x1789 = x124*x1778
    x1790 = x1577*x1782
    x1791 = x124*x1751
    x1792 = x1769*x492
    x1793 = x1751*x492
    x1794 = 4*n1
    x1795 = x492*x7
    x1796 = 4*x1574
    x1797 = x1640*x492
    x1798 = x1309*x1797
    x1799 = x1640*x1782
    x1800 = x1753*x492
    x1801 = x1640*x1780
    x1802 = 2*x1032
    x1803 = 2*n1
    x1804 = x1261 + x1803
    x1805 = 2*x1649
    x1806 = -x1805
    x1807 = x1260 - x1803
    x1808 = -x1505 - x1596*x1797
    x1809 = x1751*x530
    x1810 = x530*x7
    x1811 = -x1032*x1797 - x1032*x1810 + x1515 + x1574*x1679 + x1628 + x1645 + x1701
    x1812 = x1640*x530
    x1813 = x1586 + x1637
    x1814 = -x1588 - x1691
    x1815 = x1100 + x1148 + x1309*x1810 - x1574*x1812 - x1683*x492 + x1798 + x1813 + x1814
    x1816 = x1753*x530
    x1817 = -x1661
    x1818 = x1032*x1812 - x1309*x1644 + x1341 - x1684 + x1688*x492 + x1710 + x1817
    x1819 = x1769*x530
    x1820 = x1115 + x1159
    x1821 = x509*x556 + x511*x550 + x513*x552 + x516*x548 + x518*x544 + x523*x546
    x1822 = x1382 + x1502
    x1823 = 2*x1601
    x1824 = 2*x1677
    x1825 = 2*x1600
    x1826 = x1309*x492
    x1827 = x1666*x1812
    x1828 = -x1384 - x1596*x1810 - 2*x1651 - 2*x1680 - x1698*x1826 + x1805 + x1808 + x1823 + x1824 + x1825 - x1827 - 4*x505
    x1829 = x507*x832
    x1830 = x386*x542
    x1831 = x499*x669
    x1832 = x537*x669
    x1833 = x101*x499*x537 + x1138*x538 + x1138*x543 + x1175*x500 + x1175*x508 + x1671*x1832 + x1829*x542 + x1830*x1831
    x1834 = x1574*x492
    x1835 = x1032*x492
    x1836 = x1180*x1834 - x1187*x1835 + x1721 + x1813 + x22 + x569
    x1837 = x1182 + x1187*x1826 - x1712*x1834 - x1715
    x1838 = -x1180*x1826 + x1602 - x1649 + x1712*x1835
    x1839 = x509*x572 + x511*x570 + x513*x567
    x1840 = 2*x1780
    x1841 = 2*x1782
    x1842 = 2*x1708
    x1843 = -x1663
    x1844 = x1802*x492
    x1845 = x1596*x492
    x1846 = x1666*x492
    x1847 = -x1180*x1844 - x1187*x1845 - x1662 - x1712*x1846 + x1842 + x1843 - x576
    x1848 = x1831*x386
    x1849 = x1138*x579 + x1185*x500 + x1185*x508 + x1829*x578 + x1848*x578
    x1850 = x1192*x1834 - x1199*x1835 + x1614 + x1733 + x1817 + x584
    x1851 = -x1730
    x1852 = x1191 + x1199*x1826 + x1649 + x1676 - x1728*x1834 + x1851
    x1853 = -x1192*x1826 + x1628 + x1641 + x1728*x1835
    x1854 = x509*x585 + x511*x590 + x513*x588
    x1855 = -x1585
    x1856 = -x1192*x1844 - x1199*x1845 - 2*x1637 + x1722 + 2*x1725 - x1728*x1846 + x1855 - x594
    x1857 = x1138*x597 + x1197*x500 + x1197*x508 + x1829*x596 + x1848*x596
    x1858 = x1203*x1834 - x1211*x1835 + x1744 + x601
    x1859 = -x1741
    x1860 = x1097 + x1207 + x1211*x1826 + x1638 - x1739*x1834 + x1859
    x1861 = -x1203*x1826 + x1613 + x1661 + x1739*x1835
    x1862 = x509*x606 + x511*x603 + x513*x608
    x1863 = 2*x1737
    x1864 = -x1203*x1844 - x1211*x1845 - x1739*x1846 + x1806 - x1823 + x1863 - x612
    x1865 = x1138*x615 + x1209*x500 + x1209*x508 + x1829*x614 + x1848*x614
    x1866 = x94*(x1215*x542 + x537*x618 + x97*(2*x545 + 2*x547 + 2*x549 + 2*x551 + 2*x553 + 2*x557))
    x1867 = x102*(x251 + x27*x533 + x28*x531 + x31*x535)
    x1868 = -x1417
    x1869 = x837*(x1868 + x728)
    x1870 = x15*x1869
    x1871 = x14*x1869
    x1872 = x1*x1871
    x1873 = x1872*x843
    x1874 = x1871*x985
    x1875 = x1870*x44
    x1876 = x1871*x44
    x1877 = x1876*x370
    x1878 = x1876*x282
    x1879 = x122*x1869
    x1880 = x1*x1869
    x1881 = x122*x1880
    x1882 = x833*(-x1*x540 - x456*x530 - x458*x530 - x460*x530 + x474 - x475 + x522)
    x1883 = x18*x1869
    x1884 = x1880*x884
    x1885 = x1883*x44
    x1886 = x1871*x860
    x1887 = x1869*x44
    x1888 = x1887*x371
    x1889 = x1880*x44
    x1890 = x115*x1889
    x1891 = x122*x1887
    x1892 = x1869*x19
    x1893 = x1892*x44
    x1894 = x1880*x841
    x1895 = 3*n2
    x1896 = x1571*(x1868 + x1895)
    x1897 = x1869*x435
    x1898 = x14*x1896
    x1899 = x1042*x1898
    x1900 = x1*x1896
    x1901 = x1042*x1900
    x1902 = x17*x1896
    x1903 = x1577*x1902
    x1904 = x1577*x1898
    x1905 = x1871*x435
    x1906 = x1887*x435
    x1907 = x124*x1896
    x1908 = x1577*x1900
    x1909 = x124*x1869
    x1910 = x1869*x492
    x1911 = x1640*x1898
    x1912 = x1871*x492
    x1913 = x1887*x492
    x1914 = x1640*x1900
    x1915 = x1887*x530
    x1916 = x1869*x530
    x1917 = 4*n2
    x1918 = x1871*x530
    x1919 = -x1702
    x1920 = 2*n2
    x1921 = x1456 - x1920
    x1922 = 2*x530
    x1923 = x1458 + x1920
    x1924 = x1574*x530
    x1925 = x1187*x530
    x1926 = -x1032*x1925 + x1180*x1924 + x1600 + x1677
    x1927 = x1309*x1925 + x1708 - x1712*x1924 + x564
    x1928 = -x1721
    x1929 = x1032*x530
    x1930 = x1309*x530
    x1931 = x1097 - x1180*x1930 + x1393 + x1712*x1929 + x1814 + x1928
    x1932 = x544*x570 + x546*x567 + x548*x572
    x1933 = 2*x1898
    x1934 = 2*x1900
    x1935 = 2*x1715
    x1936 = x1802*x530
    x1937 = x1666*x530
    x1938 = -x1180*x1936 - x1596*x1925 - x1699 - x1712*x1937 + x1919 + x1935 - x577
    x1939 = x542*x832
    x1940 = x1832*x386
    x1941 = x1175*x579 + x1185*x538 + x1185*x543 + x1939*x578 + x1940*x578
    x1942 = x1192*x1924 - x1199*x1929 + x1629 - x1701
    x1943 = x1199*x1930 + x1692 + x1725 - x1728*x1924 + x22 + x587
    x1944 = -x1192*x1930 + x1398 + x1728*x1929 - x1733
    x1945 = x544*x590 + x546*x588 + x548*x585
    x1946 = 2*x1730
    x1947 = -x1825
    x1948 = x1596*x530
    x1949 = -x1192*x1936 - x1199*x1948 - x1728*x1937 - x1824 + x1946 + x1947 - x595
    x1950 = x1175*x597 + x1197*x538 + x1197*x543 + x1939*x596 + x1940*x596
    x1951 = x1203*x1924 - x1211*x1929 + x1614 + x1710
    x1952 = x1211*x1930 + x1601 + x1678 + x1737 - x1739*x1924 + x602
    x1953 = -x1744
    x1954 = -x1203*x1930 + x1401 + x1641 + x1701 + x1739*x1929 + x1953
    x1955 = x544*x603 + x546*x608 + x548*x606
    x1956 = x1086 - x1203*x1936 - x1211*x1948 - 2*x1691 + x1720 - x1739*x1937 + 2*x1741 + x1855 - x613
    x1957 = x1175*x615 + x1209*x538 + x1209*x543 + x1939*x614 + x1940*x614
    x1958 = x94*(x1215*x578 + x97*(2*x568 + 2*x571 + 2*x573))
    x1959 = x833*(-x1*x566 - x14*x569 - x17*x564 + x554)
    x1960 = x1571*(-x1570 + x838)
    x1961 = x14*x1960
    x1962 = x1042*x1961
    x1963 = x1*x1960
    x1964 = x1042*x1963
    x1965 = x17*x1960
    x1966 = x1577*x1965
    x1967 = x1577*x1961
    x1968 = x124*x1960
    x1969 = x1577*x1963
    x1970 = x1640*x1961
    x1971 = x1640*x1963
    x1972 = -x1935
    x1973 = 2*x1961
    x1974 = 2*x1963
    x1975 = x1725 + x1928
    x1976 = -x1734
    x1977 = -x1842 + x1976
    x1978 = x578*x832
    x1979 = x1185*x597 + x1197*x579 + x1978*x596
    x1980 = x1721 + x1859
    x1981 = -x1745 + x1972
    x1982 = x1185*x615 + x1209*x579 + x1978*x614
    x1983 = x94*(x1215*x596 + x97*(2*x586 + 2*x589 + 2*x591))
    x1984 = x833*(-x1*x583 - x14*x584 - x17*x587 + x479)
    x1985 = x1571*(x1226 - x1777)
    x1986 = x14*x1985
    x1987 = x1042*x1986
    x1988 = x1*x1985
    x1989 = x1042*x1988
    x1990 = x17*x1985
    x1991 = x1577*x1990
    x1992 = x1577*x1986
    x1993 = x124*x1985
    x1994 = x1577*x1988
    x1995 = x1640*x1986
    x1996 = x1640*x1988
    x1997 = 2*x1986
    x1998 = 2*x1988
    x1999 = x1726 + x1741
    x2000 = -x1863
    x2001 = -x1946 + x2000
    x2002 = x1197*x615 + x1209*x597 + x596*x614*x832
    x2003 = x94*(x1215*x614 + x97*(2*x604 + 2*x607 + 2*x609))
    x2004 = x833*(-x1*x605 - x14*x601 - x17*x602 + x520)
    x2005 = x1571*(x1417 - x1895)
    x2006 = x14*x2005
    x2007 = x1042*x2006
    x2008 = x1*x2005
    x2009 = x1042*x2008
    x2010 = x17*x2005
    x2011 = x1577*x2010
    x2012 = x1577*x2006
    x2013 = x124*x2005
    x2014 = x1577*x2008
    x2015 = x1640*x2006
    x2016 = x1640*x2008
    x2017 = 2*x2006
    x2018 = 2*x2008

    return np.array([-x88*x98 - x99*(x101*x78**2 + x103*x78 + x134*(x108*x123 + x109*x124 + x110*x125 + x132 + 4*x72) + x60*x82 + x70*(x25*(x1*x109 - x110*x17 + x112) + x43*(x108*x115 - x109*x14 + x114 + x117) + x51*(-x108*x119 + x110*x14 + x118 + x121))), -x151*x98 - x99*(x103*x149 + x134*(x123*x152 + x124*x153 + x125*x154 + x159) + x163 + x70*(x25*(x1*x153 - x154*x17 + x76) + x43*(x115*x152 - x14*x153 + x158) + x51*(-x119*x152 + x14*x154 + x155))), -x180*x98 - x99*(x103*x178 + x134*(x123*x182 + x124*x183 + x125*x185 + x188) + x189 + x70*(x25*(x1*x183 - x17*x185 + x184) + x43*(x115*x182 - x14*x183 + x181) + x51*(-x119*x182 + x14*x185 + x187))), -x258*x98 - x99*(x103*x219 + x134*(x122*x263 + 2*x297 + 2*x298 + x307 + x54*(x294 + x296)) + x312 + x70*(x25*(x275 - x278 + x284) + x293 + x43*(x17*x263 + x262*x38 - x266 + x274) + x51*(-x1*x263 + x285*x56 + x286 + x292))), -x358*x98 - x99*(x103*x329 + x134*(x124*x359 + 2*x266 + 2*x380 + x385) + x388 + x70*(x25*(x1*x359 - x368 + x373) + x379 + x43*(-x14*x359 + x297 + x365) + x51*(-x275 + x374 + x378))), -x419*x98 - x99*(x103*x399 + x134*(x125*x421 + 2*x286 + 2*x368 + x433) + x434 + x70*(x25*(-x17*x421 + x380 + x425) + x429 + x43*(x278 - x374 + x420) + x51*(x14*x421 - x298 + x428))), -x485*x98 - x99*(x103*x443 + x491), -x526*x98 - x99*(x103*x499 + x529), -x559*x98 - x99*(x103*x537 + x562), -x580*x98 + x581, -x598*x98 + x599, -x616*x98 + x617, -x619*x88 - x99*(x134*(x123*x623 + x159 + x489*x623 + x623*x625) + x163 + x626*x78 + x70*(x25*(-x282*x623 + x370*x623 + x76) + x43*(x115*x623 + x158 - x27*x624) + x51*(-x119*x623 + x155 + x31*x624))), -x151*x619 - x99*(x101*x149**2 + x134*(x123*x627 + x132 + 4*x156 + x489*x627 + x625*x627) + x143*x150 + x149*x626 + x70*(x25*(x112 - x282*x627 + x370*x627 + x630) + x43*(x115*x627 + x117 - x27*x628 + x629) + x51*(-x119*x627 + x121 + x31*x628))), -x180*x619 - x99*(x134*(x123*x631 + x489*x631 + x625*x631 + x637) + x178*x626 + x641 + x70*(x25*(-x282*x631 + x370*x631 + x635) + x43*(x115*x631 - x27*x632 + x633) + x51*(-x119*x631 + x145 + x31*x632))), -x258*x619 - x99*(x134*(x122*x642 + x124*x643 + x125*x652 + x668) + x219*x626 + x671 + x70*(x25*(x651 - x653 + x656) + x43*(-x14*x643 + x17*x642 + x650) + x51*(-x1*x642 + x14*x652 + x661) + x662)), -x358*x619 - x99*(x134*(x122*x643 + x124*x675 + x125*x682 + x38*(x692 + x694) + x697) + x329*x626 + x699 + x70*(x25*(x1*x675 - x17*x682 + x56*x681 + x685) + x43*(-x14*x675 + x17*x643 + x54*x674 + x679) + x51*(-x651 + x686 + x690) + x691)), -x419*x619 - x99*(x134*(x122*x652 + x124*x682 + x125*x701 + x711) + x399*x626 + x70*(x25*(x1*x682 - x17*x701 + x705) + x43*(x653 - x686 + x700) + x51*(-x1*x652 + x14*x701 + x706) + x707) + x712), -x485*x619 - x99*(x443*x626 + x716), -x526*x619 - x99*(x499*x626 + x719), -x559*x619 - x99*(x537*x626 + x722), -x580*x619 + x723, -x598*x619 + x724, -x616*x619 + x725, -x726*x88 - x99*(x134*(x123*x730 + x188 + x489*x730 + x625*x730) + x189 + x70*(x25*(x184 - x282*x730 + x370*x730) + x43*(x115*x730 + x181 - x27*x731) + x51*(-x119*x730 + x187 + x31*x731)) + x732*x78), -x151*x726 - x99*(x134*(x123*x733 + x489*x733 + x625*x733 + x637) + x149*x732 + x641 + x70*(x25*(-x282*x733 + x370*x733 + x635) + x43*(x115*x733 - x27*x734 + x633) + x51*(-x119*x733 + x145 + x31*x734))), -x180*x726 - x99*(x101*x178**2 + x134*(x123*x735 + x132 + 4*x176 + x489*x735 + x625*x735) + x172*x179 + x178*x732 + x70*(x25*(x112 - x282*x735 + x370*x735 + x737) + x43*(x115*x735 + x117 - x27*x736) + x51*(-x119*x735 + x121 + x175 + x31*x736))), -x258*x726 - x99*(x134*(x122*x738 + x124*x739 + x125*x746 + x763) + x219*x732 + x70*(x25*(x745 - x747 + x750) + x43*(-x14*x739 + x17*x738 + x744) + x51*(-x1*x738 + x14*x746 + x756) + x757) + x768), -x358*x726 - x99*(x134*(x122*x739 + x124*x769 + x125*x773 + x786) + x329*x732 + x70*(x25*(x1*x769 - x17*x773 + x778) + x43*(-x14*x769 + x17*x739 + x772) + x51*(-x745 + x779 + x782) + x783) + x788), -x419*x726 - x99*(x134*(x122*x746 + x124*x773 + x125*x793 + x56*(x801 + x803) + x805) + x399*x732 + x70*(x25*(x1*x773 - x17*x793 + x38*x792 + x796) + x43*(x747 - x779 + x789) + x51*(-x1*x746 + x14*x793 + x54*x798 + x799) + x800) + x806), -x485*x726 - x99*(x443*x732 + x810), -x526*x726 - x99*(x499*x732 + x813), -x559*x726 - x99*(x537*x732 + x816), -x580*x726 + x817, -x598*x726 + x818, -x616*x726 + x819, -x821*x88 - x99*(x134*(x123*x824 + 4*x126 + x307 + x489*x824 + x625*x824) + x312 + x70*(x25*(-x282*x824 + x284 + x370*x824) + x293 + x43*(x115*x824 - x27*x825 + x274 + x663) + x51*(-x119*x824 + x292 + x31*x825 + x826)) + x78*x827), -x151*x821 - x99*(x134*(x123*x828 + x489*x828 + x625*x828 + x668) + x149*x827 + x671 + x70*(x25*(-x282*x828 + x370*x828 + x656) + x43*(x115*x828 - x27*x829 + x650) + x51*(-x119*x828 + x31*x829 + x661) + x662)), -x180*x821 - x99*(x134*(x123*x830 + x489*x830 + x625*x830 + x763) + x178*x827 + x70*(x25*(-x282*x830 + x370*x830 + x750) + x43*(x115*x830 - x27*x831 + x744) + x51*(-x119*x830 + x31*x831 + x756) + x757) + x768), -x258*x821 - x99*(x101*x219**2 + x134*(x122*x31*x862 + x122*x856 + x124*x858 + x125*x859 + 4*x15*x855 - 4*x209 - 4*x211 + x301*x857 + x54*(-x294 + x295) + x845*x861 + x853*x854 + x864 + x874) + x201**2*x832 + x201*x834 + x205*x257 + x219*x309*x851 + x219*x827 + x220*x257 + x70*(2*x225*x242 + 2*x229*x248 + 2*x236*x255 + x25*(x891 + x893 - x894 - x895 - x896 + x897 + x902) + x43*(x115*x892 - x14*x858 + x17*x856 - x216 - x27*x857 + x285*x38 + x883*x905 + x904 - x907 + x909 + x914) + x51*(-x1*x856 - x119*x892 + x14*x859 + x218 + x262*x56 + x31*x857 + x888*x915 - x917 - x919 + x920 + x925) + x83*(x195*x883 - x840*x843 + x875*x884 + x886) + x84*(x198*x888 + x840*x846 - x841*x876 + x890) + x85*(x877 - x879 + x881)) + x850*(-x122*x848 + x232*x836 - x840*x842 - x844*x845 + x849)), -x358*x821 - x99*(x134*(x115*x957 + x122*x858 + x124*x932 + x125*x946 + x383*x931 + x696*x936 + x970) + x317*x834 + x329*x827 + x70*(x25*(x1*x932 - x31*x931 - x823*x938 + x937 + x945) + x43*(-x14*x932 + x17*x858 + x28*x931 - x860*x878 + x935) + x51*(-x891 + x895 + x947 - x948 + x955) + x83*(x841*x926 - x843*x878 + x928) + x84*(x879 + x929 - x930) + x85*(x199 + x844*x847 - x846*x926) + x956) + x850*(-x124*x848 - x845*x884 - x926*x971 + x974) + x982), -x419*x821 - x99*(x1025 + x134*(x1005*x823 + x1016 + x119*x957 + x122*x859 + x124*x946 + x432*x989 + 2*x937) + x392*x834 + x399*x827 + x70*(x1004 + x25*(x1*x946 + x27*x989 - x282*x862 - x823*x990 + x998) + x43*(-x893 + x894 - x947 + x948 + x988) + x51*(-x1*x859 + x1000*x876 + x1003 - x28*x989 + x823*x999) + x83*(x334 - x877 + x930) + x84*(-x841*x984 + x846*x876 + x987) + x85*(x843*x984 - x847*x985 + x983)) + x850*(-x1017*x984 - x1018*x122 - x1019*x847 + x1022)), -x485*x821 - x99*(x1094 + x134*(x1027*x1072 + x1058*x123 + x1058*x625 + x1079 + 4*x867) + x443*x827 + x462*x834 + x70*(x1071 + x25*(-x1058*x282 + x1058*x370 + x1065) + x43*(x1058*x115 - x1059*x27 + x1062 + x959) + x51*(x1011 - x1058*x119 + x1059*x31 + x1070) + x83*(x1026 + x1027*x884 - x1028*x875 + x1040) + x84*(-x1018*x435 + x1021 + x1048*x435 + x1057) + x85*(-x1027*x985 + x1028*x847 + x1047)) + x850*(-x1019*x1027 - x1027*x1080 - x1027*x1081 + x1092 - 4*x456)), -x526*x821 - x99*(x1139 + x134*(x1072*x1095 + x1113*x123 + x1113*x625 + x1129) + x499*x827 + x507*x834 + x70*(x1125 + x25*(-x1113*x282 + x1113*x370 + x1121) + x43*(x1113*x115 - x1114*x27 + x1117) + x51*(-x1113*x119 + x1114*x31 + x1124) + x83*(x1095*x884 - x1096*x875 + x1101) + x84*(-x1018*x492 + x1048*x492 + x1112) + x85*(-x1095*x985 + x1096*x847 + x1106)) + x850*(-x1019*x1095 - x1080*x1095 - x1081*x1095 + x1137)), -x559*x821 - x99*(x1176 + x134*(x1072*x1140 + x1150*x123 + x1150*x625 + x1167) + x537*x827 + x542*x834 + x70*(x1162 + x25*(-x1150*x282 + x1150*x370 + x1157) + x43*(x115*x1150 - x1151*x27 + x1154) + x51*(-x1150*x119 + x1151*x31 + x1161) + x83*(x1140*x884 - x1141*x875 + x1143) + x84*(-x1018*x530 + x1048*x530 + x1149) + x85*(-x1140*x985 + x1141*x847 + x1145)) + x850*(-x1019*x1140 - x1080*x1140 - x1081*x1140 + x1174)), -x580*x821 - x99*(x1190 + x578*x834), -x598*x821 - x99*(x1202 + x596*x834), -x616*x821 - x99*(x1214 + x614*x834), -x1216*x88 - x99*(x1221*x78 + x134*(x1219*x123 + x1219*x489 + x1219*x625 + x385) + x388 + x70*(x25*(-x1219*x282 + x1219*x370 + x373) + x379 + x43*(x115*x1219 - x1220*x27 + x365) + x51*(-x119*x1219 + x1220*x31 + x378))), -x1216*x151 - x99*(x1221*x149 + x134*(x1222*x123 + x1222*x489 + x1222*x625 + 4*x128 + x697) + x699 + x70*(x25*(-x1222*x282 + x1222*x370 + x685 + x784) + x43*(x115*x1222 - x1223*x27 + x679 + x960) + x51*(-x119*x1222 + x1223*x31 + x690) + x691)), -x1216*x180 - x99*(x1221*x178 + x134*(x1224*x123 + x1224*x489 + x1224*x625 + x786) + x70*(x25*(-x1224*x282 + x1224*x370 + x778) + x43*(x115*x1224 - x1225*x27 + x772) + x51*(-x119*x1224 + x1225*x31 + x782) + x783) + x788), -x1216*x258 - x99*(x1221*x219 + x1245*x201 + x134*(x1000*x1244 + x1076*x1218 + x1077*x1218 + x122*x1233 + x1234*x301 + x1242*x861 + x970) + x70*(x25*(x1237 + x1238 - x1240 - x1241 + x945) + x43*(x115*x1235 + x1233*x17 - x1234*x27 - x1236*x264 + x935) + x51*(-x1*x1233 - x119*x1235 + x1234*x31 + x1236*x276 + x955) + x83*(-x1228*x843 + x1229*x884 + x928) + x84*(x1228*x846 - x1230*x841 + x929) + x85*(x1231 - x1232 + x199) + x956) + x850*(-x1228*x842 - x1242*x844 - x1244*x846 + x974) + x982), -x1216*x358 - x99*(x101*x329**2 + x1221*x329 + x1245*x317 + x134*(x115*x1257 + x1218*x1252 + x125*x1255 + x1251*x905 + x1253*x383 + x1254*x264 + x1256*x696 + x1258 + 4*x30*x360 - 4*x321 - 4*x323 + x38*(-x692 + x693) + x874) + x317**2*x832 + x319*x357 + x329*x851*x980 + x330*x357 + x70*(x25*(-x1218*x938 + x1218*x939 - x1253*x31 + x1263*x915 + x1269 - x1270 + x1272 + x1273 + x56*x674 - x710 + x902) + 2*x332*x344 + 2*x336*x355 + 2*x340*x350 + x43*(-x1218*x1267 + x1239*x264 + x1253*x28 + x1262*x854 - x1268*x17 + x216 + x54*x681 - x904 + x914 + x964 - x967) + x51*(x1008 - x1015 - x1237 + x1241 + x1264 - x1266 + x925) + x83*(-x1229*x844 + x1248*x841 + x1262*x232 + x886) + x84*(x1232 - x1259 + x890) + x85*(x1243*x844 - x1248*x846 + x1263*x198 + x881)) + x850*(-x1242*x884 - x1243*x1249 + x1247*x195 - x1248*x971 + x849)), -x1216*x419 - x99*(x1221*x399 + x1245*x392 + x1301 + x134*(x1005*x1218 + x119*x1257 + x124*x1255 + x1254*x276 + 2*x1273 + x1278*x432 + x1291) + x70*(x1283 + x25*(-x1218*x990 + x1218*x995 - x1265*x282 + x1278*x27 + x1281) + x43*(-x1238 + x1240 - x1264 + x1266 + x1277) + x51*(x1000*x1230 - x1218*x961 + x1218*x999 - x1278*x28 + x1282) + x83*(x1051 - x1231 + x1259) + x84*(x1230*x846 - x1274*x841 + x227) + x85*(-x1243*x985 + x1274*x843 + x1276)) + x850*(-x1017*x1274 - x1019*x1243 - x122*x1292 + x1295)), -x1216*x485 - x99*(x1221*x443 + x1245*x462 + x1338 + x134*(x1072*x1302 + x123*x1317 + x1302*x1325 + x1330) + x70*(x1324 + x25*(-x1317*x282 + x1317*x370 + x1321) + x43*(x115*x1317 - x1268*x435 + x1320) + x51*(x1000*x1313 - x119*x1317 + x1323) + x83*(-x1028*x1229 + x1302*x884 + x1306) + x84*(-x1292*x435 + x1313*x846 + x1316) + x85*(x1028*x1243 - x1302*x985 + x1312)) + x850*(-x1028*x1331 - x1080*x1302 - x1081*x1302 + x1336)), -x1216*x526 - x99*(x1221*x499 + x1245*x507 + x134*(x1072*x1339 + x123*x1352 + x1325*x1339 + x1360 + 4*x869) + x1366 + x70*(x1359 + x25*(x1285 - x1352*x282 + x1352*x370 + x1356) + x43*(x115*x1352 - x1268*x492 + x1355 + x965) + x51*(x1000*x1350 - x119*x1352 + x1358) + x83*(-x1096*x1229 + x1339*x884 + x1342 + x972) + x84*(-x1292*x492 + x1350*x846 + x1351) + x85*(x1096*x1243 - x1339*x985 + x1343 + x1349)) + x850*(-x1080*x1339 - x1081*x1339 - x1096*x1331 + x1365 - 4*x458)), -x1216*x559 - x99*(x1221*x537 + x1245*x542 + x134*(x1072*x1367 + x123*x1375 + x1325*x1367 + x1383) + x1390 + x70*(x1381 + x25*(-x1375*x282 + x1375*x370 + x1378) + x43*(x115*x1375 - x1268*x530 + x1377) + x51*(x1000*x1372 - x119*x1375 + x1380) + x83*(-x1141*x1229 + x1367*x884 + x1368) + x84*(-x1292*x530 + x1372*x846 + x1374) + x85*(x1141*x1243 - x1367*x985 + x1371)) + x850*(-x1080*x1367 - x1081*x1367 - x1141*x1331 + x1389)), -x1216*x580 - x99*(x1245*x578 + x1395), -x1216*x598 - x99*(x1245*x596 + x1400), -x1216*x616 - x99*(x1245*x614 + x1406), -x1407*x88 - x99*(x134*(x123*x1410 + x1410*x489 + x1410*x625 + x433) + x1412*x78 + x434 + x70*(x25*(-x1410*x282 + x1410*x370 + x425) + x429 + x43*(x115*x1410 - x1411*x27 + x420) + x51*(-x119*x1410 + x1411*x31 + x428))), -x1407*x151 - x99*(x134*(x123*x1413 + x1413*x489 + x1413*x625 + x711) + x1412*x149 + x70*(x25*(-x1413*x282 + x1413*x370 + x705) + x43*(x115*x1413 - x1414*x27 + x700) + x51*(-x119*x1413 + x1414*x31 + x706) + x707) + x712), -x1407*x180 - x99*(x134*(x123*x1415 + 4*x130 + x1415*x489 + x1415*x625 + x805) + x1412*x178 + x70*(x25*(x1286 - x1415*x282 + x1415*x370 + x796) + x43*(x115*x1415 - x1416*x27 + x789) + x51*(-x119*x1415 + x1416*x31 + x430 + x799) + x800) + x806), -x1407*x258 - x99*(x1025 + x134*(x1000*x1435 + x1016 + x1076*x1409 + x1077*x1409 + x122*x1424 + x1425*x301 + x1433*x861) + x1412*x219 + x1436*x201 + x70*(x1004 + x25*(x1428 + x1429 - x1431 - x1432 + x998) + x43*(x115*x1426 + x1424*x17 - x1425*x27 - x1427*x264 + x988) + x51*(-x1*x1424 + x1003 - x119*x1426 + x1425*x31 + x1427*x276) + x83*(-x1419*x843 + x1420*x884 + x334) + x84*(x1419*x846 - x1421*x841 + x987) + x85*(x1422 - x1423 + x983)) + x850*(x1022 - x1419*x842 - x1433*x844 - x1435*x846)), -x1407*x358 - x99*(x1301 + x134*(x115*x1447 + x1252*x1409 + x1291 + x1329*x1409 + x1439*x383 + x1441*x696 + x1446*x264) + x1412*x329 + x1436*x317 + x70*(x1283 + x25*(x1281 - x1409*x938 + x1409*x939 - x1439*x31 + x1442) + x43*(-x1267*x1409 + x1277 + x1430*x264 + x1439*x28 - x1440*x17) + x51*(x1282 - x1428 + x1432 + x1443 - x1445) + x83*(x1051 - x1420*x844 + x1437*x841) + x84*(x1423 - x1438 + x227) + x85*(x1276 + x1434*x844 - x1437*x846)) + x850*(-x1249*x1434 + x1295 - x1433*x884 - x1437*x971)), -x1407*x419 - x99*(x101*x399**2 + x1299*x399*x851 + x134*(x1005*x1409 + x119*x1447 + x1258 + x132 + x1409*x1455 + 2*x1442 + x1446*x276 + x1453*x915 + x1454*x432 + 4*x32*x423 - 4*x395 - 4*x397 + x56*(-x801 + x802) + x864 + x865 + x873) + x1412*x399 + x1436*x392 + x392**2*x832 + x393*x418 + x400*x418 + x70*(x25*(-x1269 + x1287 - x1290 - x1409*x990 + x1409*x995 - x1444*x282 + x1454*x27 + x1459*x905 + x38*x798 + x710 + x902) + 2*x401*x409 + 2*x403*x412 + 2*x407*x416 + x43*(-x1429 + x1431 - x1443 + x1445 + x914 + x962 - x969) + x51*(x1000*x1421 + x1010 - x1013 - x1409*x961 + x1409*x999 - x1454*x28 + x1457*x854 - x218 + x54*x792 + x917 + x925) + x83*(-x1422 + x1438 + x886) + x84*(x1421*x846 - x1450*x841 + x1457*x232 + x890) + x85*(-x1434*x985 + x1450*x843 + x1459*x195 + x881)) + x850*(-x1017*x1450 - x1019*x1434 - x122*x1451 + x1449*x198 + x849)), -x1407*x485 - x99*(x134*(x1072*x1460 + x123*x1470 + x1325*x1460 + x1476) + x1412*x443 + x1436*x462 + x1488 + x70*(x1474 + x25*(-x1470*x282 + x1470*x370 + x1472) + x43*(x115*x1470 - x1440*x435 + x1471) + x51*(x1000*x1466 - x119*x1470 + x1473) + x83*(-x1028*x1420 + x1460*x884 + x1461) + x84*(-x1451*x435 + x1466*x846 + x1469) + x85*(x1028*x1434 - x1460*x985 + x1465)) + x850*(-x1028*x1477 - x1080*x1460 - x1081*x1460 + x1482)), -x1407*x526 - x99*(x134*(x1072*x1489 + x123*x1496 + x1325*x1489 + x1504) + x1412*x499 + x1436*x507 + x1509 + x70*(x1501 + x25*(-x1496*x282 + x1496*x370 + x1499) + x43*(x115*x1496 - x1440*x492 + x1497) + x51*(x1000*x1494 - x119*x1496 + x1500) + x83*(-x1096*x1420 + x1489*x884 + x1490) + x84*(-x1451*x492 + x1494*x846 + x1495) + x85*(x1096*x1434 - x1489*x985 + x1493)) + x850*(-x1080*x1489 - x1081*x1489 - x1096*x1477 + x1507)), -x1407*x559 - x99*(x134*(x1072*x1510 + x123*x1517 + x1325*x1510 + x1523 + 4*x871) + x1412*x537 + x1436*x542 + x1527 + x70*(x1522 + x25*(x1288 - x1517*x282 + x1517*x370 + x1520) + x43*(x115*x1517 - x1440*x530 + x1518) + x51*(x1000*x1514 + x1007 - x119*x1517 + x1521) + x83*(-x1141*x1420 + x1510*x884 + x1511) + x84*(-x1451*x530 + x1478 + x1514*x846 + x1516) + x85*(x1141*x1434 + x1293 - x1510*x985 + x1513)) + x850*(-x1080*x1510 - x1081*x1510 - x1141*x1477 + x1526 - 4*x460)), -x1407*x580 - x99*(x1436*x578 + x1530), -x1407*x598 - x99*(x1436*x596 + x1532), -x1407*x616 - x99*(x1436*x614 + x1534), -x1535*x88 - x99*(x1536*x78 + x491), -x151*x1535 - x99*(x149*x1536 + x716), -x1535*x180 - x99*(x1536*x178 + x810), -x1535*x258 - x99*(x1094 + x134*(x1000*x1550 + x1079 + x1544*x301 + x1548*x861 + x836*x854) + x1536*x219 + x1551*x201 + x70*(x1071 + x25*(x1065 + x1546 - x1547) + x43*(x1062 + x115*x1545 - x1544*x27 + x888*x905) + x51*(x1070 - x119*x1545 + x1544*x31 + x883*x915) + x83*(x1040 - x1539*x843 + x1540*x884 + x195*x888) + x84*(x1057 + x1539*x846 - x1541*x841 + x198*x883) + x85*(x1047 + x1542 - x1543)) + x850*(x1092 - x1539*x842 - x1548*x844 - x1550*x846 + x232*x853)), -x1535*x358 - x99*(x1338 + x134*(x115*x1560 + x1330 + x1554*x383 + x1556*x696) + x1536*x329 + x1551*x317 + x70*(x1324 + x25*(x1321 - x1554*x31 + x1557) + x43*(x1320 + x1554*x28 - x1555*x17) + x51*(x1323 + x1547 - x1559) + x83*(x1306 - x1540*x844 + x1552*x841) + x84*(x1316 + x1543 - x1553) + x85*(x1312 + x1549*x844 - x1552*x846)) + x850*(-x1249*x1549 + x1336 - x1548*x884 - x1552*x971)), -x1535*x419 - x99*(x134*(x119*x1560 + x1476 + 2*x1557 + x1562*x432) + x1488 + x1536*x399 + x1551*x392 + x70*(x1474 + x25*(x1472 - x1558*x282 + x1562*x27) + x43*(x1471 - x1546 + x1559) + x51*(x1000*x1541 + x1473 - x1562*x28) + x83*(x1461 - x1542 + x1553) + x84*(x1469 + x1541*x846 - x1561*x841) + x85*(x1465 - x1549*x985 + x1561*x843)) + x850*(-x1017*x1561 - x1019*x1549 - x122*x1563 + x1482)), -x1535*x485 - x99*(x101*x443**2 + x134*(x1072*x1565 + 4*x1073 + x123*x1564 + x1325*x1565 + x873) + x1486*x443*x851 + x1536*x443 + x1551*x462 + x444*x484 + x462**2*x832 + x463*x484 + x70*(x25*(-x1564*x282 + x1564*x370 + x901) + x43*(x115*x1564 + x1327 - x1555*x435 + x913) + 2*x464*x472 + 2*x466*x476 + 2*x468*x482 + x51*(x1000*x1592 - x119*x1564 + x1475 + x924) + x83*(-x1028*x1540 + x1033*x1572 - x1134 + x1565*x884 + x1598*x1611 + x1607 + x1609*x1610 - x1612 + x1617 + x1618) + x84*(-x1083*x1578 + x1171 + x1479 - x1563*x435 - x1581*x6 + x1592*x846 + x1619*x1620 + x1623 + x1624 + x1626 + x1631) + x85*(x1028*x1549 + x1309*x1599 - x1565*x985 - x1577*x1597 + x1593 - x1595 + x1604)) + x850*(-x1028*x1583 - x1042*x1580 - x1080*x1565 - x1081*x1565 - x1083*x1573 - 4*x1084 + x1567*(x1566 + x852) + 4*x1568 - 4*x1569*x6 - 4*x1576 - 4*x1579 - 2*x1582 + x1591 - 4*x449)), -x1535*x526 - x99*(x134*(x1072*x1632 + x123*x1654 + x1325*x1632 + x1657) + x1536*x499 + x1551*x507 + x1674 + x70*(x1656 + x25*(x1067 - x1654*x282 + x1654*x370) + x43*(x115*x1654 - x1555*x492 + x1655) + x51*(x1000*x1648 + x1122 - x119*x1654) + x83*(x1042*x1594 - x1096*x1540 - x1573*x7 + x1632*x884 + x1639) + x84*(-x1563*x492 - x1593 + x1647 + x1648*x846 + x1653) + x85*(x1096*x1549 + x1581*x7 - x1594*x1640 - x1632*x985 + x1646)) + x850*(-x1080*x1632 - x1081*x1632 - x1096*x1583 - x1572*x1658 - 2*x1612 - 2*x1659 + x1668)), -x1535*x559 - x99*(x134*(x1072*x1675 + x123*x1694 + x1325*x1675 + x1697) + x1536*x537 + x1551*x542 + x1707 + x70*(x1696 + x25*(x1060 - x1694*x282 + x1694*x370) + x43*(x115*x1694 + x1519 - x1555*x530) + x51*(x1000*x1687 - x119*x1694 + x1695) + x83*(-x1141*x1540 + x1595 - x1647 + x1675*x884 + x1681) + x84*(x10*x1573 - x1563*x530 - x1582 + x1687*x846 + x1693) + x85*(x1141*x1549 - x1572*x1682 + x1659 - x1675*x985 + x1686)) + x850*(-x1080*x1675 - x1081*x1675 - x1141*x1583 - x1580*x1640 - x1581*x1698 - 2*x1624 + x1705)), -x1535*x580 - x99*(x1551*x578 + x1724 + x70*(x1717 + x83*(x1180*x1594 - x1187*x1573 + x1660 + x1711) + x84*(-x1180*x1581 + x1573*x1712 + x1714 + x1716) + x85*(x1187*x1581 - x1594*x1712 + x1713)) + x850*(-x1180*x1718 - x1187*x1580 - 4*x1584 - x1712*x1719 + x1723)), -x1535*x598 - x99*(x1551*x596 + x1736 + x70*(x1732 + x83*(x1192*x1594 - x1199*x1573 + x1727) + x84*(-x1192*x1581 + x1573*x1728 + x1731) + x85*(x1199*x1581 - x1594*x1728 + x1729)) + x850*(-x1192*x1718 - x1199*x1580 - x1719*x1728 + x1735)), -x1535*x616 - x99*(x1551*x614 + x1747 + x70*(x1743 + x83*(x1203*x1594 - x1211*x1573 + x1738) + x84*(-x1203*x1581 + x1573*x1739 + x1742) + x85*(x1211*x1581 - x1594*x1739 + x1740)) + x850*(-x1203*x1718 - x1211*x1580 - x1719*x1739 + x1746)), -x1748*x88 - x99*(x1749*x78 + x529), -x151*x1748 - x99*(x149*x1749 + x719), -x1748*x180 - x99*(x1749*x178 + x813), -x1748*x258 - x99*(x1139 + x134*(x1000*x1763 + x1129 + x1757*x301 + x1761*x861) + x1749*x219 + x1764*x201 + x70*(x1125 + x25*(x1121 + x1759 - x1760) + x43*(x1117 + x115*x1758 - x1757*x27) + x51*(x1124 - x119*x1758 + x1757*x31) + x83*(x1101 - x1752*x843 + x1753*x884) + x84*(x1112 + x1752*x846 - x1754*x841) + x85*(x1106 + x1755 - x1756)) + x850*(x1137 - x1752*x842 - x1761*x844 - x1763*x846)), -x1748*x358 - x99*(x134*(x115*x1773 + x1247*x905 + x1360 + x1767*x383 + x1769*x696) + x1366 + x1749*x329 + x1764*x317 + x70*(x1359 + x25*(x1262*x915 + x1356 - x1767*x31 + x1770) + x43*(x1263*x854 + x1355 - x17*x1768 + x1767*x28) + x51*(x1358 + x1760 - x1772) + x83*(x1263*x232 + x1342 - x1753*x844 + x1765*x841) + x84*(x1351 + x1756 - x1766) + x85*(x1262*x198 + x1349 + x1762*x844 - x1765*x846)) + x850*(-x1249*x1762 + x1251*x195 + x1365 - x1761*x884 - x1765*x971)), -x1748*x419 - x99*(x134*(x119*x1773 + x1504 + 2*x1770 + x1775*x432) + x1509 + x1749*x399 + x1764*x392 + x70*(x1501 + x25*(x1499 - x1771*x282 + x1775*x27) + x43*(x1497 - x1759 + x1772) + x51*(x1000*x1754 + x1500 - x1775*x28) + x83*(x1490 - x1755 + x1766) + x84*(x1495 + x1754*x846 - x1774*x841) + x85*(x1493 - x1762*x985 + x1774*x843)) + x850*(-x1017*x1774 - x1019*x1762 - x122*x1776 + x1507)), -x1748*x485 - x99*(x134*(x1072*x1779 + x123*x1788 + x1325*x1779 + x1657) + x1674 + x1749*x443 + x1764*x462 + x70*(x1656 + x25*(x1067 - x1788*x282 + x1788*x370) + x43*(x115*x1788 + x1655 - x1768*x435) + x51*(x1000*x1787 + x1122 - x119*x1788) + x83*(-x1028*x1753 + x1033*x1778 + x1639 + x1779*x884 - x1781) + x84*(x1653 - x1776*x435 - x1782*x6 + x1786 + x1787*x846) + x85*(x1028*x1762 + x1646 - x1779*x985 + x1783 - x1785)) + x850*(-x1028*x1791 - x1042*x1789 - x1080*x1779 - x1081*x1779 - x1083*x1780 + x1668 - 2*x1790)), -x1748*x526 - x99*(x101*x499**2 + x134*(x1072*x1793 + 4*x1115 + x123*x1792 + x1325*x1793 + x873) + x1671*x499*x851 + x1749*x499 + x1764*x507 + x500*x525 + x507**2*x832 + x508*x525 + x70*(x25*(x1503 - x1792*x282 + x1792*x370 + x901) + x43*(x1127 + x115*x1792 - x1768*x492 + x913) + 2*x509*x516 + x51*(x1000*x1800 - x119*x1792 + x924) + 2*x511*x518 + 2*x513*x523 + x83*(x1042*x1784 - x1096*x1753 + x1131 + x1134 + x1567*x1804 + x1617 + x1662 + x1665 - x1780*x7 + x1793*x884 - x1795*x1802) + x84*(x1631 - 2*x1643 - x1776*x492 - x1783 + x1797*x1802 + x1800*x846 + x1801) + x85*(x1096*x1762 - x1386 + x1604 + x1620*x1807 - x1640*x1784 + x1666*x1795 + x1782*x7 - x1793*x985 + x1806 + x1808)) + x850*(-x1080*x1793 - x1081*x1793 - x1096*x1791 - 4*x1099 + x1591 + x1610*(x1250 + x1794) - 4*x1635 + 4*x1637 - x1658*x1778 - 2*x1781 - x1795*x1796 - 4*x1798 - 2*x1799 - 4*x502)), -x1748*x559 - x99*(x134*(x1072*x1809 + x123*x1819 + x1325*x1809 + x1822) + x1749*x537 + x1764*x542 + x1833 + x70*(x1821 + x25*(-x1819*x282 + x1819*x370 + x1820) + x43*(x115*x1819 + x1163 - x1768*x530) + x51*(x1000*x1816 - x119*x1819 + x1353) + x83*(-x1141*x1753 + x1785 - x1801 + x1809*x884 + x1811) + x84*(x10*x1780 - x1776*x530 - x1790 + x1816*x846 + x1818) + x85*(x1141*x1762 - x1682*x1778 + x1799 - x1809*x985 + x1815)) + x850*(-x1080*x1809 - x1081*x1809 - x1141*x1791 - x1640*x1789 - x1698*x1782 - 2*x1786 + x1828)), -x1748*x580 - x99*(x1764*x578 + x1849 + x70*(x1839 + x83*(x1180*x1784 - x1187*x1780 + x1836) + x84*(-x1180*x1782 + x1712*x1780 + x1838) + x85*(x1187*x1782 - x1712*x1784 + x1837)) + x850*(-x1180*x1840 - x1187*x1789 - x1712*x1841 + x1847)), -x1748*x598 - x99*(x1764*x596 + x1857 + x70*(x1854 + x83*(x1192*x1784 - x1199*x1780 + x1843 + x1850) + x84*(-x1192*x1782 + x1728*x1780 + x1853) + x85*(x1199*x1782 - x1728*x1784 + x1823 + x1852)) + x850*(-x1192*x1840 - x1199*x1789 - 4*x1586 - x1728*x1841 + x1856)), -x1748*x616 - x99*(x1764*x614 + x1865 + x70*(x1862 + x83*(x1203*x1784 - x1211*x1780 + x1858) + x84*(-x1203*x1782 + x1739*x1780 + x1861) + x85*(x1211*x1782 - x1739*x1784 + x1860)) + x850*(-x1203*x1840 - x1211*x1789 - x1739*x1841 + x1864)), -x1866*x88 - x99*(x1867*x78 + x562), -x151*x1866 - x99*(x149*x1867 + x722), -x180*x1866 - x99*(x178*x1867 + x816), -x1866*x258 - x99*(x1176 + x134*(x1000*x1881 + x1167 + x1875*x301 + x1879*x861) + x1867*x219 + x1882*x201 + x70*(x1162 + x25*(x1157 + x1877 - x1878) + x43*(x115*x1876 + x1154 - x1875*x27) + x51*(x1161 - x119*x1876 + x1875*x31) + x83*(x1143 - x1870*x843 + x1871*x884) + x84*(x1149 + x1870*x846 - x1872*x841) + x85*(x1145 + x1873 - x1874)) + x850*(x1174 - x1870*x842 - x1879*x844 - x1881*x846)), -x1866*x358 - x99*(x134*(x115*x1891 + x1383 + x1885*x383 + x1887*x696) + x1390 + x1867*x329 + x1882*x317 + x70*(x1381 + x25*(x1378 - x1885*x31 + x1888) + x43*(x1377 - x17*x1886 + x1885*x28) + x51*(x1380 + x1878 - x1890) + x83*(x1368 - x1871*x844 + x1883*x841) + x84*(x1374 + x1874 - x1884) + x85*(x1371 + x1880*x844 - x1883*x846)) + x850*(-x1249*x1880 + x1389 - x1879*x884 - x1883*x971)), -x1866*x419 - x99*(x134*(x119*x1891 + x1449*x915 + x1523 + 2*x1888 + x1893*x432) + x1527 + x1867*x399 + x1882*x392 + x70*(x1522 + x25*(x1457*x905 + x1520 - x1889*x282 + x1893*x27) + x43*(x1518 - x1877 + x1890) + x51*(x1000*x1872 + x1459*x854 + x1521 - x1893*x28) + x83*(x1511 - x1873 + x1884) + x84*(x1459*x232 + x1516 + x1872*x846 - x1892*x841) + x85*(x1457*x195 + x1513 - x1880*x985 + x1892*x843)) + x850*(-x1017*x1892 - x1019*x1880 - x122*x1894 + x1453*x198 + x1526)), -x1866*x485 - x99*(x134*(x1072*x1897 + x123*x1906 + x1325*x1897 + x1697) + x1707 + x1867*x443 + x1882*x462 + x70*(x1696 + x25*(x1060 - x1906*x282 + x1906*x370) + x43*(x115*x1906 + x1519 - x1886*x435) + x51*(x1000*x1905 - x119*x1906 + x1695) + x83*(-x1028*x1871 + x1033*x1896 + x1681 + x1897*x884 - x1899) + x84*(x1693 - x1894*x435 - x1900*x6 + x1904 + x1905*x846) + x85*(x1028*x1880 + x1686 - x1897*x985 + x1901 - x1903)) + x850*(-x1028*x1909 - x1042*x1907 - x1080*x1897 - x1081*x1897 - x1083*x1898 + x1705 - 2*x1908)), -x1866*x526 - x99*(x134*(x1072*x1910 + x123*x1913 + x1325*x1910 + x1822) + x1833 + x1867*x499 + x1882*x507 + x70*(x1821 + x25*(x1820 - x1913*x282 + x1913*x370) + x43*(x115*x1913 + x1163 - x1886*x492) + x51*(x1000*x1912 - x119*x1913 + x1353) + x83*(x1042*x1902 - x1096*x1871 + x1811 - x1898*x7 + x1910*x884) + x84*(x1818 - x1894*x492 - x1901 + x1911 + x1912*x846) + x85*(x1096*x1880 - x1640*x1902 + x1815 + x1900*x7 - x1910*x985)) + x850*(-x1080*x1910 - x1081*x1910 - x1096*x1909 - x1658*x1896 + x1828 - 2*x1899 - 2*x1914)), -x1866*x559 - x99*(x101*x537**2 + x134*(x1072*x1916 + 4*x1158 + x123*x1915 + x1325*x1916 + x873) + x1830*x537*x851 + x1867*x537 + x1882*x542 + x538*x558 + x542**2*x832 + x543*x558 + x70*(x25*(x1382 - x1915*x282 + x1915*x370 + x901) + x43*(x115*x1915 - x1886*x530 + x913) + x51*(x1000*x1918 + x1165 - x119*x1915 + x924) + 2*x544*x550 + 2*x546*x552 + 2*x548*x556 + x83*(-x1141*x1871 + x1596*x1685 + x1617 - x1802*x1812 + x1903 - x1911 + x1916*x884) + x84*(x10*x1898 - x1171 + x1567*x1921 + x1631 + x1688*x1922 + x1704 - x1894*x530 - x1908 + x1918*x846 + x1919) + x85*(x1141*x1880 + x1384 + x1386 + x1604 + x1610*x1923 - x1682*x1896 - x1683*x1922 + x1824 + x1827 + x1914 - x1916*x985)) + x850*(-x1080*x1916 - x1081*x1916 - x1141*x1909 - 4*x1147 + x1591 + x1620*(x1452 + x1917) - x1640*x1907 - 4*x1689 + 4*x1691 - x1698*x1900 - 4*x1703*x530 - x1796*x1812 - 2*x1904 - 4*x540)), -x1866*x580 - x99*(x1882*x578 + x1941 + x70*(x1932 + x83*(x1180*x1902 - x1187*x1898 + x1926) + x84*(-x1180*x1900 + x1712*x1898 + x1931) + x85*(x1187*x1900 - x1712*x1902 + x1927)) + x850*(-x1180*x1933 - x1187*x1907 - x1712*x1934 + x1938)), -x1866*x598 - x99*(x1882*x596 + x1950 + x70*(x1945 + x83*(x1192*x1902 - x1199*x1898 + x1942) + x84*(-x1192*x1900 + x1728*x1898 + x1944) + x85*(x1199*x1900 - x1728*x1902 + x1943)) + x850*(-x1192*x1933 - x1199*x1907 - x1728*x1934 + x1949)), -x1866*x616 - x99*(x1882*x614 + x1957 + x70*(x1955 + x83*(x1203*x1902 - x1211*x1898 + x1951) + x84*(-x1203*x1900 + x1699 + x1739*x1898 + x1954) + x85*(x1211*x1900 - x1739*x1902 + x1947 + x1952)) + x850*(-x1203*x1933 - x1211*x1907 - 4*x1588 - x1739*x1934 + x1956)), -x1958*x88 + x581, -x151*x1958 + x723, -x180*x1958 + x817, -x1958*x258 - x99*(x1190 + x1959*x201), -x1958*x358 - x99*(x1395 + x1959*x317), -x1958*x419 - x99*(x1530 + x1959*x392), -x1958*x485 - x99*(x1724 + x1959*x462 + x70*(x1717 + x83*(x1033*x1960 + x1610*x1619 + x1711 - x1962) + x84*(x1609*x1620 + x1716 - x1963*x6 + x1967) + x85*(x1713 + x1964 - x1966)) + x850*(-x1042*x1968 - x1083*x1961 + x1567*(-x1566 + x835) + x1723 - 2*x1969)), -x1958*x526 - x99*(x1849 + x1959*x507 + x70*(x1839 + x83*(x1042*x1965 + x1836 - x1961*x7) + x84*(x1838 - x1964 + x1970) + x85*(-x1640*x1965 + x1837 + x1963*x7)) + x850*(-x1658*x1960 + x1847 - 2*x1962 - 2*x1971)), -x1958*x559 - x99*(x1941 + x1959*x542 + x70*(x1932 + x83*(x1926 + x1966 - x1970) + x84*(x10*x1961 + x1931 - x1969) + x85*(-x1682*x1960 + x1927 + x1971)) + x850*(-x1640*x1968 - x1698*x1963 + x1938 - 2*x1967)), -x1958*x580 - x99*(x1959*x578 + x574*x579 + x578**2*x832 + x70*(x83*(x1180*x1965 - x1187*x1961 + x1616 + x1842) + x84*(-x1180*x1963 + x1630 + x1712*x1961 + x1972) + x85*(x1187*x1963 + x1603 - x1712*x1965)) + x850*(-x1180*x1973 - x1187*x1968 + x1590 - x1712*x1974 - 4*x1721)), -x1958*x598 - x99*(x1959*x596 + x1979 + x70*(x83*(x1192*x1965 - x1199*x1961 + x1975) + x84*(-x1192*x1963 + x1728*x1961 + x1851) + x85*(x1199*x1963 + x1715 - x1728*x1965)) + x850*(-x1192*x1973 - x1199*x1968 - x1728*x1974 + x1977)), -x1958*x616 - x99*(x1959*x614 + x1982 + x70*(x83*(x1203*x1965 - x1211*x1961 + x1737) + x84*(-x1203*x1963 + x1739*x1961 + x1980) + x85*(x1211*x1963 + x1709 - x1739*x1965)) + x850*(-x1203*x1973 - x1211*x1968 - x1739*x1974 + x1981)), -x1983*x88 + x599, -x151*x1983 + x724, -x180*x1983 + x818, -x1983*x258 - x99*(x1202 + x1984*x201), -x1983*x358 - x99*(x1400 + x1984*x317), -x1983*x419 - x99*(x1532 + x1984*x392), -x1983*x485 - x99*(x1736 + x1984*x462 + x70*(x1732 + x83*(x1033*x1985 + x1727 - x1987) + x84*(x1731 - x1988*x6 + x1992) + x85*(x1729 + x1989 - x1991)) + x850*(-x1042*x1993 - x1083*x1986 + x1735 - 2*x1994)), -x1983*x526 - x99*(x1857 + x1984*x507 + x70*(x1854 + x83*(x1042*x1990 + x1567*x1807 + x1850 - x1986*x7) + x84*(x1853 - x1989 + x1995) + x85*(x1620*x1804 - x1640*x1990 + x1852 + x1988*x7)) + x850*(x1610*(x1246 - x1794) - x1658*x1985 + x1856 - 2*x1987 - 2*x1996)), -x1983*x559 - x99*(x1950 + x1984*x542 + x70*(x1945 + x83*(x1942 + x1991 - x1995) + x84*(x10*x1986 + x1944 - x1994) + x85*(-x1682*x1985 + x1943 + x1996)) + x850*(-x1640*x1993 - x1698*x1988 + x1949 - 2*x1992)), -x1983*x580 - x99*(x1979 + x1984*x578 + x70*(x83*(x1180*x1990 - x1187*x1986 + x1975) + x84*(-x1180*x1988 + x1712*x1986 + x1851) + x85*(x1187*x1988 - x1712*x1990 + x1715)) + x850*(-x1180*x1997 - x1187*x1993 - x1712*x1998 + x1977)), -x1983*x598 - x99*(x1984*x596 + x592*x597 + x596**2*x832 + x70*(x83*(x1192*x1990 - x1199*x1986 + x1616 + x1976) + x84*(-x1192*x1988 + x1630 + x1728*x1986) + x85*(x1199*x1988 + x1603 - x1728*x1990 + x1946)) + x850*(-x1192*x1997 - x1199*x1993 + x1590 - 4*x1725 - x1728*x1998)), -x1983*x616 - x99*(x1984*x614 + x2002 + x70*(x83*(x1203*x1990 - x1211*x1986 + x1953) + x84*(-x1203*x1988 + x1733 + x1739*x1986) + x85*(x1211*x1988 - x1739*x1990 + x1999)) + x850*(-x1203*x1997 - x1211*x1993 - x1739*x1998 + x2001)), -x2003*x88 + x617, -x151*x2003 + x725, -x180*x2003 + x819, -x2003*x258 - x99*(x1214 + x2004*x201), -x2003*x358 - x99*(x1406 + x2004*x317), -x2003*x419 - x99*(x1534 + x2004*x392), -x2003*x485 - x99*(x1747 + x2004*x462 + x70*(x1743 + x83*(x1033*x2005 + x1738 - x2007) + x84*(x1742 - x2008*x6 + x2012) + x85*(x1740 + x2009 - x2011)) + x850*(-x1042*x2013 - x1083*x2006 + x1746 - 2*x2014)), -x2003*x526 - x99*(x1865 + x2004*x507 + x70*(x1862 + x83*(x1042*x2010 + x1858 - x2006*x7) + x84*(x1861 - x2009 + x2015) + x85*(-x1640*x2010 + x1860 + x2008*x7)) + x850*(-x1658*x2005 + x1864 - 2*x2007 - 2*x2016)), -x2003*x559 - x99*(x1957 + x2004*x542 + x70*(x1955 + x83*(x1951 + x2011 - x2015) + x84*(x10*x2006 + x1567*x1923 + x1954 - x2014) + x85*(x1610*x1921 - x1682*x2005 + x1952 + x2016)) + x850*(x1620*(x1448 - x1917) - x1640*x2013 - x1698*x2008 + x1956 - 2*x2012)), -x2003*x580 - x99*(x1982 + x2004*x578 + x70*(x83*(x1180*x2010 - x1187*x2006 + x1737) + x84*(-x1180*x2008 + x1712*x2006 + x1980) + x85*(x1187*x2008 + x1709 - x1712*x2010)) + x850*(-x1180*x2017 - x1187*x2013 - x1712*x2018 + x1981)), -x2003*x598 - x99*(x2002 + x2004*x596 + x70*(x83*(x1192*x2010 - x1199*x2006 + x1953) + x84*(-x1192*x2008 + x1728*x2006 + x1733) + x85*(x1199*x2008 - x1728*x2010 + x1999)) + x850*(-x1192*x2017 - x1199*x2013 - x1728*x2018 + x2001)), -x2003*x616 - x99*(x2004*x614 + x610*x615 + x614**2*x832 + x70*(x83*(x1203*x2010 - x1211*x2006 + x1616) + x84*(-x1203*x2008 + x1630 + x1739*x2006 + x1745) + x85*(x1211*x2008 + x1603 - x1739*x2010 + x2000)) + x850*(-x1203*x2017 - x1211*x2013 + x1590 - x1739*x2018 - 4*x1741))])


def dq_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend, first derivative wrt. cartesians"""

    x0 = -n2
    x1 = o2 + x0
    x2 = -o1
    x3 = n1 + x2
    x4 = -o0
    x5 = m0 + x4
    x6 = m1 + x2
    x7 = -o2
    x8 = m2 + x7
    x9 = x5**2 + x6**2 + x8**2
    x10 = 1/math.sqrt(x9)
    x11 = n0 + x4
    x12 = n2 + x7
    x13 = x11**2 + x12**2 + x3**2
    x14 = 1/math.sqrt(x13)
    x15 = x10*x14
    x16 = -m0
    x17 = o0 + x16
    x18 = -n1
    x19 = o1 + x18
    x20 = -n0
    x21 = o0 + x20
    x22 = p0*(x12*x6 + x19*x8) + p1*(x1*x5 + x11*x8) + p2*(x21*x6 + x3*x5)
    x23 = x14*x22/x9**(3/2)
    x24 = -m1
    x25 = o1 + x24
    x26 = -m2
    x27 = o2 + x26
    x28 = x10*x22/x13**(3/2)

    return np.array([x15*(p1*x1 + p2*x3) + x17*x23, x15*(p0*x12 + p2*x21) + x23*x25, x15*(p0*x19 + p1*x11) + x23*x27, x11*x28 + x15*(p1*(n2 + x26) + p2*(m1 + x18)) + x23*x5, x15*(p0*(m2 + x0) + p2*(n0 + x16)) + x23*x6 + x28*x3, x12*x28 + x15*(p0*(n1 + x24) + p1*(m0 + x20)) + x23*x8, x15*(p1*x8 + p2*x25) + x21*x28, x15*(p0*x27 + p2*x5) + x19*x28, x1*x28 + x15*(p0*x6 + p1*x17)])


def d2q_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend, 2nd derivative wrt. cartesians"""

    x0 = -n2
    x1 = o2 + x0
    x2 = -o1
    x3 = n1 + x2
    x4 = p1*x1 + p2*x3
    x5 = -m0
    x6 = o0 + x5
    x7 = -o0
    x8 = m0 + x7
    x9 = m1 + x2
    x10 = -o2
    x11 = m2 + x10
    x12 = x11**2 + x8**2 + x9**2
    x13 = x12**(-3/2)
    x14 = n0 + x7
    x15 = n2 + x10
    x16 = x14**2 + x15**2 + x3**2
    x17 = 1/math.sqrt(x16)
    x18 = x13*x17
    x19 = x18*x6
    x20 = x15*x9
    x21 = -n1
    x22 = o1 + x21
    x23 = x11*x22
    x24 = x1*x8
    x25 = x11*x14
    x26 = x3*x8
    x27 = -n0
    x28 = o0 + x27
    x29 = x28*x9
    x30 = p0*(x20 + x23) + p1*(x24 + x25) + p2*(x26 + x29)
    x31 = x18*x30
    x32 = -x31
    x33 = x30*x6
    x34 = 3*m0
    x35 = 3*o0
    x36 = x17/x12**(5/2)
    x37 = x36*(-x34 + x35)
    x38 = -m1
    x39 = o1 + x38
    x40 = x30*x37
    x41 = p0*x15 + p2*x28
    x42 = x18*x4
    x43 = x19*x41 + x39*x42
    x44 = -m2
    x45 = o2 + x44
    x46 = p0*x22 + p1*x14
    x47 = x19*x46 + x42*x45
    x48 = p1*(n2 + x44) + p2*(m1 + x21)
    x49 = 1/math.sqrt(x12)
    x50 = x16**(-3/2)
    x51 = x49*x50
    x52 = x4*x51
    x53 = x13*x50
    x54 = x33*x53
    x55 = x14*x52 + x14*x54 + x19*x48 + x31 + x42*x8
    x56 = x17*x49
    x57 = p2*x56
    x58 = -x57
    x59 = p0*(m2 + x0) + p2*(n0 + x5)
    x60 = x19*x59 + x3*x52 + x3*x54 + x42*x9 + x58
    x61 = p1*x56
    x62 = p0*(n1 + x38) + p1*(m0 + x27)
    x63 = x11*x42 + x15*x52 + x15*x54 + x19*x62 + x61
    x64 = p1*x11 + p2*x39
    x65 = x19*x64 + x28*x52 + x28*x54
    x66 = p0*x45 + p2*x8
    x67 = x19*x66 + x22*x52 + x22*x54 + x57
    x68 = -x61
    x69 = p0*x9 + p1*x6
    x70 = x1*x52 + x1*x54 + x19*x69 + x68
    x71 = 3*m1
    x72 = 3*o1
    x73 = x36*(-x71 + x72)
    x74 = x18*x39
    x75 = x30*x73
    x76 = x18*x41
    x77 = x45*x76 + x46*x74
    x78 = x41*x51
    x79 = x30*x39
    x80 = x53*x79
    x81 = x14*x78 + x14*x80 + x48*x74 + x57 + x76*x8
    x82 = x3*x78 + x3*x80 + x31 + x59*x74 + x76*x9
    x83 = p0*x56
    x84 = -x83
    x85 = x11*x76 + x15*x78 + x15*x80 + x62*x74 + x84
    x86 = x28*x78 + x28*x80 + x58 + x64*x74
    x87 = x22*x78 + x22*x80 + x66*x74
    x88 = x1*x78 + x1*x80 + x69*x74 + x83
    x89 = 3*m2
    x90 = 3*o2
    x91 = x36*(-x89 + x90)
    x92 = x18*x46
    x93 = x30*x91
    x94 = x18*x45
    x95 = x46*x51
    x96 = x30*x45
    x97 = x53*x96
    x98 = x14*x95 + x14*x97 + x48*x94 + x68 + x8*x92
    x99 = x3*x95 + x3*x97 + x59*x94 + x83 + x9*x92
    x100 = x11*x92 + x15*x95 + x15*x97 + x31 + x62*x94
    x101 = x28*x95 + x28*x97 + x61 + x64*x94
    x102 = x22*x95 + x22*x97 + x66*x94 + x84
    x103 = x1*x95 + x1*x97 + x69*x94
    x104 = -x35
    x105 = x36*(x104 + x34)
    x106 = x18*x8
    x107 = 2*x48
    x108 = x14*x51
    x109 = x105*x30
    x110 = x14*x30
    x111 = 3*n0
    x112 = x49/x16**(5/2)
    x113 = x112*(x104 + x111)
    x114 = x110*x53
    x115 = x30*x51
    x116 = -x115
    x117 = x116 + x32
    x118 = x113*x30
    x119 = x18*x48
    x120 = x48*x51
    x121 = x30*x53
    x122 = x106*x59 + x108*x59 + x114*x9 + x119*x9 + x120*x3 + x121*x26
    x123 = x121*x8
    x124 = x106*x62 + x108*x62 + x11*x119 + x120*x15 + x121*x25 + x123*x15
    x125 = x106*x64 + x108*x64 + x115 + x120*x28 + x123*x28
    x126 = x106*x66 + x108*x66 + x120*x22 + x123*x22 + x58
    x127 = x1*x120 + x106*x69 + x108*x69 + x121*x24 + x61
    x128 = -x72
    x129 = x36*(x128 + x71)
    x130 = x129*x30
    x131 = 3*n1
    x132 = x112*(x128 + x131)
    x133 = x18*x9
    x134 = 2*x59
    x135 = x3*x51
    x136 = x132*x30
    x137 = x121*x9
    x138 = x11*x18
    x139 = x51*x59
    x140 = x11*x121
    x141 = x121*x20 + x133*x62 + x135*x62 + x138*x59 + x139*x15 + x140*x3
    x142 = x121*x29 + x133*x64 + x135*x64 + x139*x28 + x57
    x143 = x115 + x133*x66 + x135*x66 + x137*x22 + x139*x22
    x144 = x1*x137 + x1*x139 + x133*x69 + x135*x69 + x84
    x145 = -x90
    x146 = x36*(x145 + x89)
    x147 = x146*x30
    x148 = 3*n2
    x149 = x112*(x145 + x148)
    x150 = x149*x30
    x151 = 2*x62
    x152 = x15*x51
    x153 = x51*x62
    x154 = x138*x64 + x140*x28 + x152*x64 + x153*x28 + x68
    x155 = x121*x23 + x138*x66 + x152*x66 + x153*x22 + x83
    x156 = x1*x140 + x1*x153 + x115 + x138*x69 + x152*x69
    x157 = x112*(-x111 + x35)
    x158 = x157*x30
    x159 = x28*x51
    x160 = x51*x64
    x161 = x159*x66 + x160*x22
    x162 = x1*x160 + x159*x69
    x163 = x112*(-x131 + x72)
    x164 = x163*x30
    x165 = x22*x51
    x166 = x1*x51
    x167 = x165*x69 + x166*x66
    x168 = x112*(-x148 + x90)
    x169 = x168*x30

    return np.array([2*x19*x4 + x32 + x33*x37, x39*x40 + x43, x40*x45 + x47, x40*x8 + x55, x40*x9 + x60, x11*x40 + x63, x65, x67, x70, x33*x73 + x43, x32 + x39*x75 + 2*x41*x74, x45*x75 + x77, x75*x8 + x81, x75*x9 + x82, x11*x75 + x85, x86, x87, x88, x33*x91 + x47, x77 + x79*x91, x32 + 2*x45*x92 + x45*x93, x8*x93 + x98, x9*x93 + x99, x100 + x11*x93, x101, x102, x103, x105*x33 + x55, x105*x79 + x81, x105*x96 + x98, x106*x107 + x107*x108 + x109*x8 + x110*x113 + 2*x114*x8 + x117, x109*x9 + x118*x3 + x122, x109*x11 + x118*x15 + x124, x118*x28 + x125, x118*x22 + x126, x1*x118 + x127, x129*x33 + x60, x129*x79 + x82, x129*x96 + x99, x110*x132 + x122 + x130*x8, x117 + x130*x9 + x133*x134 + x134*x135 + x136*x3 + 2*x137*x3, x11*x130 + x136*x15 + x141, x136*x28 + x142, x136*x22 + x143, x1*x136 + x144, x146*x33 + x63, x146*x79 + x85, x100 + x146*x96, x110*x149 + x124 + x147*x8, x141 + x147*x9 + x150*x3, x11*x147 + x117 + x138*x151 + 2*x140*x15 + x15*x150 + x151*x152, x150*x28 + x154, x150*x22 + x155, x1*x150 + x156, x65, x86, x101, x110*x157 + x125, x142 + x158*x3, x15*x158 + x154, x116 + x158*x28 + 2*x159*x64, x158*x22 + x161, x1*x158 + x162, x67, x87, x102, x110*x163 + x126, x143 + x164*x3, x15*x164 + x155, x161 + x164*x28, x116 + x164*x22 + 2*x165*x66, x1*x164 + x167, x70, x88, x103, x110*x168 + x127, x144 + x169*x3, x15*x169 + x156, x162 + x169*x28, x167 + x169*x22, x1*x169 + x116 + 2*x166*x69])


